/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.lang.javascript.service.JSNodeServiceMemoryOptionsKt;
import com.intellij.lang.javascript.service.TypeScriptServiceOutOfMemoryDetector;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.lsp.BaseLspTypeScriptServiceCompletionSupport;
import com.intellij.lang.typescript.lsp.JSFrameworkLsp4jServer;
import com.intellij.lang.typescript.lsp.JSFrameworkLspServerDescriptor;
import com.intellij.lang.typescript.lsp.JSFrameworkLspServerDescriptorKt;
import com.intellij.lang.typescript.lsp.JSNodeLspServerDescriptor;
import com.intellij.lang.typescript.lsp.LspServerActivationRule;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.lsp.api.customization.LspCustomization;
import com.intellij.platform.lsp.api.customization.LspDiagnosticsDisabled;
import com.intellij.platform.lsp.api.customization.LspDocumentColorDisabled;
import com.intellij.platform.lsp.api.customization.LspDocumentHighlightsCustomizer;
import com.intellij.platform.lsp.api.customization.LspDocumentHighlightsDisabled;
import com.intellij.platform.lsp.api.customization.LspDocumentLinkDisabled;
import com.intellij.platform.lsp.api.customization.LspDocumentSymbolCustomizer;
import com.intellij.platform.lsp.api.customization.LspDocumentSymbolDisabled;
import com.intellij.platform.lsp.api.customization.LspFindReferencesDisabled;
import com.intellij.platform.lsp.api.customization.LspFoldingRangeDisabled;
import com.intellij.platform.lsp.api.customization.LspFormattingDisabled;
import com.intellij.platform.lsp.api.customization.LspGoToDefinitionDisabled;
import com.intellij.platform.lsp.api.customization.LspGoToTypeDefinitionDisabled;
import com.intellij.platform.lsp.api.customization.LspHoverDisabled;
import com.intellij.platform.lsp.api.customization.LspInlayHintCustomizer;
import com.intellij.platform.lsp.api.customization.LspInlayHintDisabled;
import com.intellij.platform.lsp.api.customization.LspSemanticTokensDisabled;
import com.intellij.platform.lsp.api.customization.LspSignatureHelpCustomizer;
import com.intellij.platform.lsp.api.customization.LspSignatureHelpDisabled;
import com.intellij.platform.lsp.api.customization.LspWorkspaceSymbolCustomizer;
import com.intellij.platform.lsp.api.customization.LspWorkspaceSymbolDisabled;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u0007H\u0014J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0007H\u0014R \u0010\n\u001a\u000e\u0012\n\b\u0001\u0012\u00060\fj\u0002`\r0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/intellij/lang/typescript/lsp/JSFrameworkLspServerDescriptor;", "Lcom/intellij/lang/typescript/lsp/JSNodeLspServerDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "activationRule", "Lcom/intellij/lang/typescript/lsp/LspServerActivationRule;", "presentableName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/typescript/lsp/LspServerActivationRule;Ljava/lang/String;)V", "lsp4jServerClass", "Ljava/lang/Class;", "Lorg/eclipse/lsp4j/services/LanguageServer;", "Lcom/intellij/platform/lsp/api/Lsp4jServer;", "getLsp4jServerClass", "()Ljava/lang/Class;", "lspCustomization", "Lcom/intellij/platform/lsp/api/customization/LspCustomization;", "getLspCustomization", "()Lcom/intellij/platform/lsp/api/customization/LspCustomization;", "oomDetector", "Lcom/intellij/lang/javascript/service/TypeScriptServiceOutOfMemoryDetector;", "getOomDetector", "()Lcom/intellij/lang/javascript/service/TypeScriptServiceOutOfMemoryDetector;", "startServerProcess", "Lcom/intellij/execution/process/OSProcessHandler;", "addNodeOptions", "", "commandLineBuilder", "Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "getCommandLineArgsFromRegistry", "createInitializationOptions", "", "createInitializationOptionsWithTS", "targetPath", "intellij.javascript.backend"})
@ApiStatus.Experimental
public abstract class JSFrameworkLspServerDescriptor
extends JSNodeLspServerDescriptor {
    @NotNull
    private final Class<? extends LanguageServer> lsp4jServerClass;
    @NotNull
    private final LspCustomization lspCustomization;
    @NotNull
    private final TypeScriptServiceOutOfMemoryDetector oomDetector;

    public JSFrameworkLspServerDescriptor(@NotNull Project project, @NotNull LspServerActivationRule activationRule, @NotNull String presentableName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)activationRule, (String)"activationRule");
        Intrinsics.checkNotNullParameter((Object)presentableName, (String)"presentableName");
        super(project, activationRule, presentableName);
        this.lsp4jServerClass = JSFrameworkLsp4jServer.class;
        this.lspCustomization = new LspCustomization(){
            private final LspSemanticTokensDisabled semanticTokensCustomizer;
            private final LspGoToDefinitionDisabled goToDefinitionCustomizer;
            private final LspGoToTypeDefinitionDisabled goToTypeDefinitionCustomizer;
            private final LspDocumentLinkDisabled documentLinkCustomizer;
            private final LspHoverDisabled hoverCustomizer;
            private final BaseLspTypeScriptServiceCompletionSupport completionCustomizer;
            private final LspDiagnosticsDisabled diagnosticsCustomizer;
            private final LspFormattingDisabled formattingCustomizer;
            private final LspFindReferencesDisabled findReferencesCustomizer;
            private final LspDocumentColorDisabled documentColorCustomizer;
            private final LspFoldingRangeDisabled foldingRangeCustomizer;
            private final LspInlayHintCustomizer inlayHintCustomizer;
            private final LspWorkspaceSymbolCustomizer workspaceSymbolCustomizer;
            private final LspDocumentSymbolCustomizer documentSymbolCustomizer;
            private final LspDocumentHighlightsCustomizer documentHighlightsCustomizer;
            private final LspSignatureHelpCustomizer signatureHelpCustomizer;
            {
                this.semanticTokensCustomizer = LspSemanticTokensDisabled.INSTANCE;
                this.goToDefinitionCustomizer = LspGoToDefinitionDisabled.INSTANCE;
                this.goToTypeDefinitionCustomizer = LspGoToTypeDefinitionDisabled.INSTANCE;
                this.documentLinkCustomizer = LspDocumentLinkDisabled.INSTANCE;
                this.hoverCustomizer = LspHoverDisabled.INSTANCE;
                this.completionCustomizer = new BaseLspTypeScriptServiceCompletionSupport();
                this.diagnosticsCustomizer = LspDiagnosticsDisabled.INSTANCE;
                this.formattingCustomizer = LspFormattingDisabled.INSTANCE;
                this.findReferencesCustomizer = LspFindReferencesDisabled.INSTANCE;
                this.documentColorCustomizer = LspDocumentColorDisabled.INSTANCE;
                this.foldingRangeCustomizer = LspFoldingRangeDisabled.INSTANCE;
                this.inlayHintCustomizer = (LspInlayHintCustomizer)LspInlayHintDisabled.INSTANCE;
                this.workspaceSymbolCustomizer = (LspWorkspaceSymbolCustomizer)LspWorkspaceSymbolDisabled.INSTANCE;
                this.documentSymbolCustomizer = (LspDocumentSymbolCustomizer)LspDocumentSymbolDisabled.INSTANCE;
                this.documentHighlightsCustomizer = (LspDocumentHighlightsCustomizer)LspDocumentHighlightsDisabled.INSTANCE;
                this.signatureHelpCustomizer = (LspSignatureHelpCustomizer)LspSignatureHelpDisabled.INSTANCE;
            }

            public LspSemanticTokensDisabled getSemanticTokensCustomizer() {
                return this.semanticTokensCustomizer;
            }

            public LspGoToDefinitionDisabled getGoToDefinitionCustomizer() {
                return this.goToDefinitionCustomizer;
            }

            public LspGoToTypeDefinitionDisabled getGoToTypeDefinitionCustomizer() {
                return this.goToTypeDefinitionCustomizer;
            }

            public LspDocumentLinkDisabled getDocumentLinkCustomizer() {
                return this.documentLinkCustomizer;
            }

            public LspHoverDisabled getHoverCustomizer() {
                return this.hoverCustomizer;
            }

            public BaseLspTypeScriptServiceCompletionSupport getCompletionCustomizer() {
                return this.completionCustomizer;
            }

            public LspDiagnosticsDisabled getDiagnosticsCustomizer() {
                return this.diagnosticsCustomizer;
            }

            public LspFormattingDisabled getFormattingCustomizer() {
                return this.formattingCustomizer;
            }

            public LspFindReferencesDisabled getFindReferencesCustomizer() {
                return this.findReferencesCustomizer;
            }

            public LspDocumentColorDisabled getDocumentColorCustomizer() {
                return this.documentColorCustomizer;
            }

            public LspFoldingRangeDisabled getFoldingRangeCustomizer() {
                return this.foldingRangeCustomizer;
            }

            public LspInlayHintCustomizer getInlayHintCustomizer() {
                return this.inlayHintCustomizer;
            }

            public LspWorkspaceSymbolCustomizer getWorkspaceSymbolCustomizer() {
                return this.workspaceSymbolCustomizer;
            }

            public LspDocumentSymbolCustomizer getDocumentSymbolCustomizer() {
                return this.documentSymbolCustomizer;
            }

            public LspDocumentHighlightsCustomizer getDocumentHighlightsCustomizer() {
                return this.documentHighlightsCustomizer;
            }

            public LspSignatureHelpCustomizer getSignatureHelpCustomizer() {
                return this.signatureHelpCustomizer;
            }
        };
        this.oomDetector = new TypeScriptServiceOutOfMemoryDetector(project, presentableName, ((Object)((Object)this)).getClass(), TypeScriptCompilerSettings.Companion.getSettings(project).getMemoryLimit());
    }

    @NotNull
    public Class<? extends LanguageServer> getLsp4jServerClass() {
        return this.lsp4jServerClass;
    }

    @NotNull
    public LspCustomization getLspCustomization() {
        return this.lspCustomization;
    }

    @NotNull
    public final TypeScriptServiceOutOfMemoryDetector getOomDetector() {
        return this.oomDetector;
    }

    @Override
    @NotNull
    public OSProcessHandler startServerProcess() {
        OSProcessHandler processHandler = super.startServerProcess();
        processHandler.addProcessListener(this.oomDetector.getProcessListener());
        return processHandler;
    }

    @Override
    protected void addNodeOptions(@NotNull TargetedCommandLineBuilder commandLineBuilder) {
        Intrinsics.checkNotNullParameter((Object)commandLineBuilder, (String)"commandLineBuilder");
        JSNodeServiceMemoryOptionsKt.addNodeMemoryLimitFlag(commandLineBuilder, this.getPresentableName(), TypeScriptCompilerSettings.Companion.getSettings(this.getProject()).getMemoryLimit());
        super.addNodeOptions(commandLineBuilder);
    }

    @Override
    @NotNull
    protected String getCommandLineArgsFromRegistry() {
        return JSNodeServiceMemoryOptionsKt.sanitizeNodeMemoryRegistryOptions("typescript.service.lsp.node.arguments", Registry.Companion.stringValue("typescript.service.lsp.node.arguments"));
    }

    @NotNull
    public Object createInitializationOptions() {
        String tsPath = (String)ActionsKt.runReadAction(() -> JSFrameworkLspServerDescriptor.createInitializationOptions$lambda$0(this));
        String targetPath = this.convertLocalPathToTargetPath(tsPath);
        return this.createInitializationOptionsWithTS(targetPath);
    }

    @NotNull
    protected Object createInitializationOptionsWithTS(@NotNull String targetPath) {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        return new Object(targetPath){
            private final createInitializationOptionsWithTS.typescript.1 typescript;
            {
                this.typescript = new Object($targetPath){
                    private final String tsdk;
                    {
                        this.tsdk = $targetPath;
                    }

                    public final String getTsdk() {
                        return this.tsdk;
                    }
                };
            }

            public final createInitializationOptionsWithTS.typescript.1 getTypescript() {
                return this.typescript;
            }
        };
    }

    private static final String createInitializationOptions$lambda$0(JSFrameworkLspServerDescriptor this$0) {
        return JSFrameworkLspServerDescriptorKt.getTypeScriptServiceDirectory(this$0.getProject());
    }
}

