/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.common.HttpClient;
import org.jetbrains.kotlinx.jupyter.common.LibraryDescriptorsManager;
import org.jetbrains.kotlinx.jupyter.libraries.AbstractLibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.libraries.DefaultInfoLibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.DefaultInfoSwitch;
import org.jetbrains.kotlinx.jupyter.libraries.FallbackLibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryInfoCache;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionInfoProvider;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionInfoSwitcher;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"getStandardResolver", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;", "infoProvider", "Lorg/jetbrains/kotlinx/jupyter/libraries/ResolutionInfoProvider;", "httpClient", "Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;", "libraryDescriptorsManager", "Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;", "getDefaultResolutionInfoSwitcher", "Lorg/jetbrains/kotlinx/jupyter/libraries/ResolutionInfoSwitcher;", "Lorg/jetbrains/kotlinx/jupyter/libraries/DefaultInfoSwitch;", "provider", "libraryInfoCache", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryInfoCache;", "defaultDir", "Ljava/io/File;", "defaultRef", "", "shared-compiler"})
public final class ResolutionUtilKt {
    @NotNull
    public static final LibraryResolver getStandardResolver(@NotNull ResolutionInfoProvider infoProvider, @NotNull HttpClient httpClient, @NotNull LibraryDescriptorsManager libraryDescriptorsManager) {
        Intrinsics.checkNotNullParameter((Object)infoProvider, (String)"infoProvider");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)libraryDescriptorsManager, (String)"libraryDescriptorsManager");
        LibraryResolver res = new FallbackLibraryResolver(httpClient, libraryDescriptorsManager);
        res = new DefaultInfoLibraryResolver(res, infoProvider, libraryDescriptorsManager, CollectionsKt.listOf((Object)libraryDescriptorsManager.getUserLibrariesDir()));
        return res;
    }

    @NotNull
    public static final ResolutionInfoSwitcher<DefaultInfoSwitch> getDefaultResolutionInfoSwitcher(@NotNull ResolutionInfoProvider provider, @NotNull LibraryInfoCache libraryInfoCache, @NotNull File defaultDir, @NotNull String defaultRef) {
        AbstractLibraryResolutionInfo.ByGitRef byGitRef;
        AbstractLibraryResolutionInfo.ByDir dirInfo;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)libraryInfoCache, (String)"libraryInfoCache");
        Intrinsics.checkNotNullParameter((Object)defaultDir, (String)"defaultDir");
        Intrinsics.checkNotNullParameter((Object)defaultRef, (String)"defaultRef");
        LibraryResolutionInfo initialInfo = provider.getFallback();
        AbstractLibraryResolutionInfo.ByDir byDir = initialInfo instanceof AbstractLibraryResolutionInfo.ByDir ? (AbstractLibraryResolutionInfo.ByDir)initialInfo : null;
        if (byDir == null) {
            byDir = dirInfo = new AbstractLibraryResolutionInfo.ByDir(defaultDir);
        }
        if ((byGitRef = initialInfo instanceof AbstractLibraryResolutionInfo.ByGitRef ? (AbstractLibraryResolutionInfo.ByGitRef)initialInfo : null) == null) {
            byGitRef = libraryInfoCache.getLibraryInfoByRefWithFallback(defaultRef);
        }
        AbstractLibraryResolutionInfo.ByGitRef refInfo = byGitRef;
        AbstractLibraryResolutionInfo.ByClasspath classpathInfo = AbstractLibraryResolutionInfo.ByClasspath.INSTANCE;
        return new ResolutionInfoSwitcher<DefaultInfoSwitch>(provider, DefaultInfoSwitch.DIRECTORY, arg_0 -> ResolutionUtilKt.getDefaultResolutionInfoSwitcher$lambda$0(dirInfo, refInfo, classpathInfo, arg_0));
    }

    private static final LibraryResolutionInfo getDefaultResolutionInfoSwitcher$lambda$0(AbstractLibraryResolutionInfo.ByDir $dirInfo, AbstractLibraryResolutionInfo.ByGitRef $refInfo, AbstractLibraryResolutionInfo.ByClasspath $classpathInfo, DefaultInfoSwitch defaultInfoSwitch) {
        LibraryResolutionInfo libraryResolutionInfo;
        Intrinsics.checkNotNullParameter((Object)((Object)defaultInfoSwitch), (String)"switch");
        switch (WhenMappings.$EnumSwitchMapping$0[defaultInfoSwitch.ordinal()]) {
            case 1: {
                libraryResolutionInfo = $dirInfo;
                break;
            }
            case 2: {
                libraryResolutionInfo = $refInfo;
                break;
            }
            case 3: {
                libraryResolutionInfo = $classpathInfo;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return libraryResolutionInfo;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DefaultInfoSwitch.values().length];
            try {
                nArray[DefaultInfoSwitch.DIRECTORY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DefaultInfoSwitch.GIT_REFERENCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DefaultInfoSwitch.CLASSPATH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

