/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.google.gson.GsonBuilder;
import com.intellij.build.SyncViewManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.task.RunConfigurationTaskState;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Task;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.TestLauncher;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.CompositeBuildData;
import org.jetbrains.plugins.gradle.service.GradleFileModificationTracker;
import org.jetbrains.plugins.gradle.service.execution.GradleCommandLineUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionContext;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionContextImpl;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleWrapperHelper;
import org.jetbrains.plugins.gradle.service.project.GradleTasksIndices;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.service.task.VersionSpecificInitScript;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleTaskData;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLine;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineTask;

public class GradleTaskManager
implements ExternalSystemTaskManager<GradleExecutionSettings> {
    public static final Key<String> INIT_SCRIPT_KEY = Key.create((String)"INIT_SCRIPT_KEY");
    public static final Key<String> INIT_SCRIPT_PREFIX_KEY = Key.create((String)"INIT_SCRIPT_PREFIX_KEY");
    public static final Key<Collection<VersionSpecificInitScript>> VERSION_SPECIFIC_SCRIPTS_KEY = Key.create((String)"VERSION_SPECIFIC_SCRIPTS_KEY");
    private static final Logger LOG = Logger.getInstance(GradleTaskManager.class);
    private final Map<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap = new ConcurrentHashMap<ExternalSystemTaskId, CancellationTokenSource>();

    @Deprecated
    public void executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> taskNames, @NotNull String projectPath, @Nullable GradleExecutionSettings settings, @Nullable String jvmParametersSetup, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException {
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(0);
        }
        if (taskNames == null) {
            GradleTaskManager.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(2);
        }
        if (listener2 == null) {
            GradleTaskManager.$$$reportNull$$$0(3);
        }
        super.executeTasks(id, taskNames, projectPath, (ExternalSystemExecutionSettings)settings, jvmParametersSetup, listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTasks(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException {
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(4);
        }
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            GradleTaskManager.$$$reportNull$$$0(6);
        }
        if (listener2 == null) {
            GradleTaskManager.$$$reportNull$$$0(7);
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : GradleTaskManagerExtension.EP_NAME.getExtensionList()) {
                if (!gradleTaskManagerExtension.executeTasks(projectPath, id, settings, listener2)) continue;
                return;
            }
        }
        CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
        CancellationToken cancellationToken = cancellationTokenSource.token();
        this.myCancellationMap.put(id, cancellationTokenSource);
        try {
            GradleExecutionContextImpl context = new GradleExecutionContextImpl(projectPath, id, settings, listener2, cancellationToken);
            if (settings.getDistributionType() == DistributionType.WRAPPED) {
                GradleWrapperHelper.ensureInstalledWrapper(context);
            }
            GradleExecutionHelper.execute(context, connection -> {
                GradleTaskManager.prepareSettingsForExecution(settings, context);
                GradleTaskManager.executeTasks(connection, context);
                return null;
            });
        }
        finally {
            this.myCancellationMap.remove(id);
        }
    }

    private static void prepareSettingsForExecution(@NotNull GradleExecutionSettings settings, @NotNull GradleExecutionContext context) {
        if (settings == null) {
            GradleTaskManager.$$$reportNull$$$0(8);
        }
        if (context == null) {
            GradleTaskManager.$$$reportNull$$$0(9);
        }
        GradleTaskManager.setupGradleScriptDebugging(settings);
        GradleTaskManager.setupDebuggerDispatchPort(settings);
        GradleTaskManager.setupBuiltInTestEvents(settings, context);
        GradleTaskManager.configureTasks(settings, context);
        for (GradleBuildParticipant buildParticipant : context.getSettings().getExecutionWorkspace().getBuildParticipants()) {
            settings.withArguments(new String[]{"--include-build", buildParticipant.getProjectPath()});
        }
        GradleTaskManager.prepareTaskState(settings, context);
    }

    private static void executeTasks(@NotNull ProjectConnection connection, @NotNull GradleExecutionContext context) {
        if (connection == null) {
            GradleTaskManager.$$$reportNull$$$0(10);
        }
        if (context == null) {
            GradleTaskManager.$$$reportNull$$$0(11);
        }
        if (Registry.is((String)"gradle.report.recently.saved.paths")) {
            ((GradleFileModificationTracker)ApplicationManager.getApplication().getService(GradleFileModificationTracker.class)).notifyConnectionAboutChangedPaths(connection);
        }
        if (GradleTaskManager.isApplicableTestLauncher(context)) {
            TestLauncher operation = connection.newTestLauncher();
            GradleExecutionHelper.prepareForExecution((LongRunningOperation)operation, context);
            operation.run();
        } else {
            BuildLauncher operation = connection.newBuild();
            GradleExecutionHelper.prepareForExecution((LongRunningOperation)operation, context);
            operation.run();
        }
    }

    private static boolean isApplicableTestLauncher(@NotNull GradleExecutionContext context) {
        if (context == null) {
            GradleTaskManager.$$$reportNull$$$0(12);
        }
        if (!Registry.is((String)"gradle.testLauncherAPI.enabled")) {
            LOG.debug("TestLauncher isn't applicable: disabled by registry");
            return false;
        }
        GradleExecutionSettings settings = context.getSettings();
        if (ExternalSystemExecutionAware.hasTargetEnvironmentConfiguration((ExternalSystemExecutionSettings)settings)) {
            LOG.debug("TestLauncher isn't applicable: unsupported execution with remote target");
            return false;
        }
        if (!settings.isTestTaskRerun()) {
            LOG.debug("TestLauncher isn't applicable: RC doesn't expect task rerun");
            return false;
        }
        GradleVersion gradleVersion = context.getGradleVersion();
        if (GradleVersionUtil.isGradleOlderThan((GradleVersion)gradleVersion, (String)"8.3")) {
            LOG.debug("TestLauncher isn't applicable: unsupported Gradle version: " + String.valueOf(gradleVersion));
            return false;
        }
        Project project = context.getProject();
        String projectPath = context.getProjectPath();
        if (GradleVersionUtil.isGradleOlderThan((GradleVersion)gradleVersion, (String)"8.4") && GradleTaskManager.hasProjectIncludedBuild(project, projectPath)) {
            LOG.debug("TestLauncher isn't applicable: Project has included build. " + String.valueOf(gradleVersion));
            return false;
        }
        GradleCommandLine commandLine = settings.getCommandLine();
        if (!GradleTaskManager.hasJvmTestTasks(commandLine, project, projectPath)) {
            LOG.debug("TestLauncher isn't applicable: RC hasn't JVM test tasks");
            return false;
        }
        if (GradleTaskManager.hasNonJvmTestTasks(commandLine, project, projectPath)) {
            LOG.debug("TestLauncher isn't applicable: RC has non-JVM test tasks");
            return false;
        }
        if (GradleTaskManager.hasNonTestOptions(commandLine)) {
            LOG.debug("TestLauncher isn't applicable: RC tasks have non-test options");
            return false;
        }
        if (GradleTaskManager.hasUnrecognizedOptions(commandLine)) {
            LOG.debug("TestLauncher isn't applicable: RC has unrecognized options");
            return false;
        }
        LOG.debug("TestLauncher is applicable");
        return true;
    }

    private static boolean hasJvmTestTasks(@NotNull GradleCommandLine commandLine, @NotNull Project project, @NotNull String projectPath) {
        if (commandLine == null) {
            GradleTaskManager.$$$reportNull$$$0(13);
        }
        if (project == null) {
            GradleTaskManager.$$$reportNull$$$0(14);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(15);
        }
        GradleTasksIndices indices = GradleTasksIndices.getInstance(project);
        for (GradleCommandLineTask task : commandLine.getTasks()) {
            List<GradleTaskData> taskData = indices.findTasks(projectPath, task.getName());
            if (!ContainerUtil.exists(taskData, it -> it.isJvmTest())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNonJvmTestTasks(@NotNull GradleCommandLine commandLine, @NotNull Project project, @NotNull String projectPath) {
        if (commandLine == null) {
            GradleTaskManager.$$$reportNull$$$0(16);
        }
        if (project == null) {
            GradleTaskManager.$$$reportNull$$$0(17);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(18);
        }
        GradleTasksIndices indices = GradleTasksIndices.getInstance(project);
        for (GradleCommandLineTask task : commandLine.getTasks()) {
            List<GradleTaskData> taskData = indices.findTasks(projectPath, task.getName());
            if (!ContainerUtil.exists(taskData, it -> it.isTest() && !it.isJvmTest())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasProjectIncludedBuild(@NotNull Project project, @NotNull String projectPath) {
        DataNode projectNode;
        if (project == null) {
            GradleTaskManager.$$$reportNull$$$0(19);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(20);
        }
        if ((projectNode = ExternalSystemApiUtil.findProjectNode((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectPath)) == null) {
            return false;
        }
        DataNode compositeBuildNode = ExternalSystemApiUtil.find((DataNode)projectNode, CompositeBuildData.KEY);
        if (compositeBuildNode == null) {
            return false;
        }
        List<BuildParticipant> compositeBuildParticipants = ((CompositeBuildData)compositeBuildNode.getData()).getCompositeParticipants();
        return !compositeBuildParticipants.isEmpty();
    }

    private static boolean hasNonTestOptions(@NotNull GradleCommandLine commandLine) {
        if (commandLine == null) {
            GradleTaskManager.$$$reportNull$$$0(21);
        }
        for (GradleCommandLineTask task : commandLine.getTasks()) {
            if (!ContainerUtil.exists((Iterable)task.getOptions(), it -> !GradleCommandLineUtil.isTestPattern(it))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasUnrecognizedOptions(@NotNull GradleCommandLine commandLine) {
        if (commandLine == null) {
            GradleTaskManager.$$$reportNull$$$0(22);
        }
        for (GradleCommandLineTask task : commandLine.getTasks()) {
            if (!task.getName().startsWith("-")) continue;
            return true;
        }
        return false;
    }

    private static void prepareTaskState(@NotNull GradleExecutionSettings settings, @NotNull GradleExecutionContext context) {
        if (settings == null) {
            GradleTaskManager.$$$reportNull$$$0(23);
        }
        if (context == null) {
            GradleTaskManager.$$$reportNull$$$0(24);
        }
        if (ExternalSystemExecutionAware.hasTargetEnvironmentConfiguration((ExternalSystemExecutionSettings)settings)) {
            return;
        }
        RunConfigurationTaskState taskState = (RunConfigurationTaskState)settings.getUserData(RunConfigurationTaskState.getKEY());
        if (taskState == null) {
            return;
        }
        LocalTargetEnvironmentRequest request = new LocalTargetEnvironmentRequest();
        TargetProgressIndicator progressIndicator = TargetProgressIndicator.EMPTY;
        try {
            taskState.prepareTargetEnvironmentRequest((TargetEnvironmentRequest)request, progressIndicator);
            LocalTargetEnvironment environment = request.prepareEnvironment(progressIndicator);
            String taskStateInitScript = taskState.handleCreatedTargetEnvironment((TargetEnvironment)environment, progressIndicator);
            if (taskStateInitScript != null) {
                Path initScriptPath = GradleInitScriptUtil.createInitScript("ijtgttaskstate", taskStateInitScript);
                settings.prependArguments(new String[]{"--init-script", initScriptPath.toString()});
            }
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        context.getListener().onEnvironmentPrepared(context.getTaskId());
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException {
        CancellationTokenSource cancellationTokenSource;
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(25);
        }
        if (listener2 == null) {
            GradleTaskManager.$$$reportNull$$$0(26);
        }
        if ((cancellationTokenSource = this.myCancellationMap.get(id)) != null) {
            cancellationTokenSource.cancel();
            return true;
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.cancelTask(id, listener2)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static void appendInitScriptArgument(@NotNull List<String> taskNames, @Nullable String jvmParametersSetup, @NotNull GradleExecutionSettings settings) {
        if (taskNames == null) {
            GradleTaskManager.$$$reportNull$$$0(27);
        }
        if (settings == null) {
            GradleTaskManager.$$$reportNull$$$0(28);
        }
        ExternalSystemTaskId id = ExternalSystemTaskId.create((ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (String)"");
        settings.setTasks(taskNames);
        settings.setJvmParameters(jvmParametersSetup);
        GradleTaskManager.configureTasks("", id, settings, null);
    }

    @ApiStatus.Internal
    public static void configureTasks(@NotNull GradleExecutionSettings settings, @NotNull GradleExecutionContext context) {
        if (settings == null) {
            GradleTaskManager.$$$reportNull$$$0(29);
        }
        if (context == null) {
            GradleTaskManager.$$$reportNull$$$0(30);
        }
        GradleTaskManager.configureTasks(context.getProjectPath(), context.getTaskId(), settings, context.getGradleVersion());
    }

    @ApiStatus.Internal
    public static void configureTasks(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @Nullable GradleVersion gradleVersion) {
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(31);
        }
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(32);
        }
        if (settings == null) {
            GradleTaskManager.$$$reportNull$$$0(33);
        }
        GradleTaskManagerExtension.EP_NAME.forEachExtensionSafe(it -> it.configureTasks(projectPath, id, settings, gradleVersion));
        String initScript = (String)settings.getUserData(INIT_SCRIPT_KEY);
        if (StringUtil.isNotEmpty((String)initScript)) {
            String initScriptPrefix = StringUtil.notNullize((String)((String)settings.getUserData(INIT_SCRIPT_PREFIX_KEY)), (String)"ijmiscinit");
            Path initScriptPath = GradleInitScriptUtil.createInitScript(initScriptPrefix, initScript);
            settings.withArguments(new String[]{"--init-script", initScriptPath.toString()});
        }
        Collection scripts = (Collection)settings.getUserData(VERSION_SPECIFIC_SCRIPTS_KEY);
        if (gradleVersion != null && scripts != null) {
            for (VersionSpecificInitScript script : scripts) {
                if (!script.isApplicableTo(gradleVersion) || !StringUtil.isNotEmpty((String)script.getScript())) continue;
                String initScriptPrefix = StringUtil.notNullize((String)script.getFilePrefix(), (String)"ijverspecinit");
                Path initScriptPath = GradleInitScriptUtil.createInitScript(initScriptPrefix, script.getScript());
                settings.withArguments(new String[]{"--init-script", initScriptPath.toString()});
            }
        }
        if (settings.getArguments().contains("--init-script")) {
            Path targetPathMapperInitScript = GradleInitScriptUtil.createTargetPathMapperInitScript();
            settings.prependArguments(new String[]{"--init-script", targetPathMapperInitScript.toString()});
        }
    }

    public static void setupGradleScriptDebugging(@NotNull GradleExecutionSettings effectiveSettings) {
        if (effectiveSettings == null) {
            GradleTaskManager.$$$reportNull$$$0(34);
        }
        Integer gradleScriptDebugPort = (Integer)effectiveSettings.getUserData(ExternalSystemRunnableState.BUILD_PROCESS_DEBUGGER_PORT_KEY);
        if (effectiveSettings.isDebugServerProcess() && gradleScriptDebugPort != null && gradleScriptDebugPort > 0) {
            boolean isJdk9orLater;
            String dispatchAddr = (String)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_ADDR_KEY);
            String debugAddress = dispatchAddr != null ? dispatchAddr + ":" + gradleScriptDebugPort : ((isJdk9orLater = ExternalSystemJdkUtil.isJdk9orLater((String)effectiveSettings.getJavaHome())) ? "127.0.0.1:" : "") + gradleScriptDebugPort;
            String jvmOpt = "-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=" + debugAddress;
            effectiveSettings.withVmOption(jvmOpt);
        }
        if (effectiveSettings.isDebugAllEnabled()) {
            effectiveSettings.withArgument("-Didea.gradle.debug.all=true");
        }
    }

    public static void setupDebuggerDispatchPort(@NotNull GradleExecutionSettings effectiveSettings) {
        String dispatchAddr;
        Integer dispatchPort;
        if (effectiveSettings == null) {
            GradleTaskManager.$$$reportNull$$$0(35);
        }
        if ((dispatchPort = (Integer)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_PORT_KEY)) != null) {
            effectiveSettings.withArgument(String.format("-D%s=%d", "idea.debugger.dispatch.port", dispatchPort));
        }
        if ((dispatchAddr = (String)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_ADDR_KEY)) != null) {
            effectiveSettings.withArgument(String.format("-D%s=%s", "idea.debugger.dispatch.addr", dispatchAddr));
        }
    }

    private static void setupBuiltInTestEvents(@NotNull GradleExecutionSettings settings, @NotNull GradleExecutionContext context) {
        if (settings == null) {
            GradleTaskManager.$$$reportNull$$$0(36);
        }
        if (context == null) {
            GradleTaskManager.$$$reportNull$$$0(37);
        }
        if (GradleVersionUtil.isGradleAtLeast((GradleVersion)context.getGradleVersion(), (String)"7.6")) {
            settings.setBuiltInTestEventsUsed(true);
        }
    }

    @Deprecated
    public static void runCustomTaskScript(@NotNull Project project, @NotNull @Nls String executionName, @NotNull String projectPath, @NotNull String gradlePath2, @NotNull ProgressExecutionMode progressExecutionMode, @Nullable TaskCallback callback, @NotNull String initScript, @NotNull String taskName) {
        if (project == null) {
            GradleTaskManager.$$$reportNull$$$0(38);
        }
        if (executionName == null) {
            GradleTaskManager.$$$reportNull$$$0(39);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(40);
        }
        if (gradlePath2 == null) {
            GradleTaskManager.$$$reportNull$$$0(41);
        }
        if (progressExecutionMode == null) {
            GradleTaskManager.$$$reportNull$$$0(42);
        }
        if (initScript == null) {
            GradleTaskManager.$$$reportNull$$$0(43);
        }
        if (taskName == null) {
            GradleTaskManager.$$$reportNull$$$0(44);
        }
        UserDataHolderBase userData = new UserDataHolderBase();
        userData.putUserData(INIT_SCRIPT_KEY, (Object)initScript);
        userData.putUserData(ExternalSystemRunConfiguration.PROGRESS_LISTENER_KEY, SyncViewManager.class);
        String gradleVmOptions = GradleSettings.getInstance(project).getGradleVmOptions();
        ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
        settings.setExecutionName(executionName);
        settings.setExternalProjectPath(projectPath);
        Object taskPrefix = gradlePath2.endsWith(":") ? gradlePath2 : gradlePath2 + ":";
        settings.setTaskNames(Collections.singletonList((String)taskPrefix + taskName));
        settings.setVmOptions(gradleVmOptions);
        settings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
        ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings, (String)"Run", (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)callback, (ProgressExecutionMode)progressExecutionMode, (boolean)false, (UserDataHolderBase)userData);
    }

    @Deprecated
    public static void runCustomTask(@NotNull Project project, @NotNull @Nls String executionName, @NotNull Class<? extends Task> taskClass, @NotNull String projectPath, @NotNull String gradlePath2, @Nullable String taskConfiguration, @NotNull ProgressExecutionMode progressExecutionMode, @Nullable TaskCallback callback, @NotNull Set<Class<?>> toolingExtensionClasses) {
        if (project == null) {
            GradleTaskManager.$$$reportNull$$$0(45);
        }
        if (executionName == null) {
            GradleTaskManager.$$$reportNull$$$0(46);
        }
        if (taskClass == null) {
            GradleTaskManager.$$$reportNull$$$0(47);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(48);
        }
        if (gradlePath2 == null) {
            GradleTaskManager.$$$reportNull$$$0(49);
        }
        if (progressExecutionMode == null) {
            GradleTaskManager.$$$reportNull$$$0(50);
        }
        if (toolingExtensionClasses == null) {
            GradleTaskManager.$$$reportNull$$$0(51);
        }
        String taskName = taskClass.getSimpleName();
        String taskType = taskClass.getName();
        HashSet tools = new HashSet(toolingExtensionClasses);
        tools.add(taskClass);
        tools.add(GsonBuilder.class);
        String initScript = GradleInitScriptUtil.loadTaskInitScript(gradlePath2, taskName, taskType, tools, taskConfiguration);
        GradleTaskManager.runCustomTaskScript(project, executionName, projectPath, gradlePath2, progressExecutionMode, callback, initScript, taskName);
    }

    @Deprecated
    public static void runCustomTask(@NotNull Project project, @NotNull @Nls String executionName, @NotNull Class<? extends Task> taskClass, @NotNull String projectPath, @NotNull String gradlePath2, @Nullable String taskConfiguration, @NotNull ProgressExecutionMode progressExecutionMode, @Nullable TaskCallback callback) {
        if (project == null) {
            GradleTaskManager.$$$reportNull$$$0(52);
        }
        if (executionName == null) {
            GradleTaskManager.$$$reportNull$$$0(53);
        }
        if (taskClass == null) {
            GradleTaskManager.$$$reportNull$$$0(54);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(55);
        }
        if (gradlePath2 == null) {
            GradleTaskManager.$$$reportNull$$$0(56);
        }
        if (progressExecutionMode == null) {
            GradleTaskManager.$$$reportNull$$$0(57);
        }
        GradleTaskManager.runCustomTask(project, executionName, taskClass, projectPath, gradlePath2, taskConfiguration, progressExecutionMode, callback, new HashSet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 2: 
            case 4: 
            case 15: 
            case 18: 
            case 20: 
            case 31: 
            case 40: 
            case 48: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: 
            case 7: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 8: 
            case 23: 
            case 28: 
            case 29: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 24: 
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 13: 
            case 16: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 38: 
            case 45: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectiveSettings";
                break;
            }
            case 39: 
            case 46: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionName";
                break;
            }
            case 41: 
            case 49: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 42: 
            case 50: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressExecutionMode";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScript";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 47: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskClass";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolingExtensionClasses";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/service/task/GradleTaskManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTasks";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareSettingsForExecution";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableTestLauncher";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "hasJvmTestTasks";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNonJvmTestTasks";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "hasProjectIncludedBuild";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNonTestOptions";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "hasUnrecognizedOptions";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareTaskState";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelTask";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "appendInitScriptArgument";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "configureTasks";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "setupGradleScriptDebugging";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "setupDebuggerDispatchPort";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "setupBuiltInTestEvents";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "runCustomTaskScript";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[2] = "runCustomTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

