/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.RunManager;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.jam.JavaJamBundle;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.javaee.JavaeeIcons;
import com.intellij.jpa.ConsoleTarget;
import com.intellij.jpa.JpaConsoleUtils;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.engine.JpaConsole;
import com.intellij.jpa.engine.JpaConsoleBase;
import com.intellij.jpa.engine.QlScriptModel;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetType;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.view.editor.PersistencePackageAsVirtualFileImpl;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.uast.UastMetaLanguage;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;

public class JpaConsoleProvider
extends PersistenceConsoleProvider {
    public static boolean canOpenConsoleInSeparatedProcess(PersistencePackage unit) {
        return unit.getModelHelper().getAdditionalMapping() == null;
    }

    public boolean hasRunners(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JpaConsoleProvider.$$$reportNull$$$0(0);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT.getData(dataContext);
        return project != null && facet != null && unit != null && unit.isValid() && JpaConsoleProvider.canOpenConsoleInSeparatedProcess(unit) && facet.getQlLanguage() != null && this.isAvailable(facet.getModule());
    }

    public boolean hasRunners(@NotNull PsiElement element, @Nullable Editor editor) {
        PsiFile file;
        if (element == null) {
            JpaConsoleProvider.$$$reportNull$$$0(1);
        }
        if (!JpaConsoleProvider.isSuitableFileType(element, file = element.getContainingFile())) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null && file.getVirtualFile() instanceof LightVirtualFile) {
            module = (Module)file.getUserData(ModuleUtilCore.KEY_MODULE);
        }
        if (module == null || !this.isAvailable(module)) {
            return false;
        }
        return JpaConsoleProvider.findQlFile(file, element) != null;
    }

    private static boolean isSuitableFileType(@NotNull PsiElement element, PsiFile file) {
        if (element == null) {
            JpaConsoleProvider.$$$reportNull$$$0(2);
        }
        return file instanceof QlFile || ((UastMetaLanguage)Language.findInstance(UastMetaLanguage.class)).matchesLanguage(element.getLanguage()) || JamCommonUtil.isPlainXmlFile((PsiElement)file);
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull DataContext dataContext) {
        boolean enable;
        if (dataContext == null) {
            JpaConsoleProvider.$$$reportNull$$$0(3);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT.getData(dataContext);
        boolean bl = enable = project != null && facet instanceof JpaFacet && unit != null && unit.isValid() && JpaConsoleProvider.canOpenConsoleInSeparatedProcess(unit) && facet.getQlLanguage() != null && this.isAvailable(facet.getModule());
        if (!enable) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                JpaConsoleProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        PersistencePackagePointer unitFile = PersistencePackageAsVirtualFileImpl.findFile(unit, facet);
        if (unitFile == null) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                JpaConsoleProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        result.add(this.createRunner(project, unitFile));
        JpaConsoleProvider.addDefaultRunners(result, project, unitFile, null);
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
        if (arrayList == null) {
            JpaConsoleProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull PsiElement element, Editor editor) {
        if (element == null) {
            JpaConsoleProvider.$$$reportNull$$$0(7);
        }
        List list = (List)ReadAction.nonBlocking(() -> this.getRunnersInner(element)).withDocumentsCommitted(element.getProject()).inSmartMode(element.getProject()).executeSynchronously();
        if (list == null) {
            JpaConsoleProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    private List<PersistenceConsoleProvider.Runner> getRunnersInner(@NotNull PsiElement element) {
        QlScriptModel model;
        if (element == null) {
            JpaConsoleProvider.$$$reportNull$$$0(9);
        }
        if (!element.isValid()) {
            return Collections.emptyList();
        }
        PsiFile file = element.getContainingFile();
        if (!JpaConsoleProvider.isSuitableFileType(element, file)) {
            return Collections.emptyList();
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null && file.getVirtualFile() instanceof LightVirtualFile) {
            module = (Module)file.getUserData(ModuleUtilCore.KEY_MODULE);
        }
        if (module == null || !this.isAvailable(module)) {
            return Collections.emptyList();
        }
        ArrayList<PersistencePackagePointer> unitFiles = new ArrayList<PersistencePackagePointer>();
        for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module)) {
            if (facet.getQlLanguage() == null) continue;
            for (PersistencePackage unit : facet.getPersistenceUnits()) {
                if (!JpaConsoleProvider.canOpenConsoleInSeparatedProcess(unit)) continue;
                ContainerUtil.addIfNotNull(unitFiles, (Object)PersistencePackageAsVirtualFileImpl.findFile(unit, facet));
            }
        }
        if (unitFiles.isEmpty()) {
            return Collections.emptyList();
        }
        QlFile qlFile = JpaConsoleProvider.findQlFile(file, element);
        QlScriptModel qlScriptModel = model = qlFile == null ? null : JpaConsoleProvider.createScriptModel(file, qlFile);
        if (model == null || model.statements().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        result.add(this.createQueryRunner(module, unitFiles, model));
        for (PersistencePackagePointer unit : unitFiles) {
            JpaConsoleProvider.addDefaultRunners(result, module.getProject(), unit, model);
        }
        return result;
    }

    protected static void addDefaultRunners(Collection<? super PersistenceConsoleProvider.Runner> result, Project project, PersistencePackagePointer unit, QlScriptModel model) {
        for (JpaConsoleBase jpaConsoleBase : JpaConsole.getActiveConsoles(project)) {
            if (!((PersistencePackagePointer)jpaConsoleBase.getTarget()).equals((Object)unit)) continue;
            result.add(new MyConsoleRunner(jpaConsoleBase, model));
        }
    }

    public static QlScriptModel createScriptModel(@NotNull PsiFile file, @NotNull QlFile qlFile) {
        Project project;
        InjectedLanguageManager manager;
        if (file == null) {
            JpaConsoleProvider.$$$reportNull$$$0(10);
        }
        if (qlFile == null) {
            JpaConsoleProvider.$$$reportNull$$$0(11);
        }
        if ((manager = InjectedLanguageManager.getInstance((Project)(project = file.getProject()))).isInjectedFragment((PsiFile)qlFile)) {
            String fileText = manager.getUnescapedText((PsiElement)qlFile);
            PsiFile file2 = PsiFileFactory.getInstance((Project)project).createFileFromText("a.ql", qlFile.getLanguage(), (CharSequence)fileText);
            QlFile qlFile2 = (QlFile)file2;
            return new QlScriptModel((PsiFile)qlFile2);
        }
        return new QlScriptModel((PsiFile)qlFile);
    }

    @Nullable
    public static QlFile findQlFile(PsiFile file, PsiElement element) {
        PsiLanguageInjectionHost injectionHost;
        if (file instanceof QlFile) {
            return (QlFile)file;
        }
        UInjectionHost uInjectionHost = (UInjectionHost)UastUtils.findContaining((PsiElement)element, UInjectionHost.class);
        PsiLanguageInjectionHost psiLanguageInjectionHost = injectionHost = uInjectionHost == null ? null : uInjectionHost.getPsiLanguageInjectionHost();
        if (injectionHost == null) {
            return null;
        }
        Pair elementToRange = (Pair)ContainerUtil.getFirstItem((List)InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectedPsiFiles((PsiElement)uInjectionHost.getPsiLanguageInjectionHost()));
        PsiElement maybeQlFile = elementToRange == null ? null : (PsiElement)elementToRange.getFirst();
        return maybeQlFile instanceof QlFile ? (QlFile)maybeQlFile : null;
    }

    protected boolean isAvailable(Module module) {
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)"javax.persistence.EntityManager");
    }

    @NotNull
    protected MyRunner createRunner(Project project, PersistencePackagePointer unitFile) {
        return new MyRunner(project, unitFile);
    }

    protected MyQueryRunner createQueryRunner(Module module, List<PersistencePackagePointer> unitFiles, QlScriptModel model) {
        return new MyQueryRunner(module.getProject(), unitFiles, model);
    }

    @NotNull
    private static List<RunConfiguration> getJavaRunConfigurations(@NotNull Project project) {
        if (project == null) {
            JpaConsoleProvider.$$$reportNull$$$0(12);
        }
        ArrayList<RunConfiguration> list = new ArrayList<RunConfiguration>();
        for (RunConfiguration o : RunManager.getInstance((Project)project).getAllConfigurationsList()) {
            String vmParameters = o instanceof ApplicationConfiguration ? ((CommonJavaRunConfigurationParameters)o).getVMParameters() : null;
            if (!StringUtil.isNotEmpty((String)vmParameters)) continue;
            list.add(o);
        }
        ArrayList<RunConfiguration> arrayList = list;
        if (arrayList == null) {
            JpaConsoleProvider.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    private static List<PersistenceConsoleProvider.Runner> getCfgSubRunners(@NotNull Project project, @Nullable String selectedName, @NotNull Consumer<? super ConsoleRunConfiguration> consumer) {
        List<RunConfiguration> runConfigurations;
        if (project == null) {
            JpaConsoleProvider.$$$reportNull$$$0(14);
        }
        if (consumer == null) {
            JpaConsoleProvider.$$$reportNull$$$0(15);
        }
        if ((runConfigurations = JpaConsoleProvider.getJavaRunConfigurations(project)).isEmpty()) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                JpaConsoleProvider.$$$reportNull$$$0(16);
            }
            return list;
        }
        ConsoleRunConfiguration noArgs = ConsoleRunConfiguration.newConfiguration((Project)project);
        noArgs.setName("<empty>");
        RunConfiguration selected = (RunConfiguration)ObjectUtils.notNull((Object)((RunConfiguration)ContainerUtil.find(runConfigurations, cfg -> cfg.getName().equals(selectedName))), (Object)noArgs);
        runConfigurations.add(0, (RunConfiguration)noArgs);
        List list = ContainerUtil.map(runConfigurations, cfg -> JpaConsoleProvider.newRunner(project, cfg, cfg == selected, consumer));
        if (list == null) {
            JpaConsoleProvider.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner newRunner(final @NotNull Project project, final @NotNull RunConfiguration profile, final boolean isDefault, final @NotNull Consumer<? super ConsoleRunConfiguration> consumer) {
        if (project == null) {
            JpaConsoleProvider.$$$reportNull$$$0(18);
        }
        if (profile == null) {
            JpaConsoleProvider.$$$reportNull$$$0(19);
        }
        if (consumer == null) {
            JpaConsoleProvider.$$$reportNull$$$0(20);
        }
        return new PersistenceConsoleProvider.Runner(){

            public String getDisplayName() {
                return profile.getName() + (this.isDefaultSubRunner() ? " *" : "");
            }

            public Icon getIcon() {
                return profile.getIcon();
            }

            public boolean isDefaultSubRunner() {
                return isDefault;
            }

            public void run() {
                ConsoleRunConfiguration result = ConsoleRunConfiguration.newConfiguration((Project)project);
                if (profile instanceof CommonJavaRunConfigurationParameters) {
                    CommonJavaRunConfigurationParameters javaParams = (CommonJavaRunConfigurationParameters)profile;
                    result.VM_PARAMETERS = javaParams.getVMParameters();
                    result.VM_ENV = new LinkedHashMap(javaParams.getEnvs());
                    result.setName(profile.getName());
                }
                consumer.consume((Object)result);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 13, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/JpaConsoleProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qlFile";
                break;
            }
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/JpaConsoleProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunners";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaRunConfigurations";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCfgSubRunners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasRunners";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableFileType";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRunners";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 16: 
            case 17: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRunnersInner";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createScriptModel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getJavaRunConfigurations";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCfgSubRunners";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "newRunner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8, 13, 16, 17 -> new IllegalStateException(string);
        };
    }

    public static class MyRunner
    extends PersistenceConsoleProvider.Runner {
        private final Project myProject;
        private final PersistencePackagePointer myUnitFile;

        public MyRunner(Project project, PersistencePackagePointer unitFile) {
            this.myProject = project;
            this.myUnitFile = unitFile;
        }

        public Project getProject() {
            return this.myProject;
        }

        public String getDisplayName() {
            return JpaMessages.message("jpa.console.provider.name", new Object[0]);
        }

        public Icon getIcon() {
            return JavaeeIcons.JPA_ICON;
        }

        public void run() {
            this.runInner(this.createRunConfiguration());
        }

        @NotNull
        protected ConsoleRunConfiguration createRunConfiguration() {
            ConsoleRunConfiguration configuration = ConsoleRunConfiguration.newConfiguration((Project)this.myProject);
            if (this.isJava9()) {
                String parameters = configuration.VM_PARAMETERS;
                configuration.VM_PARAMETERS = (StringUtil.isEmptyOrSpaces((String)parameters) ? "" : parameters) + " --add-modules java.xml.bind";
            }
            ConsoleRunConfiguration consoleRunConfiguration = configuration;
            if (consoleRunConfiguration == null) {
                MyRunner.$$$reportNull$$$0(0);
            }
            return consoleRunConfiguration;
        }

        protected final boolean isJava9() {
            Sdk jdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
            return jdk != null && jdk.getSdkType() instanceof JavaSdkType && JavaSdk.getInstance().isOfVersionOrHigher(jdk, JavaSdkVersion.JDK_1_9) && !JavaSdk.getInstance().isOfVersionOrHigher(jdk, JavaSdkVersion.JDK_11);
        }

        @NotNull
        public List<PersistenceConsoleProvider.Runner> getSubRunners() {
            List<PersistenceConsoleProvider.Runner> list = JpaConsoleProvider.getCfgSubRunners(this.myProject, this.myUnitFile.getElementName(), (Consumer<? super ConsoleRunConfiguration>)((Consumer)this::runInner));
            if (list == null) {
                MyRunner.$$$reportNull$$$0(1);
            }
            return list;
        }

        public String getSubRunnersTitle() {
            return JpaMessages.message("jpa.console.vm.and.env.configuration", new Object[0]);
        }

        protected void runInner(@NotNull ConsoleRunConfiguration configuration) {
            ConsoleTarget target;
            if (configuration == null) {
                MyRunner.$$$reportNull$$$0(2);
            }
            if ((target = JpaConsoleUtils.suggestAssignDatasourceIfNeeded(this.myUnitFile)) == null) {
                return;
            }
            JpaConsole.newConsole(target.getPersistencePackage()).withRunConfiguration(configuration).build().showConsole(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/JpaConsoleProvider$MyRunner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRunConfiguration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubRunners";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/JpaConsoleProvider$MyRunner";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "runInner";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class MyQueryRunner
    extends PersistenceConsoleProvider.Runner {
        private final Project myProject;
        private final @Unmodifiable List<? extends PersistencePackagePointer> myUnits;
        private final QlScriptModel myModel;

        public MyQueryRunner(Project project, @Unmodifiable List<? extends PersistencePackagePointer> units, QlScriptModel model) {
            this.myProject = project;
            this.myUnits = units;
            this.myModel = model;
        }

        public String getDisplayName() {
            return JpaMessages.message("jpa.console.provider.name", new Object[0]);
        }

        public Icon getIcon() {
            return JavaeeIcons.JPA_ICON;
        }

        public Project getProject() {
            return this.myProject;
        }

        @Nullable
        public String getSubRunnersTitle() {
            return JpaMessages.message("jpa.console.persistence.units.text", new Object[0]);
        }

        @NotNull
        public @Unmodifiable List<// Could not load outer class - annotation placement on inner may be incorrect
        PersistenceConsoleProvider.Runner> getSubRunners() {
            List sorted = ContainerUtil.sorted(this.myUnits, Comparator.comparing(PersistencePackagePointer::getPresentableUrl));
            List list = ContainerUtil.map((Collection)sorted, unit -> new PersistenceConsoleProvider.Runner((PersistencePackagePointer)unit){
                final /* synthetic */ PersistencePackagePointer val$unit;
                {
                    this.val$unit = persistencePackagePointer;
                }

                public String getDisplayName() {
                    PersistenceFacet facet = this.val$unit.getPersistenceFacet();
                    String unitName = this.val$unit.getElementName();
                    return facet.getModule().getName() + "/" + (StringUtil.isNotEmpty((String)unitName) ? unitName : JavaJamBundle.message((String)"unnamed.element.presentable.name", (Object[])new Object[0]));
                }

                public Icon getIcon() {
                    PersistenceFacet persistenceFacet = this.val$unit.getPersistenceFacet();
                    if (persistenceFacet != null) {
                        return persistenceFacet.getIcon();
                    }
                    if (this.val$unit instanceof VirtualFile) {
                        return VirtualFilePresentation.getIcon((VirtualFile)((VirtualFile)this.val$unit));
                    }
                    return JpaFacetType.getInstance().getIcon();
                }

                public String getSubRunnersTitle() {
                    return JpaMessages.message("jpa.console.vm.env.configuration.text", new Object[0]);
                }

                @NotNull
                public List<PersistenceConsoleProvider.Runner> getSubRunners() {
                    List<PersistenceConsoleProvider.Runner> list = JpaConsoleProvider.getCfgSubRunners(myProject, this.val$unit.getElementName(), (Consumer<? super ConsoleRunConfiguration>)((Consumer)cfg -> this.runInner(this.val$unit, (ConsoleRunConfiguration)cfg, myModel)));
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                public void run() {
                    this.runInner(this.val$unit, ConsoleRunConfiguration.newConfiguration((Project)myProject), myModel);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaConsoleProvider$MyQueryRunner$1", "getSubRunners"));
                }
            });
            if (list == null) {
                MyQueryRunner.$$$reportNull$$$0(0);
            }
            return list;
        }

        public void run() {
            this.runInner(this.myUnits.get(0), ConsoleRunConfiguration.newConfiguration((Project)this.myProject), this.myModel);
        }

        protected void runInner(@NotNull PersistencePackagePointer unit, @NotNull ConsoleRunConfiguration configuration, @NotNull QlScriptModel model) {
            ConsoleTarget target;
            if (unit == null) {
                MyQueryRunner.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                MyQueryRunner.$$$reportNull$$$0(2);
            }
            if (model == null) {
                MyQueryRunner.$$$reportNull$$$0(3);
            }
            if ((target = JpaConsoleUtils.suggestAssignDatasourceIfNeeded(unit)) == null) {
                return;
            }
            String text = (String)model.statements().transform(ScriptModelUtilCore.TO_QUERY).first();
            JpaConsoleBase console = this.createConsole(target.getPersistencePackage(), configuration, text);
            console.showConsole(true);
            if (console.beforeExecuteQueries(model)) {
                console.executeQueries(model);
            }
        }

        protected JpaConsoleBase createConsole(@NotNull PersistencePackagePointer unit, @NotNull ConsoleRunConfiguration configuration, String query) {
            if (unit == null) {
                MyQueryRunner.$$$reportNull$$$0(4);
            }
            if (configuration == null) {
                MyQueryRunner.$$$reportNull$$$0(5);
            }
            return JpaConsole.newConsole(unit).withRunConfiguration(configuration).withQuery(query).build();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/JpaConsoleProvider$MyQueryRunner";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubRunners";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/JpaConsoleProvider$MyQueryRunner";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "runInner";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createConsole";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class MyConsoleRunner
    extends PersistenceConsoleProvider.Runner {
        private final JpaConsoleBase myConsole;
        private final ScriptModel myModel;

        public MyConsoleRunner(@NotNull JpaConsoleBase console, @Nullable ScriptModel model) {
            if (console == null) {
                MyConsoleRunner.$$$reportNull$$$0(0);
            }
            this.myConsole = console;
            this.myModel = model;
        }

        public String getDisplayName() {
            return this.myConsole.getTitle();
        }

        public Icon getIcon() {
            return this.myConsole.getToolWindowIcon();
        }

        public boolean isAlreadyRunning() {
            return true;
        }

        public void run() {
            if (this.myModel == null) {
                this.myConsole.showConsole(true);
            } else if (this.myConsole.beforeExecuteQueries(this.myModel)) {
                this.myConsole.executeQueries(this.myModel);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/jpa/JpaConsoleProvider$MyConsoleRunner", "<init>"));
        }
    }
}

