/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.providers;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.java.ultimate.icons.JavaUltimateIcons;
import com.intellij.jpa.JpaImplementationProviderBase;
import com.intellij.jpa.JpaLibraryCoordinates;
import com.intellij.jpa.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HibernateProvider
extends JpaImplementationProviderBase {
    @NonNls
    public static final String PROVIDER_JPA_21 = "org.hibernate.jpa.HibernatePersistenceProvider";
    @NonNls
    public static final String PROVIDER_JPA_20 = "org.hibernate.ejb.HibernatePersistence";
    @NonNls
    public static final String HIBERNATE_PREFIX = "hibernate.";

    public HibernateProvider() {
        super("Hibernate", PROVIDER_JPA_21, "hibernate.connection.driver_class", "hibernate.connection.url", "hibernate.connection.username", "hibernate.connection.password");
    }

    @Override
    @Nullable
    public Icon getProviderIcon() {
        return JavaUltimateIcons.Javaee.Hibernate;
    }

    @Override
    @NotNull
    protected String getPropertyAlias(String propertyName) {
        String string = propertyName.substring(HIBERNATE_PREFIX.length());
        if (string == null) {
            HibernateProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void setDefaultProperties(@NotNull PersistenceUnit unit) {
        if (unit == null) {
            HibernateProvider.$$$reportNull$$$0(1);
        }
        super.setDefaultProperties(unit);
        JpaUtil.setPersistenceUnitProperty(unit, "hibernate.archive.autodetection", null, "class");
        JpaUtil.setPersistenceUnitProperty(unit, "hibernate.show_sql", null, "true");
        JpaUtil.setPersistenceUnitProperty(unit, "hibernate.format_sql", null, "true");
        JpaUtil.setPersistenceUnitProperty(unit, "hibernate.format_sql", null, "true");
        JpaUtil.setPersistenceUnitProperty(unit, "hibernate.hbm2ddl.auto", null, "update");
    }

    @Nullable
    public Pair<String, String> getUserDefinedNamingStrategyProperty(@NonNls PersistenceFacet facet, @NotNull PersistencePackage unit) {
        Module module;
        PsiClass namingStrategyPsiClass;
        String namingStrategyClass;
        if (unit == null) {
            HibernateProvider.$$$reportNull$$$0(2);
        }
        if (StringUtil.isNotEmpty((String)(namingStrategyClass = facet.getNamingStrategy(unit))) && (namingStrategyPsiClass = JavaPsiFacade.getInstance((Project)(module = facet.getModule()).getProject()).findClass(namingStrategyClass, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) != null) {
            String propertyName = InheritanceUtil.isInheritor((PsiClass)namingStrategyPsiClass, (String)"org.hibernate.boot.model.naming.ImplicitNamingStrategy") ? "hibernate.implicit_naming_strategy" : "hibernate.physical_naming_strategy";
            return Pair.create((Object)propertyName, (Object)namingStrategyClass);
        }
        return null;
    }

    @Override
    public String getProviderClassName(@Nullable Module module) {
        return HibernateProvider.getProvider(module);
    }

    @NotNull
    public static String getProvider(@Nullable Module module) {
        if (JavaLibraryUtil.hasLibraryClass((Module)module, (String)PROVIDER_JPA_21)) {
            return PROVIDER_JPA_21;
        }
        return PROVIDER_JPA_20;
    }

    @Override
    @NotNull
    public List<JpaLibraryCoordinates> getAutoDetectionCoordinates() {
        List<JpaLibraryCoordinates> list = Arrays.asList(new JpaLibraryCoordinates("org.hibernate", "hibernate-core"), new JpaLibraryCoordinates("org.hibernate.orm", "hibernate-core"));
        if (list == null) {
            HibernateProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/providers/HibernateProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyAlias";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/providers/HibernateProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoDetectionCoordinates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultProperties";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUserDefinedNamingStrategyProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

