/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class ResourceUtil {
    public static byte[] readUrlAsBytes(URL url) throws IOException {
        try (InputStream stream = url.openStream();){
            int len;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((len = stream.read(buffer)) != -1) {
                result.write(buffer, 0, len);
            }
            byte[] byArray = result.toByteArray();
            return byArray;
        }
    }

    public static String readUrlAsString(URL url) throws IOException {
        return new String(ResourceUtil.readUrlAsBytes(url));
    }

    public static String readPathAsString(String path) throws IOException {
        URL url = ResourceUtil.class.getResource(path);
        if (url == null) {
            throw new IOException("Resource path not found: " + path);
        }
        return ResourceUtil.readUrlAsString(url);
    }

    private ResourceUtil() {
    }
}

