/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.protobuf.lang.resolve.FileResolveProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalRootsFileResolveProvider
implements FileResolveProvider {
    private final String descriptorPath;

    public LocalRootsFileResolveProvider(String descriptorPath) {
        this.descriptorPath = descriptorPath;
    }

    @Override
    @Nullable
    public VirtualFile findFile(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            LocalRootsFileResolveProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            LocalRootsFileResolveProvider.$$$reportNull$$$0(1);
        }
        return LocalRootsFileResolveProvider.findFileInRoots(path, LocalRootsFileResolveProvider.getProjectRoots(project));
    }

    @Override
    @Nullable
    public VirtualFile findFile(@NotNull String path, @NotNull Module module) {
        if (path == null) {
            LocalRootsFileResolveProvider.$$$reportNull$$$0(2);
        }
        if (module == null) {
            LocalRootsFileResolveProvider.$$$reportNull$$$0(3);
        }
        return LocalRootsFileResolveProvider.findFileInRoots(path, LocalRootsFileResolveProvider.getModuleRoots(module));
    }

    @NotNull
    public List<FileResolveProvider.ChildEntry> getChildEntries(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            LocalRootsFileResolveProvider.$$$reportNull$$$0(4);
        }
        if (project == null) {
            LocalRootsFileResolveProvider.$$$reportNull$$$0(5);
        }
        List<FileResolveProvider.ChildEntry> list = LocalRootsFileResolveProvider.getChildEntriesForFile(this.findFile(path, project));
        if (list == null) {
            LocalRootsFileResolveProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<FileResolveProvider.ChildEntry> getChildEntries(@NotNull String path, @NotNull Module module) {
        if (path == null) {
            LocalRootsFileResolveProvider.$$$reportNull$$$0(7);
        }
        if (module == null) {
            LocalRootsFileResolveProvider.$$$reportNull$$$0(8);
        }
        List<FileResolveProvider.ChildEntry> list = LocalRootsFileResolveProvider.getChildEntriesForFile(this.findFile(path, module));
        if (list == null) {
            LocalRootsFileResolveProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @Nullable
    public VirtualFile getDescriptorFile(@NotNull Project project) {
        if (project == null) {
            LocalRootsFileResolveProvider.$$$reportNull$$$0(10);
        }
        if (this.descriptorPath != null) {
            return this.findFile(this.descriptorPath, project);
        }
        return null;
    }

    @Override
    @Nullable
    public VirtualFile getDescriptorFile(@NotNull Module module) {
        if (module == null) {
            LocalRootsFileResolveProvider.$$$reportNull$$$0(11);
        }
        if (this.descriptorPath != null) {
            return this.findFile(this.descriptorPath, module);
        }
        return null;
    }

    @Override
    @NotNull
    public GlobalSearchScope getSearchScope(@NotNull Project project) {
        if (project == null) {
            LocalRootsFileResolveProvider.$$$reportNull$$$0(12);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoriesScope((Project)project, (boolean)true, (VirtualFile[])LocalRootsFileResolveProvider.getProjectRoots(project));
        if (globalSearchScope == null) {
            LocalRootsFileResolveProvider.$$$reportNull$$$0(13);
        }
        return globalSearchScope;
    }

    private static List<FileResolveProvider.ChildEntry> getChildEntriesForFile(VirtualFile file) {
        if (file != null && file.isDirectory()) {
            return VfsUtil.getChildren((VirtualFile)file, (VirtualFileFilter)PROTO_AND_DIRECTORY_FILTER).stream().map(child -> new FileResolveProvider.ChildEntry(child.getName(), child.isDirectory())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static VirtualFile findFileInRoots(String path, VirtualFile[] roots) {
        for (VirtualFile root : roots) {
            VirtualFile file = root.findFileByRelativePath(path);
            if (file == null || !file.exists()) continue;
            return file;
        }
        return null;
    }

    private static VirtualFile[] getProjectRoots(@NotNull Project project) {
        if (project == null) {
            LocalRootsFileResolveProvider.$$$reportNull$$$0(14);
        }
        return ProjectRootManager.getInstance((Project)project).getContentRoots();
    }

    private static VirtualFile[] getModuleRoots(@NotNull Module module) {
        if (module == null) {
            LocalRootsFileResolveProvider.$$$reportNull$$$0(15);
        }
        return ModuleRootManager.getInstance((Module)module).getContentRoots();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/lang/resolve/LocalRootsFileResolveProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/lang/resolve/LocalRootsFileResolveProvider";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildEntries";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getChildEntries";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRoots";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getModuleRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 13 -> new IllegalStateException(string);
        };
    }
}

