/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.httpClient.http.request.HttpRequestNameElement;
import com.intellij.httpClient.http.request.HttpRequestPsiFileIdentifiersScope;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocComment;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocNameTag;
import com.intellij.httpClient.http.request.psi.HttpClientExecutionBlock;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0007\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0003H\u0007\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0003\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0003\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"getDeclaredName", "", "Lcom/intellij/httpClient/http/request/psi/HttpClientExecutionBlock;", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "getUniqueName", "getDeclaredNameElement", "Lcom/intellij/httpClient/http/request/HttpRequestNameElement;", "SEPARATOR_PREFIX", "IDENTIFIER_INDEX_PREFIX", "IDENTIFIER_INDEX_PREFIX_REPLACEMENT", "intellij.httpClient.lang"})
@JvmName(name="HttpRequestNameSupport")
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nHttpRequestNameSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestNameSupport.kt\ncom/intellij/httpClient/http/request/HttpRequestNameSupport\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,123:1\n19#2:124\n1#3:125\n158#4,6:126\n*S KotlinDebug\n*F\n+ 1 HttpRequestNameSupport.kt\ncom/intellij/httpClient/http/request/HttpRequestNameSupport\n*L\n22#1:124\n61#1:126,6\n*E\n"})
public final class HttpRequestNameSupport {
    @NotNull
    private static final String SEPARATOR_PREFIX = "###";
    @NotNull
    public static final String IDENTIFIER_INDEX_PREFIX = "#";
    @NotNull
    private static final String IDENTIFIER_INDEX_PREFIX_REPLACEMENT = "##";

    @NlsSafe
    @Nullable
    public static final String getDeclaredName(@NotNull HttpClientExecutionBlock $this$getDeclaredName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getDeclaredName, (String)"<this>");
        HttpClientExecutionBlock $this$asSafely$iv = $this$getDeclaredName;
        boolean $i$f$asSafely = false;
        HttpClientExecutionBlock httpClientExecutionBlock = $this$asSafely$iv;
        if (!(httpClientExecutionBlock instanceof HttpRequestBlock)) {
            httpClientExecutionBlock = null;
        }
        return (object = (HttpRequestBlock)httpClientExecutionBlock) != null && (object = object.getRequest()) != null && (object = HttpRequestNameSupport.getDeclaredNameElement((HttpRequest)object)) != null ? ((HttpRequestNameElement)object).getName() : null;
    }

    @NlsSafe
    @Nullable
    public static final String getDeclaredName(@NotNull HttpRequest $this$getDeclaredName) {
        Intrinsics.checkNotNullParameter((Object)$this$getDeclaredName, (String)"<this>");
        HttpRequestNameElement httpRequestNameElement = HttpRequestNameSupport.getDeclaredNameElement($this$getDeclaredName);
        return httpRequestNameElement != null ? httpRequestNameElement.getName() : null;
    }

    @NotNull
    public static final String getUniqueName(@NotNull HttpClientExecutionBlock $this$getUniqueName) {
        Intrinsics.checkNotNullParameter((Object)$this$getUniqueName, (String)"<this>");
        PsiFile psiFile = $this$getUniqueName.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        HttpRequestPsiFileIdentifiersScope scope = new HttpRequestPsiFileIdentifiersScope(psiFile);
        return scope.getIdentifier($this$getUniqueName);
    }

    @NotNull
    public static final String getUniqueName(@NotNull HttpRequest $this$getUniqueName) {
        Intrinsics.checkNotNullParameter((Object)$this$getUniqueName, (String)"<this>");
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)$this$getUniqueName), HttpClientExecutionBlock.class);
        Intrinsics.checkNotNull((Object)psiElement);
        HttpClientExecutionBlock parent = (HttpClientExecutionBlock)psiElement;
        return HttpRequestNameSupport.getUniqueName(parent);
    }

    @Nullable
    public static final HttpRequestNameElement getDeclaredNameElement(@NotNull HttpRequest $this$getDeclaredNameElement) {
        String string;
        Integer n;
        int n2;
        Object $this$indexOfFirst$iv;
        String withoutPrefix;
        String separatorText;
        PsiElement firstSeparator;
        block8: {
            Intrinsics.checkNotNullParameter((Object)$this$getDeclaredNameElement, (String)"<this>");
            HttpDocComment findDocComment = HttpRequestPsiUtils.findDocComment($this$getDeclaredNameElement);
            HttpDocNameTag nameDocComment = HttpRequestPsiUtils.findDocCommentOfType(findDocComment, HttpDocNameTag.class);
            if (nameDocComment != null) {
                String string2;
                String it = string2 = nameDocComment.getName();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if ((!StringsKt.isBlank((CharSequence)it) ? string2 : null) != null) {
                    String string3 = nameDocComment.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                    CharSequence charSequence = string3;
                    String string4 = nameDocComment.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                    int indexOfNameInElement = StringsKt.indexOf$default((CharSequence)charSequence, (String)string4, (int)0, (boolean)false, (int)6, null);
                    String string5 = nameDocComment.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
                    TextRange textRange = nameDocComment.getTextRange().shiftRight(indexOfNameInElement).grown(-indexOfNameInElement);
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"grown(...)");
                    return new HttpRequestNameElement(string5, textRange);
                }
            }
            PsiElement psiElement = (PsiElement)SequencesKt.lastOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.siblings((PsiElement)((PsiElement)$this$getDeclaredNameElement), (boolean)false, (boolean)false), HttpRequestNameSupport::getDeclaredNameElement$lambda$1), HttpRequestNameSupport::getDeclaredNameElement$lambda$2));
            if (psiElement == null) {
                return null;
            }
            firstSeparator = psiElement;
            separatorText = firstSeparator.getText();
            Intrinsics.checkNotNull((Object)separatorText);
            withoutPrefix = StringsKt.removePrefix((String)separatorText, (CharSequence)SEPARATOR_PREFIX);
            boolean bl = false;
            $this$indexOfFirst$iv = withoutPrefix;
            boolean $i$f$indexOfFirst = false;
            int n3 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n3; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl2 = false;
                if (!(it != '#')) continue;
                n2 = index$iv;
                break block8;
            }
            n2 = -1;
        }
        $this$indexOfFirst$iv = n2;
        int it = ((Number)$this$indexOfFirst$iv).intValue();
        boolean bl = false;
        Object object = it != -1 ? $this$indexOfFirst$iv : null;
        if (object != null) {
            int start2 = ((Number)object).intValue();
            boolean bl3 = false;
            int trimmedStart = SequencesKt.count((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.drop((Sequence)StringsKt.asSequence((CharSequence)withoutPrefix), (int)start2), HttpRequestNameSupport::getDeclaredNameElement$lambda$3$2$0));
            boolean bl4 = false;
            n = 3 + start2 + trimmedStart;
        } else {
            n = null;
        }
        if (n == null) {
            return null;
        }
        int indexOfNameInElement = n;
        String string6 = separatorText.substring(indexOfNameInElement);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
        String it2 = string = ((Object)StringsKt.trimEnd((CharSequence)string6)).toString();
        boolean bl5 = false;
        String string7 = ((CharSequence)it2).length() > 0 ? string : null;
        if (string7 == null) {
            return null;
        }
        String name = string7;
        TextRange textRange = firstSeparator.getTextRange().shiftRight(indexOfNameInElement).grown(-indexOfNameInElement);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"grown(...)");
        return new HttpRequestNameElement(name, textRange);
    }

    private static final boolean getDeclaredNameElement$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof HttpRequest);
    }

    private static final boolean getDeclaredNameElement$lambda$2(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HttpRequestPsiUtils.isOfType(it, HttpRequestElementTypes.REQUEST_SEPARATOR);
    }

    private static final boolean getDeclaredNameElement$lambda$3$2$0(char it) {
        return CharsKt.isWhitespace((char)it);
    }
}

