/**
 * Utilities for unicode characters
 */

#include "tree_sitter/parser.h"

/**
 * Test whether the character is considered to be valid for a varsym, which amounts to being in one of the following
 * unicode categories, as defined by GHC/Parser/Lexer.x:
 *
 * - ConnectorPunctuation
 * - DashPunctuation
 * - OtherPunctuation
 * - MathSymbol
 * - CurrencySymbol
 * - ModifierSymbol
 * - OtherSymbol
 *
 * Since there doesn't appear to be an easy way to test this with standard C, we list all individual codepoints here.
 */
static bool unicode_symbol(uint32_t c) {
  switch (c) {
    case 161u:
    case 162u:
    case 163u:
    case 164u:
    case 165u:
    case 166u:
    case 167u:
    case 168u:
    case 169u:
    case 172u:
    case 174u:
    case 175u:
    case 176u:
    case 177u:
    case 180u:
    case 182u:
    case 183u:
    case 184u:
    case 191u:
    case 215u:
    case 247u:
    case 706u:
    case 707u:
    case 708u:
    case 709u:
    case 722u:
    case 723u:
    case 724u:
    case 725u:
    case 726u:
    case 727u:
    case 728u:
    case 729u:
    case 730u:
    case 731u:
    case 732u:
    case 733u:
    case 734u:
    case 735u:
    case 741u:
    case 742u:
    case 743u:
    case 744u:
    case 745u:
    case 746u:
    case 747u:
    case 749u:
    case 751u:
    case 752u:
    case 753u:
    case 754u:
    case 755u:
    case 756u:
    case 757u:
    case 758u:
    case 759u:
    case 760u:
    case 761u:
    case 762u:
    case 763u:
    case 764u:
    case 765u:
    case 766u:
    case 767u:
    case 885u:
    case 894u:
    case 900u:
    case 901u:
    case 903u:
    case 1014u:
    case 1154u:
    case 1370u:
    case 1371u:
    case 1372u:
    case 1373u:
    case 1374u:
    case 1375u:
    case 1417u:
    case 1418u:
    case 1423u:
    case 1470u:
    case 1472u:
    case 1475u:
    case 1478u:
    case 1523u:
    case 1524u:
    case 1542u:
    case 1543u:
    case 1544u:
    case 1545u:
    case 1546u:
    case 1547u:
    case 1548u:
    case 1549u:
    case 1550u:
    case 1551u:
    case 1563u:
    case 1566u:
    case 1567u:
    case 1642u:
    case 1643u:
    case 1644u:
    case 1645u:
    case 1748u:
    case 1758u:
    case 1769u:
    case 1789u:
    case 1790u:
    case 1792u:
    case 1793u:
    case 1794u:
    case 1795u:
    case 1796u:
    case 1797u:
    case 1798u:
    case 1799u:
    case 1800u:
    case 1801u:
    case 1802u:
    case 1803u:
    case 1804u:
    case 1805u:
    case 2038u:
    case 2039u:
    case 2040u:
    case 2041u:
    case 2096u:
    case 2097u:
    case 2098u:
    case 2099u:
    case 2100u:
    case 2101u:
    case 2102u:
    case 2103u:
    case 2104u:
    case 2105u:
    case 2106u:
    case 2107u:
    case 2108u:
    case 2109u:
    case 2110u:
    case 2142u:
    case 2404u:
    case 2405u:
    case 2416u:
    case 2546u:
    case 2547u:
    case 2554u:
    case 2555u:
    case 2800u:
    case 2801u:
    case 2928u:
    case 3059u:
    case 3060u:
    case 3061u:
    case 3062u:
    case 3063u:
    case 3064u:
    case 3065u:
    case 3066u:
    case 3199u:
    case 3449u:
    case 3572u:
    case 3647u:
    case 3663u:
    case 3674u:
    case 3675u:
    case 3841u:
    case 3842u:
    case 3843u:
    case 3844u:
    case 3845u:
    case 3846u:
    case 3847u:
    case 3848u:
    case 3849u:
    case 3850u:
    case 3851u:
    case 3852u:
    case 3853u:
    case 3854u:
    case 3855u:
    case 3856u:
    case 3857u:
    case 3858u:
    case 3859u:
    case 3860u:
    case 3861u:
    case 3862u:
    case 3863u:
    case 3866u:
    case 3867u:
    case 3868u:
    case 3869u:
    case 3870u:
    case 3871u:
    case 3892u:
    case 3894u:
    case 3896u:
    case 3973u:
    case 4030u:
    case 4031u:
    case 4032u:
    case 4033u:
    case 4034u:
    case 4035u:
    case 4036u:
    case 4037u:
    case 4039u:
    case 4040u:
    case 4041u:
    case 4042u:
    case 4043u:
    case 4044u:
    case 4046u:
    case 4047u:
    case 4048u:
    case 4049u:
    case 4050u:
    case 4051u:
    case 4052u:
    case 4053u:
    case 4054u:
    case 4055u:
    case 4056u:
    case 4057u:
    case 4058u:
    case 4170u:
    case 4171u:
    case 4172u:
    case 4173u:
    case 4174u:
    case 4175u:
    case 4254u:
    case 4255u:
    case 4347u:
    case 4960u:
    case 4961u:
    case 4962u:
    case 4963u:
    case 4964u:
    case 4965u:
    case 4966u:
    case 4967u:
    case 4968u:
    case 5008u:
    case 5009u:
    case 5010u:
    case 5011u:
    case 5012u:
    case 5013u:
    case 5014u:
    case 5015u:
    case 5016u:
    case 5017u:
    case 5120u:
    case 5741u:
    case 5742u:
    case 5867u:
    case 5868u:
    case 5869u:
    case 5941u:
    case 5942u:
    case 6100u:
    case 6101u:
    case 6102u:
    case 6104u:
    case 6105u:
    case 6106u:
    case 6107u:
    case 6144u:
    case 6145u:
    case 6146u:
    case 6147u:
    case 6148u:
    case 6149u:
    case 6150u:
    case 6151u:
    case 6152u:
    case 6153u:
    case 6154u:
    case 6464u:
    case 6468u:
    case 6469u:
    case 6622u:
    case 6623u:
    case 6624u:
    case 6625u:
    case 6626u:
    case 6627u:
    case 6628u:
    case 6629u:
    case 6630u:
    case 6631u:
    case 6632u:
    case 6633u:
    case 6634u:
    case 6635u:
    case 6636u:
    case 6637u:
    case 6638u:
    case 6639u:
    case 6640u:
    case 6641u:
    case 6642u:
    case 6643u:
    case 6644u:
    case 6645u:
    case 6646u:
    case 6647u:
    case 6648u:
    case 6649u:
    case 6650u:
    case 6651u:
    case 6652u:
    case 6653u:
    case 6654u:
    case 6655u:
    case 6686u:
    case 6687u:
    case 6816u:
    case 6817u:
    case 6818u:
    case 6819u:
    case 6820u:
    case 6821u:
    case 6822u:
    case 6824u:
    case 6825u:
    case 6826u:
    case 6827u:
    case 6828u:
    case 6829u:
    case 7002u:
    case 7003u:
    case 7004u:
    case 7005u:
    case 7006u:
    case 7007u:
    case 7008u:
    case 7009u:
    case 7010u:
    case 7011u:
    case 7012u:
    case 7013u:
    case 7014u:
    case 7015u:
    case 7016u:
    case 7017u:
    case 7018u:
    case 7028u:
    case 7029u:
    case 7030u:
    case 7031u:
    case 7032u:
    case 7033u:
    case 7034u:
    case 7035u:
    case 7036u:
    case 7164u:
    case 7165u:
    case 7166u:
    case 7167u:
    case 7227u:
    case 7228u:
    case 7229u:
    case 7230u:
    case 7231u:
    case 7294u:
    case 7295u:
    case 7360u:
    case 7361u:
    case 7362u:
    case 7363u:
    case 7364u:
    case 7365u:
    case 7366u:
    case 7367u:
    case 7379u:
    case 8125u:
    case 8127u:
    case 8128u:
    case 8129u:
    case 8141u:
    case 8142u:
    case 8143u:
    case 8157u:
    case 8158u:
    case 8159u:
    case 8173u:
    case 8174u:
    case 8175u:
    case 8189u:
    case 8190u:
    case 8208u:
    case 8209u:
    case 8210u:
    case 8211u:
    case 8212u:
    case 8213u:
    case 8214u:
    case 8215u:
    case 8224u:
    case 8225u:
    case 8226u:
    case 8227u:
    case 8228u:
    case 8229u:
    case 8230u:
    case 8231u:
    case 8240u:
    case 8241u:
    case 8242u:
    case 8243u:
    case 8244u:
    case 8245u:
    case 8246u:
    case 8247u:
    case 8248u:
    case 8251u:
    case 8252u:
    case 8253u:
    case 8254u:
    case 8255u:
    case 8256u:
    case 8257u:
    case 8258u:
    case 8259u:
    case 8260u:
    case 8263u:
    case 8264u:
    case 8265u:
    case 8266u:
    case 8267u:
    case 8268u:
    case 8269u:
    case 8270u:
    case 8271u:
    case 8272u:
    case 8273u:
    case 8274u:
    case 8275u:
    case 8276u:
    case 8277u:
    case 8278u:
    case 8279u:
    case 8280u:
    case 8281u:
    case 8282u:
    case 8283u:
    case 8284u:
    case 8285u:
    case 8286u:
    case 8314u:
    case 8315u:
    case 8316u:
    case 8330u:
    case 8331u:
    case 8332u:
    case 8352u:
    case 8353u:
    case 8354u:
    case 8355u:
    case 8356u:
    case 8357u:
    case 8358u:
    case 8359u:
    case 8360u:
    case 8361u:
    case 8362u:
    case 8363u:
    case 8364u:
    case 8365u:
    case 8366u:
    case 8367u:
    case 8368u:
    case 8369u:
    case 8370u:
    case 8371u:
    case 8372u:
    case 8373u:
    case 8374u:
    case 8375u:
    case 8376u:
    case 8377u:
    case 8448u:
    case 8449u:
    case 8451u:
    case 8452u:
    case 8453u:
    case 8454u:
    case 8456u:
    case 8457u:
    case 8468u:
    case 8470u:
    case 8471u:
    case 8472u:
    case 8478u:
    case 8479u:
    case 8480u:
    case 8481u:
    case 8482u:
    case 8483u:
    case 8485u:
    case 8487u:
    case 8489u:
    case 8494u:
    case 8506u:
    case 8507u:
    case 8512u:
    case 8513u:
    case 8514u:
    case 8515u:
    case 8516u:
    case 8522u:
    case 8523u:
    case 8524u:
    case 8525u:
    case 8527u:
    case 8593u:
    case 8595u:
    case 8596u:
    case 8597u:
    case 8598u:
    case 8599u:
    case 8600u:
    case 8601u:
    case 8602u:
    case 8603u:
    case 8604u:
    case 8605u:
    case 8606u:
    case 8607u:
    case 8608u:
    case 8609u:
    case 8610u:
    case 8611u:
    case 8612u:
    case 8613u:
    case 8614u:
    case 8615u:
    case 8616u:
    case 8617u:
    case 8618u:
    case 8619u:
    case 8620u:
    case 8621u:
    case 8622u:
    case 8623u:
    case 8624u:
    case 8625u:
    case 8626u:
    case 8627u:
    case 8628u:
    case 8629u:
    case 8630u:
    case 8631u:
    case 8632u:
    case 8633u:
    case 8634u:
    case 8635u:
    case 8636u:
    case 8637u:
    case 8638u:
    case 8639u:
    case 8640u:
    case 8641u:
    case 8642u:
    case 8643u:
    case 8644u:
    case 8645u:
    case 8646u:
    case 8647u:
    case 8648u:
    case 8649u:
    case 8650u:
    case 8651u:
    case 8652u:
    case 8653u:
    case 8654u:
    case 8655u:
    case 8656u:
    case 8657u:
    case 8659u:
    case 8660u:
    case 8661u:
    case 8662u:
    case 8663u:
    case 8664u:
    case 8665u:
    case 8666u:
    case 8667u:
    case 8668u:
    case 8669u:
    case 8670u:
    case 8671u:
    case 8672u:
    case 8673u:
    case 8674u:
    case 8675u:
    case 8676u:
    case 8677u:
    case 8678u:
    case 8679u:
    case 8680u:
    case 8681u:
    case 8682u:
    case 8683u:
    case 8684u:
    case 8685u:
    case 8686u:
    case 8687u:
    case 8688u:
    case 8689u:
    case 8690u:
    case 8691u:
    case 8692u:
    case 8693u:
    case 8694u:
    case 8695u:
    case 8696u:
    case 8697u:
    case 8698u:
    case 8699u:
    case 8700u:
    case 8701u:
    case 8702u:
    case 8703u:
    case 8705u:
    case 8706u:
    case 8707u:
    case 8708u:
    case 8709u:
    case 8710u:
    case 8711u:
    case 8712u:
    case 8713u:
    case 8714u:
    case 8715u:
    case 8716u:
    case 8717u:
    case 8718u:
    case 8719u:
    case 8720u:
    case 8721u:
    case 8722u:
    case 8723u:
    case 8724u:
    case 8725u:
    case 8726u:
    case 8727u:
    case 8728u:
    case 8729u:
    case 8730u:
    case 8731u:
    case 8732u:
    case 8733u:
    case 8734u:
    case 8735u:
    case 8736u:
    case 8737u:
    case 8738u:
    case 8739u:
    case 8740u:
    case 8741u:
    case 8742u:
    case 8743u:
    case 8744u:
    case 8745u:
    case 8746u:
    case 8747u:
    case 8748u:
    case 8749u:
    case 8750u:
    case 8751u:
    case 8752u:
    case 8753u:
    case 8754u:
    case 8755u:
    case 8756u:
    case 8757u:
    case 8758u:
    case 8760u:
    case 8761u:
    case 8762u:
    case 8763u:
    case 8764u:
    case 8765u:
    case 8766u:
    case 8767u:
    case 8768u:
    case 8769u:
    case 8770u:
    case 8771u:
    case 8772u:
    case 8773u:
    case 8774u:
    case 8775u:
    case 8776u:
    case 8777u:
    case 8778u:
    case 8779u:
    case 8780u:
    case 8781u:
    case 8782u:
    case 8783u:
    case 8784u:
    case 8785u:
    case 8786u:
    case 8787u:
    case 8788u:
    case 8789u:
    case 8790u:
    case 8791u:
    case 8792u:
    case 8793u:
    case 8794u:
    case 8795u:
    case 8796u:
    case 8797u:
    case 8798u:
    case 8799u:
    case 8800u:
    case 8801u:
    case 8802u:
    case 8803u:
    case 8804u:
    case 8805u:
    case 8806u:
    case 8807u:
    case 8808u:
    case 8809u:
    case 8810u:
    case 8811u:
    case 8812u:
    case 8813u:
    case 8814u:
    case 8815u:
    case 8816u:
    case 8817u:
    case 8818u:
    case 8819u:
    case 8820u:
    case 8821u:
    case 8822u:
    case 8823u:
    case 8824u:
    case 8825u:
    case 8826u:
    case 8827u:
    case 8828u:
    case 8829u:
    case 8830u:
    case 8831u:
    case 8832u:
    case 8833u:
    case 8834u:
    case 8835u:
    case 8836u:
    case 8837u:
    case 8838u:
    case 8839u:
    case 8840u:
    case 8841u:
    case 8842u:
    case 8843u:
    case 8844u:
    case 8845u:
    case 8846u:
    case 8847u:
    case 8848u:
    case 8849u:
    case 8850u:
    case 8851u:
    case 8852u:
    case 8853u:
    case 8854u:
    case 8855u:
    case 8856u:
    case 8857u:
    case 8858u:
    case 8859u:
    case 8860u:
    case 8861u:
    case 8862u:
    case 8863u:
    case 8864u:
    case 8865u:
    case 8866u:
    case 8867u:
    case 8868u:
    case 8869u:
    case 8870u:
    case 8871u:
    case 8872u:
    case 8873u:
    case 8874u:
    case 8875u:
    case 8876u:
    case 8877u:
    case 8878u:
    case 8879u:
    case 8880u:
    case 8881u:
    case 8882u:
    case 8883u:
    case 8884u:
    case 8885u:
    case 8886u:
    case 8887u:
    case 8888u:
    case 8889u:
    case 8890u:
    case 8891u:
    case 8892u:
    case 8893u:
    case 8894u:
    case 8895u:
    case 8896u:
    case 8897u:
    case 8898u:
    case 8899u:
    case 8900u:
    case 8901u:
    case 8902u:
    case 8903u:
    case 8904u:
    case 8905u:
    case 8906u:
    case 8907u:
    case 8908u:
    case 8909u:
    case 8910u:
    case 8911u:
    case 8912u:
    case 8913u:
    case 8914u:
    case 8915u:
    case 8916u:
    case 8917u:
    case 8918u:
    case 8919u:
    case 8920u:
    case 8921u:
    case 8922u:
    case 8923u:
    case 8924u:
    case 8925u:
    case 8926u:
    case 8927u:
    case 8928u:
    case 8929u:
    case 8930u:
    case 8931u:
    case 8932u:
    case 8933u:
    case 8934u:
    case 8935u:
    case 8936u:
    case 8937u:
    case 8938u:
    case 8939u:
    case 8940u:
    case 8941u:
    case 8942u:
    case 8943u:
    case 8944u:
    case 8945u:
    case 8946u:
    case 8947u:
    case 8948u:
    case 8949u:
    case 8950u:
    case 8951u:
    case 8952u:
    case 8953u:
    case 8954u:
    case 8955u:
    case 8956u:
    case 8957u:
    case 8958u:
    case 8959u:
    case 8960u:
    case 8961u:
    case 8962u:
    case 8963u:
    case 8964u:
    case 8965u:
    case 8966u:
    case 8967u:
    case 8968u:
    case 8969u:
    case 8970u:
    case 8971u:
    case 8972u:
    case 8973u:
    case 8974u:
    case 8975u:
    case 8976u:
    case 8977u:
    case 8978u:
    case 8979u:
    case 8980u:
    case 8981u:
    case 8982u:
    case 8983u:
    case 8984u:
    case 8985u:
    case 8986u:
    case 8987u:
    case 8988u:
    case 8989u:
    case 8990u:
    case 8991u:
    case 8992u:
    case 8993u:
    case 8994u:
    case 8995u:
    case 8996u:
    case 8997u:
    case 8998u:
    case 8999u:
    case 9000u:
    case 9003u:
    case 9004u:
    case 9005u:
    case 9006u:
    case 9007u:
    case 9008u:
    case 9009u:
    case 9010u:
    case 9011u:
    case 9012u:
    case 9013u:
    case 9014u:
    case 9015u:
    case 9016u:
    case 9017u:
    case 9018u:
    case 9019u:
    case 9020u:
    case 9021u:
    case 9022u:
    case 9023u:
    case 9024u:
    case 9025u:
    case 9026u:
    case 9027u:
    case 9028u:
    case 9029u:
    case 9030u:
    case 9031u:
    case 9032u:
    case 9033u:
    case 9034u:
    case 9035u:
    case 9036u:
    case 9037u:
    case 9038u:
    case 9039u:
    case 9040u:
    case 9041u:
    case 9042u:
    case 9043u:
    case 9044u:
    case 9045u:
    case 9046u:
    case 9047u:
    case 9048u:
    case 9049u:
    case 9050u:
    case 9051u:
    case 9052u:
    case 9053u:
    case 9054u:
    case 9055u:
    case 9056u:
    case 9057u:
    case 9058u:
    case 9059u:
    case 9060u:
    case 9061u:
    case 9062u:
    case 9063u:
    case 9064u:
    case 9065u:
    case 9066u:
    case 9067u:
    case 9068u:
    case 9069u:
    case 9070u:
    case 9071u:
    case 9072u:
    case 9073u:
    case 9074u:
    case 9075u:
    case 9076u:
    case 9077u:
    case 9078u:
    case 9079u:
    case 9080u:
    case 9081u:
    case 9082u:
    case 9083u:
    case 9084u:
    case 9085u:
    case 9086u:
    case 9087u:
    case 9088u:
    case 9089u:
    case 9090u:
    case 9091u:
    case 9092u:
    case 9093u:
    case 9094u:
    case 9095u:
    case 9096u:
    case 9097u:
    case 9098u:
    case 9099u:
    case 9100u:
    case 9101u:
    case 9102u:
    case 9103u:
    case 9104u:
    case 9105u:
    case 9106u:
    case 9107u:
    case 9108u:
    case 9109u:
    case 9110u:
    case 9111u:
    case 9112u:
    case 9113u:
    case 9114u:
    case 9115u:
    case 9116u:
    case 9117u:
    case 9118u:
    case 9119u:
    case 9120u:
    case 9121u:
    case 9122u:
    case 9123u:
    case 9124u:
    case 9125u:
    case 9126u:
    case 9127u:
    case 9128u:
    case 9129u:
    case 9130u:
    case 9131u:
    case 9132u:
    case 9133u:
    case 9134u:
    case 9135u:
    case 9136u:
    case 9137u:
    case 9138u:
    case 9139u:
    case 9140u:
    case 9141u:
    case 9142u:
    case 9143u:
    case 9144u:
    case 9145u:
    case 9146u:
    case 9147u:
    case 9148u:
    case 9149u:
    case 9150u:
    case 9151u:
    case 9152u:
    case 9153u:
    case 9154u:
    case 9155u:
    case 9156u:
    case 9157u:
    case 9158u:
    case 9159u:
    case 9160u:
    case 9161u:
    case 9162u:
    case 9163u:
    case 9164u:
    case 9165u:
    case 9166u:
    case 9167u:
    case 9168u:
    case 9169u:
    case 9170u:
    case 9171u:
    case 9172u:
    case 9173u:
    case 9174u:
    case 9175u:
    case 9176u:
    case 9177u:
    case 9178u:
    case 9179u:
    case 9180u:
    case 9181u:
    case 9182u:
    case 9183u:
    case 9184u:
    case 9185u:
    case 9186u:
    case 9187u:
    case 9188u:
    case 9189u:
    case 9190u:
    case 9191u:
    case 9192u:
    case 9193u:
    case 9194u:
    case 9195u:
    case 9196u:
    case 9197u:
    case 9198u:
    case 9199u:
    case 9200u:
    case 9201u:
    case 9202u:
    case 9203u:
    case 9216u:
    case 9217u:
    case 9218u:
    case 9219u:
    case 9220u:
    case 9221u:
    case 9222u:
    case 9223u:
    case 9224u:
    case 9225u:
    case 9226u:
    case 9227u:
    case 9228u:
    case 9229u:
    case 9230u:
    case 9231u:
    case 9232u:
    case 9233u:
    case 9234u:
    case 9235u:
    case 9236u:
    case 9237u:
    case 9238u:
    case 9239u:
    case 9240u:
    case 9241u:
    case 9242u:
    case 9243u:
    case 9244u:
    case 9245u:
    case 9246u:
    case 9247u:
    case 9248u:
    case 9249u:
    case 9250u:
    case 9251u:
    case 9252u:
    case 9253u:
    case 9254u:
    case 9280u:
    case 9281u:
    case 9282u:
    case 9283u:
    case 9284u:
    case 9285u:
    case 9286u:
    case 9287u:
    case 9288u:
    case 9289u:
    case 9290u:
    case 9372u:
    case 9373u:
    case 9374u:
    case 9375u:
    case 9376u:
    case 9377u:
    case 9378u:
    case 9379u:
    case 9380u:
    case 9381u:
    case 9382u:
    case 9383u:
    case 9384u:
    case 9385u:
    case 9386u:
    case 9387u:
    case 9388u:
    case 9389u:
    case 9390u:
    case 9391u:
    case 9392u:
    case 9393u:
    case 9394u:
    case 9395u:
    case 9396u:
    case 9397u:
    case 9398u:
    case 9399u:
    case 9400u:
    case 9401u:
    case 9402u:
    case 9403u:
    case 9404u:
    case 9405u:
    case 9406u:
    case 9407u:
    case 9408u:
    case 9409u:
    case 9410u:
    case 9411u:
    case 9412u:
    case 9413u:
    case 9414u:
    case 9415u:
    case 9416u:
    case 9417u:
    case 9418u:
    case 9419u:
    case 9420u:
    case 9421u:
    case 9422u:
    case 9423u:
    case 9424u:
    case 9425u:
    case 9426u:
    case 9427u:
    case 9428u:
    case 9429u:
    case 9430u:
    case 9431u:
    case 9432u:
    case 9433u:
    case 9434u:
    case 9435u:
    case 9436u:
    case 9437u:
    case 9438u:
    case 9439u:
    case 9440u:
    case 9441u:
    case 9442u:
    case 9443u:
    case 9444u:
    case 9445u:
    case 9446u:
    case 9447u:
    case 9448u:
    case 9449u:
    case 9472u:
    case 9473u:
    case 9474u:
    case 9475u:
    case 9476u:
    case 9477u:
    case 9478u:
    case 9479u:
    case 9480u:
    case 9481u:
    case 9482u:
    case 9483u:
    case 9484u:
    case 9485u:
    case 9486u:
    case 9487u:
    case 9488u:
    case 9489u:
    case 9490u:
    case 9491u:
    case 9492u:
    case 9493u:
    case 9494u:
    case 9495u:
    case 9496u:
    case 9497u:
    case 9498u:
    case 9499u:
    case 9500u:
    case 9501u:
    case 9502u:
    case 9503u:
    case 9504u:
    case 9505u:
    case 9506u:
    case 9507u:
    case 9508u:
    case 9509u:
    case 9510u:
    case 9511u:
    case 9512u:
    case 9513u:
    case 9514u:
    case 9515u:
    case 9516u:
    case 9517u:
    case 9518u:
    case 9519u:
    case 9520u:
    case 9521u:
    case 9522u:
    case 9523u:
    case 9524u:
    case 9525u:
    case 9526u:
    case 9527u:
    case 9528u:
    case 9529u:
    case 9530u:
    case 9531u:
    case 9532u:
    case 9533u:
    case 9534u:
    case 9535u:
    case 9536u:
    case 9537u:
    case 9538u:
    case 9539u:
    case 9540u:
    case 9541u:
    case 9542u:
    case 9543u:
    case 9544u:
    case 9545u:
    case 9546u:
    case 9547u:
    case 9548u:
    case 9549u:
    case 9550u:
    case 9551u:
    case 9552u:
    case 9553u:
    case 9554u:
    case 9555u:
    case 9556u:
    case 9557u:
    case 9558u:
    case 9559u:
    case 9560u:
    case 9561u:
    case 9562u:
    case 9563u:
    case 9564u:
    case 9565u:
    case 9566u:
    case 9567u:
    case 9568u:
    case 9569u:
    case 9570u:
    case 9571u:
    case 9572u:
    case 9573u:
    case 9574u:
    case 9575u:
    case 9576u:
    case 9577u:
    case 9578u:
    case 9579u:
    case 9580u:
    case 9581u:
    case 9582u:
    case 9583u:
    case 9584u:
    case 9585u:
    case 9586u:
    case 9587u:
    case 9588u:
    case 9589u:
    case 9590u:
    case 9591u:
    case 9592u:
    case 9593u:
    case 9594u:
    case 9595u:
    case 9596u:
    case 9597u:
    case 9598u:
    case 9599u:
    case 9600u:
    case 9601u:
    case 9602u:
    case 9603u:
    case 9604u:
    case 9605u:
    case 9606u:
    case 9607u:
    case 9608u:
    case 9609u:
    case 9610u:
    case 9611u:
    case 9612u:
    case 9613u:
    case 9614u:
    case 9615u:
    case 9616u:
    case 9617u:
    case 9618u:
    case 9619u:
    case 9620u:
    case 9621u:
    case 9622u:
    case 9623u:
    case 9624u:
    case 9625u:
    case 9626u:
    case 9627u:
    case 9628u:
    case 9629u:
    case 9630u:
    case 9631u:
    case 9632u:
    case 9633u:
    case 9634u:
    case 9635u:
    case 9636u:
    case 9637u:
    case 9638u:
    case 9639u:
    case 9640u:
    case 9641u:
    case 9642u:
    case 9643u:
    case 9644u:
    case 9645u:
    case 9646u:
    case 9647u:
    case 9648u:
    case 9649u:
    case 9650u:
    case 9651u:
    case 9652u:
    case 9653u:
    case 9654u:
    case 9655u:
    case 9656u:
    case 9657u:
    case 9658u:
    case 9659u:
    case 9660u:
    case 9661u:
    case 9662u:
    case 9663u:
    case 9664u:
    case 9665u:
    case 9666u:
    case 9667u:
    case 9668u:
    case 9669u:
    case 9670u:
    case 9671u:
    case 9672u:
    case 9673u:
    case 9674u:
    case 9675u:
    case 9676u:
    case 9677u:
    case 9678u:
    case 9679u:
    case 9680u:
    case 9681u:
    case 9682u:
    case 9683u:
    case 9684u:
    case 9685u:
    case 9686u:
    case 9687u:
    case 9688u:
    case 9689u:
    case 9690u:
    case 9691u:
    case 9692u:
    case 9693u:
    case 9694u:
    case 9695u:
    case 9696u:
    case 9697u:
    case 9698u:
    case 9699u:
    case 9700u:
    case 9701u:
    case 9702u:
    case 9703u:
    case 9704u:
    case 9705u:
    case 9706u:
    case 9707u:
    case 9708u:
    case 9709u:
    case 9710u:
    case 9711u:
    case 9712u:
    case 9713u:
    case 9714u:
    case 9715u:
    case 9716u:
    case 9717u:
    case 9718u:
    case 9719u:
    case 9720u:
    case 9721u:
    case 9722u:
    case 9723u:
    case 9724u:
    case 9725u:
    case 9726u:
    case 9727u:
    case 9728u:
    case 9729u:
    case 9730u:
    case 9731u:
    case 9732u:
    case 9734u:
    case 9735u:
    case 9736u:
    case 9737u:
    case 9738u:
    case 9739u:
    case 9740u:
    case 9741u:
    case 9742u:
    case 9743u:
    case 9744u:
    case 9745u:
    case 9746u:
    case 9747u:
    case 9748u:
    case 9749u:
    case 9750u:
    case 9751u:
    case 9752u:
    case 9753u:
    case 9754u:
    case 9755u:
    case 9756u:
    case 9757u:
    case 9758u:
    case 9759u:
    case 9760u:
    case 9761u:
    case 9762u:
    case 9763u:
    case 9764u:
    case 9765u:
    case 9766u:
    case 9767u:
    case 9768u:
    case 9769u:
    case 9770u:
    case 9771u:
    case 9772u:
    case 9773u:
    case 9774u:
    case 9775u:
    case 9776u:
    case 9777u:
    case 9778u:
    case 9779u:
    case 9780u:
    case 9781u:
    case 9782u:
    case 9783u:
    case 9784u:
    case 9785u:
    case 9786u:
    case 9787u:
    case 9788u:
    case 9789u:
    case 9790u:
    case 9791u:
    case 9792u:
    case 9793u:
    case 9794u:
    case 9795u:
    case 9796u:
    case 9797u:
    case 9798u:
    case 9799u:
    case 9800u:
    case 9801u:
    case 9802u:
    case 9803u:
    case 9804u:
    case 9805u:
    case 9806u:
    case 9807u:
    case 9808u:
    case 9809u:
    case 9810u:
    case 9811u:
    case 9812u:
    case 9813u:
    case 9814u:
    case 9815u:
    case 9816u:
    case 9817u:
    case 9818u:
    case 9819u:
    case 9820u:
    case 9821u:
    case 9822u:
    case 9823u:
    case 9824u:
    case 9825u:
    case 9826u:
    case 9827u:
    case 9828u:
    case 9829u:
    case 9830u:
    case 9831u:
    case 9832u:
    case 9833u:
    case 9834u:
    case 9835u:
    case 9836u:
    case 9837u:
    case 9838u:
    case 9839u:
    case 9840u:
    case 9841u:
    case 9842u:
    case 9843u:
    case 9844u:
    case 9845u:
    case 9846u:
    case 9847u:
    case 9848u:
    case 9849u:
    case 9850u:
    case 9851u:
    case 9852u:
    case 9853u:
    case 9854u:
    case 9855u:
    case 9856u:
    case 9857u:
    case 9858u:
    case 9859u:
    case 9860u:
    case 9861u:
    case 9862u:
    case 9863u:
    case 9864u:
    case 9865u:
    case 9866u:
    case 9867u:
    case 9868u:
    case 9869u:
    case 9870u:
    case 9871u:
    case 9872u:
    case 9873u:
    case 9874u:
    case 9875u:
    case 9876u:
    case 9877u:
    case 9878u:
    case 9879u:
    case 9880u:
    case 9881u:
    case 9882u:
    case 9883u:
    case 9884u:
    case 9885u:
    case 9886u:
    case 9887u:
    case 9888u:
    case 9889u:
    case 9890u:
    case 9891u:
    case 9892u:
    case 9893u:
    case 9894u:
    case 9895u:
    case 9896u:
    case 9897u:
    case 9898u:
    case 9899u:
    case 9900u:
    case 9901u:
    case 9902u:
    case 9903u:
    case 9904u:
    case 9905u:
    case 9906u:
    case 9907u:
    case 9908u:
    case 9909u:
    case 9910u:
    case 9911u:
    case 9912u:
    case 9913u:
    case 9914u:
    case 9915u:
    case 9916u:
    case 9917u:
    case 9918u:
    case 9919u:
    case 9920u:
    case 9921u:
    case 9922u:
    case 9923u:
    case 9924u:
    case 9925u:
    case 9926u:
    case 9927u:
    case 9928u:
    case 9929u:
    case 9930u:
    case 9931u:
    case 9932u:
    case 9933u:
    case 9934u:
    case 9935u:
    case 9936u:
    case 9937u:
    case 9938u:
    case 9939u:
    case 9940u:
    case 9941u:
    case 9942u:
    case 9943u:
    case 9944u:
    case 9945u:
    case 9946u:
    case 9947u:
    case 9948u:
    case 9949u:
    case 9950u:
    case 9951u:
    case 9952u:
    case 9953u:
    case 9954u:
    case 9955u:
    case 9956u:
    case 9957u:
    case 9958u:
    case 9959u:
    case 9960u:
    case 9961u:
    case 9962u:
    case 9963u:
    case 9964u:
    case 9965u:
    case 9966u:
    case 9967u:
    case 9968u:
    case 9969u:
    case 9970u:
    case 9971u:
    case 9972u:
    case 9973u:
    case 9974u:
    case 9975u:
    case 9976u:
    case 9977u:
    case 9978u:
    case 9979u:
    case 9980u:
    case 9981u:
    case 9982u:
    case 9983u:
    case 9985u:
    case 9986u:
    case 9987u:
    case 9988u:
    case 9989u:
    case 9990u:
    case 9991u:
    case 9992u:
    case 9993u:
    case 9994u:
    case 9995u:
    case 9996u:
    case 9997u:
    case 9998u:
    case 9999u:
    case 10000u:
    case 10001u:
    case 10002u:
    case 10003u:
    case 10004u:
    case 10005u:
    case 10006u:
    case 10007u:
    case 10008u:
    case 10009u:
    case 10010u:
    case 10011u:
    case 10012u:
    case 10013u:
    case 10014u:
    case 10015u:
    case 10016u:
    case 10017u:
    case 10018u:
    case 10019u:
    case 10020u:
    case 10021u:
    case 10022u:
    case 10023u:
    case 10024u:
    case 10025u:
    case 10026u:
    case 10027u:
    case 10028u:
    case 10029u:
    case 10030u:
    case 10031u:
    case 10032u:
    case 10033u:
    case 10034u:
    case 10035u:
    case 10036u:
    case 10037u:
    case 10038u:
    case 10039u:
    case 10040u:
    case 10041u:
    case 10042u:
    case 10043u:
    case 10044u:
    case 10045u:
    case 10046u:
    case 10047u:
    case 10048u:
    case 10049u:
    case 10050u:
    case 10051u:
    case 10052u:
    case 10053u:
    case 10054u:
    case 10055u:
    case 10056u:
    case 10057u:
    case 10058u:
    case 10059u:
    case 10060u:
    case 10061u:
    case 10062u:
    case 10063u:
    case 10064u:
    case 10065u:
    case 10066u:
    case 10067u:
    case 10068u:
    case 10069u:
    case 10070u:
    case 10071u:
    case 10072u:
    case 10073u:
    case 10074u:
    case 10075u:
    case 10076u:
    case 10077u:
    case 10078u:
    case 10079u:
    case 10080u:
    case 10081u:
    case 10082u:
    case 10083u:
    case 10084u:
    case 10085u:
    case 10086u:
    case 10087u:
    case 10132u:
    case 10133u:
    case 10134u:
    case 10135u:
    case 10136u:
    case 10137u:
    case 10138u:
    case 10139u:
    case 10140u:
    case 10141u:
    case 10142u:
    case 10143u:
    case 10144u:
    case 10145u:
    case 10146u:
    case 10147u:
    case 10148u:
    case 10149u:
    case 10150u:
    case 10151u:
    case 10152u:
    case 10153u:
    case 10154u:
    case 10155u:
    case 10156u:
    case 10157u:
    case 10158u:
    case 10159u:
    case 10160u:
    case 10161u:
    case 10162u:
    case 10163u:
    case 10164u:
    case 10165u:
    case 10166u:
    case 10167u:
    case 10168u:
    case 10169u:
    case 10170u:
    case 10171u:
    case 10172u:
    case 10173u:
    case 10174u:
    case 10175u:
    case 10176u:
    case 10177u:
    case 10178u:
    case 10179u:
    case 10180u:
    case 10183u:
    case 10184u:
    case 10185u:
    case 10186u:
    case 10187u:
    case 10188u:
    case 10189u:
    case 10190u:
    case 10191u:
    case 10192u:
    case 10193u:
    case 10194u:
    case 10195u:
    case 10196u:
    case 10197u:
    case 10198u:
    case 10199u:
    case 10200u:
    case 10201u:
    case 10202u:
    case 10203u:
    case 10204u:
    case 10205u:
    case 10206u:
    case 10207u:
    case 10208u:
    case 10209u:
    case 10210u:
    case 10211u:
    case 10212u:
    case 10213u:
    case 10224u:
    case 10225u:
    case 10226u:
    case 10227u:
    case 10228u:
    case 10229u:
    case 10230u:
    case 10231u:
    case 10232u:
    case 10233u:
    case 10234u:
    case 10235u:
    case 10236u:
    case 10237u:
    case 10238u:
    case 10239u:
    case 10240u:
    case 10241u:
    case 10242u:
    case 10243u:
    case 10244u:
    case 10245u:
    case 10246u:
    case 10247u:
    case 10248u:
    case 10249u:
    case 10250u:
    case 10251u:
    case 10252u:
    case 10253u:
    case 10254u:
    case 10255u:
    case 10256u:
    case 10257u:
    case 10258u:
    case 10259u:
    case 10260u:
    case 10261u:
    case 10262u:
    case 10263u:
    case 10264u:
    case 10265u:
    case 10266u:
    case 10267u:
    case 10268u:
    case 10269u:
    case 10270u:
    case 10271u:
    case 10272u:
    case 10273u:
    case 10274u:
    case 10275u:
    case 10276u:
    case 10277u:
    case 10278u:
    case 10279u:
    case 10280u:
    case 10281u:
    case 10282u:
    case 10283u:
    case 10284u:
    case 10285u:
    case 10286u:
    case 10287u:
    case 10288u:
    case 10289u:
    case 10290u:
    case 10291u:
    case 10292u:
    case 10293u:
    case 10294u:
    case 10295u:
    case 10296u:
    case 10297u:
    case 10298u:
    case 10299u:
    case 10300u:
    case 10301u:
    case 10302u:
    case 10303u:
    case 10304u:
    case 10305u:
    case 10306u:
    case 10307u:
    case 10308u:
    case 10309u:
    case 10310u:
    case 10311u:
    case 10312u:
    case 10313u:
    case 10314u:
    case 10315u:
    case 10316u:
    case 10317u:
    case 10318u:
    case 10319u:
    case 10320u:
    case 10321u:
    case 10322u:
    case 10323u:
    case 10324u:
    case 10325u:
    case 10326u:
    case 10327u:
    case 10328u:
    case 10329u:
    case 10330u:
    case 10331u:
    case 10332u:
    case 10333u:
    case 10334u:
    case 10335u:
    case 10336u:
    case 10337u:
    case 10338u:
    case 10339u:
    case 10340u:
    case 10341u:
    case 10342u:
    case 10343u:
    case 10344u:
    case 10345u:
    case 10346u:
    case 10347u:
    case 10348u:
    case 10349u:
    case 10350u:
    case 10351u:
    case 10352u:
    case 10353u:
    case 10354u:
    case 10355u:
    case 10356u:
    case 10357u:
    case 10358u:
    case 10359u:
    case 10360u:
    case 10361u:
    case 10362u:
    case 10363u:
    case 10364u:
    case 10365u:
    case 10366u:
    case 10367u:
    case 10368u:
    case 10369u:
    case 10370u:
    case 10371u:
    case 10372u:
    case 10373u:
    case 10374u:
    case 10375u:
    case 10376u:
    case 10377u:
    case 10378u:
    case 10379u:
    case 10380u:
    case 10381u:
    case 10382u:
    case 10383u:
    case 10384u:
    case 10385u:
    case 10386u:
    case 10387u:
    case 10388u:
    case 10389u:
    case 10390u:
    case 10391u:
    case 10392u:
    case 10393u:
    case 10394u:
    case 10395u:
    case 10396u:
    case 10397u:
    case 10398u:
    case 10399u:
    case 10400u:
    case 10401u:
    case 10402u:
    case 10403u:
    case 10404u:
    case 10405u:
    case 10406u:
    case 10407u:
    case 10408u:
    case 10409u:
    case 10410u:
    case 10411u:
    case 10412u:
    case 10413u:
    case 10414u:
    case 10415u:
    case 10416u:
    case 10417u:
    case 10418u:
    case 10419u:
    case 10420u:
    case 10421u:
    case 10422u:
    case 10423u:
    case 10424u:
    case 10425u:
    case 10426u:
    case 10427u:
    case 10428u:
    case 10429u:
    case 10430u:
    case 10431u:
    case 10432u:
    case 10433u:
    case 10434u:
    case 10435u:
    case 10436u:
    case 10437u:
    case 10438u:
    case 10439u:
    case 10440u:
    case 10441u:
    case 10442u:
    case 10443u:
    case 10444u:
    case 10445u:
    case 10446u:
    case 10447u:
    case 10448u:
    case 10449u:
    case 10450u:
    case 10451u:
    case 10452u:
    case 10453u:
    case 10454u:
    case 10455u:
    case 10456u:
    case 10457u:
    case 10458u:
    case 10459u:
    case 10460u:
    case 10461u:
    case 10462u:
    case 10463u:
    case 10464u:
    case 10465u:
    case 10466u:
    case 10467u:
    case 10468u:
    case 10469u:
    case 10470u:
    case 10471u:
    case 10472u:
    case 10473u:
    case 10474u:
    case 10475u:
    case 10476u:
    case 10477u:
    case 10478u:
    case 10479u:
    case 10480u:
    case 10481u:
    case 10482u:
    case 10483u:
    case 10484u:
    case 10485u:
    case 10486u:
    case 10487u:
    case 10488u:
    case 10489u:
    case 10490u:
    case 10491u:
    case 10492u:
    case 10493u:
    case 10494u:
    case 10495u:
    case 10496u:
    case 10497u:
    case 10498u:
    case 10499u:
    case 10500u:
    case 10501u:
    case 10502u:
    case 10503u:
    case 10504u:
    case 10505u:
    case 10506u:
    case 10507u:
    case 10508u:
    case 10509u:
    case 10510u:
    case 10511u:
    case 10512u:
    case 10513u:
    case 10514u:
    case 10515u:
    case 10516u:
    case 10517u:
    case 10518u:
    case 10519u:
    case 10520u:
    case 10525u:
    case 10526u:
    case 10527u:
    case 10528u:
    case 10529u:
    case 10530u:
    case 10531u:
    case 10532u:
    case 10533u:
    case 10534u:
    case 10535u:
    case 10536u:
    case 10537u:
    case 10538u:
    case 10539u:
    case 10540u:
    case 10541u:
    case 10542u:
    case 10543u:
    case 10544u:
    case 10545u:
    case 10546u:
    case 10547u:
    case 10548u:
    case 10549u:
    case 10550u:
    case 10551u:
    case 10552u:
    case 10553u:
    case 10554u:
    case 10555u:
    case 10556u:
    case 10557u:
    case 10558u:
    case 10559u:
    case 10560u:
    case 10561u:
    case 10562u:
    case 10563u:
    case 10564u:
    case 10565u:
    case 10566u:
    case 10567u:
    case 10568u:
    case 10569u:
    case 10570u:
    case 10571u:
    case 10572u:
    case 10573u:
    case 10574u:
    case 10575u:
    case 10576u:
    case 10577u:
    case 10578u:
    case 10579u:
    case 10580u:
    case 10581u:
    case 10582u:
    case 10583u:
    case 10584u:
    case 10585u:
    case 10586u:
    case 10587u:
    case 10588u:
    case 10589u:
    case 10590u:
    case 10591u:
    case 10592u:
    case 10593u:
    case 10594u:
    case 10595u:
    case 10596u:
    case 10597u:
    case 10598u:
    case 10599u:
    case 10600u:
    case 10601u:
    case 10602u:
    case 10603u:
    case 10604u:
    case 10605u:
    case 10606u:
    case 10607u:
    case 10608u:
    case 10609u:
    case 10610u:
    case 10611u:
    case 10612u:
    case 10613u:
    case 10614u:
    case 10615u:
    case 10616u:
    case 10617u:
    case 10618u:
    case 10619u:
    case 10620u:
    case 10621u:
    case 10622u:
    case 10623u:
    case 10624u:
    case 10625u:
    case 10626u:
    case 10649u:
    case 10650u:
    case 10651u:
    case 10652u:
    case 10653u:
    case 10654u:
    case 10655u:
    case 10656u:
    case 10657u:
    case 10658u:
    case 10659u:
    case 10660u:
    case 10661u:
    case 10662u:
    case 10663u:
    case 10664u:
    case 10665u:
    case 10666u:
    case 10667u:
    case 10668u:
    case 10669u:
    case 10670u:
    case 10671u:
    case 10672u:
    case 10673u:
    case 10674u:
    case 10675u:
    case 10676u:
    case 10677u:
    case 10678u:
    case 10679u:
    case 10680u:
    case 10681u:
    case 10682u:
    case 10683u:
    case 10684u:
    case 10685u:
    case 10686u:
    case 10687u:
    case 10688u:
    case 10689u:
    case 10690u:
    case 10691u:
    case 10692u:
    case 10693u:
    case 10694u:
    case 10695u:
    case 10696u:
    case 10697u:
    case 10698u:
    case 10699u:
    case 10700u:
    case 10701u:
    case 10702u:
    case 10703u:
    case 10704u:
    case 10705u:
    case 10706u:
    case 10707u:
    case 10708u:
    case 10709u:
    case 10710u:
    case 10711u:
    case 10716u:
    case 10717u:
    case 10718u:
    case 10719u:
    case 10720u:
    case 10721u:
    case 10722u:
    case 10723u:
    case 10724u:
    case 10725u:
    case 10726u:
    case 10727u:
    case 10728u:
    case 10729u:
    case 10730u:
    case 10731u:
    case 10732u:
    case 10733u:
    case 10734u:
    case 10735u:
    case 10736u:
    case 10737u:
    case 10738u:
    case 10739u:
    case 10740u:
    case 10741u:
    case 10742u:
    case 10743u:
    case 10744u:
    case 10745u:
    case 10746u:
    case 10747u:
    case 10750u:
    case 10751u:
    case 10752u:
    case 10753u:
    case 10754u:
    case 10755u:
    case 10756u:
    case 10757u:
    case 10758u:
    case 10759u:
    case 10760u:
    case 10761u:
    case 10762u:
    case 10763u:
    case 10764u:
    case 10765u:
    case 10766u:
    case 10767u:
    case 10768u:
    case 10769u:
    case 10770u:
    case 10771u:
    case 10772u:
    case 10773u:
    case 10774u:
    case 10775u:
    case 10776u:
    case 10777u:
    case 10778u:
    case 10779u:
    case 10780u:
    case 10781u:
    case 10782u:
    case 10783u:
    case 10784u:
    case 10785u:
    case 10786u:
    case 10787u:
    case 10788u:
    case 10789u:
    case 10790u:
    case 10791u:
    case 10792u:
    case 10793u:
    case 10794u:
    case 10795u:
    case 10796u:
    case 10797u:
    case 10798u:
    case 10799u:
    case 10800u:
    case 10801u:
    case 10802u:
    case 10803u:
    case 10804u:
    case 10805u:
    case 10806u:
    case 10807u:
    case 10808u:
    case 10809u:
    case 10810u:
    case 10811u:
    case 10812u:
    case 10813u:
    case 10814u:
    case 10815u:
    case 10816u:
    case 10817u:
    case 10818u:
    case 10819u:
    case 10820u:
    case 10821u:
    case 10822u:
    case 10823u:
    case 10824u:
    case 10825u:
    case 10826u:
    case 10827u:
    case 10828u:
    case 10829u:
    case 10830u:
    case 10831u:
    case 10832u:
    case 10833u:
    case 10834u:
    case 10835u:
    case 10836u:
    case 10837u:
    case 10838u:
    case 10839u:
    case 10840u:
    case 10841u:
    case 10842u:
    case 10843u:
    case 10844u:
    case 10845u:
    case 10846u:
    case 10847u:
    case 10848u:
    case 10849u:
    case 10850u:
    case 10851u:
    case 10852u:
    case 10853u:
    case 10854u:
    case 10855u:
    case 10856u:
    case 10857u:
    case 10858u:
    case 10859u:
    case 10860u:
    case 10861u:
    case 10862u:
    case 10863u:
    case 10864u:
    case 10865u:
    case 10866u:
    case 10867u:
    case 10868u:
    case 10869u:
    case 10870u:
    case 10871u:
    case 10872u:
    case 10873u:
    case 10874u:
    case 10875u:
    case 10876u:
    case 10877u:
    case 10878u:
    case 10879u:
    case 10880u:
    case 10881u:
    case 10882u:
    case 10883u:
    case 10884u:
    case 10885u:
    case 10886u:
    case 10887u:
    case 10888u:
    case 10889u:
    case 10890u:
    case 10891u:
    case 10892u:
    case 10893u:
    case 10894u:
    case 10895u:
    case 10896u:
    case 10897u:
    case 10898u:
    case 10899u:
    case 10900u:
    case 10901u:
    case 10902u:
    case 10903u:
    case 10904u:
    case 10905u:
    case 10906u:
    case 10907u:
    case 10908u:
    case 10909u:
    case 10910u:
    case 10911u:
    case 10912u:
    case 10913u:
    case 10914u:
    case 10915u:
    case 10916u:
    case 10917u:
    case 10918u:
    case 10919u:
    case 10920u:
    case 10921u:
    case 10922u:
    case 10923u:
    case 10924u:
    case 10925u:
    case 10926u:
    case 10927u:
    case 10928u:
    case 10929u:
    case 10930u:
    case 10931u:
    case 10932u:
    case 10933u:
    case 10934u:
    case 10935u:
    case 10936u:
    case 10937u:
    case 10938u:
    case 10939u:
    case 10940u:
    case 10941u:
    case 10942u:
    case 10943u:
    case 10944u:
    case 10945u:
    case 10946u:
    case 10947u:
    case 10948u:
    case 10949u:
    case 10950u:
    case 10951u:
    case 10952u:
    case 10953u:
    case 10954u:
    case 10955u:
    case 10956u:
    case 10957u:
    case 10958u:
    case 10959u:
    case 10960u:
    case 10961u:
    case 10962u:
    case 10963u:
    case 10964u:
    case 10965u:
    case 10966u:
    case 10967u:
    case 10968u:
    case 10969u:
    case 10970u:
    case 10971u:
    case 10972u:
    case 10973u:
    case 10974u:
    case 10975u:
    case 10976u:
    case 10977u:
    case 10978u:
    case 10979u:
    case 10980u:
    case 10981u:
    case 10982u:
    case 10983u:
    case 10984u:
    case 10985u:
    case 10986u:
    case 10987u:
    case 10988u:
    case 10989u:
    case 10990u:
    case 10991u:
    case 10992u:
    case 10993u:
    case 10994u:
    case 10995u:
    case 10996u:
    case 10997u:
    case 10998u:
    case 10999u:
    case 11000u:
    case 11001u:
    case 11002u:
    case 11003u:
    case 11004u:
    case 11005u:
    case 11006u:
    case 11007u:
    case 11008u:
    case 11009u:
    case 11010u:
    case 11011u:
    case 11012u:
    case 11013u:
    case 11014u:
    case 11015u:
    case 11016u:
    case 11017u:
    case 11018u:
    case 11019u:
    case 11020u:
    case 11021u:
    case 11022u:
    case 11023u:
    case 11024u:
    case 11025u:
    case 11026u:
    case 11027u:
    case 11028u:
    case 11029u:
    case 11030u:
    case 11031u:
    case 11032u:
    case 11033u:
    case 11034u:
    case 11035u:
    case 11036u:
    case 11037u:
    case 11038u:
    case 11039u:
    case 11040u:
    case 11041u:
    case 11042u:
    case 11043u:
    case 11044u:
    case 11045u:
    case 11046u:
    case 11047u:
    case 11048u:
    case 11049u:
    case 11050u:
    case 11051u:
    case 11052u:
    case 11053u:
    case 11054u:
    case 11055u:
    case 11056u:
    case 11057u:
    case 11058u:
    case 11059u:
    case 11060u:
    case 11061u:
    case 11062u:
    case 11063u:
    case 11064u:
    case 11065u:
    case 11066u:
    case 11067u:
    case 11068u:
    case 11069u:
    case 11070u:
    case 11071u:
    case 11072u:
    case 11073u:
    case 11074u:
    case 11075u:
    case 11076u:
    case 11077u:
    case 11078u:
    case 11079u:
    case 11080u:
    case 11081u:
    case 11082u:
    case 11083u:
    case 11084u:
    case 11088u:
    case 11089u:
    case 11090u:
    case 11091u:
    case 11092u:
    case 11093u:
    case 11094u:
    case 11095u:
    case 11096u:
    case 11097u:
    case 11493u:
    case 11494u:
    case 11495u:
    case 11496u:
    case 11497u:
    case 11498u:
    case 11513u:
    case 11514u:
    case 11515u:
    case 11516u:
    case 11518u:
    case 11519u:
    case 11632u:
    case 11776u:
    case 11777u:
    case 11782u:
    case 11783u:
    case 11784u:
    case 11787u:
    case 11790u:
    case 11791u:
    case 11792u:
    case 11793u:
    case 11794u:
    case 11795u:
    case 11796u:
    case 11797u:
    case 11798u:
    case 11799u:
    case 11800u:
    case 11801u:
    case 11802u:
    case 11803u:
    case 11806u:
    case 11807u:
    case 11818u:
    case 11819u:
    case 11820u:
    case 11821u:
    case 11822u:
    case 11824u:
    case 11825u:
    case 11826u:
    case 11827u:
    case 11828u:
    case 11829u:
    case 11830u:
    case 11831u:
    case 11832u:
    case 11833u:
    case 11834u:
    case 11835u:
    case 11904u:
    case 11905u:
    case 11906u:
    case 11907u:
    case 11908u:
    case 11909u:
    case 11910u:
    case 11911u:
    case 11912u:
    case 11913u:
    case 11914u:
    case 11915u:
    case 11916u:
    case 11917u:
    case 11918u:
    case 11919u:
    case 11920u:
    case 11921u:
    case 11922u:
    case 11923u:
    case 11924u:
    case 11925u:
    case 11926u:
    case 11927u:
    case 11928u:
    case 11929u:
    case 11931u:
    case 11932u:
    case 11933u:
    case 11934u:
    case 11935u:
    case 11936u:
    case 11937u:
    case 11938u:
    case 11939u:
    case 11940u:
    case 11941u:
    case 11942u:
    case 11943u:
    case 11944u:
    case 11945u:
    case 11946u:
    case 11947u:
    case 11948u:
    case 11949u:
    case 11950u:
    case 11951u:
    case 11952u:
    case 11953u:
    case 11954u:
    case 11955u:
    case 11956u:
    case 11957u:
    case 11958u:
    case 11959u:
    case 11960u:
    case 11961u:
    case 11962u:
    case 11963u:
    case 11964u:
    case 11965u:
    case 11966u:
    case 11967u:
    case 11968u:
    case 11969u:
    case 11970u:
    case 11971u:
    case 11972u:
    case 11973u:
    case 11974u:
    case 11975u:
    case 11976u:
    case 11977u:
    case 11978u:
    case 11979u:
    case 11980u:
    case 11981u:
    case 11982u:
    case 11983u:
    case 11984u:
    case 11985u:
    case 11986u:
    case 11987u:
    case 11988u:
    case 11989u:
    case 11990u:
    case 11991u:
    case 11992u:
    case 11993u:
    case 11994u:
    case 11995u:
    case 11996u:
    case 11997u:
    case 11998u:
    case 11999u:
    case 12000u:
    case 12001u:
    case 12002u:
    case 12003u:
    case 12004u:
    case 12005u:
    case 12006u:
    case 12007u:
    case 12008u:
    case 12009u:
    case 12010u:
    case 12011u:
    case 12012u:
    case 12013u:
    case 12014u:
    case 12015u:
    case 12016u:
    case 12017u:
    case 12018u:
    case 12019u:
    case 12032u:
    case 12033u:
    case 12034u:
    case 12035u:
    case 12036u:
    case 12037u:
    case 12038u:
    case 12039u:
    case 12040u:
    case 12041u:
    case 12042u:
    case 12043u:
    case 12044u:
    case 12045u:
    case 12046u:
    case 12047u:
    case 12048u:
    case 12049u:
    case 12050u:
    case 12051u:
    case 12052u:
    case 12053u:
    case 12054u:
    case 12055u:
    case 12056u:
    case 12057u:
    case 12058u:
    case 12059u:
    case 12060u:
    case 12061u:
    case 12062u:
    case 12063u:
    case 12064u:
    case 12065u:
    case 12066u:
    case 12067u:
    case 12068u:
    case 12069u:
    case 12070u:
    case 12071u:
    case 12072u:
    case 12073u:
    case 12074u:
    case 12075u:
    case 12076u:
    case 12077u:
    case 12078u:
    case 12079u:
    case 12080u:
    case 12081u:
    case 12082u:
    case 12083u:
    case 12084u:
    case 12085u:
    case 12086u:
    case 12087u:
    case 12088u:
    case 12089u:
    case 12090u:
    case 12091u:
    case 12092u:
    case 12093u:
    case 12094u:
    case 12095u:
    case 12096u:
    case 12097u:
    case 12098u:
    case 12099u:
    case 12100u:
    case 12101u:
    case 12102u:
    case 12103u:
    case 12104u:
    case 12105u:
    case 12106u:
    case 12107u:
    case 12108u:
    case 12109u:
    case 12110u:
    case 12111u:
    case 12112u:
    case 12113u:
    case 12114u:
    case 12115u:
    case 12116u:
    case 12117u:
    case 12118u:
    case 12119u:
    case 12120u:
    case 12121u:
    case 12122u:
    case 12123u:
    case 12124u:
    case 12125u:
    case 12126u:
    case 12127u:
    case 12128u:
    case 12129u:
    case 12130u:
    case 12131u:
    case 12132u:
    case 12133u:
    case 12134u:
    case 12135u:
    case 12136u:
    case 12137u:
    case 12138u:
    case 12139u:
    case 12140u:
    case 12141u:
    case 12142u:
    case 12143u:
    case 12144u:
    case 12145u:
    case 12146u:
    case 12147u:
    case 12148u:
    case 12149u:
    case 12150u:
    case 12151u:
    case 12152u:
    case 12153u:
    case 12154u:
    case 12155u:
    case 12156u:
    case 12157u:
    case 12158u:
    case 12159u:
    case 12160u:
    case 12161u:
    case 12162u:
    case 12163u:
    case 12164u:
    case 12165u:
    case 12166u:
    case 12167u:
    case 12168u:
    case 12169u:
    case 12170u:
    case 12171u:
    case 12172u:
    case 12173u:
    case 12174u:
    case 12175u:
    case 12176u:
    case 12177u:
    case 12178u:
    case 12179u:
    case 12180u:
    case 12181u:
    case 12182u:
    case 12183u:
    case 12184u:
    case 12185u:
    case 12186u:
    case 12187u:
    case 12188u:
    case 12189u:
    case 12190u:
    case 12191u:
    case 12192u:
    case 12193u:
    case 12194u:
    case 12195u:
    case 12196u:
    case 12197u:
    case 12198u:
    case 12199u:
    case 12200u:
    case 12201u:
    case 12202u:
    case 12203u:
    case 12204u:
    case 12205u:
    case 12206u:
    case 12207u:
    case 12208u:
    case 12209u:
    case 12210u:
    case 12211u:
    case 12212u:
    case 12213u:
    case 12214u:
    case 12215u:
    case 12216u:
    case 12217u:
    case 12218u:
    case 12219u:
    case 12220u:
    case 12221u:
    case 12222u:
    case 12223u:
    case 12224u:
    case 12225u:
    case 12226u:
    case 12227u:
    case 12228u:
    case 12229u:
    case 12230u:
    case 12231u:
    case 12232u:
    case 12233u:
    case 12234u:
    case 12235u:
    case 12236u:
    case 12237u:
    case 12238u:
    case 12239u:
    case 12240u:
    case 12241u:
    case 12242u:
    case 12243u:
    case 12244u:
    case 12245u:
    case 12272u:
    case 12273u:
    case 12274u:
    case 12275u:
    case 12276u:
    case 12277u:
    case 12278u:
    case 12279u:
    case 12280u:
    case 12281u:
    case 12282u:
    case 12283u:
    case 12289u:
    case 12290u:
    case 12291u:
    case 12292u:
    case 12306u:
    case 12307u:
    case 12316u:
    case 12320u:
    case 12336u:
    case 12342u:
    case 12343u:
    case 12349u:
    case 12350u:
    case 12351u:
    case 12443u:
    case 12444u:
    case 12448u:
    case 12539u:
    case 12688u:
    case 12689u:
    case 12694u:
    case 12695u:
    case 12696u:
    case 12697u:
    case 12698u:
    case 12699u:
    case 12700u:
    case 12701u:
    case 12702u:
    case 12703u:
    case 12736u:
    case 12737u:
    case 12738u:
    case 12739u:
    case 12740u:
    case 12741u:
    case 12742u:
    case 12743u:
    case 12744u:
    case 12745u:
    case 12746u:
    case 12747u:
    case 12748u:
    case 12749u:
    case 12750u:
    case 12751u:
    case 12752u:
    case 12753u:
    case 12754u:
    case 12755u:
    case 12756u:
    case 12757u:
    case 12758u:
    case 12759u:
    case 12760u:
    case 12761u:
    case 12762u:
    case 12763u:
    case 12764u:
    case 12765u:
    case 12766u:
    case 12767u:
    case 12768u:
    case 12769u:
    case 12770u:
    case 12771u:
    case 12800u:
    case 12801u:
    case 12802u:
    case 12803u:
    case 12804u:
    case 12805u:
    case 12806u:
    case 12807u:
    case 12808u:
    case 12809u:
    case 12810u:
    case 12811u:
    case 12812u:
    case 12813u:
    case 12814u:
    case 12815u:
    case 12816u:
    case 12817u:
    case 12818u:
    case 12819u:
    case 12820u:
    case 12821u:
    case 12822u:
    case 12823u:
    case 12824u:
    case 12825u:
    case 12826u:
    case 12827u:
    case 12828u:
    case 12829u:
    case 12830u:
    case 12842u:
    case 12843u:
    case 12844u:
    case 12845u:
    case 12846u:
    case 12847u:
    case 12848u:
    case 12849u:
    case 12850u:
    case 12851u:
    case 12852u:
    case 12853u:
    case 12854u:
    case 12855u:
    case 12856u:
    case 12857u:
    case 12858u:
    case 12859u:
    case 12860u:
    case 12861u:
    case 12862u:
    case 12863u:
    case 12864u:
    case 12865u:
    case 12866u:
    case 12867u:
    case 12868u:
    case 12869u:
    case 12870u:
    case 12871u:
    case 12880u:
    case 12896u:
    case 12897u:
    case 12898u:
    case 12899u:
    case 12900u:
    case 12901u:
    case 12902u:
    case 12903u:
    case 12904u:
    case 12905u:
    case 12906u:
    case 12907u:
    case 12908u:
    case 12909u:
    case 12910u:
    case 12911u:
    case 12912u:
    case 12913u:
    case 12914u:
    case 12915u:
    case 12916u:
    case 12917u:
    case 12918u:
    case 12919u:
    case 12920u:
    case 12921u:
    case 12922u:
    case 12923u:
    case 12924u:
    case 12925u:
    case 12926u:
    case 12927u:
    case 12938u:
    case 12939u:
    case 12940u:
    case 12941u:
    case 12942u:
    case 12943u:
    case 12944u:
    case 12945u:
    case 12946u:
    case 12947u:
    case 12948u:
    case 12949u:
    case 12950u:
    case 12951u:
    case 12952u:
    case 12953u:
    case 12954u:
    case 12955u:
    case 12956u:
    case 12957u:
    case 12958u:
    case 12959u:
    case 12960u:
    case 12961u:
    case 12962u:
    case 12963u:
    case 12964u:
    case 12965u:
    case 12966u:
    case 12967u:
    case 12968u:
    case 12969u:
    case 12970u:
    case 12971u:
    case 12972u:
    case 12973u:
    case 12974u:
    case 12975u:
    case 12976u:
    case 12992u:
    case 12993u:
    case 12994u:
    case 12995u:
    case 12996u:
    case 12997u:
    case 12998u:
    case 12999u:
    case 13000u:
    case 13001u:
    case 13002u:
    case 13003u:
    case 13004u:
    case 13005u:
    case 13006u:
    case 13007u:
    case 13008u:
    case 13009u:
    case 13010u:
    case 13011u:
    case 13012u:
    case 13013u:
    case 13014u:
    case 13015u:
    case 13016u:
    case 13017u:
    case 13018u:
    case 13019u:
    case 13020u:
    case 13021u:
    case 13022u:
    case 13023u:
    case 13024u:
    case 13025u:
    case 13026u:
    case 13027u:
    case 13028u:
    case 13029u:
    case 13030u:
    case 13031u:
    case 13032u:
    case 13033u:
    case 13034u:
    case 13035u:
    case 13036u:
    case 13037u:
    case 13038u:
    case 13039u:
    case 13040u:
    case 13041u:
    case 13042u:
    case 13043u:
    case 13044u:
    case 13045u:
    case 13046u:
    case 13047u:
    case 13048u:
    case 13049u:
    case 13050u:
    case 13051u:
    case 13052u:
    case 13053u:
    case 13054u:
    case 13056u:
    case 13057u:
    case 13058u:
    case 13059u:
    case 13060u:
    case 13061u:
    case 13062u:
    case 13063u:
    case 13064u:
    case 13065u:
    case 13066u:
    case 13067u:
    case 13068u:
    case 13069u:
    case 13070u:
    case 13071u:
    case 13072u:
    case 13073u:
    case 13074u:
    case 13075u:
    case 13076u:
    case 13077u:
    case 13078u:
    case 13079u:
    case 13080u:
    case 13081u:
    case 13082u:
    case 13083u:
    case 13084u:
    case 13085u:
    case 13086u:
    case 13087u:
    case 13088u:
    case 13089u:
    case 13090u:
    case 13091u:
    case 13092u:
    case 13093u:
    case 13094u:
    case 13095u:
    case 13096u:
    case 13097u:
    case 13098u:
    case 13099u:
    case 13100u:
    case 13101u:
    case 13102u:
    case 13103u:
    case 13104u:
    case 13105u:
    case 13106u:
    case 13107u:
    case 13108u:
    case 13109u:
    case 13110u:
    case 13111u:
    case 13112u:
    case 13113u:
    case 13114u:
    case 13115u:
    case 13116u:
    case 13117u:
    case 13118u:
    case 13119u:
    case 13120u:
    case 13121u:
    case 13122u:
    case 13123u:
    case 13124u:
    case 13125u:
    case 13126u:
    case 13127u:
    case 13128u:
    case 13129u:
    case 13130u:
    case 13131u:
    case 13132u:
    case 13133u:
    case 13134u:
    case 13135u:
    case 13136u:
    case 13137u:
    case 13138u:
    case 13139u:
    case 13140u:
    case 13141u:
    case 13142u:
    case 13143u:
    case 13144u:
    case 13145u:
    case 13146u:
    case 13147u:
    case 13148u:
    case 13149u:
    case 13150u:
    case 13151u:
    case 13152u:
    case 13153u:
    case 13154u:
    case 13155u:
    case 13156u:
    case 13157u:
    case 13158u:
    case 13159u:
    case 13160u:
    case 13161u:
    case 13162u:
    case 13163u:
    case 13164u:
    case 13165u:
    case 13166u:
    case 13167u:
    case 13168u:
    case 13169u:
    case 13170u:
    case 13171u:
    case 13172u:
    case 13173u:
    case 13174u:
    case 13175u:
    case 13176u:
    case 13177u:
    case 13178u:
    case 13179u:
    case 13180u:
    case 13181u:
    case 13182u:
    case 13183u:
    case 13184u:
    case 13185u:
    case 13186u:
    case 13187u:
    case 13188u:
    case 13189u:
    case 13190u:
    case 13191u:
    case 13192u:
    case 13193u:
    case 13194u:
    case 13195u:
    case 13196u:
    case 13197u:
    case 13198u:
    case 13199u:
    case 13200u:
    case 13201u:
    case 13202u:
    case 13203u:
    case 13204u:
    case 13205u:
    case 13206u:
    case 13207u:
    case 13208u:
    case 13209u:
    case 13210u:
    case 13211u:
    case 13212u:
    case 13213u:
    case 13214u:
    case 13215u:
    case 13216u:
    case 13217u:
    case 13218u:
    case 13219u:
    case 13220u:
    case 13221u:
    case 13222u:
    case 13223u:
    case 13224u:
    case 13225u:
    case 13226u:
    case 13227u:
    case 13228u:
    case 13229u:
    case 13230u:
    case 13231u:
    case 13232u:
    case 13233u:
    case 13234u:
    case 13235u:
    case 13236u:
    case 13237u:
    case 13238u:
    case 13239u:
    case 13240u:
    case 13241u:
    case 13242u:
    case 13243u:
    case 13244u:
    case 13245u:
    case 13246u:
    case 13247u:
    case 13248u:
    case 13249u:
    case 13250u:
    case 13251u:
    case 13252u:
    case 13253u:
    case 13254u:
    case 13255u:
    case 13256u:
    case 13257u:
    case 13258u:
    case 13259u:
    case 13260u:
    case 13261u:
    case 13262u:
    case 13263u:
    case 13264u:
    case 13265u:
    case 13266u:
    case 13267u:
    case 13268u:
    case 13269u:
    case 13270u:
    case 13271u:
    case 13272u:
    case 13273u:
    case 13274u:
    case 13275u:
    case 13276u:
    case 13277u:
    case 13278u:
    case 13279u:
    case 13280u:
    case 13281u:
    case 13282u:
    case 13283u:
    case 13284u:
    case 13285u:
    case 13286u:
    case 13287u:
    case 13288u:
    case 13289u:
    case 13290u:
    case 13291u:
    case 13292u:
    case 13293u:
    case 13294u:
    case 13295u:
    case 13296u:
    case 13297u:
    case 13298u:
    case 13299u:
    case 13300u:
    case 13301u:
    case 13302u:
    case 13303u:
    case 13304u:
    case 13305u:
    case 13306u:
    case 13307u:
    case 13308u:
    case 13309u:
    case 13310u:
    case 13311u:
    case 19904u:
    case 19905u:
    case 19906u:
    case 19907u:
    case 19908u:
    case 19909u:
    case 19910u:
    case 19911u:
    case 19912u:
    case 19913u:
    case 19914u:
    case 19915u:
    case 19916u:
    case 19917u:
    case 19918u:
    case 19919u:
    case 19920u:
    case 19921u:
    case 19922u:
    case 19923u:
    case 19924u:
    case 19925u:
    case 19926u:
    case 19927u:
    case 19928u:
    case 19929u:
    case 19930u:
    case 19931u:
    case 19932u:
    case 19933u:
    case 19934u:
    case 19935u:
    case 19936u:
    case 19937u:
    case 19938u:
    case 19939u:
    case 19940u:
    case 19941u:
    case 19942u:
    case 19943u:
    case 19944u:
    case 19945u:
    case 19946u:
    case 19947u:
    case 19948u:
    case 19949u:
    case 19950u:
    case 19951u:
    case 19952u:
    case 19953u:
    case 19954u:
    case 19955u:
    case 19956u:
    case 19957u:
    case 19958u:
    case 19959u:
    case 19960u:
    case 19961u:
    case 19962u:
    case 19963u:
    case 19964u:
    case 19965u:
    case 19966u:
    case 19967u:
    case 42128u:
    case 42129u:
    case 42130u:
    case 42131u:
    case 42132u:
    case 42133u:
    case 42134u:
    case 42135u:
    case 42136u:
    case 42137u:
    case 42138u:
    case 42139u:
    case 42140u:
    case 42141u:
    case 42142u:
    case 42143u:
    case 42144u:
    case 42145u:
    case 42146u:
    case 42147u:
    case 42148u:
    case 42149u:
    case 42150u:
    case 42151u:
    case 42152u:
    case 42153u:
    case 42154u:
    case 42155u:
    case 42156u:
    case 42157u:
    case 42158u:
    case 42159u:
    case 42160u:
    case 42161u:
    case 42162u:
    case 42163u:
    case 42164u:
    case 42165u:
    case 42166u:
    case 42167u:
    case 42168u:
    case 42169u:
    case 42170u:
    case 42171u:
    case 42172u:
    case 42173u:
    case 42174u:
    case 42175u:
    case 42176u:
    case 42177u:
    case 42178u:
    case 42179u:
    case 42180u:
    case 42181u:
    case 42182u:
    case 42238u:
    case 42239u:
    case 42509u:
    case 42510u:
    case 42511u:
    case 42611u:
    case 42622u:
    case 42738u:
    case 42739u:
    case 42740u:
    case 42741u:
    case 42742u:
    case 42743u:
    case 42752u:
    case 42753u:
    case 42754u:
    case 42755u:
    case 42756u:
    case 42757u:
    case 42758u:
    case 42759u:
    case 42760u:
    case 42761u:
    case 42762u:
    case 42763u:
    case 42764u:
    case 42765u:
    case 42766u:
    case 42767u:
    case 42768u:
    case 42769u:
    case 42770u:
    case 42771u:
    case 42772u:
    case 42773u:
    case 42774u:
    case 42784u:
    case 42785u:
    case 42889u:
    case 42890u:
    case 43048u:
    case 43049u:
    case 43050u:
    case 43051u:
    case 43062u:
    case 43063u:
    case 43064u:
    case 43065u:
    case 43124u:
    case 43125u:
    case 43126u:
    case 43127u:
    case 43214u:
    case 43215u:
    case 43256u:
    case 43257u:
    case 43258u:
    case 43310u:
    case 43311u:
    case 43359u:
    case 43457u:
    case 43458u:
    case 43459u:
    case 43460u:
    case 43461u:
    case 43462u:
    case 43463u:
    case 43464u:
    case 43465u:
    case 43466u:
    case 43467u:
    case 43468u:
    case 43469u:
    case 43486u:
    case 43487u:
    case 43612u:
    case 43613u:
    case 43614u:
    case 43615u:
    case 43639u:
    case 43640u:
    case 43641u:
    case 43742u:
    case 43743u:
    case 43760u:
    case 43761u:
    case 44011u:
    case 64297u:
    case 64434u:
    case 64435u:
    case 64436u:
    case 64437u:
    case 64438u:
    case 64439u:
    case 64440u:
    case 64441u:
    case 64442u:
    case 64443u:
    case 64444u:
    case 64445u:
    case 64446u:
    case 64447u:
    case 64448u:
    case 64449u:
    case 65020u:
    case 65021u:
    case 65040u:
    case 65041u:
    case 65042u:
    case 65043u:
    case 65044u:
    case 65045u:
    case 65046u:
    case 65049u:
    case 65072u:
    case 65073u:
    case 65074u:
    case 65075u:
    case 65076u:
    case 65093u:
    case 65094u:
    case 65097u:
    case 65098u:
    case 65099u:
    case 65100u:
    case 65101u:
    case 65102u:
    case 65103u:
    case 65104u:
    case 65105u:
    case 65106u:
    case 65108u:
    case 65109u:
    case 65110u:
    case 65111u:
    case 65112u:
    case 65119u:
    case 65120u:
    case 65121u:
    case 65122u:
    case 65123u:
    case 65124u:
    case 65125u:
    case 65126u:
    case 65128u:
    case 65129u:
    case 65130u:
    case 65131u:
    case 65281u:
    case 65282u:
    case 65283u:
    case 65284u:
    case 65285u:
    case 65286u:
    case 65287u:
    case 65290u:
    case 65291u:
    case 65292u:
    case 65293u:
    case 65294u:
    case 65295u:
    case 65306u:
    case 65307u:
    case 65308u:
    case 65309u:
    case 65310u:
    case 65311u:
    case 65312u:
    case 65340u:
    case 65342u:
    case 65343u:
    case 65344u:
    case 65372u:
    case 65374u:
    case 65377u:
    case 65380u:
    case 65381u:
    case 65504u:
    case 65505u:
    case 65506u:
    case 65507u:
    case 65508u:
    case 65509u:
    case 65510u:
    case 65512u:
    case 65513u:
    case 65514u:
    case 65515u:
    case 65516u:
    case 65517u:
    case 65518u:
    case 65532u:
    case 65533u:
    case 65792u:
    case 65793u:
    case 65794u:
    case 65847u:
    case 65848u:
    case 65849u:
    case 65850u:
    case 65851u:
    case 65852u:
    case 65853u:
    case 65854u:
    case 65855u:
    case 65913u:
    case 65914u:
    case 65915u:
    case 65916u:
    case 65917u:
    case 65918u:
    case 65919u:
    case 65920u:
    case 65921u:
    case 65922u:
    case 65923u:
    case 65924u:
    case 65925u:
    case 65926u:
    case 65927u:
    case 65928u:
    case 65929u:
    case 65936u:
    case 65937u:
    case 65938u:
    case 65939u:
    case 65940u:
    case 65941u:
    case 65942u:
    case 65943u:
    case 65944u:
    case 65945u:
    case 65946u:
    case 65947u:
    case 66000u:
    case 66001u:
    case 66002u:
    case 66003u:
    case 66004u:
    case 66005u:
    case 66006u:
    case 66007u:
    case 66008u:
    case 66009u:
    case 66010u:
    case 66011u:
    case 66012u:
    case 66013u:
    case 66014u:
    case 66015u:
    case 66016u:
    case 66017u:
    case 66018u:
    case 66019u:
    case 66020u:
    case 66021u:
    case 66022u:
    case 66023u:
    case 66024u:
    case 66025u:
    case 66026u:
    case 66027u:
    case 66028u:
    case 66029u:
    case 66030u:
    case 66031u:
    case 66032u:
    case 66033u:
    case 66034u:
    case 66035u:
    case 66036u:
    case 66037u:
    case 66038u:
    case 66039u:
    case 66040u:
    case 66041u:
    case 66042u:
    case 66043u:
    case 66044u:
    case 66463u:
    case 66512u:
    case 67671u:
    case 67871u:
    case 67903u:
    case 68176u:
    case 68177u:
    case 68178u:
    case 68179u:
    case 68180u:
    case 68181u:
    case 68182u:
    case 68183u:
    case 68184u:
    case 68223u:
    case 68409u:
    case 68410u:
    case 68411u:
    case 68412u:
    case 68413u:
    case 68414u:
    case 68415u:
    case 69703u:
    case 69704u:
    case 69705u:
    case 69706u:
    case 69707u:
    case 69708u:
    case 69709u:
    case 69819u:
    case 69820u:
    case 69822u:
    case 69823u:
    case 69824u:
    case 69825u:
    case 69952u:
    case 69953u:
    case 69954u:
    case 69955u:
    case 70085u:
    case 70086u:
    case 70087u:
    case 70088u:
    case 74864u:
    case 74865u:
    case 74866u:
    case 74867u:
    case 118784u:
    case 118785u:
    case 118786u:
    case 118787u:
    case 118788u:
    case 118789u:
    case 118790u:
    case 118791u:
    case 118792u:
    case 118793u:
    case 118794u:
    case 118795u:
    case 118796u:
    case 118797u:
    case 118798u:
    case 118799u:
    case 118800u:
    case 118801u:
    case 118802u:
    case 118803u:
    case 118804u:
    case 118805u:
    case 118806u:
    case 118807u:
    case 118808u:
    case 118809u:
    case 118810u:
    case 118811u:
    case 118812u:
    case 118813u:
    case 118814u:
    case 118815u:
    case 118816u:
    case 118817u:
    case 118818u:
    case 118819u:
    case 118820u:
    case 118821u:
    case 118822u:
    case 118823u:
    case 118824u:
    case 118825u:
    case 118826u:
    case 118827u:
    case 118828u:
    case 118829u:
    case 118830u:
    case 118831u:
    case 118832u:
    case 118833u:
    case 118834u:
    case 118835u:
    case 118836u:
    case 118837u:
    case 118838u:
    case 118839u:
    case 118840u:
    case 118841u:
    case 118842u:
    case 118843u:
    case 118844u:
    case 118845u:
    case 118846u:
    case 118847u:
    case 118848u:
    case 118849u:
    case 118850u:
    case 118851u:
    case 118852u:
    case 118853u:
    case 118854u:
    case 118855u:
    case 118856u:
    case 118857u:
    case 118858u:
    case 118859u:
    case 118860u:
    case 118861u:
    case 118862u:
    case 118863u:
    case 118864u:
    case 118865u:
    case 118866u:
    case 118867u:
    case 118868u:
    case 118869u:
    case 118870u:
    case 118871u:
    case 118872u:
    case 118873u:
    case 118874u:
    case 118875u:
    case 118876u:
    case 118877u:
    case 118878u:
    case 118879u:
    case 118880u:
    case 118881u:
    case 118882u:
    case 118883u:
    case 118884u:
    case 118885u:
    case 118886u:
    case 118887u:
    case 118888u:
    case 118889u:
    case 118890u:
    case 118891u:
    case 118892u:
    case 118893u:
    case 118894u:
    case 118895u:
    case 118896u:
    case 118897u:
    case 118898u:
    case 118899u:
    case 118900u:
    case 118901u:
    case 118902u:
    case 118903u:
    case 118904u:
    case 118905u:
    case 118906u:
    case 118907u:
    case 118908u:
    case 118909u:
    case 118910u:
    case 118911u:
    case 118912u:
    case 118913u:
    case 118914u:
    case 118915u:
    case 118916u:
    case 118917u:
    case 118918u:
    case 118919u:
    case 118920u:
    case 118921u:
    case 118922u:
    case 118923u:
    case 118924u:
    case 118925u:
    case 118926u:
    case 118927u:
    case 118928u:
    case 118929u:
    case 118930u:
    case 118931u:
    case 118932u:
    case 118933u:
    case 118934u:
    case 118935u:
    case 118936u:
    case 118937u:
    case 118938u:
    case 118939u:
    case 118940u:
    case 118941u:
    case 118942u:
    case 118943u:
    case 118944u:
    case 118945u:
    case 118946u:
    case 118947u:
    case 118948u:
    case 118949u:
    case 118950u:
    case 118951u:
    case 118952u:
    case 118953u:
    case 118954u:
    case 118955u:
    case 118956u:
    case 118957u:
    case 118958u:
    case 118959u:
    case 118960u:
    case 118961u:
    case 118962u:
    case 118963u:
    case 118964u:
    case 118965u:
    case 118966u:
    case 118967u:
    case 118968u:
    case 118969u:
    case 118970u:
    case 118971u:
    case 118972u:
    case 118973u:
    case 118974u:
    case 118975u:
    case 118976u:
    case 118977u:
    case 118978u:
    case 118979u:
    case 118980u:
    case 118981u:
    case 118982u:
    case 118983u:
    case 118984u:
    case 118985u:
    case 118986u:
    case 118987u:
    case 118988u:
    case 118989u:
    case 118990u:
    case 118991u:
    case 118992u:
    case 118993u:
    case 118994u:
    case 118995u:
    case 118996u:
    case 118997u:
    case 118998u:
    case 118999u:
    case 119000u:
    case 119001u:
    case 119002u:
    case 119003u:
    case 119004u:
    case 119005u:
    case 119006u:
    case 119007u:
    case 119008u:
    case 119009u:
    case 119010u:
    case 119011u:
    case 119012u:
    case 119013u:
    case 119014u:
    case 119015u:
    case 119016u:
    case 119017u:
    case 119018u:
    case 119019u:
    case 119020u:
    case 119021u:
    case 119022u:
    case 119023u:
    case 119024u:
    case 119025u:
    case 119026u:
    case 119027u:
    case 119028u:
    case 119029u:
    case 119040u:
    case 119041u:
    case 119042u:
    case 119043u:
    case 119044u:
    case 119045u:
    case 119046u:
    case 119047u:
    case 119048u:
    case 119049u:
    case 119050u:
    case 119051u:
    case 119052u:
    case 119053u:
    case 119054u:
    case 119055u:
    case 119056u:
    case 119057u:
    case 119058u:
    case 119059u:
    case 119060u:
    case 119061u:
    case 119062u:
    case 119063u:
    case 119064u:
    case 119065u:
    case 119066u:
    case 119067u:
    case 119068u:
    case 119069u:
    case 119070u:
    case 119071u:
    case 119072u:
    case 119073u:
    case 119074u:
    case 119075u:
    case 119076u:
    case 119077u:
    case 119078u:
    case 119081u:
    case 119082u:
    case 119083u:
    case 119084u:
    case 119085u:
    case 119086u:
    case 119087u:
    case 119088u:
    case 119089u:
    case 119090u:
    case 119091u:
    case 119092u:
    case 119093u:
    case 119094u:
    case 119095u:
    case 119096u:
    case 119097u:
    case 119098u:
    case 119099u:
    case 119100u:
    case 119101u:
    case 119102u:
    case 119103u:
    case 119104u:
    case 119105u:
    case 119106u:
    case 119107u:
    case 119108u:
    case 119109u:
    case 119110u:
    case 119111u:
    case 119112u:
    case 119113u:
    case 119114u:
    case 119115u:
    case 119116u:
    case 119117u:
    case 119118u:
    case 119119u:
    case 119120u:
    case 119121u:
    case 119122u:
    case 119123u:
    case 119124u:
    case 119125u:
    case 119126u:
    case 119127u:
    case 119128u:
    case 119129u:
    case 119130u:
    case 119131u:
    case 119132u:
    case 119133u:
    case 119134u:
    case 119135u:
    case 119136u:
    case 119137u:
    case 119138u:
    case 119139u:
    case 119140u:
    case 119146u:
    case 119147u:
    case 119148u:
    case 119171u:
    case 119172u:
    case 119180u:
    case 119181u:
    case 119182u:
    case 119183u:
    case 119184u:
    case 119185u:
    case 119186u:
    case 119187u:
    case 119188u:
    case 119189u:
    case 119190u:
    case 119191u:
    case 119192u:
    case 119193u:
    case 119194u:
    case 119195u:
    case 119196u:
    case 119197u:
    case 119198u:
    case 119199u:
    case 119200u:
    case 119201u:
    case 119202u:
    case 119203u:
    case 119204u:
    case 119205u:
    case 119206u:
    case 119207u:
    case 119208u:
    case 119209u:
    case 119214u:
    case 119215u:
    case 119216u:
    case 119217u:
    case 119218u:
    case 119219u:
    case 119220u:
    case 119221u:
    case 119222u:
    case 119223u:
    case 119224u:
    case 119225u:
    case 119226u:
    case 119227u:
    case 119228u:
    case 119229u:
    case 119230u:
    case 119231u:
    case 119232u:
    case 119233u:
    case 119234u:
    case 119235u:
    case 119236u:
    case 119237u:
    case 119238u:
    case 119239u:
    case 119240u:
    case 119241u:
    case 119242u:
    case 119243u:
    case 119244u:
    case 119245u:
    case 119246u:
    case 119247u:
    case 119248u:
    case 119249u:
    case 119250u:
    case 119251u:
    case 119252u:
    case 119253u:
    case 119254u:
    case 119255u:
    case 119256u:
    case 119257u:
    case 119258u:
    case 119259u:
    case 119260u:
    case 119261u:
    case 119296u:
    case 119297u:
    case 119298u:
    case 119299u:
    case 119300u:
    case 119301u:
    case 119302u:
    case 119303u:
    case 119304u:
    case 119305u:
    case 119306u:
    case 119307u:
    case 119308u:
    case 119309u:
    case 119310u:
    case 119311u:
    case 119312u:
    case 119313u:
    case 119314u:
    case 119315u:
    case 119316u:
    case 119317u:
    case 119318u:
    case 119319u:
    case 119320u:
    case 119321u:
    case 119322u:
    case 119323u:
    case 119324u:
    case 119325u:
    case 119326u:
    case 119327u:
    case 119328u:
    case 119329u:
    case 119330u:
    case 119331u:
    case 119332u:
    case 119333u:
    case 119334u:
    case 119335u:
    case 119336u:
    case 119337u:
    case 119338u:
    case 119339u:
    case 119340u:
    case 119341u:
    case 119342u:
    case 119343u:
    case 119344u:
    case 119345u:
    case 119346u:
    case 119347u:
    case 119348u:
    case 119349u:
    case 119350u:
    case 119351u:
    case 119352u:
    case 119353u:
    case 119354u:
    case 119355u:
    case 119356u:
    case 119357u:
    case 119358u:
    case 119359u:
    case 119360u:
    case 119361u:
    case 119365u:
    case 119552u:
    case 119553u:
    case 119554u:
    case 119555u:
    case 119556u:
    case 119557u:
    case 119558u:
    case 119559u:
    case 119560u:
    case 119561u:
    case 119562u:
    case 119563u:
    case 119564u:
    case 119565u:
    case 119566u:
    case 119567u:
    case 119568u:
    case 119569u:
    case 119570u:
    case 119571u:
    case 119572u:
    case 119573u:
    case 119574u:
    case 119575u:
    case 119576u:
    case 119577u:
    case 119578u:
    case 119579u:
    case 119580u:
    case 119581u:
    case 119582u:
    case 119583u:
    case 119584u:
    case 119585u:
    case 119586u:
    case 119587u:
    case 119588u:
    case 119589u:
    case 119590u:
    case 119591u:
    case 119592u:
    case 119593u:
    case 119594u:
    case 119595u:
    case 119596u:
    case 119597u:
    case 119598u:
    case 119599u:
    case 119600u:
    case 119601u:
    case 119602u:
    case 119603u:
    case 119604u:
    case 119605u:
    case 119606u:
    case 119607u:
    case 119608u:
    case 119609u:
    case 119610u:
    case 119611u:
    case 119612u:
    case 119613u:
    case 119614u:
    case 119615u:
    case 119616u:
    case 119617u:
    case 119618u:
    case 119619u:
    case 119620u:
    case 119621u:
    case 119622u:
    case 119623u:
    case 119624u:
    case 119625u:
    case 119626u:
    case 119627u:
    case 119628u:
    case 119629u:
    case 119630u:
    case 119631u:
    case 119632u:
    case 119633u:
    case 119634u:
    case 119635u:
    case 119636u:
    case 119637u:
    case 119638u:
    case 120513u:
    case 120539u:
    case 120571u:
    case 120597u:
    case 120629u:
    case 120655u:
    case 120687u:
    case 120713u:
    case 120745u:
    case 120771u:
    case 126704u:
    case 126705u:
    case 126976u:
    case 126977u:
    case 126978u:
    case 126979u:
    case 126980u:
    case 126981u:
    case 126982u:
    case 126983u:
    case 126984u:
    case 126985u:
    case 126986u:
    case 126987u:
    case 126988u:
    case 126989u:
    case 126990u:
    case 126991u:
    case 126992u:
    case 126993u:
    case 126994u:
    case 126995u:
    case 126996u:
    case 126997u:
    case 126998u:
    case 126999u:
    case 127000u:
    case 127001u:
    case 127002u:
    case 127003u:
    case 127004u:
    case 127005u:
    case 127006u:
    case 127007u:
    case 127008u:
    case 127009u:
    case 127010u:
    case 127011u:
    case 127012u:
    case 127013u:
    case 127014u:
    case 127015u:
    case 127016u:
    case 127017u:
    case 127018u:
    case 127019u:
    case 127024u:
    case 127025u:
    case 127026u:
    case 127027u:
    case 127028u:
    case 127029u:
    case 127030u:
    case 127031u:
    case 127032u:
    case 127033u:
    case 127034u:
    case 127035u:
    case 127036u:
    case 127037u:
    case 127038u:
    case 127039u:
    case 127040u:
    case 127041u:
    case 127042u:
    case 127043u:
    case 127044u:
    case 127045u:
    case 127046u:
    case 127047u:
    case 127048u:
    case 127049u:
    case 127050u:
    case 127051u:
    case 127052u:
    case 127053u:
    case 127054u:
    case 127055u:
    case 127056u:
    case 127057u:
    case 127058u:
    case 127059u:
    case 127060u:
    case 127061u:
    case 127062u:
    case 127063u:
    case 127064u:
    case 127065u:
    case 127066u:
    case 127067u:
    case 127068u:
    case 127069u:
    case 127070u:
    case 127071u:
    case 127072u:
    case 127073u:
    case 127074u:
    case 127075u:
    case 127076u:
    case 127077u:
    case 127078u:
    case 127079u:
    case 127080u:
    case 127081u:
    case 127082u:
    case 127083u:
    case 127084u:
    case 127085u:
    case 127086u:
    case 127087u:
    case 127088u:
    case 127089u:
    case 127090u:
    case 127091u:
    case 127092u:
    case 127093u:
    case 127094u:
    case 127095u:
    case 127096u:
    case 127097u:
    case 127098u:
    case 127099u:
    case 127100u:
    case 127101u:
    case 127102u:
    case 127103u:
    case 127104u:
    case 127105u:
    case 127106u:
    case 127107u:
    case 127108u:
    case 127109u:
    case 127110u:
    case 127111u:
    case 127112u:
    case 127113u:
    case 127114u:
    case 127115u:
    case 127116u:
    case 127117u:
    case 127118u:
    case 127119u:
    case 127120u:
    case 127121u:
    case 127122u:
    case 127123u:
    case 127136u:
    case 127137u:
    case 127138u:
    case 127139u:
    case 127140u:
    case 127141u:
    case 127142u:
    case 127143u:
    case 127144u:
    case 127145u:
    case 127146u:
    case 127147u:
    case 127148u:
    case 127149u:
    case 127150u:
    case 127153u:
    case 127154u:
    case 127155u:
    case 127156u:
    case 127157u:
    case 127158u:
    case 127159u:
    case 127160u:
    case 127161u:
    case 127162u:
    case 127163u:
    case 127164u:
    case 127165u:
    case 127166u:
    case 127169u:
    case 127170u:
    case 127171u:
    case 127172u:
    case 127173u:
    case 127174u:
    case 127175u:
    case 127176u:
    case 127177u:
    case 127178u:
    case 127179u:
    case 127180u:
    case 127181u:
    case 127182u:
    case 127183u:
    case 127185u:
    case 127186u:
    case 127187u:
    case 127188u:
    case 127189u:
    case 127190u:
    case 127191u:
    case 127192u:
    case 127193u:
    case 127194u:
    case 127195u:
    case 127196u:
    case 127197u:
    case 127198u:
    case 127199u:
    case 127248u:
    case 127249u:
    case 127250u:
    case 127251u:
    case 127252u:
    case 127253u:
    case 127254u:
    case 127255u:
    case 127256u:
    case 127257u:
    case 127258u:
    case 127259u:
    case 127260u:
    case 127261u:
    case 127262u:
    case 127263u:
    case 127264u:
    case 127265u:
    case 127266u:
    case 127267u:
    case 127268u:
    case 127269u:
    case 127270u:
    case 127271u:
    case 127272u:
    case 127273u:
    case 127274u:
    case 127275u:
    case 127276u:
    case 127277u:
    case 127278u:
    case 127280u:
    case 127281u:
    case 127282u:
    case 127283u:
    case 127284u:
    case 127285u:
    case 127286u:
    case 127287u:
    case 127288u:
    case 127289u:
    case 127290u:
    case 127291u:
    case 127292u:
    case 127293u:
    case 127294u:
    case 127295u:
    case 127296u:
    case 127297u:
    case 127298u:
    case 127299u:
    case 127300u:
    case 127301u:
    case 127302u:
    case 127303u:
    case 127304u:
    case 127305u:
    case 127306u:
    case 127307u:
    case 127308u:
    case 127309u:
    case 127310u:
    case 127311u:
    case 127312u:
    case 127313u:
    case 127314u:
    case 127315u:
    case 127316u:
    case 127317u:
    case 127318u:
    case 127319u:
    case 127320u:
    case 127321u:
    case 127322u:
    case 127323u:
    case 127324u:
    case 127325u:
    case 127326u:
    case 127327u:
    case 127328u:
    case 127329u:
    case 127330u:
    case 127331u:
    case 127332u:
    case 127333u:
    case 127334u:
    case 127335u:
    case 127336u:
    case 127337u:
    case 127338u:
    case 127339u:
    case 127344u:
    case 127345u:
    case 127346u:
    case 127347u:
    case 127348u:
    case 127349u:
    case 127350u:
    case 127351u:
    case 127352u:
    case 127353u:
    case 127354u:
    case 127355u:
    case 127356u:
    case 127357u:
    case 127358u:
    case 127359u:
    case 127360u:
    case 127361u:
    case 127362u:
    case 127363u:
    case 127364u:
    case 127365u:
    case 127366u:
    case 127367u:
    case 127368u:
    case 127369u:
    case 127370u:
    case 127371u:
    case 127372u:
    case 127373u:
    case 127374u:
    case 127375u:
    case 127376u:
    case 127377u:
    case 127378u:
    case 127379u:
    case 127380u:
    case 127381u:
    case 127382u:
    case 127383u:
    case 127384u:
    case 127385u:
    case 127386u:
    case 127462u:
    case 127463u:
    case 127464u:
    case 127465u:
    case 127466u:
    case 127467u:
    case 127468u:
    case 127469u:
    case 127470u:
    case 127471u:
    case 127472u:
    case 127473u:
    case 127474u:
    case 127475u:
    case 127476u:
    case 127477u:
    case 127478u:
    case 127479u:
    case 127480u:
    case 127481u:
    case 127482u:
    case 127483u:
    case 127484u:
    case 127485u:
    case 127486u:
    case 127487u:
    case 127488u:
    case 127489u:
    case 127490u:
    case 127504u:
    case 127505u:
    case 127506u:
    case 127507u:
    case 127508u:
    case 127509u:
    case 127510u:
    case 127511u:
    case 127512u:
    case 127513u:
    case 127514u:
    case 127515u:
    case 127516u:
    case 127517u:
    case 127518u:
    case 127519u:
    case 127520u:
    case 127521u:
    case 127522u:
    case 127523u:
    case 127524u:
    case 127525u:
    case 127526u:
    case 127527u:
    case 127528u:
    case 127529u:
    case 127530u:
    case 127531u:
    case 127532u:
    case 127533u:
    case 127534u:
    case 127535u:
    case 127536u:
    case 127537u:
    case 127538u:
    case 127539u:
    case 127540u:
    case 127541u:
    case 127542u:
    case 127543u:
    case 127544u:
    case 127545u:
    case 127546u:
    case 127552u:
    case 127553u:
    case 127554u:
    case 127555u:
    case 127556u:
    case 127557u:
    case 127558u:
    case 127559u:
    case 127560u:
    case 127568u:
    case 127569u:
    case 127744u:
    case 127745u:
    case 127746u:
    case 127747u:
    case 127748u:
    case 127749u:
    case 127750u:
    case 127751u:
    case 127752u:
    case 127753u:
    case 127754u:
    case 127755u:
    case 127756u:
    case 127757u:
    case 127758u:
    case 127759u:
    case 127760u:
    case 127761u:
    case 127762u:
    case 127763u:
    case 127764u:
    case 127765u:
    case 127766u:
    case 127767u:
    case 127768u:
    case 127769u:
    case 127770u:
    case 127771u:
    case 127772u:
    case 127773u:
    case 127774u:
    case 127775u:
    case 127776u:
    case 127792u:
    case 127793u:
    case 127794u:
    case 127795u:
    case 127796u:
    case 127797u:
    case 127799u:
    case 127800u:
    case 127801u:
    case 127802u:
    case 127803u:
    case 127804u:
    case 127805u:
    case 127806u:
    case 127807u:
    case 127808u:
    case 127809u:
    case 127810u:
    case 127811u:
    case 127812u:
    case 127813u:
    case 127814u:
    case 127815u:
    case 127816u:
    case 127817u:
    case 127818u:
    case 127819u:
    case 127820u:
    case 127821u:
    case 127822u:
    case 127823u:
    case 127824u:
    case 127825u:
    case 127826u:
    case 127827u:
    case 127828u:
    case 127829u:
    case 127830u:
    case 127831u:
    case 127832u:
    case 127833u:
    case 127834u:
    case 127835u:
    case 127836u:
    case 127837u:
    case 127838u:
    case 127839u:
    case 127840u:
    case 127841u:
    case 127842u:
    case 127843u:
    case 127844u:
    case 127845u:
    case 127846u:
    case 127847u:
    case 127848u:
    case 127849u:
    case 127850u:
    case 127851u:
    case 127852u:
    case 127853u:
    case 127854u:
    case 127855u:
    case 127856u:
    case 127857u:
    case 127858u:
    case 127859u:
    case 127860u:
    case 127861u:
    case 127862u:
    case 127863u:
    case 127864u:
    case 127865u:
    case 127866u:
    case 127867u:
    case 127868u:
    case 127872u:
    case 127873u:
    case 127874u:
    case 127875u:
    case 127876u:
    case 127877u:
    case 127878u:
    case 127879u:
    case 127880u:
    case 127881u:
    case 127882u:
    case 127883u:
    case 127884u:
    case 127885u:
    case 127886u:
    case 127887u:
    case 127888u:
    case 127889u:
    case 127890u:
    case 127891u:
    case 127904u:
    case 127905u:
    case 127906u:
    case 127907u:
    case 127908u:
    case 127909u:
    case 127910u:
    case 127911u:
    case 127912u:
    case 127913u:
    case 127914u:
    case 127915u:
    case 127916u:
    case 127917u:
    case 127918u:
    case 127919u:
    case 127920u:
    case 127921u:
    case 127922u:
    case 127923u:
    case 127924u:
    case 127925u:
    case 127926u:
    case 127927u:
    case 127928u:
    case 127929u:
    case 127930u:
    case 127931u:
    case 127932u:
    case 127933u:
    case 127934u:
    case 127935u:
    case 127936u:
    case 127937u:
    case 127938u:
    case 127939u:
    case 127940u:
    case 127942u:
    case 127943u:
    case 127944u:
    case 127945u:
    case 127946u:
    case 127968u:
    case 127969u:
    case 127970u:
    case 127971u:
    case 127972u:
    case 127973u:
    case 127974u:
    case 127975u:
    case 127976u:
    case 127977u:
    case 127978u:
    case 127979u:
    case 127980u:
    case 127981u:
    case 127982u:
    case 127983u:
    case 127984u:
    case 128000u:
    case 128001u:
    case 128002u:
    case 128003u:
    case 128004u:
    case 128005u:
    case 128006u:
    case 128007u:
    case 128008u:
    case 128009u:
    case 128010u:
    case 128011u:
    case 128012u:
    case 128013u:
    case 128014u:
    case 128015u:
    case 128016u:
    case 128017u:
    case 128018u:
    case 128019u:
    case 128020u:
    case 128021u:
    case 128022u:
    case 128023u:
    case 128024u:
    case 128025u:
    case 128026u:
    case 128027u:
    case 128028u:
    case 128029u:
    case 128030u:
    case 128031u:
    case 128032u:
    case 128033u:
    case 128034u:
    case 128035u:
    case 128036u:
    case 128037u:
    case 128038u:
    case 128039u:
    case 128040u:
    case 128041u:
    case 128042u:
    case 128043u:
    case 128044u:
    case 128045u:
    case 128046u:
    case 128047u:
    case 128048u:
    case 128049u:
    case 128050u:
    case 128051u:
    case 128052u:
    case 128053u:
    case 128054u:
    case 128055u:
    case 128056u:
    case 128057u:
    case 128058u:
    case 128059u:
    case 128060u:
    case 128061u:
    case 128062u:
    case 128064u:
    case 128066u:
    case 128067u:
    case 128068u:
    case 128069u:
    case 128070u:
    case 128071u:
    case 128072u:
    case 128073u:
    case 128074u:
    case 128075u:
    case 128076u:
    case 128077u:
    case 128078u:
    case 128079u:
    case 128080u:
    case 128081u:
    case 128082u:
    case 128083u:
    case 128084u:
    case 128085u:
    case 128086u:
    case 128087u:
    case 128088u:
    case 128089u:
    case 128090u:
    case 128091u:
    case 128092u:
    case 128093u:
    case 128094u:
    case 128095u:
    case 128096u:
    case 128097u:
    case 128098u:
    case 128099u:
    case 128100u:
    case 128101u:
    case 128102u:
    case 128103u:
    case 128104u:
    case 128105u:
    case 128106u:
    case 128107u:
    case 128108u:
    case 128109u:
    case 128110u:
    case 128111u:
    case 128112u:
    case 128113u:
    case 128114u:
    case 128115u:
    case 128116u:
    case 128117u:
    case 128118u:
    case 128119u:
    case 128120u:
    case 128121u:
    case 128122u:
    case 128123u:
    case 128124u:
    case 128125u:
    case 128126u:
    case 128127u:
    case 128128u:
    case 128129u:
    case 128130u:
    case 128131u:
    case 128132u:
    case 128133u:
    case 128134u:
    case 128135u:
    case 128136u:
    case 128137u:
    case 128138u:
    case 128139u:
    case 128140u:
    case 128141u:
    case 128142u:
    case 128143u:
    case 128144u:
    case 128145u:
    case 128146u:
    case 128147u:
    case 128148u:
    case 128149u:
    case 128150u:
    case 128151u:
    case 128152u:
    case 128153u:
    case 128154u:
    case 128155u:
    case 128156u:
    case 128157u:
    case 128158u:
    case 128159u:
    case 128160u:
    case 128161u:
    case 128162u:
    case 128163u:
    case 128164u:
    case 128165u:
    case 128166u:
    case 128167u:
    case 128168u:
    case 128169u:
    case 128170u:
    case 128171u:
    case 128172u:
    case 128173u:
    case 128174u:
    case 128175u:
    case 128176u:
    case 128177u:
    case 128178u:
    case 128179u:
    case 128180u:
    case 128181u:
    case 128182u:
    case 128183u:
    case 128184u:
    case 128185u:
    case 128186u:
    case 128187u:
    case 128188u:
    case 128189u:
    case 128190u:
    case 128191u:
    case 128192u:
    case 128193u:
    case 128194u:
    case 128195u:
    case 128196u:
    case 128197u:
    case 128198u:
    case 128199u:
    case 128200u:
    case 128201u:
    case 128202u:
    case 128203u:
    case 128204u:
    case 128205u:
    case 128206u:
    case 128207u:
    case 128208u:
    case 128209u:
    case 128210u:
    case 128211u:
    case 128212u:
    case 128213u:
    case 128214u:
    case 128215u:
    case 128216u:
    case 128217u:
    case 128218u:
    case 128219u:
    case 128220u:
    case 128221u:
    case 128222u:
    case 128223u:
    case 128224u:
    case 128225u:
    case 128226u:
    case 128227u:
    case 128228u:
    case 128229u:
    case 128230u:
    case 128231u:
    case 128232u:
    case 128233u:
    case 128234u:
    case 128235u:
    case 128236u:
    case 128237u:
    case 128238u:
    case 128239u:
    case 128240u:
    case 128241u:
    case 128242u:
    case 128243u:
    case 128244u:
    case 128245u:
    case 128246u:
    case 128247u:
    case 128249u:
    case 128250u:
    case 128251u:
    case 128252u:
    case 128256u:
    case 128257u:
    case 128258u:
    case 128259u:
    case 128260u:
    case 128261u:
    case 128262u:
    case 128263u:
    case 128264u:
    case 128265u:
    case 128266u:
    case 128267u:
    case 128268u:
    case 128269u:
    case 128270u:
    case 128271u:
    case 128272u:
    case 128273u:
    case 128274u:
    case 128275u:
    case 128276u:
    case 128277u:
    case 128278u:
    case 128279u:
    case 128280u:
    case 128281u:
    case 128282u:
    case 128283u:
    case 128284u:
    case 128285u:
    case 128286u:
    case 128287u:
    case 128288u:
    case 128289u:
    case 128290u:
    case 128291u:
    case 128292u:
    case 128293u:
    case 128294u:
    case 128295u:
    case 128296u:
    case 128297u:
    case 128298u:
    case 128299u:
    case 128300u:
    case 128301u:
    case 128302u:
    case 128303u:
    case 128304u:
    case 128305u:
    case 128306u:
    case 128307u:
    case 128308u:
    case 128309u:
    case 128310u:
    case 128311u:
    case 128312u:
    case 128313u:
    case 128314u:
    case 128315u:
    case 128316u:
    case 128317u:
    case 128320u:
    case 128321u:
    case 128322u:
    case 128323u:
    case 128336u:
    case 128337u:
    case 128338u:
    case 128339u:
    case 128340u:
    case 128341u:
    case 128342u:
    case 128343u:
    case 128344u:
    case 128345u:
    case 128346u:
    case 128347u:
    case 128348u:
    case 128349u:
    case 128350u:
    case 128351u:
    case 128352u:
    case 128353u:
    case 128354u:
    case 128355u:
    case 128356u:
    case 128357u:
    case 128358u:
    case 128359u:
    case 128507u:
    case 128508u:
    case 128509u:
    case 128510u:
    case 128511u:
    case 128512u:
    case 128513u:
    case 128514u:
    case 128515u:
    case 128516u:
    case 128517u:
    case 128518u:
    case 128519u:
    case 128520u:
    case 128521u:
    case 128522u:
    case 128523u:
    case 128524u:
    case 128525u:
    case 128526u:
    case 128527u:
    case 128528u:
    case 128529u:
    case 128530u:
    case 128531u:
    case 128532u:
    case 128533u:
    case 128534u:
    case 128535u:
    case 128536u:
    case 128537u:
    case 128538u:
    case 128539u:
    case 128540u:
    case 128541u:
    case 128542u:
    case 128543u:
    case 128544u:
    case 128545u:
    case 128546u:
    case 128547u:
    case 128548u:
    case 128549u:
    case 128550u:
    case 128551u:
    case 128552u:
    case 128553u:
    case 128554u:
    case 128555u:
    case 128556u:
    case 128557u:
    case 128558u:
    case 128559u:
    case 128560u:
    case 128561u:
    case 128562u:
    case 128563u:
    case 128564u:
    case 128565u:
    case 128566u:
    case 128567u:
    case 128568u:
    case 128569u:
    case 128570u:
    case 128571u:
    case 128572u:
    case 128573u:
    case 128574u:
    case 128575u:
    case 128576u:
    case 128581u:
    case 128582u:
    case 128583u:
    case 128584u:
    case 128585u:
    case 128586u:
    case 128587u:
    case 128588u:
    case 128589u:
    case 128590u:
    case 128591u:
    case 128640u:
    case 128641u:
    case 128642u:
    case 128643u:
    case 128644u:
    case 128645u:
    case 128646u:
    case 128647u:
    case 128648u:
    case 128649u:
    case 128650u:
    case 128651u:
    case 128652u:
    case 128653u:
    case 128654u:
    case 128655u:
    case 128656u:
    case 128657u:
    case 128658u:
    case 128659u:
    case 128660u:
    case 128661u:
    case 128662u:
    case 128663u:
    case 128664u:
    case 128665u:
    case 128666u:
    case 128667u:
    case 128668u:
    case 128669u:
    case 128670u:
    case 128671u:
    case 128672u:
    case 128673u:
    case 128674u:
    case 128675u:
    case 128676u:
    case 128677u:
    case 128678u:
    case 128679u:
    case 128680u:
    case 128681u:
    case 128682u:
    case 128683u:
    case 128684u:
    case 128685u:
    case 128686u:
    case 128687u:
    case 128688u:
    case 128689u:
    case 128690u:
    case 128691u:
    case 128692u:
    case 128693u:
    case 128694u:
    case 128695u:
    case 128696u:
    case 128697u:
    case 128698u:
    case 128699u:
    case 128700u:
    case 128701u:
    case 128702u:
    case 128703u:
    case 128704u:
    case 128705u:
    case 128706u:
    case 128707u:
    case 128708u:
    case 128709u:
    case 128768u:
    case 128769u:
    case 128770u:
    case 128771u:
    case 128772u:
    case 128773u:
    case 128774u:
    case 128775u:
    case 128776u:
    case 128777u:
    case 128778u:
    case 128779u:
    case 128780u:
    case 128781u:
    case 128782u:
    case 128783u:
    case 128784u:
    case 128785u:
    case 128786u:
    case 128787u:
    case 128788u:
    case 128789u:
    case 128790u:
    case 128791u:
    case 128792u:
    case 128793u:
    case 128794u:
    case 128795u:
    case 128796u:
    case 128797u:
    case 128798u:
    case 128799u:
    case 128800u:
    case 128801u:
    case 128802u:
    case 128803u:
    case 128804u:
    case 128805u:
    case 128806u:
    case 128807u:
    case 128808u:
    case 128809u:
    case 128810u:
    case 128811u:
    case 128812u:
    case 128813u:
    case 128814u:
    case 128815u:
    case 128816u:
    case 128817u:
    case 128818u:
    case 128819u:
    case 128820u:
    case 128821u:
    case 128822u:
    case 128823u:
    case 128824u:
    case 128825u:
    case 128826u:
    case 128827u:
    case 128828u:
    case 128829u:
    case 128830u:
    case 128831u:
    case 128832u:
    case 128833u:
    case 128834u:
    case 128835u:
    case 128836u:
    case 128837u:
    case 128838u:
    case 128839u:
    case 128840u:
    case 128841u:
    case 128842u:
    case 128843u:
    case 128844u:
    case 128845u:
    case 128846u:
    case 128847u:
    case 128848u:
    case 128849u:
    case 128850u:
    case 128851u:
    case 128852u:
    case 128853u:
    case 128854u:
    case 128855u:
    case 128856u:
    case 128857u:
    case 128858u:
    case 128859u:
    case 128860u:
    case 128861u:
    case 128862u:
    case 128863u:
    case 128864u:
    case 128865u:
    case 128866u:
    case 128867u:
    case 128868u:
    case 128869u:
    case 128870u:
    case 128871u:
    case 128872u:
    case 128873u:
    case 128874u:
    case 128875u:
    case 128876u:
    case 128877u:
    case 128878u:
    case 128879u:
    case 128880u:
    case 128881u:
    case 128882u:
    case 128883u:
      return true;
  }
  return false;
}
