#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 758
#define LARGE_STATE_COUNT 369
#define SYMBOL_COUNT 199
#define ALIAS_COUNT 4
#define TOKEN_COUNT 123
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 8
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 22

enum {
  sym_label = 1,
  anon_sym_COLON = 2,
  anon_sym_Some = 3,
  anon_sym_if = 4,
  anon_sym_then = 5,
  anon_sym_else = 6,
  anon_sym_let = 7,
  anon_sym_in = 8,
  anon_sym_as = 9,
  anon_sym_using = 10,
  anon_sym_merge = 11,
  anon_sym_missing = 12,
  anon_sym_Infinity = 13,
  anon_sym_NaN = 14,
  anon_sym_toMap = 15,
  anon_sym_assert = 16,
  anon_sym_forall = 17,
  anon_sym_ = 18,
  anon_sym_with = 19,
  anon_sym_showConstructor = 20,
  anon_sym_Natural_SLASHfold = 21,
  anon_sym_Natural_SLASHbuild = 22,
  anon_sym_Natural_SLASHisZero = 23,
  anon_sym_Natural_SLASHeven = 24,
  anon_sym_Natural_SLASHodd = 25,
  anon_sym_Natural_SLASHtoInteger = 26,
  anon_sym_Natural_SLASHshow = 27,
  anon_sym_Integer_SLASHtoDouble = 28,
  anon_sym_Integer_SLASHshow = 29,
  anon_sym_Integer_SLASHnegate = 30,
  anon_sym_Integer_SLASHclamp = 31,
  anon_sym_Natural_SLASHsubtract = 32,
  anon_sym_Double_SLASHshow = 33,
  anon_sym_List_SLASHbuild = 34,
  anon_sym_List_SLASHfold = 35,
  anon_sym_List_SLASHlength = 36,
  anon_sym_List_SLASHhead = 37,
  anon_sym_List_SLASHlast = 38,
  anon_sym_List_SLASHindexed = 39,
  anon_sym_List_SLASHreverse = 40,
  anon_sym_Text_SLASHshow = 41,
  anon_sym_Text_SLASHreplace = 42,
  anon_sym_Bool = 43,
  anon_sym_Optional = 44,
  anon_sym_None = 45,
  anon_sym_Natural = 46,
  anon_sym_Integer = 47,
  anon_sym_Double = 48,
  anon_sym_Text = 49,
  anon_sym_Date = 50,
  anon_sym_Time = 51,
  anon_sym_TimeZone = 52,
  anon_sym_List = 53,
  anon_sym_Type = 54,
  anon_sym_Kind = 55,
  anon_sym_Sort = 56,
  anon_sym_LPAREN = 57,
  anon_sym_RPAREN = 58,
  anon_sym_2 = 59,
  anon_sym_DASH_GT = 60,
  anon_sym_3 = 61,
  anon_sym_BSLASH = 62,
  anon_sym_EQ = 63,
  anon_sym_DOT = 64,
  anon_sym_QMARK = 65,
  anon_sym_LBRACK = 66,
  anon_sym_COMMA = 67,
  anon_sym_RBRACK = 68,
  anon_sym_4 = 69,
  anon_sym_EQ_EQ_EQ = 70,
  anon_sym_PIPE_PIPE = 71,
  anon_sym_PLUS = 72,
  anon_sym_PLUS_PLUS = 73,
  anon_sym_POUND = 74,
  anon_sym_AMP_AMP = 75,
  anon_sym_5 = 76,
  anon_sym_SLASH_BSLASH = 77,
  anon_sym_6 = 78,
  anon_sym_SLASH_SLASH = 79,
  anon_sym_7 = 80,
  anon_sym_SLASH_SLASH_BSLASH_BSLASH = 81,
  anon_sym_STAR = 82,
  anon_sym_EQ_EQ = 83,
  anon_sym_BANG_EQ = 84,
  anon_sym_COLON_COLON = 85,
  anon_sym_LBRACE = 86,
  anon_sym_RBRACE = 87,
  anon_sym_Location = 88,
  sym_import_hash = 89,
  sym_local_import = 90,
  sym_http_raw = 91,
  aux_sym_env_import_token1 = 92,
  sym__env_bash = 93,
  sym__env_posix = 94,
  sym_line_comment_prefix = 95,
  sym_line_comment_content = 96,
  sym_block_comment_open = 97,
  sym_block_comment_close = 98,
  sym_temporal_literal = 99,
  anon_sym_DASHInfinity = 100,
  aux_sym_double_literal_token1 = 101,
  sym_natural_literal = 102,
  sym_integer_literal = 103,
  anon_sym_DQUOTE = 104,
  aux_sym__double_quote_chunk_token1 = 105,
  anon_sym_DOLLAR = 106,
  sym_double_quote_escaped = 107,
  anon_sym_SQUOTE_SQUOTE = 108,
  anon_sym_LF = 109,
  anon_sym_CR_LF = 110,
  aux_sym__single_quote_chunk_token1 = 111,
  anon_sym_SQUOTE = 112,
  sym_single_quote_escaped = 113,
  anon_sym_DOLLAR_LBRACE = 114,
  anon_sym_LT = 115,
  anon_sym_PIPE = 116,
  anon_sym_GT = 117,
  anon_sym_True = 118,
  anon_sym_False = 119,
  anon_sym_AT = 120,
  sym_block_comment_content = 121,
  sym_block_comment_end = 122,
  sym_expression = 123,
  sym__type = 124,
  sym__label_or_some = 125,
  sym_builtin = 126,
  sym_lambda_expression = 127,
  sym_forall_expression = 128,
  sym__function_expression = 129,
  sym_arrow_operator = 130,
  sym_lambda_operator = 131,
  sym_forall_operator = 132,
  sym_if_then_else_expression = 133,
  sym_let_expression = 134,
  sym_let_binding = 135,
  sym_function_type = 136,
  sym_with_expression = 137,
  sym__with_component = 138,
  sym__empty_list_literal_primitive = 139,
  sym__empty_list_literal_text = 140,
  sym_assert_expression = 141,
  sym__operator_expression = 142,
  sym_equivalence_expression = 143,
  sym_import_alt_expression = 144,
  sym_or_expression = 145,
  sym_plus_expression = 146,
  sym_text_append_expression = 147,
  sym_list_append_expression = 148,
  sym_and_expression = 149,
  sym_combine_expression = 150,
  sym_prefer_expression = 151,
  sym_combine_types_expression = 152,
  sym_times_expression = 153,
  sym_equal_expression = 154,
  sym_not_equal_expression = 155,
  sym_application_expression = 156,
  sym_builtin_function = 157,
  sym__import_expression = 158,
  sym_completion = 159,
  sym_primitive_expression = 160,
  sym_selector = 161,
  sym_label_set = 162,
  sym_type_selector = 163,
  sym_import = 164,
  sym__import_type = 165,
  sym_http_import = 166,
  sym_env_import = 167,
  sym_env_variable = 168,
  sym_line_comment = 169,
  sym_block_comment = 170,
  sym_numeric_literal = 171,
  sym_double_literal = 172,
  sym_text_literal = 173,
  sym_double_quote_literal = 174,
  sym_single_quote_literal = 175,
  sym_interpolation = 176,
  sym_record_literal = 177,
  sym_record_literal_entry = 178,
  sym_record_type = 179,
  sym_record_type_entry = 180,
  sym_union_type = 181,
  sym_union_type_entry = 182,
  sym_list_literal = 183,
  sym_boolean_literal = 184,
  sym_identifier = 185,
  sym_de_bruijn_index = 186,
  aux_sym_let_expression_repeat1 = 187,
  aux_sym_with_expression_repeat1 = 188,
  aux_sym_application_expression_repeat1 = 189,
  aux_sym_selector_repeat1 = 190,
  aux_sym_label_set_repeat1 = 191,
  aux_sym_double_quote_literal_repeat1 = 192,
  aux_sym_single_quote_literal_repeat1 = 193,
  aux_sym_record_literal_repeat1 = 194,
  aux_sym_record_literal_entry_repeat1 = 195,
  aux_sym_record_type_repeat1 = 196,
  aux_sym_union_type_repeat1 = 197,
  aux_sym_list_literal_repeat1 = 198,
  alias_sym_assert_operator = 199,
  alias_sym_empty_record_literal = 200,
  alias_sym_import_as_text = 201,
  alias_sym_missing_import = 202,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_label] = "label",
  [anon_sym_COLON] = "type_operator",
  [anon_sym_Some] = "Some",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_else] = "else",
  [anon_sym_let] = "let",
  [anon_sym_in] = "in",
  [anon_sym_as] = "as",
  [anon_sym_using] = "using",
  [anon_sym_merge] = "merge",
  [anon_sym_missing] = "missing",
  [anon_sym_Infinity] = "Infinity",
  [anon_sym_NaN] = "NaN",
  [anon_sym_toMap] = "toMap",
  [anon_sym_assert] = "assert",
  [anon_sym_forall] = "forall",
  [anon_sym_] = "∀",
  [anon_sym_with] = "with",
  [anon_sym_showConstructor] = "showConstructor",
  [anon_sym_Natural_SLASHfold] = "Natural/fold",
  [anon_sym_Natural_SLASHbuild] = "Natural/build",
  [anon_sym_Natural_SLASHisZero] = "Natural/isZero",
  [anon_sym_Natural_SLASHeven] = "Natural/even",
  [anon_sym_Natural_SLASHodd] = "Natural/odd",
  [anon_sym_Natural_SLASHtoInteger] = "Natural/toInteger",
  [anon_sym_Natural_SLASHshow] = "Natural/show",
  [anon_sym_Integer_SLASHtoDouble] = "Integer/toDouble",
  [anon_sym_Integer_SLASHshow] = "Integer/show",
  [anon_sym_Integer_SLASHnegate] = "Integer/negate",
  [anon_sym_Integer_SLASHclamp] = "Integer/clamp",
  [anon_sym_Natural_SLASHsubtract] = "Natural/subtract",
  [anon_sym_Double_SLASHshow] = "Double/show",
  [anon_sym_List_SLASHbuild] = "List/build",
  [anon_sym_List_SLASHfold] = "List/fold",
  [anon_sym_List_SLASHlength] = "List/length",
  [anon_sym_List_SLASHhead] = "List/head",
  [anon_sym_List_SLASHlast] = "List/last",
  [anon_sym_List_SLASHindexed] = "List/indexed",
  [anon_sym_List_SLASHreverse] = "List/reverse",
  [anon_sym_Text_SLASHshow] = "Text/show",
  [anon_sym_Text_SLASHreplace] = "Text/replace",
  [anon_sym_Bool] = "Bool",
  [anon_sym_Optional] = "Optional",
  [anon_sym_None] = "None",
  [anon_sym_Natural] = "Natural",
  [anon_sym_Integer] = "Integer",
  [anon_sym_Double] = "Double",
  [anon_sym_Text] = "Text",
  [anon_sym_Date] = "Date",
  [anon_sym_Time] = "Time",
  [anon_sym_TimeZone] = "TimeZone",
  [anon_sym_List] = "List",
  [anon_sym_Type] = "Type",
  [anon_sym_Kind] = "Kind",
  [anon_sym_Sort] = "Sort",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_2] = "→",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_3] = "λ",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_EQ] = "assign_operator",
  [anon_sym_DOT] = "selector_dot",
  [anon_sym_QMARK] = "question_mark",
  [anon_sym_LBRACK] = "[",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACK] = "]",
  [anon_sym_4] = "infix_operator",
  [anon_sym_EQ_EQ_EQ] = "infix_operator",
  [anon_sym_PIPE_PIPE] = "infix_operator",
  [anon_sym_PLUS] = "infix_operator",
  [anon_sym_PLUS_PLUS] = "infix_operator",
  [anon_sym_POUND] = "infix_operator",
  [anon_sym_AMP_AMP] = "infix_operator",
  [anon_sym_5] = "infix_operator",
  [anon_sym_SLASH_BSLASH] = "infix_operator",
  [anon_sym_6] = "infix_operator",
  [anon_sym_SLASH_SLASH] = "infix_operator",
  [anon_sym_7] = "infix_operator",
  [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = "infix_operator",
  [anon_sym_STAR] = "infix_operator",
  [anon_sym_EQ_EQ] = "infix_operator",
  [anon_sym_BANG_EQ] = "infix_operator",
  [anon_sym_COLON_COLON] = "completion_operator",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_Location] = "import_as_location",
  [sym_import_hash] = "import_hash",
  [sym_local_import] = "local_import",
  [sym_http_raw] = "http_raw",
  [aux_sym_env_import_token1] = "env_import_token1",
  [sym__env_bash] = "_env_bash",
  [sym__env_posix] = "_env_posix",
  [sym_line_comment_prefix] = "line_comment_prefix",
  [sym_line_comment_content] = "line_comment_content",
  [sym_block_comment_open] = "block_comment_open",
  [sym_block_comment_close] = "block_comment_close",
  [sym_temporal_literal] = "temporal_literal",
  [anon_sym_DASHInfinity] = "-Infinity",
  [aux_sym_double_literal_token1] = "double_literal_token1",
  [sym_natural_literal] = "natural_literal",
  [sym_integer_literal] = "integer_literal",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__double_quote_chunk_token1] = "_double_quote_chunk_token1",
  [anon_sym_DOLLAR] = "$",
  [sym_double_quote_escaped] = "double_quote_escaped",
  [anon_sym_SQUOTE_SQUOTE] = "''",
  [anon_sym_LF] = "\n",
  [anon_sym_CR_LF] = "\r\n",
  [aux_sym__single_quote_chunk_token1] = "_single_quote_chunk_token1",
  [anon_sym_SQUOTE] = "'",
  [sym_single_quote_escaped] = "single_quote_escaped",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_LT] = "<",
  [anon_sym_PIPE] = "|",
  [anon_sym_GT] = ">",
  [anon_sym_True] = "True",
  [anon_sym_False] = "False",
  [anon_sym_AT] = "@",
  [sym_block_comment_content] = "block_comment_content",
  [sym_block_comment_end] = "block_comment_end",
  [sym_expression] = "expression",
  [sym__type] = "_type",
  [sym__label_or_some] = "_label_or_some",
  [sym_builtin] = "builtin",
  [sym_lambda_expression] = "lambda_expression",
  [sym_forall_expression] = "forall_expression",
  [sym__function_expression] = "_function_expression",
  [sym_arrow_operator] = "arrow_operator",
  [sym_lambda_operator] = "lambda_operator",
  [sym_forall_operator] = "forall_operator",
  [sym_if_then_else_expression] = "if_then_else_expression",
  [sym_let_expression] = "let_expression",
  [sym_let_binding] = "let_binding",
  [sym_function_type] = "function_type",
  [sym_with_expression] = "with_expression",
  [sym__with_component] = "_with_component",
  [sym__empty_list_literal_primitive] = "primitive_expression",
  [sym__empty_list_literal_text] = "list_literal",
  [sym_assert_expression] = "assert_expression",
  [sym__operator_expression] = "_operator_expression",
  [sym_equivalence_expression] = "equivalence_expression",
  [sym_import_alt_expression] = "import_alt_expression",
  [sym_or_expression] = "or_expression",
  [sym_plus_expression] = "plus_expression",
  [sym_text_append_expression] = "text_append_expression",
  [sym_list_append_expression] = "list_append_expression",
  [sym_and_expression] = "and_expression",
  [sym_combine_expression] = "combine_expression",
  [sym_prefer_expression] = "prefer_expression",
  [sym_combine_types_expression] = "combine_types_expression",
  [sym_times_expression] = "times_expression",
  [sym_equal_expression] = "equal_expression",
  [sym_not_equal_expression] = "not_equal_expression",
  [sym_application_expression] = "application_expression",
  [sym_builtin_function] = "builtin_function",
  [sym__import_expression] = "_import_expression",
  [sym_completion] = "completion",
  [sym_primitive_expression] = "primitive_expression",
  [sym_selector] = "selector",
  [sym_label_set] = "label_set",
  [sym_type_selector] = "type_selector",
  [sym_import] = "import",
  [sym__import_type] = "_import_type",
  [sym_http_import] = "http_import",
  [sym_env_import] = "env_import",
  [sym_env_variable] = "env_variable",
  [sym_line_comment] = "line_comment",
  [sym_block_comment] = "block_comment",
  [sym_numeric_literal] = "numeric_literal",
  [sym_double_literal] = "double_literal",
  [sym_text_literal] = "text_literal",
  [sym_double_quote_literal] = "double_quote_literal",
  [sym_single_quote_literal] = "single_quote_literal",
  [sym_interpolation] = "interpolation",
  [sym_record_literal] = "record_literal",
  [sym_record_literal_entry] = "record_literal_entry",
  [sym_record_type] = "record_type",
  [sym_record_type_entry] = "record_type_entry",
  [sym_union_type] = "union_type",
  [sym_union_type_entry] = "union_type_entry",
  [sym_list_literal] = "list_literal",
  [sym_boolean_literal] = "boolean_literal",
  [sym_identifier] = "identifier",
  [sym_de_bruijn_index] = "de_bruijn_index",
  [aux_sym_let_expression_repeat1] = "let_expression_repeat1",
  [aux_sym_with_expression_repeat1] = "with_expression_repeat1",
  [aux_sym_application_expression_repeat1] = "application_expression_repeat1",
  [aux_sym_selector_repeat1] = "selector_repeat1",
  [aux_sym_label_set_repeat1] = "label_set_repeat1",
  [aux_sym_double_quote_literal_repeat1] = "double_quote_literal_repeat1",
  [aux_sym_single_quote_literal_repeat1] = "single_quote_literal_repeat1",
  [aux_sym_record_literal_repeat1] = "record_literal_repeat1",
  [aux_sym_record_literal_entry_repeat1] = "record_literal_entry_repeat1",
  [aux_sym_record_type_repeat1] = "record_type_repeat1",
  [aux_sym_union_type_repeat1] = "union_type_repeat1",
  [aux_sym_list_literal_repeat1] = "list_literal_repeat1",
  [alias_sym_assert_operator] = "assert_operator",
  [alias_sym_empty_record_literal] = "empty_record_literal",
  [alias_sym_import_as_text] = "import_as_text",
  [alias_sym_missing_import] = "missing_import",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_label] = sym_label,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_Some] = anon_sym_Some,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_merge] = anon_sym_merge,
  [anon_sym_missing] = anon_sym_missing,
  [anon_sym_Infinity] = anon_sym_Infinity,
  [anon_sym_NaN] = anon_sym_NaN,
  [anon_sym_toMap] = anon_sym_toMap,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_forall] = anon_sym_forall,
  [anon_sym_] = anon_sym_,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_showConstructor] = anon_sym_showConstructor,
  [anon_sym_Natural_SLASHfold] = anon_sym_Natural_SLASHfold,
  [anon_sym_Natural_SLASHbuild] = anon_sym_Natural_SLASHbuild,
  [anon_sym_Natural_SLASHisZero] = anon_sym_Natural_SLASHisZero,
  [anon_sym_Natural_SLASHeven] = anon_sym_Natural_SLASHeven,
  [anon_sym_Natural_SLASHodd] = anon_sym_Natural_SLASHodd,
  [anon_sym_Natural_SLASHtoInteger] = anon_sym_Natural_SLASHtoInteger,
  [anon_sym_Natural_SLASHshow] = anon_sym_Natural_SLASHshow,
  [anon_sym_Integer_SLASHtoDouble] = anon_sym_Integer_SLASHtoDouble,
  [anon_sym_Integer_SLASHshow] = anon_sym_Integer_SLASHshow,
  [anon_sym_Integer_SLASHnegate] = anon_sym_Integer_SLASHnegate,
  [anon_sym_Integer_SLASHclamp] = anon_sym_Integer_SLASHclamp,
  [anon_sym_Natural_SLASHsubtract] = anon_sym_Natural_SLASHsubtract,
  [anon_sym_Double_SLASHshow] = anon_sym_Double_SLASHshow,
  [anon_sym_List_SLASHbuild] = anon_sym_List_SLASHbuild,
  [anon_sym_List_SLASHfold] = anon_sym_List_SLASHfold,
  [anon_sym_List_SLASHlength] = anon_sym_List_SLASHlength,
  [anon_sym_List_SLASHhead] = anon_sym_List_SLASHhead,
  [anon_sym_List_SLASHlast] = anon_sym_List_SLASHlast,
  [anon_sym_List_SLASHindexed] = anon_sym_List_SLASHindexed,
  [anon_sym_List_SLASHreverse] = anon_sym_List_SLASHreverse,
  [anon_sym_Text_SLASHshow] = anon_sym_Text_SLASHshow,
  [anon_sym_Text_SLASHreplace] = anon_sym_Text_SLASHreplace,
  [anon_sym_Bool] = anon_sym_Bool,
  [anon_sym_Optional] = anon_sym_Optional,
  [anon_sym_None] = anon_sym_None,
  [anon_sym_Natural] = anon_sym_Natural,
  [anon_sym_Integer] = anon_sym_Integer,
  [anon_sym_Double] = anon_sym_Double,
  [anon_sym_Text] = anon_sym_Text,
  [anon_sym_Date] = anon_sym_Date,
  [anon_sym_Time] = anon_sym_Time,
  [anon_sym_TimeZone] = anon_sym_TimeZone,
  [anon_sym_List] = anon_sym_List,
  [anon_sym_Type] = anon_sym_Type,
  [anon_sym_Kind] = anon_sym_Kind,
  [anon_sym_Sort] = anon_sym_Sort,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_2] = anon_sym_2,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_3] = anon_sym_3,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_4] = anon_sym_4,
  [anon_sym_EQ_EQ_EQ] = anon_sym_4,
  [anon_sym_PIPE_PIPE] = anon_sym_4,
  [anon_sym_PLUS] = anon_sym_4,
  [anon_sym_PLUS_PLUS] = anon_sym_4,
  [anon_sym_POUND] = anon_sym_4,
  [anon_sym_AMP_AMP] = anon_sym_4,
  [anon_sym_5] = anon_sym_4,
  [anon_sym_SLASH_BSLASH] = anon_sym_4,
  [anon_sym_6] = anon_sym_4,
  [anon_sym_SLASH_SLASH] = anon_sym_4,
  [anon_sym_7] = anon_sym_4,
  [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = anon_sym_4,
  [anon_sym_STAR] = anon_sym_4,
  [anon_sym_EQ_EQ] = anon_sym_4,
  [anon_sym_BANG_EQ] = anon_sym_4,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_Location] = anon_sym_Location,
  [sym_import_hash] = sym_import_hash,
  [sym_local_import] = sym_local_import,
  [sym_http_raw] = sym_http_raw,
  [aux_sym_env_import_token1] = aux_sym_env_import_token1,
  [sym__env_bash] = sym__env_bash,
  [sym__env_posix] = sym__env_posix,
  [sym_line_comment_prefix] = sym_line_comment_prefix,
  [sym_line_comment_content] = sym_line_comment_content,
  [sym_block_comment_open] = sym_block_comment_open,
  [sym_block_comment_close] = sym_block_comment_close,
  [sym_temporal_literal] = sym_temporal_literal,
  [anon_sym_DASHInfinity] = anon_sym_DASHInfinity,
  [aux_sym_double_literal_token1] = aux_sym_double_literal_token1,
  [sym_natural_literal] = sym_natural_literal,
  [sym_integer_literal] = sym_integer_literal,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__double_quote_chunk_token1] = aux_sym__double_quote_chunk_token1,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [sym_double_quote_escaped] = sym_double_quote_escaped,
  [anon_sym_SQUOTE_SQUOTE] = anon_sym_SQUOTE_SQUOTE,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR_LF] = anon_sym_CR_LF,
  [aux_sym__single_quote_chunk_token1] = aux_sym__single_quote_chunk_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_single_quote_escaped] = sym_single_quote_escaped,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_True] = anon_sym_True,
  [anon_sym_False] = anon_sym_False,
  [anon_sym_AT] = anon_sym_AT,
  [sym_block_comment_content] = sym_block_comment_content,
  [sym_block_comment_end] = sym_block_comment_end,
  [sym_expression] = sym_expression,
  [sym__type] = sym__type,
  [sym__label_or_some] = sym__label_or_some,
  [sym_builtin] = sym_builtin,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym_forall_expression] = sym_forall_expression,
  [sym__function_expression] = sym__function_expression,
  [sym_arrow_operator] = sym_arrow_operator,
  [sym_lambda_operator] = sym_lambda_operator,
  [sym_forall_operator] = sym_forall_operator,
  [sym_if_then_else_expression] = sym_if_then_else_expression,
  [sym_let_expression] = sym_let_expression,
  [sym_let_binding] = sym_let_binding,
  [sym_function_type] = sym_function_type,
  [sym_with_expression] = sym_with_expression,
  [sym__with_component] = sym__with_component,
  [sym__empty_list_literal_primitive] = sym_primitive_expression,
  [sym__empty_list_literal_text] = sym_list_literal,
  [sym_assert_expression] = sym_assert_expression,
  [sym__operator_expression] = sym__operator_expression,
  [sym_equivalence_expression] = sym_equivalence_expression,
  [sym_import_alt_expression] = sym_import_alt_expression,
  [sym_or_expression] = sym_or_expression,
  [sym_plus_expression] = sym_plus_expression,
  [sym_text_append_expression] = sym_text_append_expression,
  [sym_list_append_expression] = sym_list_append_expression,
  [sym_and_expression] = sym_and_expression,
  [sym_combine_expression] = sym_combine_expression,
  [sym_prefer_expression] = sym_prefer_expression,
  [sym_combine_types_expression] = sym_combine_types_expression,
  [sym_times_expression] = sym_times_expression,
  [sym_equal_expression] = sym_equal_expression,
  [sym_not_equal_expression] = sym_not_equal_expression,
  [sym_application_expression] = sym_application_expression,
  [sym_builtin_function] = sym_builtin_function,
  [sym__import_expression] = sym__import_expression,
  [sym_completion] = sym_completion,
  [sym_primitive_expression] = sym_primitive_expression,
  [sym_selector] = sym_selector,
  [sym_label_set] = sym_label_set,
  [sym_type_selector] = sym_type_selector,
  [sym_import] = sym_import,
  [sym__import_type] = sym__import_type,
  [sym_http_import] = sym_http_import,
  [sym_env_import] = sym_env_import,
  [sym_env_variable] = sym_env_variable,
  [sym_line_comment] = sym_line_comment,
  [sym_block_comment] = sym_block_comment,
  [sym_numeric_literal] = sym_numeric_literal,
  [sym_double_literal] = sym_double_literal,
  [sym_text_literal] = sym_text_literal,
  [sym_double_quote_literal] = sym_double_quote_literal,
  [sym_single_quote_literal] = sym_single_quote_literal,
  [sym_interpolation] = sym_interpolation,
  [sym_record_literal] = sym_record_literal,
  [sym_record_literal_entry] = sym_record_literal_entry,
  [sym_record_type] = sym_record_type,
  [sym_record_type_entry] = sym_record_type_entry,
  [sym_union_type] = sym_union_type,
  [sym_union_type_entry] = sym_union_type_entry,
  [sym_list_literal] = sym_list_literal,
  [sym_boolean_literal] = sym_boolean_literal,
  [sym_identifier] = sym_identifier,
  [sym_de_bruijn_index] = sym_de_bruijn_index,
  [aux_sym_let_expression_repeat1] = aux_sym_let_expression_repeat1,
  [aux_sym_with_expression_repeat1] = aux_sym_with_expression_repeat1,
  [aux_sym_application_expression_repeat1] = aux_sym_application_expression_repeat1,
  [aux_sym_selector_repeat1] = aux_sym_selector_repeat1,
  [aux_sym_label_set_repeat1] = aux_sym_label_set_repeat1,
  [aux_sym_double_quote_literal_repeat1] = aux_sym_double_quote_literal_repeat1,
  [aux_sym_single_quote_literal_repeat1] = aux_sym_single_quote_literal_repeat1,
  [aux_sym_record_literal_repeat1] = aux_sym_record_literal_repeat1,
  [aux_sym_record_literal_entry_repeat1] = aux_sym_record_literal_entry_repeat1,
  [aux_sym_record_type_repeat1] = aux_sym_record_type_repeat1,
  [aux_sym_union_type_repeat1] = aux_sym_union_type_repeat1,
  [aux_sym_list_literal_repeat1] = aux_sym_list_literal_repeat1,
  [alias_sym_assert_operator] = alias_sym_assert_operator,
  [alias_sym_empty_record_literal] = alias_sym_empty_record_literal,
  [alias_sym_import_as_text] = alias_sym_import_as_text,
  [alias_sym_missing_import] = alias_sym_missing_import,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_Some] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_merge] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_missing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Infinity] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NaN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_toMap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_forall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_showConstructor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Natural_SLASHfold] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Natural_SLASHbuild] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Natural_SLASHisZero] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Natural_SLASHeven] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Natural_SLASHodd] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Natural_SLASHtoInteger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Natural_SLASHshow] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Integer_SLASHtoDouble] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Integer_SLASHshow] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Integer_SLASHnegate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Integer_SLASHclamp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Natural_SLASHsubtract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Double_SLASHshow] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_List_SLASHbuild] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_List_SLASHfold] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_List_SLASHlength] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_List_SLASHhead] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_List_SLASHlast] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_List_SLASHindexed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_List_SLASHreverse] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Text_SLASHshow] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Text_SLASHreplace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Optional] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_None] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Natural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Integer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Double] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Text] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Date] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Time] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TimeZone] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_List] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Kind] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Sort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_4] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_5] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH_BSLASH] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_6] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_7] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Location] = {
    .visible = true,
    .named = true,
  },
  [sym_import_hash] = {
    .visible = true,
    .named = true,
  },
  [sym_local_import] = {
    .visible = true,
    .named = true,
  },
  [sym_http_raw] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_env_import_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__env_bash] = {
    .visible = false,
    .named = true,
  },
  [sym__env_posix] = {
    .visible = false,
    .named = true,
  },
  [sym_line_comment_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment_content] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment_open] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment_close] = {
    .visible = true,
    .named = true,
  },
  [sym_temporal_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASHInfinity] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_double_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_natural_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__double_quote_chunk_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym_double_quote_escaped] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR_LF] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__single_quote_chunk_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_single_quote_escaped] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_True] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_False] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [sym_block_comment_content] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment_end] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__label_or_some] = {
    .visible = false,
    .named = true,
  },
  [sym_builtin] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_forall_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__function_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_arrow_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_forall_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_if_then_else_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_let_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_let_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_with_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__with_component] = {
    .visible = false,
    .named = true,
  },
  [sym__empty_list_literal_primitive] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_list_literal_text] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__operator_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_equivalence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_import_alt_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_or_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_plus_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_text_append_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_list_append_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_and_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_combine_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_prefer_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_combine_types_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_times_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_equal_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_not_equal_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_application_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin_function] = {
    .visible = true,
    .named = true,
  },
  [sym__import_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_completion] = {
    .visible = true,
    .named = true,
  },
  [sym_primitive_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_label_set] = {
    .visible = true,
    .named = true,
  },
  [sym_type_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym__import_type] = {
    .visible = false,
    .named = true,
  },
  [sym_http_import] = {
    .visible = true,
    .named = true,
  },
  [sym_env_import] = {
    .visible = true,
    .named = true,
  },
  [sym_env_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_numeric_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_double_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_text_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_double_quote_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_single_quote_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_record_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_record_literal_entry] = {
    .visible = true,
    .named = true,
  },
  [sym_record_type] = {
    .visible = true,
    .named = true,
  },
  [sym_record_type_entry] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type_entry] = {
    .visible = true,
    .named = true,
  },
  [sym_list_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_de_bruijn_index] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_let_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_with_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_application_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_selector_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_label_set_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_double_quote_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_single_quote_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_literal_entry_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_assert_operator] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_empty_record_literal] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_import_as_text] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_missing_import] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternate = 1,
  field_expression = 2,
  field_label = 3,
  field_left = 4,
  field_predicate = 5,
  field_right = 6,
  field_selector = 7,
  field_type = 8,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternate] = "alternate",
  [field_expression] = "expression",
  [field_label] = "label",
  [field_left] = "left",
  [field_predicate] = "predicate",
  [field_right] = "right",
  [field_selector] = "selector",
  [field_type] = "type",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 3},
  [5] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 1},
  [10] = {.index = 6, .length = 2},
  [11] = {.index = 8, .length = 1},
  [13] = {.index = 9, .length = 1},
  [14] = {.index = 10, .length = 1},
  [17] = {.index = 11, .length = 2},
  [19] = {.index = 13, .length = 3},
  [21] = {.index = 16, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_selector, 1},
  [1] =
    {field_expression, 1, .inherited = true},
    {field_label, 1, .inherited = true},
    {field_type, 1, .inherited = true},
  [4] =
    {field_type, 1, .inherited = true},
  [5] =
    {field_type, 1},
  [6] =
    {field_left, 0},
    {field_right, 2},
  [8] =
    {field_type, 0},
  [9] =
    {field_label, 1},
  [10] =
    {field_selector, 3},
  [11] =
    {field_label, 1},
    {field_type, 2, .inherited = true},
  [13] =
    {field_alternate, 5},
    {field_expression, 3},
    {field_predicate, 1},
  [16] =
    {field_expression, 5},
    {field_label, 1},
    {field_type, 2, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_missing_import,
  },
  [2] = {
    [0] = sym_label,
  },
  [6] = {
    [1] = alias_sym_assert_operator,
  },
  [7] = {
    [1] = alias_sym_empty_record_literal,
  },
  [9] = {
    [1] = anon_sym_4,
  },
  [12] = {
    [2] = alias_sym_import_as_text,
  },
  [15] = {
    [2] = alias_sym_empty_record_literal,
  },
  [16] = {
    [3] = alias_sym_import_as_text,
  },
  [18] = {
    [1] = sym_selector,
  },
  [20] = {
    [3] = sym_selector,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym_with_expression_repeat1, 2,
    aux_sym_with_expression_repeat1,
    sym_selector,
  aux_sym_record_literal_entry_repeat1, 2,
    aux_sym_record_literal_entry_repeat1,
    sym_selector,
  0,
};

static inline bool sym_local_import_character_set_1(int32_t c) {
  return (c < '<'
    ? (c < '#'
      ? (c < 0
        ? c == 0
        : c <= ' ')
      : (c <= '#' || (c < ','
        ? (c >= '(' && c <= ')')
        : c <= ',')))
    : (c <= '<' || (c < '{'
      ? (c < '['
        ? (c >= '>' && c <= '?')
        : c <= ']')
      : (c <= '{' || (c < 127
        ? c == '}'
        : c <= 127)))));
}

static inline bool sym_local_import_character_set_2(int32_t c) {
  return (c < '<'
    ? (c < '('
      ? (c < 0
        ? c == 0
        : (c <= ' ' || c == '#'))
      : (c <= ')' || (c < '/'
        ? c == ','
        : c <= '/')))
    : (c <= '<' || (c < '{'
      ? (c < '['
        ? (c >= '>' && c <= '?')
        : c <= ']')
      : (c <= '{' || (c < 127
        ? c == '}'
        : c <= 127)))));
}

static inline bool sym_local_import_character_set_3(int32_t c) {
  return (c < '<'
    ? (c < '"'
      ? (c < 0
        ? c == 0
        : c <= ' ')
      : (c <= '#' || (c < ','
        ? (c >= '(' && c <= ')')
        : c <= ',')))
    : (c <= '<' || (c < '{'
      ? (c < '['
        ? (c >= '>' && c <= '?')
        : c <= ']')
      : (c <= '{' || (c < 127
        ? c == '}'
        : c <= 127)))));
}

static inline bool sym_http_raw_character_set_1(int32_t c) {
  return (c < '='
    ? (c < '*'
      ? (c < '$'
        ? c == '!'
        : c <= '\'')
      : (c <= '+' || (c < '0'
        ? (c >= '-' && c <= '.')
        : c <= ';')))
    : (c <= '=' || (c < 'a'
      ? (c < '_'
        ? (c >= 'A' && c <= 'Z')
        : c <= '_')
      : (c <= 'z' || c == '~'))));
}

static inline bool sym_http_raw_character_set_2(int32_t c) {
  return (c < '0'
    ? (c < '&'
      ? (c < '$'
        ? c == '!'
        : c <= '$')
      : (c <= '\'' || (c < '-'
        ? (c >= '*' && c <= '+')
        : c <= '.')))
    : (c <= ';' || (c < '_'
      ? (c < 'A'
        ? c == '='
        : c <= 'Z')
      : (c <= '_' || (c < '~'
        ? (c >= 'a' && c <= 'z')
        : c <= '~')))));
}

static inline bool sym_http_raw_character_set_3(int32_t c) {
  return (c < '='
    ? (c < '*'
      ? (c < '$'
        ? c == '!'
        : c <= '\'')
      : (c <= '+' || (c < ':'
        ? (c >= '-' && c <= '.')
        : c <= ';')))
    : (c <= '=' || (c < 'a'
      ? (c < '_'
        ? (c >= 'A' && c <= 'Z')
        : c <= '_')
      : (c <= 'z' || c == '~'))));
}

static inline bool sym_http_raw_character_set_4(int32_t c) {
  return (c < '='
    ? (c < '*'
      ? (c < '$'
        ? c == '!'
        : c <= '\'')
      : (c <= '+' || (c < '0'
        ? (c >= '-' && c <= '.')
        : c <= ';')))
    : (c <= '=' || (c < 'a'
      ? (c < '_'
        ? (c >= '@' && c <= 'Z')
        : c <= '_')
      : (c <= 'z' || c == '~'))));
}

static inline bool sym_http_raw_character_set_5(int32_t c) {
  return (c < '='
    ? (c < '*'
      ? (c < '$'
        ? c == '!'
        : c <= '\'')
      : (c <= '+' || (c >= '-' && c <= ';')))
    : (c <= '=' || (c < 'a'
      ? (c < '_'
        ? (c >= '?' && c <= 'Z')
        : c <= '_')
      : (c <= 'z' || c == '~'))));
}

static inline bool sym_double_quote_escaped_character_set_1(int32_t c) {
  return (c < 'b'
    ? (c < '/'
      ? (c < '$'
        ? c == '"'
        : c <= '$')
      : (c <= '/' || c == '\\'))
    : (c <= 'b' || (c < 'r'
      ? (c < 'n'
        ? c == 'f'
        : c <= 'n')
      : (c <= 'r' || c == 't'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(275);
      if (lookahead == '!') ADVANCE(129);
      if (lookahead == '"') ADVANCE(402);
      if (lookahead == '#') ADVANCE(315);
      if (lookahead == '$') ADVANCE(406);
      if (lookahead == '&') ADVANCE(13);
      if (lookahead == '\'') ADVANCE(414);
      if (lookahead == '(') ADVANCE(295);
      if (lookahead == ')') ADVANCE(296);
      if (lookahead == '*') ADVANCE(323);
      if (lookahead == '+') ADVANCE(313);
      if (lookahead == ',') ADVANCE(307);
      if (lookahead == '-') ADVANCE(17);
      if (lookahead == '.') ADVANCE(304);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(390);
      if (lookahead == ':') ADVANCE(293);
      if (lookahead == '<') ADVANCE(417);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(420);
      if (lookahead == '?') ADVANCE(305);
      if (lookahead == '@') ADVANCE(421);
      if (lookahead == '[') ADVANCE(306);
      if (lookahead == '\\') ADVANCE(301);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '`') ADVANCE(145);
      if (lookahead == 'h') ADVANCE(288);
      if (lookahead == 's') ADVANCE(285);
      if (lookahead == '{') ADVANCE(327);
      if (lookahead == '|') ADVANCE(419);
      if (lookahead == '}') ADVANCE(328);
      if (lookahead == '~') ADVANCE(57);
      if (lookahead == 955) ADVANCE(299);
      if (lookahead == 8594) ADVANCE(297);
      if (lookahead == 8704) ADVANCE(294);
      if (lookahead == 8743) ADVANCE(317);
      if (lookahead == 8801) ADVANCE(309);
      if (lookahead == 10835) ADVANCE(321);
      if (lookahead == 11005) ADVANCE(319);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(289);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(270)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(391);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(410);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '-') ADVANCE(16);
      if (lookahead == '{') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(1)
      END_STATE();
    case 2:
      if (lookahead == ' ') ADVANCE(403);
      if (lookahead == '"') ADVANCE(402);
      if (lookahead == '$') ADVANCE(406);
      if (lookahead == '-') ADVANCE(404);
      if (lookahead == '\\') ADVANCE(152);
      if (lookahead == '{') ADVANCE(404);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r') SKIP(3)
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(405);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(402);
      if (lookahead == '$') ADVANCE(154);
      if (lookahead == '-') ADVANCE(16);
      if (lookahead == '\\') ADVANCE(152);
      if (lookahead == '{') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(269);
      if (lookahead == '/') ADVANCE(320);
      if (lookahead == '\\') ADVANCE(318);
      if (!sym_local_import_character_set_1(lookahead)) ADVANCE(331);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(269);
      if (!sym_local_import_character_set_2(lookahead)) ADVANCE(331);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(330);
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(75);
      if (lookahead == '-') ADVANCE(16);
      if (lookahead == '{') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(371);
      if (lookahead == ':') ADVANCE(8);
      if (lookahead == '\\') ADVANCE(164);
      if ((' ' <= lookahead && lookahead <= '<') ||
          ('>' <= lookahead && lookahead <= '~')) ADVANCE(8);
      END_STATE();
    case 9:
      if (lookahead == '$') ADVANCE(406);
      if (lookahead == '\'') ADVANCE(414);
      if (lookahead == '-') ADVANCE(412);
      if (lookahead == '{') ADVANCE(412);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(411);
      if (lookahead != 0) ADVANCE(413);
      END_STATE();
    case 10:
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '.' ||
          lookahead == ':' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (lookahead == '@') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 11:
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == ':' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '[') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(332);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 12:
      if (lookahead == '%') ADVANCE(199);
      if (sym_http_raw_character_set_1(lookahead)) ADVANCE(12);
      if (lookahead == '@') ADVANCE(130);
      END_STATE();
    case 13:
      if (lookahead == '&') ADVANCE(316);
      END_STATE();
    case 14:
      if (lookahead == '\'') ADVANCE(409);
      END_STATE();
    case 15:
      if (lookahead == '\'') ADVANCE(408);
      END_STATE();
    case 16:
      if (lookahead == '-') ADVANCE(372);
      END_STATE();
    case 17:
      if (lookahead == '-') ADVANCE(372);
      if (lookahead == '0') ADVANCE(398);
      if (lookahead == '>') ADVANCE(298);
      if (lookahead == 'I') ADVANCE(149);
      if (lookahead == '}') ADVANCE(380);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(399);
      END_STATE();
    case 18:
      if (lookahead == '-') ADVANCE(372);
      if (lookahead == '0') ADVANCE(398);
      if (lookahead == '>') ADVANCE(298);
      if (lookahead == 'I') ADVANCE(149);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(399);
      END_STATE();
    case 19:
      if (lookahead == '-') ADVANCE(372);
      if (lookahead == '0') ADVANCE(398);
      if (lookahead == 'I') ADVANCE(149);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(399);
      END_STATE();
    case 20:
      if (lookahead == '-') ADVANCE(372);
      if (lookahead == '>') ADVANCE(298);
      END_STATE();
    case 21:
      if (lookahead == '-') ADVANCE(378);
      END_STATE();
    case 22:
      if (lookahead == '-') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 23:
      if (lookahead == '-') ADVANCE(179);
      if (lookahead == '.') ADVANCE(165);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(28);
      END_STATE();
    case 24:
      if (lookahead == '-') ADVANCE(181);
      END_STATE();
    case 25:
      if (lookahead == '.') ADVANCE(165);
      if (lookahead == ':') ADVANCE(176);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(27);
      END_STATE();
    case 26:
      if (lookahead == '.') ADVANCE(165);
      if (lookahead == ':') ADVANCE(178);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(28);
      END_STATE();
    case 27:
      if (lookahead == '.') ADVANCE(165);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(23);
      END_STATE();
    case 28:
      if (lookahead == '.') ADVANCE(165);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(28);
      END_STATE();
    case 29:
      if (lookahead == '.') ADVANCE(267);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(29);
      END_STATE();
    case 30:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(190);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(32);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(66);
      END_STATE();
    case 31:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(190);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(30);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 32:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(190);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 33:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(177);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(35);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(82);
      END_STATE();
    case 34:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(177);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(33);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(83);
      END_STATE();
    case 35:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(177);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(81);
      END_STATE();
    case 36:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(205);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(38);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(91);
      END_STATE();
    case 37:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(205);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(36);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(92);
      END_STATE();
    case 38:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(205);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 39:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(96);
      END_STATE();
    case 40:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(39);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(95);
      END_STATE();
    case 41:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(94);
      END_STATE();
    case 42:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(182);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(44);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(100);
      END_STATE();
    case 43:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(182);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(101);
      END_STATE();
    case 44:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(182);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(99);
      END_STATE();
    case 45:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(185);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(111);
      END_STATE();
    case 46:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(185);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(45);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(112);
      END_STATE();
    case 47:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(185);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(110);
      END_STATE();
    case 48:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(189);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(120);
      END_STATE();
    case 49:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(189);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(121);
      END_STATE();
    case 50:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == ':') ADVANCE(189);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(119);
      END_STATE();
    case 51:
      if (lookahead == '.') ADVANCE(174);
      END_STATE();
    case 52:
      if (lookahead == '.') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(51);
      END_STATE();
    case 53:
      if (lookahead == '.') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(52);
      END_STATE();
    case 54:
      if (lookahead == '.') ADVANCE(183);
      END_STATE();
    case 55:
      if (lookahead == '.') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(54);
      END_STATE();
    case 56:
      if (lookahead == '.') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(55);
      END_STATE();
    case 57:
      if (lookahead == '/') ADVANCE(5);
      END_STATE();
    case 58:
      if (lookahead == '/') ADVANCE(320);
      if (lookahead == '\\') ADVANCE(318);
      END_STATE();
    case 59:
      if (lookahead == '/') ADVANCE(11);
      END_STATE();
    case 60:
      if (lookahead == '/') ADVANCE(59);
      END_STATE();
    case 61:
      if (lookahead == '0') ADVANCE(398);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(399);
      END_STATE();
    case 62:
      if (lookahead == '0') ADVANCE(62);
      if (lookahead == '}') ADVANCE(407);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(162);
      END_STATE();
    case 63:
      if (lookahead == '0') ADVANCE(62);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(162);
      END_STATE();
    case 64:
      if (lookahead == ':') ADVANCE(133);
      END_STATE();
    case 65:
      if (lookahead == ':') ADVANCE(190);
      if (lookahead == ']') ADVANCE(363);
      END_STATE();
    case 66:
      if (lookahead == ':') ADVANCE(190);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 67:
      if (lookahead == ':') ADVANCE(190);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(66);
      END_STATE();
    case 68:
      if (lookahead == ':') ADVANCE(190);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 69:
      if (lookahead == ':') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(143);
      END_STATE();
    case 70:
      if (lookahead == ':') ADVANCE(74);
      END_STATE();
    case 71:
      if (lookahead == ':') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(70);
      END_STATE();
    case 72:
      if (lookahead == ':') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(71);
      END_STATE();
    case 73:
      if (lookahead == ':') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(72);
      END_STATE();
    case 74:
      if (lookahead == ':') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(97);
      END_STATE();
    case 75:
      if (lookahead == ':') ADVANCE(8);
      if (lookahead == '\\') ADVANCE(164);
      if (lookahead == ' ' ||
          lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '<') ||
          ('>' <= lookahead && lookahead <= '~')) ADVANCE(8);
      END_STATE();
    case 76:
      if (lookahead == ':') ADVANCE(64);
      if (lookahead == 'v') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 77:
      if (lookahead == ':') ADVANCE(128);
      END_STATE();
    case 78:
      if (lookahead == ':') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(77);
      END_STATE();
    case 79:
      if (lookahead == ':') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(78);
      END_STATE();
    case 80:
      if (lookahead == ':') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(79);
      END_STATE();
    case 81:
      if (lookahead == ':') ADVANCE(177);
      if (lookahead == ']') ADVANCE(363);
      END_STATE();
    case 82:
      if (lookahead == ':') ADVANCE(177);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(81);
      END_STATE();
    case 83:
      if (lookahead == ':') ADVANCE(177);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(82);
      END_STATE();
    case 84:
      if (lookahead == ':') ADVANCE(177);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(83);
      END_STATE();
    case 85:
      if (lookahead == ':') ADVANCE(176);
      END_STATE();
    case 86:
      if (lookahead == ':') ADVANCE(98);
      END_STATE();
    case 87:
      if (lookahead == ':') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(86);
      END_STATE();
    case 88:
      if (lookahead == ':') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(87);
      END_STATE();
    case 89:
      if (lookahead == ':') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(88);
      END_STATE();
    case 90:
      if (lookahead == ':') ADVANCE(205);
      if (lookahead == ']') ADVANCE(363);
      END_STATE();
    case 91:
      if (lookahead == ':') ADVANCE(205);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 92:
      if (lookahead == ':') ADVANCE(205);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(91);
      END_STATE();
    case 93:
      if (lookahead == ':') ADVANCE(205);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(92);
      END_STATE();
    case 94:
      if (lookahead == ':') ADVANCE(69);
      END_STATE();
    case 95:
      if (lookahead == ':') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(96);
      END_STATE();
    case 96:
      if (lookahead == ':') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(94);
      END_STATE();
    case 97:
      if (lookahead == ':') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(95);
      END_STATE();
    case 98:
      if (lookahead == ':') ADVANCE(136);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(73);
      END_STATE();
    case 99:
      if (lookahead == ':') ADVANCE(182);
      if (lookahead == ']') ADVANCE(363);
      END_STATE();
    case 100:
      if (lookahead == ':') ADVANCE(182);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(99);
      END_STATE();
    case 101:
      if (lookahead == ':') ADVANCE(182);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(100);
      END_STATE();
    case 102:
      if (lookahead == ':') ADVANCE(182);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(101);
      END_STATE();
    case 103:
      if (lookahead == ':') ADVANCE(109);
      END_STATE();
    case 104:
      if (lookahead == ':') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(103);
      END_STATE();
    case 105:
      if (lookahead == ':') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(104);
      END_STATE();
    case 106:
      if (lookahead == ':') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(105);
      END_STATE();
    case 107:
      if (lookahead == ':') ADVANCE(178);
      END_STATE();
    case 108:
      if (lookahead == ':') ADVANCE(180);
      END_STATE();
    case 109:
      if (lookahead == ':') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(89);
      END_STATE();
    case 110:
      if (lookahead == ':') ADVANCE(185);
      if (lookahead == ']') ADVANCE(363);
      END_STATE();
    case 111:
      if (lookahead == ':') ADVANCE(185);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(110);
      END_STATE();
    case 112:
      if (lookahead == ':') ADVANCE(185);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(111);
      END_STATE();
    case 113:
      if (lookahead == ':') ADVANCE(185);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(112);
      END_STATE();
    case 114:
      if (lookahead == ':') ADVANCE(118);
      END_STATE();
    case 115:
      if (lookahead == ':') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(114);
      END_STATE();
    case 116:
      if (lookahead == ':') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(115);
      END_STATE();
    case 117:
      if (lookahead == ':') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(116);
      END_STATE();
    case 118:
      if (lookahead == ':') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(106);
      END_STATE();
    case 119:
      if (lookahead == ':') ADVANCE(189);
      if (lookahead == ']') ADVANCE(363);
      END_STATE();
    case 120:
      if (lookahead == ':') ADVANCE(189);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(119);
      END_STATE();
    case 121:
      if (lookahead == ':') ADVANCE(189);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(120);
      END_STATE();
    case 122:
      if (lookahead == ':') ADVANCE(189);
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(121);
      END_STATE();
    case 123:
      if (lookahead == ':') ADVANCE(127);
      END_STATE();
    case 124:
      if (lookahead == ':') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(123);
      END_STATE();
    case 125:
      if (lookahead == ':') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(124);
      END_STATE();
    case 126:
      if (lookahead == ':') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(125);
      END_STATE();
    case 127:
      if (lookahead == ':') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(117);
      END_STATE();
    case 128:
      if (lookahead == ':') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(126);
      END_STATE();
    case 129:
      if (lookahead == '=') ADVANCE(325);
      END_STATE();
    case 130:
      if (lookahead == '[') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(351);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 131:
      if (lookahead == '\\') ADVANCE(322);
      END_STATE();
    case 132:
      if (lookahead == ']') ADVANCE(363);
      END_STATE();
    case 133:
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(31);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(68);
      END_STATE();
    case 134:
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(132);
      END_STATE();
    case 135:
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(134);
      END_STATE();
    case 136:
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(37);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(93);
      END_STATE();
    case 137:
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(34);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(84);
      END_STATE();
    case 138:
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(43);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(102);
      END_STATE();
    case 139:
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(113);
      END_STATE();
    case 140:
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(49);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(122);
      END_STATE();
    case 141:
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(132);
      END_STATE();
    case 142:
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(141);
      END_STATE();
    case 143:
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(142);
      END_STATE();
    case 144:
      if (lookahead == ']') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(143);
      END_STATE();
    case 145:
      if (lookahead == '`') ADVANCE(276);
      if ((' ' <= lookahead && lookahead <= '~')) ADVANCE(145);
      END_STATE();
    case 146:
      if (lookahead == 'f') ADVANCE(148);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(151);
      END_STATE();
    case 148:
      if (lookahead == 'i') ADVANCE(150);
      END_STATE();
    case 149:
      if (lookahead == 'n') ADVANCE(146);
      END_STATE();
    case 150:
      if (lookahead == 'n') ADVANCE(147);
      END_STATE();
    case 151:
      if (lookahead == 't') ADVANCE(153);
      END_STATE();
    case 152:
      if (lookahead == 'u') ADVANCE(156);
      if (sym_double_quote_escaped_character_set_1(lookahead)) ADVANCE(407);
      END_STATE();
    case 153:
      if (lookahead == 'y') ADVANCE(385);
      END_STATE();
    case 154:
      if (lookahead == '{') ADVANCE(416);
      END_STATE();
    case 155:
      if (lookahead == '{') ADVANCE(415);
      END_STATE();
    case 156:
      if (lookahead == '{') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(203);
      END_STATE();
    case 157:
      if (lookahead == '}') ADVANCE(407);
      END_STATE();
    case 158:
      if (lookahead == '}') ADVANCE(407);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(157);
      END_STATE();
    case 159:
      if (lookahead == '}') ADVANCE(407);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(158);
      END_STATE();
    case 160:
      if (lookahead == '}') ADVANCE(407);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(159);
      END_STATE();
    case 161:
      if (lookahead == '}') ADVANCE(407);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(160);
      END_STATE();
    case 162:
      if (lookahead == '}') ADVANCE(407);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(161);
      END_STATE();
    case 163:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(387);
      END_STATE();
    case 164:
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't' ||
          lookahead == 'v') ADVANCE(8);
      END_STATE();
    case 165:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(386);
      END_STATE();
    case 166:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(387);
      END_STATE();
    case 167:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(108);
      END_STATE();
    case 168:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(381);
      END_STATE();
    case 169:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(24);
      END_STATE();
    case 170:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(382);
      END_STATE();
    case 171:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(383);
      END_STATE();
    case 172:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(384);
      END_STATE();
    case 173:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(29);
      END_STATE();
    case 174:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      END_STATE();
    case 175:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(56);
      END_STATE();
    case 176:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(167);
      END_STATE();
    case 177:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(37);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(93);
      END_STATE();
    case 178:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(168);
      END_STATE();
    case 179:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(169);
      END_STATE();
    case 180:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(170);
      END_STATE();
    case 181:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(172);
      END_STATE();
    case 182:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(34);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(84);
      END_STATE();
    case 183:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(53);
      END_STATE();
    case 184:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(107);
      END_STATE();
    case 185:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(43);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(102);
      END_STATE();
    case 186:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 187:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(85);
      END_STATE();
    case 188:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(187);
      END_STATE();
    case 189:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(113);
      END_STATE();
    case 190:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(49);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(122);
      END_STATE();
    case 191:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(407);
      END_STATE();
    case 192:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(396);
      END_STATE();
    case 193:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(401);
      END_STATE();
    case 194:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(12);
      END_STATE();
    case 195:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(349);
      END_STATE();
    case 196:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(350);
      END_STATE();
    case 197:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(329);
      END_STATE();
    case 198:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(191);
      END_STATE();
    case 199:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(194);
      END_STATE();
    case 200:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(195);
      END_STATE();
    case 201:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(196);
      END_STATE();
    case 202:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(197);
      END_STATE();
    case 203:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(198);
      END_STATE();
    case 204:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 205:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(143);
      END_STATE();
    case 206:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(204);
      END_STATE();
    case 207:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(206);
      END_STATE();
    case 208:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(207);
      END_STATE();
    case 209:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(208);
      END_STATE();
    case 210:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(209);
      END_STATE();
    case 211:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(210);
      END_STATE();
    case 212:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(211);
      END_STATE();
    case 213:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(212);
      END_STATE();
    case 214:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(213);
      END_STATE();
    case 215:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(214);
      END_STATE();
    case 216:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(215);
      END_STATE();
    case 217:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(216);
      END_STATE();
    case 218:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(217);
      END_STATE();
    case 219:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(218);
      END_STATE();
    case 220:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(219);
      END_STATE();
    case 221:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(220);
      END_STATE();
    case 222:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(221);
      END_STATE();
    case 223:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(222);
      END_STATE();
    case 224:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(223);
      END_STATE();
    case 225:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(224);
      END_STATE();
    case 226:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(225);
      END_STATE();
    case 227:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(226);
      END_STATE();
    case 228:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(227);
      END_STATE();
    case 229:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(228);
      END_STATE();
    case 230:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(229);
      END_STATE();
    case 231:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(230);
      END_STATE();
    case 232:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(231);
      END_STATE();
    case 233:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(232);
      END_STATE();
    case 234:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(233);
      END_STATE();
    case 235:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(234);
      END_STATE();
    case 236:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(235);
      END_STATE();
    case 237:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(236);
      END_STATE();
    case 238:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(237);
      END_STATE();
    case 239:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(238);
      END_STATE();
    case 240:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(239);
      END_STATE();
    case 241:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(240);
      END_STATE();
    case 242:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(241);
      END_STATE();
    case 243:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(242);
      END_STATE();
    case 244:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(243);
      END_STATE();
    case 245:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(244);
      END_STATE();
    case 246:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(245);
      END_STATE();
    case 247:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(246);
      END_STATE();
    case 248:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(247);
      END_STATE();
    case 249:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(248);
      END_STATE();
    case 250:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(249);
      END_STATE();
    case 251:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(250);
      END_STATE();
    case 252:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(251);
      END_STATE();
    case 253:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(252);
      END_STATE();
    case 254:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(253);
      END_STATE();
    case 255:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(254);
      END_STATE();
    case 256:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(255);
      END_STATE();
    case 257:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(256);
      END_STATE();
    case 258:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(257);
      END_STATE();
    case 259:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(258);
      END_STATE();
    case 260:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(259);
      END_STATE();
    case 261:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(260);
      END_STATE();
    case 262:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(261);
      END_STATE();
    case 263:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(262);
      END_STATE();
    case 264:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(263);
      END_STATE();
    case 265:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(264);
      END_STATE();
    case 266:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(265);
      END_STATE();
    case 267:
      if (sym_http_raw_character_set_2(lookahead)) ADVANCE(268);
      END_STATE();
    case 268:
      if (sym_http_raw_character_set_2(lookahead)) ADVANCE(268);
      if (lookahead == ']') ADVANCE(363);
      END_STATE();
    case 269:
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(6);
      END_STATE();
    case 270:
      if (eof) ADVANCE(275);
      if (lookahead == '!') ADVANCE(129);
      if (lookahead == '"') ADVANCE(402);
      if (lookahead == '#') ADVANCE(315);
      if (lookahead == '$') ADVANCE(154);
      if (lookahead == '&') ADVANCE(13);
      if (lookahead == '\'') ADVANCE(14);
      if (lookahead == '(') ADVANCE(295);
      if (lookahead == ')') ADVANCE(296);
      if (lookahead == '*') ADVANCE(323);
      if (lookahead == '+') ADVANCE(313);
      if (lookahead == ',') ADVANCE(307);
      if (lookahead == '-') ADVANCE(17);
      if (lookahead == '.') ADVANCE(304);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(390);
      if (lookahead == ':') ADVANCE(293);
      if (lookahead == '<') ADVANCE(417);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(420);
      if (lookahead == '?') ADVANCE(305);
      if (lookahead == '@') ADVANCE(421);
      if (lookahead == '[') ADVANCE(306);
      if (lookahead == '\\') ADVANCE(301);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '`') ADVANCE(145);
      if (lookahead == 'h') ADVANCE(288);
      if (lookahead == 's') ADVANCE(285);
      if (lookahead == '{') ADVANCE(327);
      if (lookahead == '|') ADVANCE(419);
      if (lookahead == '}') ADVANCE(328);
      if (lookahead == '~') ADVANCE(57);
      if (lookahead == 955) ADVANCE(299);
      if (lookahead == 8594) ADVANCE(297);
      if (lookahead == 8704) ADVANCE(294);
      if (lookahead == 8743) ADVANCE(317);
      if (lookahead == 8801) ADVANCE(309);
      if (lookahead == 10835) ADVANCE(321);
      if (lookahead == 11005) ADVANCE(319);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(289);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(270)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(391);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 271:
      if (eof) ADVANCE(275);
      if (lookahead == '!') ADVANCE(129);
      if (lookahead == '"') ADVANCE(402);
      if (lookahead == '#') ADVANCE(315);
      if (lookahead == '&') ADVANCE(13);
      if (lookahead == '\'') ADVANCE(15);
      if (lookahead == '(') ADVANCE(295);
      if (lookahead == ')') ADVANCE(296);
      if (lookahead == '*') ADVANCE(323);
      if (lookahead == '+') ADVANCE(313);
      if (lookahead == ',') ADVANCE(307);
      if (lookahead == '-') ADVANCE(18);
      if (lookahead == '.') ADVANCE(304);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(390);
      if (lookahead == ':') ADVANCE(293);
      if (lookahead == '<') ADVANCE(417);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(420);
      if (lookahead == '?') ADVANCE(305);
      if (lookahead == '@') ADVANCE(421);
      if (lookahead == '[') ADVANCE(306);
      if (lookahead == '\\') ADVANCE(300);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '`') ADVANCE(145);
      if (lookahead == 'h') ADVANCE(288);
      if (lookahead == '{') ADVANCE(327);
      if (lookahead == '|') ADVANCE(419);
      if (lookahead == '}') ADVANCE(328);
      if (lookahead == '~') ADVANCE(57);
      if (lookahead == 955) ADVANCE(299);
      if (lookahead == 8594) ADVANCE(297);
      if (lookahead == 8704) ADVANCE(294);
      if (lookahead == 8743) ADVANCE(317);
      if (lookahead == 8801) ADVANCE(309);
      if (lookahead == 10835) ADVANCE(321);
      if (lookahead == 11005) ADVANCE(319);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(289);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(271)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(391);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 272:
      if (eof) ADVANCE(275);
      if (lookahead == '!') ADVANCE(129);
      if (lookahead == '"') ADVANCE(402);
      if (lookahead == '#') ADVANCE(315);
      if (lookahead == '&') ADVANCE(13);
      if (lookahead == '\'') ADVANCE(15);
      if (lookahead == '(') ADVANCE(295);
      if (lookahead == ')') ADVANCE(296);
      if (lookahead == '*') ADVANCE(323);
      if (lookahead == '+') ADVANCE(313);
      if (lookahead == ',') ADVANCE(307);
      if (lookahead == '-') ADVANCE(18);
      if (lookahead == '.') ADVANCE(304);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(390);
      if (lookahead == ':') ADVANCE(293);
      if (lookahead == '<') ADVANCE(417);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(420);
      if (lookahead == '?') ADVANCE(305);
      if (lookahead == '@') ADVANCE(421);
      if (lookahead == '[') ADVANCE(306);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '`') ADVANCE(145);
      if (lookahead == 'h') ADVANCE(288);
      if (lookahead == 's') ADVANCE(285);
      if (lookahead == '{') ADVANCE(327);
      if (lookahead == '|') ADVANCE(419);
      if (lookahead == '}') ADVANCE(328);
      if (lookahead == '~') ADVANCE(57);
      if (lookahead == 8594) ADVANCE(297);
      if (lookahead == 8743) ADVANCE(317);
      if (lookahead == 8801) ADVANCE(309);
      if (lookahead == 10835) ADVANCE(321);
      if (lookahead == 11005) ADVANCE(319);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(289);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(272)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(391);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 273:
      if (eof) ADVANCE(275);
      if (lookahead == '!') ADVANCE(129);
      if (lookahead == '#') ADVANCE(315);
      if (lookahead == '&') ADVANCE(13);
      if (lookahead == ')') ADVANCE(296);
      if (lookahead == '*') ADVANCE(323);
      if (lookahead == '+') ADVANCE(312);
      if (lookahead == ',') ADVANCE(307);
      if (lookahead == '-') ADVANCE(20);
      if (lookahead == '/') ADVANCE(58);
      if (lookahead == '0') ADVANCE(394);
      if (lookahead == ':') ADVANCE(292);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(420);
      if (lookahead == '?') ADVANCE(305);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '`') ADVANCE(145);
      if (lookahead == '{') ADVANCE(21);
      if (lookahead == '|') ADVANCE(419);
      if (lookahead == '}') ADVANCE(328);
      if (lookahead == 8594) ADVANCE(297);
      if (lookahead == 8743) ADVANCE(317);
      if (lookahead == 8801) ADVANCE(309);
      if (lookahead == 10835) ADVANCE(321);
      if (lookahead == 11005) ADVANCE(319);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(273)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(395);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 274:
      if (eof) ADVANCE(275);
      if (lookahead == '"') ADVANCE(402);
      if (lookahead == '\'') ADVANCE(15);
      if (lookahead == '(') ADVANCE(295);
      if (lookahead == ')') ADVANCE(296);
      if (lookahead == '+') ADVANCE(61);
      if (lookahead == ',') ADVANCE(307);
      if (lookahead == '-') ADVANCE(19);
      if (lookahead == '0') ADVANCE(390);
      if (lookahead == '<') ADVANCE(417);
      if (lookahead == '=') ADVANCE(302);
      if (lookahead == '>') ADVANCE(420);
      if (lookahead == '?') ADVANCE(305);
      if (lookahead == '[') ADVANCE(306);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '`') ADVANCE(145);
      if (lookahead == '{') ADVANCE(327);
      if (lookahead == '|') ADVANCE(418);
      if (lookahead == '}') ADVANCE(328);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(274)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(391);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_label);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_label);
      if (lookahead == '2') ADVANCE(278);
      if (lookahead == '-' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_label);
      if (lookahead == '5') ADVANCE(279);
      if (lookahead == '-' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_label);
      if (lookahead == '6') ADVANCE(283);
      if (lookahead == '-' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_label);
      if (lookahead == ':') ADVANCE(369);
      if (lookahead == '-' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_label);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == 's') ADVANCE(282);
      if (lookahead == '-' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_label);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == '-' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_label);
      if (lookahead == ':') ADVANCE(266);
      if (lookahead == '-' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_label);
      if (lookahead == 'a') ADVANCE(277);
      if (lookahead == '-' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_label);
      if (lookahead == 'h') ADVANCE(284);
      if (lookahead == '-' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_label);
      if (lookahead == 'p') ADVANCE(281);
      if (lookahead == '-' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_label);
      if (lookahead == 't') ADVANCE(286);
      if (lookahead == '-' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_label);
      if (lookahead == 't') ADVANCE(287);
      if (lookahead == '-' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_label);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(290);
      if (lookahead == '-' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_label);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(280);
      if (lookahead == '-' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_label);
      if (lookahead == '-' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(291);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(326);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_2);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_3);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead == 'u') ADVANCE(156);
      if (sym_double_quote_escaped_character_set_1(lookahead)) ADVANCE(407);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(324);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '/') ADVANCE(5);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_4);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(314);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(314);
      if (lookahead == '0') ADVANCE(398);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(399);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_5);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_SLASH_BSLASH);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_6);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '\\') ADVANCE(131);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_7);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_BSLASH_BSLASH);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(310);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '-') ADVANCE(378);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_import_hash);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_local_import);
      if (lookahead == '"') ADVANCE(330);
      if (lookahead == '/') ADVANCE(5);
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '\\') ADVANCE(6);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_local_import);
      if (lookahead == '/') ADVANCE(5);
      if (!sym_local_import_character_set_3(lookahead)) ADVANCE(331);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '.') ADVANCE(346);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(348);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(333);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '.') ADVANCE(346);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(348);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(334);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '.') ADVANCE(346);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(348);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '.') ADVANCE(347);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(348);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(337);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '.') ADVANCE(347);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(348);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(335);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '.') ADVANCE(347);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(348);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '.') ADVANCE(344);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(348);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(339);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '.') ADVANCE(344);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(348);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(340);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '.') ADVANCE(344);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(348);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '.') ADVANCE(345);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(348);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(342);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '.') ADVANCE(345);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(348);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(343);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '.') ADVANCE(345);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(348);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(348);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(336);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(348);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(338);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(348);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(341);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == ';' ||
          lookahead == '=' ||
          lookahead == '_' ||
          lookahead == '~') ADVANCE(12);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(348);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(337);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(199);
      if (sym_http_raw_character_set_3(lookahead)) ADVANCE(12);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == '?') ADVANCE(350);
      if (lookahead == '@') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(348);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(200);
      if (sym_http_raw_character_set_4(lookahead)) ADVANCE(349);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == '?') ADVANCE(350);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '%') ADVANCE(201);
      if (sym_http_raw_character_set_5(lookahead)) ADVANCE(350);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '.') ADVANCE(366);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '.') ADVANCE(366);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(353);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '.') ADVANCE(366);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '.') ADVANCE(367);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(356);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '.') ADVANCE(367);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(354);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '.') ADVANCE(367);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '.') ADVANCE(364);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(358);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '.') ADVANCE(364);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(359);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '.') ADVANCE(364);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '.') ADVANCE(365);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(361);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '.') ADVANCE(365);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(362);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '.') ADVANCE(365);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(355);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(357);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(360);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == ':') ADVANCE(368);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(356);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_http_raw);
      if (lookahead == '/') ADVANCE(349);
      if (lookahead == '?') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(368);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(aux_sym_env_import_token1);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym__env_bash);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym__env_posix);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_line_comment_prefix);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_line_comment_prefix);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(377);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_line_comment_content);
      if (lookahead == '-') ADVANCE(375);
      if (lookahead == '{') ADVANCE(376);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(374);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(377);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_line_comment_content);
      if (lookahead == '-') ADVANCE(373);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(377);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_line_comment_content);
      if (lookahead == '-') ADVANCE(379);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(377);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_line_comment_content);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(377);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_block_comment_open);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_block_comment_open);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(377);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_block_comment_close);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_temporal_literal);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_temporal_literal);
      if (lookahead == '.') ADVANCE(171);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(186);
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(381);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_temporal_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(186);
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(381);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(383);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_temporal_literal);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(188);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(anon_sym_DASHInfinity);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(aux_sym_double_literal_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(386);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(aux_sym_double_literal_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(387);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_natural_literal);
      if (lookahead == '-') ADVANCE(179);
      if (lookahead == '.') ADVANCE(165);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(393);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_natural_literal);
      if (lookahead == '.') ADVANCE(165);
      if (lookahead == ':') ADVANCE(176);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(392);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_natural_literal);
      if (lookahead == '.') ADVANCE(165);
      if (lookahead == 'x') ADVANCE(192);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(25);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_natural_literal);
      if (lookahead == '.') ADVANCE(165);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(389);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_natural_literal);
      if (lookahead == '.') ADVANCE(165);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(388);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_natural_literal);
      if (lookahead == '.') ADVANCE(165);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(393);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_natural_literal);
      if (lookahead == 'x') ADVANCE(192);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_natural_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(395);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_natural_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(396);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '.') ADVANCE(165);
      if (lookahead == ':') ADVANCE(178);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(400);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '.') ADVANCE(165);
      if (lookahead == 'x') ADVANCE(193);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(26);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '.') ADVANCE(165);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(397);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '.') ADVANCE(165);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(400);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_integer_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(401);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(aux_sym__double_quote_chunk_token1);
      if (lookahead == ' ') ADVANCE(403);
      if (lookahead == '-') ADVANCE(404);
      if (lookahead == '{') ADVANCE(404);
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(405);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(aux_sym__double_quote_chunk_token1);
      if (lookahead == '-') ADVANCE(405);
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(405);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(aux_sym__double_quote_chunk_token1);
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(405);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{') ADVANCE(416);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_double_quote_escaped);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE);
      if (lookahead == '$') ADVANCE(155);
      if (lookahead == '\'') ADVANCE(415);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(410);
      if (lookahead == '\r') ADVANCE(1);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(aux_sym__single_quote_chunk_token1);
      if (lookahead == '-') ADVANCE(412);
      if (lookahead == '{') ADVANCE(412);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(411);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'') ADVANCE(413);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(aux_sym__single_quote_chunk_token1);
      if (lookahead == '-') ADVANCE(413);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'') ADVANCE(413);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(aux_sym__single_quote_chunk_token1);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'') ADVANCE(413);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (lookahead == '\'') ADVANCE(409);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym_single_quote_escaped);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(311);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'B') ADVANCE(1);
      if (lookahead == 'D') ADVANCE(2);
      if (lookahead == 'F') ADVANCE(3);
      if (lookahead == 'I') ADVANCE(4);
      if (lookahead == 'K') ADVANCE(5);
      if (lookahead == 'L') ADVANCE(6);
      if (lookahead == 'N') ADVANCE(7);
      if (lookahead == 'O') ADVANCE(8);
      if (lookahead == 'S') ADVANCE(9);
      if (lookahead == 'T') ADVANCE(10);
      if (lookahead == 'a') ADVANCE(11);
      if (lookahead == 'e') ADVANCE(12);
      if (lookahead == 'f') ADVANCE(13);
      if (lookahead == 'i') ADVANCE(14);
      if (lookahead == 'l') ADVANCE(15);
      if (lookahead == 'm') ADVANCE(16);
      if (lookahead == 's') ADVANCE(17);
      if (lookahead == 't') ADVANCE(18);
      if (lookahead == 'u') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'o') ADVANCE(21);
      END_STATE();
    case 2:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == 'n') ADVANCE(25);
      END_STATE();
    case 5:
      if (lookahead == 'i') ADVANCE(26);
      END_STATE();
    case 6:
      if (lookahead == 'i') ADVANCE(27);
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 8:
      if (lookahead == 'p') ADVANCE(31);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(33);
      if (lookahead == 'i') ADVANCE(34);
      if (lookahead == 'r') ADVANCE(35);
      if (lookahead == 'y') ADVANCE(36);
      END_STATE();
    case 11:
      if (lookahead == 's') ADVANCE(37);
      END_STATE();
    case 12:
      if (lookahead == 'l') ADVANCE(38);
      END_STATE();
    case 13:
      if (lookahead == 'o') ADVANCE(39);
      END_STATE();
    case 14:
      if (lookahead == 'f') ADVANCE(40);
      if (lookahead == 'n') ADVANCE(41);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'i') ADVANCE(44);
      END_STATE();
    case 17:
      if (lookahead == 'h') ADVANCE(45);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(46);
      if (lookahead == 'o') ADVANCE(47);
      END_STATE();
    case 19:
      if (lookahead == 's') ADVANCE(48);
      END_STATE();
    case 20:
      if (lookahead == 'i') ADVANCE(49);
      END_STATE();
    case 21:
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 22:
      if (lookahead == 't') ADVANCE(51);
      END_STATE();
    case 23:
      if (lookahead == 'u') ADVANCE(52);
      END_STATE();
    case 24:
      if (lookahead == 'l') ADVANCE(53);
      END_STATE();
    case 25:
      if (lookahead == 'f') ADVANCE(54);
      if (lookahead == 't') ADVANCE(55);
      END_STATE();
    case 26:
      if (lookahead == 'n') ADVANCE(56);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(57);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(58);
      END_STATE();
    case 29:
      if (lookahead == 'N') ADVANCE(59);
      if (lookahead == 't') ADVANCE(60);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(61);
      END_STATE();
    case 31:
      if (lookahead == 't') ADVANCE(62);
      END_STATE();
    case 32:
      if (lookahead == 'm') ADVANCE(63);
      if (lookahead == 'r') ADVANCE(64);
      END_STATE();
    case 33:
      if (lookahead == 'x') ADVANCE(65);
      END_STATE();
    case 34:
      if (lookahead == 'm') ADVANCE(66);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(67);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(68);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(69);
      END_STATE();
    case 38:
      if (lookahead == 's') ADVANCE(70);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(71);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(72);
      END_STATE();
    case 43:
      if (lookahead == 'r') ADVANCE(73);
      END_STATE();
    case 44:
      if (lookahead == 's') ADVANCE(74);
      END_STATE();
    case 45:
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(76);
      END_STATE();
    case 47:
      if (lookahead == 'M') ADVANCE(77);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(78);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(79);
      END_STATE();
    case 50:
      if (lookahead == 'l') ADVANCE(80);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(81);
      END_STATE();
    case 52:
      if (lookahead == 'b') ADVANCE(82);
      END_STATE();
    case 53:
      if (lookahead == 's') ADVANCE(83);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(84);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(85);
      END_STATE();
    case 56:
      if (lookahead == 'd') ADVANCE(86);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(88);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_NaN);
      END_STATE();
    case 60:
      if (lookahead == 'u') ADVANCE(89);
      END_STATE();
    case 61:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(91);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 64:
      if (lookahead == 't') ADVANCE(93);
      END_STATE();
    case 65:
      if (lookahead == 't') ADVANCE(94);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 70:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 71:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 73:
      if (lookahead == 'g') ADVANCE(101);
      END_STATE();
    case 74:
      if (lookahead == 's') ADVANCE(102);
      END_STATE();
    case 75:
      if (lookahead == 'w') ADVANCE(103);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(104);
      END_STATE();
    case 77:
      if (lookahead == 'a') ADVANCE(105);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(106);
      END_STATE();
    case 79:
      if (lookahead == 'h') ADVANCE(107);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_Bool);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_Date);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(108);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 84:
      if (lookahead == 'n') ADVANCE(110);
      END_STATE();
    case 85:
      if (lookahead == 'g') ADVANCE(111);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_Kind);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_List);
      if (lookahead == '/') ADVANCE(112);
      END_STATE();
    case 88:
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 89:
      if (lookahead == 'r') ADVANCE(114);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_None);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(115);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_Some);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_Sort);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_Text);
      if (lookahead == '/') ADVANCE(116);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_Time);
      if (lookahead == 'Z') ADVANCE(117);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_True);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_Type);
      END_STATE();
    case 98:
      if (lookahead == 'r') ADVANCE(118);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 100:
      if (lookahead == 'l') ADVANCE(119);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 102:
      if (lookahead == 'i') ADVANCE(121);
      END_STATE();
    case 103:
      if (lookahead == 'C') ADVANCE(122);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 105:
      if (lookahead == 'p') ADVANCE(123);
      END_STATE();
    case 106:
      if (lookahead == 'g') ADVANCE(124);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(125);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_False);
      END_STATE();
    case 110:
      if (lookahead == 'i') ADVANCE(126);
      END_STATE();
    case 111:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 112:
      if (lookahead == 'b') ADVANCE(128);
      if (lookahead == 'f') ADVANCE(129);
      if (lookahead == 'h') ADVANCE(130);
      if (lookahead == 'i') ADVANCE(131);
      if (lookahead == 'l') ADVANCE(132);
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 113:
      if (lookahead == 'i') ADVANCE(134);
      END_STATE();
    case 114:
      if (lookahead == 'a') ADVANCE(135);
      END_STATE();
    case 115:
      if (lookahead == 'n') ADVANCE(136);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(137);
      if (lookahead == 's') ADVANCE(138);
      END_STATE();
    case 117:
      if (lookahead == 'o') ADVANCE(139);
      END_STATE();
    case 118:
      if (lookahead == 't') ADVANCE(140);
      END_STATE();
    case 119:
      if (lookahead == 'l') ADVANCE(141);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_merge);
      END_STATE();
    case 121:
      if (lookahead == 'n') ADVANCE(142);
      END_STATE();
    case 122:
      if (lookahead == 'o') ADVANCE(143);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_toMap);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_Double);
      if (lookahead == '/') ADVANCE(144);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(145);
      END_STATE();
    case 127:
      if (lookahead == 'r') ADVANCE(146);
      END_STATE();
    case 128:
      if (lookahead == 'u') ADVANCE(147);
      END_STATE();
    case 129:
      if (lookahead == 'o') ADVANCE(148);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 131:
      if (lookahead == 'n') ADVANCE(150);
      END_STATE();
    case 132:
      if (lookahead == 'a') ADVANCE(151);
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 133:
      if (lookahead == 'e') ADVANCE(153);
      END_STATE();
    case 134:
      if (lookahead == 'o') ADVANCE(154);
      END_STATE();
    case 135:
      if (lookahead == 'l') ADVANCE(155);
      END_STATE();
    case 136:
      if (lookahead == 'a') ADVANCE(156);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 138:
      if (lookahead == 'h') ADVANCE(158);
      END_STATE();
    case 139:
      if (lookahead == 'n') ADVANCE(159);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_forall);
      END_STATE();
    case 142:
      if (lookahead == 'g') ADVANCE(160);
      END_STATE();
    case 143:
      if (lookahead == 'n') ADVANCE(161);
      END_STATE();
    case 144:
      if (lookahead == 's') ADVANCE(162);
      END_STATE();
    case 145:
      if (lookahead == 'y') ADVANCE(163);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_Integer);
      if (lookahead == '/') ADVANCE(164);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(165);
      END_STATE();
    case 148:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 149:
      if (lookahead == 'a') ADVANCE(167);
      END_STATE();
    case 150:
      if (lookahead == 'd') ADVANCE(168);
      END_STATE();
    case 151:
      if (lookahead == 's') ADVANCE(169);
      END_STATE();
    case 152:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 153:
      if (lookahead == 'v') ADVANCE(171);
      END_STATE();
    case 154:
      if (lookahead == 'n') ADVANCE(172);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_Natural);
      if (lookahead == '/') ADVANCE(173);
      END_STATE();
    case 156:
      if (lookahead == 'l') ADVANCE(174);
      END_STATE();
    case 157:
      if (lookahead == 'p') ADVANCE(175);
      END_STATE();
    case 158:
      if (lookahead == 'o') ADVANCE(176);
      END_STATE();
    case 159:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_missing);
      END_STATE();
    case 161:
      if (lookahead == 's') ADVANCE(178);
      END_STATE();
    case 162:
      if (lookahead == 'h') ADVANCE(179);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_Infinity);
      END_STATE();
    case 164:
      if (lookahead == 'c') ADVANCE(180);
      if (lookahead == 'n') ADVANCE(181);
      if (lookahead == 's') ADVANCE(182);
      if (lookahead == 't') ADVANCE(183);
      END_STATE();
    case 165:
      if (lookahead == 'l') ADVANCE(184);
      END_STATE();
    case 166:
      if (lookahead == 'd') ADVANCE(185);
      END_STATE();
    case 167:
      if (lookahead == 'd') ADVANCE(186);
      END_STATE();
    case 168:
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 169:
      if (lookahead == 't') ADVANCE(188);
      END_STATE();
    case 170:
      if (lookahead == 'g') ADVANCE(189);
      END_STATE();
    case 171:
      if (lookahead == 'e') ADVANCE(190);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_Location);
      END_STATE();
    case 173:
      if (lookahead == 'b') ADVANCE(191);
      if (lookahead == 'e') ADVANCE(192);
      if (lookahead == 'f') ADVANCE(193);
      if (lookahead == 'i') ADVANCE(194);
      if (lookahead == 'o') ADVANCE(195);
      if (lookahead == 's') ADVANCE(196);
      if (lookahead == 't') ADVANCE(197);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_Optional);
      END_STATE();
    case 175:
      if (lookahead == 'l') ADVANCE(198);
      END_STATE();
    case 176:
      if (lookahead == 'w') ADVANCE(199);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_TimeZone);
      END_STATE();
    case 178:
      if (lookahead == 't') ADVANCE(200);
      END_STATE();
    case 179:
      if (lookahead == 'o') ADVANCE(201);
      END_STATE();
    case 180:
      if (lookahead == 'l') ADVANCE(202);
      END_STATE();
    case 181:
      if (lookahead == 'e') ADVANCE(203);
      END_STATE();
    case 182:
      if (lookahead == 'h') ADVANCE(204);
      END_STATE();
    case 183:
      if (lookahead == 'o') ADVANCE(205);
      END_STATE();
    case 184:
      if (lookahead == 'd') ADVANCE(206);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_List_SLASHfold);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_List_SLASHhead);
      END_STATE();
    case 187:
      if (lookahead == 'x') ADVANCE(207);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_List_SLASHlast);
      END_STATE();
    case 189:
      if (lookahead == 't') ADVANCE(208);
      END_STATE();
    case 190:
      if (lookahead == 'r') ADVANCE(209);
      END_STATE();
    case 191:
      if (lookahead == 'u') ADVANCE(210);
      END_STATE();
    case 192:
      if (lookahead == 'v') ADVANCE(211);
      END_STATE();
    case 193:
      if (lookahead == 'o') ADVANCE(212);
      END_STATE();
    case 194:
      if (lookahead == 's') ADVANCE(213);
      END_STATE();
    case 195:
      if (lookahead == 'd') ADVANCE(214);
      END_STATE();
    case 196:
      if (lookahead == 'h') ADVANCE(215);
      if (lookahead == 'u') ADVANCE(216);
      END_STATE();
    case 197:
      if (lookahead == 'o') ADVANCE(217);
      END_STATE();
    case 198:
      if (lookahead == 'a') ADVANCE(218);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_Text_SLASHshow);
      END_STATE();
    case 200:
      if (lookahead == 'r') ADVANCE(219);
      END_STATE();
    case 201:
      if (lookahead == 'w') ADVANCE(220);
      END_STATE();
    case 202:
      if (lookahead == 'a') ADVANCE(221);
      END_STATE();
    case 203:
      if (lookahead == 'g') ADVANCE(222);
      END_STATE();
    case 204:
      if (lookahead == 'o') ADVANCE(223);
      END_STATE();
    case 205:
      if (lookahead == 'D') ADVANCE(224);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_List_SLASHbuild);
      END_STATE();
    case 207:
      if (lookahead == 'e') ADVANCE(225);
      END_STATE();
    case 208:
      if (lookahead == 'h') ADVANCE(226);
      END_STATE();
    case 209:
      if (lookahead == 's') ADVANCE(227);
      END_STATE();
    case 210:
      if (lookahead == 'i') ADVANCE(228);
      END_STATE();
    case 211:
      if (lookahead == 'e') ADVANCE(229);
      END_STATE();
    case 212:
      if (lookahead == 'l') ADVANCE(230);
      END_STATE();
    case 213:
      if (lookahead == 'Z') ADVANCE(231);
      END_STATE();
    case 214:
      if (lookahead == 'd') ADVANCE(232);
      END_STATE();
    case 215:
      if (lookahead == 'o') ADVANCE(233);
      END_STATE();
    case 216:
      if (lookahead == 'b') ADVANCE(234);
      END_STATE();
    case 217:
      if (lookahead == 'I') ADVANCE(235);
      END_STATE();
    case 218:
      if (lookahead == 'c') ADVANCE(236);
      END_STATE();
    case 219:
      if (lookahead == 'u') ADVANCE(237);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_Double_SLASHshow);
      END_STATE();
    case 221:
      if (lookahead == 'm') ADVANCE(238);
      END_STATE();
    case 222:
      if (lookahead == 'a') ADVANCE(239);
      END_STATE();
    case 223:
      if (lookahead == 'w') ADVANCE(240);
      END_STATE();
    case 224:
      if (lookahead == 'o') ADVANCE(241);
      END_STATE();
    case 225:
      if (lookahead == 'd') ADVANCE(242);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_List_SLASHlength);
      END_STATE();
    case 227:
      if (lookahead == 'e') ADVANCE(243);
      END_STATE();
    case 228:
      if (lookahead == 'l') ADVANCE(244);
      END_STATE();
    case 229:
      if (lookahead == 'n') ADVANCE(245);
      END_STATE();
    case 230:
      if (lookahead == 'd') ADVANCE(246);
      END_STATE();
    case 231:
      if (lookahead == 'e') ADVANCE(247);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_Natural_SLASHodd);
      END_STATE();
    case 233:
      if (lookahead == 'w') ADVANCE(248);
      END_STATE();
    case 234:
      if (lookahead == 't') ADVANCE(249);
      END_STATE();
    case 235:
      if (lookahead == 'n') ADVANCE(250);
      END_STATE();
    case 236:
      if (lookahead == 'e') ADVANCE(251);
      END_STATE();
    case 237:
      if (lookahead == 'c') ADVANCE(252);
      END_STATE();
    case 238:
      if (lookahead == 'p') ADVANCE(253);
      END_STATE();
    case 239:
      if (lookahead == 't') ADVANCE(254);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_Integer_SLASHshow);
      END_STATE();
    case 241:
      if (lookahead == 'u') ADVANCE(255);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_List_SLASHindexed);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_List_SLASHreverse);
      END_STATE();
    case 244:
      if (lookahead == 'd') ADVANCE(256);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_Natural_SLASHeven);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_Natural_SLASHfold);
      END_STATE();
    case 247:
      if (lookahead == 'r') ADVANCE(257);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_Natural_SLASHshow);
      END_STATE();
    case 249:
      if (lookahead == 'r') ADVANCE(258);
      END_STATE();
    case 250:
      if (lookahead == 't') ADVANCE(259);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_Text_SLASHreplace);
      END_STATE();
    case 252:
      if (lookahead == 't') ADVANCE(260);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_Integer_SLASHclamp);
      END_STATE();
    case 254:
      if (lookahead == 'e') ADVANCE(261);
      END_STATE();
    case 255:
      if (lookahead == 'b') ADVANCE(262);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_Natural_SLASHbuild);
      END_STATE();
    case 257:
      if (lookahead == 'o') ADVANCE(263);
      END_STATE();
    case 258:
      if (lookahead == 'a') ADVANCE(264);
      END_STATE();
    case 259:
      if (lookahead == 'e') ADVANCE(265);
      END_STATE();
    case 260:
      if (lookahead == 'o') ADVANCE(266);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_Integer_SLASHnegate);
      END_STATE();
    case 262:
      if (lookahead == 'l') ADVANCE(267);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_Natural_SLASHisZero);
      END_STATE();
    case 264:
      if (lookahead == 'c') ADVANCE(268);
      END_STATE();
    case 265:
      if (lookahead == 'g') ADVANCE(269);
      END_STATE();
    case 266:
      if (lookahead == 'r') ADVANCE(270);
      END_STATE();
    case 267:
      if (lookahead == 'e') ADVANCE(271);
      END_STATE();
    case 268:
      if (lookahead == 't') ADVANCE(272);
      END_STATE();
    case 269:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_showConstructor);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_Integer_SLASHtoDouble);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_Natural_SLASHsubtract);
      END_STATE();
    case 273:
      if (lookahead == 'r') ADVANCE(274);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_Natural_SLASHtoInteger);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 271},
  [2] = {.lex_state = 271},
  [3] = {.lex_state = 271},
  [4] = {.lex_state = 271},
  [5] = {.lex_state = 271},
  [6] = {.lex_state = 271},
  [7] = {.lex_state = 271},
  [8] = {.lex_state = 271},
  [9] = {.lex_state = 271},
  [10] = {.lex_state = 271},
  [11] = {.lex_state = 271},
  [12] = {.lex_state = 271},
  [13] = {.lex_state = 271},
  [14] = {.lex_state = 271},
  [15] = {.lex_state = 271},
  [16] = {.lex_state = 271},
  [17] = {.lex_state = 271},
  [18] = {.lex_state = 271},
  [19] = {.lex_state = 271},
  [20] = {.lex_state = 271},
  [21] = {.lex_state = 271},
  [22] = {.lex_state = 271},
  [23] = {.lex_state = 271},
  [24] = {.lex_state = 271},
  [25] = {.lex_state = 271},
  [26] = {.lex_state = 271},
  [27] = {.lex_state = 271},
  [28] = {.lex_state = 271},
  [29] = {.lex_state = 271},
  [30] = {.lex_state = 271},
  [31] = {.lex_state = 271},
  [32] = {.lex_state = 271},
  [33] = {.lex_state = 271},
  [34] = {.lex_state = 271},
  [35] = {.lex_state = 271},
  [36] = {.lex_state = 271},
  [37] = {.lex_state = 271},
  [38] = {.lex_state = 271},
  [39] = {.lex_state = 271},
  [40] = {.lex_state = 271},
  [41] = {.lex_state = 271},
  [42] = {.lex_state = 271},
  [43] = {.lex_state = 271},
  [44] = {.lex_state = 271},
  [45] = {.lex_state = 271},
  [46] = {.lex_state = 271},
  [47] = {.lex_state = 271},
  [48] = {.lex_state = 271},
  [49] = {.lex_state = 271},
  [50] = {.lex_state = 271},
  [51] = {.lex_state = 271},
  [52] = {.lex_state = 271},
  [53] = {.lex_state = 271},
  [54] = {.lex_state = 271},
  [55] = {.lex_state = 271},
  [56] = {.lex_state = 271},
  [57] = {.lex_state = 271},
  [58] = {.lex_state = 271},
  [59] = {.lex_state = 271},
  [60] = {.lex_state = 271},
  [61] = {.lex_state = 271},
  [62] = {.lex_state = 271},
  [63] = {.lex_state = 271},
  [64] = {.lex_state = 271},
  [65] = {.lex_state = 271},
  [66] = {.lex_state = 271},
  [67] = {.lex_state = 271},
  [68] = {.lex_state = 271},
  [69] = {.lex_state = 271},
  [70] = {.lex_state = 271},
  [71] = {.lex_state = 271},
  [72] = {.lex_state = 271},
  [73] = {.lex_state = 271},
  [74] = {.lex_state = 271},
  [75] = {.lex_state = 271},
  [76] = {.lex_state = 271},
  [77] = {.lex_state = 271},
  [78] = {.lex_state = 271},
  [79] = {.lex_state = 271},
  [80] = {.lex_state = 271},
  [81] = {.lex_state = 271},
  [82] = {.lex_state = 271},
  [83] = {.lex_state = 271},
  [84] = {.lex_state = 271},
  [85] = {.lex_state = 271},
  [86] = {.lex_state = 271},
  [87] = {.lex_state = 271},
  [88] = {.lex_state = 271},
  [89] = {.lex_state = 271},
  [90] = {.lex_state = 271},
  [91] = {.lex_state = 271},
  [92] = {.lex_state = 271},
  [93] = {.lex_state = 271},
  [94] = {.lex_state = 271},
  [95] = {.lex_state = 271},
  [96] = {.lex_state = 271},
  [97] = {.lex_state = 271},
  [98] = {.lex_state = 271},
  [99] = {.lex_state = 271},
  [100] = {.lex_state = 271},
  [101] = {.lex_state = 271},
  [102] = {.lex_state = 271},
  [103] = {.lex_state = 271},
  [104] = {.lex_state = 271},
  [105] = {.lex_state = 271},
  [106] = {.lex_state = 271},
  [107] = {.lex_state = 271},
  [108] = {.lex_state = 271},
  [109] = {.lex_state = 271},
  [110] = {.lex_state = 271},
  [111] = {.lex_state = 271},
  [112] = {.lex_state = 271},
  [113] = {.lex_state = 271},
  [114] = {.lex_state = 271},
  [115] = {.lex_state = 271},
  [116] = {.lex_state = 271},
  [117] = {.lex_state = 271},
  [118] = {.lex_state = 272},
  [119] = {.lex_state = 272},
  [120] = {.lex_state = 272},
  [121] = {.lex_state = 272},
  [122] = {.lex_state = 272},
  [123] = {.lex_state = 272},
  [124] = {.lex_state = 272},
  [125] = {.lex_state = 272},
  [126] = {.lex_state = 272},
  [127] = {.lex_state = 272},
  [128] = {.lex_state = 272},
  [129] = {.lex_state = 272},
  [130] = {.lex_state = 272},
  [131] = {.lex_state = 272},
  [132] = {.lex_state = 272},
  [133] = {.lex_state = 272},
  [134] = {.lex_state = 272},
  [135] = {.lex_state = 272},
  [136] = {.lex_state = 272},
  [137] = {.lex_state = 272},
  [138] = {.lex_state = 272},
  [139] = {.lex_state = 272},
  [140] = {.lex_state = 272},
  [141] = {.lex_state = 272},
  [142] = {.lex_state = 272},
  [143] = {.lex_state = 272},
  [144] = {.lex_state = 272},
  [145] = {.lex_state = 272},
  [146] = {.lex_state = 272},
  [147] = {.lex_state = 272},
  [148] = {.lex_state = 272},
  [149] = {.lex_state = 272},
  [150] = {.lex_state = 271},
  [151] = {.lex_state = 271},
  [152] = {.lex_state = 272},
  [153] = {.lex_state = 272},
  [154] = {.lex_state = 272},
  [155] = {.lex_state = 272},
  [156] = {.lex_state = 272},
  [157] = {.lex_state = 272},
  [158] = {.lex_state = 271},
  [159] = {.lex_state = 272},
  [160] = {.lex_state = 272},
  [161] = {.lex_state = 272},
  [162] = {.lex_state = 272},
  [163] = {.lex_state = 272},
  [164] = {.lex_state = 272},
  [165] = {.lex_state = 272},
  [166] = {.lex_state = 272},
  [167] = {.lex_state = 271},
  [168] = {.lex_state = 272},
  [169] = {.lex_state = 271},
  [170] = {.lex_state = 272},
  [171] = {.lex_state = 272},
  [172] = {.lex_state = 272},
  [173] = {.lex_state = 271},
  [174] = {.lex_state = 271},
  [175] = {.lex_state = 271},
  [176] = {.lex_state = 271},
  [177] = {.lex_state = 272},
  [178] = {.lex_state = 272},
  [179] = {.lex_state = 271},
  [180] = {.lex_state = 271},
  [181] = {.lex_state = 271},
  [182] = {.lex_state = 272},
  [183] = {.lex_state = 271},
  [184] = {.lex_state = 271},
  [185] = {.lex_state = 271},
  [186] = {.lex_state = 271},
  [187] = {.lex_state = 272},
  [188] = {.lex_state = 271},
  [189] = {.lex_state = 271},
  [190] = {.lex_state = 272},
  [191] = {.lex_state = 272},
  [192] = {.lex_state = 271},
  [193] = {.lex_state = 271},
  [194] = {.lex_state = 271},
  [195] = {.lex_state = 272},
  [196] = {.lex_state = 271},
  [197] = {.lex_state = 271},
  [198] = {.lex_state = 271},
  [199] = {.lex_state = 271},
  [200] = {.lex_state = 271},
  [201] = {.lex_state = 271},
  [202] = {.lex_state = 272},
  [203] = {.lex_state = 271},
  [204] = {.lex_state = 271},
  [205] = {.lex_state = 271},
  [206] = {.lex_state = 272},
  [207] = {.lex_state = 271},
  [208] = {.lex_state = 272},
  [209] = {.lex_state = 271},
  [210] = {.lex_state = 271},
  [211] = {.lex_state = 271},
  [212] = {.lex_state = 271},
  [213] = {.lex_state = 271},
  [214] = {.lex_state = 272},
  [215] = {.lex_state = 271},
  [216] = {.lex_state = 271},
  [217] = {.lex_state = 272},
  [218] = {.lex_state = 272},
  [219] = {.lex_state = 271},
  [220] = {.lex_state = 272},
  [221] = {.lex_state = 271},
  [222] = {.lex_state = 271},
  [223] = {.lex_state = 271},
  [224] = {.lex_state = 271},
  [225] = {.lex_state = 271},
  [226] = {.lex_state = 271},
  [227] = {.lex_state = 271},
  [228] = {.lex_state = 271},
  [229] = {.lex_state = 271},
  [230] = {.lex_state = 271},
  [231] = {.lex_state = 271},
  [232] = {.lex_state = 271},
  [233] = {.lex_state = 271},
  [234] = {.lex_state = 271},
  [235] = {.lex_state = 271},
  [236] = {.lex_state = 271},
  [237] = {.lex_state = 271},
  [238] = {.lex_state = 271},
  [239] = {.lex_state = 272},
  [240] = {.lex_state = 272},
  [241] = {.lex_state = 272},
  [242] = {.lex_state = 272},
  [243] = {.lex_state = 272},
  [244] = {.lex_state = 272},
  [245] = {.lex_state = 272},
  [246] = {.lex_state = 272},
  [247] = {.lex_state = 272},
  [248] = {.lex_state = 272},
  [249] = {.lex_state = 272},
  [250] = {.lex_state = 272},
  [251] = {.lex_state = 272},
  [252] = {.lex_state = 272},
  [253] = {.lex_state = 272},
  [254] = {.lex_state = 272},
  [255] = {.lex_state = 272},
  [256] = {.lex_state = 272},
  [257] = {.lex_state = 272},
  [258] = {.lex_state = 272},
  [259] = {.lex_state = 272},
  [260] = {.lex_state = 272},
  [261] = {.lex_state = 272},
  [262] = {.lex_state = 271},
  [263] = {.lex_state = 272},
  [264] = {.lex_state = 272},
  [265] = {.lex_state = 272},
  [266] = {.lex_state = 272},
  [267] = {.lex_state = 272},
  [268] = {.lex_state = 271},
  [269] = {.lex_state = 272},
  [270] = {.lex_state = 272},
  [271] = {.lex_state = 272},
  [272] = {.lex_state = 271},
  [273] = {.lex_state = 272},
  [274] = {.lex_state = 272},
  [275] = {.lex_state = 272},
  [276] = {.lex_state = 272},
  [277] = {.lex_state = 272},
  [278] = {.lex_state = 272},
  [279] = {.lex_state = 272},
  [280] = {.lex_state = 272},
  [281] = {.lex_state = 272},
  [282] = {.lex_state = 272},
  [283] = {.lex_state = 272},
  [284] = {.lex_state = 272},
  [285] = {.lex_state = 272},
  [286] = {.lex_state = 272},
  [287] = {.lex_state = 272},
  [288] = {.lex_state = 272},
  [289] = {.lex_state = 271},
  [290] = {.lex_state = 271},
  [291] = {.lex_state = 272},
  [292] = {.lex_state = 272},
  [293] = {.lex_state = 272},
  [294] = {.lex_state = 271},
  [295] = {.lex_state = 271},
  [296] = {.lex_state = 272},
  [297] = {.lex_state = 271},
  [298] = {.lex_state = 271},
  [299] = {.lex_state = 271},
  [300] = {.lex_state = 272},
  [301] = {.lex_state = 271},
  [302] = {.lex_state = 271},
  [303] = {.lex_state = 271},
  [304] = {.lex_state = 271},
  [305] = {.lex_state = 271},
  [306] = {.lex_state = 271},
  [307] = {.lex_state = 272},
  [308] = {.lex_state = 271},
  [309] = {.lex_state = 271},
  [310] = {.lex_state = 271},
  [311] = {.lex_state = 272},
  [312] = {.lex_state = 271},
  [313] = {.lex_state = 271},
  [314] = {.lex_state = 271},
  [315] = {.lex_state = 271},
  [316] = {.lex_state = 271},
  [317] = {.lex_state = 271},
  [318] = {.lex_state = 271},
  [319] = {.lex_state = 271},
  [320] = {.lex_state = 272},
  [321] = {.lex_state = 271},
  [322] = {.lex_state = 271},
  [323] = {.lex_state = 271},
  [324] = {.lex_state = 271},
  [325] = {.lex_state = 271},
  [326] = {.lex_state = 271},
  [327] = {.lex_state = 271},
  [328] = {.lex_state = 271},
  [329] = {.lex_state = 272},
  [330] = {.lex_state = 271},
  [331] = {.lex_state = 271},
  [332] = {.lex_state = 271},
  [333] = {.lex_state = 272},
  [334] = {.lex_state = 271},
  [335] = {.lex_state = 272},
  [336] = {.lex_state = 272},
  [337] = {.lex_state = 271},
  [338] = {.lex_state = 271},
  [339] = {.lex_state = 271},
  [340] = {.lex_state = 272},
  [341] = {.lex_state = 272},
  [342] = {.lex_state = 271},
  [343] = {.lex_state = 271},
  [344] = {.lex_state = 271},
  [345] = {.lex_state = 272},
  [346] = {.lex_state = 271},
  [347] = {.lex_state = 272},
  [348] = {.lex_state = 272},
  [349] = {.lex_state = 271},
  [350] = {.lex_state = 271},
  [351] = {.lex_state = 271},
  [352] = {.lex_state = 271},
  [353] = {.lex_state = 271},
  [354] = {.lex_state = 271},
  [355] = {.lex_state = 271},
  [356] = {.lex_state = 271},
  [357] = {.lex_state = 271},
  [358] = {.lex_state = 271},
  [359] = {.lex_state = 271},
  [360] = {.lex_state = 271},
  [361] = {.lex_state = 271},
  [362] = {.lex_state = 271},
  [363] = {.lex_state = 271},
  [364] = {.lex_state = 271},
  [365] = {.lex_state = 274},
  [366] = {.lex_state = 274},
  [367] = {.lex_state = 274},
  [368] = {.lex_state = 274},
  [369] = {.lex_state = 271},
  [370] = {.lex_state = 273},
  [371] = {.lex_state = 273},
  [372] = {.lex_state = 273},
  [373] = {.lex_state = 273},
  [374] = {.lex_state = 273},
  [375] = {.lex_state = 273},
  [376] = {.lex_state = 273},
  [377] = {.lex_state = 273},
  [378] = {.lex_state = 273},
  [379] = {.lex_state = 273},
  [380] = {.lex_state = 273},
  [381] = {.lex_state = 273},
  [382] = {.lex_state = 273},
  [383] = {.lex_state = 273},
  [384] = {.lex_state = 273},
  [385] = {.lex_state = 273},
  [386] = {.lex_state = 273},
  [387] = {.lex_state = 273},
  [388] = {.lex_state = 273},
  [389] = {.lex_state = 273},
  [390] = {.lex_state = 273},
  [391] = {.lex_state = 273},
  [392] = {.lex_state = 273},
  [393] = {.lex_state = 273},
  [394] = {.lex_state = 273},
  [395] = {.lex_state = 273},
  [396] = {.lex_state = 273},
  [397] = {.lex_state = 273},
  [398] = {.lex_state = 273},
  [399] = {.lex_state = 273},
  [400] = {.lex_state = 273},
  [401] = {.lex_state = 273},
  [402] = {.lex_state = 273},
  [403] = {.lex_state = 273},
  [404] = {.lex_state = 273},
  [405] = {.lex_state = 273},
  [406] = {.lex_state = 273},
  [407] = {.lex_state = 273},
  [408] = {.lex_state = 273},
  [409] = {.lex_state = 273},
  [410] = {.lex_state = 273},
  [411] = {.lex_state = 273},
  [412] = {.lex_state = 273},
  [413] = {.lex_state = 273},
  [414] = {.lex_state = 273},
  [415] = {.lex_state = 273},
  [416] = {.lex_state = 273},
  [417] = {.lex_state = 274},
  [418] = {.lex_state = 274},
  [419] = {.lex_state = 0},
  [420] = {.lex_state = 274},
  [421] = {.lex_state = 0},
  [422] = {.lex_state = 0},
  [423] = {.lex_state = 274},
  [424] = {.lex_state = 9},
  [425] = {.lex_state = 0},
  [426] = {.lex_state = 0},
  [427] = {.lex_state = 0},
  [428] = {.lex_state = 9},
  [429] = {.lex_state = 9},
  [430] = {.lex_state = 9},
  [431] = {.lex_state = 0},
  [432] = {.lex_state = 0},
  [433] = {.lex_state = 9},
  [434] = {.lex_state = 9},
  [435] = {.lex_state = 9},
  [436] = {.lex_state = 9},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 9},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 274},
  [441] = {.lex_state = 0},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 274},
  [444] = {.lex_state = 274},
  [445] = {.lex_state = 274},
  [446] = {.lex_state = 2},
  [447] = {.lex_state = 2},
  [448] = {.lex_state = 2},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 2},
  [451] = {.lex_state = 2},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 2},
  [454] = {.lex_state = 2},
  [455] = {.lex_state = 2},
  [456] = {.lex_state = 2},
  [457] = {.lex_state = 274},
  [458] = {.lex_state = 9},
  [459] = {.lex_state = 274},
  [460] = {.lex_state = 274},
  [461] = {.lex_state = 274},
  [462] = {.lex_state = 274},
  [463] = {.lex_state = 9},
  [464] = {.lex_state = 9},
  [465] = {.lex_state = 274},
  [466] = {.lex_state = 274},
  [467] = {.lex_state = 274},
  [468] = {.lex_state = 274},
  [469] = {.lex_state = 274},
  [470] = {.lex_state = 274},
  [471] = {.lex_state = 274},
  [472] = {.lex_state = 274},
  [473] = {.lex_state = 274},
  [474] = {.lex_state = 274},
  [475] = {.lex_state = 274},
  [476] = {.lex_state = 274},
  [477] = {.lex_state = 274},
  [478] = {.lex_state = 274},
  [479] = {.lex_state = 274},
  [480] = {.lex_state = 274},
  [481] = {.lex_state = 274},
  [482] = {.lex_state = 274},
  [483] = {.lex_state = 274},
  [484] = {.lex_state = 274},
  [485] = {.lex_state = 274},
  [486] = {.lex_state = 274},
  [487] = {.lex_state = 274},
  [488] = {.lex_state = 274},
  [489] = {.lex_state = 274},
  [490] = {.lex_state = 274},
  [491] = {.lex_state = 274},
  [492] = {.lex_state = 274},
  [493] = {.lex_state = 274},
  [494] = {.lex_state = 274},
  [495] = {.lex_state = 274},
  [496] = {.lex_state = 2},
  [497] = {.lex_state = 2},
  [498] = {.lex_state = 274},
  [499] = {.lex_state = 274},
  [500] = {.lex_state = 274},
  [501] = {.lex_state = 274},
  [502] = {.lex_state = 274},
  [503] = {.lex_state = 274},
  [504] = {.lex_state = 274},
  [505] = {.lex_state = 274},
  [506] = {.lex_state = 274},
  [507] = {.lex_state = 274},
  [508] = {.lex_state = 2},
  [509] = {.lex_state = 274},
  [510] = {.lex_state = 274},
  [511] = {.lex_state = 274},
  [512] = {.lex_state = 274},
  [513] = {.lex_state = 274},
  [514] = {.lex_state = 274},
  [515] = {.lex_state = 274},
  [516] = {.lex_state = 274},
  [517] = {.lex_state = 274},
  [518] = {.lex_state = 274},
  [519] = {.lex_state = 274},
  [520] = {.lex_state = 274},
  [521] = {.lex_state = 274},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 274},
  [524] = {.lex_state = 274},
  [525] = {.lex_state = 274},
  [526] = {.lex_state = 274},
  [527] = {.lex_state = 274},
  [528] = {.lex_state = 274},
  [529] = {.lex_state = 274},
  [530] = {.lex_state = 274},
  [531] = {.lex_state = 274},
  [532] = {.lex_state = 274},
  [533] = {.lex_state = 274},
  [534] = {.lex_state = 274},
  [535] = {.lex_state = 274},
  [536] = {.lex_state = 274},
  [537] = {.lex_state = 274},
  [538] = {.lex_state = 274},
  [539] = {.lex_state = 274},
  [540] = {.lex_state = 274},
  [541] = {.lex_state = 274},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 274},
  [544] = {.lex_state = 274},
  [545] = {.lex_state = 274},
  [546] = {.lex_state = 274},
  [547] = {.lex_state = 274},
  [548] = {.lex_state = 274},
  [549] = {.lex_state = 274},
  [550] = {.lex_state = 274},
  [551] = {.lex_state = 274},
  [552] = {.lex_state = 274},
  [553] = {.lex_state = 274},
  [554] = {.lex_state = 274},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 7},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 274},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 0},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 7},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 0},
  [617] = {.lex_state = 0},
  [618] = {.lex_state = 0},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 0},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 0},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 274},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 274},
  [658] = {.lex_state = 274},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 1},
  [665] = {.lex_state = 274},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 274},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 1},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 274},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 1},
  [678] = {.lex_state = 274},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 274},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 274},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 1},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 274},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 274},
  [699] = {.lex_state = 274},
  [700] = {.lex_state = 274},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 274},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 273},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 274},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 274},
  [727] = {.lex_state = 273},
  [728] = {.lex_state = 273},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 274},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 274},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 273},
  [736] = {.lex_state = 374},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 274},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 274},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 274},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 274},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 0, .external_lex_state = 2},
  [755] = {.lex_state = 274},
  [756] = {(TSStateId)(-1)},
  [757] = {(TSStateId)(-1)},
};

enum {
  ts_external_token_block_comment_content = 0,
  ts_external_token_block_comment_end = 1,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_block_comment_content] = sym_block_comment_content,
  [ts_external_token_block_comment_end] = sym_block_comment_end,
};

static const bool ts_external_scanner_states[3][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_block_comment_content] = true,
    [ts_external_token_block_comment_end] = true,
  },
  [2] = {
    [ts_external_token_block_comment_content] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_line_comment] = STATE(0),
    [sym_block_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_label] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_Some] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_merge] = ACTIONS(1),
    [anon_sym_missing] = ACTIONS(1),
    [anon_sym_Infinity] = ACTIONS(1),
    [anon_sym_NaN] = ACTIONS(1),
    [anon_sym_toMap] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_forall] = ACTIONS(1),
    [anon_sym_] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_showConstructor] = ACTIONS(1),
    [anon_sym_Natural_SLASHfold] = ACTIONS(1),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(1),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(1),
    [anon_sym_Natural_SLASHeven] = ACTIONS(1),
    [anon_sym_Natural_SLASHodd] = ACTIONS(1),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(1),
    [anon_sym_Natural_SLASHshow] = ACTIONS(1),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(1),
    [anon_sym_Integer_SLASHshow] = ACTIONS(1),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(1),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(1),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(1),
    [anon_sym_Double_SLASHshow] = ACTIONS(1),
    [anon_sym_List_SLASHbuild] = ACTIONS(1),
    [anon_sym_List_SLASHfold] = ACTIONS(1),
    [anon_sym_List_SLASHlength] = ACTIONS(1),
    [anon_sym_List_SLASHhead] = ACTIONS(1),
    [anon_sym_List_SLASHlast] = ACTIONS(1),
    [anon_sym_List_SLASHindexed] = ACTIONS(1),
    [anon_sym_List_SLASHreverse] = ACTIONS(1),
    [anon_sym_Text_SLASHshow] = ACTIONS(1),
    [anon_sym_Text_SLASHreplace] = ACTIONS(1),
    [anon_sym_Bool] = ACTIONS(1),
    [anon_sym_Optional] = ACTIONS(1),
    [anon_sym_None] = ACTIONS(1),
    [anon_sym_Natural] = ACTIONS(1),
    [anon_sym_Integer] = ACTIONS(1),
    [anon_sym_Double] = ACTIONS(1),
    [anon_sym_Text] = ACTIONS(1),
    [anon_sym_Date] = ACTIONS(1),
    [anon_sym_Time] = ACTIONS(1),
    [anon_sym_TimeZone] = ACTIONS(1),
    [anon_sym_List] = ACTIONS(1),
    [anon_sym_Type] = ACTIONS(1),
    [anon_sym_Kind] = ACTIONS(1),
    [anon_sym_Sort] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_2] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_3] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_4] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_5] = ACTIONS(1),
    [anon_sym_SLASH_BSLASH] = ACTIONS(1),
    [anon_sym_6] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_7] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_Location] = ACTIONS(1),
    [sym_import_hash] = ACTIONS(1),
    [sym_local_import] = ACTIONS(1),
    [sym_http_raw] = ACTIONS(1),
    [aux_sym_env_import_token1] = ACTIONS(1),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_block_comment_close] = ACTIONS(1),
    [sym_temporal_literal] = ACTIONS(1),
    [anon_sym_DASHInfinity] = ACTIONS(1),
    [aux_sym_double_literal_token1] = ACTIONS(1),
    [sym_natural_literal] = ACTIONS(1),
    [sym_integer_literal] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [sym_double_quote_escaped] = ACTIONS(1),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_single_quote_escaped] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_True] = ACTIONS(1),
    [anon_sym_False] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [sym_block_comment_content] = ACTIONS(1),
    [sym_block_comment_end] = ACTIONS(1),
  },
  [1] = {
    [sym_expression] = STATE(711),
    [sym_builtin] = STATE(331),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(666),
    [sym_forall_operator] = STATE(673),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(695),
    [sym__empty_list_literal_primitive] = STATE(696),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(402),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(73),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(1),
    [sym_block_comment] = STATE(1),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [aux_sym_let_expression_repeat1] = STATE(554),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [2] = {
    [sym_expression] = STATE(588),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(2),
    [sym_block_comment] = STATE(2),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(73),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [3] = {
    [sym_expression] = STATE(579),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(3),
    [sym_block_comment] = STATE(3),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(97),
    [anon_sym_RBRACK] = ACTIONS(73),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [4] = {
    [sym_expression] = STATE(588),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(4),
    [sym_block_comment] = STATE(4),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [5] = {
    [sym_expression] = STATE(667),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(5),
    [sym_block_comment] = STATE(5),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_RBRACK] = ACTIONS(101),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [6] = {
    [sym_expression] = STATE(579),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(6),
    [sym_block_comment] = STATE(6),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(103),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [7] = {
    [sym_expression] = STATE(667),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(7),
    [sym_block_comment] = STATE(7),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_RBRACK] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [8] = {
    [sym_expression] = STATE(667),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(8),
    [sym_block_comment] = STATE(8),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_RBRACK] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [9] = {
    [sym_expression] = STATE(667),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(9),
    [sym_block_comment] = STATE(9),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_RBRACK] = ACTIONS(109),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [10] = {
    [sym_expression] = STATE(667),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(10),
    [sym_block_comment] = STATE(10),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_RBRACK] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [11] = {
    [sym_expression] = STATE(629),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(11),
    [sym_block_comment] = STATE(11),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_RBRACK] = ACTIONS(113),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [12] = {
    [sym_expression] = STATE(558),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(12),
    [sym_block_comment] = STATE(12),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_RBRACK] = ACTIONS(113),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [13] = {
    [sym_expression] = STATE(667),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(13),
    [sym_block_comment] = STATE(13),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_RBRACK] = ACTIONS(115),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [14] = {
    [sym_expression] = STATE(667),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(14),
    [sym_block_comment] = STATE(14),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_RBRACK] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [15] = {
    [sym_expression] = STATE(626),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(15),
    [sym_block_comment] = STATE(15),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(119),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [16] = {
    [sym_expression] = STATE(667),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(16),
    [sym_block_comment] = STATE(16),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_RBRACK] = ACTIONS(121),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [17] = {
    [sym_expression] = STATE(667),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(17),
    [sym_block_comment] = STATE(17),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_RBRACK] = ACTIONS(123),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [18] = {
    [sym_expression] = STATE(622),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(18),
    [sym_block_comment] = STATE(18),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(125),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [19] = {
    [sym_expression] = STATE(667),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(19),
    [sym_block_comment] = STATE(19),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_RBRACK] = ACTIONS(127),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [20] = {
    [sym_expression] = STATE(667),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(20),
    [sym_block_comment] = STATE(20),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_RBRACK] = ACTIONS(129),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [21] = {
    [sym_expression] = STATE(667),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(21),
    [sym_block_comment] = STATE(21),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_RBRACK] = ACTIONS(131),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [22] = {
    [sym_expression] = STATE(731),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(22),
    [sym_block_comment] = STATE(22),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [23] = {
    [sym_expression] = STATE(419),
    [sym_builtin] = STATE(331),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(666),
    [sym_forall_operator] = STATE(673),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(695),
    [sym__empty_list_literal_primitive] = STATE(696),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(402),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(73),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(23),
    [sym_block_comment] = STATE(23),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [aux_sym_let_expression_repeat1] = STATE(554),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [24] = {
    [sym_expression] = STATE(734),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(24),
    [sym_block_comment] = STATE(24),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [25] = {
    [sym_expression] = STATE(701),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(25),
    [sym_block_comment] = STATE(25),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [26] = {
    [sym_expression] = STATE(667),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(26),
    [sym_block_comment] = STATE(26),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [27] = {
    [sym_expression] = STATE(725),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(27),
    [sym_block_comment] = STATE(27),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [28] = {
    [sym_expression] = STATE(617),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(28),
    [sym_block_comment] = STATE(28),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [29] = {
    [sym_expression] = STATE(631),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(29),
    [sym_block_comment] = STATE(29),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [30] = {
    [sym_expression] = STATE(425),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(30),
    [sym_block_comment] = STATE(30),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [31] = {
    [sym_expression] = STATE(419),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(31),
    [sym_block_comment] = STATE(31),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [32] = {
    [sym_expression] = STATE(432),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(32),
    [sym_block_comment] = STATE(32),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [33] = {
    [sym_expression] = STATE(421),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(33),
    [sym_block_comment] = STATE(33),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [34] = {
    [sym_expression] = STATE(546),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(544),
    [sym_forall_expression] = STATE(544),
    [sym_lambda_operator] = STATE(668),
    [sym_forall_operator] = STATE(669),
    [sym_if_then_else_expression] = STATE(544),
    [sym_let_expression] = STATE(544),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(544),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(680),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(544),
    [sym__operator_expression] = STATE(401),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(34),
    [sym_block_comment] = STATE(34),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(532),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(135),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [35] = {
    [sym_expression] = STATE(629),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(35),
    [sym_block_comment] = STATE(35),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [36] = {
    [sym_expression] = STATE(543),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(544),
    [sym_forall_expression] = STATE(544),
    [sym_lambda_operator] = STATE(668),
    [sym_forall_operator] = STATE(669),
    [sym_if_then_else_expression] = STATE(544),
    [sym_let_expression] = STATE(544),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(544),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(680),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(544),
    [sym__operator_expression] = STATE(401),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(36),
    [sym_block_comment] = STATE(36),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(532),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(135),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [37] = {
    [sym_expression] = STATE(721),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(37),
    [sym_block_comment] = STATE(37),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [38] = {
    [sym_expression] = STATE(698),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(544),
    [sym_forall_expression] = STATE(544),
    [sym_lambda_operator] = STATE(668),
    [sym_forall_operator] = STATE(669),
    [sym_if_then_else_expression] = STATE(544),
    [sym_let_expression] = STATE(544),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(544),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(680),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(544),
    [sym__operator_expression] = STATE(401),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(38),
    [sym_block_comment] = STATE(38),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(532),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(135),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [39] = {
    [sym_expression] = STATE(699),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(544),
    [sym_forall_expression] = STATE(544),
    [sym_lambda_operator] = STATE(668),
    [sym_forall_operator] = STATE(669),
    [sym_if_then_else_expression] = STATE(544),
    [sym_let_expression] = STATE(544),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(544),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(680),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(544),
    [sym__operator_expression] = STATE(401),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(39),
    [sym_block_comment] = STATE(39),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(532),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(135),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [40] = {
    [sym_expression] = STATE(742),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(544),
    [sym_forall_expression] = STATE(544),
    [sym_lambda_operator] = STATE(668),
    [sym_forall_operator] = STATE(669),
    [sym_if_then_else_expression] = STATE(544),
    [sym_let_expression] = STATE(544),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(544),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(680),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(544),
    [sym__operator_expression] = STATE(401),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(40),
    [sym_block_comment] = STATE(40),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(532),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(135),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [41] = {
    [sym_expression] = STATE(750),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(544),
    [sym_forall_expression] = STATE(544),
    [sym_lambda_operator] = STATE(668),
    [sym_forall_operator] = STATE(669),
    [sym_if_then_else_expression] = STATE(544),
    [sym_let_expression] = STATE(544),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(544),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(680),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(544),
    [sym__operator_expression] = STATE(401),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(41),
    [sym_block_comment] = STATE(41),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(532),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(135),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [42] = {
    [sym_expression] = STATE(726),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(544),
    [sym_forall_expression] = STATE(544),
    [sym_lambda_operator] = STATE(668),
    [sym_forall_operator] = STATE(669),
    [sym_if_then_else_expression] = STATE(544),
    [sym_let_expression] = STATE(544),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(544),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(680),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(544),
    [sym__operator_expression] = STATE(401),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(42),
    [sym_block_comment] = STATE(42),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(532),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(135),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [43] = {
    [sym_expression] = STATE(690),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(43),
    [sym_block_comment] = STATE(43),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [44] = {
    [sym_expression] = STATE(432),
    [sym_builtin] = STATE(331),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(666),
    [sym_forall_operator] = STATE(673),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(695),
    [sym__empty_list_literal_primitive] = STATE(696),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(402),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(73),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(44),
    [sym_block_comment] = STATE(44),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [aux_sym_let_expression_repeat1] = STATE(554),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [45] = {
    [sym_expression] = STATE(525),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(544),
    [sym_forall_expression] = STATE(544),
    [sym_lambda_operator] = STATE(668),
    [sym_forall_operator] = STATE(669),
    [sym_if_then_else_expression] = STATE(544),
    [sym_let_expression] = STATE(544),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(544),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(680),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(544),
    [sym__operator_expression] = STATE(401),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(45),
    [sym_block_comment] = STATE(45),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(532),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(135),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [46] = {
    [sym_expression] = STATE(547),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(544),
    [sym_forall_expression] = STATE(544),
    [sym_lambda_operator] = STATE(668),
    [sym_forall_operator] = STATE(669),
    [sym_if_then_else_expression] = STATE(544),
    [sym_let_expression] = STATE(544),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(544),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(680),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(544),
    [sym__operator_expression] = STATE(401),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(46),
    [sym_block_comment] = STATE(46),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(532),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(135),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [47] = {
    [sym_expression] = STATE(748),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(544),
    [sym_forall_expression] = STATE(544),
    [sym_lambda_operator] = STATE(668),
    [sym_forall_operator] = STATE(669),
    [sym_if_then_else_expression] = STATE(544),
    [sym_let_expression] = STATE(544),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(544),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(680),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(544),
    [sym__operator_expression] = STATE(401),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(47),
    [sym_block_comment] = STATE(47),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(532),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(135),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [48] = {
    [sym_expression] = STATE(437),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(48),
    [sym_block_comment] = STATE(48),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [49] = {
    [sym_expression] = STATE(427),
    [sym_builtin] = STATE(331),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(666),
    [sym_forall_operator] = STATE(673),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(695),
    [sym__empty_list_literal_primitive] = STATE(696),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(402),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(73),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(49),
    [sym_block_comment] = STATE(49),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [aux_sym_let_expression_repeat1] = STATE(554),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [50] = {
    [sym_expression] = STATE(427),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(50),
    [sym_block_comment] = STATE(50),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [51] = {
    [sym_expression] = STATE(722),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(51),
    [sym_block_comment] = STATE(51),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [52] = {
    [sym_expression] = STATE(729),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(52),
    [sym_block_comment] = STATE(52),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [53] = {
    [sym_expression] = STATE(752),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(544),
    [sym_forall_expression] = STATE(544),
    [sym_lambda_operator] = STATE(668),
    [sym_forall_operator] = STATE(669),
    [sym_if_then_else_expression] = STATE(544),
    [sym_let_expression] = STATE(544),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(544),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(680),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(544),
    [sym__operator_expression] = STATE(401),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(53),
    [sym_block_comment] = STATE(53),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(532),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(135),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [54] = {
    [sym_expression] = STATE(747),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(54),
    [sym_block_comment] = STATE(54),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [55] = {
    [sym_expression] = STATE(558),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(55),
    [sym_block_comment] = STATE(55),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [56] = {
    [sym_expression] = STATE(733),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(56),
    [sym_block_comment] = STATE(56),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [57] = {
    [sym_expression] = STATE(717),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(544),
    [sym_forall_expression] = STATE(544),
    [sym_lambda_operator] = STATE(668),
    [sym_forall_operator] = STATE(669),
    [sym_if_then_else_expression] = STATE(544),
    [sym_let_expression] = STATE(544),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(544),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(680),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(544),
    [sym__operator_expression] = STATE(401),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(57),
    [sym_block_comment] = STATE(57),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(532),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(135),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [58] = {
    [sym_expression] = STATE(421),
    [sym_builtin] = STATE(331),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(666),
    [sym_forall_operator] = STATE(673),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(695),
    [sym__empty_list_literal_primitive] = STATE(696),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(402),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(73),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(58),
    [sym_block_comment] = STATE(58),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [aux_sym_let_expression_repeat1] = STATE(554),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [59] = {
    [sym_expression] = STATE(425),
    [sym_builtin] = STATE(331),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(666),
    [sym_forall_operator] = STATE(673),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(695),
    [sym__empty_list_literal_primitive] = STATE(696),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(402),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(73),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(59),
    [sym_block_comment] = STATE(59),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [aux_sym_let_expression_repeat1] = STATE(554),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [60] = {
    [sym_expression] = STATE(715),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(60),
    [sym_block_comment] = STATE(60),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [61] = {
    [sym_expression] = STATE(437),
    [sym_builtin] = STATE(331),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(666),
    [sym_forall_operator] = STATE(673),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(695),
    [sym__empty_list_literal_primitive] = STATE(696),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(402),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(73),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(61),
    [sym_block_comment] = STATE(61),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [aux_sym_let_expression_repeat1] = STATE(554),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [62] = {
    [sym_expression] = STATE(524),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(544),
    [sym_forall_expression] = STATE(544),
    [sym_lambda_operator] = STATE(668),
    [sym_forall_operator] = STATE(669),
    [sym_if_then_else_expression] = STATE(544),
    [sym_let_expression] = STATE(544),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(544),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(680),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(544),
    [sym__operator_expression] = STATE(401),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(62),
    [sym_block_comment] = STATE(62),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(532),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(135),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [63] = {
    [sym_expression] = STATE(718),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(439),
    [sym_forall_expression] = STATE(439),
    [sym_lambda_operator] = STATE(660),
    [sym_forall_operator] = STATE(659),
    [sym_if_then_else_expression] = STATE(439),
    [sym_let_expression] = STATE(439),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(439),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(687),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(439),
    [sym__operator_expression] = STATE(387),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(63),
    [sym_block_comment] = STATE(63),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(550),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [64] = {
    [sym_expression] = STATE(549),
    [sym_builtin] = STATE(183),
    [sym_lambda_expression] = STATE(544),
    [sym_forall_expression] = STATE(544),
    [sym_lambda_operator] = STATE(668),
    [sym_forall_operator] = STATE(669),
    [sym_if_then_else_expression] = STATE(544),
    [sym_let_expression] = STATE(544),
    [sym_let_binding] = STATE(670),
    [sym_function_type] = STATE(544),
    [sym_with_expression] = STATE(417),
    [sym__empty_list_literal_primitive] = STATE(680),
    [sym__empty_list_literal_text] = STATE(753),
    [sym_assert_expression] = STATE(544),
    [sym__operator_expression] = STATE(401),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(68),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(64),
    [sym_block_comment] = STATE(64),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_let_expression_repeat1] = STATE(532),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_let] = ACTIONS(13),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_assert] = ACTIONS(135),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_] = ACTIONS(23),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_3] = ACTIONS(29),
    [anon_sym_BSLASH] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [65] = {
    [sym_builtin] = STATE(183),
    [sym__import_expression] = STATE(234),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(65),
    [sym_block_comment] = STATE(65),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_application_expression_repeat1] = STATE(65),
    [sym_label] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(140),
    [anon_sym_then] = ACTIONS(142),
    [anon_sym_else] = ACTIONS(142),
    [anon_sym_let] = ACTIONS(142),
    [anon_sym_in] = ACTIONS(142),
    [anon_sym_missing] = ACTIONS(144),
    [anon_sym_Infinity] = ACTIONS(147),
    [anon_sym_NaN] = ACTIONS(147),
    [anon_sym_with] = ACTIONS(142),
    [anon_sym_Natural_SLASHfold] = ACTIONS(150),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(150),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(150),
    [anon_sym_Natural_SLASHeven] = ACTIONS(150),
    [anon_sym_Natural_SLASHodd] = ACTIONS(150),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(150),
    [anon_sym_Natural_SLASHshow] = ACTIONS(150),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(150),
    [anon_sym_Integer_SLASHshow] = ACTIONS(150),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(150),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(150),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(150),
    [anon_sym_Double_SLASHshow] = ACTIONS(150),
    [anon_sym_List_SLASHbuild] = ACTIONS(150),
    [anon_sym_List_SLASHfold] = ACTIONS(150),
    [anon_sym_List_SLASHlength] = ACTIONS(150),
    [anon_sym_List_SLASHhead] = ACTIONS(150),
    [anon_sym_List_SLASHlast] = ACTIONS(150),
    [anon_sym_List_SLASHindexed] = ACTIONS(150),
    [anon_sym_List_SLASHreverse] = ACTIONS(150),
    [anon_sym_Text_SLASHshow] = ACTIONS(150),
    [anon_sym_Text_SLASHreplace] = ACTIONS(150),
    [anon_sym_Bool] = ACTIONS(150),
    [anon_sym_Optional] = ACTIONS(150),
    [anon_sym_None] = ACTIONS(150),
    [anon_sym_Natural] = ACTIONS(150),
    [anon_sym_Integer] = ACTIONS(150),
    [anon_sym_Double] = ACTIONS(150),
    [anon_sym_Text] = ACTIONS(150),
    [anon_sym_Date] = ACTIONS(150),
    [anon_sym_Time] = ACTIONS(150),
    [anon_sym_TimeZone] = ACTIONS(150),
    [anon_sym_List] = ACTIONS(150),
    [anon_sym_Type] = ACTIONS(150),
    [anon_sym_Kind] = ACTIONS(150),
    [anon_sym_Sort] = ACTIONS(150),
    [anon_sym_LPAREN] = ACTIONS(153),
    [anon_sym_RPAREN] = ACTIONS(140),
    [anon_sym_2] = ACTIONS(140),
    [anon_sym_DASH_GT] = ACTIONS(140),
    [anon_sym_EQ] = ACTIONS(142),
    [anon_sym_QMARK] = ACTIONS(140),
    [anon_sym_LBRACK] = ACTIONS(156),
    [anon_sym_COMMA] = ACTIONS(140),
    [anon_sym_RBRACK] = ACTIONS(140),
    [anon_sym_4] = ACTIONS(140),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(140),
    [anon_sym_PIPE_PIPE] = ACTIONS(140),
    [anon_sym_PLUS] = ACTIONS(142),
    [anon_sym_PLUS_PLUS] = ACTIONS(140),
    [anon_sym_POUND] = ACTIONS(140),
    [anon_sym_AMP_AMP] = ACTIONS(140),
    [anon_sym_5] = ACTIONS(140),
    [anon_sym_SLASH_BSLASH] = ACTIONS(140),
    [anon_sym_6] = ACTIONS(140),
    [anon_sym_SLASH_SLASH] = ACTIONS(142),
    [anon_sym_7] = ACTIONS(140),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(140),
    [anon_sym_STAR] = ACTIONS(140),
    [anon_sym_EQ_EQ] = ACTIONS(142),
    [anon_sym_BANG_EQ] = ACTIONS(140),
    [anon_sym_LBRACE] = ACTIONS(159),
    [anon_sym_RBRACE] = ACTIONS(140),
    [sym_local_import] = ACTIONS(162),
    [sym_http_raw] = ACTIONS(165),
    [aux_sym_env_import_token1] = ACTIONS(168),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(171),
    [anon_sym_DASHInfinity] = ACTIONS(174),
    [aux_sym_double_literal_token1] = ACTIONS(174),
    [sym_natural_literal] = ACTIONS(177),
    [sym_integer_literal] = ACTIONS(177),
    [anon_sym_DQUOTE] = ACTIONS(180),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(183),
    [anon_sym_LT] = ACTIONS(186),
    [anon_sym_PIPE] = ACTIONS(142),
    [anon_sym_GT] = ACTIONS(140),
    [anon_sym_True] = ACTIONS(189),
    [anon_sym_False] = ACTIONS(189),
  },
  [66] = {
    [sym_builtin] = STATE(183),
    [sym__import_expression] = STATE(234),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(66),
    [sym_block_comment] = STATE(66),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_application_expression_repeat1] = STATE(67),
    [sym_label] = ACTIONS(55),
    [anon_sym_COLON] = ACTIONS(192),
    [anon_sym_then] = ACTIONS(194),
    [anon_sym_else] = ACTIONS(194),
    [anon_sym_let] = ACTIONS(194),
    [anon_sym_in] = ACTIONS(194),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_with] = ACTIONS(194),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_RPAREN] = ACTIONS(192),
    [anon_sym_2] = ACTIONS(192),
    [anon_sym_DASH_GT] = ACTIONS(192),
    [anon_sym_EQ] = ACTIONS(194),
    [anon_sym_QMARK] = ACTIONS(192),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_COMMA] = ACTIONS(192),
    [anon_sym_RBRACK] = ACTIONS(192),
    [anon_sym_4] = ACTIONS(192),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(192),
    [anon_sym_PIPE_PIPE] = ACTIONS(192),
    [anon_sym_PLUS] = ACTIONS(194),
    [anon_sym_PLUS_PLUS] = ACTIONS(192),
    [anon_sym_POUND] = ACTIONS(192),
    [anon_sym_AMP_AMP] = ACTIONS(192),
    [anon_sym_5] = ACTIONS(192),
    [anon_sym_SLASH_BSLASH] = ACTIONS(192),
    [anon_sym_6] = ACTIONS(192),
    [anon_sym_SLASH_SLASH] = ACTIONS(194),
    [anon_sym_7] = ACTIONS(192),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(192),
    [anon_sym_STAR] = ACTIONS(192),
    [anon_sym_EQ_EQ] = ACTIONS(194),
    [anon_sym_BANG_EQ] = ACTIONS(192),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_RBRACE] = ACTIONS(192),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_PIPE] = ACTIONS(194),
    [anon_sym_GT] = ACTIONS(192),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [67] = {
    [sym_builtin] = STATE(183),
    [sym__import_expression] = STATE(234),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(67),
    [sym_block_comment] = STATE(67),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [aux_sym_application_expression_repeat1] = STATE(65),
    [sym_label] = ACTIONS(55),
    [anon_sym_COLON] = ACTIONS(198),
    [anon_sym_then] = ACTIONS(200),
    [anon_sym_else] = ACTIONS(200),
    [anon_sym_let] = ACTIONS(200),
    [anon_sym_in] = ACTIONS(200),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_with] = ACTIONS(200),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_RPAREN] = ACTIONS(198),
    [anon_sym_2] = ACTIONS(198),
    [anon_sym_DASH_GT] = ACTIONS(198),
    [anon_sym_EQ] = ACTIONS(200),
    [anon_sym_QMARK] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_COMMA] = ACTIONS(198),
    [anon_sym_RBRACK] = ACTIONS(198),
    [anon_sym_4] = ACTIONS(198),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(198),
    [anon_sym_PIPE_PIPE] = ACTIONS(198),
    [anon_sym_PLUS] = ACTIONS(200),
    [anon_sym_PLUS_PLUS] = ACTIONS(198),
    [anon_sym_POUND] = ACTIONS(198),
    [anon_sym_AMP_AMP] = ACTIONS(198),
    [anon_sym_5] = ACTIONS(198),
    [anon_sym_SLASH_BSLASH] = ACTIONS(198),
    [anon_sym_6] = ACTIONS(198),
    [anon_sym_SLASH_SLASH] = ACTIONS(200),
    [anon_sym_7] = ACTIONS(198),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(198),
    [anon_sym_STAR] = ACTIONS(198),
    [anon_sym_EQ_EQ] = ACTIONS(200),
    [anon_sym_BANG_EQ] = ACTIONS(198),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_RBRACE] = ACTIONS(198),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_PIPE] = ACTIONS(200),
    [anon_sym_GT] = ACTIONS(198),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [68] = {
    [sym_builtin] = STATE(183),
    [sym__import_expression] = STATE(66),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(68),
    [sym_block_comment] = STATE(68),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_COLON] = ACTIONS(202),
    [anon_sym_then] = ACTIONS(204),
    [anon_sym_else] = ACTIONS(204),
    [anon_sym_let] = ACTIONS(204),
    [anon_sym_in] = ACTIONS(204),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_with] = ACTIONS(206),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_RPAREN] = ACTIONS(202),
    [anon_sym_2] = ACTIONS(202),
    [anon_sym_DASH_GT] = ACTIONS(202),
    [anon_sym_EQ] = ACTIONS(204),
    [anon_sym_QMARK] = ACTIONS(202),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_COMMA] = ACTIONS(202),
    [anon_sym_RBRACK] = ACTIONS(202),
    [anon_sym_4] = ACTIONS(202),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(202),
    [anon_sym_PIPE_PIPE] = ACTIONS(202),
    [anon_sym_PLUS] = ACTIONS(204),
    [anon_sym_PLUS_PLUS] = ACTIONS(202),
    [anon_sym_POUND] = ACTIONS(202),
    [anon_sym_AMP_AMP] = ACTIONS(202),
    [anon_sym_5] = ACTIONS(202),
    [anon_sym_SLASH_BSLASH] = ACTIONS(202),
    [anon_sym_6] = ACTIONS(202),
    [anon_sym_SLASH_SLASH] = ACTIONS(204),
    [anon_sym_7] = ACTIONS(202),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(202),
    [anon_sym_STAR] = ACTIONS(202),
    [anon_sym_EQ_EQ] = ACTIONS(204),
    [anon_sym_BANG_EQ] = ACTIONS(202),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_RBRACE] = ACTIONS(202),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_PIPE] = ACTIONS(204),
    [anon_sym_GT] = ACTIONS(202),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [69] = {
    [sym_builtin] = STATE(183),
    [sym__import_expression] = STATE(66),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(69),
    [sym_block_comment] = STATE(69),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_COLON] = ACTIONS(202),
    [anon_sym_then] = ACTIONS(204),
    [anon_sym_else] = ACTIONS(204),
    [anon_sym_let] = ACTIONS(204),
    [anon_sym_in] = ACTIONS(204),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_with] = ACTIONS(204),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_RPAREN] = ACTIONS(202),
    [anon_sym_2] = ACTIONS(202),
    [anon_sym_DASH_GT] = ACTIONS(202),
    [anon_sym_EQ] = ACTIONS(204),
    [anon_sym_QMARK] = ACTIONS(202),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_COMMA] = ACTIONS(202),
    [anon_sym_RBRACK] = ACTIONS(202),
    [anon_sym_4] = ACTIONS(202),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(202),
    [anon_sym_PIPE_PIPE] = ACTIONS(202),
    [anon_sym_PLUS] = ACTIONS(204),
    [anon_sym_PLUS_PLUS] = ACTIONS(202),
    [anon_sym_POUND] = ACTIONS(202),
    [anon_sym_AMP_AMP] = ACTIONS(202),
    [anon_sym_5] = ACTIONS(202),
    [anon_sym_SLASH_BSLASH] = ACTIONS(202),
    [anon_sym_6] = ACTIONS(202),
    [anon_sym_SLASH_SLASH] = ACTIONS(204),
    [anon_sym_7] = ACTIONS(202),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(202),
    [anon_sym_STAR] = ACTIONS(202),
    [anon_sym_EQ_EQ] = ACTIONS(204),
    [anon_sym_BANG_EQ] = ACTIONS(202),
    [anon_sym_LBRACE] = ACTIONS(75),
    [anon_sym_RBRACE] = ACTIONS(202),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_PIPE] = ACTIONS(204),
    [anon_sym_GT] = ACTIONS(202),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [70] = {
    [sym_builtin] = STATE(331),
    [sym__import_expression] = STATE(355),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(70),
    [sym_block_comment] = STATE(70),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [aux_sym_application_expression_repeat1] = STATE(70),
    [ts_builtin_sym_end] = ACTIONS(140),
    [sym_label] = ACTIONS(208),
    [anon_sym_COLON] = ACTIONS(140),
    [anon_sym_missing] = ACTIONS(211),
    [anon_sym_Infinity] = ACTIONS(214),
    [anon_sym_NaN] = ACTIONS(214),
    [anon_sym_with] = ACTIONS(142),
    [anon_sym_Natural_SLASHfold] = ACTIONS(217),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(217),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(217),
    [anon_sym_Natural_SLASHeven] = ACTIONS(217),
    [anon_sym_Natural_SLASHodd] = ACTIONS(217),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(217),
    [anon_sym_Natural_SLASHshow] = ACTIONS(217),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(217),
    [anon_sym_Integer_SLASHshow] = ACTIONS(217),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(217),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(217),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(217),
    [anon_sym_Double_SLASHshow] = ACTIONS(217),
    [anon_sym_List_SLASHbuild] = ACTIONS(217),
    [anon_sym_List_SLASHfold] = ACTIONS(217),
    [anon_sym_List_SLASHlength] = ACTIONS(217),
    [anon_sym_List_SLASHhead] = ACTIONS(217),
    [anon_sym_List_SLASHlast] = ACTIONS(217),
    [anon_sym_List_SLASHindexed] = ACTIONS(217),
    [anon_sym_List_SLASHreverse] = ACTIONS(217),
    [anon_sym_Text_SLASHshow] = ACTIONS(217),
    [anon_sym_Text_SLASHreplace] = ACTIONS(217),
    [anon_sym_Bool] = ACTIONS(217),
    [anon_sym_Optional] = ACTIONS(217),
    [anon_sym_None] = ACTIONS(217),
    [anon_sym_Natural] = ACTIONS(217),
    [anon_sym_Integer] = ACTIONS(217),
    [anon_sym_Double] = ACTIONS(217),
    [anon_sym_Text] = ACTIONS(217),
    [anon_sym_Date] = ACTIONS(217),
    [anon_sym_Time] = ACTIONS(217),
    [anon_sym_TimeZone] = ACTIONS(217),
    [anon_sym_List] = ACTIONS(217),
    [anon_sym_Type] = ACTIONS(217),
    [anon_sym_Kind] = ACTIONS(217),
    [anon_sym_Sort] = ACTIONS(217),
    [anon_sym_LPAREN] = ACTIONS(220),
    [anon_sym_2] = ACTIONS(140),
    [anon_sym_DASH_GT] = ACTIONS(140),
    [anon_sym_QMARK] = ACTIONS(140),
    [anon_sym_LBRACK] = ACTIONS(223),
    [anon_sym_4] = ACTIONS(140),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(140),
    [anon_sym_PIPE_PIPE] = ACTIONS(140),
    [anon_sym_PLUS] = ACTIONS(142),
    [anon_sym_PLUS_PLUS] = ACTIONS(140),
    [anon_sym_POUND] = ACTIONS(140),
    [anon_sym_AMP_AMP] = ACTIONS(140),
    [anon_sym_5] = ACTIONS(140),
    [anon_sym_SLASH_BSLASH] = ACTIONS(140),
    [anon_sym_6] = ACTIONS(140),
    [anon_sym_SLASH_SLASH] = ACTIONS(142),
    [anon_sym_7] = ACTIONS(140),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(140),
    [anon_sym_STAR] = ACTIONS(140),
    [anon_sym_EQ_EQ] = ACTIONS(142),
    [anon_sym_BANG_EQ] = ACTIONS(140),
    [anon_sym_LBRACE] = ACTIONS(226),
    [sym_local_import] = ACTIONS(229),
    [sym_http_raw] = ACTIONS(232),
    [aux_sym_env_import_token1] = ACTIONS(235),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(238),
    [anon_sym_DASHInfinity] = ACTIONS(241),
    [aux_sym_double_literal_token1] = ACTIONS(241),
    [sym_natural_literal] = ACTIONS(244),
    [sym_integer_literal] = ACTIONS(244),
    [anon_sym_DQUOTE] = ACTIONS(247),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(250),
    [anon_sym_LT] = ACTIONS(253),
    [anon_sym_True] = ACTIONS(256),
    [anon_sym_False] = ACTIONS(256),
  },
  [71] = {
    [sym_builtin] = STATE(331),
    [sym__import_expression] = STATE(355),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(71),
    [sym_block_comment] = STATE(71),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [aux_sym_application_expression_repeat1] = STATE(72),
    [ts_builtin_sym_end] = ACTIONS(192),
    [sym_label] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(192),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(194),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_2] = ACTIONS(192),
    [anon_sym_DASH_GT] = ACTIONS(192),
    [anon_sym_QMARK] = ACTIONS(192),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_4] = ACTIONS(192),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(192),
    [anon_sym_PIPE_PIPE] = ACTIONS(192),
    [anon_sym_PLUS] = ACTIONS(194),
    [anon_sym_PLUS_PLUS] = ACTIONS(192),
    [anon_sym_POUND] = ACTIONS(192),
    [anon_sym_AMP_AMP] = ACTIONS(192),
    [anon_sym_5] = ACTIONS(192),
    [anon_sym_SLASH_BSLASH] = ACTIONS(192),
    [anon_sym_6] = ACTIONS(192),
    [anon_sym_SLASH_SLASH] = ACTIONS(194),
    [anon_sym_7] = ACTIONS(192),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(192),
    [anon_sym_STAR] = ACTIONS(192),
    [anon_sym_EQ_EQ] = ACTIONS(194),
    [anon_sym_BANG_EQ] = ACTIONS(192),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [72] = {
    [sym_builtin] = STATE(331),
    [sym__import_expression] = STATE(355),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(72),
    [sym_block_comment] = STATE(72),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [aux_sym_application_expression_repeat1] = STATE(70),
    [ts_builtin_sym_end] = ACTIONS(198),
    [sym_label] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(198),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(200),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_2] = ACTIONS(198),
    [anon_sym_DASH_GT] = ACTIONS(198),
    [anon_sym_QMARK] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_4] = ACTIONS(198),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(198),
    [anon_sym_PIPE_PIPE] = ACTIONS(198),
    [anon_sym_PLUS] = ACTIONS(200),
    [anon_sym_PLUS_PLUS] = ACTIONS(198),
    [anon_sym_POUND] = ACTIONS(198),
    [anon_sym_AMP_AMP] = ACTIONS(198),
    [anon_sym_5] = ACTIONS(198),
    [anon_sym_SLASH_BSLASH] = ACTIONS(198),
    [anon_sym_6] = ACTIONS(198),
    [anon_sym_SLASH_SLASH] = ACTIONS(200),
    [anon_sym_7] = ACTIONS(198),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(198),
    [anon_sym_STAR] = ACTIONS(198),
    [anon_sym_EQ_EQ] = ACTIONS(200),
    [anon_sym_BANG_EQ] = ACTIONS(198),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [73] = {
    [sym_builtin] = STATE(331),
    [sym__import_expression] = STATE(71),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(73),
    [sym_block_comment] = STATE(73),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [ts_builtin_sym_end] = ACTIONS(202),
    [sym_label] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(202),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(261),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_2] = ACTIONS(202),
    [anon_sym_DASH_GT] = ACTIONS(202),
    [anon_sym_QMARK] = ACTIONS(202),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_4] = ACTIONS(202),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(202),
    [anon_sym_PIPE_PIPE] = ACTIONS(202),
    [anon_sym_PLUS] = ACTIONS(204),
    [anon_sym_PLUS_PLUS] = ACTIONS(202),
    [anon_sym_POUND] = ACTIONS(202),
    [anon_sym_AMP_AMP] = ACTIONS(202),
    [anon_sym_5] = ACTIONS(202),
    [anon_sym_SLASH_BSLASH] = ACTIONS(202),
    [anon_sym_6] = ACTIONS(202),
    [anon_sym_SLASH_SLASH] = ACTIONS(204),
    [anon_sym_7] = ACTIONS(202),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(202),
    [anon_sym_STAR] = ACTIONS(202),
    [anon_sym_EQ_EQ] = ACTIONS(204),
    [anon_sym_BANG_EQ] = ACTIONS(202),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [74] = {
    [sym_builtin] = STATE(331),
    [sym__import_expression] = STATE(71),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(74),
    [sym_block_comment] = STATE(74),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [ts_builtin_sym_end] = ACTIONS(202),
    [sym_label] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(202),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(204),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_2] = ACTIONS(202),
    [anon_sym_DASH_GT] = ACTIONS(202),
    [anon_sym_QMARK] = ACTIONS(202),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_4] = ACTIONS(202),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(202),
    [anon_sym_PIPE_PIPE] = ACTIONS(202),
    [anon_sym_PLUS] = ACTIONS(204),
    [anon_sym_PLUS_PLUS] = ACTIONS(202),
    [anon_sym_POUND] = ACTIONS(202),
    [anon_sym_AMP_AMP] = ACTIONS(202),
    [anon_sym_5] = ACTIONS(202),
    [anon_sym_SLASH_BSLASH] = ACTIONS(202),
    [anon_sym_6] = ACTIONS(202),
    [anon_sym_SLASH_SLASH] = ACTIONS(204),
    [anon_sym_7] = ACTIONS(202),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(202),
    [anon_sym_STAR] = ACTIONS(202),
    [anon_sym_EQ_EQ] = ACTIONS(204),
    [anon_sym_BANG_EQ] = ACTIONS(202),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [75] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(372),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(75),
    [sym_block_comment] = STATE(75),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [76] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(370),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(76),
    [sym_block_comment] = STATE(76),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [77] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(383),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(77),
    [sym_block_comment] = STATE(77),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [78] = {
    [sym_builtin] = STATE(331),
    [sym__operator_expression] = STATE(416),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(74),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(78),
    [sym_block_comment] = STATE(78),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [79] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(382),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(79),
    [sym_block_comment] = STATE(79),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [80] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(375),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(80),
    [sym_block_comment] = STATE(80),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [81] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(374),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(81),
    [sym_block_comment] = STATE(81),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [82] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(373),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(82),
    [sym_block_comment] = STATE(82),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [83] = {
    [sym_builtin] = STATE(331),
    [sym__operator_expression] = STATE(415),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(74),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(83),
    [sym_block_comment] = STATE(83),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [84] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(388),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(84),
    [sym_block_comment] = STATE(84),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [85] = {
    [sym_builtin] = STATE(331),
    [sym__operator_expression] = STATE(413),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(74),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(85),
    [sym_block_comment] = STATE(85),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [86] = {
    [sym_builtin] = STATE(331),
    [sym__operator_expression] = STATE(412),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(74),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(86),
    [sym_block_comment] = STATE(86),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [87] = {
    [sym_builtin] = STATE(331),
    [sym__operator_expression] = STATE(403),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(74),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(87),
    [sym_block_comment] = STATE(87),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [88] = {
    [sym_builtin] = STATE(331),
    [sym__operator_expression] = STATE(409),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(74),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(88),
    [sym_block_comment] = STATE(88),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [89] = {
    [sym_builtin] = STATE(331),
    [sym__operator_expression] = STATE(408),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(74),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(89),
    [sym_block_comment] = STATE(89),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [90] = {
    [sym_builtin] = STATE(331),
    [sym__operator_expression] = STATE(407),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(74),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(90),
    [sym_block_comment] = STATE(90),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [91] = {
    [sym_builtin] = STATE(331),
    [sym__operator_expression] = STATE(404),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(74),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(91),
    [sym_block_comment] = STATE(91),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [92] = {
    [sym_builtin] = STATE(331),
    [sym__operator_expression] = STATE(406),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(74),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(92),
    [sym_block_comment] = STATE(92),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [93] = {
    [sym_builtin] = STATE(331),
    [sym__operator_expression] = STATE(405),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(74),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(93),
    [sym_block_comment] = STATE(93),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [94] = {
    [sym_builtin] = STATE(331),
    [sym__operator_expression] = STATE(410),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(74),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(94),
    [sym_block_comment] = STATE(94),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [95] = {
    [sym_builtin] = STATE(331),
    [sym__operator_expression] = STATE(411),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(74),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(95),
    [sym_block_comment] = STATE(95),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [96] = {
    [sym_builtin] = STATE(331),
    [sym__operator_expression] = STATE(414),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(74),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(96),
    [sym_block_comment] = STATE(96),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [97] = {
    [sym_builtin] = STATE(331),
    [sym__operator_expression] = STATE(386),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(360),
    [sym__import_expression] = STATE(74),
    [sym_completion] = STATE(354),
    [sym_primitive_expression] = STATE(350),
    [sym_import] = STATE(354),
    [sym__import_type] = STATE(296),
    [sym_http_import] = STATE(307),
    [sym_env_import] = STATE(307),
    [sym_line_comment] = STATE(97),
    [sym_block_comment] = STATE(97),
    [sym_numeric_literal] = STATE(262),
    [sym_double_literal] = STATE(308),
    [sym_text_literal] = STATE(262),
    [sym_double_quote_literal] = STATE(342),
    [sym_single_quote_literal] = STATE(342),
    [sym_record_literal] = STATE(262),
    [sym_record_type] = STATE(262),
    [sym_union_type] = STATE(262),
    [sym_list_literal] = STATE(262),
    [sym_boolean_literal] = STATE(262),
    [sym_identifier] = STATE(262),
    [sym_label] = ACTIONS(7),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(15),
    [anon_sym_Infinity] = ACTIONS(17),
    [anon_sym_NaN] = ACTIONS(17),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(25),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(25),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(25),
    [anon_sym_Natural_SLASHeven] = ACTIONS(25),
    [anon_sym_Natural_SLASHodd] = ACTIONS(25),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(25),
    [anon_sym_Natural_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(25),
    [anon_sym_Integer_SLASHshow] = ACTIONS(25),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(25),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(25),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(25),
    [anon_sym_Double_SLASHshow] = ACTIONS(25),
    [anon_sym_List_SLASHbuild] = ACTIONS(25),
    [anon_sym_List_SLASHfold] = ACTIONS(25),
    [anon_sym_List_SLASHlength] = ACTIONS(25),
    [anon_sym_List_SLASHhead] = ACTIONS(25),
    [anon_sym_List_SLASHlast] = ACTIONS(25),
    [anon_sym_List_SLASHindexed] = ACTIONS(25),
    [anon_sym_List_SLASHreverse] = ACTIONS(25),
    [anon_sym_Text_SLASHshow] = ACTIONS(25),
    [anon_sym_Text_SLASHreplace] = ACTIONS(25),
    [anon_sym_Bool] = ACTIONS(25),
    [anon_sym_Optional] = ACTIONS(25),
    [anon_sym_None] = ACTIONS(25),
    [anon_sym_Natural] = ACTIONS(25),
    [anon_sym_Integer] = ACTIONS(25),
    [anon_sym_Double] = ACTIONS(25),
    [anon_sym_Text] = ACTIONS(25),
    [anon_sym_Date] = ACTIONS(25),
    [anon_sym_Time] = ACTIONS(25),
    [anon_sym_TimeZone] = ACTIONS(25),
    [anon_sym_List] = ACTIONS(25),
    [anon_sym_Type] = ACTIONS(25),
    [anon_sym_Kind] = ACTIONS(25),
    [anon_sym_Sort] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(33),
    [sym_local_import] = ACTIONS(35),
    [sym_http_raw] = ACTIONS(37),
    [aux_sym_env_import_token1] = ACTIONS(39),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(41),
    [anon_sym_DASHInfinity] = ACTIONS(43),
    [aux_sym_double_literal_token1] = ACTIONS(43),
    [sym_natural_literal] = ACTIONS(45),
    [sym_integer_literal] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_True] = ACTIONS(53),
    [anon_sym_False] = ACTIONS(53),
  },
  [98] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(371),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(98),
    [sym_block_comment] = STATE(98),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [99] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(376),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(99),
    [sym_block_comment] = STATE(99),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [100] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(377),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(100),
    [sym_block_comment] = STATE(100),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [101] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(378),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(101),
    [sym_block_comment] = STATE(101),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [102] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(397),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(102),
    [sym_block_comment] = STATE(102),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [103] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(385),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(103),
    [sym_block_comment] = STATE(103),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [104] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(399),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(104),
    [sym_block_comment] = STATE(104),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [105] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(400),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(105),
    [sym_block_comment] = STATE(105),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [106] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(389),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(106),
    [sym_block_comment] = STATE(106),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [107] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(398),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(107),
    [sym_block_comment] = STATE(107),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [108] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(396),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(108),
    [sym_block_comment] = STATE(108),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [109] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(395),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(109),
    [sym_block_comment] = STATE(109),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [110] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(394),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(110),
    [sym_block_comment] = STATE(110),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [111] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(381),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(111),
    [sym_block_comment] = STATE(111),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [112] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(380),
    [sym_equivalence_expression] = STATE(379),
    [sym_import_alt_expression] = STATE(379),
    [sym_or_expression] = STATE(379),
    [sym_plus_expression] = STATE(379),
    [sym_text_append_expression] = STATE(379),
    [sym_list_append_expression] = STATE(379),
    [sym_and_expression] = STATE(379),
    [sym_combine_expression] = STATE(379),
    [sym_prefer_expression] = STATE(379),
    [sym_combine_types_expression] = STATE(379),
    [sym_times_expression] = STATE(379),
    [sym_equal_expression] = STATE(379),
    [sym_not_equal_expression] = STATE(379),
    [sym_application_expression] = STATE(379),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(112),
    [sym_block_comment] = STATE(112),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [113] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(393),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(113),
    [sym_block_comment] = STATE(113),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [114] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(392),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(114),
    [sym_block_comment] = STATE(114),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [115] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(391),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(115),
    [sym_block_comment] = STATE(115),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [116] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(390),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(116),
    [sym_block_comment] = STATE(116),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [117] = {
    [sym_builtin] = STATE(183),
    [sym__operator_expression] = STATE(386),
    [sym_equivalence_expression] = STATE(384),
    [sym_import_alt_expression] = STATE(384),
    [sym_or_expression] = STATE(384),
    [sym_plus_expression] = STATE(384),
    [sym_text_append_expression] = STATE(384),
    [sym_list_append_expression] = STATE(384),
    [sym_and_expression] = STATE(384),
    [sym_combine_expression] = STATE(384),
    [sym_prefer_expression] = STATE(384),
    [sym_combine_types_expression] = STATE(384),
    [sym_times_expression] = STATE(384),
    [sym_equal_expression] = STATE(384),
    [sym_not_equal_expression] = STATE(384),
    [sym_application_expression] = STATE(384),
    [sym_builtin_function] = STATE(361),
    [sym__import_expression] = STATE(69),
    [sym_completion] = STATE(235),
    [sym_primitive_expression] = STATE(229),
    [sym_import] = STATE(235),
    [sym__import_type] = STATE(182),
    [sym_http_import] = STATE(187),
    [sym_env_import] = STATE(187),
    [sym_line_comment] = STATE(117),
    [sym_block_comment] = STATE(117),
    [sym_numeric_literal] = STATE(150),
    [sym_double_literal] = STATE(186),
    [sym_text_literal] = STATE(150),
    [sym_double_quote_literal] = STATE(181),
    [sym_single_quote_literal] = STATE(181),
    [sym_record_literal] = STATE(150),
    [sym_record_type] = STATE(150),
    [sym_union_type] = STATE(150),
    [sym_list_literal] = STATE(150),
    [sym_boolean_literal] = STATE(150),
    [sym_identifier] = STATE(150),
    [sym_label] = ACTIONS(55),
    [anon_sym_Some] = ACTIONS(9),
    [anon_sym_merge] = ACTIONS(9),
    [anon_sym_missing] = ACTIONS(59),
    [anon_sym_Infinity] = ACTIONS(61),
    [anon_sym_NaN] = ACTIONS(61),
    [anon_sym_toMap] = ACTIONS(9),
    [anon_sym_showConstructor] = ACTIONS(9),
    [anon_sym_Natural_SLASHfold] = ACTIONS(65),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(65),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(65),
    [anon_sym_Natural_SLASHeven] = ACTIONS(65),
    [anon_sym_Natural_SLASHodd] = ACTIONS(65),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(65),
    [anon_sym_Natural_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(65),
    [anon_sym_Integer_SLASHshow] = ACTIONS(65),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(65),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(65),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(65),
    [anon_sym_Double_SLASHshow] = ACTIONS(65),
    [anon_sym_List_SLASHbuild] = ACTIONS(65),
    [anon_sym_List_SLASHfold] = ACTIONS(65),
    [anon_sym_List_SLASHlength] = ACTIONS(65),
    [anon_sym_List_SLASHhead] = ACTIONS(65),
    [anon_sym_List_SLASHlast] = ACTIONS(65),
    [anon_sym_List_SLASHindexed] = ACTIONS(65),
    [anon_sym_List_SLASHreverse] = ACTIONS(65),
    [anon_sym_Text_SLASHshow] = ACTIONS(65),
    [anon_sym_Text_SLASHreplace] = ACTIONS(65),
    [anon_sym_Bool] = ACTIONS(65),
    [anon_sym_Optional] = ACTIONS(65),
    [anon_sym_None] = ACTIONS(65),
    [anon_sym_Natural] = ACTIONS(65),
    [anon_sym_Integer] = ACTIONS(65),
    [anon_sym_Double] = ACTIONS(65),
    [anon_sym_Text] = ACTIONS(65),
    [anon_sym_Date] = ACTIONS(65),
    [anon_sym_Time] = ACTIONS(65),
    [anon_sym_TimeZone] = ACTIONS(65),
    [anon_sym_List] = ACTIONS(65),
    [anon_sym_Type] = ACTIONS(65),
    [anon_sym_Kind] = ACTIONS(65),
    [anon_sym_Sort] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(75),
    [sym_local_import] = ACTIONS(77),
    [sym_http_raw] = ACTIONS(79),
    [aux_sym_env_import_token1] = ACTIONS(81),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(83),
    [anon_sym_DASHInfinity] = ACTIONS(85),
    [aux_sym_double_literal_token1] = ACTIONS(85),
    [sym_natural_literal] = ACTIONS(87),
    [sym_integer_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_True] = ACTIONS(95),
    [anon_sym_False] = ACTIONS(95),
  },
  [118] = {
    [sym_line_comment] = STATE(118),
    [sym_block_comment] = STATE(118),
    [sym_de_bruijn_index] = STATE(129),
    [sym_label] = ACTIONS(263),
    [anon_sym_COLON] = ACTIONS(263),
    [anon_sym_then] = ACTIONS(263),
    [anon_sym_else] = ACTIONS(263),
    [anon_sym_let] = ACTIONS(263),
    [anon_sym_in] = ACTIONS(263),
    [anon_sym_as] = ACTIONS(263),
    [anon_sym_missing] = ACTIONS(263),
    [anon_sym_Infinity] = ACTIONS(263),
    [anon_sym_NaN] = ACTIONS(263),
    [anon_sym_with] = ACTIONS(263),
    [anon_sym_Natural_SLASHfold] = ACTIONS(263),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(263),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(263),
    [anon_sym_Natural_SLASHeven] = ACTIONS(263),
    [anon_sym_Natural_SLASHodd] = ACTIONS(263),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(263),
    [anon_sym_Natural_SLASHshow] = ACTIONS(263),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(263),
    [anon_sym_Integer_SLASHshow] = ACTIONS(263),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(263),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(263),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(263),
    [anon_sym_Double_SLASHshow] = ACTIONS(263),
    [anon_sym_List_SLASHbuild] = ACTIONS(263),
    [anon_sym_List_SLASHfold] = ACTIONS(263),
    [anon_sym_List_SLASHlength] = ACTIONS(263),
    [anon_sym_List_SLASHhead] = ACTIONS(263),
    [anon_sym_List_SLASHlast] = ACTIONS(263),
    [anon_sym_List_SLASHindexed] = ACTIONS(263),
    [anon_sym_List_SLASHreverse] = ACTIONS(263),
    [anon_sym_Text_SLASHshow] = ACTIONS(263),
    [anon_sym_Text_SLASHreplace] = ACTIONS(263),
    [anon_sym_Bool] = ACTIONS(263),
    [anon_sym_Optional] = ACTIONS(263),
    [anon_sym_None] = ACTIONS(263),
    [anon_sym_Natural] = ACTIONS(263),
    [anon_sym_Integer] = ACTIONS(263),
    [anon_sym_Double] = ACTIONS(263),
    [anon_sym_Text] = ACTIONS(263),
    [anon_sym_Date] = ACTIONS(263),
    [anon_sym_Time] = ACTIONS(263),
    [anon_sym_TimeZone] = ACTIONS(263),
    [anon_sym_List] = ACTIONS(263),
    [anon_sym_Type] = ACTIONS(263),
    [anon_sym_Kind] = ACTIONS(263),
    [anon_sym_Sort] = ACTIONS(263),
    [anon_sym_LPAREN] = ACTIONS(265),
    [anon_sym_RPAREN] = ACTIONS(265),
    [anon_sym_2] = ACTIONS(265),
    [anon_sym_DASH_GT] = ACTIONS(265),
    [anon_sym_EQ] = ACTIONS(263),
    [anon_sym_DOT] = ACTIONS(263),
    [anon_sym_QMARK] = ACTIONS(265),
    [anon_sym_LBRACK] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_RBRACK] = ACTIONS(265),
    [anon_sym_4] = ACTIONS(265),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(265),
    [anon_sym_PIPE_PIPE] = ACTIONS(265),
    [anon_sym_PLUS] = ACTIONS(263),
    [anon_sym_PLUS_PLUS] = ACTIONS(265),
    [anon_sym_POUND] = ACTIONS(265),
    [anon_sym_AMP_AMP] = ACTIONS(265),
    [anon_sym_5] = ACTIONS(265),
    [anon_sym_SLASH_BSLASH] = ACTIONS(265),
    [anon_sym_6] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(263),
    [anon_sym_7] = ACTIONS(265),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(265),
    [anon_sym_STAR] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(263),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_COLON_COLON] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(263),
    [anon_sym_RBRACE] = ACTIONS(265),
    [sym_import_hash] = ACTIONS(265),
    [sym_local_import] = ACTIONS(265),
    [sym_http_raw] = ACTIONS(265),
    [aux_sym_env_import_token1] = ACTIONS(265),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(265),
    [anon_sym_DASHInfinity] = ACTIONS(265),
    [aux_sym_double_literal_token1] = ACTIONS(265),
    [sym_natural_literal] = ACTIONS(263),
    [sym_integer_literal] = ACTIONS(263),
    [anon_sym_DQUOTE] = ACTIONS(265),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(265),
    [anon_sym_LT] = ACTIONS(265),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(265),
    [anon_sym_True] = ACTIONS(263),
    [anon_sym_False] = ACTIONS(263),
    [anon_sym_AT] = ACTIONS(267),
  },
  [119] = {
    [sym_selector] = STATE(168),
    [sym_line_comment] = STATE(119),
    [sym_block_comment] = STATE(119),
    [aux_sym_selector_repeat1] = STATE(122),
    [sym_label] = ACTIONS(269),
    [anon_sym_COLON] = ACTIONS(269),
    [anon_sym_then] = ACTIONS(269),
    [anon_sym_else] = ACTIONS(269),
    [anon_sym_let] = ACTIONS(269),
    [anon_sym_in] = ACTIONS(269),
    [anon_sym_as] = ACTIONS(269),
    [anon_sym_missing] = ACTIONS(269),
    [anon_sym_Infinity] = ACTIONS(269),
    [anon_sym_NaN] = ACTIONS(269),
    [anon_sym_with] = ACTIONS(269),
    [anon_sym_Natural_SLASHfold] = ACTIONS(269),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(269),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(269),
    [anon_sym_Natural_SLASHeven] = ACTIONS(269),
    [anon_sym_Natural_SLASHodd] = ACTIONS(269),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(269),
    [anon_sym_Natural_SLASHshow] = ACTIONS(269),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(269),
    [anon_sym_Integer_SLASHshow] = ACTIONS(269),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(269),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(269),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(269),
    [anon_sym_Double_SLASHshow] = ACTIONS(269),
    [anon_sym_List_SLASHbuild] = ACTIONS(269),
    [anon_sym_List_SLASHfold] = ACTIONS(269),
    [anon_sym_List_SLASHlength] = ACTIONS(269),
    [anon_sym_List_SLASHhead] = ACTIONS(269),
    [anon_sym_List_SLASHlast] = ACTIONS(269),
    [anon_sym_List_SLASHindexed] = ACTIONS(269),
    [anon_sym_List_SLASHreverse] = ACTIONS(269),
    [anon_sym_Text_SLASHshow] = ACTIONS(269),
    [anon_sym_Text_SLASHreplace] = ACTIONS(269),
    [anon_sym_Bool] = ACTIONS(269),
    [anon_sym_Optional] = ACTIONS(269),
    [anon_sym_None] = ACTIONS(269),
    [anon_sym_Natural] = ACTIONS(269),
    [anon_sym_Integer] = ACTIONS(269),
    [anon_sym_Double] = ACTIONS(269),
    [anon_sym_Text] = ACTIONS(269),
    [anon_sym_Date] = ACTIONS(269),
    [anon_sym_Time] = ACTIONS(269),
    [anon_sym_TimeZone] = ACTIONS(269),
    [anon_sym_List] = ACTIONS(269),
    [anon_sym_Type] = ACTIONS(269),
    [anon_sym_Kind] = ACTIONS(269),
    [anon_sym_Sort] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_RPAREN] = ACTIONS(271),
    [anon_sym_2] = ACTIONS(271),
    [anon_sym_DASH_GT] = ACTIONS(271),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_DOT] = ACTIONS(273),
    [anon_sym_QMARK] = ACTIONS(271),
    [anon_sym_LBRACK] = ACTIONS(271),
    [anon_sym_COMMA] = ACTIONS(271),
    [anon_sym_RBRACK] = ACTIONS(271),
    [anon_sym_4] = ACTIONS(271),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(271),
    [anon_sym_PIPE_PIPE] = ACTIONS(271),
    [anon_sym_PLUS] = ACTIONS(269),
    [anon_sym_PLUS_PLUS] = ACTIONS(271),
    [anon_sym_POUND] = ACTIONS(271),
    [anon_sym_AMP_AMP] = ACTIONS(271),
    [anon_sym_5] = ACTIONS(271),
    [anon_sym_SLASH_BSLASH] = ACTIONS(271),
    [anon_sym_6] = ACTIONS(271),
    [anon_sym_SLASH_SLASH] = ACTIONS(269),
    [anon_sym_7] = ACTIONS(271),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(271),
    [anon_sym_STAR] = ACTIONS(271),
    [anon_sym_EQ_EQ] = ACTIONS(269),
    [anon_sym_BANG_EQ] = ACTIONS(271),
    [anon_sym_COLON_COLON] = ACTIONS(271),
    [anon_sym_LBRACE] = ACTIONS(269),
    [anon_sym_RBRACE] = ACTIONS(271),
    [sym_import_hash] = ACTIONS(271),
    [sym_local_import] = ACTIONS(271),
    [sym_http_raw] = ACTIONS(271),
    [aux_sym_env_import_token1] = ACTIONS(271),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(271),
    [anon_sym_DASHInfinity] = ACTIONS(271),
    [aux_sym_double_literal_token1] = ACTIONS(271),
    [sym_natural_literal] = ACTIONS(269),
    [sym_integer_literal] = ACTIONS(269),
    [anon_sym_DQUOTE] = ACTIONS(271),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(271),
    [anon_sym_LT] = ACTIONS(271),
    [anon_sym_PIPE] = ACTIONS(269),
    [anon_sym_GT] = ACTIONS(271),
    [anon_sym_True] = ACTIONS(269),
    [anon_sym_False] = ACTIONS(269),
  },
  [120] = {
    [sym_selector] = STATE(171),
    [sym_line_comment] = STATE(120),
    [sym_block_comment] = STATE(120),
    [aux_sym_selector_repeat1] = STATE(122),
    [sym_label] = ACTIONS(275),
    [anon_sym_COLON] = ACTIONS(275),
    [anon_sym_then] = ACTIONS(275),
    [anon_sym_else] = ACTIONS(275),
    [anon_sym_let] = ACTIONS(275),
    [anon_sym_in] = ACTIONS(275),
    [anon_sym_as] = ACTIONS(275),
    [anon_sym_missing] = ACTIONS(275),
    [anon_sym_Infinity] = ACTIONS(275),
    [anon_sym_NaN] = ACTIONS(275),
    [anon_sym_with] = ACTIONS(275),
    [anon_sym_Natural_SLASHfold] = ACTIONS(275),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(275),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(275),
    [anon_sym_Natural_SLASHeven] = ACTIONS(275),
    [anon_sym_Natural_SLASHodd] = ACTIONS(275),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(275),
    [anon_sym_Natural_SLASHshow] = ACTIONS(275),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(275),
    [anon_sym_Integer_SLASHshow] = ACTIONS(275),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(275),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(275),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(275),
    [anon_sym_Double_SLASHshow] = ACTIONS(275),
    [anon_sym_List_SLASHbuild] = ACTIONS(275),
    [anon_sym_List_SLASHfold] = ACTIONS(275),
    [anon_sym_List_SLASHlength] = ACTIONS(275),
    [anon_sym_List_SLASHhead] = ACTIONS(275),
    [anon_sym_List_SLASHlast] = ACTIONS(275),
    [anon_sym_List_SLASHindexed] = ACTIONS(275),
    [anon_sym_List_SLASHreverse] = ACTIONS(275),
    [anon_sym_Text_SLASHshow] = ACTIONS(275),
    [anon_sym_Text_SLASHreplace] = ACTIONS(275),
    [anon_sym_Bool] = ACTIONS(275),
    [anon_sym_Optional] = ACTIONS(275),
    [anon_sym_None] = ACTIONS(275),
    [anon_sym_Natural] = ACTIONS(275),
    [anon_sym_Integer] = ACTIONS(275),
    [anon_sym_Double] = ACTIONS(275),
    [anon_sym_Text] = ACTIONS(275),
    [anon_sym_Date] = ACTIONS(275),
    [anon_sym_Time] = ACTIONS(275),
    [anon_sym_TimeZone] = ACTIONS(275),
    [anon_sym_List] = ACTIONS(275),
    [anon_sym_Type] = ACTIONS(275),
    [anon_sym_Kind] = ACTIONS(275),
    [anon_sym_Sort] = ACTIONS(275),
    [anon_sym_LPAREN] = ACTIONS(277),
    [anon_sym_RPAREN] = ACTIONS(277),
    [anon_sym_2] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(275),
    [anon_sym_DOT] = ACTIONS(273),
    [anon_sym_QMARK] = ACTIONS(277),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_RBRACK] = ACTIONS(277),
    [anon_sym_4] = ACTIONS(277),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(277),
    [anon_sym_PIPE_PIPE] = ACTIONS(277),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_PLUS_PLUS] = ACTIONS(277),
    [anon_sym_POUND] = ACTIONS(277),
    [anon_sym_AMP_AMP] = ACTIONS(277),
    [anon_sym_5] = ACTIONS(277),
    [anon_sym_SLASH_BSLASH] = ACTIONS(277),
    [anon_sym_6] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(275),
    [anon_sym_7] = ACTIONS(277),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(277),
    [anon_sym_STAR] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(275),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_COLON_COLON] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(275),
    [anon_sym_RBRACE] = ACTIONS(277),
    [sym_import_hash] = ACTIONS(277),
    [sym_local_import] = ACTIONS(277),
    [sym_http_raw] = ACTIONS(277),
    [aux_sym_env_import_token1] = ACTIONS(277),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(277),
    [anon_sym_DASHInfinity] = ACTIONS(277),
    [aux_sym_double_literal_token1] = ACTIONS(277),
    [sym_natural_literal] = ACTIONS(275),
    [sym_integer_literal] = ACTIONS(275),
    [anon_sym_DQUOTE] = ACTIONS(277),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(277),
    [anon_sym_LT] = ACTIONS(277),
    [anon_sym_PIPE] = ACTIONS(275),
    [anon_sym_GT] = ACTIONS(277),
    [anon_sym_True] = ACTIONS(275),
    [anon_sym_False] = ACTIONS(275),
  },
  [121] = {
    [sym_line_comment] = STATE(121),
    [sym_block_comment] = STATE(121),
    [aux_sym_selector_repeat1] = STATE(121),
    [sym_label] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_then] = ACTIONS(279),
    [anon_sym_else] = ACTIONS(279),
    [anon_sym_let] = ACTIONS(279),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_missing] = ACTIONS(279),
    [anon_sym_Infinity] = ACTIONS(279),
    [anon_sym_NaN] = ACTIONS(279),
    [anon_sym_with] = ACTIONS(279),
    [anon_sym_Natural_SLASHfold] = ACTIONS(279),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(279),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(279),
    [anon_sym_Natural_SLASHeven] = ACTIONS(279),
    [anon_sym_Natural_SLASHodd] = ACTIONS(279),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(279),
    [anon_sym_Natural_SLASHshow] = ACTIONS(279),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(279),
    [anon_sym_Integer_SLASHshow] = ACTIONS(279),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(279),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(279),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(279),
    [anon_sym_Double_SLASHshow] = ACTIONS(279),
    [anon_sym_List_SLASHbuild] = ACTIONS(279),
    [anon_sym_List_SLASHfold] = ACTIONS(279),
    [anon_sym_List_SLASHlength] = ACTIONS(279),
    [anon_sym_List_SLASHhead] = ACTIONS(279),
    [anon_sym_List_SLASHlast] = ACTIONS(279),
    [anon_sym_List_SLASHindexed] = ACTIONS(279),
    [anon_sym_List_SLASHreverse] = ACTIONS(279),
    [anon_sym_Text_SLASHshow] = ACTIONS(279),
    [anon_sym_Text_SLASHreplace] = ACTIONS(279),
    [anon_sym_Bool] = ACTIONS(279),
    [anon_sym_Optional] = ACTIONS(279),
    [anon_sym_None] = ACTIONS(279),
    [anon_sym_Natural] = ACTIONS(279),
    [anon_sym_Integer] = ACTIONS(279),
    [anon_sym_Double] = ACTIONS(279),
    [anon_sym_Text] = ACTIONS(279),
    [anon_sym_Date] = ACTIONS(279),
    [anon_sym_Time] = ACTIONS(279),
    [anon_sym_TimeZone] = ACTIONS(279),
    [anon_sym_List] = ACTIONS(279),
    [anon_sym_Type] = ACTIONS(279),
    [anon_sym_Kind] = ACTIONS(279),
    [anon_sym_Sort] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(281),
    [anon_sym_RPAREN] = ACTIONS(281),
    [anon_sym_2] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_DOT] = ACTIONS(283),
    [anon_sym_QMARK] = ACTIONS(281),
    [anon_sym_LBRACK] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(281),
    [anon_sym_RBRACK] = ACTIONS(281),
    [anon_sym_4] = ACTIONS(281),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(281),
    [anon_sym_PIPE_PIPE] = ACTIONS(281),
    [anon_sym_PLUS] = ACTIONS(279),
    [anon_sym_PLUS_PLUS] = ACTIONS(281),
    [anon_sym_POUND] = ACTIONS(281),
    [anon_sym_AMP_AMP] = ACTIONS(281),
    [anon_sym_5] = ACTIONS(281),
    [anon_sym_SLASH_BSLASH] = ACTIONS(281),
    [anon_sym_6] = ACTIONS(281),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_7] = ACTIONS(281),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(281),
    [anon_sym_STAR] = ACTIONS(281),
    [anon_sym_EQ_EQ] = ACTIONS(279),
    [anon_sym_BANG_EQ] = ACTIONS(281),
    [anon_sym_COLON_COLON] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(279),
    [anon_sym_RBRACE] = ACTIONS(281),
    [sym_import_hash] = ACTIONS(281),
    [sym_local_import] = ACTIONS(281),
    [sym_http_raw] = ACTIONS(281),
    [aux_sym_env_import_token1] = ACTIONS(281),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(281),
    [anon_sym_DASHInfinity] = ACTIONS(281),
    [aux_sym_double_literal_token1] = ACTIONS(281),
    [sym_natural_literal] = ACTIONS(279),
    [sym_integer_literal] = ACTIONS(279),
    [anon_sym_DQUOTE] = ACTIONS(281),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(281),
    [anon_sym_LT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_GT] = ACTIONS(281),
    [anon_sym_True] = ACTIONS(279),
    [anon_sym_False] = ACTIONS(279),
  },
  [122] = {
    [sym_line_comment] = STATE(122),
    [sym_block_comment] = STATE(122),
    [aux_sym_selector_repeat1] = STATE(121),
    [sym_label] = ACTIONS(286),
    [anon_sym_COLON] = ACTIONS(286),
    [anon_sym_then] = ACTIONS(286),
    [anon_sym_else] = ACTIONS(286),
    [anon_sym_let] = ACTIONS(286),
    [anon_sym_in] = ACTIONS(286),
    [anon_sym_as] = ACTIONS(286),
    [anon_sym_missing] = ACTIONS(286),
    [anon_sym_Infinity] = ACTIONS(286),
    [anon_sym_NaN] = ACTIONS(286),
    [anon_sym_with] = ACTIONS(286),
    [anon_sym_Natural_SLASHfold] = ACTIONS(286),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(286),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(286),
    [anon_sym_Natural_SLASHeven] = ACTIONS(286),
    [anon_sym_Natural_SLASHodd] = ACTIONS(286),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(286),
    [anon_sym_Natural_SLASHshow] = ACTIONS(286),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(286),
    [anon_sym_Integer_SLASHshow] = ACTIONS(286),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(286),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(286),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(286),
    [anon_sym_Double_SLASHshow] = ACTIONS(286),
    [anon_sym_List_SLASHbuild] = ACTIONS(286),
    [anon_sym_List_SLASHfold] = ACTIONS(286),
    [anon_sym_List_SLASHlength] = ACTIONS(286),
    [anon_sym_List_SLASHhead] = ACTIONS(286),
    [anon_sym_List_SLASHlast] = ACTIONS(286),
    [anon_sym_List_SLASHindexed] = ACTIONS(286),
    [anon_sym_List_SLASHreverse] = ACTIONS(286),
    [anon_sym_Text_SLASHshow] = ACTIONS(286),
    [anon_sym_Text_SLASHreplace] = ACTIONS(286),
    [anon_sym_Bool] = ACTIONS(286),
    [anon_sym_Optional] = ACTIONS(286),
    [anon_sym_None] = ACTIONS(286),
    [anon_sym_Natural] = ACTIONS(286),
    [anon_sym_Integer] = ACTIONS(286),
    [anon_sym_Double] = ACTIONS(286),
    [anon_sym_Text] = ACTIONS(286),
    [anon_sym_Date] = ACTIONS(286),
    [anon_sym_Time] = ACTIONS(286),
    [anon_sym_TimeZone] = ACTIONS(286),
    [anon_sym_List] = ACTIONS(286),
    [anon_sym_Type] = ACTIONS(286),
    [anon_sym_Kind] = ACTIONS(286),
    [anon_sym_Sort] = ACTIONS(286),
    [anon_sym_LPAREN] = ACTIONS(288),
    [anon_sym_RPAREN] = ACTIONS(288),
    [anon_sym_2] = ACTIONS(288),
    [anon_sym_DASH_GT] = ACTIONS(288),
    [anon_sym_EQ] = ACTIONS(286),
    [anon_sym_DOT] = ACTIONS(273),
    [anon_sym_QMARK] = ACTIONS(288),
    [anon_sym_LBRACK] = ACTIONS(288),
    [anon_sym_COMMA] = ACTIONS(288),
    [anon_sym_RBRACK] = ACTIONS(288),
    [anon_sym_4] = ACTIONS(288),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(288),
    [anon_sym_PIPE_PIPE] = ACTIONS(288),
    [anon_sym_PLUS] = ACTIONS(286),
    [anon_sym_PLUS_PLUS] = ACTIONS(288),
    [anon_sym_POUND] = ACTIONS(288),
    [anon_sym_AMP_AMP] = ACTIONS(288),
    [anon_sym_5] = ACTIONS(288),
    [anon_sym_SLASH_BSLASH] = ACTIONS(288),
    [anon_sym_6] = ACTIONS(288),
    [anon_sym_SLASH_SLASH] = ACTIONS(286),
    [anon_sym_7] = ACTIONS(288),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(288),
    [anon_sym_STAR] = ACTIONS(288),
    [anon_sym_EQ_EQ] = ACTIONS(286),
    [anon_sym_BANG_EQ] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(288),
    [anon_sym_LBRACE] = ACTIONS(286),
    [anon_sym_RBRACE] = ACTIONS(288),
    [sym_import_hash] = ACTIONS(288),
    [sym_local_import] = ACTIONS(288),
    [sym_http_raw] = ACTIONS(288),
    [aux_sym_env_import_token1] = ACTIONS(288),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(288),
    [anon_sym_DASHInfinity] = ACTIONS(288),
    [aux_sym_double_literal_token1] = ACTIONS(288),
    [sym_natural_literal] = ACTIONS(286),
    [sym_integer_literal] = ACTIONS(286),
    [anon_sym_DQUOTE] = ACTIONS(288),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(288),
    [anon_sym_LT] = ACTIONS(288),
    [anon_sym_PIPE] = ACTIONS(286),
    [anon_sym_GT] = ACTIONS(288),
    [anon_sym_True] = ACTIONS(286),
    [anon_sym_False] = ACTIONS(286),
  },
  [123] = {
    [sym_line_comment] = STATE(123),
    [sym_block_comment] = STATE(123),
    [sym_label] = ACTIONS(290),
    [anon_sym_COLON] = ACTIONS(290),
    [anon_sym_then] = ACTIONS(290),
    [anon_sym_else] = ACTIONS(290),
    [anon_sym_let] = ACTIONS(290),
    [anon_sym_in] = ACTIONS(290),
    [anon_sym_as] = ACTIONS(290),
    [anon_sym_missing] = ACTIONS(290),
    [anon_sym_Infinity] = ACTIONS(290),
    [anon_sym_NaN] = ACTIONS(290),
    [anon_sym_with] = ACTIONS(290),
    [anon_sym_Natural_SLASHfold] = ACTIONS(290),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(290),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(290),
    [anon_sym_Natural_SLASHeven] = ACTIONS(290),
    [anon_sym_Natural_SLASHodd] = ACTIONS(290),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(290),
    [anon_sym_Natural_SLASHshow] = ACTIONS(290),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(290),
    [anon_sym_Integer_SLASHshow] = ACTIONS(290),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(290),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(290),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(290),
    [anon_sym_Double_SLASHshow] = ACTIONS(290),
    [anon_sym_List_SLASHbuild] = ACTIONS(290),
    [anon_sym_List_SLASHfold] = ACTIONS(290),
    [anon_sym_List_SLASHlength] = ACTIONS(290),
    [anon_sym_List_SLASHhead] = ACTIONS(290),
    [anon_sym_List_SLASHlast] = ACTIONS(290),
    [anon_sym_List_SLASHindexed] = ACTIONS(290),
    [anon_sym_List_SLASHreverse] = ACTIONS(290),
    [anon_sym_Text_SLASHshow] = ACTIONS(290),
    [anon_sym_Text_SLASHreplace] = ACTIONS(290),
    [anon_sym_Bool] = ACTIONS(290),
    [anon_sym_Optional] = ACTIONS(290),
    [anon_sym_None] = ACTIONS(290),
    [anon_sym_Natural] = ACTIONS(290),
    [anon_sym_Integer] = ACTIONS(290),
    [anon_sym_Double] = ACTIONS(290),
    [anon_sym_Text] = ACTIONS(290),
    [anon_sym_Date] = ACTIONS(290),
    [anon_sym_Time] = ACTIONS(290),
    [anon_sym_TimeZone] = ACTIONS(290),
    [anon_sym_List] = ACTIONS(290),
    [anon_sym_Type] = ACTIONS(290),
    [anon_sym_Kind] = ACTIONS(290),
    [anon_sym_Sort] = ACTIONS(290),
    [anon_sym_LPAREN] = ACTIONS(292),
    [anon_sym_RPAREN] = ACTIONS(292),
    [anon_sym_2] = ACTIONS(292),
    [anon_sym_DASH_GT] = ACTIONS(292),
    [anon_sym_EQ] = ACTIONS(290),
    [anon_sym_DOT] = ACTIONS(290),
    [anon_sym_QMARK] = ACTIONS(292),
    [anon_sym_LBRACK] = ACTIONS(292),
    [anon_sym_COMMA] = ACTIONS(292),
    [anon_sym_RBRACK] = ACTIONS(292),
    [anon_sym_4] = ACTIONS(292),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(292),
    [anon_sym_PIPE_PIPE] = ACTIONS(292),
    [anon_sym_PLUS] = ACTIONS(290),
    [anon_sym_PLUS_PLUS] = ACTIONS(292),
    [anon_sym_POUND] = ACTIONS(292),
    [anon_sym_AMP_AMP] = ACTIONS(292),
    [anon_sym_5] = ACTIONS(292),
    [anon_sym_SLASH_BSLASH] = ACTIONS(292),
    [anon_sym_6] = ACTIONS(292),
    [anon_sym_SLASH_SLASH] = ACTIONS(290),
    [anon_sym_7] = ACTIONS(292),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(292),
    [anon_sym_STAR] = ACTIONS(292),
    [anon_sym_EQ_EQ] = ACTIONS(290),
    [anon_sym_BANG_EQ] = ACTIONS(292),
    [anon_sym_COLON_COLON] = ACTIONS(292),
    [anon_sym_LBRACE] = ACTIONS(290),
    [anon_sym_RBRACE] = ACTIONS(292),
    [sym_import_hash] = ACTIONS(292),
    [sym_local_import] = ACTIONS(292),
    [sym_http_raw] = ACTIONS(292),
    [aux_sym_env_import_token1] = ACTIONS(292),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(292),
    [anon_sym_DASHInfinity] = ACTIONS(292),
    [aux_sym_double_literal_token1] = ACTIONS(292),
    [sym_natural_literal] = ACTIONS(290),
    [sym_integer_literal] = ACTIONS(290),
    [anon_sym_DQUOTE] = ACTIONS(292),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(292),
    [anon_sym_LT] = ACTIONS(292),
    [anon_sym_PIPE] = ACTIONS(290),
    [anon_sym_GT] = ACTIONS(292),
    [anon_sym_True] = ACTIONS(290),
    [anon_sym_False] = ACTIONS(290),
  },
  [124] = {
    [sym_line_comment] = STATE(124),
    [sym_block_comment] = STATE(124),
    [sym_label] = ACTIONS(294),
    [anon_sym_COLON] = ACTIONS(294),
    [anon_sym_then] = ACTIONS(294),
    [anon_sym_else] = ACTIONS(294),
    [anon_sym_let] = ACTIONS(294),
    [anon_sym_in] = ACTIONS(294),
    [anon_sym_as] = ACTIONS(294),
    [anon_sym_missing] = ACTIONS(294),
    [anon_sym_Infinity] = ACTIONS(294),
    [anon_sym_NaN] = ACTIONS(294),
    [anon_sym_with] = ACTIONS(294),
    [anon_sym_Natural_SLASHfold] = ACTIONS(294),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(294),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(294),
    [anon_sym_Natural_SLASHeven] = ACTIONS(294),
    [anon_sym_Natural_SLASHodd] = ACTIONS(294),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(294),
    [anon_sym_Natural_SLASHshow] = ACTIONS(294),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(294),
    [anon_sym_Integer_SLASHshow] = ACTIONS(294),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(294),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(294),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(294),
    [anon_sym_Double_SLASHshow] = ACTIONS(294),
    [anon_sym_List_SLASHbuild] = ACTIONS(294),
    [anon_sym_List_SLASHfold] = ACTIONS(294),
    [anon_sym_List_SLASHlength] = ACTIONS(294),
    [anon_sym_List_SLASHhead] = ACTIONS(294),
    [anon_sym_List_SLASHlast] = ACTIONS(294),
    [anon_sym_List_SLASHindexed] = ACTIONS(294),
    [anon_sym_List_SLASHreverse] = ACTIONS(294),
    [anon_sym_Text_SLASHshow] = ACTIONS(294),
    [anon_sym_Text_SLASHreplace] = ACTIONS(294),
    [anon_sym_Bool] = ACTIONS(294),
    [anon_sym_Optional] = ACTIONS(294),
    [anon_sym_None] = ACTIONS(294),
    [anon_sym_Natural] = ACTIONS(294),
    [anon_sym_Integer] = ACTIONS(294),
    [anon_sym_Double] = ACTIONS(294),
    [anon_sym_Text] = ACTIONS(294),
    [anon_sym_Date] = ACTIONS(294),
    [anon_sym_Time] = ACTIONS(294),
    [anon_sym_TimeZone] = ACTIONS(294),
    [anon_sym_List] = ACTIONS(294),
    [anon_sym_Type] = ACTIONS(294),
    [anon_sym_Kind] = ACTIONS(294),
    [anon_sym_Sort] = ACTIONS(294),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_RPAREN] = ACTIONS(296),
    [anon_sym_2] = ACTIONS(296),
    [anon_sym_DASH_GT] = ACTIONS(296),
    [anon_sym_EQ] = ACTIONS(294),
    [anon_sym_DOT] = ACTIONS(294),
    [anon_sym_QMARK] = ACTIONS(296),
    [anon_sym_LBRACK] = ACTIONS(296),
    [anon_sym_COMMA] = ACTIONS(296),
    [anon_sym_RBRACK] = ACTIONS(296),
    [anon_sym_4] = ACTIONS(296),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(296),
    [anon_sym_PIPE_PIPE] = ACTIONS(296),
    [anon_sym_PLUS] = ACTIONS(294),
    [anon_sym_PLUS_PLUS] = ACTIONS(296),
    [anon_sym_POUND] = ACTIONS(296),
    [anon_sym_AMP_AMP] = ACTIONS(296),
    [anon_sym_5] = ACTIONS(296),
    [anon_sym_SLASH_BSLASH] = ACTIONS(296),
    [anon_sym_6] = ACTIONS(296),
    [anon_sym_SLASH_SLASH] = ACTIONS(294),
    [anon_sym_7] = ACTIONS(296),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(296),
    [anon_sym_STAR] = ACTIONS(296),
    [anon_sym_EQ_EQ] = ACTIONS(294),
    [anon_sym_BANG_EQ] = ACTIONS(296),
    [anon_sym_COLON_COLON] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(294),
    [anon_sym_RBRACE] = ACTIONS(296),
    [sym_import_hash] = ACTIONS(296),
    [sym_local_import] = ACTIONS(296),
    [sym_http_raw] = ACTIONS(296),
    [aux_sym_env_import_token1] = ACTIONS(296),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(296),
    [anon_sym_DASHInfinity] = ACTIONS(296),
    [aux_sym_double_literal_token1] = ACTIONS(296),
    [sym_natural_literal] = ACTIONS(294),
    [sym_integer_literal] = ACTIONS(294),
    [anon_sym_DQUOTE] = ACTIONS(296),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(296),
    [anon_sym_LT] = ACTIONS(296),
    [anon_sym_PIPE] = ACTIONS(294),
    [anon_sym_GT] = ACTIONS(296),
    [anon_sym_True] = ACTIONS(294),
    [anon_sym_False] = ACTIONS(294),
  },
  [125] = {
    [sym_line_comment] = STATE(125),
    [sym_block_comment] = STATE(125),
    [sym_label] = ACTIONS(298),
    [anon_sym_COLON] = ACTIONS(298),
    [anon_sym_then] = ACTIONS(298),
    [anon_sym_else] = ACTIONS(298),
    [anon_sym_let] = ACTIONS(298),
    [anon_sym_in] = ACTIONS(298),
    [anon_sym_as] = ACTIONS(298),
    [anon_sym_missing] = ACTIONS(298),
    [anon_sym_Infinity] = ACTIONS(298),
    [anon_sym_NaN] = ACTIONS(298),
    [anon_sym_with] = ACTIONS(298),
    [anon_sym_Natural_SLASHfold] = ACTIONS(298),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(298),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(298),
    [anon_sym_Natural_SLASHeven] = ACTIONS(298),
    [anon_sym_Natural_SLASHodd] = ACTIONS(298),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(298),
    [anon_sym_Natural_SLASHshow] = ACTIONS(298),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(298),
    [anon_sym_Integer_SLASHshow] = ACTIONS(298),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(298),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(298),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(298),
    [anon_sym_Double_SLASHshow] = ACTIONS(298),
    [anon_sym_List_SLASHbuild] = ACTIONS(298),
    [anon_sym_List_SLASHfold] = ACTIONS(298),
    [anon_sym_List_SLASHlength] = ACTIONS(298),
    [anon_sym_List_SLASHhead] = ACTIONS(298),
    [anon_sym_List_SLASHlast] = ACTIONS(298),
    [anon_sym_List_SLASHindexed] = ACTIONS(298),
    [anon_sym_List_SLASHreverse] = ACTIONS(298),
    [anon_sym_Text_SLASHshow] = ACTIONS(298),
    [anon_sym_Text_SLASHreplace] = ACTIONS(298),
    [anon_sym_Bool] = ACTIONS(298),
    [anon_sym_Optional] = ACTIONS(298),
    [anon_sym_None] = ACTIONS(298),
    [anon_sym_Natural] = ACTIONS(298),
    [anon_sym_Integer] = ACTIONS(298),
    [anon_sym_Double] = ACTIONS(298),
    [anon_sym_Text] = ACTIONS(298),
    [anon_sym_Date] = ACTIONS(298),
    [anon_sym_Time] = ACTIONS(298),
    [anon_sym_TimeZone] = ACTIONS(298),
    [anon_sym_List] = ACTIONS(298),
    [anon_sym_Type] = ACTIONS(298),
    [anon_sym_Kind] = ACTIONS(298),
    [anon_sym_Sort] = ACTIONS(298),
    [anon_sym_LPAREN] = ACTIONS(300),
    [anon_sym_RPAREN] = ACTIONS(300),
    [anon_sym_2] = ACTIONS(300),
    [anon_sym_DASH_GT] = ACTIONS(300),
    [anon_sym_EQ] = ACTIONS(298),
    [anon_sym_DOT] = ACTIONS(298),
    [anon_sym_QMARK] = ACTIONS(300),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_COMMA] = ACTIONS(300),
    [anon_sym_RBRACK] = ACTIONS(300),
    [anon_sym_4] = ACTIONS(300),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(300),
    [anon_sym_PIPE_PIPE] = ACTIONS(300),
    [anon_sym_PLUS] = ACTIONS(298),
    [anon_sym_PLUS_PLUS] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(300),
    [anon_sym_AMP_AMP] = ACTIONS(300),
    [anon_sym_5] = ACTIONS(300),
    [anon_sym_SLASH_BSLASH] = ACTIONS(300),
    [anon_sym_6] = ACTIONS(300),
    [anon_sym_SLASH_SLASH] = ACTIONS(298),
    [anon_sym_7] = ACTIONS(300),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(300),
    [anon_sym_STAR] = ACTIONS(300),
    [anon_sym_EQ_EQ] = ACTIONS(298),
    [anon_sym_BANG_EQ] = ACTIONS(300),
    [anon_sym_COLON_COLON] = ACTIONS(300),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_RBRACE] = ACTIONS(300),
    [sym_import_hash] = ACTIONS(300),
    [sym_local_import] = ACTIONS(300),
    [sym_http_raw] = ACTIONS(300),
    [aux_sym_env_import_token1] = ACTIONS(300),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(300),
    [anon_sym_DASHInfinity] = ACTIONS(300),
    [aux_sym_double_literal_token1] = ACTIONS(300),
    [sym_natural_literal] = ACTIONS(298),
    [sym_integer_literal] = ACTIONS(298),
    [anon_sym_DQUOTE] = ACTIONS(300),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(300),
    [anon_sym_LT] = ACTIONS(300),
    [anon_sym_PIPE] = ACTIONS(298),
    [anon_sym_GT] = ACTIONS(300),
    [anon_sym_True] = ACTIONS(298),
    [anon_sym_False] = ACTIONS(298),
  },
  [126] = {
    [sym_line_comment] = STATE(126),
    [sym_block_comment] = STATE(126),
    [sym_label] = ACTIONS(302),
    [anon_sym_COLON] = ACTIONS(302),
    [anon_sym_then] = ACTIONS(302),
    [anon_sym_else] = ACTIONS(302),
    [anon_sym_let] = ACTIONS(302),
    [anon_sym_in] = ACTIONS(302),
    [anon_sym_as] = ACTIONS(302),
    [anon_sym_missing] = ACTIONS(302),
    [anon_sym_Infinity] = ACTIONS(302),
    [anon_sym_NaN] = ACTIONS(302),
    [anon_sym_with] = ACTIONS(302),
    [anon_sym_Natural_SLASHfold] = ACTIONS(302),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(302),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(302),
    [anon_sym_Natural_SLASHeven] = ACTIONS(302),
    [anon_sym_Natural_SLASHodd] = ACTIONS(302),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(302),
    [anon_sym_Natural_SLASHshow] = ACTIONS(302),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(302),
    [anon_sym_Integer_SLASHshow] = ACTIONS(302),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(302),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(302),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(302),
    [anon_sym_Double_SLASHshow] = ACTIONS(302),
    [anon_sym_List_SLASHbuild] = ACTIONS(302),
    [anon_sym_List_SLASHfold] = ACTIONS(302),
    [anon_sym_List_SLASHlength] = ACTIONS(302),
    [anon_sym_List_SLASHhead] = ACTIONS(302),
    [anon_sym_List_SLASHlast] = ACTIONS(302),
    [anon_sym_List_SLASHindexed] = ACTIONS(302),
    [anon_sym_List_SLASHreverse] = ACTIONS(302),
    [anon_sym_Text_SLASHshow] = ACTIONS(302),
    [anon_sym_Text_SLASHreplace] = ACTIONS(302),
    [anon_sym_Bool] = ACTIONS(302),
    [anon_sym_Optional] = ACTIONS(302),
    [anon_sym_None] = ACTIONS(302),
    [anon_sym_Natural] = ACTIONS(302),
    [anon_sym_Integer] = ACTIONS(302),
    [anon_sym_Double] = ACTIONS(302),
    [anon_sym_Text] = ACTIONS(302),
    [anon_sym_Date] = ACTIONS(302),
    [anon_sym_Time] = ACTIONS(302),
    [anon_sym_TimeZone] = ACTIONS(302),
    [anon_sym_List] = ACTIONS(302),
    [anon_sym_Type] = ACTIONS(302),
    [anon_sym_Kind] = ACTIONS(302),
    [anon_sym_Sort] = ACTIONS(302),
    [anon_sym_LPAREN] = ACTIONS(304),
    [anon_sym_RPAREN] = ACTIONS(304),
    [anon_sym_2] = ACTIONS(304),
    [anon_sym_DASH_GT] = ACTIONS(304),
    [anon_sym_EQ] = ACTIONS(302),
    [anon_sym_DOT] = ACTIONS(302),
    [anon_sym_QMARK] = ACTIONS(304),
    [anon_sym_LBRACK] = ACTIONS(304),
    [anon_sym_COMMA] = ACTIONS(304),
    [anon_sym_RBRACK] = ACTIONS(304),
    [anon_sym_4] = ACTIONS(304),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(304),
    [anon_sym_PLUS] = ACTIONS(302),
    [anon_sym_PLUS_PLUS] = ACTIONS(304),
    [anon_sym_POUND] = ACTIONS(304),
    [anon_sym_AMP_AMP] = ACTIONS(304),
    [anon_sym_5] = ACTIONS(304),
    [anon_sym_SLASH_BSLASH] = ACTIONS(304),
    [anon_sym_6] = ACTIONS(304),
    [anon_sym_SLASH_SLASH] = ACTIONS(302),
    [anon_sym_7] = ACTIONS(304),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(304),
    [anon_sym_STAR] = ACTIONS(304),
    [anon_sym_EQ_EQ] = ACTIONS(302),
    [anon_sym_BANG_EQ] = ACTIONS(304),
    [anon_sym_COLON_COLON] = ACTIONS(304),
    [anon_sym_LBRACE] = ACTIONS(302),
    [anon_sym_RBRACE] = ACTIONS(304),
    [sym_import_hash] = ACTIONS(304),
    [sym_local_import] = ACTIONS(304),
    [sym_http_raw] = ACTIONS(304),
    [aux_sym_env_import_token1] = ACTIONS(304),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(304),
    [anon_sym_DASHInfinity] = ACTIONS(304),
    [aux_sym_double_literal_token1] = ACTIONS(304),
    [sym_natural_literal] = ACTIONS(302),
    [sym_integer_literal] = ACTIONS(302),
    [anon_sym_DQUOTE] = ACTIONS(304),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(304),
    [anon_sym_LT] = ACTIONS(304),
    [anon_sym_PIPE] = ACTIONS(302),
    [anon_sym_GT] = ACTIONS(304),
    [anon_sym_True] = ACTIONS(302),
    [anon_sym_False] = ACTIONS(302),
  },
  [127] = {
    [sym_line_comment] = STATE(127),
    [sym_block_comment] = STATE(127),
    [sym_label] = ACTIONS(306),
    [anon_sym_COLON] = ACTIONS(306),
    [anon_sym_then] = ACTIONS(306),
    [anon_sym_else] = ACTIONS(306),
    [anon_sym_let] = ACTIONS(306),
    [anon_sym_in] = ACTIONS(306),
    [anon_sym_as] = ACTIONS(306),
    [anon_sym_missing] = ACTIONS(306),
    [anon_sym_Infinity] = ACTIONS(306),
    [anon_sym_NaN] = ACTIONS(306),
    [anon_sym_with] = ACTIONS(306),
    [anon_sym_Natural_SLASHfold] = ACTIONS(306),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(306),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(306),
    [anon_sym_Natural_SLASHeven] = ACTIONS(306),
    [anon_sym_Natural_SLASHodd] = ACTIONS(306),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(306),
    [anon_sym_Natural_SLASHshow] = ACTIONS(306),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(306),
    [anon_sym_Integer_SLASHshow] = ACTIONS(306),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(306),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(306),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(306),
    [anon_sym_Double_SLASHshow] = ACTIONS(306),
    [anon_sym_List_SLASHbuild] = ACTIONS(306),
    [anon_sym_List_SLASHfold] = ACTIONS(306),
    [anon_sym_List_SLASHlength] = ACTIONS(306),
    [anon_sym_List_SLASHhead] = ACTIONS(306),
    [anon_sym_List_SLASHlast] = ACTIONS(306),
    [anon_sym_List_SLASHindexed] = ACTIONS(306),
    [anon_sym_List_SLASHreverse] = ACTIONS(306),
    [anon_sym_Text_SLASHshow] = ACTIONS(306),
    [anon_sym_Text_SLASHreplace] = ACTIONS(306),
    [anon_sym_Bool] = ACTIONS(306),
    [anon_sym_Optional] = ACTIONS(306),
    [anon_sym_None] = ACTIONS(306),
    [anon_sym_Natural] = ACTIONS(306),
    [anon_sym_Integer] = ACTIONS(306),
    [anon_sym_Double] = ACTIONS(306),
    [anon_sym_Text] = ACTIONS(306),
    [anon_sym_Date] = ACTIONS(306),
    [anon_sym_Time] = ACTIONS(306),
    [anon_sym_TimeZone] = ACTIONS(306),
    [anon_sym_List] = ACTIONS(306),
    [anon_sym_Type] = ACTIONS(306),
    [anon_sym_Kind] = ACTIONS(306),
    [anon_sym_Sort] = ACTIONS(306),
    [anon_sym_LPAREN] = ACTIONS(308),
    [anon_sym_RPAREN] = ACTIONS(308),
    [anon_sym_2] = ACTIONS(308),
    [anon_sym_DASH_GT] = ACTIONS(308),
    [anon_sym_EQ] = ACTIONS(306),
    [anon_sym_DOT] = ACTIONS(306),
    [anon_sym_QMARK] = ACTIONS(308),
    [anon_sym_LBRACK] = ACTIONS(308),
    [anon_sym_COMMA] = ACTIONS(308),
    [anon_sym_RBRACK] = ACTIONS(308),
    [anon_sym_4] = ACTIONS(308),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(308),
    [anon_sym_PIPE_PIPE] = ACTIONS(308),
    [anon_sym_PLUS] = ACTIONS(306),
    [anon_sym_PLUS_PLUS] = ACTIONS(308),
    [anon_sym_POUND] = ACTIONS(308),
    [anon_sym_AMP_AMP] = ACTIONS(308),
    [anon_sym_5] = ACTIONS(308),
    [anon_sym_SLASH_BSLASH] = ACTIONS(308),
    [anon_sym_6] = ACTIONS(308),
    [anon_sym_SLASH_SLASH] = ACTIONS(306),
    [anon_sym_7] = ACTIONS(308),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(308),
    [anon_sym_STAR] = ACTIONS(308),
    [anon_sym_EQ_EQ] = ACTIONS(306),
    [anon_sym_BANG_EQ] = ACTIONS(308),
    [anon_sym_COLON_COLON] = ACTIONS(308),
    [anon_sym_LBRACE] = ACTIONS(306),
    [anon_sym_RBRACE] = ACTIONS(308),
    [sym_import_hash] = ACTIONS(308),
    [sym_local_import] = ACTIONS(308),
    [sym_http_raw] = ACTIONS(308),
    [aux_sym_env_import_token1] = ACTIONS(308),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(308),
    [anon_sym_DASHInfinity] = ACTIONS(308),
    [aux_sym_double_literal_token1] = ACTIONS(308),
    [sym_natural_literal] = ACTIONS(306),
    [sym_integer_literal] = ACTIONS(306),
    [anon_sym_DQUOTE] = ACTIONS(308),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(308),
    [anon_sym_LT] = ACTIONS(308),
    [anon_sym_PIPE] = ACTIONS(306),
    [anon_sym_GT] = ACTIONS(308),
    [anon_sym_True] = ACTIONS(306),
    [anon_sym_False] = ACTIONS(306),
  },
  [128] = {
    [sym_line_comment] = STATE(128),
    [sym_block_comment] = STATE(128),
    [sym_label] = ACTIONS(310),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_then] = ACTIONS(310),
    [anon_sym_else] = ACTIONS(310),
    [anon_sym_let] = ACTIONS(310),
    [anon_sym_in] = ACTIONS(310),
    [anon_sym_as] = ACTIONS(310),
    [anon_sym_missing] = ACTIONS(310),
    [anon_sym_Infinity] = ACTIONS(310),
    [anon_sym_NaN] = ACTIONS(310),
    [anon_sym_with] = ACTIONS(310),
    [anon_sym_Natural_SLASHfold] = ACTIONS(310),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(310),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(310),
    [anon_sym_Natural_SLASHeven] = ACTIONS(310),
    [anon_sym_Natural_SLASHodd] = ACTIONS(310),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(310),
    [anon_sym_Natural_SLASHshow] = ACTIONS(310),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(310),
    [anon_sym_Integer_SLASHshow] = ACTIONS(310),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(310),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(310),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(310),
    [anon_sym_Double_SLASHshow] = ACTIONS(310),
    [anon_sym_List_SLASHbuild] = ACTIONS(310),
    [anon_sym_List_SLASHfold] = ACTIONS(310),
    [anon_sym_List_SLASHlength] = ACTIONS(310),
    [anon_sym_List_SLASHhead] = ACTIONS(310),
    [anon_sym_List_SLASHlast] = ACTIONS(310),
    [anon_sym_List_SLASHindexed] = ACTIONS(310),
    [anon_sym_List_SLASHreverse] = ACTIONS(310),
    [anon_sym_Text_SLASHshow] = ACTIONS(310),
    [anon_sym_Text_SLASHreplace] = ACTIONS(310),
    [anon_sym_Bool] = ACTIONS(310),
    [anon_sym_Optional] = ACTIONS(310),
    [anon_sym_None] = ACTIONS(310),
    [anon_sym_Natural] = ACTIONS(310),
    [anon_sym_Integer] = ACTIONS(310),
    [anon_sym_Double] = ACTIONS(310),
    [anon_sym_Text] = ACTIONS(310),
    [anon_sym_Date] = ACTIONS(310),
    [anon_sym_Time] = ACTIONS(310),
    [anon_sym_TimeZone] = ACTIONS(310),
    [anon_sym_List] = ACTIONS(310),
    [anon_sym_Type] = ACTIONS(310),
    [anon_sym_Kind] = ACTIONS(310),
    [anon_sym_Sort] = ACTIONS(310),
    [anon_sym_LPAREN] = ACTIONS(312),
    [anon_sym_RPAREN] = ACTIONS(312),
    [anon_sym_2] = ACTIONS(312),
    [anon_sym_DASH_GT] = ACTIONS(312),
    [anon_sym_EQ] = ACTIONS(310),
    [anon_sym_DOT] = ACTIONS(310),
    [anon_sym_QMARK] = ACTIONS(312),
    [anon_sym_LBRACK] = ACTIONS(312),
    [anon_sym_COMMA] = ACTIONS(312),
    [anon_sym_RBRACK] = ACTIONS(312),
    [anon_sym_4] = ACTIONS(312),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(312),
    [anon_sym_PIPE_PIPE] = ACTIONS(312),
    [anon_sym_PLUS] = ACTIONS(310),
    [anon_sym_PLUS_PLUS] = ACTIONS(312),
    [anon_sym_POUND] = ACTIONS(312),
    [anon_sym_AMP_AMP] = ACTIONS(312),
    [anon_sym_5] = ACTIONS(312),
    [anon_sym_SLASH_BSLASH] = ACTIONS(312),
    [anon_sym_6] = ACTIONS(312),
    [anon_sym_SLASH_SLASH] = ACTIONS(310),
    [anon_sym_7] = ACTIONS(312),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(312),
    [anon_sym_STAR] = ACTIONS(312),
    [anon_sym_EQ_EQ] = ACTIONS(310),
    [anon_sym_BANG_EQ] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_RBRACE] = ACTIONS(312),
    [sym_import_hash] = ACTIONS(312),
    [sym_local_import] = ACTIONS(312),
    [sym_http_raw] = ACTIONS(312),
    [aux_sym_env_import_token1] = ACTIONS(312),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(312),
    [anon_sym_DASHInfinity] = ACTIONS(312),
    [aux_sym_double_literal_token1] = ACTIONS(312),
    [sym_natural_literal] = ACTIONS(310),
    [sym_integer_literal] = ACTIONS(310),
    [anon_sym_DQUOTE] = ACTIONS(312),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(312),
    [anon_sym_LT] = ACTIONS(312),
    [anon_sym_PIPE] = ACTIONS(310),
    [anon_sym_GT] = ACTIONS(312),
    [anon_sym_True] = ACTIONS(310),
    [anon_sym_False] = ACTIONS(310),
  },
  [129] = {
    [sym_line_comment] = STATE(129),
    [sym_block_comment] = STATE(129),
    [sym_label] = ACTIONS(314),
    [anon_sym_COLON] = ACTIONS(314),
    [anon_sym_then] = ACTIONS(314),
    [anon_sym_else] = ACTIONS(314),
    [anon_sym_let] = ACTIONS(314),
    [anon_sym_in] = ACTIONS(314),
    [anon_sym_as] = ACTIONS(314),
    [anon_sym_missing] = ACTIONS(314),
    [anon_sym_Infinity] = ACTIONS(314),
    [anon_sym_NaN] = ACTIONS(314),
    [anon_sym_with] = ACTIONS(314),
    [anon_sym_Natural_SLASHfold] = ACTIONS(314),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(314),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(314),
    [anon_sym_Natural_SLASHeven] = ACTIONS(314),
    [anon_sym_Natural_SLASHodd] = ACTIONS(314),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(314),
    [anon_sym_Natural_SLASHshow] = ACTIONS(314),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(314),
    [anon_sym_Integer_SLASHshow] = ACTIONS(314),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(314),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(314),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(314),
    [anon_sym_Double_SLASHshow] = ACTIONS(314),
    [anon_sym_List_SLASHbuild] = ACTIONS(314),
    [anon_sym_List_SLASHfold] = ACTIONS(314),
    [anon_sym_List_SLASHlength] = ACTIONS(314),
    [anon_sym_List_SLASHhead] = ACTIONS(314),
    [anon_sym_List_SLASHlast] = ACTIONS(314),
    [anon_sym_List_SLASHindexed] = ACTIONS(314),
    [anon_sym_List_SLASHreverse] = ACTIONS(314),
    [anon_sym_Text_SLASHshow] = ACTIONS(314),
    [anon_sym_Text_SLASHreplace] = ACTIONS(314),
    [anon_sym_Bool] = ACTIONS(314),
    [anon_sym_Optional] = ACTIONS(314),
    [anon_sym_None] = ACTIONS(314),
    [anon_sym_Natural] = ACTIONS(314),
    [anon_sym_Integer] = ACTIONS(314),
    [anon_sym_Double] = ACTIONS(314),
    [anon_sym_Text] = ACTIONS(314),
    [anon_sym_Date] = ACTIONS(314),
    [anon_sym_Time] = ACTIONS(314),
    [anon_sym_TimeZone] = ACTIONS(314),
    [anon_sym_List] = ACTIONS(314),
    [anon_sym_Type] = ACTIONS(314),
    [anon_sym_Kind] = ACTIONS(314),
    [anon_sym_Sort] = ACTIONS(314),
    [anon_sym_LPAREN] = ACTIONS(316),
    [anon_sym_RPAREN] = ACTIONS(316),
    [anon_sym_2] = ACTIONS(316),
    [anon_sym_DASH_GT] = ACTIONS(316),
    [anon_sym_EQ] = ACTIONS(314),
    [anon_sym_DOT] = ACTIONS(314),
    [anon_sym_QMARK] = ACTIONS(316),
    [anon_sym_LBRACK] = ACTIONS(316),
    [anon_sym_COMMA] = ACTIONS(316),
    [anon_sym_RBRACK] = ACTIONS(316),
    [anon_sym_4] = ACTIONS(316),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(316),
    [anon_sym_PIPE_PIPE] = ACTIONS(316),
    [anon_sym_PLUS] = ACTIONS(314),
    [anon_sym_PLUS_PLUS] = ACTIONS(316),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_AMP_AMP] = ACTIONS(316),
    [anon_sym_5] = ACTIONS(316),
    [anon_sym_SLASH_BSLASH] = ACTIONS(316),
    [anon_sym_6] = ACTIONS(316),
    [anon_sym_SLASH_SLASH] = ACTIONS(314),
    [anon_sym_7] = ACTIONS(316),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(316),
    [anon_sym_STAR] = ACTIONS(316),
    [anon_sym_EQ_EQ] = ACTIONS(314),
    [anon_sym_BANG_EQ] = ACTIONS(316),
    [anon_sym_COLON_COLON] = ACTIONS(316),
    [anon_sym_LBRACE] = ACTIONS(314),
    [anon_sym_RBRACE] = ACTIONS(316),
    [sym_import_hash] = ACTIONS(316),
    [sym_local_import] = ACTIONS(316),
    [sym_http_raw] = ACTIONS(316),
    [aux_sym_env_import_token1] = ACTIONS(316),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(316),
    [anon_sym_DASHInfinity] = ACTIONS(316),
    [aux_sym_double_literal_token1] = ACTIONS(316),
    [sym_natural_literal] = ACTIONS(314),
    [sym_integer_literal] = ACTIONS(314),
    [anon_sym_DQUOTE] = ACTIONS(316),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(316),
    [anon_sym_LT] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(314),
    [anon_sym_GT] = ACTIONS(316),
    [anon_sym_True] = ACTIONS(314),
    [anon_sym_False] = ACTIONS(314),
  },
  [130] = {
    [sym_line_comment] = STATE(130),
    [sym_block_comment] = STATE(130),
    [sym_label] = ACTIONS(318),
    [anon_sym_COLON] = ACTIONS(318),
    [anon_sym_then] = ACTIONS(318),
    [anon_sym_else] = ACTIONS(318),
    [anon_sym_let] = ACTIONS(318),
    [anon_sym_in] = ACTIONS(318),
    [anon_sym_as] = ACTIONS(318),
    [anon_sym_missing] = ACTIONS(318),
    [anon_sym_Infinity] = ACTIONS(318),
    [anon_sym_NaN] = ACTIONS(318),
    [anon_sym_with] = ACTIONS(318),
    [anon_sym_Natural_SLASHfold] = ACTIONS(318),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(318),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(318),
    [anon_sym_Natural_SLASHeven] = ACTIONS(318),
    [anon_sym_Natural_SLASHodd] = ACTIONS(318),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(318),
    [anon_sym_Natural_SLASHshow] = ACTIONS(318),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(318),
    [anon_sym_Integer_SLASHshow] = ACTIONS(318),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(318),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(318),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(318),
    [anon_sym_Double_SLASHshow] = ACTIONS(318),
    [anon_sym_List_SLASHbuild] = ACTIONS(318),
    [anon_sym_List_SLASHfold] = ACTIONS(318),
    [anon_sym_List_SLASHlength] = ACTIONS(318),
    [anon_sym_List_SLASHhead] = ACTIONS(318),
    [anon_sym_List_SLASHlast] = ACTIONS(318),
    [anon_sym_List_SLASHindexed] = ACTIONS(318),
    [anon_sym_List_SLASHreverse] = ACTIONS(318),
    [anon_sym_Text_SLASHshow] = ACTIONS(318),
    [anon_sym_Text_SLASHreplace] = ACTIONS(318),
    [anon_sym_Bool] = ACTIONS(318),
    [anon_sym_Optional] = ACTIONS(318),
    [anon_sym_None] = ACTIONS(318),
    [anon_sym_Natural] = ACTIONS(318),
    [anon_sym_Integer] = ACTIONS(318),
    [anon_sym_Double] = ACTIONS(318),
    [anon_sym_Text] = ACTIONS(318),
    [anon_sym_Date] = ACTIONS(318),
    [anon_sym_Time] = ACTIONS(318),
    [anon_sym_TimeZone] = ACTIONS(318),
    [anon_sym_List] = ACTIONS(318),
    [anon_sym_Type] = ACTIONS(318),
    [anon_sym_Kind] = ACTIONS(318),
    [anon_sym_Sort] = ACTIONS(318),
    [anon_sym_LPAREN] = ACTIONS(320),
    [anon_sym_RPAREN] = ACTIONS(320),
    [anon_sym_2] = ACTIONS(320),
    [anon_sym_DASH_GT] = ACTIONS(320),
    [anon_sym_EQ] = ACTIONS(318),
    [anon_sym_DOT] = ACTIONS(318),
    [anon_sym_QMARK] = ACTIONS(320),
    [anon_sym_LBRACK] = ACTIONS(320),
    [anon_sym_COMMA] = ACTIONS(320),
    [anon_sym_RBRACK] = ACTIONS(320),
    [anon_sym_4] = ACTIONS(320),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(320),
    [anon_sym_PIPE_PIPE] = ACTIONS(320),
    [anon_sym_PLUS] = ACTIONS(318),
    [anon_sym_PLUS_PLUS] = ACTIONS(320),
    [anon_sym_POUND] = ACTIONS(320),
    [anon_sym_AMP_AMP] = ACTIONS(320),
    [anon_sym_5] = ACTIONS(320),
    [anon_sym_SLASH_BSLASH] = ACTIONS(320),
    [anon_sym_6] = ACTIONS(320),
    [anon_sym_SLASH_SLASH] = ACTIONS(318),
    [anon_sym_7] = ACTIONS(320),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(320),
    [anon_sym_STAR] = ACTIONS(320),
    [anon_sym_EQ_EQ] = ACTIONS(318),
    [anon_sym_BANG_EQ] = ACTIONS(320),
    [anon_sym_COLON_COLON] = ACTIONS(320),
    [anon_sym_LBRACE] = ACTIONS(318),
    [anon_sym_RBRACE] = ACTIONS(320),
    [sym_import_hash] = ACTIONS(320),
    [sym_local_import] = ACTIONS(320),
    [sym_http_raw] = ACTIONS(320),
    [aux_sym_env_import_token1] = ACTIONS(320),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(320),
    [anon_sym_DASHInfinity] = ACTIONS(320),
    [aux_sym_double_literal_token1] = ACTIONS(320),
    [sym_natural_literal] = ACTIONS(318),
    [sym_integer_literal] = ACTIONS(318),
    [anon_sym_DQUOTE] = ACTIONS(320),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(320),
    [anon_sym_LT] = ACTIONS(320),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_GT] = ACTIONS(320),
    [anon_sym_True] = ACTIONS(318),
    [anon_sym_False] = ACTIONS(318),
  },
  [131] = {
    [sym_line_comment] = STATE(131),
    [sym_block_comment] = STATE(131),
    [sym_label] = ACTIONS(322),
    [anon_sym_COLON] = ACTIONS(322),
    [anon_sym_then] = ACTIONS(322),
    [anon_sym_else] = ACTIONS(322),
    [anon_sym_let] = ACTIONS(322),
    [anon_sym_in] = ACTIONS(322),
    [anon_sym_as] = ACTIONS(322),
    [anon_sym_missing] = ACTIONS(322),
    [anon_sym_Infinity] = ACTIONS(322),
    [anon_sym_NaN] = ACTIONS(322),
    [anon_sym_with] = ACTIONS(322),
    [anon_sym_Natural_SLASHfold] = ACTIONS(322),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(322),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(322),
    [anon_sym_Natural_SLASHeven] = ACTIONS(322),
    [anon_sym_Natural_SLASHodd] = ACTIONS(322),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(322),
    [anon_sym_Natural_SLASHshow] = ACTIONS(322),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(322),
    [anon_sym_Integer_SLASHshow] = ACTIONS(322),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(322),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(322),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(322),
    [anon_sym_Double_SLASHshow] = ACTIONS(322),
    [anon_sym_List_SLASHbuild] = ACTIONS(322),
    [anon_sym_List_SLASHfold] = ACTIONS(322),
    [anon_sym_List_SLASHlength] = ACTIONS(322),
    [anon_sym_List_SLASHhead] = ACTIONS(322),
    [anon_sym_List_SLASHlast] = ACTIONS(322),
    [anon_sym_List_SLASHindexed] = ACTIONS(322),
    [anon_sym_List_SLASHreverse] = ACTIONS(322),
    [anon_sym_Text_SLASHshow] = ACTIONS(322),
    [anon_sym_Text_SLASHreplace] = ACTIONS(322),
    [anon_sym_Bool] = ACTIONS(322),
    [anon_sym_Optional] = ACTIONS(322),
    [anon_sym_None] = ACTIONS(322),
    [anon_sym_Natural] = ACTIONS(322),
    [anon_sym_Integer] = ACTIONS(322),
    [anon_sym_Double] = ACTIONS(322),
    [anon_sym_Text] = ACTIONS(322),
    [anon_sym_Date] = ACTIONS(322),
    [anon_sym_Time] = ACTIONS(322),
    [anon_sym_TimeZone] = ACTIONS(322),
    [anon_sym_List] = ACTIONS(322),
    [anon_sym_Type] = ACTIONS(322),
    [anon_sym_Kind] = ACTIONS(322),
    [anon_sym_Sort] = ACTIONS(322),
    [anon_sym_LPAREN] = ACTIONS(324),
    [anon_sym_RPAREN] = ACTIONS(324),
    [anon_sym_2] = ACTIONS(324),
    [anon_sym_DASH_GT] = ACTIONS(324),
    [anon_sym_EQ] = ACTIONS(322),
    [anon_sym_DOT] = ACTIONS(322),
    [anon_sym_QMARK] = ACTIONS(324),
    [anon_sym_LBRACK] = ACTIONS(324),
    [anon_sym_COMMA] = ACTIONS(324),
    [anon_sym_RBRACK] = ACTIONS(324),
    [anon_sym_4] = ACTIONS(324),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(324),
    [anon_sym_PIPE_PIPE] = ACTIONS(324),
    [anon_sym_PLUS] = ACTIONS(322),
    [anon_sym_PLUS_PLUS] = ACTIONS(324),
    [anon_sym_POUND] = ACTIONS(324),
    [anon_sym_AMP_AMP] = ACTIONS(324),
    [anon_sym_5] = ACTIONS(324),
    [anon_sym_SLASH_BSLASH] = ACTIONS(324),
    [anon_sym_6] = ACTIONS(324),
    [anon_sym_SLASH_SLASH] = ACTIONS(322),
    [anon_sym_7] = ACTIONS(324),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(324),
    [anon_sym_STAR] = ACTIONS(324),
    [anon_sym_EQ_EQ] = ACTIONS(322),
    [anon_sym_BANG_EQ] = ACTIONS(324),
    [anon_sym_COLON_COLON] = ACTIONS(324),
    [anon_sym_LBRACE] = ACTIONS(322),
    [anon_sym_RBRACE] = ACTIONS(324),
    [sym_import_hash] = ACTIONS(324),
    [sym_local_import] = ACTIONS(324),
    [sym_http_raw] = ACTIONS(324),
    [aux_sym_env_import_token1] = ACTIONS(324),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(324),
    [anon_sym_DASHInfinity] = ACTIONS(324),
    [aux_sym_double_literal_token1] = ACTIONS(324),
    [sym_natural_literal] = ACTIONS(322),
    [sym_integer_literal] = ACTIONS(322),
    [anon_sym_DQUOTE] = ACTIONS(324),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(324),
    [anon_sym_LT] = ACTIONS(324),
    [anon_sym_PIPE] = ACTIONS(322),
    [anon_sym_GT] = ACTIONS(324),
    [anon_sym_True] = ACTIONS(322),
    [anon_sym_False] = ACTIONS(322),
  },
  [132] = {
    [sym_line_comment] = STATE(132),
    [sym_block_comment] = STATE(132),
    [sym_label] = ACTIONS(326),
    [anon_sym_COLON] = ACTIONS(326),
    [anon_sym_then] = ACTIONS(326),
    [anon_sym_else] = ACTIONS(326),
    [anon_sym_let] = ACTIONS(326),
    [anon_sym_in] = ACTIONS(326),
    [anon_sym_as] = ACTIONS(326),
    [anon_sym_missing] = ACTIONS(326),
    [anon_sym_Infinity] = ACTIONS(326),
    [anon_sym_NaN] = ACTIONS(326),
    [anon_sym_with] = ACTIONS(326),
    [anon_sym_Natural_SLASHfold] = ACTIONS(326),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(326),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(326),
    [anon_sym_Natural_SLASHeven] = ACTIONS(326),
    [anon_sym_Natural_SLASHodd] = ACTIONS(326),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(326),
    [anon_sym_Natural_SLASHshow] = ACTIONS(326),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(326),
    [anon_sym_Integer_SLASHshow] = ACTIONS(326),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(326),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(326),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(326),
    [anon_sym_Double_SLASHshow] = ACTIONS(326),
    [anon_sym_List_SLASHbuild] = ACTIONS(326),
    [anon_sym_List_SLASHfold] = ACTIONS(326),
    [anon_sym_List_SLASHlength] = ACTIONS(326),
    [anon_sym_List_SLASHhead] = ACTIONS(326),
    [anon_sym_List_SLASHlast] = ACTIONS(326),
    [anon_sym_List_SLASHindexed] = ACTIONS(326),
    [anon_sym_List_SLASHreverse] = ACTIONS(326),
    [anon_sym_Text_SLASHshow] = ACTIONS(326),
    [anon_sym_Text_SLASHreplace] = ACTIONS(326),
    [anon_sym_Bool] = ACTIONS(326),
    [anon_sym_Optional] = ACTIONS(326),
    [anon_sym_None] = ACTIONS(326),
    [anon_sym_Natural] = ACTIONS(326),
    [anon_sym_Integer] = ACTIONS(326),
    [anon_sym_Double] = ACTIONS(326),
    [anon_sym_Text] = ACTIONS(326),
    [anon_sym_Date] = ACTIONS(326),
    [anon_sym_Time] = ACTIONS(326),
    [anon_sym_TimeZone] = ACTIONS(326),
    [anon_sym_List] = ACTIONS(326),
    [anon_sym_Type] = ACTIONS(326),
    [anon_sym_Kind] = ACTIONS(326),
    [anon_sym_Sort] = ACTIONS(326),
    [anon_sym_LPAREN] = ACTIONS(328),
    [anon_sym_RPAREN] = ACTIONS(328),
    [anon_sym_2] = ACTIONS(328),
    [anon_sym_DASH_GT] = ACTIONS(328),
    [anon_sym_EQ] = ACTIONS(326),
    [anon_sym_DOT] = ACTIONS(326),
    [anon_sym_QMARK] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(328),
    [anon_sym_COMMA] = ACTIONS(328),
    [anon_sym_RBRACK] = ACTIONS(328),
    [anon_sym_4] = ACTIONS(328),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(328),
    [anon_sym_PIPE_PIPE] = ACTIONS(328),
    [anon_sym_PLUS] = ACTIONS(326),
    [anon_sym_PLUS_PLUS] = ACTIONS(328),
    [anon_sym_POUND] = ACTIONS(328),
    [anon_sym_AMP_AMP] = ACTIONS(328),
    [anon_sym_5] = ACTIONS(328),
    [anon_sym_SLASH_BSLASH] = ACTIONS(328),
    [anon_sym_6] = ACTIONS(328),
    [anon_sym_SLASH_SLASH] = ACTIONS(326),
    [anon_sym_7] = ACTIONS(328),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(328),
    [anon_sym_STAR] = ACTIONS(328),
    [anon_sym_EQ_EQ] = ACTIONS(326),
    [anon_sym_BANG_EQ] = ACTIONS(328),
    [anon_sym_COLON_COLON] = ACTIONS(328),
    [anon_sym_LBRACE] = ACTIONS(326),
    [anon_sym_RBRACE] = ACTIONS(328),
    [sym_import_hash] = ACTIONS(328),
    [sym_local_import] = ACTIONS(328),
    [sym_http_raw] = ACTIONS(328),
    [aux_sym_env_import_token1] = ACTIONS(328),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(328),
    [anon_sym_DASHInfinity] = ACTIONS(328),
    [aux_sym_double_literal_token1] = ACTIONS(328),
    [sym_natural_literal] = ACTIONS(326),
    [sym_integer_literal] = ACTIONS(326),
    [anon_sym_DQUOTE] = ACTIONS(328),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(328),
    [anon_sym_LT] = ACTIONS(328),
    [anon_sym_PIPE] = ACTIONS(326),
    [anon_sym_GT] = ACTIONS(328),
    [anon_sym_True] = ACTIONS(326),
    [anon_sym_False] = ACTIONS(326),
  },
  [133] = {
    [sym_line_comment] = STATE(133),
    [sym_block_comment] = STATE(133),
    [sym_label] = ACTIONS(263),
    [anon_sym_COLON] = ACTIONS(263),
    [anon_sym_then] = ACTIONS(263),
    [anon_sym_else] = ACTIONS(263),
    [anon_sym_let] = ACTIONS(263),
    [anon_sym_in] = ACTIONS(263),
    [anon_sym_as] = ACTIONS(263),
    [anon_sym_missing] = ACTIONS(263),
    [anon_sym_Infinity] = ACTIONS(263),
    [anon_sym_NaN] = ACTIONS(263),
    [anon_sym_with] = ACTIONS(263),
    [anon_sym_Natural_SLASHfold] = ACTIONS(263),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(263),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(263),
    [anon_sym_Natural_SLASHeven] = ACTIONS(263),
    [anon_sym_Natural_SLASHodd] = ACTIONS(263),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(263),
    [anon_sym_Natural_SLASHshow] = ACTIONS(263),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(263),
    [anon_sym_Integer_SLASHshow] = ACTIONS(263),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(263),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(263),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(263),
    [anon_sym_Double_SLASHshow] = ACTIONS(263),
    [anon_sym_List_SLASHbuild] = ACTIONS(263),
    [anon_sym_List_SLASHfold] = ACTIONS(263),
    [anon_sym_List_SLASHlength] = ACTIONS(263),
    [anon_sym_List_SLASHhead] = ACTIONS(263),
    [anon_sym_List_SLASHlast] = ACTIONS(263),
    [anon_sym_List_SLASHindexed] = ACTIONS(263),
    [anon_sym_List_SLASHreverse] = ACTIONS(263),
    [anon_sym_Text_SLASHshow] = ACTIONS(263),
    [anon_sym_Text_SLASHreplace] = ACTIONS(263),
    [anon_sym_Bool] = ACTIONS(263),
    [anon_sym_Optional] = ACTIONS(263),
    [anon_sym_None] = ACTIONS(263),
    [anon_sym_Natural] = ACTIONS(263),
    [anon_sym_Integer] = ACTIONS(263),
    [anon_sym_Double] = ACTIONS(263),
    [anon_sym_Text] = ACTIONS(263),
    [anon_sym_Date] = ACTIONS(263),
    [anon_sym_Time] = ACTIONS(263),
    [anon_sym_TimeZone] = ACTIONS(263),
    [anon_sym_List] = ACTIONS(263),
    [anon_sym_Type] = ACTIONS(263),
    [anon_sym_Kind] = ACTIONS(263),
    [anon_sym_Sort] = ACTIONS(263),
    [anon_sym_LPAREN] = ACTIONS(265),
    [anon_sym_RPAREN] = ACTIONS(265),
    [anon_sym_2] = ACTIONS(265),
    [anon_sym_DASH_GT] = ACTIONS(265),
    [anon_sym_EQ] = ACTIONS(263),
    [anon_sym_DOT] = ACTIONS(263),
    [anon_sym_QMARK] = ACTIONS(265),
    [anon_sym_LBRACK] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_RBRACK] = ACTIONS(265),
    [anon_sym_4] = ACTIONS(265),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(265),
    [anon_sym_PIPE_PIPE] = ACTIONS(265),
    [anon_sym_PLUS] = ACTIONS(263),
    [anon_sym_PLUS_PLUS] = ACTIONS(265),
    [anon_sym_POUND] = ACTIONS(265),
    [anon_sym_AMP_AMP] = ACTIONS(265),
    [anon_sym_5] = ACTIONS(265),
    [anon_sym_SLASH_BSLASH] = ACTIONS(265),
    [anon_sym_6] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(263),
    [anon_sym_7] = ACTIONS(265),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(265),
    [anon_sym_STAR] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(263),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_COLON_COLON] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(263),
    [anon_sym_RBRACE] = ACTIONS(265),
    [sym_import_hash] = ACTIONS(265),
    [sym_local_import] = ACTIONS(265),
    [sym_http_raw] = ACTIONS(265),
    [aux_sym_env_import_token1] = ACTIONS(265),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(265),
    [anon_sym_DASHInfinity] = ACTIONS(265),
    [aux_sym_double_literal_token1] = ACTIONS(265),
    [sym_natural_literal] = ACTIONS(263),
    [sym_integer_literal] = ACTIONS(263),
    [anon_sym_DQUOTE] = ACTIONS(265),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(265),
    [anon_sym_LT] = ACTIONS(265),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(265),
    [anon_sym_True] = ACTIONS(263),
    [anon_sym_False] = ACTIONS(263),
  },
  [134] = {
    [sym_line_comment] = STATE(134),
    [sym_block_comment] = STATE(134),
    [sym_label] = ACTIONS(330),
    [anon_sym_COLON] = ACTIONS(330),
    [anon_sym_then] = ACTIONS(330),
    [anon_sym_else] = ACTIONS(330),
    [anon_sym_let] = ACTIONS(330),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_as] = ACTIONS(330),
    [anon_sym_missing] = ACTIONS(330),
    [anon_sym_Infinity] = ACTIONS(330),
    [anon_sym_NaN] = ACTIONS(330),
    [anon_sym_with] = ACTIONS(330),
    [anon_sym_Natural_SLASHfold] = ACTIONS(330),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(330),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(330),
    [anon_sym_Natural_SLASHeven] = ACTIONS(330),
    [anon_sym_Natural_SLASHodd] = ACTIONS(330),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(330),
    [anon_sym_Natural_SLASHshow] = ACTIONS(330),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(330),
    [anon_sym_Integer_SLASHshow] = ACTIONS(330),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(330),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(330),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(330),
    [anon_sym_Double_SLASHshow] = ACTIONS(330),
    [anon_sym_List_SLASHbuild] = ACTIONS(330),
    [anon_sym_List_SLASHfold] = ACTIONS(330),
    [anon_sym_List_SLASHlength] = ACTIONS(330),
    [anon_sym_List_SLASHhead] = ACTIONS(330),
    [anon_sym_List_SLASHlast] = ACTIONS(330),
    [anon_sym_List_SLASHindexed] = ACTIONS(330),
    [anon_sym_List_SLASHreverse] = ACTIONS(330),
    [anon_sym_Text_SLASHshow] = ACTIONS(330),
    [anon_sym_Text_SLASHreplace] = ACTIONS(330),
    [anon_sym_Bool] = ACTIONS(330),
    [anon_sym_Optional] = ACTIONS(330),
    [anon_sym_None] = ACTIONS(330),
    [anon_sym_Natural] = ACTIONS(330),
    [anon_sym_Integer] = ACTIONS(330),
    [anon_sym_Double] = ACTIONS(330),
    [anon_sym_Text] = ACTIONS(330),
    [anon_sym_Date] = ACTIONS(330),
    [anon_sym_Time] = ACTIONS(330),
    [anon_sym_TimeZone] = ACTIONS(330),
    [anon_sym_List] = ACTIONS(330),
    [anon_sym_Type] = ACTIONS(330),
    [anon_sym_Kind] = ACTIONS(330),
    [anon_sym_Sort] = ACTIONS(330),
    [anon_sym_LPAREN] = ACTIONS(332),
    [anon_sym_RPAREN] = ACTIONS(332),
    [anon_sym_2] = ACTIONS(332),
    [anon_sym_DASH_GT] = ACTIONS(332),
    [anon_sym_EQ] = ACTIONS(330),
    [anon_sym_DOT] = ACTIONS(330),
    [anon_sym_QMARK] = ACTIONS(332),
    [anon_sym_LBRACK] = ACTIONS(332),
    [anon_sym_COMMA] = ACTIONS(332),
    [anon_sym_RBRACK] = ACTIONS(332),
    [anon_sym_4] = ACTIONS(332),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(332),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_PLUS] = ACTIONS(330),
    [anon_sym_PLUS_PLUS] = ACTIONS(332),
    [anon_sym_POUND] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(332),
    [anon_sym_5] = ACTIONS(332),
    [anon_sym_SLASH_BSLASH] = ACTIONS(332),
    [anon_sym_6] = ACTIONS(332),
    [anon_sym_SLASH_SLASH] = ACTIONS(330),
    [anon_sym_7] = ACTIONS(332),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(332),
    [anon_sym_STAR] = ACTIONS(332),
    [anon_sym_EQ_EQ] = ACTIONS(330),
    [anon_sym_BANG_EQ] = ACTIONS(332),
    [anon_sym_COLON_COLON] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(330),
    [anon_sym_RBRACE] = ACTIONS(332),
    [sym_import_hash] = ACTIONS(332),
    [sym_local_import] = ACTIONS(332),
    [sym_http_raw] = ACTIONS(332),
    [aux_sym_env_import_token1] = ACTIONS(332),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(332),
    [anon_sym_DASHInfinity] = ACTIONS(332),
    [aux_sym_double_literal_token1] = ACTIONS(332),
    [sym_natural_literal] = ACTIONS(330),
    [sym_integer_literal] = ACTIONS(330),
    [anon_sym_DQUOTE] = ACTIONS(332),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(332),
    [anon_sym_LT] = ACTIONS(332),
    [anon_sym_PIPE] = ACTIONS(330),
    [anon_sym_GT] = ACTIONS(332),
    [anon_sym_True] = ACTIONS(330),
    [anon_sym_False] = ACTIONS(330),
  },
  [135] = {
    [sym_line_comment] = STATE(135),
    [sym_block_comment] = STATE(135),
    [sym_label] = ACTIONS(334),
    [anon_sym_COLON] = ACTIONS(334),
    [anon_sym_then] = ACTIONS(334),
    [anon_sym_else] = ACTIONS(334),
    [anon_sym_let] = ACTIONS(334),
    [anon_sym_in] = ACTIONS(334),
    [anon_sym_as] = ACTIONS(334),
    [anon_sym_missing] = ACTIONS(334),
    [anon_sym_Infinity] = ACTIONS(334),
    [anon_sym_NaN] = ACTIONS(334),
    [anon_sym_with] = ACTIONS(334),
    [anon_sym_Natural_SLASHfold] = ACTIONS(334),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(334),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(334),
    [anon_sym_Natural_SLASHeven] = ACTIONS(334),
    [anon_sym_Natural_SLASHodd] = ACTIONS(334),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(334),
    [anon_sym_Natural_SLASHshow] = ACTIONS(334),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(334),
    [anon_sym_Integer_SLASHshow] = ACTIONS(334),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(334),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(334),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(334),
    [anon_sym_Double_SLASHshow] = ACTIONS(334),
    [anon_sym_List_SLASHbuild] = ACTIONS(334),
    [anon_sym_List_SLASHfold] = ACTIONS(334),
    [anon_sym_List_SLASHlength] = ACTIONS(334),
    [anon_sym_List_SLASHhead] = ACTIONS(334),
    [anon_sym_List_SLASHlast] = ACTIONS(334),
    [anon_sym_List_SLASHindexed] = ACTIONS(334),
    [anon_sym_List_SLASHreverse] = ACTIONS(334),
    [anon_sym_Text_SLASHshow] = ACTIONS(334),
    [anon_sym_Text_SLASHreplace] = ACTIONS(334),
    [anon_sym_Bool] = ACTIONS(334),
    [anon_sym_Optional] = ACTIONS(334),
    [anon_sym_None] = ACTIONS(334),
    [anon_sym_Natural] = ACTIONS(334),
    [anon_sym_Integer] = ACTIONS(334),
    [anon_sym_Double] = ACTIONS(334),
    [anon_sym_Text] = ACTIONS(334),
    [anon_sym_Date] = ACTIONS(334),
    [anon_sym_Time] = ACTIONS(334),
    [anon_sym_TimeZone] = ACTIONS(334),
    [anon_sym_List] = ACTIONS(334),
    [anon_sym_Type] = ACTIONS(334),
    [anon_sym_Kind] = ACTIONS(334),
    [anon_sym_Sort] = ACTIONS(334),
    [anon_sym_LPAREN] = ACTIONS(336),
    [anon_sym_RPAREN] = ACTIONS(336),
    [anon_sym_2] = ACTIONS(336),
    [anon_sym_DASH_GT] = ACTIONS(336),
    [anon_sym_EQ] = ACTIONS(334),
    [anon_sym_DOT] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_LBRACK] = ACTIONS(336),
    [anon_sym_COMMA] = ACTIONS(336),
    [anon_sym_RBRACK] = ACTIONS(336),
    [anon_sym_4] = ACTIONS(336),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(336),
    [anon_sym_PIPE_PIPE] = ACTIONS(336),
    [anon_sym_PLUS] = ACTIONS(334),
    [anon_sym_PLUS_PLUS] = ACTIONS(336),
    [anon_sym_POUND] = ACTIONS(336),
    [anon_sym_AMP_AMP] = ACTIONS(336),
    [anon_sym_5] = ACTIONS(336),
    [anon_sym_SLASH_BSLASH] = ACTIONS(336),
    [anon_sym_6] = ACTIONS(336),
    [anon_sym_SLASH_SLASH] = ACTIONS(334),
    [anon_sym_7] = ACTIONS(336),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(336),
    [anon_sym_STAR] = ACTIONS(336),
    [anon_sym_EQ_EQ] = ACTIONS(334),
    [anon_sym_BANG_EQ] = ACTIONS(336),
    [anon_sym_COLON_COLON] = ACTIONS(336),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_RBRACE] = ACTIONS(336),
    [sym_import_hash] = ACTIONS(336),
    [sym_local_import] = ACTIONS(336),
    [sym_http_raw] = ACTIONS(336),
    [aux_sym_env_import_token1] = ACTIONS(336),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(336),
    [anon_sym_DASHInfinity] = ACTIONS(336),
    [aux_sym_double_literal_token1] = ACTIONS(336),
    [sym_natural_literal] = ACTIONS(334),
    [sym_integer_literal] = ACTIONS(334),
    [anon_sym_DQUOTE] = ACTIONS(336),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(336),
    [anon_sym_LT] = ACTIONS(336),
    [anon_sym_PIPE] = ACTIONS(334),
    [anon_sym_GT] = ACTIONS(336),
    [anon_sym_True] = ACTIONS(334),
    [anon_sym_False] = ACTIONS(334),
  },
  [136] = {
    [sym_line_comment] = STATE(136),
    [sym_block_comment] = STATE(136),
    [sym_label] = ACTIONS(338),
    [anon_sym_COLON] = ACTIONS(338),
    [anon_sym_then] = ACTIONS(338),
    [anon_sym_else] = ACTIONS(338),
    [anon_sym_let] = ACTIONS(338),
    [anon_sym_in] = ACTIONS(338),
    [anon_sym_as] = ACTIONS(338),
    [anon_sym_missing] = ACTIONS(338),
    [anon_sym_Infinity] = ACTIONS(338),
    [anon_sym_NaN] = ACTIONS(338),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_Natural_SLASHfold] = ACTIONS(338),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(338),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(338),
    [anon_sym_Natural_SLASHeven] = ACTIONS(338),
    [anon_sym_Natural_SLASHodd] = ACTIONS(338),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(338),
    [anon_sym_Natural_SLASHshow] = ACTIONS(338),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(338),
    [anon_sym_Integer_SLASHshow] = ACTIONS(338),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(338),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(338),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(338),
    [anon_sym_Double_SLASHshow] = ACTIONS(338),
    [anon_sym_List_SLASHbuild] = ACTIONS(338),
    [anon_sym_List_SLASHfold] = ACTIONS(338),
    [anon_sym_List_SLASHlength] = ACTIONS(338),
    [anon_sym_List_SLASHhead] = ACTIONS(338),
    [anon_sym_List_SLASHlast] = ACTIONS(338),
    [anon_sym_List_SLASHindexed] = ACTIONS(338),
    [anon_sym_List_SLASHreverse] = ACTIONS(338),
    [anon_sym_Text_SLASHshow] = ACTIONS(338),
    [anon_sym_Text_SLASHreplace] = ACTIONS(338),
    [anon_sym_Bool] = ACTIONS(338),
    [anon_sym_Optional] = ACTIONS(338),
    [anon_sym_None] = ACTIONS(338),
    [anon_sym_Natural] = ACTIONS(338),
    [anon_sym_Integer] = ACTIONS(338),
    [anon_sym_Double] = ACTIONS(338),
    [anon_sym_Text] = ACTIONS(338),
    [anon_sym_Date] = ACTIONS(338),
    [anon_sym_Time] = ACTIONS(338),
    [anon_sym_TimeZone] = ACTIONS(338),
    [anon_sym_List] = ACTIONS(338),
    [anon_sym_Type] = ACTIONS(338),
    [anon_sym_Kind] = ACTIONS(338),
    [anon_sym_Sort] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_RPAREN] = ACTIONS(340),
    [anon_sym_2] = ACTIONS(340),
    [anon_sym_DASH_GT] = ACTIONS(340),
    [anon_sym_EQ] = ACTIONS(338),
    [anon_sym_DOT] = ACTIONS(338),
    [anon_sym_QMARK] = ACTIONS(340),
    [anon_sym_LBRACK] = ACTIONS(340),
    [anon_sym_COMMA] = ACTIONS(340),
    [anon_sym_RBRACK] = ACTIONS(340),
    [anon_sym_4] = ACTIONS(340),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(340),
    [anon_sym_PIPE_PIPE] = ACTIONS(340),
    [anon_sym_PLUS] = ACTIONS(338),
    [anon_sym_PLUS_PLUS] = ACTIONS(340),
    [anon_sym_POUND] = ACTIONS(340),
    [anon_sym_AMP_AMP] = ACTIONS(340),
    [anon_sym_5] = ACTIONS(340),
    [anon_sym_SLASH_BSLASH] = ACTIONS(340),
    [anon_sym_6] = ACTIONS(340),
    [anon_sym_SLASH_SLASH] = ACTIONS(338),
    [anon_sym_7] = ACTIONS(340),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(340),
    [anon_sym_STAR] = ACTIONS(340),
    [anon_sym_EQ_EQ] = ACTIONS(338),
    [anon_sym_BANG_EQ] = ACTIONS(340),
    [anon_sym_COLON_COLON] = ACTIONS(340),
    [anon_sym_LBRACE] = ACTIONS(338),
    [anon_sym_RBRACE] = ACTIONS(340),
    [sym_import_hash] = ACTIONS(340),
    [sym_local_import] = ACTIONS(340),
    [sym_http_raw] = ACTIONS(340),
    [aux_sym_env_import_token1] = ACTIONS(340),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(340),
    [anon_sym_DASHInfinity] = ACTIONS(340),
    [aux_sym_double_literal_token1] = ACTIONS(340),
    [sym_natural_literal] = ACTIONS(338),
    [sym_integer_literal] = ACTIONS(338),
    [anon_sym_DQUOTE] = ACTIONS(340),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(340),
    [anon_sym_LT] = ACTIONS(340),
    [anon_sym_PIPE] = ACTIONS(338),
    [anon_sym_GT] = ACTIONS(340),
    [anon_sym_True] = ACTIONS(338),
    [anon_sym_False] = ACTIONS(338),
  },
  [137] = {
    [sym_line_comment] = STATE(137),
    [sym_block_comment] = STATE(137),
    [sym_label] = ACTIONS(342),
    [anon_sym_COLON] = ACTIONS(342),
    [anon_sym_then] = ACTIONS(342),
    [anon_sym_else] = ACTIONS(342),
    [anon_sym_let] = ACTIONS(342),
    [anon_sym_in] = ACTIONS(342),
    [anon_sym_as] = ACTIONS(342),
    [anon_sym_missing] = ACTIONS(342),
    [anon_sym_Infinity] = ACTIONS(342),
    [anon_sym_NaN] = ACTIONS(342),
    [anon_sym_with] = ACTIONS(342),
    [anon_sym_Natural_SLASHfold] = ACTIONS(342),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(342),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(342),
    [anon_sym_Natural_SLASHeven] = ACTIONS(342),
    [anon_sym_Natural_SLASHodd] = ACTIONS(342),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(342),
    [anon_sym_Natural_SLASHshow] = ACTIONS(342),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(342),
    [anon_sym_Integer_SLASHshow] = ACTIONS(342),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(342),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(342),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(342),
    [anon_sym_Double_SLASHshow] = ACTIONS(342),
    [anon_sym_List_SLASHbuild] = ACTIONS(342),
    [anon_sym_List_SLASHfold] = ACTIONS(342),
    [anon_sym_List_SLASHlength] = ACTIONS(342),
    [anon_sym_List_SLASHhead] = ACTIONS(342),
    [anon_sym_List_SLASHlast] = ACTIONS(342),
    [anon_sym_List_SLASHindexed] = ACTIONS(342),
    [anon_sym_List_SLASHreverse] = ACTIONS(342),
    [anon_sym_Text_SLASHshow] = ACTIONS(342),
    [anon_sym_Text_SLASHreplace] = ACTIONS(342),
    [anon_sym_Bool] = ACTIONS(342),
    [anon_sym_Optional] = ACTIONS(342),
    [anon_sym_None] = ACTIONS(342),
    [anon_sym_Natural] = ACTIONS(342),
    [anon_sym_Integer] = ACTIONS(342),
    [anon_sym_Double] = ACTIONS(342),
    [anon_sym_Text] = ACTIONS(342),
    [anon_sym_Date] = ACTIONS(342),
    [anon_sym_Time] = ACTIONS(342),
    [anon_sym_TimeZone] = ACTIONS(342),
    [anon_sym_List] = ACTIONS(342),
    [anon_sym_Type] = ACTIONS(342),
    [anon_sym_Kind] = ACTIONS(342),
    [anon_sym_Sort] = ACTIONS(342),
    [anon_sym_LPAREN] = ACTIONS(344),
    [anon_sym_RPAREN] = ACTIONS(344),
    [anon_sym_2] = ACTIONS(344),
    [anon_sym_DASH_GT] = ACTIONS(344),
    [anon_sym_EQ] = ACTIONS(342),
    [anon_sym_DOT] = ACTIONS(342),
    [anon_sym_QMARK] = ACTIONS(344),
    [anon_sym_LBRACK] = ACTIONS(344),
    [anon_sym_COMMA] = ACTIONS(344),
    [anon_sym_RBRACK] = ACTIONS(344),
    [anon_sym_4] = ACTIONS(344),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(344),
    [anon_sym_PIPE_PIPE] = ACTIONS(344),
    [anon_sym_PLUS] = ACTIONS(342),
    [anon_sym_PLUS_PLUS] = ACTIONS(344),
    [anon_sym_POUND] = ACTIONS(344),
    [anon_sym_AMP_AMP] = ACTIONS(344),
    [anon_sym_5] = ACTIONS(344),
    [anon_sym_SLASH_BSLASH] = ACTIONS(344),
    [anon_sym_6] = ACTIONS(344),
    [anon_sym_SLASH_SLASH] = ACTIONS(342),
    [anon_sym_7] = ACTIONS(344),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(344),
    [anon_sym_STAR] = ACTIONS(344),
    [anon_sym_EQ_EQ] = ACTIONS(342),
    [anon_sym_BANG_EQ] = ACTIONS(344),
    [anon_sym_COLON_COLON] = ACTIONS(344),
    [anon_sym_LBRACE] = ACTIONS(342),
    [anon_sym_RBRACE] = ACTIONS(344),
    [sym_import_hash] = ACTIONS(344),
    [sym_local_import] = ACTIONS(344),
    [sym_http_raw] = ACTIONS(344),
    [aux_sym_env_import_token1] = ACTIONS(344),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(344),
    [anon_sym_DASHInfinity] = ACTIONS(344),
    [aux_sym_double_literal_token1] = ACTIONS(344),
    [sym_natural_literal] = ACTIONS(342),
    [sym_integer_literal] = ACTIONS(342),
    [anon_sym_DQUOTE] = ACTIONS(344),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(344),
    [anon_sym_LT] = ACTIONS(344),
    [anon_sym_PIPE] = ACTIONS(342),
    [anon_sym_GT] = ACTIONS(344),
    [anon_sym_True] = ACTIONS(342),
    [anon_sym_False] = ACTIONS(342),
  },
  [138] = {
    [sym_line_comment] = STATE(138),
    [sym_block_comment] = STATE(138),
    [sym_label] = ACTIONS(346),
    [anon_sym_COLON] = ACTIONS(346),
    [anon_sym_then] = ACTIONS(346),
    [anon_sym_else] = ACTIONS(346),
    [anon_sym_let] = ACTIONS(346),
    [anon_sym_in] = ACTIONS(346),
    [anon_sym_as] = ACTIONS(346),
    [anon_sym_missing] = ACTIONS(346),
    [anon_sym_Infinity] = ACTIONS(346),
    [anon_sym_NaN] = ACTIONS(346),
    [anon_sym_with] = ACTIONS(346),
    [anon_sym_Natural_SLASHfold] = ACTIONS(346),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(346),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(346),
    [anon_sym_Natural_SLASHeven] = ACTIONS(346),
    [anon_sym_Natural_SLASHodd] = ACTIONS(346),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(346),
    [anon_sym_Natural_SLASHshow] = ACTIONS(346),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(346),
    [anon_sym_Integer_SLASHshow] = ACTIONS(346),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(346),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(346),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(346),
    [anon_sym_Double_SLASHshow] = ACTIONS(346),
    [anon_sym_List_SLASHbuild] = ACTIONS(346),
    [anon_sym_List_SLASHfold] = ACTIONS(346),
    [anon_sym_List_SLASHlength] = ACTIONS(346),
    [anon_sym_List_SLASHhead] = ACTIONS(346),
    [anon_sym_List_SLASHlast] = ACTIONS(346),
    [anon_sym_List_SLASHindexed] = ACTIONS(346),
    [anon_sym_List_SLASHreverse] = ACTIONS(346),
    [anon_sym_Text_SLASHshow] = ACTIONS(346),
    [anon_sym_Text_SLASHreplace] = ACTIONS(346),
    [anon_sym_Bool] = ACTIONS(346),
    [anon_sym_Optional] = ACTIONS(346),
    [anon_sym_None] = ACTIONS(346),
    [anon_sym_Natural] = ACTIONS(346),
    [anon_sym_Integer] = ACTIONS(346),
    [anon_sym_Double] = ACTIONS(346),
    [anon_sym_Text] = ACTIONS(346),
    [anon_sym_Date] = ACTIONS(346),
    [anon_sym_Time] = ACTIONS(346),
    [anon_sym_TimeZone] = ACTIONS(346),
    [anon_sym_List] = ACTIONS(346),
    [anon_sym_Type] = ACTIONS(346),
    [anon_sym_Kind] = ACTIONS(346),
    [anon_sym_Sort] = ACTIONS(346),
    [anon_sym_LPAREN] = ACTIONS(348),
    [anon_sym_RPAREN] = ACTIONS(348),
    [anon_sym_2] = ACTIONS(348),
    [anon_sym_DASH_GT] = ACTIONS(348),
    [anon_sym_EQ] = ACTIONS(346),
    [anon_sym_DOT] = ACTIONS(346),
    [anon_sym_QMARK] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(348),
    [anon_sym_COMMA] = ACTIONS(348),
    [anon_sym_RBRACK] = ACTIONS(348),
    [anon_sym_4] = ACTIONS(348),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(348),
    [anon_sym_PIPE_PIPE] = ACTIONS(348),
    [anon_sym_PLUS] = ACTIONS(346),
    [anon_sym_PLUS_PLUS] = ACTIONS(348),
    [anon_sym_POUND] = ACTIONS(348),
    [anon_sym_AMP_AMP] = ACTIONS(348),
    [anon_sym_5] = ACTIONS(348),
    [anon_sym_SLASH_BSLASH] = ACTIONS(348),
    [anon_sym_6] = ACTIONS(348),
    [anon_sym_SLASH_SLASH] = ACTIONS(346),
    [anon_sym_7] = ACTIONS(348),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(348),
    [anon_sym_STAR] = ACTIONS(348),
    [anon_sym_EQ_EQ] = ACTIONS(346),
    [anon_sym_BANG_EQ] = ACTIONS(348),
    [anon_sym_COLON_COLON] = ACTIONS(348),
    [anon_sym_LBRACE] = ACTIONS(346),
    [anon_sym_RBRACE] = ACTIONS(348),
    [sym_import_hash] = ACTIONS(348),
    [sym_local_import] = ACTIONS(348),
    [sym_http_raw] = ACTIONS(348),
    [aux_sym_env_import_token1] = ACTIONS(348),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(348),
    [anon_sym_DASHInfinity] = ACTIONS(348),
    [aux_sym_double_literal_token1] = ACTIONS(348),
    [sym_natural_literal] = ACTIONS(346),
    [sym_integer_literal] = ACTIONS(346),
    [anon_sym_DQUOTE] = ACTIONS(348),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(348),
    [anon_sym_PIPE] = ACTIONS(346),
    [anon_sym_GT] = ACTIONS(348),
    [anon_sym_True] = ACTIONS(346),
    [anon_sym_False] = ACTIONS(346),
  },
  [139] = {
    [sym_line_comment] = STATE(139),
    [sym_block_comment] = STATE(139),
    [sym_label] = ACTIONS(350),
    [anon_sym_COLON] = ACTIONS(350),
    [anon_sym_then] = ACTIONS(350),
    [anon_sym_else] = ACTIONS(350),
    [anon_sym_let] = ACTIONS(350),
    [anon_sym_in] = ACTIONS(350),
    [anon_sym_as] = ACTIONS(350),
    [anon_sym_missing] = ACTIONS(350),
    [anon_sym_Infinity] = ACTIONS(350),
    [anon_sym_NaN] = ACTIONS(350),
    [anon_sym_with] = ACTIONS(350),
    [anon_sym_Natural_SLASHfold] = ACTIONS(350),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(350),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(350),
    [anon_sym_Natural_SLASHeven] = ACTIONS(350),
    [anon_sym_Natural_SLASHodd] = ACTIONS(350),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(350),
    [anon_sym_Natural_SLASHshow] = ACTIONS(350),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(350),
    [anon_sym_Integer_SLASHshow] = ACTIONS(350),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(350),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(350),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(350),
    [anon_sym_Double_SLASHshow] = ACTIONS(350),
    [anon_sym_List_SLASHbuild] = ACTIONS(350),
    [anon_sym_List_SLASHfold] = ACTIONS(350),
    [anon_sym_List_SLASHlength] = ACTIONS(350),
    [anon_sym_List_SLASHhead] = ACTIONS(350),
    [anon_sym_List_SLASHlast] = ACTIONS(350),
    [anon_sym_List_SLASHindexed] = ACTIONS(350),
    [anon_sym_List_SLASHreverse] = ACTIONS(350),
    [anon_sym_Text_SLASHshow] = ACTIONS(350),
    [anon_sym_Text_SLASHreplace] = ACTIONS(350),
    [anon_sym_Bool] = ACTIONS(350),
    [anon_sym_Optional] = ACTIONS(350),
    [anon_sym_None] = ACTIONS(350),
    [anon_sym_Natural] = ACTIONS(350),
    [anon_sym_Integer] = ACTIONS(350),
    [anon_sym_Double] = ACTIONS(350),
    [anon_sym_Text] = ACTIONS(350),
    [anon_sym_Date] = ACTIONS(350),
    [anon_sym_Time] = ACTIONS(350),
    [anon_sym_TimeZone] = ACTIONS(350),
    [anon_sym_List] = ACTIONS(350),
    [anon_sym_Type] = ACTIONS(350),
    [anon_sym_Kind] = ACTIONS(350),
    [anon_sym_Sort] = ACTIONS(350),
    [anon_sym_LPAREN] = ACTIONS(352),
    [anon_sym_RPAREN] = ACTIONS(352),
    [anon_sym_2] = ACTIONS(352),
    [anon_sym_DASH_GT] = ACTIONS(352),
    [anon_sym_EQ] = ACTIONS(350),
    [anon_sym_DOT] = ACTIONS(350),
    [anon_sym_QMARK] = ACTIONS(352),
    [anon_sym_LBRACK] = ACTIONS(352),
    [anon_sym_COMMA] = ACTIONS(352),
    [anon_sym_RBRACK] = ACTIONS(352),
    [anon_sym_4] = ACTIONS(352),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(352),
    [anon_sym_PIPE_PIPE] = ACTIONS(352),
    [anon_sym_PLUS] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_POUND] = ACTIONS(352),
    [anon_sym_AMP_AMP] = ACTIONS(352),
    [anon_sym_5] = ACTIONS(352),
    [anon_sym_SLASH_BSLASH] = ACTIONS(352),
    [anon_sym_6] = ACTIONS(352),
    [anon_sym_SLASH_SLASH] = ACTIONS(350),
    [anon_sym_7] = ACTIONS(352),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(352),
    [anon_sym_STAR] = ACTIONS(352),
    [anon_sym_EQ_EQ] = ACTIONS(350),
    [anon_sym_BANG_EQ] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(352),
    [anon_sym_LBRACE] = ACTIONS(350),
    [anon_sym_RBRACE] = ACTIONS(352),
    [sym_import_hash] = ACTIONS(352),
    [sym_local_import] = ACTIONS(352),
    [sym_http_raw] = ACTIONS(352),
    [aux_sym_env_import_token1] = ACTIONS(352),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(352),
    [anon_sym_DASHInfinity] = ACTIONS(352),
    [aux_sym_double_literal_token1] = ACTIONS(352),
    [sym_natural_literal] = ACTIONS(350),
    [sym_integer_literal] = ACTIONS(350),
    [anon_sym_DQUOTE] = ACTIONS(352),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(352),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_PIPE] = ACTIONS(350),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_True] = ACTIONS(350),
    [anon_sym_False] = ACTIONS(350),
  },
  [140] = {
    [sym_line_comment] = STATE(140),
    [sym_block_comment] = STATE(140),
    [sym_label] = ACTIONS(354),
    [anon_sym_COLON] = ACTIONS(354),
    [anon_sym_then] = ACTIONS(354),
    [anon_sym_else] = ACTIONS(354),
    [anon_sym_let] = ACTIONS(354),
    [anon_sym_in] = ACTIONS(354),
    [anon_sym_as] = ACTIONS(354),
    [anon_sym_missing] = ACTIONS(354),
    [anon_sym_Infinity] = ACTIONS(354),
    [anon_sym_NaN] = ACTIONS(354),
    [anon_sym_with] = ACTIONS(354),
    [anon_sym_Natural_SLASHfold] = ACTIONS(354),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(354),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(354),
    [anon_sym_Natural_SLASHeven] = ACTIONS(354),
    [anon_sym_Natural_SLASHodd] = ACTIONS(354),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(354),
    [anon_sym_Natural_SLASHshow] = ACTIONS(354),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(354),
    [anon_sym_Integer_SLASHshow] = ACTIONS(354),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(354),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(354),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(354),
    [anon_sym_Double_SLASHshow] = ACTIONS(354),
    [anon_sym_List_SLASHbuild] = ACTIONS(354),
    [anon_sym_List_SLASHfold] = ACTIONS(354),
    [anon_sym_List_SLASHlength] = ACTIONS(354),
    [anon_sym_List_SLASHhead] = ACTIONS(354),
    [anon_sym_List_SLASHlast] = ACTIONS(354),
    [anon_sym_List_SLASHindexed] = ACTIONS(354),
    [anon_sym_List_SLASHreverse] = ACTIONS(354),
    [anon_sym_Text_SLASHshow] = ACTIONS(354),
    [anon_sym_Text_SLASHreplace] = ACTIONS(354),
    [anon_sym_Bool] = ACTIONS(354),
    [anon_sym_Optional] = ACTIONS(354),
    [anon_sym_None] = ACTIONS(354),
    [anon_sym_Natural] = ACTIONS(354),
    [anon_sym_Integer] = ACTIONS(354),
    [anon_sym_Double] = ACTIONS(354),
    [anon_sym_Text] = ACTIONS(354),
    [anon_sym_Date] = ACTIONS(354),
    [anon_sym_Time] = ACTIONS(354),
    [anon_sym_TimeZone] = ACTIONS(354),
    [anon_sym_List] = ACTIONS(354),
    [anon_sym_Type] = ACTIONS(354),
    [anon_sym_Kind] = ACTIONS(354),
    [anon_sym_Sort] = ACTIONS(354),
    [anon_sym_LPAREN] = ACTIONS(356),
    [anon_sym_RPAREN] = ACTIONS(356),
    [anon_sym_2] = ACTIONS(356),
    [anon_sym_DASH_GT] = ACTIONS(356),
    [anon_sym_EQ] = ACTIONS(354),
    [anon_sym_DOT] = ACTIONS(354),
    [anon_sym_QMARK] = ACTIONS(356),
    [anon_sym_LBRACK] = ACTIONS(356),
    [anon_sym_COMMA] = ACTIONS(356),
    [anon_sym_RBRACK] = ACTIONS(356),
    [anon_sym_4] = ACTIONS(356),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(356),
    [anon_sym_PIPE_PIPE] = ACTIONS(356),
    [anon_sym_PLUS] = ACTIONS(354),
    [anon_sym_PLUS_PLUS] = ACTIONS(356),
    [anon_sym_POUND] = ACTIONS(356),
    [anon_sym_AMP_AMP] = ACTIONS(356),
    [anon_sym_5] = ACTIONS(356),
    [anon_sym_SLASH_BSLASH] = ACTIONS(356),
    [anon_sym_6] = ACTIONS(356),
    [anon_sym_SLASH_SLASH] = ACTIONS(354),
    [anon_sym_7] = ACTIONS(356),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(356),
    [anon_sym_STAR] = ACTIONS(356),
    [anon_sym_EQ_EQ] = ACTIONS(354),
    [anon_sym_BANG_EQ] = ACTIONS(356),
    [anon_sym_COLON_COLON] = ACTIONS(356),
    [anon_sym_LBRACE] = ACTIONS(354),
    [anon_sym_RBRACE] = ACTIONS(356),
    [sym_import_hash] = ACTIONS(356),
    [sym_local_import] = ACTIONS(356),
    [sym_http_raw] = ACTIONS(356),
    [aux_sym_env_import_token1] = ACTIONS(356),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(356),
    [anon_sym_DASHInfinity] = ACTIONS(356),
    [aux_sym_double_literal_token1] = ACTIONS(356),
    [sym_natural_literal] = ACTIONS(354),
    [sym_integer_literal] = ACTIONS(354),
    [anon_sym_DQUOTE] = ACTIONS(356),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(356),
    [anon_sym_LT] = ACTIONS(356),
    [anon_sym_PIPE] = ACTIONS(354),
    [anon_sym_GT] = ACTIONS(356),
    [anon_sym_True] = ACTIONS(354),
    [anon_sym_False] = ACTIONS(354),
  },
  [141] = {
    [sym_line_comment] = STATE(141),
    [sym_block_comment] = STATE(141),
    [sym_label] = ACTIONS(358),
    [anon_sym_COLON] = ACTIONS(358),
    [anon_sym_then] = ACTIONS(358),
    [anon_sym_else] = ACTIONS(358),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_in] = ACTIONS(358),
    [anon_sym_as] = ACTIONS(358),
    [anon_sym_missing] = ACTIONS(358),
    [anon_sym_Infinity] = ACTIONS(358),
    [anon_sym_NaN] = ACTIONS(358),
    [anon_sym_with] = ACTIONS(358),
    [anon_sym_Natural_SLASHfold] = ACTIONS(358),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(358),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(358),
    [anon_sym_Natural_SLASHeven] = ACTIONS(358),
    [anon_sym_Natural_SLASHodd] = ACTIONS(358),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(358),
    [anon_sym_Natural_SLASHshow] = ACTIONS(358),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(358),
    [anon_sym_Integer_SLASHshow] = ACTIONS(358),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(358),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(358),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(358),
    [anon_sym_Double_SLASHshow] = ACTIONS(358),
    [anon_sym_List_SLASHbuild] = ACTIONS(358),
    [anon_sym_List_SLASHfold] = ACTIONS(358),
    [anon_sym_List_SLASHlength] = ACTIONS(358),
    [anon_sym_List_SLASHhead] = ACTIONS(358),
    [anon_sym_List_SLASHlast] = ACTIONS(358),
    [anon_sym_List_SLASHindexed] = ACTIONS(358),
    [anon_sym_List_SLASHreverse] = ACTIONS(358),
    [anon_sym_Text_SLASHshow] = ACTIONS(358),
    [anon_sym_Text_SLASHreplace] = ACTIONS(358),
    [anon_sym_Bool] = ACTIONS(358),
    [anon_sym_Optional] = ACTIONS(358),
    [anon_sym_None] = ACTIONS(358),
    [anon_sym_Natural] = ACTIONS(358),
    [anon_sym_Integer] = ACTIONS(358),
    [anon_sym_Double] = ACTIONS(358),
    [anon_sym_Text] = ACTIONS(358),
    [anon_sym_Date] = ACTIONS(358),
    [anon_sym_Time] = ACTIONS(358),
    [anon_sym_TimeZone] = ACTIONS(358),
    [anon_sym_List] = ACTIONS(358),
    [anon_sym_Type] = ACTIONS(358),
    [anon_sym_Kind] = ACTIONS(358),
    [anon_sym_Sort] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(360),
    [anon_sym_RPAREN] = ACTIONS(360),
    [anon_sym_2] = ACTIONS(360),
    [anon_sym_DASH_GT] = ACTIONS(360),
    [anon_sym_EQ] = ACTIONS(358),
    [anon_sym_DOT] = ACTIONS(358),
    [anon_sym_QMARK] = ACTIONS(360),
    [anon_sym_LBRACK] = ACTIONS(360),
    [anon_sym_COMMA] = ACTIONS(360),
    [anon_sym_RBRACK] = ACTIONS(360),
    [anon_sym_4] = ACTIONS(360),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(360),
    [anon_sym_PIPE_PIPE] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(358),
    [anon_sym_PLUS_PLUS] = ACTIONS(360),
    [anon_sym_POUND] = ACTIONS(360),
    [anon_sym_AMP_AMP] = ACTIONS(360),
    [anon_sym_5] = ACTIONS(360),
    [anon_sym_SLASH_BSLASH] = ACTIONS(360),
    [anon_sym_6] = ACTIONS(360),
    [anon_sym_SLASH_SLASH] = ACTIONS(358),
    [anon_sym_7] = ACTIONS(360),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(360),
    [anon_sym_STAR] = ACTIONS(360),
    [anon_sym_EQ_EQ] = ACTIONS(358),
    [anon_sym_BANG_EQ] = ACTIONS(360),
    [anon_sym_COLON_COLON] = ACTIONS(360),
    [anon_sym_LBRACE] = ACTIONS(358),
    [anon_sym_RBRACE] = ACTIONS(360),
    [sym_import_hash] = ACTIONS(360),
    [sym_local_import] = ACTIONS(360),
    [sym_http_raw] = ACTIONS(360),
    [aux_sym_env_import_token1] = ACTIONS(360),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(360),
    [anon_sym_DASHInfinity] = ACTIONS(360),
    [aux_sym_double_literal_token1] = ACTIONS(360),
    [sym_natural_literal] = ACTIONS(358),
    [sym_integer_literal] = ACTIONS(358),
    [anon_sym_DQUOTE] = ACTIONS(360),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(360),
    [anon_sym_LT] = ACTIONS(360),
    [anon_sym_PIPE] = ACTIONS(358),
    [anon_sym_GT] = ACTIONS(360),
    [anon_sym_True] = ACTIONS(358),
    [anon_sym_False] = ACTIONS(358),
  },
  [142] = {
    [sym_line_comment] = STATE(142),
    [sym_block_comment] = STATE(142),
    [sym_label] = ACTIONS(362),
    [anon_sym_COLON] = ACTIONS(362),
    [anon_sym_then] = ACTIONS(362),
    [anon_sym_else] = ACTIONS(362),
    [anon_sym_let] = ACTIONS(362),
    [anon_sym_in] = ACTIONS(362),
    [anon_sym_as] = ACTIONS(362),
    [anon_sym_missing] = ACTIONS(362),
    [anon_sym_Infinity] = ACTIONS(362),
    [anon_sym_NaN] = ACTIONS(362),
    [anon_sym_with] = ACTIONS(362),
    [anon_sym_Natural_SLASHfold] = ACTIONS(362),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(362),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(362),
    [anon_sym_Natural_SLASHeven] = ACTIONS(362),
    [anon_sym_Natural_SLASHodd] = ACTIONS(362),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(362),
    [anon_sym_Natural_SLASHshow] = ACTIONS(362),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(362),
    [anon_sym_Integer_SLASHshow] = ACTIONS(362),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(362),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(362),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(362),
    [anon_sym_Double_SLASHshow] = ACTIONS(362),
    [anon_sym_List_SLASHbuild] = ACTIONS(362),
    [anon_sym_List_SLASHfold] = ACTIONS(362),
    [anon_sym_List_SLASHlength] = ACTIONS(362),
    [anon_sym_List_SLASHhead] = ACTIONS(362),
    [anon_sym_List_SLASHlast] = ACTIONS(362),
    [anon_sym_List_SLASHindexed] = ACTIONS(362),
    [anon_sym_List_SLASHreverse] = ACTIONS(362),
    [anon_sym_Text_SLASHshow] = ACTIONS(362),
    [anon_sym_Text_SLASHreplace] = ACTIONS(362),
    [anon_sym_Bool] = ACTIONS(362),
    [anon_sym_Optional] = ACTIONS(362),
    [anon_sym_None] = ACTIONS(362),
    [anon_sym_Natural] = ACTIONS(362),
    [anon_sym_Integer] = ACTIONS(362),
    [anon_sym_Double] = ACTIONS(362),
    [anon_sym_Text] = ACTIONS(362),
    [anon_sym_Date] = ACTIONS(362),
    [anon_sym_Time] = ACTIONS(362),
    [anon_sym_TimeZone] = ACTIONS(362),
    [anon_sym_List] = ACTIONS(362),
    [anon_sym_Type] = ACTIONS(362),
    [anon_sym_Kind] = ACTIONS(362),
    [anon_sym_Sort] = ACTIONS(362),
    [anon_sym_LPAREN] = ACTIONS(364),
    [anon_sym_RPAREN] = ACTIONS(364),
    [anon_sym_2] = ACTIONS(364),
    [anon_sym_DASH_GT] = ACTIONS(364),
    [anon_sym_EQ] = ACTIONS(362),
    [anon_sym_DOT] = ACTIONS(362),
    [anon_sym_QMARK] = ACTIONS(364),
    [anon_sym_LBRACK] = ACTIONS(364),
    [anon_sym_COMMA] = ACTIONS(364),
    [anon_sym_RBRACK] = ACTIONS(364),
    [anon_sym_4] = ACTIONS(364),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(364),
    [anon_sym_PIPE_PIPE] = ACTIONS(364),
    [anon_sym_PLUS] = ACTIONS(362),
    [anon_sym_PLUS_PLUS] = ACTIONS(364),
    [anon_sym_POUND] = ACTIONS(364),
    [anon_sym_AMP_AMP] = ACTIONS(364),
    [anon_sym_5] = ACTIONS(364),
    [anon_sym_SLASH_BSLASH] = ACTIONS(364),
    [anon_sym_6] = ACTIONS(364),
    [anon_sym_SLASH_SLASH] = ACTIONS(362),
    [anon_sym_7] = ACTIONS(364),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(364),
    [anon_sym_STAR] = ACTIONS(364),
    [anon_sym_EQ_EQ] = ACTIONS(362),
    [anon_sym_BANG_EQ] = ACTIONS(364),
    [anon_sym_COLON_COLON] = ACTIONS(364),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_RBRACE] = ACTIONS(364),
    [sym_import_hash] = ACTIONS(364),
    [sym_local_import] = ACTIONS(364),
    [sym_http_raw] = ACTIONS(364),
    [aux_sym_env_import_token1] = ACTIONS(364),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(364),
    [anon_sym_DASHInfinity] = ACTIONS(364),
    [aux_sym_double_literal_token1] = ACTIONS(364),
    [sym_natural_literal] = ACTIONS(362),
    [sym_integer_literal] = ACTIONS(362),
    [anon_sym_DQUOTE] = ACTIONS(364),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(364),
    [anon_sym_LT] = ACTIONS(364),
    [anon_sym_PIPE] = ACTIONS(362),
    [anon_sym_GT] = ACTIONS(364),
    [anon_sym_True] = ACTIONS(362),
    [anon_sym_False] = ACTIONS(362),
  },
  [143] = {
    [sym_line_comment] = STATE(143),
    [sym_block_comment] = STATE(143),
    [sym_label] = ACTIONS(366),
    [anon_sym_COLON] = ACTIONS(366),
    [anon_sym_then] = ACTIONS(366),
    [anon_sym_else] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(366),
    [anon_sym_in] = ACTIONS(366),
    [anon_sym_as] = ACTIONS(366),
    [anon_sym_missing] = ACTIONS(366),
    [anon_sym_Infinity] = ACTIONS(366),
    [anon_sym_NaN] = ACTIONS(366),
    [anon_sym_with] = ACTIONS(366),
    [anon_sym_Natural_SLASHfold] = ACTIONS(366),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(366),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(366),
    [anon_sym_Natural_SLASHeven] = ACTIONS(366),
    [anon_sym_Natural_SLASHodd] = ACTIONS(366),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(366),
    [anon_sym_Natural_SLASHshow] = ACTIONS(366),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(366),
    [anon_sym_Integer_SLASHshow] = ACTIONS(366),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(366),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(366),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(366),
    [anon_sym_Double_SLASHshow] = ACTIONS(366),
    [anon_sym_List_SLASHbuild] = ACTIONS(366),
    [anon_sym_List_SLASHfold] = ACTIONS(366),
    [anon_sym_List_SLASHlength] = ACTIONS(366),
    [anon_sym_List_SLASHhead] = ACTIONS(366),
    [anon_sym_List_SLASHlast] = ACTIONS(366),
    [anon_sym_List_SLASHindexed] = ACTIONS(366),
    [anon_sym_List_SLASHreverse] = ACTIONS(366),
    [anon_sym_Text_SLASHshow] = ACTIONS(366),
    [anon_sym_Text_SLASHreplace] = ACTIONS(366),
    [anon_sym_Bool] = ACTIONS(366),
    [anon_sym_Optional] = ACTIONS(366),
    [anon_sym_None] = ACTIONS(366),
    [anon_sym_Natural] = ACTIONS(366),
    [anon_sym_Integer] = ACTIONS(366),
    [anon_sym_Double] = ACTIONS(366),
    [anon_sym_Text] = ACTIONS(366),
    [anon_sym_Date] = ACTIONS(366),
    [anon_sym_Time] = ACTIONS(366),
    [anon_sym_TimeZone] = ACTIONS(366),
    [anon_sym_List] = ACTIONS(366),
    [anon_sym_Type] = ACTIONS(366),
    [anon_sym_Kind] = ACTIONS(366),
    [anon_sym_Sort] = ACTIONS(366),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(368),
    [anon_sym_2] = ACTIONS(368),
    [anon_sym_DASH_GT] = ACTIONS(368),
    [anon_sym_EQ] = ACTIONS(366),
    [anon_sym_DOT] = ACTIONS(366),
    [anon_sym_QMARK] = ACTIONS(368),
    [anon_sym_LBRACK] = ACTIONS(368),
    [anon_sym_COMMA] = ACTIONS(368),
    [anon_sym_RBRACK] = ACTIONS(368),
    [anon_sym_4] = ACTIONS(368),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(368),
    [anon_sym_PIPE_PIPE] = ACTIONS(368),
    [anon_sym_PLUS] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_POUND] = ACTIONS(368),
    [anon_sym_AMP_AMP] = ACTIONS(368),
    [anon_sym_5] = ACTIONS(368),
    [anon_sym_SLASH_BSLASH] = ACTIONS(368),
    [anon_sym_6] = ACTIONS(368),
    [anon_sym_SLASH_SLASH] = ACTIONS(366),
    [anon_sym_7] = ACTIONS(368),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(368),
    [anon_sym_STAR] = ACTIONS(368),
    [anon_sym_EQ_EQ] = ACTIONS(366),
    [anon_sym_BANG_EQ] = ACTIONS(368),
    [anon_sym_COLON_COLON] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(366),
    [anon_sym_RBRACE] = ACTIONS(368),
    [sym_import_hash] = ACTIONS(368),
    [sym_local_import] = ACTIONS(368),
    [sym_http_raw] = ACTIONS(368),
    [aux_sym_env_import_token1] = ACTIONS(368),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(368),
    [anon_sym_DASHInfinity] = ACTIONS(368),
    [aux_sym_double_literal_token1] = ACTIONS(368),
    [sym_natural_literal] = ACTIONS(366),
    [sym_integer_literal] = ACTIONS(366),
    [anon_sym_DQUOTE] = ACTIONS(368),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(368),
    [anon_sym_LT] = ACTIONS(368),
    [anon_sym_PIPE] = ACTIONS(366),
    [anon_sym_GT] = ACTIONS(368),
    [anon_sym_True] = ACTIONS(366),
    [anon_sym_False] = ACTIONS(366),
  },
  [144] = {
    [sym_line_comment] = STATE(144),
    [sym_block_comment] = STATE(144),
    [sym_label] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_then] = ACTIONS(279),
    [anon_sym_else] = ACTIONS(279),
    [anon_sym_let] = ACTIONS(279),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_missing] = ACTIONS(279),
    [anon_sym_Infinity] = ACTIONS(279),
    [anon_sym_NaN] = ACTIONS(279),
    [anon_sym_with] = ACTIONS(279),
    [anon_sym_Natural_SLASHfold] = ACTIONS(279),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(279),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(279),
    [anon_sym_Natural_SLASHeven] = ACTIONS(279),
    [anon_sym_Natural_SLASHodd] = ACTIONS(279),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(279),
    [anon_sym_Natural_SLASHshow] = ACTIONS(279),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(279),
    [anon_sym_Integer_SLASHshow] = ACTIONS(279),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(279),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(279),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(279),
    [anon_sym_Double_SLASHshow] = ACTIONS(279),
    [anon_sym_List_SLASHbuild] = ACTIONS(279),
    [anon_sym_List_SLASHfold] = ACTIONS(279),
    [anon_sym_List_SLASHlength] = ACTIONS(279),
    [anon_sym_List_SLASHhead] = ACTIONS(279),
    [anon_sym_List_SLASHlast] = ACTIONS(279),
    [anon_sym_List_SLASHindexed] = ACTIONS(279),
    [anon_sym_List_SLASHreverse] = ACTIONS(279),
    [anon_sym_Text_SLASHshow] = ACTIONS(279),
    [anon_sym_Text_SLASHreplace] = ACTIONS(279),
    [anon_sym_Bool] = ACTIONS(279),
    [anon_sym_Optional] = ACTIONS(279),
    [anon_sym_None] = ACTIONS(279),
    [anon_sym_Natural] = ACTIONS(279),
    [anon_sym_Integer] = ACTIONS(279),
    [anon_sym_Double] = ACTIONS(279),
    [anon_sym_Text] = ACTIONS(279),
    [anon_sym_Date] = ACTIONS(279),
    [anon_sym_Time] = ACTIONS(279),
    [anon_sym_TimeZone] = ACTIONS(279),
    [anon_sym_List] = ACTIONS(279),
    [anon_sym_Type] = ACTIONS(279),
    [anon_sym_Kind] = ACTIONS(279),
    [anon_sym_Sort] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(281),
    [anon_sym_RPAREN] = ACTIONS(281),
    [anon_sym_2] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_QMARK] = ACTIONS(281),
    [anon_sym_LBRACK] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(281),
    [anon_sym_RBRACK] = ACTIONS(281),
    [anon_sym_4] = ACTIONS(281),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(281),
    [anon_sym_PIPE_PIPE] = ACTIONS(281),
    [anon_sym_PLUS] = ACTIONS(279),
    [anon_sym_PLUS_PLUS] = ACTIONS(281),
    [anon_sym_POUND] = ACTIONS(281),
    [anon_sym_AMP_AMP] = ACTIONS(281),
    [anon_sym_5] = ACTIONS(281),
    [anon_sym_SLASH_BSLASH] = ACTIONS(281),
    [anon_sym_6] = ACTIONS(281),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_7] = ACTIONS(281),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(281),
    [anon_sym_STAR] = ACTIONS(281),
    [anon_sym_EQ_EQ] = ACTIONS(279),
    [anon_sym_BANG_EQ] = ACTIONS(281),
    [anon_sym_COLON_COLON] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(279),
    [anon_sym_RBRACE] = ACTIONS(281),
    [sym_import_hash] = ACTIONS(281),
    [sym_local_import] = ACTIONS(281),
    [sym_http_raw] = ACTIONS(281),
    [aux_sym_env_import_token1] = ACTIONS(281),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(281),
    [anon_sym_DASHInfinity] = ACTIONS(281),
    [aux_sym_double_literal_token1] = ACTIONS(281),
    [sym_natural_literal] = ACTIONS(279),
    [sym_integer_literal] = ACTIONS(279),
    [anon_sym_DQUOTE] = ACTIONS(281),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(281),
    [anon_sym_LT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_GT] = ACTIONS(281),
    [anon_sym_True] = ACTIONS(279),
    [anon_sym_False] = ACTIONS(279),
  },
  [145] = {
    [sym_line_comment] = STATE(145),
    [sym_block_comment] = STATE(145),
    [sym_label] = ACTIONS(370),
    [anon_sym_COLON] = ACTIONS(370),
    [anon_sym_then] = ACTIONS(370),
    [anon_sym_else] = ACTIONS(370),
    [anon_sym_let] = ACTIONS(370),
    [anon_sym_in] = ACTIONS(370),
    [anon_sym_as] = ACTIONS(370),
    [anon_sym_missing] = ACTIONS(370),
    [anon_sym_Infinity] = ACTIONS(370),
    [anon_sym_NaN] = ACTIONS(370),
    [anon_sym_with] = ACTIONS(370),
    [anon_sym_Natural_SLASHfold] = ACTIONS(370),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(370),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(370),
    [anon_sym_Natural_SLASHeven] = ACTIONS(370),
    [anon_sym_Natural_SLASHodd] = ACTIONS(370),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(370),
    [anon_sym_Natural_SLASHshow] = ACTIONS(370),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(370),
    [anon_sym_Integer_SLASHshow] = ACTIONS(370),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(370),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(370),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(370),
    [anon_sym_Double_SLASHshow] = ACTIONS(370),
    [anon_sym_List_SLASHbuild] = ACTIONS(370),
    [anon_sym_List_SLASHfold] = ACTIONS(370),
    [anon_sym_List_SLASHlength] = ACTIONS(370),
    [anon_sym_List_SLASHhead] = ACTIONS(370),
    [anon_sym_List_SLASHlast] = ACTIONS(370),
    [anon_sym_List_SLASHindexed] = ACTIONS(370),
    [anon_sym_List_SLASHreverse] = ACTIONS(370),
    [anon_sym_Text_SLASHshow] = ACTIONS(370),
    [anon_sym_Text_SLASHreplace] = ACTIONS(370),
    [anon_sym_Bool] = ACTIONS(370),
    [anon_sym_Optional] = ACTIONS(370),
    [anon_sym_None] = ACTIONS(370),
    [anon_sym_Natural] = ACTIONS(370),
    [anon_sym_Integer] = ACTIONS(370),
    [anon_sym_Double] = ACTIONS(370),
    [anon_sym_Text] = ACTIONS(370),
    [anon_sym_Date] = ACTIONS(370),
    [anon_sym_Time] = ACTIONS(370),
    [anon_sym_TimeZone] = ACTIONS(370),
    [anon_sym_List] = ACTIONS(370),
    [anon_sym_Type] = ACTIONS(370),
    [anon_sym_Kind] = ACTIONS(370),
    [anon_sym_Sort] = ACTIONS(370),
    [anon_sym_LPAREN] = ACTIONS(372),
    [anon_sym_RPAREN] = ACTIONS(372),
    [anon_sym_2] = ACTIONS(372),
    [anon_sym_DASH_GT] = ACTIONS(372),
    [anon_sym_EQ] = ACTIONS(370),
    [anon_sym_DOT] = ACTIONS(370),
    [anon_sym_QMARK] = ACTIONS(372),
    [anon_sym_LBRACK] = ACTIONS(372),
    [anon_sym_COMMA] = ACTIONS(372),
    [anon_sym_RBRACK] = ACTIONS(372),
    [anon_sym_4] = ACTIONS(372),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(372),
    [anon_sym_PIPE_PIPE] = ACTIONS(372),
    [anon_sym_PLUS] = ACTIONS(370),
    [anon_sym_PLUS_PLUS] = ACTIONS(372),
    [anon_sym_POUND] = ACTIONS(372),
    [anon_sym_AMP_AMP] = ACTIONS(372),
    [anon_sym_5] = ACTIONS(372),
    [anon_sym_SLASH_BSLASH] = ACTIONS(372),
    [anon_sym_6] = ACTIONS(372),
    [anon_sym_SLASH_SLASH] = ACTIONS(370),
    [anon_sym_7] = ACTIONS(372),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(372),
    [anon_sym_STAR] = ACTIONS(372),
    [anon_sym_EQ_EQ] = ACTIONS(370),
    [anon_sym_BANG_EQ] = ACTIONS(372),
    [anon_sym_COLON_COLON] = ACTIONS(372),
    [anon_sym_LBRACE] = ACTIONS(370),
    [anon_sym_RBRACE] = ACTIONS(372),
    [sym_import_hash] = ACTIONS(372),
    [sym_local_import] = ACTIONS(372),
    [sym_http_raw] = ACTIONS(372),
    [aux_sym_env_import_token1] = ACTIONS(372),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(372),
    [anon_sym_DASHInfinity] = ACTIONS(372),
    [aux_sym_double_literal_token1] = ACTIONS(372),
    [sym_natural_literal] = ACTIONS(370),
    [sym_integer_literal] = ACTIONS(370),
    [anon_sym_DQUOTE] = ACTIONS(372),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(372),
    [anon_sym_LT] = ACTIONS(372),
    [anon_sym_PIPE] = ACTIONS(370),
    [anon_sym_GT] = ACTIONS(372),
    [anon_sym_True] = ACTIONS(370),
    [anon_sym_False] = ACTIONS(370),
  },
  [146] = {
    [sym_line_comment] = STATE(146),
    [sym_block_comment] = STATE(146),
    [sym_label] = ACTIONS(374),
    [anon_sym_COLON] = ACTIONS(374),
    [anon_sym_then] = ACTIONS(374),
    [anon_sym_else] = ACTIONS(374),
    [anon_sym_let] = ACTIONS(374),
    [anon_sym_in] = ACTIONS(374),
    [anon_sym_as] = ACTIONS(374),
    [anon_sym_missing] = ACTIONS(374),
    [anon_sym_Infinity] = ACTIONS(374),
    [anon_sym_NaN] = ACTIONS(374),
    [anon_sym_with] = ACTIONS(374),
    [anon_sym_Natural_SLASHfold] = ACTIONS(374),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(374),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(374),
    [anon_sym_Natural_SLASHeven] = ACTIONS(374),
    [anon_sym_Natural_SLASHodd] = ACTIONS(374),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(374),
    [anon_sym_Natural_SLASHshow] = ACTIONS(374),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(374),
    [anon_sym_Integer_SLASHshow] = ACTIONS(374),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(374),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(374),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(374),
    [anon_sym_Double_SLASHshow] = ACTIONS(374),
    [anon_sym_List_SLASHbuild] = ACTIONS(374),
    [anon_sym_List_SLASHfold] = ACTIONS(374),
    [anon_sym_List_SLASHlength] = ACTIONS(374),
    [anon_sym_List_SLASHhead] = ACTIONS(374),
    [anon_sym_List_SLASHlast] = ACTIONS(374),
    [anon_sym_List_SLASHindexed] = ACTIONS(374),
    [anon_sym_List_SLASHreverse] = ACTIONS(374),
    [anon_sym_Text_SLASHshow] = ACTIONS(374),
    [anon_sym_Text_SLASHreplace] = ACTIONS(374),
    [anon_sym_Bool] = ACTIONS(374),
    [anon_sym_Optional] = ACTIONS(374),
    [anon_sym_None] = ACTIONS(374),
    [anon_sym_Natural] = ACTIONS(374),
    [anon_sym_Integer] = ACTIONS(374),
    [anon_sym_Double] = ACTIONS(374),
    [anon_sym_Text] = ACTIONS(374),
    [anon_sym_Date] = ACTIONS(374),
    [anon_sym_Time] = ACTIONS(374),
    [anon_sym_TimeZone] = ACTIONS(374),
    [anon_sym_List] = ACTIONS(374),
    [anon_sym_Type] = ACTIONS(374),
    [anon_sym_Kind] = ACTIONS(374),
    [anon_sym_Sort] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(376),
    [anon_sym_RPAREN] = ACTIONS(376),
    [anon_sym_2] = ACTIONS(376),
    [anon_sym_DASH_GT] = ACTIONS(376),
    [anon_sym_EQ] = ACTIONS(374),
    [anon_sym_DOT] = ACTIONS(374),
    [anon_sym_QMARK] = ACTIONS(376),
    [anon_sym_LBRACK] = ACTIONS(376),
    [anon_sym_COMMA] = ACTIONS(376),
    [anon_sym_RBRACK] = ACTIONS(376),
    [anon_sym_4] = ACTIONS(376),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(376),
    [anon_sym_PIPE_PIPE] = ACTIONS(376),
    [anon_sym_PLUS] = ACTIONS(374),
    [anon_sym_PLUS_PLUS] = ACTIONS(376),
    [anon_sym_POUND] = ACTIONS(376),
    [anon_sym_AMP_AMP] = ACTIONS(376),
    [anon_sym_5] = ACTIONS(376),
    [anon_sym_SLASH_BSLASH] = ACTIONS(376),
    [anon_sym_6] = ACTIONS(376),
    [anon_sym_SLASH_SLASH] = ACTIONS(374),
    [anon_sym_7] = ACTIONS(376),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(376),
    [anon_sym_STAR] = ACTIONS(376),
    [anon_sym_EQ_EQ] = ACTIONS(374),
    [anon_sym_BANG_EQ] = ACTIONS(376),
    [anon_sym_COLON_COLON] = ACTIONS(376),
    [anon_sym_LBRACE] = ACTIONS(374),
    [anon_sym_RBRACE] = ACTIONS(376),
    [sym_import_hash] = ACTIONS(376),
    [sym_local_import] = ACTIONS(376),
    [sym_http_raw] = ACTIONS(376),
    [aux_sym_env_import_token1] = ACTIONS(376),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(376),
    [anon_sym_DASHInfinity] = ACTIONS(376),
    [aux_sym_double_literal_token1] = ACTIONS(376),
    [sym_natural_literal] = ACTIONS(374),
    [sym_integer_literal] = ACTIONS(374),
    [anon_sym_DQUOTE] = ACTIONS(376),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(376),
    [anon_sym_LT] = ACTIONS(376),
    [anon_sym_PIPE] = ACTIONS(374),
    [anon_sym_GT] = ACTIONS(376),
    [anon_sym_True] = ACTIONS(374),
    [anon_sym_False] = ACTIONS(374),
  },
  [147] = {
    [sym_line_comment] = STATE(147),
    [sym_block_comment] = STATE(147),
    [sym_label] = ACTIONS(378),
    [anon_sym_COLON] = ACTIONS(378),
    [anon_sym_then] = ACTIONS(378),
    [anon_sym_else] = ACTIONS(378),
    [anon_sym_let] = ACTIONS(378),
    [anon_sym_in] = ACTIONS(378),
    [anon_sym_as] = ACTIONS(378),
    [anon_sym_missing] = ACTIONS(378),
    [anon_sym_Infinity] = ACTIONS(378),
    [anon_sym_NaN] = ACTIONS(378),
    [anon_sym_with] = ACTIONS(378),
    [anon_sym_Natural_SLASHfold] = ACTIONS(378),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(378),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(378),
    [anon_sym_Natural_SLASHeven] = ACTIONS(378),
    [anon_sym_Natural_SLASHodd] = ACTIONS(378),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(378),
    [anon_sym_Natural_SLASHshow] = ACTIONS(378),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(378),
    [anon_sym_Integer_SLASHshow] = ACTIONS(378),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(378),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(378),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(378),
    [anon_sym_Double_SLASHshow] = ACTIONS(378),
    [anon_sym_List_SLASHbuild] = ACTIONS(378),
    [anon_sym_List_SLASHfold] = ACTIONS(378),
    [anon_sym_List_SLASHlength] = ACTIONS(378),
    [anon_sym_List_SLASHhead] = ACTIONS(378),
    [anon_sym_List_SLASHlast] = ACTIONS(378),
    [anon_sym_List_SLASHindexed] = ACTIONS(378),
    [anon_sym_List_SLASHreverse] = ACTIONS(378),
    [anon_sym_Text_SLASHshow] = ACTIONS(378),
    [anon_sym_Text_SLASHreplace] = ACTIONS(378),
    [anon_sym_Bool] = ACTIONS(378),
    [anon_sym_Optional] = ACTIONS(378),
    [anon_sym_None] = ACTIONS(378),
    [anon_sym_Natural] = ACTIONS(378),
    [anon_sym_Integer] = ACTIONS(378),
    [anon_sym_Double] = ACTIONS(378),
    [anon_sym_Text] = ACTIONS(378),
    [anon_sym_Date] = ACTIONS(378),
    [anon_sym_Time] = ACTIONS(378),
    [anon_sym_TimeZone] = ACTIONS(378),
    [anon_sym_List] = ACTIONS(378),
    [anon_sym_Type] = ACTIONS(378),
    [anon_sym_Kind] = ACTIONS(378),
    [anon_sym_Sort] = ACTIONS(378),
    [anon_sym_LPAREN] = ACTIONS(380),
    [anon_sym_RPAREN] = ACTIONS(380),
    [anon_sym_2] = ACTIONS(380),
    [anon_sym_DASH_GT] = ACTIONS(380),
    [anon_sym_EQ] = ACTIONS(378),
    [anon_sym_DOT] = ACTIONS(378),
    [anon_sym_QMARK] = ACTIONS(380),
    [anon_sym_LBRACK] = ACTIONS(380),
    [anon_sym_COMMA] = ACTIONS(380),
    [anon_sym_RBRACK] = ACTIONS(380),
    [anon_sym_4] = ACTIONS(380),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(380),
    [anon_sym_PIPE_PIPE] = ACTIONS(380),
    [anon_sym_PLUS] = ACTIONS(378),
    [anon_sym_PLUS_PLUS] = ACTIONS(380),
    [anon_sym_POUND] = ACTIONS(380),
    [anon_sym_AMP_AMP] = ACTIONS(380),
    [anon_sym_5] = ACTIONS(380),
    [anon_sym_SLASH_BSLASH] = ACTIONS(380),
    [anon_sym_6] = ACTIONS(380),
    [anon_sym_SLASH_SLASH] = ACTIONS(378),
    [anon_sym_7] = ACTIONS(380),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(380),
    [anon_sym_STAR] = ACTIONS(380),
    [anon_sym_EQ_EQ] = ACTIONS(378),
    [anon_sym_BANG_EQ] = ACTIONS(380),
    [anon_sym_COLON_COLON] = ACTIONS(380),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(380),
    [sym_import_hash] = ACTIONS(380),
    [sym_local_import] = ACTIONS(380),
    [sym_http_raw] = ACTIONS(380),
    [aux_sym_env_import_token1] = ACTIONS(380),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(380),
    [anon_sym_DASHInfinity] = ACTIONS(380),
    [aux_sym_double_literal_token1] = ACTIONS(380),
    [sym_natural_literal] = ACTIONS(378),
    [sym_integer_literal] = ACTIONS(378),
    [anon_sym_DQUOTE] = ACTIONS(380),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(380),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_PIPE] = ACTIONS(378),
    [anon_sym_GT] = ACTIONS(380),
    [anon_sym_True] = ACTIONS(378),
    [anon_sym_False] = ACTIONS(378),
  },
  [148] = {
    [sym_line_comment] = STATE(148),
    [sym_block_comment] = STATE(148),
    [sym_label] = ACTIONS(382),
    [anon_sym_COLON] = ACTIONS(382),
    [anon_sym_then] = ACTIONS(382),
    [anon_sym_else] = ACTIONS(382),
    [anon_sym_let] = ACTIONS(382),
    [anon_sym_in] = ACTIONS(382),
    [anon_sym_as] = ACTIONS(382),
    [anon_sym_missing] = ACTIONS(382),
    [anon_sym_Infinity] = ACTIONS(382),
    [anon_sym_NaN] = ACTIONS(382),
    [anon_sym_with] = ACTIONS(382),
    [anon_sym_Natural_SLASHfold] = ACTIONS(382),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(382),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(382),
    [anon_sym_Natural_SLASHeven] = ACTIONS(382),
    [anon_sym_Natural_SLASHodd] = ACTIONS(382),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(382),
    [anon_sym_Natural_SLASHshow] = ACTIONS(382),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(382),
    [anon_sym_Integer_SLASHshow] = ACTIONS(382),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(382),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(382),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(382),
    [anon_sym_Double_SLASHshow] = ACTIONS(382),
    [anon_sym_List_SLASHbuild] = ACTIONS(382),
    [anon_sym_List_SLASHfold] = ACTIONS(382),
    [anon_sym_List_SLASHlength] = ACTIONS(382),
    [anon_sym_List_SLASHhead] = ACTIONS(382),
    [anon_sym_List_SLASHlast] = ACTIONS(382),
    [anon_sym_List_SLASHindexed] = ACTIONS(382),
    [anon_sym_List_SLASHreverse] = ACTIONS(382),
    [anon_sym_Text_SLASHshow] = ACTIONS(382),
    [anon_sym_Text_SLASHreplace] = ACTIONS(382),
    [anon_sym_Bool] = ACTIONS(382),
    [anon_sym_Optional] = ACTIONS(382),
    [anon_sym_None] = ACTIONS(382),
    [anon_sym_Natural] = ACTIONS(382),
    [anon_sym_Integer] = ACTIONS(382),
    [anon_sym_Double] = ACTIONS(382),
    [anon_sym_Text] = ACTIONS(382),
    [anon_sym_Date] = ACTIONS(382),
    [anon_sym_Time] = ACTIONS(382),
    [anon_sym_TimeZone] = ACTIONS(382),
    [anon_sym_List] = ACTIONS(382),
    [anon_sym_Type] = ACTIONS(382),
    [anon_sym_Kind] = ACTIONS(382),
    [anon_sym_Sort] = ACTIONS(382),
    [anon_sym_LPAREN] = ACTIONS(384),
    [anon_sym_RPAREN] = ACTIONS(384),
    [anon_sym_2] = ACTIONS(384),
    [anon_sym_DASH_GT] = ACTIONS(384),
    [anon_sym_EQ] = ACTIONS(382),
    [anon_sym_DOT] = ACTIONS(382),
    [anon_sym_QMARK] = ACTIONS(384),
    [anon_sym_LBRACK] = ACTIONS(384),
    [anon_sym_COMMA] = ACTIONS(384),
    [anon_sym_RBRACK] = ACTIONS(384),
    [anon_sym_4] = ACTIONS(384),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(384),
    [anon_sym_PIPE_PIPE] = ACTIONS(384),
    [anon_sym_PLUS] = ACTIONS(382),
    [anon_sym_PLUS_PLUS] = ACTIONS(384),
    [anon_sym_POUND] = ACTIONS(384),
    [anon_sym_AMP_AMP] = ACTIONS(384),
    [anon_sym_5] = ACTIONS(384),
    [anon_sym_SLASH_BSLASH] = ACTIONS(384),
    [anon_sym_6] = ACTIONS(384),
    [anon_sym_SLASH_SLASH] = ACTIONS(382),
    [anon_sym_7] = ACTIONS(384),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(384),
    [anon_sym_STAR] = ACTIONS(384),
    [anon_sym_EQ_EQ] = ACTIONS(382),
    [anon_sym_BANG_EQ] = ACTIONS(384),
    [anon_sym_COLON_COLON] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(382),
    [anon_sym_RBRACE] = ACTIONS(384),
    [sym_import_hash] = ACTIONS(384),
    [sym_local_import] = ACTIONS(384),
    [sym_http_raw] = ACTIONS(384),
    [aux_sym_env_import_token1] = ACTIONS(384),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(384),
    [anon_sym_DASHInfinity] = ACTIONS(384),
    [aux_sym_double_literal_token1] = ACTIONS(384),
    [sym_natural_literal] = ACTIONS(382),
    [sym_integer_literal] = ACTIONS(382),
    [anon_sym_DQUOTE] = ACTIONS(384),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(384),
    [anon_sym_LT] = ACTIONS(384),
    [anon_sym_PIPE] = ACTIONS(382),
    [anon_sym_GT] = ACTIONS(384),
    [anon_sym_True] = ACTIONS(382),
    [anon_sym_False] = ACTIONS(382),
  },
  [149] = {
    [sym_line_comment] = STATE(149),
    [sym_block_comment] = STATE(149),
    [sym_label] = ACTIONS(386),
    [anon_sym_COLON] = ACTIONS(386),
    [anon_sym_then] = ACTIONS(386),
    [anon_sym_else] = ACTIONS(386),
    [anon_sym_let] = ACTIONS(386),
    [anon_sym_in] = ACTIONS(386),
    [anon_sym_as] = ACTIONS(386),
    [anon_sym_missing] = ACTIONS(386),
    [anon_sym_Infinity] = ACTIONS(386),
    [anon_sym_NaN] = ACTIONS(386),
    [anon_sym_with] = ACTIONS(386),
    [anon_sym_Natural_SLASHfold] = ACTIONS(386),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(386),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(386),
    [anon_sym_Natural_SLASHeven] = ACTIONS(386),
    [anon_sym_Natural_SLASHodd] = ACTIONS(386),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(386),
    [anon_sym_Natural_SLASHshow] = ACTIONS(386),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(386),
    [anon_sym_Integer_SLASHshow] = ACTIONS(386),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(386),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(386),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(386),
    [anon_sym_Double_SLASHshow] = ACTIONS(386),
    [anon_sym_List_SLASHbuild] = ACTIONS(386),
    [anon_sym_List_SLASHfold] = ACTIONS(386),
    [anon_sym_List_SLASHlength] = ACTIONS(386),
    [anon_sym_List_SLASHhead] = ACTIONS(386),
    [anon_sym_List_SLASHlast] = ACTIONS(386),
    [anon_sym_List_SLASHindexed] = ACTIONS(386),
    [anon_sym_List_SLASHreverse] = ACTIONS(386),
    [anon_sym_Text_SLASHshow] = ACTIONS(386),
    [anon_sym_Text_SLASHreplace] = ACTIONS(386),
    [anon_sym_Bool] = ACTIONS(386),
    [anon_sym_Optional] = ACTIONS(386),
    [anon_sym_None] = ACTIONS(386),
    [anon_sym_Natural] = ACTIONS(386),
    [anon_sym_Integer] = ACTIONS(386),
    [anon_sym_Double] = ACTIONS(386),
    [anon_sym_Text] = ACTIONS(386),
    [anon_sym_Date] = ACTIONS(386),
    [anon_sym_Time] = ACTIONS(386),
    [anon_sym_TimeZone] = ACTIONS(386),
    [anon_sym_List] = ACTIONS(386),
    [anon_sym_Type] = ACTIONS(386),
    [anon_sym_Kind] = ACTIONS(386),
    [anon_sym_Sort] = ACTIONS(386),
    [anon_sym_LPAREN] = ACTIONS(388),
    [anon_sym_RPAREN] = ACTIONS(388),
    [anon_sym_2] = ACTIONS(388),
    [anon_sym_DASH_GT] = ACTIONS(388),
    [anon_sym_EQ] = ACTIONS(386),
    [anon_sym_DOT] = ACTIONS(386),
    [anon_sym_QMARK] = ACTIONS(388),
    [anon_sym_LBRACK] = ACTIONS(388),
    [anon_sym_COMMA] = ACTIONS(388),
    [anon_sym_RBRACK] = ACTIONS(388),
    [anon_sym_4] = ACTIONS(388),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(388),
    [anon_sym_PIPE_PIPE] = ACTIONS(388),
    [anon_sym_PLUS] = ACTIONS(386),
    [anon_sym_PLUS_PLUS] = ACTIONS(388),
    [anon_sym_POUND] = ACTIONS(388),
    [anon_sym_AMP_AMP] = ACTIONS(388),
    [anon_sym_5] = ACTIONS(388),
    [anon_sym_SLASH_BSLASH] = ACTIONS(388),
    [anon_sym_6] = ACTIONS(388),
    [anon_sym_SLASH_SLASH] = ACTIONS(386),
    [anon_sym_7] = ACTIONS(388),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(388),
    [anon_sym_STAR] = ACTIONS(388),
    [anon_sym_EQ_EQ] = ACTIONS(386),
    [anon_sym_BANG_EQ] = ACTIONS(388),
    [anon_sym_COLON_COLON] = ACTIONS(388),
    [anon_sym_LBRACE] = ACTIONS(386),
    [anon_sym_RBRACE] = ACTIONS(388),
    [sym_import_hash] = ACTIONS(388),
    [sym_local_import] = ACTIONS(388),
    [sym_http_raw] = ACTIONS(388),
    [aux_sym_env_import_token1] = ACTIONS(388),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(388),
    [anon_sym_DASHInfinity] = ACTIONS(388),
    [aux_sym_double_literal_token1] = ACTIONS(388),
    [sym_natural_literal] = ACTIONS(386),
    [sym_integer_literal] = ACTIONS(386),
    [anon_sym_DQUOTE] = ACTIONS(388),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(388),
    [anon_sym_LT] = ACTIONS(388),
    [anon_sym_PIPE] = ACTIONS(386),
    [anon_sym_GT] = ACTIONS(388),
    [anon_sym_True] = ACTIONS(386),
    [anon_sym_False] = ACTIONS(386),
  },
  [150] = {
    [sym_selector] = STATE(230),
    [sym_line_comment] = STATE(150),
    [sym_block_comment] = STATE(150),
    [aux_sym_selector_repeat1] = STATE(167),
    [sym_label] = ACTIONS(275),
    [anon_sym_COLON] = ACTIONS(275),
    [anon_sym_then] = ACTIONS(275),
    [anon_sym_else] = ACTIONS(275),
    [anon_sym_let] = ACTIONS(275),
    [anon_sym_in] = ACTIONS(275),
    [anon_sym_missing] = ACTIONS(275),
    [anon_sym_Infinity] = ACTIONS(275),
    [anon_sym_NaN] = ACTIONS(275),
    [anon_sym_with] = ACTIONS(275),
    [anon_sym_Natural_SLASHfold] = ACTIONS(275),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(275),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(275),
    [anon_sym_Natural_SLASHeven] = ACTIONS(275),
    [anon_sym_Natural_SLASHodd] = ACTIONS(275),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(275),
    [anon_sym_Natural_SLASHshow] = ACTIONS(275),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(275),
    [anon_sym_Integer_SLASHshow] = ACTIONS(275),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(275),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(275),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(275),
    [anon_sym_Double_SLASHshow] = ACTIONS(275),
    [anon_sym_List_SLASHbuild] = ACTIONS(275),
    [anon_sym_List_SLASHfold] = ACTIONS(275),
    [anon_sym_List_SLASHlength] = ACTIONS(275),
    [anon_sym_List_SLASHhead] = ACTIONS(275),
    [anon_sym_List_SLASHlast] = ACTIONS(275),
    [anon_sym_List_SLASHindexed] = ACTIONS(275),
    [anon_sym_List_SLASHreverse] = ACTIONS(275),
    [anon_sym_Text_SLASHshow] = ACTIONS(275),
    [anon_sym_Text_SLASHreplace] = ACTIONS(275),
    [anon_sym_Bool] = ACTIONS(275),
    [anon_sym_Optional] = ACTIONS(275),
    [anon_sym_None] = ACTIONS(275),
    [anon_sym_Natural] = ACTIONS(275),
    [anon_sym_Integer] = ACTIONS(275),
    [anon_sym_Double] = ACTIONS(275),
    [anon_sym_Text] = ACTIONS(275),
    [anon_sym_Date] = ACTIONS(275),
    [anon_sym_Time] = ACTIONS(275),
    [anon_sym_TimeZone] = ACTIONS(275),
    [anon_sym_List] = ACTIONS(275),
    [anon_sym_Type] = ACTIONS(275),
    [anon_sym_Kind] = ACTIONS(275),
    [anon_sym_Sort] = ACTIONS(275),
    [anon_sym_LPAREN] = ACTIONS(277),
    [anon_sym_RPAREN] = ACTIONS(277),
    [anon_sym_2] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(277),
    [anon_sym_EQ] = ACTIONS(275),
    [anon_sym_DOT] = ACTIONS(390),
    [anon_sym_QMARK] = ACTIONS(277),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_RBRACK] = ACTIONS(277),
    [anon_sym_4] = ACTIONS(277),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(277),
    [anon_sym_PIPE_PIPE] = ACTIONS(277),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_PLUS_PLUS] = ACTIONS(277),
    [anon_sym_POUND] = ACTIONS(277),
    [anon_sym_AMP_AMP] = ACTIONS(277),
    [anon_sym_5] = ACTIONS(277),
    [anon_sym_SLASH_BSLASH] = ACTIONS(277),
    [anon_sym_6] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(275),
    [anon_sym_7] = ACTIONS(277),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(277),
    [anon_sym_STAR] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(275),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_COLON_COLON] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(275),
    [anon_sym_RBRACE] = ACTIONS(277),
    [sym_local_import] = ACTIONS(277),
    [sym_http_raw] = ACTIONS(277),
    [aux_sym_env_import_token1] = ACTIONS(277),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(277),
    [anon_sym_DASHInfinity] = ACTIONS(277),
    [aux_sym_double_literal_token1] = ACTIONS(277),
    [sym_natural_literal] = ACTIONS(275),
    [sym_integer_literal] = ACTIONS(275),
    [anon_sym_DQUOTE] = ACTIONS(277),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(277),
    [anon_sym_LT] = ACTIONS(277),
    [anon_sym_PIPE] = ACTIONS(275),
    [anon_sym_GT] = ACTIONS(277),
    [anon_sym_True] = ACTIONS(275),
    [anon_sym_False] = ACTIONS(275),
  },
  [151] = {
    [sym_line_comment] = STATE(151),
    [sym_block_comment] = STATE(151),
    [sym_de_bruijn_index] = STATE(180),
    [sym_label] = ACTIONS(263),
    [anon_sym_COLON] = ACTIONS(263),
    [anon_sym_then] = ACTIONS(263),
    [anon_sym_else] = ACTIONS(263),
    [anon_sym_let] = ACTIONS(263),
    [anon_sym_in] = ACTIONS(263),
    [anon_sym_missing] = ACTIONS(263),
    [anon_sym_Infinity] = ACTIONS(263),
    [anon_sym_NaN] = ACTIONS(263),
    [anon_sym_with] = ACTIONS(263),
    [anon_sym_Natural_SLASHfold] = ACTIONS(263),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(263),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(263),
    [anon_sym_Natural_SLASHeven] = ACTIONS(263),
    [anon_sym_Natural_SLASHodd] = ACTIONS(263),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(263),
    [anon_sym_Natural_SLASHshow] = ACTIONS(263),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(263),
    [anon_sym_Integer_SLASHshow] = ACTIONS(263),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(263),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(263),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(263),
    [anon_sym_Double_SLASHshow] = ACTIONS(263),
    [anon_sym_List_SLASHbuild] = ACTIONS(263),
    [anon_sym_List_SLASHfold] = ACTIONS(263),
    [anon_sym_List_SLASHlength] = ACTIONS(263),
    [anon_sym_List_SLASHhead] = ACTIONS(263),
    [anon_sym_List_SLASHlast] = ACTIONS(263),
    [anon_sym_List_SLASHindexed] = ACTIONS(263),
    [anon_sym_List_SLASHreverse] = ACTIONS(263),
    [anon_sym_Text_SLASHshow] = ACTIONS(263),
    [anon_sym_Text_SLASHreplace] = ACTIONS(263),
    [anon_sym_Bool] = ACTIONS(263),
    [anon_sym_Optional] = ACTIONS(263),
    [anon_sym_None] = ACTIONS(263),
    [anon_sym_Natural] = ACTIONS(263),
    [anon_sym_Integer] = ACTIONS(263),
    [anon_sym_Double] = ACTIONS(263),
    [anon_sym_Text] = ACTIONS(263),
    [anon_sym_Date] = ACTIONS(263),
    [anon_sym_Time] = ACTIONS(263),
    [anon_sym_TimeZone] = ACTIONS(263),
    [anon_sym_List] = ACTIONS(263),
    [anon_sym_Type] = ACTIONS(263),
    [anon_sym_Kind] = ACTIONS(263),
    [anon_sym_Sort] = ACTIONS(263),
    [anon_sym_LPAREN] = ACTIONS(265),
    [anon_sym_RPAREN] = ACTIONS(265),
    [anon_sym_2] = ACTIONS(265),
    [anon_sym_DASH_GT] = ACTIONS(265),
    [anon_sym_EQ] = ACTIONS(263),
    [anon_sym_DOT] = ACTIONS(263),
    [anon_sym_QMARK] = ACTIONS(265),
    [anon_sym_LBRACK] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_RBRACK] = ACTIONS(265),
    [anon_sym_4] = ACTIONS(265),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(265),
    [anon_sym_PIPE_PIPE] = ACTIONS(265),
    [anon_sym_PLUS] = ACTIONS(263),
    [anon_sym_PLUS_PLUS] = ACTIONS(265),
    [anon_sym_POUND] = ACTIONS(265),
    [anon_sym_AMP_AMP] = ACTIONS(265),
    [anon_sym_5] = ACTIONS(265),
    [anon_sym_SLASH_BSLASH] = ACTIONS(265),
    [anon_sym_6] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(263),
    [anon_sym_7] = ACTIONS(265),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(265),
    [anon_sym_STAR] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(263),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_COLON_COLON] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(263),
    [anon_sym_RBRACE] = ACTIONS(265),
    [sym_local_import] = ACTIONS(265),
    [sym_http_raw] = ACTIONS(265),
    [aux_sym_env_import_token1] = ACTIONS(265),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(265),
    [anon_sym_DASHInfinity] = ACTIONS(265),
    [aux_sym_double_literal_token1] = ACTIONS(265),
    [sym_natural_literal] = ACTIONS(263),
    [sym_integer_literal] = ACTIONS(263),
    [anon_sym_DQUOTE] = ACTIONS(265),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(265),
    [anon_sym_LT] = ACTIONS(265),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(265),
    [anon_sym_True] = ACTIONS(263),
    [anon_sym_False] = ACTIONS(263),
    [anon_sym_AT] = ACTIONS(392),
  },
  [152] = {
    [sym_line_comment] = STATE(152),
    [sym_block_comment] = STATE(152),
    [sym_label] = ACTIONS(394),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_then] = ACTIONS(394),
    [anon_sym_else] = ACTIONS(394),
    [anon_sym_let] = ACTIONS(394),
    [anon_sym_in] = ACTIONS(394),
    [anon_sym_as] = ACTIONS(394),
    [anon_sym_missing] = ACTIONS(394),
    [anon_sym_Infinity] = ACTIONS(394),
    [anon_sym_NaN] = ACTIONS(394),
    [anon_sym_with] = ACTIONS(394),
    [anon_sym_Natural_SLASHfold] = ACTIONS(394),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(394),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(394),
    [anon_sym_Natural_SLASHeven] = ACTIONS(394),
    [anon_sym_Natural_SLASHodd] = ACTIONS(394),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(394),
    [anon_sym_Natural_SLASHshow] = ACTIONS(394),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(394),
    [anon_sym_Integer_SLASHshow] = ACTIONS(394),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(394),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(394),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(394),
    [anon_sym_Double_SLASHshow] = ACTIONS(394),
    [anon_sym_List_SLASHbuild] = ACTIONS(394),
    [anon_sym_List_SLASHfold] = ACTIONS(394),
    [anon_sym_List_SLASHlength] = ACTIONS(394),
    [anon_sym_List_SLASHhead] = ACTIONS(394),
    [anon_sym_List_SLASHlast] = ACTIONS(394),
    [anon_sym_List_SLASHindexed] = ACTIONS(394),
    [anon_sym_List_SLASHreverse] = ACTIONS(394),
    [anon_sym_Text_SLASHshow] = ACTIONS(394),
    [anon_sym_Text_SLASHreplace] = ACTIONS(394),
    [anon_sym_Bool] = ACTIONS(394),
    [anon_sym_Optional] = ACTIONS(394),
    [anon_sym_None] = ACTIONS(394),
    [anon_sym_Natural] = ACTIONS(394),
    [anon_sym_Integer] = ACTIONS(394),
    [anon_sym_Double] = ACTIONS(394),
    [anon_sym_Text] = ACTIONS(394),
    [anon_sym_Date] = ACTIONS(394),
    [anon_sym_Time] = ACTIONS(394),
    [anon_sym_TimeZone] = ACTIONS(394),
    [anon_sym_List] = ACTIONS(394),
    [anon_sym_Type] = ACTIONS(394),
    [anon_sym_Kind] = ACTIONS(394),
    [anon_sym_Sort] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_RPAREN] = ACTIONS(396),
    [anon_sym_2] = ACTIONS(396),
    [anon_sym_DASH_GT] = ACTIONS(396),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_QMARK] = ACTIONS(396),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_COMMA] = ACTIONS(396),
    [anon_sym_RBRACK] = ACTIONS(396),
    [anon_sym_4] = ACTIONS(396),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(396),
    [anon_sym_PIPE_PIPE] = ACTIONS(396),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(396),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_AMP_AMP] = ACTIONS(396),
    [anon_sym_5] = ACTIONS(396),
    [anon_sym_SLASH_BSLASH] = ACTIONS(396),
    [anon_sym_6] = ACTIONS(396),
    [anon_sym_SLASH_SLASH] = ACTIONS(394),
    [anon_sym_7] = ACTIONS(396),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(396),
    [anon_sym_STAR] = ACTIONS(396),
    [anon_sym_EQ_EQ] = ACTIONS(394),
    [anon_sym_BANG_EQ] = ACTIONS(396),
    [anon_sym_COLON_COLON] = ACTIONS(396),
    [anon_sym_LBRACE] = ACTIONS(394),
    [anon_sym_RBRACE] = ACTIONS(396),
    [sym_import_hash] = ACTIONS(396),
    [sym_local_import] = ACTIONS(396),
    [sym_http_raw] = ACTIONS(396),
    [aux_sym_env_import_token1] = ACTIONS(396),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(396),
    [anon_sym_DASHInfinity] = ACTIONS(396),
    [aux_sym_double_literal_token1] = ACTIONS(396),
    [sym_natural_literal] = ACTIONS(394),
    [sym_integer_literal] = ACTIONS(394),
    [anon_sym_DQUOTE] = ACTIONS(396),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(396),
    [anon_sym_LT] = ACTIONS(396),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(396),
    [anon_sym_True] = ACTIONS(394),
    [anon_sym_False] = ACTIONS(394),
  },
  [153] = {
    [sym_line_comment] = STATE(153),
    [sym_block_comment] = STATE(153),
    [sym_label] = ACTIONS(398),
    [anon_sym_COLON] = ACTIONS(398),
    [anon_sym_then] = ACTIONS(398),
    [anon_sym_else] = ACTIONS(398),
    [anon_sym_let] = ACTIONS(398),
    [anon_sym_in] = ACTIONS(398),
    [anon_sym_as] = ACTIONS(398),
    [anon_sym_missing] = ACTIONS(398),
    [anon_sym_Infinity] = ACTIONS(398),
    [anon_sym_NaN] = ACTIONS(398),
    [anon_sym_with] = ACTIONS(398),
    [anon_sym_Natural_SLASHfold] = ACTIONS(398),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(398),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(398),
    [anon_sym_Natural_SLASHeven] = ACTIONS(398),
    [anon_sym_Natural_SLASHodd] = ACTIONS(398),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(398),
    [anon_sym_Natural_SLASHshow] = ACTIONS(398),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(398),
    [anon_sym_Integer_SLASHshow] = ACTIONS(398),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(398),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(398),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(398),
    [anon_sym_Double_SLASHshow] = ACTIONS(398),
    [anon_sym_List_SLASHbuild] = ACTIONS(398),
    [anon_sym_List_SLASHfold] = ACTIONS(398),
    [anon_sym_List_SLASHlength] = ACTIONS(398),
    [anon_sym_List_SLASHhead] = ACTIONS(398),
    [anon_sym_List_SLASHlast] = ACTIONS(398),
    [anon_sym_List_SLASHindexed] = ACTIONS(398),
    [anon_sym_List_SLASHreverse] = ACTIONS(398),
    [anon_sym_Text_SLASHshow] = ACTIONS(398),
    [anon_sym_Text_SLASHreplace] = ACTIONS(398),
    [anon_sym_Bool] = ACTIONS(398),
    [anon_sym_Optional] = ACTIONS(398),
    [anon_sym_None] = ACTIONS(398),
    [anon_sym_Natural] = ACTIONS(398),
    [anon_sym_Integer] = ACTIONS(398),
    [anon_sym_Double] = ACTIONS(398),
    [anon_sym_Text] = ACTIONS(398),
    [anon_sym_Date] = ACTIONS(398),
    [anon_sym_Time] = ACTIONS(398),
    [anon_sym_TimeZone] = ACTIONS(398),
    [anon_sym_List] = ACTIONS(398),
    [anon_sym_Type] = ACTIONS(398),
    [anon_sym_Kind] = ACTIONS(398),
    [anon_sym_Sort] = ACTIONS(398),
    [anon_sym_LPAREN] = ACTIONS(400),
    [anon_sym_RPAREN] = ACTIONS(400),
    [anon_sym_2] = ACTIONS(400),
    [anon_sym_DASH_GT] = ACTIONS(400),
    [anon_sym_EQ] = ACTIONS(398),
    [anon_sym_DOT] = ACTIONS(398),
    [anon_sym_QMARK] = ACTIONS(400),
    [anon_sym_LBRACK] = ACTIONS(400),
    [anon_sym_COMMA] = ACTIONS(400),
    [anon_sym_RBRACK] = ACTIONS(400),
    [anon_sym_4] = ACTIONS(400),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(400),
    [anon_sym_PIPE_PIPE] = ACTIONS(400),
    [anon_sym_PLUS] = ACTIONS(398),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_POUND] = ACTIONS(400),
    [anon_sym_AMP_AMP] = ACTIONS(400),
    [anon_sym_5] = ACTIONS(400),
    [anon_sym_SLASH_BSLASH] = ACTIONS(400),
    [anon_sym_6] = ACTIONS(400),
    [anon_sym_SLASH_SLASH] = ACTIONS(398),
    [anon_sym_7] = ACTIONS(400),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(400),
    [anon_sym_STAR] = ACTIONS(400),
    [anon_sym_EQ_EQ] = ACTIONS(398),
    [anon_sym_BANG_EQ] = ACTIONS(400),
    [anon_sym_COLON_COLON] = ACTIONS(400),
    [anon_sym_LBRACE] = ACTIONS(398),
    [anon_sym_RBRACE] = ACTIONS(400),
    [sym_import_hash] = ACTIONS(400),
    [sym_local_import] = ACTIONS(400),
    [sym_http_raw] = ACTIONS(400),
    [aux_sym_env_import_token1] = ACTIONS(400),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(400),
    [anon_sym_DASHInfinity] = ACTIONS(400),
    [aux_sym_double_literal_token1] = ACTIONS(400),
    [sym_natural_literal] = ACTIONS(398),
    [sym_integer_literal] = ACTIONS(398),
    [anon_sym_DQUOTE] = ACTIONS(400),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(400),
    [anon_sym_LT] = ACTIONS(400),
    [anon_sym_PIPE] = ACTIONS(398),
    [anon_sym_GT] = ACTIONS(400),
    [anon_sym_True] = ACTIONS(398),
    [anon_sym_False] = ACTIONS(398),
  },
  [154] = {
    [sym_line_comment] = STATE(154),
    [sym_block_comment] = STATE(154),
    [sym_label] = ACTIONS(402),
    [anon_sym_COLON] = ACTIONS(402),
    [anon_sym_then] = ACTIONS(402),
    [anon_sym_else] = ACTIONS(402),
    [anon_sym_let] = ACTIONS(402),
    [anon_sym_in] = ACTIONS(402),
    [anon_sym_as] = ACTIONS(402),
    [anon_sym_missing] = ACTIONS(402),
    [anon_sym_Infinity] = ACTIONS(402),
    [anon_sym_NaN] = ACTIONS(402),
    [anon_sym_with] = ACTIONS(402),
    [anon_sym_Natural_SLASHfold] = ACTIONS(402),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(402),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(402),
    [anon_sym_Natural_SLASHeven] = ACTIONS(402),
    [anon_sym_Natural_SLASHodd] = ACTIONS(402),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(402),
    [anon_sym_Natural_SLASHshow] = ACTIONS(402),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(402),
    [anon_sym_Integer_SLASHshow] = ACTIONS(402),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(402),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(402),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(402),
    [anon_sym_Double_SLASHshow] = ACTIONS(402),
    [anon_sym_List_SLASHbuild] = ACTIONS(402),
    [anon_sym_List_SLASHfold] = ACTIONS(402),
    [anon_sym_List_SLASHlength] = ACTIONS(402),
    [anon_sym_List_SLASHhead] = ACTIONS(402),
    [anon_sym_List_SLASHlast] = ACTIONS(402),
    [anon_sym_List_SLASHindexed] = ACTIONS(402),
    [anon_sym_List_SLASHreverse] = ACTIONS(402),
    [anon_sym_Text_SLASHshow] = ACTIONS(402),
    [anon_sym_Text_SLASHreplace] = ACTIONS(402),
    [anon_sym_Bool] = ACTIONS(402),
    [anon_sym_Optional] = ACTIONS(402),
    [anon_sym_None] = ACTIONS(402),
    [anon_sym_Natural] = ACTIONS(402),
    [anon_sym_Integer] = ACTIONS(402),
    [anon_sym_Double] = ACTIONS(402),
    [anon_sym_Text] = ACTIONS(402),
    [anon_sym_Date] = ACTIONS(402),
    [anon_sym_Time] = ACTIONS(402),
    [anon_sym_TimeZone] = ACTIONS(402),
    [anon_sym_List] = ACTIONS(402),
    [anon_sym_Type] = ACTIONS(402),
    [anon_sym_Kind] = ACTIONS(402),
    [anon_sym_Sort] = ACTIONS(402),
    [anon_sym_LPAREN] = ACTIONS(404),
    [anon_sym_RPAREN] = ACTIONS(404),
    [anon_sym_2] = ACTIONS(404),
    [anon_sym_DASH_GT] = ACTIONS(404),
    [anon_sym_EQ] = ACTIONS(402),
    [anon_sym_DOT] = ACTIONS(402),
    [anon_sym_QMARK] = ACTIONS(404),
    [anon_sym_LBRACK] = ACTIONS(404),
    [anon_sym_COMMA] = ACTIONS(404),
    [anon_sym_RBRACK] = ACTIONS(404),
    [anon_sym_4] = ACTIONS(404),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(404),
    [anon_sym_PIPE_PIPE] = ACTIONS(404),
    [anon_sym_PLUS] = ACTIONS(402),
    [anon_sym_PLUS_PLUS] = ACTIONS(404),
    [anon_sym_POUND] = ACTIONS(404),
    [anon_sym_AMP_AMP] = ACTIONS(404),
    [anon_sym_5] = ACTIONS(404),
    [anon_sym_SLASH_BSLASH] = ACTIONS(404),
    [anon_sym_6] = ACTIONS(404),
    [anon_sym_SLASH_SLASH] = ACTIONS(402),
    [anon_sym_7] = ACTIONS(404),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(404),
    [anon_sym_STAR] = ACTIONS(404),
    [anon_sym_EQ_EQ] = ACTIONS(402),
    [anon_sym_BANG_EQ] = ACTIONS(404),
    [anon_sym_COLON_COLON] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(402),
    [anon_sym_RBRACE] = ACTIONS(404),
    [sym_import_hash] = ACTIONS(404),
    [sym_local_import] = ACTIONS(404),
    [sym_http_raw] = ACTIONS(404),
    [aux_sym_env_import_token1] = ACTIONS(404),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(404),
    [anon_sym_DASHInfinity] = ACTIONS(404),
    [aux_sym_double_literal_token1] = ACTIONS(404),
    [sym_natural_literal] = ACTIONS(402),
    [sym_integer_literal] = ACTIONS(402),
    [anon_sym_DQUOTE] = ACTIONS(404),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(404),
    [anon_sym_LT] = ACTIONS(404),
    [anon_sym_PIPE] = ACTIONS(402),
    [anon_sym_GT] = ACTIONS(404),
    [anon_sym_True] = ACTIONS(402),
    [anon_sym_False] = ACTIONS(402),
  },
  [155] = {
    [sym_line_comment] = STATE(155),
    [sym_block_comment] = STATE(155),
    [sym_label] = ACTIONS(406),
    [anon_sym_COLON] = ACTIONS(406),
    [anon_sym_then] = ACTIONS(406),
    [anon_sym_else] = ACTIONS(406),
    [anon_sym_let] = ACTIONS(406),
    [anon_sym_in] = ACTIONS(406),
    [anon_sym_as] = ACTIONS(406),
    [anon_sym_missing] = ACTIONS(406),
    [anon_sym_Infinity] = ACTIONS(406),
    [anon_sym_NaN] = ACTIONS(406),
    [anon_sym_with] = ACTIONS(406),
    [anon_sym_Natural_SLASHfold] = ACTIONS(406),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(406),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(406),
    [anon_sym_Natural_SLASHeven] = ACTIONS(406),
    [anon_sym_Natural_SLASHodd] = ACTIONS(406),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(406),
    [anon_sym_Natural_SLASHshow] = ACTIONS(406),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(406),
    [anon_sym_Integer_SLASHshow] = ACTIONS(406),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(406),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(406),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(406),
    [anon_sym_Double_SLASHshow] = ACTIONS(406),
    [anon_sym_List_SLASHbuild] = ACTIONS(406),
    [anon_sym_List_SLASHfold] = ACTIONS(406),
    [anon_sym_List_SLASHlength] = ACTIONS(406),
    [anon_sym_List_SLASHhead] = ACTIONS(406),
    [anon_sym_List_SLASHlast] = ACTIONS(406),
    [anon_sym_List_SLASHindexed] = ACTIONS(406),
    [anon_sym_List_SLASHreverse] = ACTIONS(406),
    [anon_sym_Text_SLASHshow] = ACTIONS(406),
    [anon_sym_Text_SLASHreplace] = ACTIONS(406),
    [anon_sym_Bool] = ACTIONS(406),
    [anon_sym_Optional] = ACTIONS(406),
    [anon_sym_None] = ACTIONS(406),
    [anon_sym_Natural] = ACTIONS(406),
    [anon_sym_Integer] = ACTIONS(406),
    [anon_sym_Double] = ACTIONS(406),
    [anon_sym_Text] = ACTIONS(406),
    [anon_sym_Date] = ACTIONS(406),
    [anon_sym_Time] = ACTIONS(406),
    [anon_sym_TimeZone] = ACTIONS(406),
    [anon_sym_List] = ACTIONS(406),
    [anon_sym_Type] = ACTIONS(406),
    [anon_sym_Kind] = ACTIONS(406),
    [anon_sym_Sort] = ACTIONS(406),
    [anon_sym_LPAREN] = ACTIONS(408),
    [anon_sym_RPAREN] = ACTIONS(408),
    [anon_sym_2] = ACTIONS(408),
    [anon_sym_DASH_GT] = ACTIONS(408),
    [anon_sym_EQ] = ACTIONS(406),
    [anon_sym_DOT] = ACTIONS(406),
    [anon_sym_QMARK] = ACTIONS(408),
    [anon_sym_LBRACK] = ACTIONS(408),
    [anon_sym_COMMA] = ACTIONS(408),
    [anon_sym_RBRACK] = ACTIONS(408),
    [anon_sym_4] = ACTIONS(408),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(408),
    [anon_sym_PIPE_PIPE] = ACTIONS(408),
    [anon_sym_PLUS] = ACTIONS(406),
    [anon_sym_PLUS_PLUS] = ACTIONS(408),
    [anon_sym_POUND] = ACTIONS(408),
    [anon_sym_AMP_AMP] = ACTIONS(408),
    [anon_sym_5] = ACTIONS(408),
    [anon_sym_SLASH_BSLASH] = ACTIONS(408),
    [anon_sym_6] = ACTIONS(408),
    [anon_sym_SLASH_SLASH] = ACTIONS(406),
    [anon_sym_7] = ACTIONS(408),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(408),
    [anon_sym_STAR] = ACTIONS(408),
    [anon_sym_EQ_EQ] = ACTIONS(406),
    [anon_sym_BANG_EQ] = ACTIONS(408),
    [anon_sym_COLON_COLON] = ACTIONS(408),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(408),
    [sym_import_hash] = ACTIONS(408),
    [sym_local_import] = ACTIONS(408),
    [sym_http_raw] = ACTIONS(408),
    [aux_sym_env_import_token1] = ACTIONS(408),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(408),
    [anon_sym_DASHInfinity] = ACTIONS(408),
    [aux_sym_double_literal_token1] = ACTIONS(408),
    [sym_natural_literal] = ACTIONS(406),
    [sym_integer_literal] = ACTIONS(406),
    [anon_sym_DQUOTE] = ACTIONS(408),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(408),
    [anon_sym_LT] = ACTIONS(408),
    [anon_sym_PIPE] = ACTIONS(406),
    [anon_sym_GT] = ACTIONS(408),
    [anon_sym_True] = ACTIONS(406),
    [anon_sym_False] = ACTIONS(406),
  },
  [156] = {
    [sym_line_comment] = STATE(156),
    [sym_block_comment] = STATE(156),
    [sym_label] = ACTIONS(410),
    [anon_sym_COLON] = ACTIONS(410),
    [anon_sym_then] = ACTIONS(410),
    [anon_sym_else] = ACTIONS(410),
    [anon_sym_let] = ACTIONS(410),
    [anon_sym_in] = ACTIONS(410),
    [anon_sym_as] = ACTIONS(410),
    [anon_sym_missing] = ACTIONS(410),
    [anon_sym_Infinity] = ACTIONS(410),
    [anon_sym_NaN] = ACTIONS(410),
    [anon_sym_with] = ACTIONS(410),
    [anon_sym_Natural_SLASHfold] = ACTIONS(410),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(410),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(410),
    [anon_sym_Natural_SLASHeven] = ACTIONS(410),
    [anon_sym_Natural_SLASHodd] = ACTIONS(410),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(410),
    [anon_sym_Natural_SLASHshow] = ACTIONS(410),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(410),
    [anon_sym_Integer_SLASHshow] = ACTIONS(410),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(410),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(410),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(410),
    [anon_sym_Double_SLASHshow] = ACTIONS(410),
    [anon_sym_List_SLASHbuild] = ACTIONS(410),
    [anon_sym_List_SLASHfold] = ACTIONS(410),
    [anon_sym_List_SLASHlength] = ACTIONS(410),
    [anon_sym_List_SLASHhead] = ACTIONS(410),
    [anon_sym_List_SLASHlast] = ACTIONS(410),
    [anon_sym_List_SLASHindexed] = ACTIONS(410),
    [anon_sym_List_SLASHreverse] = ACTIONS(410),
    [anon_sym_Text_SLASHshow] = ACTIONS(410),
    [anon_sym_Text_SLASHreplace] = ACTIONS(410),
    [anon_sym_Bool] = ACTIONS(410),
    [anon_sym_Optional] = ACTIONS(410),
    [anon_sym_None] = ACTIONS(410),
    [anon_sym_Natural] = ACTIONS(410),
    [anon_sym_Integer] = ACTIONS(410),
    [anon_sym_Double] = ACTIONS(410),
    [anon_sym_Text] = ACTIONS(410),
    [anon_sym_Date] = ACTIONS(410),
    [anon_sym_Time] = ACTIONS(410),
    [anon_sym_TimeZone] = ACTIONS(410),
    [anon_sym_List] = ACTIONS(410),
    [anon_sym_Type] = ACTIONS(410),
    [anon_sym_Kind] = ACTIONS(410),
    [anon_sym_Sort] = ACTIONS(410),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_RPAREN] = ACTIONS(412),
    [anon_sym_2] = ACTIONS(412),
    [anon_sym_DASH_GT] = ACTIONS(412),
    [anon_sym_EQ] = ACTIONS(410),
    [anon_sym_DOT] = ACTIONS(410),
    [anon_sym_QMARK] = ACTIONS(412),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_COMMA] = ACTIONS(412),
    [anon_sym_RBRACK] = ACTIONS(412),
    [anon_sym_4] = ACTIONS(412),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(412),
    [anon_sym_PIPE_PIPE] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(410),
    [anon_sym_PLUS_PLUS] = ACTIONS(412),
    [anon_sym_POUND] = ACTIONS(412),
    [anon_sym_AMP_AMP] = ACTIONS(412),
    [anon_sym_5] = ACTIONS(412),
    [anon_sym_SLASH_BSLASH] = ACTIONS(412),
    [anon_sym_6] = ACTIONS(412),
    [anon_sym_SLASH_SLASH] = ACTIONS(410),
    [anon_sym_7] = ACTIONS(412),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(412),
    [anon_sym_STAR] = ACTIONS(412),
    [anon_sym_EQ_EQ] = ACTIONS(410),
    [anon_sym_BANG_EQ] = ACTIONS(412),
    [anon_sym_COLON_COLON] = ACTIONS(412),
    [anon_sym_LBRACE] = ACTIONS(410),
    [anon_sym_RBRACE] = ACTIONS(412),
    [sym_import_hash] = ACTIONS(412),
    [sym_local_import] = ACTIONS(412),
    [sym_http_raw] = ACTIONS(412),
    [aux_sym_env_import_token1] = ACTIONS(412),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(412),
    [anon_sym_DASHInfinity] = ACTIONS(412),
    [aux_sym_double_literal_token1] = ACTIONS(412),
    [sym_natural_literal] = ACTIONS(410),
    [sym_integer_literal] = ACTIONS(410),
    [anon_sym_DQUOTE] = ACTIONS(412),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(412),
    [anon_sym_PIPE] = ACTIONS(410),
    [anon_sym_GT] = ACTIONS(412),
    [anon_sym_True] = ACTIONS(410),
    [anon_sym_False] = ACTIONS(410),
  },
  [157] = {
    [sym_line_comment] = STATE(157),
    [sym_block_comment] = STATE(157),
    [sym_label] = ACTIONS(414),
    [anon_sym_COLON] = ACTIONS(414),
    [anon_sym_then] = ACTIONS(414),
    [anon_sym_else] = ACTIONS(414),
    [anon_sym_let] = ACTIONS(414),
    [anon_sym_in] = ACTIONS(414),
    [anon_sym_as] = ACTIONS(414),
    [anon_sym_missing] = ACTIONS(414),
    [anon_sym_Infinity] = ACTIONS(414),
    [anon_sym_NaN] = ACTIONS(414),
    [anon_sym_with] = ACTIONS(414),
    [anon_sym_Natural_SLASHfold] = ACTIONS(414),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(414),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(414),
    [anon_sym_Natural_SLASHeven] = ACTIONS(414),
    [anon_sym_Natural_SLASHodd] = ACTIONS(414),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(414),
    [anon_sym_Natural_SLASHshow] = ACTIONS(414),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(414),
    [anon_sym_Integer_SLASHshow] = ACTIONS(414),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(414),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(414),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(414),
    [anon_sym_Double_SLASHshow] = ACTIONS(414),
    [anon_sym_List_SLASHbuild] = ACTIONS(414),
    [anon_sym_List_SLASHfold] = ACTIONS(414),
    [anon_sym_List_SLASHlength] = ACTIONS(414),
    [anon_sym_List_SLASHhead] = ACTIONS(414),
    [anon_sym_List_SLASHlast] = ACTIONS(414),
    [anon_sym_List_SLASHindexed] = ACTIONS(414),
    [anon_sym_List_SLASHreverse] = ACTIONS(414),
    [anon_sym_Text_SLASHshow] = ACTIONS(414),
    [anon_sym_Text_SLASHreplace] = ACTIONS(414),
    [anon_sym_Bool] = ACTIONS(414),
    [anon_sym_Optional] = ACTIONS(414),
    [anon_sym_None] = ACTIONS(414),
    [anon_sym_Natural] = ACTIONS(414),
    [anon_sym_Integer] = ACTIONS(414),
    [anon_sym_Double] = ACTIONS(414),
    [anon_sym_Text] = ACTIONS(414),
    [anon_sym_Date] = ACTIONS(414),
    [anon_sym_Time] = ACTIONS(414),
    [anon_sym_TimeZone] = ACTIONS(414),
    [anon_sym_List] = ACTIONS(414),
    [anon_sym_Type] = ACTIONS(414),
    [anon_sym_Kind] = ACTIONS(414),
    [anon_sym_Sort] = ACTIONS(414),
    [anon_sym_LPAREN] = ACTIONS(416),
    [anon_sym_RPAREN] = ACTIONS(416),
    [anon_sym_2] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(414),
    [anon_sym_DOT] = ACTIONS(414),
    [anon_sym_QMARK] = ACTIONS(416),
    [anon_sym_LBRACK] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(416),
    [anon_sym_RBRACK] = ACTIONS(416),
    [anon_sym_4] = ACTIONS(416),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(416),
    [anon_sym_PIPE_PIPE] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_PLUS_PLUS] = ACTIONS(416),
    [anon_sym_POUND] = ACTIONS(416),
    [anon_sym_AMP_AMP] = ACTIONS(416),
    [anon_sym_5] = ACTIONS(416),
    [anon_sym_SLASH_BSLASH] = ACTIONS(416),
    [anon_sym_6] = ACTIONS(416),
    [anon_sym_SLASH_SLASH] = ACTIONS(414),
    [anon_sym_7] = ACTIONS(416),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(416),
    [anon_sym_STAR] = ACTIONS(416),
    [anon_sym_EQ_EQ] = ACTIONS(414),
    [anon_sym_BANG_EQ] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(416),
    [anon_sym_LBRACE] = ACTIONS(414),
    [anon_sym_RBRACE] = ACTIONS(416),
    [sym_import_hash] = ACTIONS(416),
    [sym_local_import] = ACTIONS(416),
    [sym_http_raw] = ACTIONS(416),
    [aux_sym_env_import_token1] = ACTIONS(416),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(416),
    [anon_sym_DASHInfinity] = ACTIONS(416),
    [aux_sym_double_literal_token1] = ACTIONS(416),
    [sym_natural_literal] = ACTIONS(414),
    [sym_integer_literal] = ACTIONS(414),
    [anon_sym_DQUOTE] = ACTIONS(416),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(416),
    [anon_sym_LT] = ACTIONS(416),
    [anon_sym_PIPE] = ACTIONS(414),
    [anon_sym_GT] = ACTIONS(416),
    [anon_sym_True] = ACTIONS(414),
    [anon_sym_False] = ACTIONS(414),
  },
  [158] = {
    [sym_selector] = STATE(231),
    [sym_line_comment] = STATE(158),
    [sym_block_comment] = STATE(158),
    [aux_sym_selector_repeat1] = STATE(167),
    [sym_label] = ACTIONS(269),
    [anon_sym_COLON] = ACTIONS(269),
    [anon_sym_then] = ACTIONS(269),
    [anon_sym_else] = ACTIONS(269),
    [anon_sym_let] = ACTIONS(269),
    [anon_sym_in] = ACTIONS(269),
    [anon_sym_missing] = ACTIONS(269),
    [anon_sym_Infinity] = ACTIONS(269),
    [anon_sym_NaN] = ACTIONS(269),
    [anon_sym_with] = ACTIONS(269),
    [anon_sym_Natural_SLASHfold] = ACTIONS(269),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(269),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(269),
    [anon_sym_Natural_SLASHeven] = ACTIONS(269),
    [anon_sym_Natural_SLASHodd] = ACTIONS(269),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(269),
    [anon_sym_Natural_SLASHshow] = ACTIONS(269),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(269),
    [anon_sym_Integer_SLASHshow] = ACTIONS(269),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(269),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(269),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(269),
    [anon_sym_Double_SLASHshow] = ACTIONS(269),
    [anon_sym_List_SLASHbuild] = ACTIONS(269),
    [anon_sym_List_SLASHfold] = ACTIONS(269),
    [anon_sym_List_SLASHlength] = ACTIONS(269),
    [anon_sym_List_SLASHhead] = ACTIONS(269),
    [anon_sym_List_SLASHlast] = ACTIONS(269),
    [anon_sym_List_SLASHindexed] = ACTIONS(269),
    [anon_sym_List_SLASHreverse] = ACTIONS(269),
    [anon_sym_Text_SLASHshow] = ACTIONS(269),
    [anon_sym_Text_SLASHreplace] = ACTIONS(269),
    [anon_sym_Bool] = ACTIONS(269),
    [anon_sym_Optional] = ACTIONS(269),
    [anon_sym_None] = ACTIONS(269),
    [anon_sym_Natural] = ACTIONS(269),
    [anon_sym_Integer] = ACTIONS(269),
    [anon_sym_Double] = ACTIONS(269),
    [anon_sym_Text] = ACTIONS(269),
    [anon_sym_Date] = ACTIONS(269),
    [anon_sym_Time] = ACTIONS(269),
    [anon_sym_TimeZone] = ACTIONS(269),
    [anon_sym_List] = ACTIONS(269),
    [anon_sym_Type] = ACTIONS(269),
    [anon_sym_Kind] = ACTIONS(269),
    [anon_sym_Sort] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_RPAREN] = ACTIONS(271),
    [anon_sym_2] = ACTIONS(271),
    [anon_sym_DASH_GT] = ACTIONS(271),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_DOT] = ACTIONS(390),
    [anon_sym_QMARK] = ACTIONS(271),
    [anon_sym_LBRACK] = ACTIONS(271),
    [anon_sym_COMMA] = ACTIONS(271),
    [anon_sym_RBRACK] = ACTIONS(271),
    [anon_sym_4] = ACTIONS(271),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(271),
    [anon_sym_PIPE_PIPE] = ACTIONS(271),
    [anon_sym_PLUS] = ACTIONS(269),
    [anon_sym_PLUS_PLUS] = ACTIONS(271),
    [anon_sym_POUND] = ACTIONS(271),
    [anon_sym_AMP_AMP] = ACTIONS(271),
    [anon_sym_5] = ACTIONS(271),
    [anon_sym_SLASH_BSLASH] = ACTIONS(271),
    [anon_sym_6] = ACTIONS(271),
    [anon_sym_SLASH_SLASH] = ACTIONS(269),
    [anon_sym_7] = ACTIONS(271),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(271),
    [anon_sym_STAR] = ACTIONS(271),
    [anon_sym_EQ_EQ] = ACTIONS(269),
    [anon_sym_BANG_EQ] = ACTIONS(271),
    [anon_sym_COLON_COLON] = ACTIONS(271),
    [anon_sym_LBRACE] = ACTIONS(269),
    [anon_sym_RBRACE] = ACTIONS(271),
    [sym_local_import] = ACTIONS(271),
    [sym_http_raw] = ACTIONS(271),
    [aux_sym_env_import_token1] = ACTIONS(271),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(271),
    [anon_sym_DASHInfinity] = ACTIONS(271),
    [aux_sym_double_literal_token1] = ACTIONS(271),
    [sym_natural_literal] = ACTIONS(269),
    [sym_integer_literal] = ACTIONS(269),
    [anon_sym_DQUOTE] = ACTIONS(271),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(271),
    [anon_sym_LT] = ACTIONS(271),
    [anon_sym_PIPE] = ACTIONS(269),
    [anon_sym_GT] = ACTIONS(271),
    [anon_sym_True] = ACTIONS(269),
    [anon_sym_False] = ACTIONS(269),
  },
  [159] = {
    [sym_line_comment] = STATE(159),
    [sym_block_comment] = STATE(159),
    [sym_label] = ACTIONS(418),
    [anon_sym_COLON] = ACTIONS(418),
    [anon_sym_then] = ACTIONS(418),
    [anon_sym_else] = ACTIONS(418),
    [anon_sym_let] = ACTIONS(418),
    [anon_sym_in] = ACTIONS(418),
    [anon_sym_as] = ACTIONS(418),
    [anon_sym_missing] = ACTIONS(418),
    [anon_sym_Infinity] = ACTIONS(418),
    [anon_sym_NaN] = ACTIONS(418),
    [anon_sym_with] = ACTIONS(418),
    [anon_sym_Natural_SLASHfold] = ACTIONS(418),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(418),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(418),
    [anon_sym_Natural_SLASHeven] = ACTIONS(418),
    [anon_sym_Natural_SLASHodd] = ACTIONS(418),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(418),
    [anon_sym_Natural_SLASHshow] = ACTIONS(418),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(418),
    [anon_sym_Integer_SLASHshow] = ACTIONS(418),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(418),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(418),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(418),
    [anon_sym_Double_SLASHshow] = ACTIONS(418),
    [anon_sym_List_SLASHbuild] = ACTIONS(418),
    [anon_sym_List_SLASHfold] = ACTIONS(418),
    [anon_sym_List_SLASHlength] = ACTIONS(418),
    [anon_sym_List_SLASHhead] = ACTIONS(418),
    [anon_sym_List_SLASHlast] = ACTIONS(418),
    [anon_sym_List_SLASHindexed] = ACTIONS(418),
    [anon_sym_List_SLASHreverse] = ACTIONS(418),
    [anon_sym_Text_SLASHshow] = ACTIONS(418),
    [anon_sym_Text_SLASHreplace] = ACTIONS(418),
    [anon_sym_Bool] = ACTIONS(418),
    [anon_sym_Optional] = ACTIONS(418),
    [anon_sym_None] = ACTIONS(418),
    [anon_sym_Natural] = ACTIONS(418),
    [anon_sym_Integer] = ACTIONS(418),
    [anon_sym_Double] = ACTIONS(418),
    [anon_sym_Text] = ACTIONS(418),
    [anon_sym_Date] = ACTIONS(418),
    [anon_sym_Time] = ACTIONS(418),
    [anon_sym_TimeZone] = ACTIONS(418),
    [anon_sym_List] = ACTIONS(418),
    [anon_sym_Type] = ACTIONS(418),
    [anon_sym_Kind] = ACTIONS(418),
    [anon_sym_Sort] = ACTIONS(418),
    [anon_sym_LPAREN] = ACTIONS(420),
    [anon_sym_RPAREN] = ACTIONS(420),
    [anon_sym_2] = ACTIONS(420),
    [anon_sym_DASH_GT] = ACTIONS(420),
    [anon_sym_EQ] = ACTIONS(418),
    [anon_sym_DOT] = ACTIONS(418),
    [anon_sym_QMARK] = ACTIONS(420),
    [anon_sym_LBRACK] = ACTIONS(420),
    [anon_sym_COMMA] = ACTIONS(420),
    [anon_sym_RBRACK] = ACTIONS(420),
    [anon_sym_4] = ACTIONS(420),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(420),
    [anon_sym_PIPE_PIPE] = ACTIONS(420),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_PLUS_PLUS] = ACTIONS(420),
    [anon_sym_POUND] = ACTIONS(420),
    [anon_sym_AMP_AMP] = ACTIONS(420),
    [anon_sym_5] = ACTIONS(420),
    [anon_sym_SLASH_BSLASH] = ACTIONS(420),
    [anon_sym_6] = ACTIONS(420),
    [anon_sym_SLASH_SLASH] = ACTIONS(418),
    [anon_sym_7] = ACTIONS(420),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(420),
    [anon_sym_STAR] = ACTIONS(420),
    [anon_sym_EQ_EQ] = ACTIONS(418),
    [anon_sym_BANG_EQ] = ACTIONS(420),
    [anon_sym_COLON_COLON] = ACTIONS(420),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_RBRACE] = ACTIONS(420),
    [sym_import_hash] = ACTIONS(420),
    [sym_local_import] = ACTIONS(420),
    [sym_http_raw] = ACTIONS(420),
    [aux_sym_env_import_token1] = ACTIONS(420),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(420),
    [anon_sym_DASHInfinity] = ACTIONS(420),
    [aux_sym_double_literal_token1] = ACTIONS(420),
    [sym_natural_literal] = ACTIONS(418),
    [sym_integer_literal] = ACTIONS(418),
    [anon_sym_DQUOTE] = ACTIONS(420),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(420),
    [anon_sym_LT] = ACTIONS(420),
    [anon_sym_PIPE] = ACTIONS(418),
    [anon_sym_GT] = ACTIONS(420),
    [anon_sym_True] = ACTIONS(418),
    [anon_sym_False] = ACTIONS(418),
  },
  [160] = {
    [sym_line_comment] = STATE(160),
    [sym_block_comment] = STATE(160),
    [sym_label] = ACTIONS(422),
    [anon_sym_COLON] = ACTIONS(422),
    [anon_sym_then] = ACTIONS(422),
    [anon_sym_else] = ACTIONS(422),
    [anon_sym_let] = ACTIONS(422),
    [anon_sym_in] = ACTIONS(422),
    [anon_sym_as] = ACTIONS(422),
    [anon_sym_missing] = ACTIONS(422),
    [anon_sym_Infinity] = ACTIONS(422),
    [anon_sym_NaN] = ACTIONS(422),
    [anon_sym_with] = ACTIONS(422),
    [anon_sym_Natural_SLASHfold] = ACTIONS(422),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(422),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(422),
    [anon_sym_Natural_SLASHeven] = ACTIONS(422),
    [anon_sym_Natural_SLASHodd] = ACTIONS(422),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(422),
    [anon_sym_Natural_SLASHshow] = ACTIONS(422),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(422),
    [anon_sym_Integer_SLASHshow] = ACTIONS(422),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(422),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(422),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(422),
    [anon_sym_Double_SLASHshow] = ACTIONS(422),
    [anon_sym_List_SLASHbuild] = ACTIONS(422),
    [anon_sym_List_SLASHfold] = ACTIONS(422),
    [anon_sym_List_SLASHlength] = ACTIONS(422),
    [anon_sym_List_SLASHhead] = ACTIONS(422),
    [anon_sym_List_SLASHlast] = ACTIONS(422),
    [anon_sym_List_SLASHindexed] = ACTIONS(422),
    [anon_sym_List_SLASHreverse] = ACTIONS(422),
    [anon_sym_Text_SLASHshow] = ACTIONS(422),
    [anon_sym_Text_SLASHreplace] = ACTIONS(422),
    [anon_sym_Bool] = ACTIONS(422),
    [anon_sym_Optional] = ACTIONS(422),
    [anon_sym_None] = ACTIONS(422),
    [anon_sym_Natural] = ACTIONS(422),
    [anon_sym_Integer] = ACTIONS(422),
    [anon_sym_Double] = ACTIONS(422),
    [anon_sym_Text] = ACTIONS(422),
    [anon_sym_Date] = ACTIONS(422),
    [anon_sym_Time] = ACTIONS(422),
    [anon_sym_TimeZone] = ACTIONS(422),
    [anon_sym_List] = ACTIONS(422),
    [anon_sym_Type] = ACTIONS(422),
    [anon_sym_Kind] = ACTIONS(422),
    [anon_sym_Sort] = ACTIONS(422),
    [anon_sym_LPAREN] = ACTIONS(424),
    [anon_sym_RPAREN] = ACTIONS(424),
    [anon_sym_2] = ACTIONS(424),
    [anon_sym_DASH_GT] = ACTIONS(424),
    [anon_sym_EQ] = ACTIONS(422),
    [anon_sym_DOT] = ACTIONS(422),
    [anon_sym_QMARK] = ACTIONS(424),
    [anon_sym_LBRACK] = ACTIONS(424),
    [anon_sym_COMMA] = ACTIONS(424),
    [anon_sym_RBRACK] = ACTIONS(424),
    [anon_sym_4] = ACTIONS(424),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(424),
    [anon_sym_PIPE_PIPE] = ACTIONS(424),
    [anon_sym_PLUS] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_POUND] = ACTIONS(424),
    [anon_sym_AMP_AMP] = ACTIONS(424),
    [anon_sym_5] = ACTIONS(424),
    [anon_sym_SLASH_BSLASH] = ACTIONS(424),
    [anon_sym_6] = ACTIONS(424),
    [anon_sym_SLASH_SLASH] = ACTIONS(422),
    [anon_sym_7] = ACTIONS(424),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(424),
    [anon_sym_STAR] = ACTIONS(424),
    [anon_sym_EQ_EQ] = ACTIONS(422),
    [anon_sym_BANG_EQ] = ACTIONS(424),
    [anon_sym_COLON_COLON] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(422),
    [anon_sym_RBRACE] = ACTIONS(424),
    [sym_import_hash] = ACTIONS(424),
    [sym_local_import] = ACTIONS(424),
    [sym_http_raw] = ACTIONS(424),
    [aux_sym_env_import_token1] = ACTIONS(424),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(424),
    [anon_sym_DASHInfinity] = ACTIONS(424),
    [aux_sym_double_literal_token1] = ACTIONS(424),
    [sym_natural_literal] = ACTIONS(422),
    [sym_integer_literal] = ACTIONS(422),
    [anon_sym_DQUOTE] = ACTIONS(424),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(424),
    [anon_sym_LT] = ACTIONS(424),
    [anon_sym_PIPE] = ACTIONS(422),
    [anon_sym_GT] = ACTIONS(424),
    [anon_sym_True] = ACTIONS(422),
    [anon_sym_False] = ACTIONS(422),
  },
  [161] = {
    [sym_line_comment] = STATE(161),
    [sym_block_comment] = STATE(161),
    [sym_label] = ACTIONS(426),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_then] = ACTIONS(426),
    [anon_sym_else] = ACTIONS(426),
    [anon_sym_let] = ACTIONS(426),
    [anon_sym_in] = ACTIONS(426),
    [anon_sym_as] = ACTIONS(426),
    [anon_sym_missing] = ACTIONS(426),
    [anon_sym_Infinity] = ACTIONS(426),
    [anon_sym_NaN] = ACTIONS(426),
    [anon_sym_with] = ACTIONS(426),
    [anon_sym_Natural_SLASHfold] = ACTIONS(426),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(426),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(426),
    [anon_sym_Natural_SLASHeven] = ACTIONS(426),
    [anon_sym_Natural_SLASHodd] = ACTIONS(426),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(426),
    [anon_sym_Natural_SLASHshow] = ACTIONS(426),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(426),
    [anon_sym_Integer_SLASHshow] = ACTIONS(426),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(426),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(426),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(426),
    [anon_sym_Double_SLASHshow] = ACTIONS(426),
    [anon_sym_List_SLASHbuild] = ACTIONS(426),
    [anon_sym_List_SLASHfold] = ACTIONS(426),
    [anon_sym_List_SLASHlength] = ACTIONS(426),
    [anon_sym_List_SLASHhead] = ACTIONS(426),
    [anon_sym_List_SLASHlast] = ACTIONS(426),
    [anon_sym_List_SLASHindexed] = ACTIONS(426),
    [anon_sym_List_SLASHreverse] = ACTIONS(426),
    [anon_sym_Text_SLASHshow] = ACTIONS(426),
    [anon_sym_Text_SLASHreplace] = ACTIONS(426),
    [anon_sym_Bool] = ACTIONS(426),
    [anon_sym_Optional] = ACTIONS(426),
    [anon_sym_None] = ACTIONS(426),
    [anon_sym_Natural] = ACTIONS(426),
    [anon_sym_Integer] = ACTIONS(426),
    [anon_sym_Double] = ACTIONS(426),
    [anon_sym_Text] = ACTIONS(426),
    [anon_sym_Date] = ACTIONS(426),
    [anon_sym_Time] = ACTIONS(426),
    [anon_sym_TimeZone] = ACTIONS(426),
    [anon_sym_List] = ACTIONS(426),
    [anon_sym_Type] = ACTIONS(426),
    [anon_sym_Kind] = ACTIONS(426),
    [anon_sym_Sort] = ACTIONS(426),
    [anon_sym_LPAREN] = ACTIONS(428),
    [anon_sym_RPAREN] = ACTIONS(428),
    [anon_sym_2] = ACTIONS(428),
    [anon_sym_DASH_GT] = ACTIONS(428),
    [anon_sym_EQ] = ACTIONS(426),
    [anon_sym_DOT] = ACTIONS(426),
    [anon_sym_QMARK] = ACTIONS(428),
    [anon_sym_LBRACK] = ACTIONS(428),
    [anon_sym_COMMA] = ACTIONS(428),
    [anon_sym_RBRACK] = ACTIONS(428),
    [anon_sym_4] = ACTIONS(428),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(428),
    [anon_sym_PIPE_PIPE] = ACTIONS(428),
    [anon_sym_PLUS] = ACTIONS(426),
    [anon_sym_PLUS_PLUS] = ACTIONS(428),
    [anon_sym_POUND] = ACTIONS(428),
    [anon_sym_AMP_AMP] = ACTIONS(428),
    [anon_sym_5] = ACTIONS(428),
    [anon_sym_SLASH_BSLASH] = ACTIONS(428),
    [anon_sym_6] = ACTIONS(428),
    [anon_sym_SLASH_SLASH] = ACTIONS(426),
    [anon_sym_7] = ACTIONS(428),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(428),
    [anon_sym_STAR] = ACTIONS(428),
    [anon_sym_EQ_EQ] = ACTIONS(426),
    [anon_sym_BANG_EQ] = ACTIONS(428),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [anon_sym_LBRACE] = ACTIONS(426),
    [anon_sym_RBRACE] = ACTIONS(428),
    [sym_import_hash] = ACTIONS(428),
    [sym_local_import] = ACTIONS(428),
    [sym_http_raw] = ACTIONS(428),
    [aux_sym_env_import_token1] = ACTIONS(428),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(428),
    [anon_sym_DASHInfinity] = ACTIONS(428),
    [aux_sym_double_literal_token1] = ACTIONS(428),
    [sym_natural_literal] = ACTIONS(426),
    [sym_integer_literal] = ACTIONS(426),
    [anon_sym_DQUOTE] = ACTIONS(428),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(428),
    [anon_sym_LT] = ACTIONS(428),
    [anon_sym_PIPE] = ACTIONS(426),
    [anon_sym_GT] = ACTIONS(428),
    [anon_sym_True] = ACTIONS(426),
    [anon_sym_False] = ACTIONS(426),
  },
  [162] = {
    [sym_line_comment] = STATE(162),
    [sym_block_comment] = STATE(162),
    [sym_label] = ACTIONS(430),
    [anon_sym_COLON] = ACTIONS(430),
    [anon_sym_then] = ACTIONS(430),
    [anon_sym_else] = ACTIONS(430),
    [anon_sym_let] = ACTIONS(430),
    [anon_sym_in] = ACTIONS(430),
    [anon_sym_as] = ACTIONS(430),
    [anon_sym_missing] = ACTIONS(430),
    [anon_sym_Infinity] = ACTIONS(430),
    [anon_sym_NaN] = ACTIONS(430),
    [anon_sym_with] = ACTIONS(430),
    [anon_sym_Natural_SLASHfold] = ACTIONS(430),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(430),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(430),
    [anon_sym_Natural_SLASHeven] = ACTIONS(430),
    [anon_sym_Natural_SLASHodd] = ACTIONS(430),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(430),
    [anon_sym_Natural_SLASHshow] = ACTIONS(430),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(430),
    [anon_sym_Integer_SLASHshow] = ACTIONS(430),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(430),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(430),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(430),
    [anon_sym_Double_SLASHshow] = ACTIONS(430),
    [anon_sym_List_SLASHbuild] = ACTIONS(430),
    [anon_sym_List_SLASHfold] = ACTIONS(430),
    [anon_sym_List_SLASHlength] = ACTIONS(430),
    [anon_sym_List_SLASHhead] = ACTIONS(430),
    [anon_sym_List_SLASHlast] = ACTIONS(430),
    [anon_sym_List_SLASHindexed] = ACTIONS(430),
    [anon_sym_List_SLASHreverse] = ACTIONS(430),
    [anon_sym_Text_SLASHshow] = ACTIONS(430),
    [anon_sym_Text_SLASHreplace] = ACTIONS(430),
    [anon_sym_Bool] = ACTIONS(430),
    [anon_sym_Optional] = ACTIONS(430),
    [anon_sym_None] = ACTIONS(430),
    [anon_sym_Natural] = ACTIONS(430),
    [anon_sym_Integer] = ACTIONS(430),
    [anon_sym_Double] = ACTIONS(430),
    [anon_sym_Text] = ACTIONS(430),
    [anon_sym_Date] = ACTIONS(430),
    [anon_sym_Time] = ACTIONS(430),
    [anon_sym_TimeZone] = ACTIONS(430),
    [anon_sym_List] = ACTIONS(430),
    [anon_sym_Type] = ACTIONS(430),
    [anon_sym_Kind] = ACTIONS(430),
    [anon_sym_Sort] = ACTIONS(430),
    [anon_sym_LPAREN] = ACTIONS(432),
    [anon_sym_RPAREN] = ACTIONS(432),
    [anon_sym_2] = ACTIONS(432),
    [anon_sym_DASH_GT] = ACTIONS(432),
    [anon_sym_EQ] = ACTIONS(430),
    [anon_sym_DOT] = ACTIONS(430),
    [anon_sym_QMARK] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(432),
    [anon_sym_COMMA] = ACTIONS(432),
    [anon_sym_RBRACK] = ACTIONS(432),
    [anon_sym_4] = ACTIONS(432),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(432),
    [anon_sym_PIPE_PIPE] = ACTIONS(432),
    [anon_sym_PLUS] = ACTIONS(430),
    [anon_sym_PLUS_PLUS] = ACTIONS(432),
    [anon_sym_POUND] = ACTIONS(432),
    [anon_sym_AMP_AMP] = ACTIONS(432),
    [anon_sym_5] = ACTIONS(432),
    [anon_sym_SLASH_BSLASH] = ACTIONS(432),
    [anon_sym_6] = ACTIONS(432),
    [anon_sym_SLASH_SLASH] = ACTIONS(430),
    [anon_sym_7] = ACTIONS(432),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(432),
    [anon_sym_STAR] = ACTIONS(432),
    [anon_sym_EQ_EQ] = ACTIONS(430),
    [anon_sym_BANG_EQ] = ACTIONS(432),
    [anon_sym_COLON_COLON] = ACTIONS(432),
    [anon_sym_LBRACE] = ACTIONS(430),
    [anon_sym_RBRACE] = ACTIONS(432),
    [sym_import_hash] = ACTIONS(432),
    [sym_local_import] = ACTIONS(432),
    [sym_http_raw] = ACTIONS(432),
    [aux_sym_env_import_token1] = ACTIONS(432),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(432),
    [anon_sym_DASHInfinity] = ACTIONS(432),
    [aux_sym_double_literal_token1] = ACTIONS(432),
    [sym_natural_literal] = ACTIONS(430),
    [sym_integer_literal] = ACTIONS(430),
    [anon_sym_DQUOTE] = ACTIONS(432),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(432),
    [anon_sym_LT] = ACTIONS(432),
    [anon_sym_PIPE] = ACTIONS(430),
    [anon_sym_GT] = ACTIONS(432),
    [anon_sym_True] = ACTIONS(430),
    [anon_sym_False] = ACTIONS(430),
  },
  [163] = {
    [sym_line_comment] = STATE(163),
    [sym_block_comment] = STATE(163),
    [sym_label] = ACTIONS(434),
    [anon_sym_COLON] = ACTIONS(434),
    [anon_sym_then] = ACTIONS(434),
    [anon_sym_else] = ACTIONS(434),
    [anon_sym_let] = ACTIONS(434),
    [anon_sym_in] = ACTIONS(434),
    [anon_sym_as] = ACTIONS(434),
    [anon_sym_missing] = ACTIONS(434),
    [anon_sym_Infinity] = ACTIONS(434),
    [anon_sym_NaN] = ACTIONS(434),
    [anon_sym_with] = ACTIONS(434),
    [anon_sym_Natural_SLASHfold] = ACTIONS(434),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(434),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(434),
    [anon_sym_Natural_SLASHeven] = ACTIONS(434),
    [anon_sym_Natural_SLASHodd] = ACTIONS(434),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(434),
    [anon_sym_Natural_SLASHshow] = ACTIONS(434),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(434),
    [anon_sym_Integer_SLASHshow] = ACTIONS(434),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(434),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(434),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(434),
    [anon_sym_Double_SLASHshow] = ACTIONS(434),
    [anon_sym_List_SLASHbuild] = ACTIONS(434),
    [anon_sym_List_SLASHfold] = ACTIONS(434),
    [anon_sym_List_SLASHlength] = ACTIONS(434),
    [anon_sym_List_SLASHhead] = ACTIONS(434),
    [anon_sym_List_SLASHlast] = ACTIONS(434),
    [anon_sym_List_SLASHindexed] = ACTIONS(434),
    [anon_sym_List_SLASHreverse] = ACTIONS(434),
    [anon_sym_Text_SLASHshow] = ACTIONS(434),
    [anon_sym_Text_SLASHreplace] = ACTIONS(434),
    [anon_sym_Bool] = ACTIONS(434),
    [anon_sym_Optional] = ACTIONS(434),
    [anon_sym_None] = ACTIONS(434),
    [anon_sym_Natural] = ACTIONS(434),
    [anon_sym_Integer] = ACTIONS(434),
    [anon_sym_Double] = ACTIONS(434),
    [anon_sym_Text] = ACTIONS(434),
    [anon_sym_Date] = ACTIONS(434),
    [anon_sym_Time] = ACTIONS(434),
    [anon_sym_TimeZone] = ACTIONS(434),
    [anon_sym_List] = ACTIONS(434),
    [anon_sym_Type] = ACTIONS(434),
    [anon_sym_Kind] = ACTIONS(434),
    [anon_sym_Sort] = ACTIONS(434),
    [anon_sym_LPAREN] = ACTIONS(436),
    [anon_sym_RPAREN] = ACTIONS(436),
    [anon_sym_2] = ACTIONS(436),
    [anon_sym_DASH_GT] = ACTIONS(436),
    [anon_sym_EQ] = ACTIONS(434),
    [anon_sym_DOT] = ACTIONS(434),
    [anon_sym_QMARK] = ACTIONS(436),
    [anon_sym_LBRACK] = ACTIONS(436),
    [anon_sym_COMMA] = ACTIONS(436),
    [anon_sym_RBRACK] = ACTIONS(436),
    [anon_sym_4] = ACTIONS(436),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(436),
    [anon_sym_PIPE_PIPE] = ACTIONS(436),
    [anon_sym_PLUS] = ACTIONS(434),
    [anon_sym_PLUS_PLUS] = ACTIONS(436),
    [anon_sym_POUND] = ACTIONS(436),
    [anon_sym_AMP_AMP] = ACTIONS(436),
    [anon_sym_5] = ACTIONS(436),
    [anon_sym_SLASH_BSLASH] = ACTIONS(436),
    [anon_sym_6] = ACTIONS(436),
    [anon_sym_SLASH_SLASH] = ACTIONS(434),
    [anon_sym_7] = ACTIONS(436),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(436),
    [anon_sym_STAR] = ACTIONS(436),
    [anon_sym_EQ_EQ] = ACTIONS(434),
    [anon_sym_BANG_EQ] = ACTIONS(436),
    [anon_sym_COLON_COLON] = ACTIONS(436),
    [anon_sym_LBRACE] = ACTIONS(434),
    [anon_sym_RBRACE] = ACTIONS(436),
    [sym_import_hash] = ACTIONS(436),
    [sym_local_import] = ACTIONS(436),
    [sym_http_raw] = ACTIONS(436),
    [aux_sym_env_import_token1] = ACTIONS(436),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(436),
    [anon_sym_DASHInfinity] = ACTIONS(436),
    [aux_sym_double_literal_token1] = ACTIONS(436),
    [sym_natural_literal] = ACTIONS(434),
    [sym_integer_literal] = ACTIONS(434),
    [anon_sym_DQUOTE] = ACTIONS(436),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(436),
    [anon_sym_LT] = ACTIONS(436),
    [anon_sym_PIPE] = ACTIONS(434),
    [anon_sym_GT] = ACTIONS(436),
    [anon_sym_True] = ACTIONS(434),
    [anon_sym_False] = ACTIONS(434),
  },
  [164] = {
    [sym_line_comment] = STATE(164),
    [sym_block_comment] = STATE(164),
    [sym_label] = ACTIONS(438),
    [anon_sym_COLON] = ACTIONS(438),
    [anon_sym_then] = ACTIONS(438),
    [anon_sym_else] = ACTIONS(438),
    [anon_sym_let] = ACTIONS(438),
    [anon_sym_in] = ACTIONS(438),
    [anon_sym_as] = ACTIONS(438),
    [anon_sym_missing] = ACTIONS(438),
    [anon_sym_Infinity] = ACTIONS(438),
    [anon_sym_NaN] = ACTIONS(438),
    [anon_sym_with] = ACTIONS(438),
    [anon_sym_Natural_SLASHfold] = ACTIONS(438),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(438),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(438),
    [anon_sym_Natural_SLASHeven] = ACTIONS(438),
    [anon_sym_Natural_SLASHodd] = ACTIONS(438),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(438),
    [anon_sym_Natural_SLASHshow] = ACTIONS(438),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(438),
    [anon_sym_Integer_SLASHshow] = ACTIONS(438),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(438),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(438),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(438),
    [anon_sym_Double_SLASHshow] = ACTIONS(438),
    [anon_sym_List_SLASHbuild] = ACTIONS(438),
    [anon_sym_List_SLASHfold] = ACTIONS(438),
    [anon_sym_List_SLASHlength] = ACTIONS(438),
    [anon_sym_List_SLASHhead] = ACTIONS(438),
    [anon_sym_List_SLASHlast] = ACTIONS(438),
    [anon_sym_List_SLASHindexed] = ACTIONS(438),
    [anon_sym_List_SLASHreverse] = ACTIONS(438),
    [anon_sym_Text_SLASHshow] = ACTIONS(438),
    [anon_sym_Text_SLASHreplace] = ACTIONS(438),
    [anon_sym_Bool] = ACTIONS(438),
    [anon_sym_Optional] = ACTIONS(438),
    [anon_sym_None] = ACTIONS(438),
    [anon_sym_Natural] = ACTIONS(438),
    [anon_sym_Integer] = ACTIONS(438),
    [anon_sym_Double] = ACTIONS(438),
    [anon_sym_Text] = ACTIONS(438),
    [anon_sym_Date] = ACTIONS(438),
    [anon_sym_Time] = ACTIONS(438),
    [anon_sym_TimeZone] = ACTIONS(438),
    [anon_sym_List] = ACTIONS(438),
    [anon_sym_Type] = ACTIONS(438),
    [anon_sym_Kind] = ACTIONS(438),
    [anon_sym_Sort] = ACTIONS(438),
    [anon_sym_LPAREN] = ACTIONS(440),
    [anon_sym_RPAREN] = ACTIONS(440),
    [anon_sym_2] = ACTIONS(440),
    [anon_sym_DASH_GT] = ACTIONS(440),
    [anon_sym_EQ] = ACTIONS(438),
    [anon_sym_DOT] = ACTIONS(438),
    [anon_sym_QMARK] = ACTIONS(440),
    [anon_sym_LBRACK] = ACTIONS(440),
    [anon_sym_COMMA] = ACTIONS(440),
    [anon_sym_RBRACK] = ACTIONS(440),
    [anon_sym_4] = ACTIONS(440),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(440),
    [anon_sym_PIPE_PIPE] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(438),
    [anon_sym_PLUS_PLUS] = ACTIONS(440),
    [anon_sym_POUND] = ACTIONS(440),
    [anon_sym_AMP_AMP] = ACTIONS(440),
    [anon_sym_5] = ACTIONS(440),
    [anon_sym_SLASH_BSLASH] = ACTIONS(440),
    [anon_sym_6] = ACTIONS(440),
    [anon_sym_SLASH_SLASH] = ACTIONS(438),
    [anon_sym_7] = ACTIONS(440),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(440),
    [anon_sym_STAR] = ACTIONS(440),
    [anon_sym_EQ_EQ] = ACTIONS(438),
    [anon_sym_BANG_EQ] = ACTIONS(440),
    [anon_sym_COLON_COLON] = ACTIONS(440),
    [anon_sym_LBRACE] = ACTIONS(438),
    [anon_sym_RBRACE] = ACTIONS(440),
    [sym_import_hash] = ACTIONS(440),
    [sym_local_import] = ACTIONS(440),
    [sym_http_raw] = ACTIONS(440),
    [aux_sym_env_import_token1] = ACTIONS(440),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(440),
    [anon_sym_DASHInfinity] = ACTIONS(440),
    [aux_sym_double_literal_token1] = ACTIONS(440),
    [sym_natural_literal] = ACTIONS(438),
    [sym_integer_literal] = ACTIONS(438),
    [anon_sym_DQUOTE] = ACTIONS(440),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(440),
    [anon_sym_LT] = ACTIONS(440),
    [anon_sym_PIPE] = ACTIONS(438),
    [anon_sym_GT] = ACTIONS(440),
    [anon_sym_True] = ACTIONS(438),
    [anon_sym_False] = ACTIONS(438),
  },
  [165] = {
    [sym_line_comment] = STATE(165),
    [sym_block_comment] = STATE(165),
    [sym_label] = ACTIONS(442),
    [anon_sym_COLON] = ACTIONS(442),
    [anon_sym_then] = ACTIONS(442),
    [anon_sym_else] = ACTIONS(442),
    [anon_sym_let] = ACTIONS(442),
    [anon_sym_in] = ACTIONS(442),
    [anon_sym_as] = ACTIONS(442),
    [anon_sym_missing] = ACTIONS(442),
    [anon_sym_Infinity] = ACTIONS(442),
    [anon_sym_NaN] = ACTIONS(442),
    [anon_sym_with] = ACTIONS(442),
    [anon_sym_Natural_SLASHfold] = ACTIONS(442),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(442),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(442),
    [anon_sym_Natural_SLASHeven] = ACTIONS(442),
    [anon_sym_Natural_SLASHodd] = ACTIONS(442),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(442),
    [anon_sym_Natural_SLASHshow] = ACTIONS(442),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(442),
    [anon_sym_Integer_SLASHshow] = ACTIONS(442),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(442),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(442),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(442),
    [anon_sym_Double_SLASHshow] = ACTIONS(442),
    [anon_sym_List_SLASHbuild] = ACTIONS(442),
    [anon_sym_List_SLASHfold] = ACTIONS(442),
    [anon_sym_List_SLASHlength] = ACTIONS(442),
    [anon_sym_List_SLASHhead] = ACTIONS(442),
    [anon_sym_List_SLASHlast] = ACTIONS(442),
    [anon_sym_List_SLASHindexed] = ACTIONS(442),
    [anon_sym_List_SLASHreverse] = ACTIONS(442),
    [anon_sym_Text_SLASHshow] = ACTIONS(442),
    [anon_sym_Text_SLASHreplace] = ACTIONS(442),
    [anon_sym_Bool] = ACTIONS(442),
    [anon_sym_Optional] = ACTIONS(442),
    [anon_sym_None] = ACTIONS(442),
    [anon_sym_Natural] = ACTIONS(442),
    [anon_sym_Integer] = ACTIONS(442),
    [anon_sym_Double] = ACTIONS(442),
    [anon_sym_Text] = ACTIONS(442),
    [anon_sym_Date] = ACTIONS(442),
    [anon_sym_Time] = ACTIONS(442),
    [anon_sym_TimeZone] = ACTIONS(442),
    [anon_sym_List] = ACTIONS(442),
    [anon_sym_Type] = ACTIONS(442),
    [anon_sym_Kind] = ACTIONS(442),
    [anon_sym_Sort] = ACTIONS(442),
    [anon_sym_LPAREN] = ACTIONS(444),
    [anon_sym_RPAREN] = ACTIONS(444),
    [anon_sym_2] = ACTIONS(444),
    [anon_sym_DASH_GT] = ACTIONS(444),
    [anon_sym_EQ] = ACTIONS(442),
    [anon_sym_DOT] = ACTIONS(442),
    [anon_sym_QMARK] = ACTIONS(444),
    [anon_sym_LBRACK] = ACTIONS(444),
    [anon_sym_COMMA] = ACTIONS(444),
    [anon_sym_RBRACK] = ACTIONS(444),
    [anon_sym_4] = ACTIONS(444),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(444),
    [anon_sym_PIPE_PIPE] = ACTIONS(444),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(444),
    [anon_sym_POUND] = ACTIONS(444),
    [anon_sym_AMP_AMP] = ACTIONS(444),
    [anon_sym_5] = ACTIONS(444),
    [anon_sym_SLASH_BSLASH] = ACTIONS(444),
    [anon_sym_6] = ACTIONS(444),
    [anon_sym_SLASH_SLASH] = ACTIONS(442),
    [anon_sym_7] = ACTIONS(444),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(444),
    [anon_sym_STAR] = ACTIONS(444),
    [anon_sym_EQ_EQ] = ACTIONS(442),
    [anon_sym_BANG_EQ] = ACTIONS(444),
    [anon_sym_COLON_COLON] = ACTIONS(444),
    [anon_sym_LBRACE] = ACTIONS(442),
    [anon_sym_RBRACE] = ACTIONS(444),
    [sym_import_hash] = ACTIONS(444),
    [sym_local_import] = ACTIONS(444),
    [sym_http_raw] = ACTIONS(444),
    [aux_sym_env_import_token1] = ACTIONS(444),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(444),
    [anon_sym_DASHInfinity] = ACTIONS(444),
    [aux_sym_double_literal_token1] = ACTIONS(444),
    [sym_natural_literal] = ACTIONS(442),
    [sym_integer_literal] = ACTIONS(442),
    [anon_sym_DQUOTE] = ACTIONS(444),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(444),
    [anon_sym_LT] = ACTIONS(444),
    [anon_sym_PIPE] = ACTIONS(442),
    [anon_sym_GT] = ACTIONS(444),
    [anon_sym_True] = ACTIONS(442),
    [anon_sym_False] = ACTIONS(442),
  },
  [166] = {
    [sym_line_comment] = STATE(166),
    [sym_block_comment] = STATE(166),
    [sym_label] = ACTIONS(446),
    [anon_sym_COLON] = ACTIONS(446),
    [anon_sym_then] = ACTIONS(446),
    [anon_sym_else] = ACTIONS(446),
    [anon_sym_let] = ACTIONS(446),
    [anon_sym_in] = ACTIONS(446),
    [anon_sym_as] = ACTIONS(446),
    [anon_sym_missing] = ACTIONS(446),
    [anon_sym_Infinity] = ACTIONS(446),
    [anon_sym_NaN] = ACTIONS(446),
    [anon_sym_with] = ACTIONS(446),
    [anon_sym_Natural_SLASHfold] = ACTIONS(446),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(446),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(446),
    [anon_sym_Natural_SLASHeven] = ACTIONS(446),
    [anon_sym_Natural_SLASHodd] = ACTIONS(446),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(446),
    [anon_sym_Natural_SLASHshow] = ACTIONS(446),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(446),
    [anon_sym_Integer_SLASHshow] = ACTIONS(446),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(446),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(446),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(446),
    [anon_sym_Double_SLASHshow] = ACTIONS(446),
    [anon_sym_List_SLASHbuild] = ACTIONS(446),
    [anon_sym_List_SLASHfold] = ACTIONS(446),
    [anon_sym_List_SLASHlength] = ACTIONS(446),
    [anon_sym_List_SLASHhead] = ACTIONS(446),
    [anon_sym_List_SLASHlast] = ACTIONS(446),
    [anon_sym_List_SLASHindexed] = ACTIONS(446),
    [anon_sym_List_SLASHreverse] = ACTIONS(446),
    [anon_sym_Text_SLASHshow] = ACTIONS(446),
    [anon_sym_Text_SLASHreplace] = ACTIONS(446),
    [anon_sym_Bool] = ACTIONS(446),
    [anon_sym_Optional] = ACTIONS(446),
    [anon_sym_None] = ACTIONS(446),
    [anon_sym_Natural] = ACTIONS(446),
    [anon_sym_Integer] = ACTIONS(446),
    [anon_sym_Double] = ACTIONS(446),
    [anon_sym_Text] = ACTIONS(446),
    [anon_sym_Date] = ACTIONS(446),
    [anon_sym_Time] = ACTIONS(446),
    [anon_sym_TimeZone] = ACTIONS(446),
    [anon_sym_List] = ACTIONS(446),
    [anon_sym_Type] = ACTIONS(446),
    [anon_sym_Kind] = ACTIONS(446),
    [anon_sym_Sort] = ACTIONS(446),
    [anon_sym_LPAREN] = ACTIONS(448),
    [anon_sym_RPAREN] = ACTIONS(448),
    [anon_sym_2] = ACTIONS(448),
    [anon_sym_DASH_GT] = ACTIONS(448),
    [anon_sym_EQ] = ACTIONS(446),
    [anon_sym_DOT] = ACTIONS(446),
    [anon_sym_QMARK] = ACTIONS(448),
    [anon_sym_LBRACK] = ACTIONS(448),
    [anon_sym_COMMA] = ACTIONS(448),
    [anon_sym_RBRACK] = ACTIONS(448),
    [anon_sym_4] = ACTIONS(448),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(448),
    [anon_sym_PIPE_PIPE] = ACTIONS(448),
    [anon_sym_PLUS] = ACTIONS(446),
    [anon_sym_PLUS_PLUS] = ACTIONS(448),
    [anon_sym_POUND] = ACTIONS(448),
    [anon_sym_AMP_AMP] = ACTIONS(448),
    [anon_sym_5] = ACTIONS(448),
    [anon_sym_SLASH_BSLASH] = ACTIONS(448),
    [anon_sym_6] = ACTIONS(448),
    [anon_sym_SLASH_SLASH] = ACTIONS(446),
    [anon_sym_7] = ACTIONS(448),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(448),
    [anon_sym_STAR] = ACTIONS(448),
    [anon_sym_EQ_EQ] = ACTIONS(446),
    [anon_sym_BANG_EQ] = ACTIONS(448),
    [anon_sym_COLON_COLON] = ACTIONS(448),
    [anon_sym_LBRACE] = ACTIONS(446),
    [anon_sym_RBRACE] = ACTIONS(448),
    [sym_import_hash] = ACTIONS(448),
    [sym_local_import] = ACTIONS(448),
    [sym_http_raw] = ACTIONS(448),
    [aux_sym_env_import_token1] = ACTIONS(448),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(448),
    [anon_sym_DASHInfinity] = ACTIONS(448),
    [aux_sym_double_literal_token1] = ACTIONS(448),
    [sym_natural_literal] = ACTIONS(446),
    [sym_integer_literal] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(448),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(448),
    [anon_sym_LT] = ACTIONS(448),
    [anon_sym_PIPE] = ACTIONS(446),
    [anon_sym_GT] = ACTIONS(448),
    [anon_sym_True] = ACTIONS(446),
    [anon_sym_False] = ACTIONS(446),
  },
  [167] = {
    [sym_line_comment] = STATE(167),
    [sym_block_comment] = STATE(167),
    [aux_sym_selector_repeat1] = STATE(169),
    [sym_label] = ACTIONS(286),
    [anon_sym_COLON] = ACTIONS(286),
    [anon_sym_then] = ACTIONS(286),
    [anon_sym_else] = ACTIONS(286),
    [anon_sym_let] = ACTIONS(286),
    [anon_sym_in] = ACTIONS(286),
    [anon_sym_missing] = ACTIONS(286),
    [anon_sym_Infinity] = ACTIONS(286),
    [anon_sym_NaN] = ACTIONS(286),
    [anon_sym_with] = ACTIONS(286),
    [anon_sym_Natural_SLASHfold] = ACTIONS(286),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(286),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(286),
    [anon_sym_Natural_SLASHeven] = ACTIONS(286),
    [anon_sym_Natural_SLASHodd] = ACTIONS(286),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(286),
    [anon_sym_Natural_SLASHshow] = ACTIONS(286),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(286),
    [anon_sym_Integer_SLASHshow] = ACTIONS(286),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(286),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(286),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(286),
    [anon_sym_Double_SLASHshow] = ACTIONS(286),
    [anon_sym_List_SLASHbuild] = ACTIONS(286),
    [anon_sym_List_SLASHfold] = ACTIONS(286),
    [anon_sym_List_SLASHlength] = ACTIONS(286),
    [anon_sym_List_SLASHhead] = ACTIONS(286),
    [anon_sym_List_SLASHlast] = ACTIONS(286),
    [anon_sym_List_SLASHindexed] = ACTIONS(286),
    [anon_sym_List_SLASHreverse] = ACTIONS(286),
    [anon_sym_Text_SLASHshow] = ACTIONS(286),
    [anon_sym_Text_SLASHreplace] = ACTIONS(286),
    [anon_sym_Bool] = ACTIONS(286),
    [anon_sym_Optional] = ACTIONS(286),
    [anon_sym_None] = ACTIONS(286),
    [anon_sym_Natural] = ACTIONS(286),
    [anon_sym_Integer] = ACTIONS(286),
    [anon_sym_Double] = ACTIONS(286),
    [anon_sym_Text] = ACTIONS(286),
    [anon_sym_Date] = ACTIONS(286),
    [anon_sym_Time] = ACTIONS(286),
    [anon_sym_TimeZone] = ACTIONS(286),
    [anon_sym_List] = ACTIONS(286),
    [anon_sym_Type] = ACTIONS(286),
    [anon_sym_Kind] = ACTIONS(286),
    [anon_sym_Sort] = ACTIONS(286),
    [anon_sym_LPAREN] = ACTIONS(288),
    [anon_sym_RPAREN] = ACTIONS(288),
    [anon_sym_2] = ACTIONS(288),
    [anon_sym_DASH_GT] = ACTIONS(288),
    [anon_sym_EQ] = ACTIONS(286),
    [anon_sym_DOT] = ACTIONS(390),
    [anon_sym_QMARK] = ACTIONS(288),
    [anon_sym_LBRACK] = ACTIONS(288),
    [anon_sym_COMMA] = ACTIONS(288),
    [anon_sym_RBRACK] = ACTIONS(288),
    [anon_sym_4] = ACTIONS(288),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(288),
    [anon_sym_PIPE_PIPE] = ACTIONS(288),
    [anon_sym_PLUS] = ACTIONS(286),
    [anon_sym_PLUS_PLUS] = ACTIONS(288),
    [anon_sym_POUND] = ACTIONS(288),
    [anon_sym_AMP_AMP] = ACTIONS(288),
    [anon_sym_5] = ACTIONS(288),
    [anon_sym_SLASH_BSLASH] = ACTIONS(288),
    [anon_sym_6] = ACTIONS(288),
    [anon_sym_SLASH_SLASH] = ACTIONS(286),
    [anon_sym_7] = ACTIONS(288),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(288),
    [anon_sym_STAR] = ACTIONS(288),
    [anon_sym_EQ_EQ] = ACTIONS(286),
    [anon_sym_BANG_EQ] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(288),
    [anon_sym_LBRACE] = ACTIONS(286),
    [anon_sym_RBRACE] = ACTIONS(288),
    [sym_local_import] = ACTIONS(288),
    [sym_http_raw] = ACTIONS(288),
    [aux_sym_env_import_token1] = ACTIONS(288),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(288),
    [anon_sym_DASHInfinity] = ACTIONS(288),
    [aux_sym_double_literal_token1] = ACTIONS(288),
    [sym_natural_literal] = ACTIONS(286),
    [sym_integer_literal] = ACTIONS(286),
    [anon_sym_DQUOTE] = ACTIONS(288),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(288),
    [anon_sym_LT] = ACTIONS(288),
    [anon_sym_PIPE] = ACTIONS(286),
    [anon_sym_GT] = ACTIONS(288),
    [anon_sym_True] = ACTIONS(286),
    [anon_sym_False] = ACTIONS(286),
  },
  [168] = {
    [sym_line_comment] = STATE(168),
    [sym_block_comment] = STATE(168),
    [sym_label] = ACTIONS(450),
    [anon_sym_COLON] = ACTIONS(450),
    [anon_sym_then] = ACTIONS(450),
    [anon_sym_else] = ACTIONS(450),
    [anon_sym_let] = ACTIONS(450),
    [anon_sym_in] = ACTIONS(450),
    [anon_sym_as] = ACTIONS(450),
    [anon_sym_missing] = ACTIONS(450),
    [anon_sym_Infinity] = ACTIONS(450),
    [anon_sym_NaN] = ACTIONS(450),
    [anon_sym_with] = ACTIONS(450),
    [anon_sym_Natural_SLASHfold] = ACTIONS(450),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(450),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(450),
    [anon_sym_Natural_SLASHeven] = ACTIONS(450),
    [anon_sym_Natural_SLASHodd] = ACTIONS(450),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(450),
    [anon_sym_Natural_SLASHshow] = ACTIONS(450),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(450),
    [anon_sym_Integer_SLASHshow] = ACTIONS(450),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(450),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(450),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(450),
    [anon_sym_Double_SLASHshow] = ACTIONS(450),
    [anon_sym_List_SLASHbuild] = ACTIONS(450),
    [anon_sym_List_SLASHfold] = ACTIONS(450),
    [anon_sym_List_SLASHlength] = ACTIONS(450),
    [anon_sym_List_SLASHhead] = ACTIONS(450),
    [anon_sym_List_SLASHlast] = ACTIONS(450),
    [anon_sym_List_SLASHindexed] = ACTIONS(450),
    [anon_sym_List_SLASHreverse] = ACTIONS(450),
    [anon_sym_Text_SLASHshow] = ACTIONS(450),
    [anon_sym_Text_SLASHreplace] = ACTIONS(450),
    [anon_sym_Bool] = ACTIONS(450),
    [anon_sym_Optional] = ACTIONS(450),
    [anon_sym_None] = ACTIONS(450),
    [anon_sym_Natural] = ACTIONS(450),
    [anon_sym_Integer] = ACTIONS(450),
    [anon_sym_Double] = ACTIONS(450),
    [anon_sym_Text] = ACTIONS(450),
    [anon_sym_Date] = ACTIONS(450),
    [anon_sym_Time] = ACTIONS(450),
    [anon_sym_TimeZone] = ACTIONS(450),
    [anon_sym_List] = ACTIONS(450),
    [anon_sym_Type] = ACTIONS(450),
    [anon_sym_Kind] = ACTIONS(450),
    [anon_sym_Sort] = ACTIONS(450),
    [anon_sym_LPAREN] = ACTIONS(452),
    [anon_sym_RPAREN] = ACTIONS(452),
    [anon_sym_2] = ACTIONS(452),
    [anon_sym_DASH_GT] = ACTIONS(452),
    [anon_sym_EQ] = ACTIONS(450),
    [anon_sym_QMARK] = ACTIONS(452),
    [anon_sym_LBRACK] = ACTIONS(452),
    [anon_sym_COMMA] = ACTIONS(452),
    [anon_sym_RBRACK] = ACTIONS(452),
    [anon_sym_4] = ACTIONS(452),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(452),
    [anon_sym_PIPE_PIPE] = ACTIONS(452),
    [anon_sym_PLUS] = ACTIONS(450),
    [anon_sym_PLUS_PLUS] = ACTIONS(452),
    [anon_sym_POUND] = ACTIONS(452),
    [anon_sym_AMP_AMP] = ACTIONS(452),
    [anon_sym_5] = ACTIONS(452),
    [anon_sym_SLASH_BSLASH] = ACTIONS(452),
    [anon_sym_6] = ACTIONS(452),
    [anon_sym_SLASH_SLASH] = ACTIONS(450),
    [anon_sym_7] = ACTIONS(452),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(452),
    [anon_sym_STAR] = ACTIONS(452),
    [anon_sym_EQ_EQ] = ACTIONS(450),
    [anon_sym_BANG_EQ] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(450),
    [anon_sym_RBRACE] = ACTIONS(452),
    [sym_import_hash] = ACTIONS(452),
    [sym_local_import] = ACTIONS(452),
    [sym_http_raw] = ACTIONS(452),
    [aux_sym_env_import_token1] = ACTIONS(452),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(452),
    [anon_sym_DASHInfinity] = ACTIONS(452),
    [aux_sym_double_literal_token1] = ACTIONS(452),
    [sym_natural_literal] = ACTIONS(450),
    [sym_integer_literal] = ACTIONS(450),
    [anon_sym_DQUOTE] = ACTIONS(452),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(452),
    [anon_sym_LT] = ACTIONS(452),
    [anon_sym_PIPE] = ACTIONS(450),
    [anon_sym_GT] = ACTIONS(452),
    [anon_sym_True] = ACTIONS(450),
    [anon_sym_False] = ACTIONS(450),
  },
  [169] = {
    [sym_line_comment] = STATE(169),
    [sym_block_comment] = STATE(169),
    [aux_sym_selector_repeat1] = STATE(169),
    [sym_label] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_then] = ACTIONS(279),
    [anon_sym_else] = ACTIONS(279),
    [anon_sym_let] = ACTIONS(279),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_missing] = ACTIONS(279),
    [anon_sym_Infinity] = ACTIONS(279),
    [anon_sym_NaN] = ACTIONS(279),
    [anon_sym_with] = ACTIONS(279),
    [anon_sym_Natural_SLASHfold] = ACTIONS(279),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(279),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(279),
    [anon_sym_Natural_SLASHeven] = ACTIONS(279),
    [anon_sym_Natural_SLASHodd] = ACTIONS(279),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(279),
    [anon_sym_Natural_SLASHshow] = ACTIONS(279),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(279),
    [anon_sym_Integer_SLASHshow] = ACTIONS(279),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(279),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(279),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(279),
    [anon_sym_Double_SLASHshow] = ACTIONS(279),
    [anon_sym_List_SLASHbuild] = ACTIONS(279),
    [anon_sym_List_SLASHfold] = ACTIONS(279),
    [anon_sym_List_SLASHlength] = ACTIONS(279),
    [anon_sym_List_SLASHhead] = ACTIONS(279),
    [anon_sym_List_SLASHlast] = ACTIONS(279),
    [anon_sym_List_SLASHindexed] = ACTIONS(279),
    [anon_sym_List_SLASHreverse] = ACTIONS(279),
    [anon_sym_Text_SLASHshow] = ACTIONS(279),
    [anon_sym_Text_SLASHreplace] = ACTIONS(279),
    [anon_sym_Bool] = ACTIONS(279),
    [anon_sym_Optional] = ACTIONS(279),
    [anon_sym_None] = ACTIONS(279),
    [anon_sym_Natural] = ACTIONS(279),
    [anon_sym_Integer] = ACTIONS(279),
    [anon_sym_Double] = ACTIONS(279),
    [anon_sym_Text] = ACTIONS(279),
    [anon_sym_Date] = ACTIONS(279),
    [anon_sym_Time] = ACTIONS(279),
    [anon_sym_TimeZone] = ACTIONS(279),
    [anon_sym_List] = ACTIONS(279),
    [anon_sym_Type] = ACTIONS(279),
    [anon_sym_Kind] = ACTIONS(279),
    [anon_sym_Sort] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(281),
    [anon_sym_RPAREN] = ACTIONS(281),
    [anon_sym_2] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_DOT] = ACTIONS(454),
    [anon_sym_QMARK] = ACTIONS(281),
    [anon_sym_LBRACK] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(281),
    [anon_sym_RBRACK] = ACTIONS(281),
    [anon_sym_4] = ACTIONS(281),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(281),
    [anon_sym_PIPE_PIPE] = ACTIONS(281),
    [anon_sym_PLUS] = ACTIONS(279),
    [anon_sym_PLUS_PLUS] = ACTIONS(281),
    [anon_sym_POUND] = ACTIONS(281),
    [anon_sym_AMP_AMP] = ACTIONS(281),
    [anon_sym_5] = ACTIONS(281),
    [anon_sym_SLASH_BSLASH] = ACTIONS(281),
    [anon_sym_6] = ACTIONS(281),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_7] = ACTIONS(281),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(281),
    [anon_sym_STAR] = ACTIONS(281),
    [anon_sym_EQ_EQ] = ACTIONS(279),
    [anon_sym_BANG_EQ] = ACTIONS(281),
    [anon_sym_COLON_COLON] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(279),
    [anon_sym_RBRACE] = ACTIONS(281),
    [sym_local_import] = ACTIONS(281),
    [sym_http_raw] = ACTIONS(281),
    [aux_sym_env_import_token1] = ACTIONS(281),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(281),
    [anon_sym_DASHInfinity] = ACTIONS(281),
    [aux_sym_double_literal_token1] = ACTIONS(281),
    [sym_natural_literal] = ACTIONS(279),
    [sym_integer_literal] = ACTIONS(279),
    [anon_sym_DQUOTE] = ACTIONS(281),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(281),
    [anon_sym_LT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_GT] = ACTIONS(281),
    [anon_sym_True] = ACTIONS(279),
    [anon_sym_False] = ACTIONS(279),
  },
  [170] = {
    [sym_line_comment] = STATE(170),
    [sym_block_comment] = STATE(170),
    [sym_label] = ACTIONS(457),
    [anon_sym_COLON] = ACTIONS(459),
    [anon_sym_then] = ACTIONS(457),
    [anon_sym_else] = ACTIONS(457),
    [anon_sym_let] = ACTIONS(457),
    [anon_sym_in] = ACTIONS(457),
    [anon_sym_as] = ACTIONS(457),
    [anon_sym_using] = ACTIONS(461),
    [anon_sym_missing] = ACTIONS(457),
    [anon_sym_Infinity] = ACTIONS(457),
    [anon_sym_NaN] = ACTIONS(457),
    [anon_sym_with] = ACTIONS(457),
    [anon_sym_Natural_SLASHfold] = ACTIONS(457),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(457),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(457),
    [anon_sym_Natural_SLASHeven] = ACTIONS(457),
    [anon_sym_Natural_SLASHodd] = ACTIONS(457),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(457),
    [anon_sym_Natural_SLASHshow] = ACTIONS(457),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(457),
    [anon_sym_Integer_SLASHshow] = ACTIONS(457),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(457),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(457),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(457),
    [anon_sym_Double_SLASHshow] = ACTIONS(457),
    [anon_sym_List_SLASHbuild] = ACTIONS(457),
    [anon_sym_List_SLASHfold] = ACTIONS(457),
    [anon_sym_List_SLASHlength] = ACTIONS(457),
    [anon_sym_List_SLASHhead] = ACTIONS(457),
    [anon_sym_List_SLASHlast] = ACTIONS(457),
    [anon_sym_List_SLASHindexed] = ACTIONS(457),
    [anon_sym_List_SLASHreverse] = ACTIONS(457),
    [anon_sym_Text_SLASHshow] = ACTIONS(457),
    [anon_sym_Text_SLASHreplace] = ACTIONS(457),
    [anon_sym_Bool] = ACTIONS(457),
    [anon_sym_Optional] = ACTIONS(457),
    [anon_sym_None] = ACTIONS(457),
    [anon_sym_Natural] = ACTIONS(457),
    [anon_sym_Integer] = ACTIONS(457),
    [anon_sym_Double] = ACTIONS(457),
    [anon_sym_Text] = ACTIONS(457),
    [anon_sym_Date] = ACTIONS(457),
    [anon_sym_Time] = ACTIONS(457),
    [anon_sym_TimeZone] = ACTIONS(457),
    [anon_sym_List] = ACTIONS(457),
    [anon_sym_Type] = ACTIONS(457),
    [anon_sym_Kind] = ACTIONS(457),
    [anon_sym_Sort] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(459),
    [anon_sym_RPAREN] = ACTIONS(459),
    [anon_sym_2] = ACTIONS(459),
    [anon_sym_DASH_GT] = ACTIONS(459),
    [anon_sym_EQ] = ACTIONS(457),
    [anon_sym_QMARK] = ACTIONS(459),
    [anon_sym_LBRACK] = ACTIONS(459),
    [anon_sym_COMMA] = ACTIONS(459),
    [anon_sym_RBRACK] = ACTIONS(459),
    [anon_sym_4] = ACTIONS(459),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(459),
    [anon_sym_PIPE_PIPE] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(459),
    [anon_sym_POUND] = ACTIONS(459),
    [anon_sym_AMP_AMP] = ACTIONS(459),
    [anon_sym_5] = ACTIONS(459),
    [anon_sym_SLASH_BSLASH] = ACTIONS(459),
    [anon_sym_6] = ACTIONS(459),
    [anon_sym_SLASH_SLASH] = ACTIONS(457),
    [anon_sym_7] = ACTIONS(459),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(459),
    [anon_sym_STAR] = ACTIONS(459),
    [anon_sym_EQ_EQ] = ACTIONS(457),
    [anon_sym_BANG_EQ] = ACTIONS(459),
    [anon_sym_LBRACE] = ACTIONS(457),
    [anon_sym_RBRACE] = ACTIONS(459),
    [sym_import_hash] = ACTIONS(459),
    [sym_local_import] = ACTIONS(459),
    [sym_http_raw] = ACTIONS(459),
    [aux_sym_env_import_token1] = ACTIONS(459),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(459),
    [anon_sym_DASHInfinity] = ACTIONS(459),
    [aux_sym_double_literal_token1] = ACTIONS(459),
    [sym_natural_literal] = ACTIONS(457),
    [sym_integer_literal] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(459),
    [anon_sym_LT] = ACTIONS(459),
    [anon_sym_PIPE] = ACTIONS(457),
    [anon_sym_GT] = ACTIONS(459),
    [anon_sym_True] = ACTIONS(457),
    [anon_sym_False] = ACTIONS(457),
  },
  [171] = {
    [sym_line_comment] = STATE(171),
    [sym_block_comment] = STATE(171),
    [sym_label] = ACTIONS(463),
    [anon_sym_COLON] = ACTIONS(463),
    [anon_sym_then] = ACTIONS(463),
    [anon_sym_else] = ACTIONS(463),
    [anon_sym_let] = ACTIONS(463),
    [anon_sym_in] = ACTIONS(463),
    [anon_sym_as] = ACTIONS(463),
    [anon_sym_missing] = ACTIONS(463),
    [anon_sym_Infinity] = ACTIONS(463),
    [anon_sym_NaN] = ACTIONS(463),
    [anon_sym_with] = ACTIONS(463),
    [anon_sym_Natural_SLASHfold] = ACTIONS(463),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(463),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(463),
    [anon_sym_Natural_SLASHeven] = ACTIONS(463),
    [anon_sym_Natural_SLASHodd] = ACTIONS(463),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(463),
    [anon_sym_Natural_SLASHshow] = ACTIONS(463),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(463),
    [anon_sym_Integer_SLASHshow] = ACTIONS(463),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(463),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(463),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(463),
    [anon_sym_Double_SLASHshow] = ACTIONS(463),
    [anon_sym_List_SLASHbuild] = ACTIONS(463),
    [anon_sym_List_SLASHfold] = ACTIONS(463),
    [anon_sym_List_SLASHlength] = ACTIONS(463),
    [anon_sym_List_SLASHhead] = ACTIONS(463),
    [anon_sym_List_SLASHlast] = ACTIONS(463),
    [anon_sym_List_SLASHindexed] = ACTIONS(463),
    [anon_sym_List_SLASHreverse] = ACTIONS(463),
    [anon_sym_Text_SLASHshow] = ACTIONS(463),
    [anon_sym_Text_SLASHreplace] = ACTIONS(463),
    [anon_sym_Bool] = ACTIONS(463),
    [anon_sym_Optional] = ACTIONS(463),
    [anon_sym_None] = ACTIONS(463),
    [anon_sym_Natural] = ACTIONS(463),
    [anon_sym_Integer] = ACTIONS(463),
    [anon_sym_Double] = ACTIONS(463),
    [anon_sym_Text] = ACTIONS(463),
    [anon_sym_Date] = ACTIONS(463),
    [anon_sym_Time] = ACTIONS(463),
    [anon_sym_TimeZone] = ACTIONS(463),
    [anon_sym_List] = ACTIONS(463),
    [anon_sym_Type] = ACTIONS(463),
    [anon_sym_Kind] = ACTIONS(463),
    [anon_sym_Sort] = ACTIONS(463),
    [anon_sym_LPAREN] = ACTIONS(465),
    [anon_sym_RPAREN] = ACTIONS(465),
    [anon_sym_2] = ACTIONS(465),
    [anon_sym_DASH_GT] = ACTIONS(465),
    [anon_sym_EQ] = ACTIONS(463),
    [anon_sym_QMARK] = ACTIONS(465),
    [anon_sym_LBRACK] = ACTIONS(465),
    [anon_sym_COMMA] = ACTIONS(465),
    [anon_sym_RBRACK] = ACTIONS(465),
    [anon_sym_4] = ACTIONS(465),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(465),
    [anon_sym_PIPE_PIPE] = ACTIONS(465),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_POUND] = ACTIONS(465),
    [anon_sym_AMP_AMP] = ACTIONS(465),
    [anon_sym_5] = ACTIONS(465),
    [anon_sym_SLASH_BSLASH] = ACTIONS(465),
    [anon_sym_6] = ACTIONS(465),
    [anon_sym_SLASH_SLASH] = ACTIONS(463),
    [anon_sym_7] = ACTIONS(465),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(465),
    [anon_sym_STAR] = ACTIONS(465),
    [anon_sym_EQ_EQ] = ACTIONS(463),
    [anon_sym_BANG_EQ] = ACTIONS(465),
    [anon_sym_COLON_COLON] = ACTIONS(465),
    [anon_sym_LBRACE] = ACTIONS(463),
    [anon_sym_RBRACE] = ACTIONS(465),
    [sym_import_hash] = ACTIONS(465),
    [sym_local_import] = ACTIONS(465),
    [sym_http_raw] = ACTIONS(465),
    [aux_sym_env_import_token1] = ACTIONS(465),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(465),
    [anon_sym_DASHInfinity] = ACTIONS(465),
    [aux_sym_double_literal_token1] = ACTIONS(465),
    [sym_natural_literal] = ACTIONS(463),
    [sym_integer_literal] = ACTIONS(463),
    [anon_sym_DQUOTE] = ACTIONS(465),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(465),
    [anon_sym_LT] = ACTIONS(465),
    [anon_sym_PIPE] = ACTIONS(463),
    [anon_sym_GT] = ACTIONS(465),
    [anon_sym_True] = ACTIONS(463),
    [anon_sym_False] = ACTIONS(463),
  },
  [172] = {
    [sym_line_comment] = STATE(172),
    [sym_block_comment] = STATE(172),
    [sym_label] = ACTIONS(467),
    [anon_sym_COLON] = ACTIONS(467),
    [anon_sym_then] = ACTIONS(467),
    [anon_sym_else] = ACTIONS(467),
    [anon_sym_let] = ACTIONS(467),
    [anon_sym_in] = ACTIONS(467),
    [anon_sym_as] = ACTIONS(467),
    [anon_sym_missing] = ACTIONS(467),
    [anon_sym_Infinity] = ACTIONS(467),
    [anon_sym_NaN] = ACTIONS(467),
    [anon_sym_with] = ACTIONS(467),
    [anon_sym_Natural_SLASHfold] = ACTIONS(467),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(467),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(467),
    [anon_sym_Natural_SLASHeven] = ACTIONS(467),
    [anon_sym_Natural_SLASHodd] = ACTIONS(467),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(467),
    [anon_sym_Natural_SLASHshow] = ACTIONS(467),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(467),
    [anon_sym_Integer_SLASHshow] = ACTIONS(467),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(467),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(467),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(467),
    [anon_sym_Double_SLASHshow] = ACTIONS(467),
    [anon_sym_List_SLASHbuild] = ACTIONS(467),
    [anon_sym_List_SLASHfold] = ACTIONS(467),
    [anon_sym_List_SLASHlength] = ACTIONS(467),
    [anon_sym_List_SLASHhead] = ACTIONS(467),
    [anon_sym_List_SLASHlast] = ACTIONS(467),
    [anon_sym_List_SLASHindexed] = ACTIONS(467),
    [anon_sym_List_SLASHreverse] = ACTIONS(467),
    [anon_sym_Text_SLASHshow] = ACTIONS(467),
    [anon_sym_Text_SLASHreplace] = ACTIONS(467),
    [anon_sym_Bool] = ACTIONS(467),
    [anon_sym_Optional] = ACTIONS(467),
    [anon_sym_None] = ACTIONS(467),
    [anon_sym_Natural] = ACTIONS(467),
    [anon_sym_Integer] = ACTIONS(467),
    [anon_sym_Double] = ACTIONS(467),
    [anon_sym_Text] = ACTIONS(467),
    [anon_sym_Date] = ACTIONS(467),
    [anon_sym_Time] = ACTIONS(467),
    [anon_sym_TimeZone] = ACTIONS(467),
    [anon_sym_List] = ACTIONS(467),
    [anon_sym_Type] = ACTIONS(467),
    [anon_sym_Kind] = ACTIONS(467),
    [anon_sym_Sort] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_RPAREN] = ACTIONS(469),
    [anon_sym_2] = ACTIONS(469),
    [anon_sym_DASH_GT] = ACTIONS(469),
    [anon_sym_EQ] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_LBRACK] = ACTIONS(469),
    [anon_sym_COMMA] = ACTIONS(469),
    [anon_sym_RBRACK] = ACTIONS(469),
    [anon_sym_4] = ACTIONS(469),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(469),
    [anon_sym_PIPE_PIPE] = ACTIONS(469),
    [anon_sym_PLUS] = ACTIONS(467),
    [anon_sym_PLUS_PLUS] = ACTIONS(469),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_AMP_AMP] = ACTIONS(469),
    [anon_sym_5] = ACTIONS(469),
    [anon_sym_SLASH_BSLASH] = ACTIONS(469),
    [anon_sym_6] = ACTIONS(469),
    [anon_sym_SLASH_SLASH] = ACTIONS(467),
    [anon_sym_7] = ACTIONS(469),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(469),
    [anon_sym_STAR] = ACTIONS(469),
    [anon_sym_EQ_EQ] = ACTIONS(467),
    [anon_sym_BANG_EQ] = ACTIONS(469),
    [anon_sym_COLON_COLON] = ACTIONS(471),
    [anon_sym_LBRACE] = ACTIONS(467),
    [anon_sym_RBRACE] = ACTIONS(469),
    [sym_import_hash] = ACTIONS(469),
    [sym_local_import] = ACTIONS(469),
    [sym_http_raw] = ACTIONS(469),
    [aux_sym_env_import_token1] = ACTIONS(469),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(469),
    [anon_sym_DASHInfinity] = ACTIONS(469),
    [aux_sym_double_literal_token1] = ACTIONS(469),
    [sym_natural_literal] = ACTIONS(467),
    [sym_integer_literal] = ACTIONS(467),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(469),
    [anon_sym_LT] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(467),
    [anon_sym_GT] = ACTIONS(469),
    [anon_sym_True] = ACTIONS(467),
    [anon_sym_False] = ACTIONS(467),
  },
  [173] = {
    [sym_line_comment] = STATE(173),
    [sym_block_comment] = STATE(173),
    [sym_label] = ACTIONS(386),
    [anon_sym_COLON] = ACTIONS(386),
    [anon_sym_then] = ACTIONS(386),
    [anon_sym_else] = ACTIONS(386),
    [anon_sym_let] = ACTIONS(386),
    [anon_sym_in] = ACTIONS(386),
    [anon_sym_missing] = ACTIONS(386),
    [anon_sym_Infinity] = ACTIONS(386),
    [anon_sym_NaN] = ACTIONS(386),
    [anon_sym_with] = ACTIONS(386),
    [anon_sym_Natural_SLASHfold] = ACTIONS(386),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(386),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(386),
    [anon_sym_Natural_SLASHeven] = ACTIONS(386),
    [anon_sym_Natural_SLASHodd] = ACTIONS(386),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(386),
    [anon_sym_Natural_SLASHshow] = ACTIONS(386),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(386),
    [anon_sym_Integer_SLASHshow] = ACTIONS(386),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(386),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(386),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(386),
    [anon_sym_Double_SLASHshow] = ACTIONS(386),
    [anon_sym_List_SLASHbuild] = ACTIONS(386),
    [anon_sym_List_SLASHfold] = ACTIONS(386),
    [anon_sym_List_SLASHlength] = ACTIONS(386),
    [anon_sym_List_SLASHhead] = ACTIONS(386),
    [anon_sym_List_SLASHlast] = ACTIONS(386),
    [anon_sym_List_SLASHindexed] = ACTIONS(386),
    [anon_sym_List_SLASHreverse] = ACTIONS(386),
    [anon_sym_Text_SLASHshow] = ACTIONS(386),
    [anon_sym_Text_SLASHreplace] = ACTIONS(386),
    [anon_sym_Bool] = ACTIONS(386),
    [anon_sym_Optional] = ACTIONS(386),
    [anon_sym_None] = ACTIONS(386),
    [anon_sym_Natural] = ACTIONS(386),
    [anon_sym_Integer] = ACTIONS(386),
    [anon_sym_Double] = ACTIONS(386),
    [anon_sym_Text] = ACTIONS(386),
    [anon_sym_Date] = ACTIONS(386),
    [anon_sym_Time] = ACTIONS(386),
    [anon_sym_TimeZone] = ACTIONS(386),
    [anon_sym_List] = ACTIONS(386),
    [anon_sym_Type] = ACTIONS(386),
    [anon_sym_Kind] = ACTIONS(386),
    [anon_sym_Sort] = ACTIONS(386),
    [anon_sym_LPAREN] = ACTIONS(388),
    [anon_sym_RPAREN] = ACTIONS(388),
    [anon_sym_2] = ACTIONS(388),
    [anon_sym_DASH_GT] = ACTIONS(388),
    [anon_sym_EQ] = ACTIONS(386),
    [anon_sym_DOT] = ACTIONS(386),
    [anon_sym_QMARK] = ACTIONS(388),
    [anon_sym_LBRACK] = ACTIONS(388),
    [anon_sym_COMMA] = ACTIONS(388),
    [anon_sym_RBRACK] = ACTIONS(388),
    [anon_sym_4] = ACTIONS(388),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(388),
    [anon_sym_PIPE_PIPE] = ACTIONS(388),
    [anon_sym_PLUS] = ACTIONS(386),
    [anon_sym_PLUS_PLUS] = ACTIONS(388),
    [anon_sym_POUND] = ACTIONS(388),
    [anon_sym_AMP_AMP] = ACTIONS(388),
    [anon_sym_5] = ACTIONS(388),
    [anon_sym_SLASH_BSLASH] = ACTIONS(388),
    [anon_sym_6] = ACTIONS(388),
    [anon_sym_SLASH_SLASH] = ACTIONS(386),
    [anon_sym_7] = ACTIONS(388),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(388),
    [anon_sym_STAR] = ACTIONS(388),
    [anon_sym_EQ_EQ] = ACTIONS(386),
    [anon_sym_BANG_EQ] = ACTIONS(388),
    [anon_sym_COLON_COLON] = ACTIONS(388),
    [anon_sym_LBRACE] = ACTIONS(386),
    [anon_sym_RBRACE] = ACTIONS(388),
    [sym_local_import] = ACTIONS(388),
    [sym_http_raw] = ACTIONS(388),
    [aux_sym_env_import_token1] = ACTIONS(388),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(388),
    [anon_sym_DASHInfinity] = ACTIONS(388),
    [aux_sym_double_literal_token1] = ACTIONS(388),
    [sym_natural_literal] = ACTIONS(386),
    [sym_integer_literal] = ACTIONS(386),
    [anon_sym_DQUOTE] = ACTIONS(388),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(388),
    [anon_sym_LT] = ACTIONS(388),
    [anon_sym_PIPE] = ACTIONS(386),
    [anon_sym_GT] = ACTIONS(388),
    [anon_sym_True] = ACTIONS(386),
    [anon_sym_False] = ACTIONS(386),
  },
  [174] = {
    [sym_line_comment] = STATE(174),
    [sym_block_comment] = STATE(174),
    [sym_label] = ACTIONS(366),
    [anon_sym_COLON] = ACTIONS(366),
    [anon_sym_then] = ACTIONS(366),
    [anon_sym_else] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(366),
    [anon_sym_in] = ACTIONS(366),
    [anon_sym_missing] = ACTIONS(366),
    [anon_sym_Infinity] = ACTIONS(366),
    [anon_sym_NaN] = ACTIONS(366),
    [anon_sym_with] = ACTIONS(366),
    [anon_sym_Natural_SLASHfold] = ACTIONS(366),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(366),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(366),
    [anon_sym_Natural_SLASHeven] = ACTIONS(366),
    [anon_sym_Natural_SLASHodd] = ACTIONS(366),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(366),
    [anon_sym_Natural_SLASHshow] = ACTIONS(366),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(366),
    [anon_sym_Integer_SLASHshow] = ACTIONS(366),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(366),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(366),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(366),
    [anon_sym_Double_SLASHshow] = ACTIONS(366),
    [anon_sym_List_SLASHbuild] = ACTIONS(366),
    [anon_sym_List_SLASHfold] = ACTIONS(366),
    [anon_sym_List_SLASHlength] = ACTIONS(366),
    [anon_sym_List_SLASHhead] = ACTIONS(366),
    [anon_sym_List_SLASHlast] = ACTIONS(366),
    [anon_sym_List_SLASHindexed] = ACTIONS(366),
    [anon_sym_List_SLASHreverse] = ACTIONS(366),
    [anon_sym_Text_SLASHshow] = ACTIONS(366),
    [anon_sym_Text_SLASHreplace] = ACTIONS(366),
    [anon_sym_Bool] = ACTIONS(366),
    [anon_sym_Optional] = ACTIONS(366),
    [anon_sym_None] = ACTIONS(366),
    [anon_sym_Natural] = ACTIONS(366),
    [anon_sym_Integer] = ACTIONS(366),
    [anon_sym_Double] = ACTIONS(366),
    [anon_sym_Text] = ACTIONS(366),
    [anon_sym_Date] = ACTIONS(366),
    [anon_sym_Time] = ACTIONS(366),
    [anon_sym_TimeZone] = ACTIONS(366),
    [anon_sym_List] = ACTIONS(366),
    [anon_sym_Type] = ACTIONS(366),
    [anon_sym_Kind] = ACTIONS(366),
    [anon_sym_Sort] = ACTIONS(366),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(368),
    [anon_sym_2] = ACTIONS(368),
    [anon_sym_DASH_GT] = ACTIONS(368),
    [anon_sym_EQ] = ACTIONS(366),
    [anon_sym_DOT] = ACTIONS(366),
    [anon_sym_QMARK] = ACTIONS(368),
    [anon_sym_LBRACK] = ACTIONS(368),
    [anon_sym_COMMA] = ACTIONS(368),
    [anon_sym_RBRACK] = ACTIONS(368),
    [anon_sym_4] = ACTIONS(368),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(368),
    [anon_sym_PIPE_PIPE] = ACTIONS(368),
    [anon_sym_PLUS] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_POUND] = ACTIONS(368),
    [anon_sym_AMP_AMP] = ACTIONS(368),
    [anon_sym_5] = ACTIONS(368),
    [anon_sym_SLASH_BSLASH] = ACTIONS(368),
    [anon_sym_6] = ACTIONS(368),
    [anon_sym_SLASH_SLASH] = ACTIONS(366),
    [anon_sym_7] = ACTIONS(368),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(368),
    [anon_sym_STAR] = ACTIONS(368),
    [anon_sym_EQ_EQ] = ACTIONS(366),
    [anon_sym_BANG_EQ] = ACTIONS(368),
    [anon_sym_COLON_COLON] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(366),
    [anon_sym_RBRACE] = ACTIONS(368),
    [sym_local_import] = ACTIONS(368),
    [sym_http_raw] = ACTIONS(368),
    [aux_sym_env_import_token1] = ACTIONS(368),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(368),
    [anon_sym_DASHInfinity] = ACTIONS(368),
    [aux_sym_double_literal_token1] = ACTIONS(368),
    [sym_natural_literal] = ACTIONS(366),
    [sym_integer_literal] = ACTIONS(366),
    [anon_sym_DQUOTE] = ACTIONS(368),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(368),
    [anon_sym_LT] = ACTIONS(368),
    [anon_sym_PIPE] = ACTIONS(366),
    [anon_sym_GT] = ACTIONS(368),
    [anon_sym_True] = ACTIONS(366),
    [anon_sym_False] = ACTIONS(366),
  },
  [175] = {
    [sym_line_comment] = STATE(175),
    [sym_block_comment] = STATE(175),
    [sym_label] = ACTIONS(298),
    [anon_sym_COLON] = ACTIONS(298),
    [anon_sym_then] = ACTIONS(298),
    [anon_sym_else] = ACTIONS(298),
    [anon_sym_let] = ACTIONS(298),
    [anon_sym_in] = ACTIONS(298),
    [anon_sym_missing] = ACTIONS(298),
    [anon_sym_Infinity] = ACTIONS(298),
    [anon_sym_NaN] = ACTIONS(298),
    [anon_sym_with] = ACTIONS(298),
    [anon_sym_Natural_SLASHfold] = ACTIONS(298),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(298),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(298),
    [anon_sym_Natural_SLASHeven] = ACTIONS(298),
    [anon_sym_Natural_SLASHodd] = ACTIONS(298),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(298),
    [anon_sym_Natural_SLASHshow] = ACTIONS(298),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(298),
    [anon_sym_Integer_SLASHshow] = ACTIONS(298),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(298),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(298),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(298),
    [anon_sym_Double_SLASHshow] = ACTIONS(298),
    [anon_sym_List_SLASHbuild] = ACTIONS(298),
    [anon_sym_List_SLASHfold] = ACTIONS(298),
    [anon_sym_List_SLASHlength] = ACTIONS(298),
    [anon_sym_List_SLASHhead] = ACTIONS(298),
    [anon_sym_List_SLASHlast] = ACTIONS(298),
    [anon_sym_List_SLASHindexed] = ACTIONS(298),
    [anon_sym_List_SLASHreverse] = ACTIONS(298),
    [anon_sym_Text_SLASHshow] = ACTIONS(298),
    [anon_sym_Text_SLASHreplace] = ACTIONS(298),
    [anon_sym_Bool] = ACTIONS(298),
    [anon_sym_Optional] = ACTIONS(298),
    [anon_sym_None] = ACTIONS(298),
    [anon_sym_Natural] = ACTIONS(298),
    [anon_sym_Integer] = ACTIONS(298),
    [anon_sym_Double] = ACTIONS(298),
    [anon_sym_Text] = ACTIONS(298),
    [anon_sym_Date] = ACTIONS(298),
    [anon_sym_Time] = ACTIONS(298),
    [anon_sym_TimeZone] = ACTIONS(298),
    [anon_sym_List] = ACTIONS(298),
    [anon_sym_Type] = ACTIONS(298),
    [anon_sym_Kind] = ACTIONS(298),
    [anon_sym_Sort] = ACTIONS(298),
    [anon_sym_LPAREN] = ACTIONS(300),
    [anon_sym_RPAREN] = ACTIONS(300),
    [anon_sym_2] = ACTIONS(300),
    [anon_sym_DASH_GT] = ACTIONS(300),
    [anon_sym_EQ] = ACTIONS(298),
    [anon_sym_DOT] = ACTIONS(298),
    [anon_sym_QMARK] = ACTIONS(300),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_COMMA] = ACTIONS(300),
    [anon_sym_RBRACK] = ACTIONS(300),
    [anon_sym_4] = ACTIONS(300),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(300),
    [anon_sym_PIPE_PIPE] = ACTIONS(300),
    [anon_sym_PLUS] = ACTIONS(298),
    [anon_sym_PLUS_PLUS] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(300),
    [anon_sym_AMP_AMP] = ACTIONS(300),
    [anon_sym_5] = ACTIONS(300),
    [anon_sym_SLASH_BSLASH] = ACTIONS(300),
    [anon_sym_6] = ACTIONS(300),
    [anon_sym_SLASH_SLASH] = ACTIONS(298),
    [anon_sym_7] = ACTIONS(300),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(300),
    [anon_sym_STAR] = ACTIONS(300),
    [anon_sym_EQ_EQ] = ACTIONS(298),
    [anon_sym_BANG_EQ] = ACTIONS(300),
    [anon_sym_COLON_COLON] = ACTIONS(300),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_RBRACE] = ACTIONS(300),
    [sym_local_import] = ACTIONS(300),
    [sym_http_raw] = ACTIONS(300),
    [aux_sym_env_import_token1] = ACTIONS(300),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(300),
    [anon_sym_DASHInfinity] = ACTIONS(300),
    [aux_sym_double_literal_token1] = ACTIONS(300),
    [sym_natural_literal] = ACTIONS(298),
    [sym_integer_literal] = ACTIONS(298),
    [anon_sym_DQUOTE] = ACTIONS(300),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(300),
    [anon_sym_LT] = ACTIONS(300),
    [anon_sym_PIPE] = ACTIONS(298),
    [anon_sym_GT] = ACTIONS(300),
    [anon_sym_True] = ACTIONS(298),
    [anon_sym_False] = ACTIONS(298),
  },
  [176] = {
    [sym_line_comment] = STATE(176),
    [sym_block_comment] = STATE(176),
    [sym_label] = ACTIONS(302),
    [anon_sym_COLON] = ACTIONS(302),
    [anon_sym_then] = ACTIONS(302),
    [anon_sym_else] = ACTIONS(302),
    [anon_sym_let] = ACTIONS(302),
    [anon_sym_in] = ACTIONS(302),
    [anon_sym_missing] = ACTIONS(302),
    [anon_sym_Infinity] = ACTIONS(302),
    [anon_sym_NaN] = ACTIONS(302),
    [anon_sym_with] = ACTIONS(302),
    [anon_sym_Natural_SLASHfold] = ACTIONS(302),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(302),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(302),
    [anon_sym_Natural_SLASHeven] = ACTIONS(302),
    [anon_sym_Natural_SLASHodd] = ACTIONS(302),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(302),
    [anon_sym_Natural_SLASHshow] = ACTIONS(302),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(302),
    [anon_sym_Integer_SLASHshow] = ACTIONS(302),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(302),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(302),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(302),
    [anon_sym_Double_SLASHshow] = ACTIONS(302),
    [anon_sym_List_SLASHbuild] = ACTIONS(302),
    [anon_sym_List_SLASHfold] = ACTIONS(302),
    [anon_sym_List_SLASHlength] = ACTIONS(302),
    [anon_sym_List_SLASHhead] = ACTIONS(302),
    [anon_sym_List_SLASHlast] = ACTIONS(302),
    [anon_sym_List_SLASHindexed] = ACTIONS(302),
    [anon_sym_List_SLASHreverse] = ACTIONS(302),
    [anon_sym_Text_SLASHshow] = ACTIONS(302),
    [anon_sym_Text_SLASHreplace] = ACTIONS(302),
    [anon_sym_Bool] = ACTIONS(302),
    [anon_sym_Optional] = ACTIONS(302),
    [anon_sym_None] = ACTIONS(302),
    [anon_sym_Natural] = ACTIONS(302),
    [anon_sym_Integer] = ACTIONS(302),
    [anon_sym_Double] = ACTIONS(302),
    [anon_sym_Text] = ACTIONS(302),
    [anon_sym_Date] = ACTIONS(302),
    [anon_sym_Time] = ACTIONS(302),
    [anon_sym_TimeZone] = ACTIONS(302),
    [anon_sym_List] = ACTIONS(302),
    [anon_sym_Type] = ACTIONS(302),
    [anon_sym_Kind] = ACTIONS(302),
    [anon_sym_Sort] = ACTIONS(302),
    [anon_sym_LPAREN] = ACTIONS(304),
    [anon_sym_RPAREN] = ACTIONS(304),
    [anon_sym_2] = ACTIONS(304),
    [anon_sym_DASH_GT] = ACTIONS(304),
    [anon_sym_EQ] = ACTIONS(302),
    [anon_sym_DOT] = ACTIONS(302),
    [anon_sym_QMARK] = ACTIONS(304),
    [anon_sym_LBRACK] = ACTIONS(304),
    [anon_sym_COMMA] = ACTIONS(304),
    [anon_sym_RBRACK] = ACTIONS(304),
    [anon_sym_4] = ACTIONS(304),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(304),
    [anon_sym_PLUS] = ACTIONS(302),
    [anon_sym_PLUS_PLUS] = ACTIONS(304),
    [anon_sym_POUND] = ACTIONS(304),
    [anon_sym_AMP_AMP] = ACTIONS(304),
    [anon_sym_5] = ACTIONS(304),
    [anon_sym_SLASH_BSLASH] = ACTIONS(304),
    [anon_sym_6] = ACTIONS(304),
    [anon_sym_SLASH_SLASH] = ACTIONS(302),
    [anon_sym_7] = ACTIONS(304),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(304),
    [anon_sym_STAR] = ACTIONS(304),
    [anon_sym_EQ_EQ] = ACTIONS(302),
    [anon_sym_BANG_EQ] = ACTIONS(304),
    [anon_sym_COLON_COLON] = ACTIONS(304),
    [anon_sym_LBRACE] = ACTIONS(302),
    [anon_sym_RBRACE] = ACTIONS(304),
    [sym_local_import] = ACTIONS(304),
    [sym_http_raw] = ACTIONS(304),
    [aux_sym_env_import_token1] = ACTIONS(304),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(304),
    [anon_sym_DASHInfinity] = ACTIONS(304),
    [aux_sym_double_literal_token1] = ACTIONS(304),
    [sym_natural_literal] = ACTIONS(302),
    [sym_integer_literal] = ACTIONS(302),
    [anon_sym_DQUOTE] = ACTIONS(304),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(304),
    [anon_sym_LT] = ACTIONS(304),
    [anon_sym_PIPE] = ACTIONS(302),
    [anon_sym_GT] = ACTIONS(304),
    [anon_sym_True] = ACTIONS(302),
    [anon_sym_False] = ACTIONS(302),
  },
  [177] = {
    [sym_line_comment] = STATE(177),
    [sym_block_comment] = STATE(177),
    [sym_label] = ACTIONS(473),
    [anon_sym_COLON] = ACTIONS(475),
    [anon_sym_then] = ACTIONS(473),
    [anon_sym_else] = ACTIONS(473),
    [anon_sym_let] = ACTIONS(473),
    [anon_sym_in] = ACTIONS(473),
    [anon_sym_as] = ACTIONS(473),
    [anon_sym_missing] = ACTIONS(473),
    [anon_sym_Infinity] = ACTIONS(473),
    [anon_sym_NaN] = ACTIONS(473),
    [anon_sym_with] = ACTIONS(473),
    [anon_sym_Natural_SLASHfold] = ACTIONS(473),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(473),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(473),
    [anon_sym_Natural_SLASHeven] = ACTIONS(473),
    [anon_sym_Natural_SLASHodd] = ACTIONS(473),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(473),
    [anon_sym_Natural_SLASHshow] = ACTIONS(473),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(473),
    [anon_sym_Integer_SLASHshow] = ACTIONS(473),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(473),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(473),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(473),
    [anon_sym_Double_SLASHshow] = ACTIONS(473),
    [anon_sym_List_SLASHbuild] = ACTIONS(473),
    [anon_sym_List_SLASHfold] = ACTIONS(473),
    [anon_sym_List_SLASHlength] = ACTIONS(473),
    [anon_sym_List_SLASHhead] = ACTIONS(473),
    [anon_sym_List_SLASHlast] = ACTIONS(473),
    [anon_sym_List_SLASHindexed] = ACTIONS(473),
    [anon_sym_List_SLASHreverse] = ACTIONS(473),
    [anon_sym_Text_SLASHshow] = ACTIONS(473),
    [anon_sym_Text_SLASHreplace] = ACTIONS(473),
    [anon_sym_Bool] = ACTIONS(473),
    [anon_sym_Optional] = ACTIONS(473),
    [anon_sym_None] = ACTIONS(473),
    [anon_sym_Natural] = ACTIONS(473),
    [anon_sym_Integer] = ACTIONS(473),
    [anon_sym_Double] = ACTIONS(473),
    [anon_sym_Text] = ACTIONS(473),
    [anon_sym_Date] = ACTIONS(473),
    [anon_sym_Time] = ACTIONS(473),
    [anon_sym_TimeZone] = ACTIONS(473),
    [anon_sym_List] = ACTIONS(473),
    [anon_sym_Type] = ACTIONS(473),
    [anon_sym_Kind] = ACTIONS(473),
    [anon_sym_Sort] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_RPAREN] = ACTIONS(475),
    [anon_sym_2] = ACTIONS(475),
    [anon_sym_DASH_GT] = ACTIONS(475),
    [anon_sym_EQ] = ACTIONS(473),
    [anon_sym_QMARK] = ACTIONS(475),
    [anon_sym_LBRACK] = ACTIONS(475),
    [anon_sym_COMMA] = ACTIONS(475),
    [anon_sym_RBRACK] = ACTIONS(475),
    [anon_sym_4] = ACTIONS(475),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(475),
    [anon_sym_PIPE_PIPE] = ACTIONS(475),
    [anon_sym_PLUS] = ACTIONS(473),
    [anon_sym_PLUS_PLUS] = ACTIONS(475),
    [anon_sym_POUND] = ACTIONS(475),
    [anon_sym_AMP_AMP] = ACTIONS(475),
    [anon_sym_5] = ACTIONS(475),
    [anon_sym_SLASH_BSLASH] = ACTIONS(475),
    [anon_sym_6] = ACTIONS(475),
    [anon_sym_SLASH_SLASH] = ACTIONS(473),
    [anon_sym_7] = ACTIONS(475),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(475),
    [anon_sym_STAR] = ACTIONS(475),
    [anon_sym_EQ_EQ] = ACTIONS(473),
    [anon_sym_BANG_EQ] = ACTIONS(475),
    [anon_sym_LBRACE] = ACTIONS(473),
    [anon_sym_RBRACE] = ACTIONS(475),
    [sym_import_hash] = ACTIONS(475),
    [sym_local_import] = ACTIONS(475),
    [sym_http_raw] = ACTIONS(475),
    [aux_sym_env_import_token1] = ACTIONS(475),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(475),
    [anon_sym_DASHInfinity] = ACTIONS(475),
    [aux_sym_double_literal_token1] = ACTIONS(475),
    [sym_natural_literal] = ACTIONS(473),
    [sym_integer_literal] = ACTIONS(473),
    [anon_sym_DQUOTE] = ACTIONS(475),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(475),
    [anon_sym_LT] = ACTIONS(475),
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_GT] = ACTIONS(475),
    [anon_sym_True] = ACTIONS(473),
    [anon_sym_False] = ACTIONS(473),
  },
  [178] = {
    [sym_line_comment] = STATE(178),
    [sym_block_comment] = STATE(178),
    [sym_label] = ACTIONS(477),
    [anon_sym_COLON] = ACTIONS(479),
    [anon_sym_then] = ACTIONS(477),
    [anon_sym_else] = ACTIONS(477),
    [anon_sym_let] = ACTIONS(477),
    [anon_sym_in] = ACTIONS(477),
    [anon_sym_as] = ACTIONS(477),
    [anon_sym_missing] = ACTIONS(477),
    [anon_sym_Infinity] = ACTIONS(477),
    [anon_sym_NaN] = ACTIONS(477),
    [anon_sym_with] = ACTIONS(477),
    [anon_sym_Natural_SLASHfold] = ACTIONS(477),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(477),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(477),
    [anon_sym_Natural_SLASHeven] = ACTIONS(477),
    [anon_sym_Natural_SLASHodd] = ACTIONS(477),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(477),
    [anon_sym_Natural_SLASHshow] = ACTIONS(477),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(477),
    [anon_sym_Integer_SLASHshow] = ACTIONS(477),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(477),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(477),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(477),
    [anon_sym_Double_SLASHshow] = ACTIONS(477),
    [anon_sym_List_SLASHbuild] = ACTIONS(477),
    [anon_sym_List_SLASHfold] = ACTIONS(477),
    [anon_sym_List_SLASHlength] = ACTIONS(477),
    [anon_sym_List_SLASHhead] = ACTIONS(477),
    [anon_sym_List_SLASHlast] = ACTIONS(477),
    [anon_sym_List_SLASHindexed] = ACTIONS(477),
    [anon_sym_List_SLASHreverse] = ACTIONS(477),
    [anon_sym_Text_SLASHshow] = ACTIONS(477),
    [anon_sym_Text_SLASHreplace] = ACTIONS(477),
    [anon_sym_Bool] = ACTIONS(477),
    [anon_sym_Optional] = ACTIONS(477),
    [anon_sym_None] = ACTIONS(477),
    [anon_sym_Natural] = ACTIONS(477),
    [anon_sym_Integer] = ACTIONS(477),
    [anon_sym_Double] = ACTIONS(477),
    [anon_sym_Text] = ACTIONS(477),
    [anon_sym_Date] = ACTIONS(477),
    [anon_sym_Time] = ACTIONS(477),
    [anon_sym_TimeZone] = ACTIONS(477),
    [anon_sym_List] = ACTIONS(477),
    [anon_sym_Type] = ACTIONS(477),
    [anon_sym_Kind] = ACTIONS(477),
    [anon_sym_Sort] = ACTIONS(477),
    [anon_sym_LPAREN] = ACTIONS(479),
    [anon_sym_RPAREN] = ACTIONS(479),
    [anon_sym_2] = ACTIONS(479),
    [anon_sym_DASH_GT] = ACTIONS(479),
    [anon_sym_EQ] = ACTIONS(477),
    [anon_sym_QMARK] = ACTIONS(479),
    [anon_sym_LBRACK] = ACTIONS(479),
    [anon_sym_COMMA] = ACTIONS(479),
    [anon_sym_RBRACK] = ACTIONS(479),
    [anon_sym_4] = ACTIONS(479),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(479),
    [anon_sym_PIPE_PIPE] = ACTIONS(479),
    [anon_sym_PLUS] = ACTIONS(477),
    [anon_sym_PLUS_PLUS] = ACTIONS(479),
    [anon_sym_POUND] = ACTIONS(479),
    [anon_sym_AMP_AMP] = ACTIONS(479),
    [anon_sym_5] = ACTIONS(479),
    [anon_sym_SLASH_BSLASH] = ACTIONS(479),
    [anon_sym_6] = ACTIONS(479),
    [anon_sym_SLASH_SLASH] = ACTIONS(477),
    [anon_sym_7] = ACTIONS(479),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(479),
    [anon_sym_STAR] = ACTIONS(479),
    [anon_sym_EQ_EQ] = ACTIONS(477),
    [anon_sym_BANG_EQ] = ACTIONS(479),
    [anon_sym_LBRACE] = ACTIONS(477),
    [anon_sym_RBRACE] = ACTIONS(479),
    [sym_import_hash] = ACTIONS(479),
    [sym_local_import] = ACTIONS(479),
    [sym_http_raw] = ACTIONS(479),
    [aux_sym_env_import_token1] = ACTIONS(479),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(479),
    [anon_sym_DASHInfinity] = ACTIONS(479),
    [aux_sym_double_literal_token1] = ACTIONS(479),
    [sym_natural_literal] = ACTIONS(477),
    [sym_integer_literal] = ACTIONS(477),
    [anon_sym_DQUOTE] = ACTIONS(479),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(479),
    [anon_sym_LT] = ACTIONS(479),
    [anon_sym_PIPE] = ACTIONS(477),
    [anon_sym_GT] = ACTIONS(479),
    [anon_sym_True] = ACTIONS(477),
    [anon_sym_False] = ACTIONS(477),
  },
  [179] = {
    [sym_line_comment] = STATE(179),
    [sym_block_comment] = STATE(179),
    [sym_label] = ACTIONS(310),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_then] = ACTIONS(310),
    [anon_sym_else] = ACTIONS(310),
    [anon_sym_let] = ACTIONS(310),
    [anon_sym_in] = ACTIONS(310),
    [anon_sym_missing] = ACTIONS(310),
    [anon_sym_Infinity] = ACTIONS(310),
    [anon_sym_NaN] = ACTIONS(310),
    [anon_sym_with] = ACTIONS(310),
    [anon_sym_Natural_SLASHfold] = ACTIONS(310),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(310),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(310),
    [anon_sym_Natural_SLASHeven] = ACTIONS(310),
    [anon_sym_Natural_SLASHodd] = ACTIONS(310),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(310),
    [anon_sym_Natural_SLASHshow] = ACTIONS(310),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(310),
    [anon_sym_Integer_SLASHshow] = ACTIONS(310),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(310),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(310),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(310),
    [anon_sym_Double_SLASHshow] = ACTIONS(310),
    [anon_sym_List_SLASHbuild] = ACTIONS(310),
    [anon_sym_List_SLASHfold] = ACTIONS(310),
    [anon_sym_List_SLASHlength] = ACTIONS(310),
    [anon_sym_List_SLASHhead] = ACTIONS(310),
    [anon_sym_List_SLASHlast] = ACTIONS(310),
    [anon_sym_List_SLASHindexed] = ACTIONS(310),
    [anon_sym_List_SLASHreverse] = ACTIONS(310),
    [anon_sym_Text_SLASHshow] = ACTIONS(310),
    [anon_sym_Text_SLASHreplace] = ACTIONS(310),
    [anon_sym_Bool] = ACTIONS(310),
    [anon_sym_Optional] = ACTIONS(310),
    [anon_sym_None] = ACTIONS(310),
    [anon_sym_Natural] = ACTIONS(310),
    [anon_sym_Integer] = ACTIONS(310),
    [anon_sym_Double] = ACTIONS(310),
    [anon_sym_Text] = ACTIONS(310),
    [anon_sym_Date] = ACTIONS(310),
    [anon_sym_Time] = ACTIONS(310),
    [anon_sym_TimeZone] = ACTIONS(310),
    [anon_sym_List] = ACTIONS(310),
    [anon_sym_Type] = ACTIONS(310),
    [anon_sym_Kind] = ACTIONS(310),
    [anon_sym_Sort] = ACTIONS(310),
    [anon_sym_LPAREN] = ACTIONS(312),
    [anon_sym_RPAREN] = ACTIONS(312),
    [anon_sym_2] = ACTIONS(312),
    [anon_sym_DASH_GT] = ACTIONS(312),
    [anon_sym_EQ] = ACTIONS(310),
    [anon_sym_DOT] = ACTIONS(310),
    [anon_sym_QMARK] = ACTIONS(312),
    [anon_sym_LBRACK] = ACTIONS(312),
    [anon_sym_COMMA] = ACTIONS(312),
    [anon_sym_RBRACK] = ACTIONS(312),
    [anon_sym_4] = ACTIONS(312),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(312),
    [anon_sym_PIPE_PIPE] = ACTIONS(312),
    [anon_sym_PLUS] = ACTIONS(310),
    [anon_sym_PLUS_PLUS] = ACTIONS(312),
    [anon_sym_POUND] = ACTIONS(312),
    [anon_sym_AMP_AMP] = ACTIONS(312),
    [anon_sym_5] = ACTIONS(312),
    [anon_sym_SLASH_BSLASH] = ACTIONS(312),
    [anon_sym_6] = ACTIONS(312),
    [anon_sym_SLASH_SLASH] = ACTIONS(310),
    [anon_sym_7] = ACTIONS(312),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(312),
    [anon_sym_STAR] = ACTIONS(312),
    [anon_sym_EQ_EQ] = ACTIONS(310),
    [anon_sym_BANG_EQ] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_RBRACE] = ACTIONS(312),
    [sym_local_import] = ACTIONS(312),
    [sym_http_raw] = ACTIONS(312),
    [aux_sym_env_import_token1] = ACTIONS(312),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(312),
    [anon_sym_DASHInfinity] = ACTIONS(312),
    [aux_sym_double_literal_token1] = ACTIONS(312),
    [sym_natural_literal] = ACTIONS(310),
    [sym_integer_literal] = ACTIONS(310),
    [anon_sym_DQUOTE] = ACTIONS(312),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(312),
    [anon_sym_LT] = ACTIONS(312),
    [anon_sym_PIPE] = ACTIONS(310),
    [anon_sym_GT] = ACTIONS(312),
    [anon_sym_True] = ACTIONS(310),
    [anon_sym_False] = ACTIONS(310),
  },
  [180] = {
    [sym_line_comment] = STATE(180),
    [sym_block_comment] = STATE(180),
    [sym_label] = ACTIONS(314),
    [anon_sym_COLON] = ACTIONS(314),
    [anon_sym_then] = ACTIONS(314),
    [anon_sym_else] = ACTIONS(314),
    [anon_sym_let] = ACTIONS(314),
    [anon_sym_in] = ACTIONS(314),
    [anon_sym_missing] = ACTIONS(314),
    [anon_sym_Infinity] = ACTIONS(314),
    [anon_sym_NaN] = ACTIONS(314),
    [anon_sym_with] = ACTIONS(314),
    [anon_sym_Natural_SLASHfold] = ACTIONS(314),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(314),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(314),
    [anon_sym_Natural_SLASHeven] = ACTIONS(314),
    [anon_sym_Natural_SLASHodd] = ACTIONS(314),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(314),
    [anon_sym_Natural_SLASHshow] = ACTIONS(314),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(314),
    [anon_sym_Integer_SLASHshow] = ACTIONS(314),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(314),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(314),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(314),
    [anon_sym_Double_SLASHshow] = ACTIONS(314),
    [anon_sym_List_SLASHbuild] = ACTIONS(314),
    [anon_sym_List_SLASHfold] = ACTIONS(314),
    [anon_sym_List_SLASHlength] = ACTIONS(314),
    [anon_sym_List_SLASHhead] = ACTIONS(314),
    [anon_sym_List_SLASHlast] = ACTIONS(314),
    [anon_sym_List_SLASHindexed] = ACTIONS(314),
    [anon_sym_List_SLASHreverse] = ACTIONS(314),
    [anon_sym_Text_SLASHshow] = ACTIONS(314),
    [anon_sym_Text_SLASHreplace] = ACTIONS(314),
    [anon_sym_Bool] = ACTIONS(314),
    [anon_sym_Optional] = ACTIONS(314),
    [anon_sym_None] = ACTIONS(314),
    [anon_sym_Natural] = ACTIONS(314),
    [anon_sym_Integer] = ACTIONS(314),
    [anon_sym_Double] = ACTIONS(314),
    [anon_sym_Text] = ACTIONS(314),
    [anon_sym_Date] = ACTIONS(314),
    [anon_sym_Time] = ACTIONS(314),
    [anon_sym_TimeZone] = ACTIONS(314),
    [anon_sym_List] = ACTIONS(314),
    [anon_sym_Type] = ACTIONS(314),
    [anon_sym_Kind] = ACTIONS(314),
    [anon_sym_Sort] = ACTIONS(314),
    [anon_sym_LPAREN] = ACTIONS(316),
    [anon_sym_RPAREN] = ACTIONS(316),
    [anon_sym_2] = ACTIONS(316),
    [anon_sym_DASH_GT] = ACTIONS(316),
    [anon_sym_EQ] = ACTIONS(314),
    [anon_sym_DOT] = ACTIONS(314),
    [anon_sym_QMARK] = ACTIONS(316),
    [anon_sym_LBRACK] = ACTIONS(316),
    [anon_sym_COMMA] = ACTIONS(316),
    [anon_sym_RBRACK] = ACTIONS(316),
    [anon_sym_4] = ACTIONS(316),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(316),
    [anon_sym_PIPE_PIPE] = ACTIONS(316),
    [anon_sym_PLUS] = ACTIONS(314),
    [anon_sym_PLUS_PLUS] = ACTIONS(316),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_AMP_AMP] = ACTIONS(316),
    [anon_sym_5] = ACTIONS(316),
    [anon_sym_SLASH_BSLASH] = ACTIONS(316),
    [anon_sym_6] = ACTIONS(316),
    [anon_sym_SLASH_SLASH] = ACTIONS(314),
    [anon_sym_7] = ACTIONS(316),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(316),
    [anon_sym_STAR] = ACTIONS(316),
    [anon_sym_EQ_EQ] = ACTIONS(314),
    [anon_sym_BANG_EQ] = ACTIONS(316),
    [anon_sym_COLON_COLON] = ACTIONS(316),
    [anon_sym_LBRACE] = ACTIONS(314),
    [anon_sym_RBRACE] = ACTIONS(316),
    [sym_local_import] = ACTIONS(316),
    [sym_http_raw] = ACTIONS(316),
    [aux_sym_env_import_token1] = ACTIONS(316),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(316),
    [anon_sym_DASHInfinity] = ACTIONS(316),
    [aux_sym_double_literal_token1] = ACTIONS(316),
    [sym_natural_literal] = ACTIONS(314),
    [sym_integer_literal] = ACTIONS(314),
    [anon_sym_DQUOTE] = ACTIONS(316),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(316),
    [anon_sym_LT] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(314),
    [anon_sym_GT] = ACTIONS(316),
    [anon_sym_True] = ACTIONS(314),
    [anon_sym_False] = ACTIONS(314),
  },
  [181] = {
    [sym_line_comment] = STATE(181),
    [sym_block_comment] = STATE(181),
    [sym_label] = ACTIONS(318),
    [anon_sym_COLON] = ACTIONS(318),
    [anon_sym_then] = ACTIONS(318),
    [anon_sym_else] = ACTIONS(318),
    [anon_sym_let] = ACTIONS(318),
    [anon_sym_in] = ACTIONS(318),
    [anon_sym_missing] = ACTIONS(318),
    [anon_sym_Infinity] = ACTIONS(318),
    [anon_sym_NaN] = ACTIONS(318),
    [anon_sym_with] = ACTIONS(318),
    [anon_sym_Natural_SLASHfold] = ACTIONS(318),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(318),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(318),
    [anon_sym_Natural_SLASHeven] = ACTIONS(318),
    [anon_sym_Natural_SLASHodd] = ACTIONS(318),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(318),
    [anon_sym_Natural_SLASHshow] = ACTIONS(318),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(318),
    [anon_sym_Integer_SLASHshow] = ACTIONS(318),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(318),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(318),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(318),
    [anon_sym_Double_SLASHshow] = ACTIONS(318),
    [anon_sym_List_SLASHbuild] = ACTIONS(318),
    [anon_sym_List_SLASHfold] = ACTIONS(318),
    [anon_sym_List_SLASHlength] = ACTIONS(318),
    [anon_sym_List_SLASHhead] = ACTIONS(318),
    [anon_sym_List_SLASHlast] = ACTIONS(318),
    [anon_sym_List_SLASHindexed] = ACTIONS(318),
    [anon_sym_List_SLASHreverse] = ACTIONS(318),
    [anon_sym_Text_SLASHshow] = ACTIONS(318),
    [anon_sym_Text_SLASHreplace] = ACTIONS(318),
    [anon_sym_Bool] = ACTIONS(318),
    [anon_sym_Optional] = ACTIONS(318),
    [anon_sym_None] = ACTIONS(318),
    [anon_sym_Natural] = ACTIONS(318),
    [anon_sym_Integer] = ACTIONS(318),
    [anon_sym_Double] = ACTIONS(318),
    [anon_sym_Text] = ACTIONS(318),
    [anon_sym_Date] = ACTIONS(318),
    [anon_sym_Time] = ACTIONS(318),
    [anon_sym_TimeZone] = ACTIONS(318),
    [anon_sym_List] = ACTIONS(318),
    [anon_sym_Type] = ACTIONS(318),
    [anon_sym_Kind] = ACTIONS(318),
    [anon_sym_Sort] = ACTIONS(318),
    [anon_sym_LPAREN] = ACTIONS(320),
    [anon_sym_RPAREN] = ACTIONS(320),
    [anon_sym_2] = ACTIONS(320),
    [anon_sym_DASH_GT] = ACTIONS(320),
    [anon_sym_EQ] = ACTIONS(318),
    [anon_sym_DOT] = ACTIONS(318),
    [anon_sym_QMARK] = ACTIONS(320),
    [anon_sym_LBRACK] = ACTIONS(320),
    [anon_sym_COMMA] = ACTIONS(320),
    [anon_sym_RBRACK] = ACTIONS(320),
    [anon_sym_4] = ACTIONS(320),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(320),
    [anon_sym_PIPE_PIPE] = ACTIONS(320),
    [anon_sym_PLUS] = ACTIONS(318),
    [anon_sym_PLUS_PLUS] = ACTIONS(320),
    [anon_sym_POUND] = ACTIONS(320),
    [anon_sym_AMP_AMP] = ACTIONS(320),
    [anon_sym_5] = ACTIONS(320),
    [anon_sym_SLASH_BSLASH] = ACTIONS(320),
    [anon_sym_6] = ACTIONS(320),
    [anon_sym_SLASH_SLASH] = ACTIONS(318),
    [anon_sym_7] = ACTIONS(320),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(320),
    [anon_sym_STAR] = ACTIONS(320),
    [anon_sym_EQ_EQ] = ACTIONS(318),
    [anon_sym_BANG_EQ] = ACTIONS(320),
    [anon_sym_COLON_COLON] = ACTIONS(320),
    [anon_sym_LBRACE] = ACTIONS(318),
    [anon_sym_RBRACE] = ACTIONS(320),
    [sym_local_import] = ACTIONS(320),
    [sym_http_raw] = ACTIONS(320),
    [aux_sym_env_import_token1] = ACTIONS(320),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(320),
    [anon_sym_DASHInfinity] = ACTIONS(320),
    [aux_sym_double_literal_token1] = ACTIONS(320),
    [sym_natural_literal] = ACTIONS(318),
    [sym_integer_literal] = ACTIONS(318),
    [anon_sym_DQUOTE] = ACTIONS(320),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(320),
    [anon_sym_LT] = ACTIONS(320),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_GT] = ACTIONS(320),
    [anon_sym_True] = ACTIONS(318),
    [anon_sym_False] = ACTIONS(318),
  },
  [182] = {
    [sym_line_comment] = STATE(182),
    [sym_block_comment] = STATE(182),
    [sym_label] = ACTIONS(481),
    [anon_sym_COLON] = ACTIONS(483),
    [anon_sym_then] = ACTIONS(481),
    [anon_sym_else] = ACTIONS(481),
    [anon_sym_let] = ACTIONS(481),
    [anon_sym_in] = ACTIONS(481),
    [anon_sym_as] = ACTIONS(485),
    [anon_sym_missing] = ACTIONS(481),
    [anon_sym_Infinity] = ACTIONS(481),
    [anon_sym_NaN] = ACTIONS(481),
    [anon_sym_with] = ACTIONS(481),
    [anon_sym_Natural_SLASHfold] = ACTIONS(481),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(481),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(481),
    [anon_sym_Natural_SLASHeven] = ACTIONS(481),
    [anon_sym_Natural_SLASHodd] = ACTIONS(481),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(481),
    [anon_sym_Natural_SLASHshow] = ACTIONS(481),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(481),
    [anon_sym_Integer_SLASHshow] = ACTIONS(481),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(481),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(481),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(481),
    [anon_sym_Double_SLASHshow] = ACTIONS(481),
    [anon_sym_List_SLASHbuild] = ACTIONS(481),
    [anon_sym_List_SLASHfold] = ACTIONS(481),
    [anon_sym_List_SLASHlength] = ACTIONS(481),
    [anon_sym_List_SLASHhead] = ACTIONS(481),
    [anon_sym_List_SLASHlast] = ACTIONS(481),
    [anon_sym_List_SLASHindexed] = ACTIONS(481),
    [anon_sym_List_SLASHreverse] = ACTIONS(481),
    [anon_sym_Text_SLASHshow] = ACTIONS(481),
    [anon_sym_Text_SLASHreplace] = ACTIONS(481),
    [anon_sym_Bool] = ACTIONS(481),
    [anon_sym_Optional] = ACTIONS(481),
    [anon_sym_None] = ACTIONS(481),
    [anon_sym_Natural] = ACTIONS(481),
    [anon_sym_Integer] = ACTIONS(481),
    [anon_sym_Double] = ACTIONS(481),
    [anon_sym_Text] = ACTIONS(481),
    [anon_sym_Date] = ACTIONS(481),
    [anon_sym_Time] = ACTIONS(481),
    [anon_sym_TimeZone] = ACTIONS(481),
    [anon_sym_List] = ACTIONS(481),
    [anon_sym_Type] = ACTIONS(481),
    [anon_sym_Kind] = ACTIONS(481),
    [anon_sym_Sort] = ACTIONS(481),
    [anon_sym_LPAREN] = ACTIONS(483),
    [anon_sym_RPAREN] = ACTIONS(483),
    [anon_sym_2] = ACTIONS(483),
    [anon_sym_DASH_GT] = ACTIONS(483),
    [anon_sym_EQ] = ACTIONS(481),
    [anon_sym_QMARK] = ACTIONS(483),
    [anon_sym_LBRACK] = ACTIONS(483),
    [anon_sym_COMMA] = ACTIONS(483),
    [anon_sym_RBRACK] = ACTIONS(483),
    [anon_sym_4] = ACTIONS(483),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(483),
    [anon_sym_PIPE_PIPE] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(481),
    [anon_sym_PLUS_PLUS] = ACTIONS(483),
    [anon_sym_POUND] = ACTIONS(483),
    [anon_sym_AMP_AMP] = ACTIONS(483),
    [anon_sym_5] = ACTIONS(483),
    [anon_sym_SLASH_BSLASH] = ACTIONS(483),
    [anon_sym_6] = ACTIONS(483),
    [anon_sym_SLASH_SLASH] = ACTIONS(481),
    [anon_sym_7] = ACTIONS(483),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(483),
    [anon_sym_STAR] = ACTIONS(483),
    [anon_sym_EQ_EQ] = ACTIONS(481),
    [anon_sym_BANG_EQ] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(481),
    [anon_sym_RBRACE] = ACTIONS(483),
    [sym_import_hash] = ACTIONS(487),
    [sym_local_import] = ACTIONS(483),
    [sym_http_raw] = ACTIONS(483),
    [aux_sym_env_import_token1] = ACTIONS(483),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(483),
    [anon_sym_DASHInfinity] = ACTIONS(483),
    [aux_sym_double_literal_token1] = ACTIONS(483),
    [sym_natural_literal] = ACTIONS(481),
    [sym_integer_literal] = ACTIONS(481),
    [anon_sym_DQUOTE] = ACTIONS(483),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(483),
    [anon_sym_LT] = ACTIONS(483),
    [anon_sym_PIPE] = ACTIONS(481),
    [anon_sym_GT] = ACTIONS(483),
    [anon_sym_True] = ACTIONS(481),
    [anon_sym_False] = ACTIONS(481),
  },
  [183] = {
    [sym_line_comment] = STATE(183),
    [sym_block_comment] = STATE(183),
    [sym_label] = ACTIONS(263),
    [anon_sym_COLON] = ACTIONS(263),
    [anon_sym_then] = ACTIONS(263),
    [anon_sym_else] = ACTIONS(263),
    [anon_sym_let] = ACTIONS(263),
    [anon_sym_in] = ACTIONS(263),
    [anon_sym_missing] = ACTIONS(263),
    [anon_sym_Infinity] = ACTIONS(263),
    [anon_sym_NaN] = ACTIONS(263),
    [anon_sym_with] = ACTIONS(263),
    [anon_sym_Natural_SLASHfold] = ACTIONS(263),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(263),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(263),
    [anon_sym_Natural_SLASHeven] = ACTIONS(263),
    [anon_sym_Natural_SLASHodd] = ACTIONS(263),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(263),
    [anon_sym_Natural_SLASHshow] = ACTIONS(263),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(263),
    [anon_sym_Integer_SLASHshow] = ACTIONS(263),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(263),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(263),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(263),
    [anon_sym_Double_SLASHshow] = ACTIONS(263),
    [anon_sym_List_SLASHbuild] = ACTIONS(263),
    [anon_sym_List_SLASHfold] = ACTIONS(263),
    [anon_sym_List_SLASHlength] = ACTIONS(263),
    [anon_sym_List_SLASHhead] = ACTIONS(263),
    [anon_sym_List_SLASHlast] = ACTIONS(263),
    [anon_sym_List_SLASHindexed] = ACTIONS(263),
    [anon_sym_List_SLASHreverse] = ACTIONS(263),
    [anon_sym_Text_SLASHshow] = ACTIONS(263),
    [anon_sym_Text_SLASHreplace] = ACTIONS(263),
    [anon_sym_Bool] = ACTIONS(263),
    [anon_sym_Optional] = ACTIONS(263),
    [anon_sym_None] = ACTIONS(263),
    [anon_sym_Natural] = ACTIONS(263),
    [anon_sym_Integer] = ACTIONS(263),
    [anon_sym_Double] = ACTIONS(263),
    [anon_sym_Text] = ACTIONS(263),
    [anon_sym_Date] = ACTIONS(263),
    [anon_sym_Time] = ACTIONS(263),
    [anon_sym_TimeZone] = ACTIONS(263),
    [anon_sym_List] = ACTIONS(263),
    [anon_sym_Type] = ACTIONS(263),
    [anon_sym_Kind] = ACTIONS(263),
    [anon_sym_Sort] = ACTIONS(263),
    [anon_sym_LPAREN] = ACTIONS(265),
    [anon_sym_RPAREN] = ACTIONS(265),
    [anon_sym_2] = ACTIONS(265),
    [anon_sym_DASH_GT] = ACTIONS(265),
    [anon_sym_EQ] = ACTIONS(263),
    [anon_sym_DOT] = ACTIONS(263),
    [anon_sym_QMARK] = ACTIONS(265),
    [anon_sym_LBRACK] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_RBRACK] = ACTIONS(265),
    [anon_sym_4] = ACTIONS(265),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(265),
    [anon_sym_PIPE_PIPE] = ACTIONS(265),
    [anon_sym_PLUS] = ACTIONS(263),
    [anon_sym_PLUS_PLUS] = ACTIONS(265),
    [anon_sym_POUND] = ACTIONS(265),
    [anon_sym_AMP_AMP] = ACTIONS(265),
    [anon_sym_5] = ACTIONS(265),
    [anon_sym_SLASH_BSLASH] = ACTIONS(265),
    [anon_sym_6] = ACTIONS(265),
    [anon_sym_SLASH_SLASH] = ACTIONS(263),
    [anon_sym_7] = ACTIONS(265),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(265),
    [anon_sym_STAR] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(263),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_COLON_COLON] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(263),
    [anon_sym_RBRACE] = ACTIONS(265),
    [sym_local_import] = ACTIONS(265),
    [sym_http_raw] = ACTIONS(265),
    [aux_sym_env_import_token1] = ACTIONS(265),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(265),
    [anon_sym_DASHInfinity] = ACTIONS(265),
    [aux_sym_double_literal_token1] = ACTIONS(265),
    [sym_natural_literal] = ACTIONS(263),
    [sym_integer_literal] = ACTIONS(263),
    [anon_sym_DQUOTE] = ACTIONS(265),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(265),
    [anon_sym_LT] = ACTIONS(265),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(265),
    [anon_sym_True] = ACTIONS(263),
    [anon_sym_False] = ACTIONS(263),
  },
  [184] = {
    [sym_line_comment] = STATE(184),
    [sym_block_comment] = STATE(184),
    [sym_label] = ACTIONS(330),
    [anon_sym_COLON] = ACTIONS(330),
    [anon_sym_then] = ACTIONS(330),
    [anon_sym_else] = ACTIONS(330),
    [anon_sym_let] = ACTIONS(330),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_missing] = ACTIONS(330),
    [anon_sym_Infinity] = ACTIONS(330),
    [anon_sym_NaN] = ACTIONS(330),
    [anon_sym_with] = ACTIONS(330),
    [anon_sym_Natural_SLASHfold] = ACTIONS(330),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(330),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(330),
    [anon_sym_Natural_SLASHeven] = ACTIONS(330),
    [anon_sym_Natural_SLASHodd] = ACTIONS(330),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(330),
    [anon_sym_Natural_SLASHshow] = ACTIONS(330),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(330),
    [anon_sym_Integer_SLASHshow] = ACTIONS(330),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(330),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(330),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(330),
    [anon_sym_Double_SLASHshow] = ACTIONS(330),
    [anon_sym_List_SLASHbuild] = ACTIONS(330),
    [anon_sym_List_SLASHfold] = ACTIONS(330),
    [anon_sym_List_SLASHlength] = ACTIONS(330),
    [anon_sym_List_SLASHhead] = ACTIONS(330),
    [anon_sym_List_SLASHlast] = ACTIONS(330),
    [anon_sym_List_SLASHindexed] = ACTIONS(330),
    [anon_sym_List_SLASHreverse] = ACTIONS(330),
    [anon_sym_Text_SLASHshow] = ACTIONS(330),
    [anon_sym_Text_SLASHreplace] = ACTIONS(330),
    [anon_sym_Bool] = ACTIONS(330),
    [anon_sym_Optional] = ACTIONS(330),
    [anon_sym_None] = ACTIONS(330),
    [anon_sym_Natural] = ACTIONS(330),
    [anon_sym_Integer] = ACTIONS(330),
    [anon_sym_Double] = ACTIONS(330),
    [anon_sym_Text] = ACTIONS(330),
    [anon_sym_Date] = ACTIONS(330),
    [anon_sym_Time] = ACTIONS(330),
    [anon_sym_TimeZone] = ACTIONS(330),
    [anon_sym_List] = ACTIONS(330),
    [anon_sym_Type] = ACTIONS(330),
    [anon_sym_Kind] = ACTIONS(330),
    [anon_sym_Sort] = ACTIONS(330),
    [anon_sym_LPAREN] = ACTIONS(332),
    [anon_sym_RPAREN] = ACTIONS(332),
    [anon_sym_2] = ACTIONS(332),
    [anon_sym_DASH_GT] = ACTIONS(332),
    [anon_sym_EQ] = ACTIONS(330),
    [anon_sym_DOT] = ACTIONS(330),
    [anon_sym_QMARK] = ACTIONS(332),
    [anon_sym_LBRACK] = ACTIONS(332),
    [anon_sym_COMMA] = ACTIONS(332),
    [anon_sym_RBRACK] = ACTIONS(332),
    [anon_sym_4] = ACTIONS(332),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(332),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_PLUS] = ACTIONS(330),
    [anon_sym_PLUS_PLUS] = ACTIONS(332),
    [anon_sym_POUND] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(332),
    [anon_sym_5] = ACTIONS(332),
    [anon_sym_SLASH_BSLASH] = ACTIONS(332),
    [anon_sym_6] = ACTIONS(332),
    [anon_sym_SLASH_SLASH] = ACTIONS(330),
    [anon_sym_7] = ACTIONS(332),
    [anon_sym_SLASH_SLASH_BSLASH_BSLASH] = ACTIONS(332),
    [anon_sym_STAR] = ACTIONS(332),
    [anon_sym_EQ_EQ] = ACTIONS(330),
    [anon_sym_BANG_EQ] = ACTIONS(332),
    [anon_sym_COLON_COLON] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(330),
    [anon_sym_RBRACE] = ACTIONS(332),
    [sym_local_import] = ACTIONS(332),
    [sym_http_raw] = ACTIONS(332),
    [aux_sym_env_import_token1] = ACTIONS(332),
    [sym_line_comment_prefix] = ACTIONS(3),
    [sym_block_comment_open] = ACTIONS(5),
    [sym_temporal_literal] = ACTIONS(332),
    [anon_sym_DASHInfinity] = ACTIONS(332),
    [aux_sym_double_literal_token1] = ACTIONS(332),
    [sym_natural_literal] = ACTIONS(330),
    [sym_integer_literal] = ACTIONS(330),
    [anon_sym_DQUOTE] = ACTIONS(332),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(332),
    [anon_sym_LT] = ACTIONS(332),
    [anon_sym_PIPE] = ACTIONS(330),
    [anon_sym_GT] = ACTIONS(332),
    [anon_sym_True] = ACTIONS(330),
    [anon_sym_False] = ACTIONS(330),
  },
  [185] = {
    [sym_line_comment] = STATE(185),
    [sym_block_comment] = STATE(185),
    [sym_label] = ACTIONS(442),
    [anon_sym_COLON] = ACTIONS(442),
    [anon_sym_then] = ACTIONS(442),
    [anon_sym_else] = ACTIONS(442),
    [anon_sym_let] = ACTIONS(442),
    [anon_sym_in] = ACTIONS(442),
    [anon_sym_missing] = ACTIONS(442),
    [anon_sym_Infinity] = ACTIONS(442),
    [anon_sym_NaN] = ACTIONS(442),
    [anon_sym_with] = ACTIONS(442),
    [anon_sym_Natural_SLASHfold] = ACTIONS(442),
    [anon_sym_Natural_SLASHbuild] = ACTIONS(442),
    [anon_sym_Natural_SLASHisZero] = ACTIONS(442),
    [anon_sym_Natural_SLASHeven] = ACTIONS(442),
    [anon_sym_Natural_SLASHodd] = ACTIONS(442),
    [anon_sym_Natural_SLASHtoInteger] = ACTIONS(442),
    [anon_sym_Natural_SLASHshow] = ACTIONS(442),
    [anon_sym_Integer_SLASHtoDouble] = ACTIONS(442),
    [anon_sym_Integer_SLASHshow] = ACTIONS(442),
    [anon_sym_Integer_SLASHnegate] = ACTIONS(442),
    [anon_sym_Integer_SLASHclamp] = ACTIONS(442),
    [anon_sym_Natural_SLASHsubtract] = ACTIONS(442),
    [anon_sym_Double_SLASHshow] = ACTIONS(442),
    [anon_sym_List_SLASHbuild] = ACTIONS(442),
    [anon_sym_List_SLASHfold] = ACTIONS(442),
    [anon_sym_List_SLASHlength] = ACTIONS(442),
    [anon_sym_List_SLASHhead] = ACTIONS(442),
    [anon_sym_List_SLASHlast] = ACTIONS(442),
    [anon_sym_List_SLASHindexed] = ACTIONS(442),
    [anon_sym_List_SLASHreverse] = ACTIONS(442),
    [anon_sym_Text_SLASHshow] = ACTIONS(442),
    [anon_sym_Text_SLASHreplace] = ACTIONS(442),
    [anon_sym_Bool] = ACTIONS(442),
    [anon_sym_Optional] = ACTIONS(442),
    [anon_sym_None] = ACTIONS(442),
    [anon_sym_Natural] = ACTIONS(442),
    [anon_sym_Integer] = ACTIONS(442),
    [anon_sym_Double] = ACTIONS(442),
    [anon_sym_Text] = ACTIONS(442),
    [anon_sym_Date] = ACTIONS(442),
    [anon_sym_Time] = ACTIONS(442),
    [anon_sym_TimeZone] = ACTIONS(442),
    [anon_sym_List] = ACTIONS(442),
    [anon_sym_Type] = ACTIONS(442),
    [anon_sym_Kind] = ACTIONS(442),
    [anon_sym_Sort] = ACTIONS(442),
    [anon_sym_LPAREN] = ACTIONS(444),
    [anon_sym_RPAREN] = ACTIONS(444),
    [anon_sym_2] = ACTIONS(444),
    [anon_sym_DASH_GT] = ACTIONS(444),
    [anon_sym_EQ] = ACTIONS(442),
    [anon_sym_DOT] = ACTIONS(442),
    [anon_sym_QMARK] = ACTIONS(444),
    [anon_sym_LBRACK] = ACTIONS(444),
    [anon_sym_COMMA] = ACTIONS(444),
    [anon_sym_RBRACK] = ACTIONS(444),
    [anon_sym_4] = ACTIONS(444),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(444),
    [anon_sym_PIPE_PIPE] = ACTIONS(444),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(444),
    [anon_sym_POUND] = ACTIONS(444),
    [anon_sym_AMP_AMP] = ACTIONS(444),
    [anon_sym_5] = ACTIONS(444),
    [anon_sym_SLASH_BSLASH] = ACTIONS(444),
    [anon