#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 4717
#define LARGE_STATE_COUNT 1962
#define SYMBOL_COUNT 361
#define ALIAS_COUNT 3
#define TOKEN_COUNT 146
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 45
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 154

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_LF = 2,
  anon_sym_CR = 3,
  anon_sym_CR_LF = 4,
  anon_sym_POUND_BANG = 5,
  aux_sym_shebang_token1 = 6,
  anon_sym_SLASH_SLASH = 7,
  anon_sym_SLASH_STAR = 8,
  aux_sym_block_comment_token1 = 9,
  aux_sym_block_comment_token2 = 10,
  anon_sym_STAR_SLASH = 11,
  anon_sym_module = 12,
  anon_sym_import = 13,
  anon_sym_SEMI = 14,
  anon_sym_DOT = 15,
  anon_sym_as = 16,
  anon_sym_LBRACE = 17,
  anon_sym_COMMA = 18,
  anon_sym_RBRACE = 19,
  anon_sym_const = 20,
  anon_sym_LPAREN = 21,
  anon_sym_RPAREN = 22,
  anon_sym_EQ = 23,
  anon_sym___global = 24,
  anon_sym_type = 25,
  anon_sym_fn = 26,
  anon_sym_PLUS = 27,
  anon_sym_DASH = 28,
  anon_sym_STAR = 29,
  anon_sym_SLASH = 30,
  anon_sym_PERCENT = 31,
  anon_sym_LT = 32,
  anon_sym_GT = 33,
  anon_sym_EQ_EQ = 34,
  anon_sym_BANG_EQ = 35,
  anon_sym_LT_EQ = 36,
  anon_sym_GT_EQ = 37,
  anon_sym_DOT_DOT_DOT = 38,
  anon_sym_LBRACK = 39,
  anon_sym_LT2 = 40,
  anon_sym_RBRACK = 41,
  anon_sym_struct = 42,
  anon_sym_union = 43,
  anon_sym_pub = 44,
  anon_sym_mut = 45,
  anon_sym_COLON = 46,
  anon_sym_enum = 47,
  anon_sym_interface = 48,
  anon_sym_PLUS_PLUS = 49,
  anon_sym_DASH_DASH = 50,
  anon_sym_QMARK = 51,
  anon_sym_BANG = 52,
  anon_sym_go = 53,
  anon_sym_spawn = 54,
  anon_sym_json_DOTdecode = 55,
  anon_sym_PIPE = 56,
  anon_sym_LBRACK2 = 57,
  anon_sym_TILDE = 58,
  anon_sym_CARET = 59,
  anon_sym_AMP = 60,
  anon_sym_LT_DASH = 61,
  anon_sym_LT_LT = 62,
  anon_sym_GT_GT = 63,
  anon_sym_GT_GT_GT = 64,
  anon_sym_AMP_CARET = 65,
  anon_sym_AMP_AMP = 66,
  anon_sym_PIPE_PIPE = 67,
  anon_sym_or = 68,
  sym_escape_sequence = 69,
  sym_none = 70,
  sym_true = 71,
  sym_false = 72,
  sym_nil = 73,
  anon_sym_QMARK_DOT = 74,
  anon_sym_DOLLAR_LPAREN = 75,
  anon_sym_POUND_LBRACK = 76,
  anon_sym_if = 77,
  anon_sym_else = 78,
  anon_sym_DOLLARif = 79,
  anon_sym_DOLLARelse = 80,
  anon_sym_is = 81,
  anon_sym_BANGis = 82,
  anon_sym_in = 83,
  anon_sym_BANGin = 84,
  anon_sym_match = 85,
  anon_sym_select = 86,
  anon_sym_STAR_EQ = 87,
  anon_sym_SLASH_EQ = 88,
  anon_sym_PERCENT_EQ = 89,
  anon_sym_LT_LT_EQ = 90,
  anon_sym_GT_GT_EQ = 91,
  anon_sym_GT_GT_GT_EQ = 92,
  anon_sym_AMP_EQ = 93,
  anon_sym_AMP_CARET_EQ = 94,
  anon_sym_PLUS_EQ = 95,
  anon_sym_DASH_EQ = 96,
  anon_sym_PIPE_EQ = 97,
  anon_sym_CARET_EQ = 98,
  anon_sym_COLON_EQ = 99,
  anon_sym_lock = 100,
  anon_sym_rlock = 101,
  anon_sym_unsafe = 102,
  anon_sym_sql = 103,
  sym_int_literal = 104,
  sym_float_literal = 105,
  sym_rune_literal = 106,
  anon_sym_SQUOTE = 107,
  aux_sym_interpreted_string_literal_token1 = 108,
  anon_sym_DOLLAR = 109,
  anon_sym_DQUOTE = 110,
  aux_sym_interpreted_string_literal_token2 = 111,
  anon_sym_c_SQUOTE = 112,
  anon_sym_c_DQUOTE = 113,
  anon_sym_r_SQUOTE = 114,
  aux_sym_raw_string_literal_token1 = 115,
  anon_sym_r_DQUOTE = 116,
  aux_sym_raw_string_literal_token2 = 117,
  anon_sym_DOLLAR_LBRACE = 118,
  aux_sym_format_specifier_token1 = 119,
  aux_sym_format_specifier_token2 = 120,
  anon_sym_0 = 121,
  sym_pseudo_compile_time_identifier = 122,
  anon_sym_static = 123,
  anon_sym_volatile = 124,
  anon_sym_shared = 125,
  aux_sym_sum_type_token1 = 126,
  anon_sym_PIPE2 = 127,
  anon_sym_map_LBRACK = 128,
  anon_sym_chan = 129,
  anon_sym_thread = 130,
  anon_sym_atomic = 131,
  anon_sym_assert = 132,
  anon_sym_defer = 133,
  anon_sym_goto = 134,
  anon_sym_break = 135,
  anon_sym_continue = 136,
  anon_sym_return = 137,
  anon_sym_DOLLARfor = 138,
  anon_sym_for = 139,
  anon_sym_DOT_DOT = 140,
  anon_sym_POUND = 141,
  aux_sym_hash_statement_token1 = 142,
  anon_sym_asm = 143,
  aux_sym__content_block_token1 = 144,
  anon_sym_AT_LBRACK = 145,
  sym_source_file = 146,
  sym_shebang = 147,
  sym_line_comment = 148,
  sym_block_comment = 149,
  sym_module_clause = 150,
  sym_import_list = 151,
  sym_import_declaration = 152,
  sym_import_spec = 153,
  sym_import_path = 154,
  sym_import_name = 155,
  sym_import_alias = 156,
  sym_selective_import_list = 157,
  sym_const_declaration = 158,
  sym_const_definition = 159,
  sym_global_var_declaration = 160,
  sym_global_var_definition = 161,
  sym__global_var_value = 162,
  sym_type_declaration = 163,
  sym_function_declaration = 164,
  sym_static_method_declaration = 165,
  sym_static_receiver = 166,
  sym__function_name = 167,
  sym_overridable_operator = 168,
  sym_receiver = 169,
  sym_signature = 170,
  sym_parameter_list = 171,
  sym_parameter_declaration = 172,
  sym_type_parameter_list = 173,
  sym_type_parameter_declaration = 174,
  sym_generic_parameters = 175,
  sym_generic_parameter = 176,
  sym_struct_declaration = 177,
  sym__struct_body = 178,
  sym_struct_field_scope = 179,
  sym_struct_field_declaration = 180,
  sym__struct_field_definition = 181,
  sym_embedded_definition = 182,
  sym_enum_declaration = 183,
  sym_enum_backed_type = 184,
  sym__enum_body = 185,
  sym_enum_field_definition = 186,
  sym_interface_declaration = 187,
  sym__interface_body = 188,
  sym_interface_method_definition = 189,
  sym__expression = 190,
  sym__expression_without_blocks = 191,
  sym__expression_with_blocks = 192,
  sym_strictly_expression_list = 193,
  sym_inc_expression = 194,
  sym_dec_expression = 195,
  sym_or_block_expression = 196,
  sym_option_propagation_expression = 197,
  sym_result_propagation_expression = 198,
  sym_anon_struct_value_expression = 199,
  sym_go_expression = 200,
  sym_spawn_expression = 201,
  sym_parenthesized_expression = 202,
  sym_call_expression = 203,
  sym_type_parameters = 204,
  sym_argument_list = 205,
  sym_short_lambda = 206,
  sym_argument = 207,
  sym_special_argument_list = 208,
  sym_type_initializer = 209,
  sym_type_initializer_body = 210,
  sym_element_list = 211,
  sym_short_element_list = 212,
  sym_field_name = 213,
  sym_keyed_element = 214,
  sym_function_literal = 215,
  sym_capture_list = 216,
  sym_capture = 217,
  sym_reference_expression = 218,
  sym_type_reference_expression = 219,
  sym_unary_expression = 220,
  sym_receive_expression = 221,
  sym_binary_expression = 222,
  sym_as_type_cast_expression = 223,
  sym_or_block = 224,
  sym__max_group = 225,
  sym_literal = 226,
  sym_spread_expression = 227,
  sym_map_init_expression = 228,
  sym_map_keyed_element = 229,
  sym_array_creation = 230,
  sym_fixed_array_creation = 231,
  sym_selector_expression = 232,
  sym_compile_time_selector_expression = 233,
  sym_index_expression = 234,
  sym_slice_expression = 235,
  sym_if_expression = 236,
  sym_else_branch = 237,
  sym_compile_time_if_expression = 238,
  sym_is_expression = 239,
  sym_in_expression = 240,
  sym_enum_fetch = 241,
  sym_match_expression = 242,
  sym_match_arms = 243,
  sym_match_arm = 244,
  sym_match_expression_list = 245,
  sym_match_arm_type = 246,
  sym_match_else_arm_clause = 247,
  sym_select_expression = 248,
  sym_select_arm = 249,
  sym_select_arm_statement = 250,
  sym__select_arm_assignment_statement = 251,
  sym_select_var_declaration = 252,
  sym_select_else_arn_clause = 253,
  sym_lock_expression = 254,
  sym_unsafe_expression = 255,
  sym_sql_expression = 256,
  sym_interpreted_string_literal = 257,
  sym_c_string_literal = 258,
  sym_raw_string_literal = 259,
  sym_string_interpolation = 260,
  sym_format_specifier = 261,
  sym_visibility_modifiers = 262,
  sym_mutability_modifiers = 263,
  sym_mutable_identifier = 264,
  sym_mutable_expression = 265,
  sym_identifier_list = 266,
  sym_expression_list = 267,
  sym_expression_without_blocks_list = 268,
  sym_sum_type = 269,
  sym_plain_type = 270,
  sym__plain_type_without_special = 271,
  sym_anon_struct_type = 272,
  sym_multi_return_type = 273,
  sym_result_type = 274,
  sym_option_type = 275,
  sym_qualified_type = 276,
  sym_fixed_array_type = 277,
  sym_array_type = 278,
  sym_pointer_type = 279,
  sym_wrong_pointer_type = 280,
  sym_map_type = 281,
  sym_channel_type = 282,
  sym_shared_type = 283,
  sym_thread_type = 284,
  sym_atomic_type = 285,
  sym_generic_type = 286,
  sym_function_type = 287,
  sym__statement = 288,
  sym_simple_statement = 289,
  sym_assert_statement = 290,
  sym_append_statement = 291,
  sym_send_statement = 292,
  sym_var_declaration = 293,
  sym_var_definition_list = 294,
  sym_var_definition = 295,
  sym_assignment_statement = 296,
  sym_block = 297,
  sym_defer_statement = 298,
  sym_label_reference = 299,
  sym_goto_statement = 300,
  sym_break_statement = 301,
  sym_continue_statement = 302,
  sym_return_statement = 303,
  sym_label_definition = 304,
  sym_labeled_statement = 305,
  sym_compile_time_for_statement = 306,
  sym_for_statement = 307,
  sym_is_clause = 308,
  sym_range_clause = 309,
  sym_for_clause = 310,
  sym__definite_range = 311,
  sym_range = 312,
  sym_hash_statement = 313,
  sym_asm_statement = 314,
  sym__content_block = 315,
  sym_attributes = 316,
  sym_attribute = 317,
  sym_attribute_expression = 318,
  sym_if_attribute = 319,
  sym__plain_attribute = 320,
  sym_literal_attribute = 321,
  sym_value_attribute = 322,
  sym_key_value_attribute = 323,
  aux_sym_source_file_repeat1 = 324,
  aux_sym_block_comment_repeat1 = 325,
  aux_sym_import_list_repeat1 = 326,
  aux_sym_import_path_repeat1 = 327,
  aux_sym_selective_import_list_repeat1 = 328,
  aux_sym_const_declaration_repeat1 = 329,
  aux_sym_global_var_declaration_repeat1 = 330,
  aux_sym_parameter_list_repeat1 = 331,
  aux_sym_type_parameter_list_repeat1 = 332,
  aux_sym_generic_parameters_repeat1 = 333,
  aux_sym__struct_body_repeat1 = 334,
  aux_sym__enum_body_repeat1 = 335,
  aux_sym__interface_body_repeat1 = 336,
  aux_sym_strictly_expression_list_repeat1 = 337,
  aux_sym_type_parameters_repeat1 = 338,
  aux_sym_argument_list_repeat1 = 339,
  aux_sym_short_lambda_repeat1 = 340,
  aux_sym_element_list_repeat1 = 341,
  aux_sym_short_element_list_repeat1 = 342,
  aux_sym_capture_list_repeat1 = 343,
  aux_sym_map_init_expression_repeat1 = 344,
  aux_sym__array_repeat1 = 345,
  aux_sym_match_arms_repeat1 = 346,
  aux_sym_match_expression_list_repeat1 = 347,
  aux_sym_select_expression_repeat1 = 348,
  aux_sym_interpreted_string_literal_repeat1 = 349,
  aux_sym_interpreted_string_literal_repeat2 = 350,
  aux_sym_raw_string_literal_repeat1 = 351,
  aux_sym_raw_string_literal_repeat2 = 352,
  aux_sym_string_interpolation_repeat1 = 353,
  aux_sym_identifier_list_repeat1 = 354,
  aux_sym_expression_without_blocks_list_repeat1 = 355,
  aux_sym_sum_type_repeat1 = 356,
  aux_sym_var_definition_list_repeat1 = 357,
  aux_sym_block_repeat1 = 358,
  aux_sym_attributes_repeat1 = 359,
  aux_sym_attribute_repeat1 = 360,
  alias_sym_element = 361,
  alias_sym_interpolation_closing = 362,
  alias_sym_interpolation_expression = 363,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_LF] = "\n",
  [anon_sym_CR] = "\r",
  [anon_sym_CR_LF] = "\r\n",
  [anon_sym_POUND_BANG] = "#!",
  [aux_sym_shebang_token1] = "shebang_token1",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_SLASH_STAR] = "/*",
  [aux_sym_block_comment_token1] = "block_comment_token1",
  [aux_sym_block_comment_token2] = "block_comment_token2",
  [anon_sym_STAR_SLASH] = "*/",
  [anon_sym_module] = "module",
  [anon_sym_import] = "import",
  [anon_sym_SEMI] = ";",
  [anon_sym_DOT] = ".",
  [anon_sym_as] = "as",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_const] = "const",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_EQ] = "=",
  [anon_sym___global] = "__global",
  [anon_sym_type] = "type",
  [anon_sym_fn] = "fn",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_LBRACK] = "[",
  [anon_sym_LT2] = "<",
  [anon_sym_RBRACK] = "]",
  [anon_sym_struct] = "struct",
  [anon_sym_union] = "union",
  [anon_sym_pub] = "pub",
  [anon_sym_mut] = "mut",
  [anon_sym_COLON] = ":",
  [anon_sym_enum] = "enum",
  [anon_sym_interface] = "interface",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_QMARK] = "\?",
  [anon_sym_BANG] = "!",
  [anon_sym_go] = "go",
  [anon_sym_spawn] = "spawn",
  [anon_sym_json_DOTdecode] = "json.decode",
  [anon_sym_PIPE] = "|",
  [anon_sym_LBRACK2] = "[",
  [anon_sym_TILDE] = "~",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_AMP_CARET] = "&^",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_or] = "or",
  [sym_escape_sequence] = "escape_sequence",
  [sym_none] = "none",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_nil] = "nil",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_DOLLAR_LPAREN] = "$(",
  [anon_sym_POUND_LBRACK] = "#[",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_DOLLARif] = "$if",
  [anon_sym_DOLLARelse] = "$else",
  [anon_sym_is] = "is",
  [anon_sym_BANGis] = "!is",
  [anon_sym_in] = "in",
  [anon_sym_BANGin] = "!in",
  [anon_sym_match] = "match",
  [anon_sym_select] = "select",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_AMP_CARET_EQ] = "&^=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_lock] = "lock",
  [anon_sym_rlock] = "rlock",
  [anon_sym_unsafe] = "unsafe",
  [anon_sym_sql] = "sql",
  [sym_int_literal] = "int_literal",
  [sym_float_literal] = "float_literal",
  [sym_rune_literal] = "rune_literal",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_interpreted_string_literal_token1] = "interpreted_string_literal_token1",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_interpreted_string_literal_token2] = "interpreted_string_literal_token2",
  [anon_sym_c_SQUOTE] = "c'",
  [anon_sym_c_DQUOTE] = "c\"",
  [anon_sym_r_SQUOTE] = "r'",
  [aux_sym_raw_string_literal_token1] = "raw_string_literal_token1",
  [anon_sym_r_DQUOTE] = "r\"",
  [aux_sym_raw_string_literal_token2] = "raw_string_literal_token2",
  [anon_sym_DOLLAR_LBRACE] = "interpolation_opening",
  [aux_sym_format_specifier_token1] = "format_specifier_token1",
  [aux_sym_format_specifier_token2] = "format_specifier_token2",
  [anon_sym_0] = "0",
  [sym_pseudo_compile_time_identifier] = "pseudo_compile_time_identifier",
  [anon_sym_static] = "static",
  [anon_sym_volatile] = "volatile",
  [anon_sym_shared] = "shared",
  [aux_sym_sum_type_token1] = "sum_type_token1",
  [anon_sym_PIPE2] = "|",
  [anon_sym_map_LBRACK] = "map[",
  [anon_sym_chan] = "chan",
  [anon_sym_thread] = "thread",
  [anon_sym_atomic] = "atomic",
  [anon_sym_assert] = "assert",
  [anon_sym_defer] = "defer",
  [anon_sym_goto] = "goto",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_return] = "return",
  [anon_sym_DOLLARfor] = "$for",
  [anon_sym_for] = "for",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_POUND] = "#",
  [aux_sym_hash_statement_token1] = "hash_statement_token1",
  [anon_sym_asm] = "asm",
  [aux_sym__content_block_token1] = "_content_block_token1",
  [anon_sym_AT_LBRACK] = "@[",
  [sym_source_file] = "source_file",
  [sym_shebang] = "shebang",
  [sym_line_comment] = "line_comment",
  [sym_block_comment] = "block_comment",
  [sym_module_clause] = "module_clause",
  [sym_import_list] = "import_list",
  [sym_import_declaration] = "import_declaration",
  [sym_import_spec] = "import_spec",
  [sym_import_path] = "import_path",
  [sym_import_name] = "import_name",
  [sym_import_alias] = "import_alias",
  [sym_selective_import_list] = "selective_import_list",
  [sym_const_declaration] = "const_declaration",
  [sym_const_definition] = "const_definition",
  [sym_global_var_declaration] = "global_var_declaration",
  [sym_global_var_definition] = "global_var_definition",
  [sym__global_var_value] = "_global_var_value",
  [sym_type_declaration] = "type_declaration",
  [sym_function_declaration] = "function_declaration",
  [sym_static_method_declaration] = "static_method_declaration",
  [sym_static_receiver] = "static_receiver",
  [sym__function_name] = "_function_name",
  [sym_overridable_operator] = "overridable_operator",
  [sym_receiver] = "receiver",
  [sym_signature] = "signature",
  [sym_parameter_list] = "parameter_list",
  [sym_parameter_declaration] = "parameter_declaration",
  [sym_type_parameter_list] = "type_parameter_list",
  [sym_type_parameter_declaration] = "type_parameter_declaration",
  [sym_generic_parameters] = "generic_parameters",
  [sym_generic_parameter] = "generic_parameter",
  [sym_struct_declaration] = "struct_declaration",
  [sym__struct_body] = "_struct_body",
  [sym_struct_field_scope] = "struct_field_scope",
  [sym_struct_field_declaration] = "struct_field_declaration",
  [sym__struct_field_definition] = "_struct_field_definition",
  [sym_embedded_definition] = "embedded_definition",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_backed_type] = "enum_backed_type",
  [sym__enum_body] = "_enum_body",
  [sym_enum_field_definition] = "enum_field_definition",
  [sym_interface_declaration] = "interface_declaration",
  [sym__interface_body] = "_interface_body",
  [sym_interface_method_definition] = "interface_method_definition",
  [sym__expression] = "_expression",
  [sym__expression_without_blocks] = "_expression_without_blocks",
  [sym__expression_with_blocks] = "_expression_with_blocks",
  [sym_strictly_expression_list] = "expression_list",
  [sym_inc_expression] = "inc_expression",
  [sym_dec_expression] = "dec_expression",
  [sym_or_block_expression] = "or_block_expression",
  [sym_option_propagation_expression] = "option_propagation_expression",
  [sym_result_propagation_expression] = "result_propagation_expression",
  [sym_anon_struct_value_expression] = "anon_struct_value_expression",
  [sym_go_expression] = "go_expression",
  [sym_spawn_expression] = "spawn_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_call_expression] = "call_expression",
  [sym_type_parameters] = "type_parameters",
  [sym_argument_list] = "argument_list",
  [sym_short_lambda] = "short_lambda",
  [sym_argument] = "argument",
  [sym_special_argument_list] = "special_argument_list",
  [sym_type_initializer] = "type_initializer",
  [sym_type_initializer_body] = "type_initializer_body",
  [sym_element_list] = "element_list",
  [sym_short_element_list] = "short_element_list",
  [sym_field_name] = "field_name",
  [sym_keyed_element] = "keyed_element",
  [sym_function_literal] = "function_literal",
  [sym_capture_list] = "capture_list",
  [sym_capture] = "capture",
  [sym_reference_expression] = "reference_expression",
  [sym_type_reference_expression] = "type_reference_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_receive_expression] = "receive_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_as_type_cast_expression] = "as_type_cast_expression",
  [sym_or_block] = "or_block",
  [sym__max_group] = "_max_group",
  [sym_literal] = "literal",
  [sym_spread_expression] = "spread_expression",
  [sym_map_init_expression] = "map_init_expression",
  [sym_map_keyed_element] = "map_keyed_element",
  [sym_array_creation] = "array_creation",
  [sym_fixed_array_creation] = "fixed_array_creation",
  [sym_selector_expression] = "selector_expression",
  [sym_compile_time_selector_expression] = "compile_time_selector_expression",
  [sym_index_expression] = "index_expression",
  [sym_slice_expression] = "slice_expression",
  [sym_if_expression] = "if_expression",
  [sym_else_branch] = "else_branch",
  [sym_compile_time_if_expression] = "compile_time_if_expression",
  [sym_is_expression] = "is_expression",
  [sym_in_expression] = "in_expression",
  [sym_enum_fetch] = "enum_fetch",
  [sym_match_expression] = "match_expression",
  [sym_match_arms] = "match_arms",
  [sym_match_arm] = "match_arm",
  [sym_match_expression_list] = "match_expression_list",
  [sym_match_arm_type] = "match_arm_type",
  [sym_match_else_arm_clause] = "match_else_arm_clause",
  [sym_select_expression] = "select_expression",
  [sym_select_arm] = "select_arm",
  [sym_select_arm_statement] = "select_arm_statement",
  [sym__select_arm_assignment_statement] = "_select_arm_assignment_statement",
  [sym_select_var_declaration] = "var_declaration",
  [sym_select_else_arn_clause] = "select_else_arn_clause",
  [sym_lock_expression] = "lock_expression",
  [sym_unsafe_expression] = "unsafe_expression",
  [sym_sql_expression] = "sql_expression",
  [sym_interpreted_string_literal] = "interpreted_string_literal",
  [sym_c_string_literal] = "c_string_literal",
  [sym_raw_string_literal] = "raw_string_literal",
  [sym_string_interpolation] = "string_interpolation",
  [sym_format_specifier] = "format_specifier",
  [sym_visibility_modifiers] = "visibility_modifiers",
  [sym_mutability_modifiers] = "mutability_modifiers",
  [sym_mutable_identifier] = "mutable_identifier",
  [sym_mutable_expression] = "mutable_expression",
  [sym_identifier_list] = "identifier_list",
  [sym_expression_list] = "expression_list",
  [sym_expression_without_blocks_list] = "expression_list",
  [sym_sum_type] = "sum_type",
  [sym_plain_type] = "plain_type",
  [sym__plain_type_without_special] = "_plain_type_without_special",
  [sym_anon_struct_type] = "anon_struct_type",
  [sym_multi_return_type] = "multi_return_type",
  [sym_result_type] = "result_type",
  [sym_option_type] = "option_type",
  [sym_qualified_type] = "qualified_type",
  [sym_fixed_array_type] = "fixed_array_type",
  [sym_array_type] = "array_type",
  [sym_pointer_type] = "pointer_type",
  [sym_wrong_pointer_type] = "wrong_pointer_type",
  [sym_map_type] = "map_type",
  [sym_channel_type] = "channel_type",
  [sym_shared_type] = "shared_type",
  [sym_thread_type] = "thread_type",
  [sym_atomic_type] = "atomic_type",
  [sym_generic_type] = "generic_type",
  [sym_function_type] = "function_type",
  [sym__statement] = "_statement",
  [sym_simple_statement] = "simple_statement",
  [sym_assert_statement] = "assert_statement",
  [sym_append_statement] = "append_statement",
  [sym_send_statement] = "send_statement",
  [sym_var_declaration] = "var_declaration",
  [sym_var_definition_list] = "var_definition_list",
  [sym_var_definition] = "var_definition",
  [sym_assignment_statement] = "assignment_statement",
  [sym_block] = "block",
  [sym_defer_statement] = "defer_statement",
  [sym_label_reference] = "label_reference",
  [sym_goto_statement] = "goto_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_return_statement] = "return_statement",
  [sym_label_definition] = "label_definition",
  [sym_labeled_statement] = "labeled_statement",
  [sym_compile_time_for_statement] = "compile_time_for_statement",
  [sym_for_statement] = "for_statement",
  [sym_is_clause] = "is_clause",
  [sym_range_clause] = "range_clause",
  [sym_for_clause] = "for_clause",
  [sym__definite_range] = "range",
  [sym_range] = "range",
  [sym_hash_statement] = "hash_statement",
  [sym_asm_statement] = "asm_statement",
  [sym__content_block] = "_content_block",
  [sym_attributes] = "attributes",
  [sym_attribute] = "attribute",
  [sym_attribute_expression] = "attribute_expression",
  [sym_if_attribute] = "if_attribute",
  [sym__plain_attribute] = "_plain_attribute",
  [sym_literal_attribute] = "literal_attribute",
  [sym_value_attribute] = "value_attribute",
  [sym_key_value_attribute] = "key_value_attribute",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_block_comment_repeat1] = "block_comment_repeat1",
  [aux_sym_import_list_repeat1] = "import_list_repeat1",
  [aux_sym_import_path_repeat1] = "import_path_repeat1",
  [aux_sym_selective_import_list_repeat1] = "selective_import_list_repeat1",
  [aux_sym_const_declaration_repeat1] = "const_declaration_repeat1",
  [aux_sym_global_var_declaration_repeat1] = "global_var_declaration_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_type_parameter_list_repeat1] = "type_parameter_list_repeat1",
  [aux_sym_generic_parameters_repeat1] = "generic_parameters_repeat1",
  [aux_sym__struct_body_repeat1] = "_struct_body_repeat1",
  [aux_sym__enum_body_repeat1] = "_enum_body_repeat1",
  [aux_sym__interface_body_repeat1] = "_interface_body_repeat1",
  [aux_sym_strictly_expression_list_repeat1] = "strictly_expression_list_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_short_lambda_repeat1] = "short_lambda_repeat1",
  [aux_sym_element_list_repeat1] = "element_list_repeat1",
  [aux_sym_short_element_list_repeat1] = "short_element_list_repeat1",
  [aux_sym_capture_list_repeat1] = "capture_list_repeat1",
  [aux_sym_map_init_expression_repeat1] = "map_init_expression_repeat1",
  [aux_sym__array_repeat1] = "_array_repeat1",
  [aux_sym_match_arms_repeat1] = "match_arms_repeat1",
  [aux_sym_match_expression_list_repeat1] = "match_expression_list_repeat1",
  [aux_sym_select_expression_repeat1] = "select_expression_repeat1",
  [aux_sym_interpreted_string_literal_repeat1] = "interpreted_string_literal_repeat1",
  [aux_sym_interpreted_string_literal_repeat2] = "interpreted_string_literal_repeat2",
  [aux_sym_raw_string_literal_repeat1] = "raw_string_literal_repeat1",
  [aux_sym_raw_string_literal_repeat2] = "raw_string_literal_repeat2",
  [aux_sym_string_interpolation_repeat1] = "string_interpolation_repeat1",
  [aux_sym_identifier_list_repeat1] = "identifier_list_repeat1",
  [aux_sym_expression_without_blocks_list_repeat1] = "expression_without_blocks_list_repeat1",
  [aux_sym_sum_type_repeat1] = "sum_type_repeat1",
  [aux_sym_var_definition_list_repeat1] = "var_definition_list_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_attributes_repeat1] = "attributes_repeat1",
  [aux_sym_attribute_repeat1] = "attribute_repeat1",
  [alias_sym_element] = "element",
  [alias_sym_interpolation_closing] = "interpolation_closing",
  [alias_sym_interpolation_expression] = "interpolation_expression",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR] = anon_sym_CR,
  [anon_sym_CR_LF] = anon_sym_CR_LF,
  [anon_sym_POUND_BANG] = anon_sym_POUND_BANG,
  [aux_sym_shebang_token1] = aux_sym_shebang_token1,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_SLASH_STAR] = anon_sym_SLASH_STAR,
  [aux_sym_block_comment_token1] = aux_sym_block_comment_token1,
  [aux_sym_block_comment_token2] = aux_sym_block_comment_token2,
  [anon_sym_STAR_SLASH] = anon_sym_STAR_SLASH,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym___global] = anon_sym___global,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_LT2] = anon_sym_LT,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_pub] = anon_sym_pub,
  [anon_sym_mut] = anon_sym_mut,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_go] = anon_sym_go,
  [anon_sym_spawn] = anon_sym_spawn,
  [anon_sym_json_DOTdecode] = anon_sym_json_DOTdecode,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_LBRACK2] = anon_sym_LBRACK,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_AMP_CARET] = anon_sym_AMP_CARET,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_or] = anon_sym_or,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_none] = sym_none,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_nil] = sym_nil,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_DOLLAR_LPAREN] = anon_sym_DOLLAR_LPAREN,
  [anon_sym_POUND_LBRACK] = anon_sym_POUND_LBRACK,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_DOLLARif] = anon_sym_DOLLARif,
  [anon_sym_DOLLARelse] = anon_sym_DOLLARelse,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_BANGis] = anon_sym_BANGis,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_BANGin] = anon_sym_BANGin,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_select] = anon_sym_select,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_AMP_CARET_EQ] = anon_sym_AMP_CARET_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_lock] = anon_sym_lock,
  [anon_sym_rlock] = anon_sym_rlock,
  [anon_sym_unsafe] = anon_sym_unsafe,
  [anon_sym_sql] = anon_sym_sql,
  [sym_int_literal] = sym_int_literal,
  [sym_float_literal] = sym_float_literal,
  [sym_rune_literal] = sym_rune_literal,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_interpreted_string_literal_token1] = aux_sym_interpreted_string_literal_token1,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_interpreted_string_literal_token2] = aux_sym_interpreted_string_literal_token2,
  [anon_sym_c_SQUOTE] = anon_sym_c_SQUOTE,
  [anon_sym_c_DQUOTE] = anon_sym_c_DQUOTE,
  [anon_sym_r_SQUOTE] = anon_sym_r_SQUOTE,
  [aux_sym_raw_string_literal_token1] = aux_sym_raw_string_literal_token1,
  [anon_sym_r_DQUOTE] = anon_sym_r_DQUOTE,
  [aux_sym_raw_string_literal_token2] = aux_sym_raw_string_literal_token2,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [aux_sym_format_specifier_token1] = aux_sym_format_specifier_token1,
  [aux_sym_format_specifier_token2] = aux_sym_format_specifier_token2,
  [anon_sym_0] = anon_sym_0,
  [sym_pseudo_compile_time_identifier] = sym_pseudo_compile_time_identifier,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_shared] = anon_sym_shared,
  [aux_sym_sum_type_token1] = aux_sym_sum_type_token1,
  [anon_sym_PIPE2] = anon_sym_PIPE,
  [anon_sym_map_LBRACK] = anon_sym_map_LBRACK,
  [anon_sym_chan] = anon_sym_chan,
  [anon_sym_thread] = anon_sym_thread,
  [anon_sym_atomic] = anon_sym_atomic,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_defer] = anon_sym_defer,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_DOLLARfor] = anon_sym_DOLLARfor,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_POUND] = anon_sym_POUND,
  [aux_sym_hash_statement_token1] = aux_sym_hash_statement_token1,
  [anon_sym_asm] = anon_sym_asm,
  [aux_sym__content_block_token1] = aux_sym__content_block_token1,
  [anon_sym_AT_LBRACK] = anon_sym_AT_LBRACK,
  [sym_source_file] = sym_source_file,
  [sym_shebang] = sym_shebang,
  [sym_line_comment] = sym_line_comment,
  [sym_block_comment] = sym_block_comment,
  [sym_module_clause] = sym_module_clause,
  [sym_import_list] = sym_import_list,
  [sym_import_declaration] = sym_import_declaration,
  [sym_import_spec] = sym_import_spec,
  [sym_import_path] = sym_import_path,
  [sym_import_name] = sym_import_name,
  [sym_import_alias] = sym_import_alias,
  [sym_selective_import_list] = sym_selective_import_list,
  [sym_const_declaration] = sym_const_declaration,
  [sym_const_definition] = sym_const_definition,
  [sym_global_var_declaration] = sym_global_var_declaration,
  [sym_global_var_definition] = sym_global_var_definition,
  [sym__global_var_value] = sym__global_var_value,
  [sym_type_declaration] = sym_type_declaration,
  [sym_function_declaration] = sym_function_declaration,
  [sym_static_method_declaration] = sym_static_method_declaration,
  [sym_static_receiver] = sym_static_receiver,
  [sym__function_name] = sym__function_name,
  [sym_overridable_operator] = sym_overridable_operator,
  [sym_receiver] = sym_receiver,
  [sym_signature] = sym_signature,
  [sym_parameter_list] = sym_parameter_list,
  [sym_parameter_declaration] = sym_parameter_declaration,
  [sym_type_parameter_list] = sym_type_parameter_list,
  [sym_type_parameter_declaration] = sym_type_parameter_declaration,
  [sym_generic_parameters] = sym_generic_parameters,
  [sym_generic_parameter] = sym_generic_parameter,
  [sym_struct_declaration] = sym_struct_declaration,
  [sym__struct_body] = sym__struct_body,
  [sym_struct_field_scope] = sym_struct_field_scope,
  [sym_struct_field_declaration] = sym_struct_field_declaration,
  [sym__struct_field_definition] = sym__struct_field_definition,
  [sym_embedded_definition] = sym_embedded_definition,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_backed_type] = sym_enum_backed_type,
  [sym__enum_body] = sym__enum_body,
  [sym_enum_field_definition] = sym_enum_field_definition,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym__interface_body] = sym__interface_body,
  [sym_interface_method_definition] = sym_interface_method_definition,
  [sym__expression] = sym__expression,
  [sym__expression_without_blocks] = sym__expression_without_blocks,
  [sym__expression_with_blocks] = sym__expression_with_blocks,
  [sym_strictly_expression_list] = sym_expression_list,
  [sym_inc_expression] = sym_inc_expression,
  [sym_dec_expression] = sym_dec_expression,
  [sym_or_block_expression] = sym_or_block_expression,
  [sym_option_propagation_expression] = sym_option_propagation_expression,
  [sym_result_propagation_expression] = sym_result_propagation_expression,
  [sym_anon_struct_value_expression] = sym_anon_struct_value_expression,
  [sym_go_expression] = sym_go_expression,
  [sym_spawn_expression] = sym_spawn_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_type_parameters] = sym_type_parameters,
  [sym_argument_list] = sym_argument_list,
  [sym_short_lambda] = sym_short_lambda,
  [sym_argument] = sym_argument,
  [sym_special_argument_list] = sym_special_argument_list,
  [sym_type_initializer] = sym_type_initializer,
  [sym_type_initializer_body] = sym_type_initializer_body,
  [sym_element_list] = sym_element_list,
  [sym_short_element_list] = sym_short_element_list,
  [sym_field_name] = sym_field_name,
  [sym_keyed_element] = sym_keyed_element,
  [sym_function_literal] = sym_function_literal,
  [sym_capture_list] = sym_capture_list,
  [sym_capture] = sym_capture,
  [sym_reference_expression] = sym_reference_expression,
  [sym_type_reference_expression] = sym_type_reference_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_receive_expression] = sym_receive_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_as_type_cast_expression] = sym_as_type_cast_expression,
  [sym_or_block] = sym_or_block,
  [sym__max_group] = sym__max_group,
  [sym_literal] = sym_literal,
  [sym_spread_expression] = sym_spread_expression,
  [sym_map_init_expression] = sym_map_init_expression,
  [sym_map_keyed_element] = sym_map_keyed_element,
  [sym_array_creation] = sym_array_creation,
  [sym_fixed_array_creation] = sym_fixed_array_creation,
  [sym_selector_expression] = sym_selector_expression,
  [sym_compile_time_selector_expression] = sym_compile_time_selector_expression,
  [sym_index_expression] = sym_index_expression,
  [sym_slice_expression] = sym_slice_expression,
  [sym_if_expression] = sym_if_expression,
  [sym_else_branch] = sym_else_branch,
  [sym_compile_time_if_expression] = sym_compile_time_if_expression,
  [sym_is_expression] = sym_is_expression,
  [sym_in_expression] = sym_in_expression,
  [sym_enum_fetch] = sym_enum_fetch,
  [sym_match_expression] = sym_match_expression,
  [sym_match_arms] = sym_match_arms,
  [sym_match_arm] = sym_match_arm,
  [sym_match_expression_list] = sym_match_expression_list,
  [sym_match_arm_type] = sym_match_arm_type,
  [sym_match_else_arm_clause] = sym_match_else_arm_clause,
  [sym_select_expression] = sym_select_expression,
  [sym_select_arm] = sym_select_arm,
  [sym_select_arm_statement] = sym_select_arm_statement,
  [sym__select_arm_assignment_statement] = sym__select_arm_assignment_statement,
  [sym_select_var_declaration] = sym_var_declaration,
  [sym_select_else_arn_clause] = sym_select_else_arn_clause,
  [sym_lock_expression] = sym_lock_expression,
  [sym_unsafe_expression] = sym_unsafe_expression,
  [sym_sql_expression] = sym_sql_expression,
  [sym_interpreted_string_literal] = sym_interpreted_string_literal,
  [sym_c_string_literal] = sym_c_string_literal,
  [sym_raw_string_literal] = sym_raw_string_literal,
  [sym_string_interpolation] = sym_string_interpolation,
  [sym_format_specifier] = sym_format_specifier,
  [sym_visibility_modifiers] = sym_visibility_modifiers,
  [sym_mutability_modifiers] = sym_mutability_modifiers,
  [sym_mutable_identifier] = sym_mutable_identifier,
  [sym_mutable_expression] = sym_mutable_expression,
  [sym_identifier_list] = sym_identifier_list,
  [sym_expression_list] = sym_expression_list,
  [sym_expression_without_blocks_list] = sym_expression_list,
  [sym_sum_type] = sym_sum_type,
  [sym_plain_type] = sym_plain_type,
  [sym__plain_type_without_special] = sym__plain_type_without_special,
  [sym_anon_struct_type] = sym_anon_struct_type,
  [sym_multi_return_type] = sym_multi_return_type,
  [sym_result_type] = sym_result_type,
  [sym_option_type] = sym_option_type,
  [sym_qualified_type] = sym_qualified_type,
  [sym_fixed_array_type] = sym_fixed_array_type,
  [sym_array_type] = sym_array_type,
  [sym_pointer_type] = sym_pointer_type,
  [sym_wrong_pointer_type] = sym_wrong_pointer_type,
  [sym_map_type] = sym_map_type,
  [sym_channel_type] = sym_channel_type,
  [sym_shared_type] = sym_shared_type,
  [sym_thread_type] = sym_thread_type,
  [sym_atomic_type] = sym_atomic_type,
  [sym_generic_type] = sym_generic_type,
  [sym_function_type] = sym_function_type,
  [sym__statement] = sym__statement,
  [sym_simple_statement] = sym_simple_statement,
  [sym_assert_statement] = sym_assert_statement,
  [sym_append_statement] = sym_append_statement,
  [sym_send_statement] = sym_send_statement,
  [sym_var_declaration] = sym_var_declaration,
  [sym_var_definition_list] = sym_var_definition_list,
  [sym_var_definition] = sym_var_definition,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym_block] = sym_block,
  [sym_defer_statement] = sym_defer_statement,
  [sym_label_reference] = sym_label_reference,
  [sym_goto_statement] = sym_goto_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_label_definition] = sym_label_definition,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_compile_time_for_statement] = sym_compile_time_for_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_is_clause] = sym_is_clause,
  [sym_range_clause] = sym_range_clause,
  [sym_for_clause] = sym_for_clause,
  [sym__definite_range] = sym_range,
  [sym_range] = sym_range,
  [sym_hash_statement] = sym_hash_statement,
  [sym_asm_statement] = sym_asm_statement,
  [sym__content_block] = sym__content_block,
  [sym_attributes] = sym_attributes,
  [sym_attribute] = sym_attribute,
  [sym_attribute_expression] = sym_attribute_expression,
  [sym_if_attribute] = sym_if_attribute,
  [sym__plain_attribute] = sym__plain_attribute,
  [sym_literal_attribute] = sym_literal_attribute,
  [sym_value_attribute] = sym_value_attribute,
  [sym_key_value_attribute] = sym_key_value_attribute,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_block_comment_repeat1] = aux_sym_block_comment_repeat1,
  [aux_sym_import_list_repeat1] = aux_sym_import_list_repeat1,
  [aux_sym_import_path_repeat1] = aux_sym_import_path_repeat1,
  [aux_sym_selective_import_list_repeat1] = aux_sym_selective_import_list_repeat1,
  [aux_sym_const_declaration_repeat1] = aux_sym_const_declaration_repeat1,
  [aux_sym_global_var_declaration_repeat1] = aux_sym_global_var_declaration_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_type_parameter_list_repeat1] = aux_sym_type_parameter_list_repeat1,
  [aux_sym_generic_parameters_repeat1] = aux_sym_generic_parameters_repeat1,
  [aux_sym__struct_body_repeat1] = aux_sym__struct_body_repeat1,
  [aux_sym__enum_body_repeat1] = aux_sym__enum_body_repeat1,
  [aux_sym__interface_body_repeat1] = aux_sym__interface_body_repeat1,
  [aux_sym_strictly_expression_list_repeat1] = aux_sym_strictly_expression_list_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_short_lambda_repeat1] = aux_sym_short_lambda_repeat1,
  [aux_sym_element_list_repeat1] = aux_sym_element_list_repeat1,
  [aux_sym_short_element_list_repeat1] = aux_sym_short_element_list_repeat1,
  [aux_sym_capture_list_repeat1] = aux_sym_capture_list_repeat1,
  [aux_sym_map_init_expression_repeat1] = aux_sym_map_init_expression_repeat1,
  [aux_sym__array_repeat1] = aux_sym__array_repeat1,
  [aux_sym_match_arms_repeat1] = aux_sym_match_arms_repeat1,
  [aux_sym_match_expression_list_repeat1] = aux_sym_match_expression_list_repeat1,
  [aux_sym_select_expression_repeat1] = aux_sym_select_expression_repeat1,
  [aux_sym_interpreted_string_literal_repeat1] = aux_sym_interpreted_string_literal_repeat1,
  [aux_sym_interpreted_string_literal_repeat2] = aux_sym_interpreted_string_literal_repeat2,
  [aux_sym_raw_string_literal_repeat1] = aux_sym_raw_string_literal_repeat1,
  [aux_sym_raw_string_literal_repeat2] = aux_sym_raw_string_literal_repeat2,
  [aux_sym_string_interpolation_repeat1] = aux_sym_string_interpolation_repeat1,
  [aux_sym_identifier_list_repeat1] = aux_sym_identifier_list_repeat1,
  [aux_sym_expression_without_blocks_list_repeat1] = aux_sym_expression_without_blocks_list_repeat1,
  [aux_sym_sum_type_repeat1] = aux_sym_sum_type_repeat1,
  [aux_sym_var_definition_list_repeat1] = aux_sym_var_definition_list_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_attributes_repeat1] = aux_sym_attributes_repeat1,
  [aux_sym_attribute_repeat1] = aux_sym_attribute_repeat1,
  [alias_sym_element] = alias_sym_element,
  [alias_sym_interpolation_closing] = alias_sym_interpolation_closing,
  [alias_sym_interpolation_expression] = alias_sym_interpolation_expression,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_shebang_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_STAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_block_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_STAR_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pub] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mut] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_go] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_spawn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_json_DOTdecode] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_none] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLARif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLARelse] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANGis] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANGin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_select] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lock] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rlock] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsafe] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sql] = {
    .visible = true,
    .named = false,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_rune_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_c_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_c_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_raw_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_r_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_raw_string_literal_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_format_specifier_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_specifier_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = false,
  },
  [sym_pseudo_compile_time_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shared] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sum_type_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PIPE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_map_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_chan] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_thread] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_atomic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLARfor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_hash_statement_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_asm] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__content_block_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_AT_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_shebang] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_module_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_import_list] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_import_path] = {
    .visible = true,
    .named = true,
  },
  [sym_import_name] = {
    .visible = true,
    .named = true,
  },
  [sym_import_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_selective_import_list] = {
    .visible = true,
    .named = true,
  },
  [sym_const_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_const_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_global_var_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_global_var_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__global_var_value] = {
    .visible = false,
    .named = true,
  },
  [sym_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_static_method_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_static_receiver] = {
    .visible = true,
    .named = true,
  },
  [sym__function_name] = {
    .visible = false,
    .named = true,
  },
  [sym_overridable_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_receiver] = {
    .visible = true,
    .named = true,
  },
  [sym_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__struct_body] = {
    .visible = false,
    .named = true,
  },
  [sym_struct_field_scope] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__struct_field_definition] = {
    .visible = false,
    .named = true,
  },
  [sym_embedded_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_backed_type] = {
    .visible = true,
    .named = true,
  },
  [sym__enum_body] = {
    .visible = false,
    .named = true,
  },
  [sym_enum_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__interface_body] = {
    .visible = false,
    .named = true,
  },
  [sym_interface_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__expression_without_blocks] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_with_blocks] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_strictly_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_inc_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dec_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_or_block_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_option_propagation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_result_propagation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_anon_struct_value_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_go_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_spawn_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_short_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_special_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_type_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_type_initializer_body] = {
    .visible = true,
    .named = true,
  },
  [sym_element_list] = {
    .visible = true,
    .named = true,
  },
  [sym_short_element_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_name] = {
    .visible = true,
    .named = true,
  },
  [sym_keyed_element] = {
    .visible = true,
    .named = true,
  },
  [sym_function_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_capture_list] = {
    .visible = true,
    .named = true,
  },
  [sym_capture] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_reference_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_receive_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_as_type_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_or_block] = {
    .visible = true,
    .named = true,
  },
  [sym__max_group] = {
    .visible = false,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_map_init_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_map_keyed_element] = {
    .visible = true,
    .named = true,
  },
  [sym_array_creation] = {
    .visible = true,
    .named = true,
  },
  [sym_fixed_array_creation] = {
    .visible = true,
    .named = true,
  },
  [sym_selector_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_compile_time_selector_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_if_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_else_branch] = {
    .visible = true,
    .named = true,
  },
  [sym_compile_time_if_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_is_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_in_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_fetch] = {
    .visible = true,
    .named = true,
  },
  [sym_match_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_match_arms] = {
    .visible = true,
    .named = true,
  },
  [sym_match_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_match_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_match_arm_type] = {
    .visible = true,
    .named = true,
  },
  [sym_match_else_arm_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_select_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_select_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_select_arm_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__select_arm_assignment_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_select_var_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_select_else_arn_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_lock_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unsafe_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sql_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_interpreted_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_c_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_format_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_visibility_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_mutability_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_mutable_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_mutable_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier_list] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_without_blocks_list] = {
    .visible = true,
    .named = true,
  },
  [sym_sum_type] = {
    .visible = true,
    .named = true,
  },
  [sym_plain_type] = {
    .visible = true,
    .named = true,
  },
  [sym__plain_type_without_special] = {
    .visible = false,
    .named = true,
  },
  [sym_anon_struct_type] = {
    .visible = true,
    .named = true,
  },
  [sym_multi_return_type] = {
    .visible = true,
    .named = true,
  },
  [sym_result_type] = {
    .visible = true,
    .named = true,
  },
  [sym_option_type] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_type] = {
    .visible = true,
    .named = true,
  },
  [sym_fixed_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_wrong_pointer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_map_type] = {
    .visible = true,
    .named = true,
  },
  [sym_channel_type] = {
    .visible = true,
    .named = true,
  },
  [sym_shared_type] = {
    .visible = true,
    .named = true,
  },
  [sym_thread_type] = {
    .visible = true,
    .named = true,
  },
  [sym_atomic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_simple_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_append_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_send_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_var_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_var_definition_list] = {
    .visible = true,
    .named = true,
  },
  [sym_var_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_defer_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_label_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_label_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_compile_time_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_is_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_range_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__definite_range] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_asm_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__content_block] = {
    .visible = false,
    .named = true,
  },
  [sym_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_if_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__plain_attribute] = {
    .visible = false,
    .named = true,
  },
  [sym_literal_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_value_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_key_value_attribute] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_path_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_selective_import_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_const_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_var_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_generic_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__struct_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__interface_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_strictly_expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_short_lambda_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_element_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_short_element_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_capture_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_map_init_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_arms_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_select_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_raw_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_raw_string_literal_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_interpolation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_without_blocks_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sum_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_var_definition_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attributes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_element] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_interpolation_closing] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_interpolation_expression] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_arguments = 1,
  field_attributes = 2,
  field_block = 3,
  field_body = 4,
  field_capture_list = 5,
  field_channel = 6,
  field_condition = 7,
  field_default_value = 8,
  field_element = 9,
  field_element_list = 10,
  field_else_branch = 11,
  field_end = 12,
  field_expression = 13,
  field_expression_list = 14,
  field_field = 15,
  field_function = 16,
  field_generic_parameters = 17,
  field_guard = 18,
  field_index = 19,
  field_initializer = 20,
  field_key = 21,
  field_left = 22,
  field_locked_variables = 23,
  field_modifiers = 24,
  field_module = 25,
  field_mutability = 26,
  field_name = 27,
  field_operand = 28,
  field_operator = 29,
  field_parameters = 30,
  field_receiver = 31,
  field_result = 32,
  field_right = 33,
  field_selected_variables = 34,
  field_short_element_list = 35,
  field_signature = 36,
  field_size = 37,
  field_start = 38,
  field_static_receiver = 39,
  field_type = 40,
  field_type_parameters = 41,
  field_update = 42,
  field_value = 43,
  field_var_list = 44,
  field_variadic = 45,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_arguments] = "arguments",
  [field_attributes] = "attributes",
  [field_block] = "block",
  [field_body] = "body",
  [field_capture_list] = "capture_list",
  [field_channel] = "channel",
  [field_condition] = "condition",
  [field_default_value] = "default_value",
  [field_element] = "element",
  [field_element_list] = "element_list",
  [field_else_branch] = "else_branch",
  [field_end] = "end",
  [field_expression] = "expression",
  [field_expression_list] = "expression_list",
  [field_field] = "field",
  [field_function] = "function",
  [field_generic_parameters] = "generic_parameters",
  [field_guard] = "guard",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_left] = "left",
  [field_locked_variables] = "locked_variables",
  [field_modifiers] = "modifiers",
  [field_module] = "module",
  [field_mutability] = "mutability",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_receiver] = "receiver",
  [field_result] = "result",
  [field_right] = "right",
  [field_selected_variables] = "selected_variables",
  [field_short_element_list] = "short_element_list",
  [field_signature] = "signature",
  [field_size] = "size",
  [field_start] = "start",
  [field_static_receiver] = "static_receiver",
  [field_type] = "type",
  [field_type_parameters] = "type_parameters",
  [field_update] = "update",
  [field_value] = "value",
  [field_var_list] = "var_list",
  [field_variadic] = "variadic",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 2},
  [4] = {.index = 4, .length = 2},
  [5] = {.index = 6, .length = 1},
  [6] = {.index = 6, .length = 1},
  [7] = {.index = 7, .length = 1},
  [8] = {.index = 8, .length = 1},
  [9] = {.index = 9, .length = 2},
  [10] = {.index = 11, .length = 2},
  [11] = {.index = 13, .length = 1},
  [12] = {.index = 14, .length = 2},
  [13] = {.index = 16, .length = 1},
  [14] = {.index = 17, .length = 2},
  [15] = {.index = 19, .length = 2},
  [16] = {.index = 21, .length = 2},
  [17] = {.index = 23, .length = 4},
  [19] = {.index = 27, .length = 1},
  [20] = {.index = 28, .length = 1},
  [21] = {.index = 29, .length = 2},
  [22] = {.index = 31, .length = 2},
  [23] = {.index = 33, .length = 2},
  [26] = {.index = 35, .length = 2},
  [27] = {.index = 37, .length = 1},
  [29] = {.index = 38, .length = 2},
  [30] = {.index = 40, .length = 3},
  [31] = {.index = 43, .length = 1},
  [32] = {.index = 44, .length = 2},
  [33] = {.index = 46, .length = 2},
  [34] = {.index = 48, .length = 1},
  [35] = {.index = 49, .length = 3},
  [36] = {.index = 52, .length = 2},
  [37] = {.index = 54, .length = 2},
  [38] = {.index = 56, .length = 1},
  [39] = {.index = 57, .length = 2},
  [40] = {.index = 59, .length = 2},
  [41] = {.index = 61, .length = 1},
  [42] = {.index = 62, .length = 2},
  [43] = {.index = 64, .length = 2},
  [44] = {.index = 66, .length = 2},
  [45] = {.index = 68, .length = 1},
  [46] = {.index = 69, .length = 3},
  [47] = {.index = 72, .length = 3},
  [48] = {.index = 75, .length = 3},
  [49] = {.index = 78, .length = 3},
  [50] = {.index = 81, .length = 3},
  [51] = {.index = 84, .length = 1},
  [52] = {.index = 85, .length = 1},
  [53] = {.index = 86, .length = 2},
  [55] = {.index = 88, .length = 2},
  [56] = {.index = 90, .length = 1},
  [57] = {.index = 91, .length = 3},
  [58] = {.index = 94, .length = 1},
  [59] = {.index = 95, .length = 3},
  [60] = {.index = 98, .length = 1},
  [62] = {.index = 99, .length = 2},
  [63] = {.index = 101, .length = 5},
  [64] = {.index = 106, .length = 1},
  [65] = {.index = 107, .length = 1},
  [66] = {.index = 108, .length = 2},
  [67] = {.index = 110, .length = 2},
  [68] = {.index = 112, .length = 2},
  [69] = {.index = 114, .length = 1},
  [70] = {.index = 115, .length = 2},
  [71] = {.index = 117, .length = 1},
  [72] = {.index = 118, .length = 3},
  [73] = {.index = 121, .length = 1},
  [74] = {.index = 122, .length = 1},
  [75] = {.index = 123, .length = 3},
  [76] = {.index = 126, .length = 2},
  [77] = {.index = 128, .length = 3},
  [78] = {.index = 131, .length = 3},
  [79] = {.index = 134, .length = 2},
  [80] = {.index = 136, .length = 2},
  [81] = {.index = 138, .length = 3},
  [82] = {.index = 141, .length = 3},
  [83] = {.index = 144, .length = 4},
  [84] = {.index = 148, .length = 4},
  [85] = {.index = 152, .length = 4},
  [86] = {.index = 156, .length = 4},
  [87] = {.index = 160, .length = 3},
  [88] = {.index = 163, .length = 2},
  [89] = {.index = 165, .length = 2},
  [90] = {.index = 167, .length = 1},
  [91] = {.index = 168, .length = 3},
  [92] = {.index = 171, .length = 2},
  [94] = {.index = 173, .length = 2},
  [95] = {.index = 175, .length = 2},
  [96] = {.index = 177, .length = 2},
  [97] = {.index = 179, .length = 1},
  [98] = {.index = 180, .length = 3},
  [99] = {.index = 183, .length = 2},
  [100] = {.index = 185, .length = 3},
  [101] = {.index = 188, .length = 3},
  [102] = {.index = 191, .length = 3},
  [103] = {.index = 194, .length = 2},
  [104] = {.index = 196, .length = 4},
  [105] = {.index = 200, .length = 4},
  [106] = {.index = 204, .length = 4},
  [107] = {.index = 208, .length = 3},
  [108] = {.index = 211, .length = 3},
  [109] = {.index = 214, .length = 2},
  [110] = {.index = 216, .length = 4},
  [111] = {.index = 220, .length = 3},
  [112] = {.index = 223, .length = 4},
  [113] = {.index = 227, .length = 4},
  [114] = {.index = 231, .length = 5},
  [115] = {.index = 236, .length = 3},
  [116] = {.index = 239, .length = 3},
  [117] = {.index = 242, .length = 3},
  [118] = {.index = 245, .length = 4},
  [119] = {.index = 249, .length = 3},
  [120] = {.index = 252, .length = 3},
  [121] = {.index = 255, .length = 3},
  [122] = {.index = 258, .length = 3},
  [123] = {.index = 261, .length = 4},
  [124] = {.index = 265, .length = 4},
  [125] = {.index = 269, .length = 4},
  [126] = {.index = 273, .length = 4},
  [127] = {.index = 277, .length = 5},
  [128] = {.index = 282, .length = 5},
  [129] = {.index = 287, .length = 5},
  [130] = {.index = 292, .length = 4},
  [131] = {.index = 296, .length = 4},
  [132] = {.index = 300, .length = 4},
  [133] = {.index = 304, .length = 3},
  [134] = {.index = 307, .length = 5},
  [135] = {.index = 312, .length = 4},
  [136] = {.index = 316, .length = 3},
  [137] = {.index = 319, .length = 4},
  [138] = {.index = 323, .length = 4},
  [139] = {.index = 327, .length = 4},
  [140] = {.index = 331, .length = 5},
  [141] = {.index = 336, .length = 5},
  [142] = {.index = 341, .length = 5},
  [143] = {.index = 346, .length = 6},
  [144] = {.index = 352, .length = 4},
  [145] = {.index = 356, .length = 5},
  [146] = {.index = 361, .length = 5},
  [147] = {.index = 366, .length = 5},
  [148] = {.index = 371, .length = 5},
  [149] = {.index = 376, .length = 6},
  [150] = {.index = 382, .length = 5},
  [151] = {.index = 387, .length = 5},
  [152] = {.index = 392, .length = 6},
  [153] = {.index = 398, .length = 6},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_signature, 1},
  [1] =
    {field_parameters, 0},
  [2] =
    {field_operand, 1},
    {field_operator, 0},
  [4] =
    {field_arguments, 1},
    {field_function, 0},
  [6] =
    {field_name, 0},
  [7] =
    {field_body, 1},
  [8] =
    {field_expression_list, 1},
  [9] =
    {field_arguments, 1},
    {field_name, 0},
  [11] =
    {field_body, 1},
    {field_type, 0},
  [13] =
    {field_expression, 1},
  [14] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [16] =
    {field_type, 0},
  [17] =
    {field_name, 1},
    {field_signature, 2},
  [19] =
    {field_body, 2},
    {field_signature, 1},
  [21] =
    {field_parameters, 0},
    {field_result, 1},
  [23] =
    {field_attributes, 0, .inherited = true},
    {field_default_value, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_type, 0, .inherited = true},
  [27] =
    {field_name, 1},
  [28] =
    {field_element, 2},
  [29] =
    {field_block, 2},
    {field_condition, 1},
  [31] =
    {field_block, 2},
    {field_guard, 1},
  [33] =
    {field_body, 2},
    {field_locked_variables, 1},
  [35] =
    {field_modifiers, 0},
    {field_name, 1},
  [37] =
    {field_body, 2},
  [38] =
    {field_field, 2},
    {field_operand, 0},
  [40] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [43] =
    {field_operator, 0},
  [44] =
    {field_channel, 0},
    {field_value, 2},
  [46] =
    {field_left, 0},
    {field_right, 2},
  [48] =
    {field_block, 1},
  [49] =
    {field_arguments, 2},
    {field_name, 0},
    {field_type_parameters, 1},
  [52] =
    {field_module, 0},
    {field_name, 2},
  [54] =
    {field_expression_list, 2},
    {field_var_list, 0},
  [56] =
    {field_attributes, 0},
  [57] =
    {field_key, 0},
    {field_value, 2},
  [59] =
    {field_name, 0},
    {field_value, 2},
  [61] =
    {field_value, 1},
  [62] =
    {field_name, 1},
    {field_type, 3},
  [64] =
    {field_type, 1},
    {field_variadic, 0},
  [66] =
    {field_name, 0},
    {field_type, 1},
  [68] =
    {field_type, 1},
  [69] =
    {field_body, 3},
    {field_name, 1},
    {field_signature, 2},
  [72] =
    {field_generic_parameters, 2},
    {field_name, 1},
    {field_signature, 3},
  [75] =
    {field_name, 2},
    {field_receiver, 1},
    {field_signature, 3},
  [78] =
    {field_body, 3},
    {field_generic_parameters, 1},
    {field_signature, 2},
  [81] =
    {field_body, 3},
    {field_capture_list, 1},
    {field_signature, 2},
  [84] =
    {field_element_list, 2},
  [85] =
    {field_short_element_list, 2},
  [86] =
    {field_generic_parameters, 2},
    {field_name, 1},
  [88] =
    {field_element, 3},
    {field_size, 1},
  [90] =
    {field_value, 2},
  [91] =
    {field_block, 3},
    {field_condition, 1},
    {field_condition, 2},
  [94] =
    {field_condition, 1},
  [95] =
    {field_end, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
    {field_start, 0, .inherited = true},
  [98] =
    {field_selected_variables, 1},
  [99] =
    {field_key, 1},
    {field_value, 3},
  [101] =
    {field_end, 2, .inherited = true},
    {field_left, 0},
    {field_operator, 2, .inherited = true},
    {field_right, 2},
    {field_start, 2, .inherited = true},
  [106] =
    {field_update, 2},
  [107] =
    {field_initializer, 0},
  [108] =
    {field_end, 1},
    {field_operator, 0},
  [110] =
    {field_index, 2},
    {field_operand, 0},
  [112] =
    {field_operator, 1},
    {field_start, 0},
  [114] =
    {field_operand, 0},
  [115] =
    {field_name, 2},
    {field_signature, 3},
  [117] =
    {field_name, 2},
  [118] =
    {field_left, 0},
    {field_left, 1},
    {field_right, 3},
  [121] =
    {field_element_list, 1},
  [122] =
    {field_short_element_list, 1},
  [123] =
    {field_attributes, 0},
    {field_name, 2},
    {field_signature, 3},
  [126] =
    {field_attributes, 0},
    {field_name, 2},
  [128] =
    {field_generic_parameters, 2},
    {field_name, 1},
    {field_type, 4},
  [131] =
    {field_name, 0},
    {field_type, 2},
    {field_variadic, 1},
  [134] =
    {field_name, 1},
    {field_type, 2},
  [136] =
    {field_type, 2},
    {field_variadic, 1},
  [138] =
    {field_mutability, 0},
    {field_name, 1},
    {field_type, 2},
  [141] =
    {field_name, 3},
    {field_signature, 4},
    {field_static_receiver, 1},
  [144] =
    {field_body, 4},
    {field_generic_parameters, 2},
    {field_name, 1},
    {field_signature, 3},
  [148] =
    {field_body, 4},
    {field_name, 2},
    {field_receiver, 1},
    {field_signature, 3},
  [152] =
    {field_generic_parameters, 3},
    {field_name, 2},
    {field_receiver, 1},
    {field_signature, 4},
  [156] =
    {field_body, 4},
    {field_capture_list, 1},
    {field_generic_parameters, 2},
    {field_signature, 3},
  [160] =
    {field_attributes, 2},
    {field_name, 0},
    {field_type, 1},
  [163] =
    {field_attributes, 1},
    {field_name, 0},
  [165] =
    {field_name, 0},
    {field_signature, 1},
  [167] =
    {field_else_branch, 1},
  [168] =
    {field_block, 2},
    {field_condition, 1},
    {field_else_branch, 4},
  [171] =
    {field_block, 1},
    {field_value, 0},
  [173] =
    {field_condition, 1},
    {field_update, 3},
  [175] =
    {field_initializer, 0},
    {field_update, 3},
  [177] =
    {field_condition, 2},
    {field_initializer, 0},
  [179] =
    {field_field, 1},
  [180] =
    {field_end, 2},
    {field_operator, 1},
    {field_start, 0},
  [183] =
    {field_name, 2},
    {field_type, 4},
  [185] =
    {field_body, 4},
    {field_name, 2},
    {field_signature, 3},
  [188] =
    {field_generic_parameters, 3},
    {field_name, 2},
    {field_signature, 4},
  [191] =
    {field_name, 3},
    {field_receiver, 2},
    {field_signature, 4},
  [194] =
    {field_generic_parameters, 3},
    {field_name, 2},
  [196] =
    {field_attributes, 0},
    {field_body, 4},
    {field_name, 2},
    {field_signature, 3},
  [200] =
    {field_attributes, 0},
    {field_generic_parameters, 3},
    {field_name, 2},
    {field_signature, 4},
  [204] =
    {field_attributes, 0},
    {field_name, 3},
    {field_receiver, 2},
    {field_signature, 4},
  [208] =
    {field_attributes, 0},
    {field_generic_parameters, 3},
    {field_name, 2},
  [211] =
    {field_attributes, 0},
    {field_name, 3},
    {field_signature, 4},
  [214] =
    {field_attributes, 0},
    {field_name, 3},
  [216] =
    {field_mutability, 0},
    {field_name, 1},
    {field_type, 3},
    {field_variadic, 2},
  [220] =
    {field_mutability, 1},
    {field_name, 2},
    {field_type, 3},
  [223] =
    {field_body, 5},
    {field_name, 3},
    {field_signature, 4},
    {field_static_receiver, 1},
  [227] =
    {field_generic_parameters, 4},
    {field_name, 3},
    {field_signature, 5},
    {field_static_receiver, 1},
  [231] =
    {field_body, 5},
    {field_generic_parameters, 3},
    {field_name, 2},
    {field_receiver, 1},
    {field_signature, 4},
  [236] =
    {field_default_value, 3},
    {field_name, 0},
    {field_type, 1},
  [239] =
    {field_attributes, 2},
    {field_name, 0},
    {field_signature, 1},
  [242] =
    {field_generic_parameters, 1},
    {field_name, 0},
    {field_signature, 2},
  [245] =
    {field_block, 3},
    {field_condition, 1},
    {field_condition, 2},
    {field_else_branch, 5},
  [249] =
    {field_end, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_start, 1, .inherited = true},
  [252] =
    {field_condition, 2},
    {field_initializer, 0},
    {field_update, 4},
  [255] =
    {field_generic_parameters, 3},
    {field_name, 2},
    {field_type, 5},
  [258] =
    {field_name, 4},
    {field_signature, 5},
    {field_static_receiver, 2},
  [261] =
    {field_body, 5},
    {field_generic_parameters, 3},
    {field_name, 2},
    {field_signature, 4},
  [265] =
    {field_body, 5},
    {field_name, 3},
    {field_receiver, 2},
    {field_signature, 4},
  [269] =
    {field_generic_parameters, 4},
    {field_name, 3},
    {field_receiver, 2},
    {field_signature, 5},
  [273] =
    {field_attributes, 0},
    {field_name, 4},
    {field_signature, 5},
    {field_static_receiver, 2},
  [277] =
    {field_attributes, 0},
    {field_body, 5},
    {field_generic_parameters, 3},
    {field_name, 2},
    {field_signature, 4},
  [282] =
    {field_attributes, 0},
    {field_body, 5},
    {field_name, 3},
    {field_receiver, 2},
    {field_signature, 4},
  [287] =
    {field_attributes, 0},
    {field_generic_parameters, 4},
    {field_name, 3},
    {field_receiver, 2},
    {field_signature, 5},
  [292] =
    {field_attributes, 0},
    {field_body, 5},
    {field_name, 3},
    {field_signature, 4},
  [296] =
    {field_attributes, 0},
    {field_generic_parameters, 4},
    {field_name, 3},
    {field_signature, 5},
  [300] =
    {field_attributes, 0},
    {field_name, 4},
    {field_receiver, 3},
    {field_signature, 5},
  [304] =
    {field_attributes, 0},
    {field_generic_parameters, 4},
    {field_name, 3},
  [307] =
    {field_body, 6},
    {field_generic_parameters, 4},
    {field_name, 3},
    {field_signature, 5},
    {field_static_receiver, 1},
  [312] =
    {field_attributes, 4},
    {field_default_value, 3},
    {field_name, 0},
    {field_type, 1},
  [316] =
    {field_attributes, 3},
    {field_name, 0},
    {field_value, 2},
  [319] =
    {field_attributes, 3},
    {field_generic_parameters, 1},
    {field_name, 0},
    {field_signature, 2},
  [323] =
    {field_body, 6},
    {field_name, 4},
    {field_signature, 5},
    {field_static_receiver, 2},
  [327] =
    {field_generic_parameters, 5},
    {field_name, 4},
    {field_signature, 6},
    {field_static_receiver, 2},
  [331] =
    {field_body, 6},
    {field_generic_parameters, 4},
    {field_name, 3},
    {field_receiver, 2},
    {field_signature, 5},
  [336] =
    {field_attributes, 0},
    {field_body, 6},
    {field_name, 4},
    {field_signature, 5},
    {field_static_receiver, 2},
  [341] =
    {field_attributes, 0},
    {field_generic_parameters, 5},
    {field_name, 4},
    {field_signature, 6},
    {field_static_receiver, 2},
  [346] =
    {field_attributes, 0},
    {field_body, 6},
    {field_generic_parameters, 4},
    {field_name, 3},
    {field_receiver, 2},
    {field_signature, 5},
  [352] =
    {field_attributes, 0},
    {field_name, 5},
    {field_signature, 6},
    {field_static_receiver, 3},
  [356] =
    {field_attributes, 0},
    {field_body, 6},
    {field_generic_parameters, 4},
    {field_name, 3},
    {field_signature, 5},
  [361] =
    {field_attributes, 0},
    {field_body, 6},
    {field_name, 4},
    {field_receiver, 3},
    {field_signature, 5},
  [366] =
    {field_attributes, 0},
    {field_generic_parameters, 5},
    {field_name, 4},
    {field_receiver, 3},
    {field_signature, 6},
  [371] =
    {field_body, 7},
    {field_generic_parameters, 5},
    {field_name, 4},
    {field_signature, 6},
    {field_static_receiver, 2},
  [376] =
    {field_attributes, 0},
    {field_body, 7},
    {field_generic_parameters, 5},
    {field_name, 4},
    {field_signature, 6},
    {field_static_receiver, 2},
  [382] =
    {field_attributes, 0},
    {field_body, 7},
    {field_name, 5},
    {field_signature, 6},
    {field_static_receiver, 3},
  [387] =
    {field_attributes, 0},
    {field_generic_parameters, 6},
    {field_name, 5},
    {field_signature, 7},
    {field_static_receiver, 3},
  [392] =
    {field_attributes, 0},
    {field_body, 7},
    {field_generic_parameters, 5},
    {field_name, 4},
    {field_receiver, 3},
    {field_signature, 6},
  [398] =
    {field_attributes, 0},
    {field_body, 8},
    {field_generic_parameters, 6},
    {field_name, 5},
    {field_signature, 7},
    {field_static_receiver, 3},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [5] = {
    [0] = sym_reference_expression,
  },
  [18] = {
    [0] = alias_sym_element,
  },
  [24] = {
    [1] = alias_sym_interpolation_closing,
  },
  [25] = {
    [0] = alias_sym_interpolation_expression,
  },
  [28] = {
    [0] = sym_mutability_modifiers,
  },
  [54] = {
    [1] = sym_plain_type,
  },
  [61] = {
    [2] = alias_sym_interpolation_closing,
  },
  [79] = {
    [2] = sym_plain_type,
  },
  [93] = {
    [1] = alias_sym_interpolation_expression,
    [3] = alias_sym_interpolation_closing,
  },
  [111] = {
    [3] = sym_plain_type,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__expression, 3,
    sym__expression,
    alias_sym_element,
    alias_sym_interpolation_expression,
  sym__plain_type_without_special, 2,
    sym__plain_type_without_special,
    sym_plain_type,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 13,
  [15] = 15,
  [16] = 15,
  [17] = 15,
  [18] = 15,
  [19] = 15,
  [20] = 15,
  [21] = 15,
  [22] = 15,
  [23] = 15,
  [24] = 15,
  [25] = 15,
  [26] = 15,
  [27] = 15,
  [28] = 15,
  [29] = 15,
  [30] = 15,
  [31] = 15,
  [32] = 15,
  [33] = 15,
  [34] = 15,
  [35] = 15,
  [36] = 15,
  [37] = 15,
  [38] = 15,
  [39] = 15,
  [40] = 15,
  [41] = 15,
  [42] = 42,
  [43] = 43,
  [44] = 42,
  [45] = 43,
  [46] = 43,
  [47] = 42,
  [48] = 43,
  [49] = 43,
  [50] = 43,
  [51] = 42,
  [52] = 42,
  [53] = 43,
  [54] = 43,
  [55] = 43,
  [56] = 43,
  [57] = 42,
  [58] = 42,
  [59] = 42,
  [60] = 42,
  [61] = 43,
  [62] = 43,
  [63] = 42,
  [64] = 42,
  [65] = 42,
  [66] = 42,
  [67] = 42,
  [68] = 42,
  [69] = 43,
  [70] = 43,
  [71] = 42,
  [72] = 43,
  [73] = 42,
  [74] = 42,
  [75] = 43,
  [76] = 42,
  [77] = 42,
  [78] = 43,
  [79] = 43,
  [80] = 42,
  [81] = 81,
  [82] = 43,
  [83] = 42,
  [84] = 43,
  [85] = 43,
  [86] = 42,
  [87] = 43,
  [88] = 43,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 89,
  [96] = 96,
  [97] = 96,
  [98] = 96,
  [99] = 92,
  [100] = 96,
  [101] = 93,
  [102] = 96,
  [103] = 96,
  [104] = 90,
  [105] = 96,
  [106] = 96,
  [107] = 91,
  [108] = 96,
  [109] = 96,
  [110] = 96,
  [111] = 94,
  [112] = 96,
  [113] = 96,
  [114] = 114,
  [115] = 114,
  [116] = 114,
  [117] = 114,
  [118] = 114,
  [119] = 114,
  [120] = 114,
  [121] = 121,
  [122] = 114,
  [123] = 114,
  [124] = 114,
  [125] = 114,
  [126] = 121,
  [127] = 114,
  [128] = 114,
  [129] = 114,
  [130] = 114,
  [131] = 114,
  [132] = 114,
  [133] = 114,
  [134] = 114,
  [135] = 114,
  [136] = 114,
  [137] = 114,
  [138] = 114,
  [139] = 139,
  [140] = 139,
  [141] = 141,
  [142] = 141,
  [143] = 141,
  [144] = 144,
  [145] = 139,
  [146] = 144,
  [147] = 139,
  [148] = 139,
  [149] = 141,
  [150] = 141,
  [151] = 141,
  [152] = 144,
  [153] = 139,
  [154] = 141,
  [155] = 144,
  [156] = 144,
  [157] = 144,
  [158] = 141,
  [159] = 141,
  [160] = 141,
  [161] = 139,
  [162] = 144,
  [163] = 139,
  [164] = 144,
  [165] = 144,
  [166] = 139,
  [167] = 144,
  [168] = 144,
  [169] = 139,
  [170] = 141,
  [171] = 139,
  [172] = 139,
  [173] = 144,
  [174] = 141,
  [175] = 141,
  [176] = 139,
  [177] = 144,
  [178] = 178,
  [179] = 178,
  [180] = 178,
  [181] = 178,
  [182] = 178,
  [183] = 183,
  [184] = 178,
  [185] = 178,
  [186] = 178,
  [187] = 178,
  [188] = 178,
  [189] = 178,
  [190] = 178,
  [191] = 191,
  [192] = 192,
  [193] = 191,
  [194] = 191,
  [195] = 192,
  [196] = 192,
  [197] = 191,
  [198] = 191,
  [199] = 191,
  [200] = 192,
  [201] = 191,
  [202] = 191,
  [203] = 192,
  [204] = 192,
  [205] = 191,
  [206] = 192,
  [207] = 192,
  [208] = 192,
  [209] = 192,
  [210] = 191,
  [211] = 192,
  [212] = 191,
  [213] = 192,
  [214] = 191,
  [215] = 192,
  [216] = 191,
  [217] = 94,
  [218] = 218,
  [219] = 218,
  [220] = 220,
  [221] = 218,
  [222] = 222,
  [223] = 90,
  [224] = 218,
  [225] = 218,
  [226] = 218,
  [227] = 92,
  [228] = 218,
  [229] = 229,
  [230] = 91,
  [231] = 218,
  [232] = 218,
  [233] = 218,
  [234] = 218,
  [235] = 235,
  [236] = 93,
  [237] = 237,
  [238] = 218,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 260,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 264,
  [268] = 263,
  [269] = 260,
  [270] = 264,
  [271] = 271,
  [272] = 266,
  [273] = 266,
  [274] = 266,
  [275] = 264,
  [276] = 263,
  [277] = 260,
  [278] = 264,
  [279] = 264,
  [280] = 266,
  [281] = 271,
  [282] = 263,
  [283] = 264,
  [284] = 263,
  [285] = 260,
  [286] = 266,
  [287] = 265,
  [288] = 288,
  [289] = 260,
  [290] = 290,
  [291] = 291,
  [292] = 264,
  [293] = 266,
  [294] = 264,
  [295] = 263,
  [296] = 264,
  [297] = 264,
  [298] = 266,
  [299] = 266,
  [300] = 264,
  [301] = 266,
  [302] = 260,
  [303] = 264,
  [304] = 260,
  [305] = 260,
  [306] = 263,
  [307] = 263,
  [308] = 264,
  [309] = 264,
  [310] = 310,
  [311] = 264,
  [312] = 288,
  [313] = 313,
  [314] = 260,
  [315] = 263,
  [316] = 266,
  [317] = 264,
  [318] = 260,
  [319] = 266,
  [320] = 264,
  [321] = 264,
  [322] = 263,
  [323] = 260,
  [324] = 263,
  [325] = 264,
  [326] = 263,
  [327] = 264,
  [328] = 260,
  [329] = 263,
  [330] = 264,
  [331] = 266,
  [332] = 264,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 337,
  [340] = 335,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 335,
  [346] = 346,
  [347] = 337,
  [348] = 348,
  [349] = 344,
  [350] = 338,
  [351] = 351,
  [352] = 335,
  [353] = 344,
  [354] = 338,
  [355] = 337,
  [356] = 344,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 335,
  [362] = 338,
  [363] = 337,
  [364] = 338,
  [365] = 337,
  [366] = 335,
  [367] = 367,
  [368] = 335,
  [369] = 338,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 343,
  [376] = 337,
  [377] = 337,
  [378] = 338,
  [379] = 379,
  [380] = 380,
  [381] = 335,
  [382] = 335,
  [383] = 383,
  [384] = 335,
  [385] = 335,
  [386] = 386,
  [387] = 387,
  [388] = 357,
  [389] = 389,
  [390] = 390,
  [391] = 335,
  [392] = 392,
  [393] = 335,
  [394] = 335,
  [395] = 395,
  [396] = 343,
  [397] = 373,
  [398] = 337,
  [399] = 338,
  [400] = 337,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 335,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 338,
  [411] = 371,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 335,
  [416] = 344,
  [417] = 335,
  [418] = 343,
  [419] = 335,
  [420] = 335,
  [421] = 421,
  [422] = 335,
  [423] = 335,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 337,
  [433] = 338,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 335,
  [438] = 438,
  [439] = 344,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 344,
  [445] = 313,
  [446] = 446,
  [447] = 447,
  [448] = 357,
  [449] = 343,
  [450] = 450,
  [451] = 430,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 338,
  [459] = 346,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 343,
  [465] = 344,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 343,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 343,
  [477] = 477,
  [478] = 343,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 344,
  [487] = 487,
  [488] = 371,
  [489] = 335,
  [490] = 490,
  [491] = 373,
  [492] = 462,
  [493] = 493,
  [494] = 494,
  [495] = 344,
  [496] = 338,
  [497] = 497,
  [498] = 343,
  [499] = 499,
  [500] = 337,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 344,
  [505] = 505,
  [506] = 403,
  [507] = 344,
  [508] = 508,
  [509] = 343,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 344,
  [517] = 517,
  [518] = 344,
  [519] = 519,
  [520] = 520,
  [521] = 371,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 373,
  [526] = 526,
  [527] = 343,
  [528] = 528,
  [529] = 529,
  [530] = 344,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 532,
  [535] = 346,
  [536] = 532,
  [537] = 537,
  [538] = 532,
  [539] = 532,
  [540] = 540,
  [541] = 541,
  [542] = 92,
  [543] = 532,
  [544] = 93,
  [545] = 532,
  [546] = 532,
  [547] = 94,
  [548] = 90,
  [549] = 532,
  [550] = 537,
  [551] = 532,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 532,
  [556] = 553,
  [557] = 553,
  [558] = 553,
  [559] = 559,
  [560] = 533,
  [561] = 553,
  [562] = 562,
  [563] = 553,
  [564] = 564,
  [565] = 537,
  [566] = 91,
  [567] = 532,
  [568] = 553,
  [569] = 553,
  [570] = 553,
  [571] = 553,
  [572] = 532,
  [573] = 533,
  [574] = 537,
  [575] = 553,
  [576] = 537,
  [577] = 537,
  [578] = 532,
  [579] = 532,
  [580] = 532,
  [581] = 532,
  [582] = 533,
  [583] = 553,
  [584] = 553,
  [585] = 346,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 586,
  [590] = 590,
  [591] = 346,
  [592] = 592,
  [593] = 587,
  [594] = 346,
  [595] = 595,
  [596] = 590,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 346,
  [601] = 601,
  [602] = 587,
  [603] = 603,
  [604] = 604,
  [605] = 599,
  [606] = 606,
  [607] = 590,
  [608] = 608,
  [609] = 609,
  [610] = 598,
  [611] = 595,
  [612] = 612,
  [613] = 590,
  [614] = 586,
  [615] = 603,
  [616] = 616,
  [617] = 604,
  [618] = 587,
  [619] = 619,
  [620] = 598,
  [621] = 619,
  [622] = 616,
  [623] = 590,
  [624] = 619,
  [625] = 601,
  [626] = 616,
  [627] = 590,
  [628] = 628,
  [629] = 601,
  [630] = 592,
  [631] = 597,
  [632] = 597,
  [633] = 587,
  [634] = 346,
  [635] = 346,
  [636] = 587,
  [637] = 592,
  [638] = 597,
  [639] = 587,
  [640] = 592,
  [641] = 601,
  [642] = 590,
  [643] = 616,
  [644] = 592,
  [645] = 587,
  [646] = 346,
  [647] = 597,
  [648] = 601,
  [649] = 590,
  [650] = 616,
  [651] = 595,
  [652] = 612,
  [653] = 616,
  [654] = 586,
  [655] = 590,
  [656] = 603,
  [657] = 592,
  [658] = 601,
  [659] = 604,
  [660] = 597,
  [661] = 597,
  [662] = 599,
  [663] = 663,
  [664] = 587,
  [665] = 609,
  [666] = 601,
  [667] = 592,
  [668] = 616,
  [669] = 587,
  [670] = 346,
  [671] = 590,
  [672] = 612,
  [673] = 606,
  [674] = 674,
  [675] = 608,
  [676] = 609,
  [677] = 598,
  [678] = 678,
  [679] = 616,
  [680] = 590,
  [681] = 606,
  [682] = 601,
  [683] = 597,
  [684] = 346,
  [685] = 608,
  [686] = 587,
  [687] = 687,
  [688] = 592,
  [689] = 609,
  [690] = 598,
  [691] = 606,
  [692] = 595,
  [693] = 599,
  [694] = 612,
  [695] = 604,
  [696] = 586,
  [697] = 603,
  [698] = 603,
  [699] = 608,
  [700] = 604,
  [701] = 599,
  [702] = 586,
  [703] = 609,
  [704] = 612,
  [705] = 598,
  [706] = 595,
  [707] = 606,
  [708] = 608,
  [709] = 609,
  [710] = 598,
  [711] = 606,
  [712] = 712,
  [713] = 608,
  [714] = 619,
  [715] = 616,
  [716] = 590,
  [717] = 601,
  [718] = 609,
  [719] = 597,
  [720] = 346,
  [721] = 598,
  [722] = 606,
  [723] = 608,
  [724] = 587,
  [725] = 592,
  [726] = 609,
  [727] = 598,
  [728] = 592,
  [729] = 606,
  [730] = 608,
  [731] = 616,
  [732] = 590,
  [733] = 733,
  [734] = 609,
  [735] = 601,
  [736] = 598,
  [737] = 587,
  [738] = 606,
  [739] = 597,
  [740] = 740,
  [741] = 608,
  [742] = 587,
  [743] = 592,
  [744] = 744,
  [745] = 609,
  [746] = 616,
  [747] = 599,
  [748] = 590,
  [749] = 606,
  [750] = 608,
  [751] = 595,
  [752] = 612,
  [753] = 601,
  [754] = 754,
  [755] = 597,
  [756] = 346,
  [757] = 757,
  [758] = 346,
  [759] = 587,
  [760] = 597,
  [761] = 592,
  [762] = 609,
  [763] = 598,
  [764] = 601,
  [765] = 606,
  [766] = 590,
  [767] = 608,
  [768] = 586,
  [769] = 603,
  [770] = 609,
  [771] = 598,
  [772] = 608,
  [773] = 595,
  [774] = 774,
  [775] = 604,
  [776] = 612,
  [777] = 604,
  [778] = 616,
  [779] = 603,
  [780] = 780,
  [781] = 687,
  [782] = 586,
  [783] = 612,
  [784] = 599,
  [785] = 604,
  [786] = 595,
  [787] = 599,
  [788] = 619,
  [789] = 789,
  [790] = 599,
  [791] = 774,
  [792] = 604,
  [793] = 603,
  [794] = 612,
  [795] = 616,
  [796] = 590,
  [797] = 601,
  [798] = 612,
  [799] = 595,
  [800] = 597,
  [801] = 346,
  [802] = 802,
  [803] = 587,
  [804] = 592,
  [805] = 603,
  [806] = 586,
  [807] = 612,
  [808] = 595,
  [809] = 595,
  [810] = 612,
  [811] = 586,
  [812] = 599,
  [813] = 619,
  [814] = 604,
  [815] = 603,
  [816] = 586,
  [817] = 612,
  [818] = 595,
  [819] = 628,
  [820] = 599,
  [821] = 588,
  [822] = 603,
  [823] = 674,
  [824] = 604,
  [825] = 599,
  [826] = 595,
  [827] = 612,
  [828] = 586,
  [829] = 595,
  [830] = 612,
  [831] = 586,
  [832] = 603,
  [833] = 604,
  [834] = 599,
  [835] = 603,
  [836] = 604,
  [837] = 599,
  [838] = 604,
  [839] = 595,
  [840] = 603,
  [841] = 612,
  [842] = 586,
  [843] = 603,
  [844] = 604,
  [845] = 599,
  [846] = 712,
  [847] = 733,
  [848] = 740,
  [849] = 616,
  [850] = 590,
  [851] = 601,
  [852] = 597,
  [853] = 346,
  [854] = 687,
  [855] = 595,
  [856] = 612,
  [857] = 586,
  [858] = 603,
  [859] = 587,
  [860] = 592,
  [861] = 604,
  [862] = 599,
  [863] = 595,
  [864] = 603,
  [865] = 586,
  [866] = 603,
  [867] = 604,
  [868] = 599,
  [869] = 619,
  [870] = 870,
  [871] = 595,
  [872] = 612,
  [873] = 586,
  [874] = 616,
  [875] = 586,
  [876] = 604,
  [877] = 592,
  [878] = 878,
  [879] = 599,
  [880] = 587,
  [881] = 780,
  [882] = 789,
  [883] = 346,
  [884] = 619,
  [885] = 595,
  [886] = 612,
  [887] = 597,
  [888] = 592,
  [889] = 587,
  [890] = 586,
  [891] = 590,
  [892] = 601,
  [893] = 590,
  [894] = 894,
  [895] = 346,
  [896] = 597,
  [897] = 601,
  [898] = 590,
  [899] = 616,
  [900] = 592,
  [901] = 616,
  [902] = 601,
  [903] = 599,
  [904] = 597,
  [905] = 587,
  [906] = 616,
  [907] = 590,
  [908] = 601,
  [909] = 597,
  [910] = 346,
  [911] = 587,
  [912] = 604,
  [913] = 603,
  [914] = 586,
  [915] = 612,
  [916] = 595,
  [917] = 346,
  [918] = 619,
  [919] = 592,
  [920] = 597,
  [921] = 601,
  [922] = 590,
  [923] = 346,
  [924] = 616,
  [925] = 592,
  [926] = 603,
  [927] = 604,
  [928] = 599,
  [929] = 597,
  [930] = 601,
  [931] = 616,
  [932] = 619,
  [933] = 587,
  [934] = 346,
  [935] = 587,
  [936] = 592,
  [937] = 590,
  [938] = 619,
  [939] = 789,
  [940] = 595,
  [941] = 619,
  [942] = 870,
  [943] = 789,
  [944] = 789,
  [945] = 603,
  [946] = 612,
  [947] = 789,
  [948] = 789,
  [949] = 789,
  [950] = 789,
  [951] = 608,
  [952] = 619,
  [953] = 616,
  [954] = 590,
  [955] = 789,
  [956] = 601,
  [957] = 597,
  [958] = 346,
  [959] = 789,
  [960] = 586,
  [961] = 586,
  [962] = 599,
  [963] = 604,
  [964] = 789,
  [965] = 789,
  [966] = 619,
  [967] = 612,
  [968] = 616,
  [969] = 587,
  [970] = 590,
  [971] = 601,
  [972] = 597,
  [973] = 595,
  [974] = 592,
  [975] = 603,
  [976] = 604,
  [977] = 599,
  [978] = 346,
  [979] = 587,
  [980] = 592,
  [981] = 606,
  [982] = 255,
  [983] = 254,
  [984] = 244,
  [985] = 248,
  [986] = 245,
  [987] = 249,
  [988] = 250,
  [989] = 247,
  [990] = 256,
  [991] = 253,
  [992] = 246,
  [993] = 242,
  [994] = 251,
  [995] = 258,
  [996] = 257,
  [997] = 252,
  [998] = 259,
  [999] = 261,
  [1000] = 271,
  [1001] = 271,
  [1002] = 288,
  [1003] = 291,
  [1004] = 288,
  [1005] = 429,
  [1006] = 313,
  [1007] = 421,
  [1008] = 342,
  [1009] = 446,
  [1010] = 358,
  [1011] = 360,
  [1012] = 408,
  [1013] = 407,
  [1014] = 405,
  [1015] = 404,
  [1016] = 390,
  [1017] = 389,
  [1018] = 471,
  [1019] = 523,
  [1020] = 474,
  [1021] = 370,
  [1022] = 481,
  [1023] = 351,
  [1024] = 359,
  [1025] = 341,
  [1026] = 333,
  [1027] = 483,
  [1028] = 290,
  [1029] = 290,
  [1030] = 348,
  [1031] = 357,
  [1032] = 520,
  [1033] = 508,
  [1034] = 334,
  [1035] = 505,
  [1036] = 443,
  [1037] = 412,
  [1038] = 313,
  [1039] = 436,
  [1040] = 426,
  [1041] = 403,
  [1042] = 336,
  [1043] = 383,
  [1044] = 380,
  [1045] = 401,
  [1046] = 379,
  [1047] = 453,
  [1048] = 454,
  [1049] = 409,
  [1050] = 463,
  [1051] = 424,
  [1052] = 455,
  [1053] = 427,
  [1054] = 466,
  [1055] = 431,
  [1056] = 434,
  [1057] = 435,
  [1058] = 467,
  [1059] = 442,
  [1060] = 367,
  [1061] = 395,
  [1062] = 456,
  [1063] = 457,
  [1064] = 468,
  [1065] = 461,
  [1066] = 460,
  [1067] = 450,
  [1068] = 386,
  [1069] = 490,
  [1070] = 469,
  [1071] = 470,
  [1072] = 473,
  [1073] = 475,
  [1074] = 479,
  [1075] = 480,
  [1076] = 477,
  [1077] = 482,
  [1078] = 485,
  [1079] = 512,
  [1080] = 387,
  [1081] = 513,
  [1082] = 357,
  [1083] = 499,
  [1084] = 514,
  [1085] = 515,
  [1086] = 517,
  [1087] = 519,
  [1088] = 528,
  [1089] = 428,
  [1090] = 425,
  [1091] = 529,
  [1092] = 414,
  [1093] = 413,
  [1094] = 531,
  [1095] = 441,
  [1096] = 438,
  [1097] = 484,
  [1098] = 403,
  [1099] = 511,
  [1100] = 526,
  [1101] = 524,
  [1102] = 510,
  [1103] = 522,
  [1104] = 503,
  [1105] = 497,
  [1106] = 494,
  [1107] = 502,
  [1108] = 501,
  [1109] = 447,
  [1110] = 493,
  [1111] = 452,
  [1112] = 1112,
  [1113] = 357,
  [1114] = 93,
  [1115] = 91,
  [1116] = 94,
  [1117] = 92,
  [1118] = 90,
  [1119] = 1119,
  [1120] = 248,
  [1121] = 246,
  [1122] = 252,
  [1123] = 1123,
  [1124] = 245,
  [1125] = 247,
  [1126] = 254,
  [1127] = 256,
  [1128] = 251,
  [1129] = 249,
  [1130] = 253,
  [1131] = 250,
  [1132] = 1132,
  [1133] = 1133,
  [1134] = 254,
  [1135] = 257,
  [1136] = 1136,
  [1137] = 251,
  [1138] = 245,
  [1139] = 258,
  [1140] = 1140,
  [1141] = 1141,
  [1142] = 246,
  [1143] = 253,
  [1144] = 247,
  [1145] = 256,
  [1146] = 90,
  [1147] = 92,
  [1148] = 291,
  [1149] = 94,
  [1150] = 271,
  [1151] = 271,
  [1152] = 93,
  [1153] = 288,
  [1154] = 288,
  [1155] = 259,
  [1156] = 91,
  [1157] = 261,
  [1158] = 515,
  [1159] = 514,
  [1160] = 523,
  [1161] = 508,
  [1162] = 334,
  [1163] = 505,
  [1164] = 443,
  [1165] = 436,
  [1166] = 426,
  [1167] = 336,
  [1168] = 383,
  [1169] = 380,
  [1170] = 455,
  [1171] = 395,
  [1172] = 379,
  [1173] = 367,
  [1174] = 403,
  [1175] = 483,
  [1176] = 386,
  [1177] = 387,
  [1178] = 475,
  [1179] = 477,
  [1180] = 438,
  [1181] = 447,
  [1182] = 452,
  [1183] = 494,
  [1184] = 497,
  [1185] = 503,
  [1186] = 522,
  [1187] = 524,
  [1188] = 526,
  [1189] = 484,
  [1190] = 441,
  [1191] = 413,
  [1192] = 414,
  [1193] = 425,
  [1194] = 428,
  [1195] = 499,
  [1196] = 529,
  [1197] = 482,
  [1198] = 480,
  [1199] = 479,
  [1200] = 460,
  [1201] = 457,
  [1202] = 456,
  [1203] = 357,
  [1204] = 435,
  [1205] = 434,
  [1206] = 431,
  [1207] = 313,
  [1208] = 427,
  [1209] = 403,
  [1210] = 342,
  [1211] = 424,
  [1212] = 461,
  [1213] = 401,
  [1214] = 429,
  [1215] = 442,
  [1216] = 360,
  [1217] = 357,
  [1218] = 450,
  [1219] = 358,
  [1220] = 348,
  [1221] = 493,
  [1222] = 469,
  [1223] = 341,
  [1224] = 470,
  [1225] = 351,
  [1226] = 473,
  [1227] = 370,
  [1228] = 389,
  [1229] = 390,
  [1230] = 404,
  [1231] = 405,
  [1232] = 407,
  [1233] = 408,
  [1234] = 501,
  [1235] = 502,
  [1236] = 510,
  [1237] = 511,
  [1238] = 453,
  [1239] = 454,
  [1240] = 463,
  [1241] = 466,
  [1242] = 467,
  [1243] = 468,
  [1244] = 490,
  [1245] = 409,
  [1246] = 412,
  [1247] = 313,
  [1248] = 520,
  [1249] = 531,
  [1250] = 481,
  [1251] = 474,
  [1252] = 471,
  [1253] = 528,
  [1254] = 519,
  [1255] = 517,
  [1256] = 446,
  [1257] = 421,
  [1258] = 485,
  [1259] = 513,
  [1260] = 512,
  [1261] = 359,
  [1262] = 333,
  [1263] = 409,
  [1264] = 1119,
  [1265] = 254,
  [1266] = 246,
  [1267] = 253,
  [1268] = 256,
  [1269] = 247,
  [1270] = 1132,
  [1271] = 245,
  [1272] = 251,
  [1273] = 252,
  [1274] = 1123,
  [1275] = 248,
  [1276] = 249,
  [1277] = 250,
  [1278] = 257,
  [1279] = 258,
  [1280] = 92,
  [1281] = 93,
  [1282] = 251,
  [1283] = 256,
  [1284] = 246,
  [1285] = 90,
  [1286] = 245,
  [1287] = 247,
  [1288] = 1136,
  [1289] = 1133,
  [1290] = 253,
  [1291] = 254,
  [1292] = 288,
  [1293] = 288,
  [1294] = 261,
  [1295] = 259,
  [1296] = 271,
  [1297] = 271,
  [1298] = 291,
  [1299] = 387,
  [1300] = 380,
  [1301] = 460,
  [1302] = 456,
  [1303] = 485,
  [1304] = 435,
  [1305] = 434,
  [1306] = 512,
  [1307] = 357,
  [1308] = 403,
  [1309] = 431,
  [1310] = 479,
  [1311] = 421,
  [1312] = 493,
  [1313] = 446,
  [1314] = 471,
  [1315] = 450,
  [1316] = 480,
  [1317] = 474,
  [1318] = 409,
  [1319] = 481,
  [1320] = 342,
  [1321] = 520,
  [1322] = 461,
  [1323] = 490,
  [1324] = 442,
  [1325] = 358,
  [1326] = 468,
  [1327] = 429,
  [1328] = 529,
  [1329] = 467,
  [1330] = 466,
  [1331] = 463,
  [1332] = 469,
  [1333] = 494,
  [1334] = 454,
  [1335] = 453,
  [1336] = 470,
  [1337] = 473,
  [1338] = 408,
  [1339] = 407,
  [1340] = 93,
  [1341] = 403,
  [1342] = 313,
  [1343] = 405,
  [1344] = 508,
  [1345] = 334,
  [1346] = 505,
  [1347] = 412,
  [1348] = 443,
  [1349] = 436,
  [1350] = 426,
  [1351] = 336,
  [1352] = 383,
  [1353] = 510,
  [1354] = 379,
  [1355] = 404,
  [1356] = 367,
  [1357] = 513,
  [1358] = 386,
  [1359] = 457,
  [1360] = 390,
  [1361] = 389,
  [1362] = 455,
  [1363] = 483,
  [1364] = 438,
  [1365] = 482,
  [1366] = 92,
  [1367] = 370,
  [1368] = 511,
  [1369] = 477,
  [1370] = 475,
  [1371] = 447,
  [1372] = 313,
  [1373] = 90,
  [1374] = 409,
  [1375] = 452,
  [1376] = 531,
  [1377] = 351,
  [1378] = 359,
  [1379] = 523,
  [1380] = 497,
  [1381] = 503,
  [1382] = 522,
  [1383] = 501,
  [1384] = 360,
  [1385] = 341,
  [1386] = 333,
  [1387] = 524,
  [1388] = 526,
  [1389] = 484,
  [1390] = 348,
  [1391] = 514,
  [1392] = 515,
  [1393] = 401,
  [1394] = 502,
  [1395] = 424,
  [1396] = 441,
  [1397] = 528,
  [1398] = 427,
  [1399] = 413,
  [1400] = 414,
  [1401] = 425,
  [1402] = 428,
  [1403] = 357,
  [1404] = 519,
  [1405] = 395,
  [1406] = 517,
  [1407] = 499,
  [1408] = 1408,
  [1409] = 250,
  [1410] = 256,
  [1411] = 248,
  [1412] = 254,
  [1413] = 251,
  [1414] = 249,
  [1415] = 246,
  [1416] = 253,
  [1417] = 247,
  [1418] = 245,
  [1419] = 252,
  [1420] = 1420,
  [1421] = 1421,
  [1422] = 1422,
  [1423] = 258,
  [1424] = 257,
  [1425] = 288,
  [1426] = 291,
  [1427] = 1427,
  [1428] = 403,
  [1429] = 271,
  [1430] = 261,
  [1431] = 288,
  [1432] = 259,
  [1433] = 271,
  [1434] = 1434,
  [1435] = 379,
  [1436] = 529,
  [1437] = 91,
  [1438] = 523,
  [1439] = 424,
  [1440] = 92,
  [1441] = 1441,
  [1442] = 427,
  [1443] = 93,
  [1444] = 431,
  [1445] = 91,
  [1446] = 434,
  [1447] = 454,
  [1448] = 435,
  [1449] = 90,
  [1450] = 456,
  [1451] = 457,
  [1452] = 460,
  [1453] = 342,
  [1454] = 479,
  [1455] = 480,
  [1456] = 482,
  [1457] = 461,
  [1458] = 453,
  [1459] = 358,
  [1460] = 469,
  [1461] = 470,
  [1462] = 94,
  [1463] = 463,
  [1464] = 473,
  [1465] = 341,
  [1466] = 485,
  [1467] = 409,
  [1468] = 360,
  [1469] = 494,
  [1470] = 351,
  [1471] = 370,
  [1472] = 428,
  [1473] = 499,
  [1474] = 425,
  [1475] = 421,
  [1476] = 403,
  [1477] = 1477,
  [1478] = 92,
  [1479] = 414,
  [1480] = 413,
  [1481] = 441,
  [1482] = 359,
  [1483] = 484,
  [1484] = 333,
  [1485] = 526,
  [1486] = 524,
  [1487] = 522,
  [1488] = 93,
  [1489] = 466,
  [1490] = 503,
  [1491] = 497,
  [1492] = 446,
  [1493] = 471,
  [1494] = 474,
  [1495] = 467,
  [1496] = 481,
  [1497] = 452,
  [1498] = 447,
  [1499] = 468,
  [1500] = 313,
  [1501] = 404,
  [1502] = 438,
  [1503] = 387,
  [1504] = 512,
  [1505] = 386,
  [1506] = 520,
  [1507] = 367,
  [1508] = 348,
  [1509] = 380,
  [1510] = 383,
  [1511] = 508,
  [1512] = 513,
  [1513] = 511,
  [1514] = 390,
  [1515] = 443,
  [1516] = 389,
  [1517] = 90,
  [1518] = 514,
  [1519] = 515,
  [1520] = 408,
  [1521] = 505,
  [1522] = 426,
  [1523] = 91,
  [1524] = 334,
  [1525] = 407,
  [1526] = 336,
  [1527] = 483,
  [1528] = 429,
  [1529] = 442,
  [1530] = 405,
  [1531] = 450,
  [1532] = 493,
  [1533] = 94,
  [1534] = 501,
  [1535] = 502,
  [1536] = 517,
  [1537] = 1441,
  [1538] = 477,
  [1539] = 475,
  [1540] = 357,
  [1541] = 510,
  [1542] = 436,
  [1543] = 490,
  [1544] = 412,
  [1545] = 519,
  [1546] = 395,
  [1547] = 531,
  [1548] = 401,
  [1549] = 528,
  [1550] = 455,
  [1551] = 357,
  [1552] = 250,
  [1553] = 248,
  [1554] = 94,
  [1555] = 249,
  [1556] = 1556,
  [1557] = 257,
  [1558] = 1556,
  [1559] = 258,
  [1560] = 288,
  [1561] = 261,
  [1562] = 251,
  [1563] = 291,
  [1564] = 421,
  [1565] = 463,
  [1566] = 454,
  [1567] = 251,
  [1568] = 453,
  [1569] = 254,
  [1570] = 271,
  [1571] = 245,
  [1572] = 288,
  [1573] = 259,
  [1574] = 1574,
  [1575] = 254,
  [1576] = 431,
  [1577] = 434,
  [1578] = 435,
  [1579] = 246,
  [1580] = 403,
  [1581] = 253,
  [1582] = 1408,
  [1583] = 256,
  [1584] = 247,
  [1585] = 271,
  [1586] = 246,
  [1587] = 253,
  [1588] = 256,
  [1589] = 247,
  [1590] = 245,
  [1591] = 414,
  [1592] = 522,
  [1593] = 508,
  [1594] = 505,
  [1595] = 360,
  [1596] = 443,
  [1597] = 436,
  [1598] = 426,
  [1599] = 336,
  [1600] = 383,
  [1601] = 380,
  [1602] = 379,
  [1603] = 367,
  [1604] = 1604,
  [1605] = 386,
  [1606] = 387,
  [1607] = 483,
  [1608] = 342,
  [1609] = 455,
  [1610] = 395,
  [1611] = 438,
  [1612] = 479,
  [1613] = 461,
  [1614] = 475,
  [1615] = 477,
  [1616] = 447,
  [1617] = 452,
  [1618] = 358,
  [1619] = 469,
  [1620] = 494,
  [1621] = 497,
  [1622] = 503,
  [1623] = 334,
  [1624] = 524,
  [1625] = 470,
  [1626] = 473,
  [1627] = 526,
  [1628] = 403,
  [1629] = 484,
  [1630] = 529,
  [1631] = 441,
  [1632] = 413,
  [1633] = 485,
  [1634] = 523,
  [1635] = 359,
  [1636] = 333,
  [1637] = 425,
  [1638] = 428,
  [1639] = 499,
  [1640] = 482,
  [1641] = 480,
  [1642] = 446,
  [1643] = 512,
  [1644] = 427,
  [1645] = 460,
  [1646] = 513,
  [1647] = 514,
  [1648] = 515,
  [1649] = 357,
  [1650] = 517,
  [1651] = 457,
  [1652] = 519,
  [1653] = 528,
  [1654] = 471,
  [1655] = 429,
  [1656] = 474,
  [1657] = 442,
  [1658] = 456,
  [1659] = 481,
  [1660] = 520,
  [1661] = 531,
  [1662] = 424,
  [1663] = 450,
  [1664] = 490,
  [1665] = 401,
  [1666] = 348,
  [1667] = 468,
  [1668] = 467,
  [1669] = 412,
  [1670] = 466,
  [1671] = 493,
  [1672] = 408,
  [1673] = 407,
  [1674] = 405,
  [1675] = 341,
  [1676] = 351,
  [1677] = 511,
  [1678] = 510,
  [1679] = 502,
  [1680] = 404,
  [1681] = 1681,
  [1682] = 390,
  [1683] = 389,
  [1684] = 370,
  [1685] = 501,
  [1686] = 1686,
  [1687] = 313,
  [1688] = 1688,
  [1689] = 409,
  [1690] = 91,
  [1691] = 409,
  [1692] = 1692,
  [1693] = 1693,
  [1694] = 90,
  [1695] = 93,
  [1696] = 92,
  [1697] = 94,
  [1698] = 313,
  [1699] = 291,
  [1700] = 93,
  [1701] = 333,
  [1702] = 1702,
  [1703] = 1703,
  [1704] = 1704,
  [1705] = 1705,
  [1706] = 92,
  [1707] = 1707,
  [1708] = 1708,
  [1709] = 403,
  [1710] = 90,
  [1711] = 359,
  [1712] = 512,
  [1713] = 91,
  [1714] = 395,
  [1715] = 1715,
  [1716] = 529,
  [1717] = 1717,
  [1718] = 358,
  [1719] = 429,
  [1720] = 485,
  [1721] = 442,
  [1722] = 450,
  [1723] = 475,
  [1724] = 477,
  [1725] = 473,
  [1726] = 493,
  [1727] = 501,
  [1728] = 502,
  [1729] = 342,
  [1730] = 291,
  [1731] = 461,
  [1732] = 510,
  [1733] = 455,
  [1734] = 1734,
  [1735] = 511,
  [1736] = 1736,
  [1737] = 1737,
  [1738] = 531,
  [1739] = 528,
  [1740] = 1740,
  [1741] = 519,
  [1742] = 469,
  [1743] = 470,
  [1744] = 513,
  [1745] = 517,
  [1746] = 412,
  [1747] = 514,
  [1748] = 515,
  [1749] = 1749,
  [1750] = 1750,
  [1751] = 1751,
  [1752] = 403,
  [1753] = 1753,
  [1754] = 1754,
  [1755] = 1755,
  [1756] = 1756,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1759,
  [1760] = 1760,
  [1761] = 1761,
  [1762] = 1762,
  [1763] = 1763,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 1766,
  [1767] = 1767,
  [1768] = 1768,
  [1769] = 1769,
  [1770] = 1770,
  [1771] = 1771,
  [1772] = 1772,
  [1773] = 1773,
  [1774] = 359,
  [1775] = 333,
  [1776] = 1776,
  [1777] = 1777,
  [1778] = 1778,
  [1779] = 501,
  [1780] = 1780,
  [1781] = 1781,
  [1782] = 1782,
  [1783] = 1783,
  [1784] = 1784,
  [1785] = 1785,
  [1786] = 1786,
  [1787] = 1787,
  [1788] = 1788,
  [1789] = 1789,
  [1790] = 1790,
  [1791] = 1791,
  [1792] = 1792,
  [1793] = 1793,
  [1794] = 1794,
  [1795] = 1795,
  [1796] = 1796,
  [1797] = 1797,
  [1798] = 1798,
  [1799] = 1799,
  [1800] = 1800,
  [1801] = 395,
  [1802] = 455,
  [1803] = 1803,
  [1804] = 1804,
  [1805] = 1805,
  [1806] = 485,
  [1807] = 513,
  [1808] = 1808,
  [1809] = 358,
  [1810] = 1810,
  [1811] = 469,
  [1812] = 1812,
  [1813] = 1813,
  [1814] = 1814,
  [1815] = 1815,
  [1816] = 1816,
  [1817] = 1817,
  [1818] = 1818,
  [1819] = 511,
  [1820] = 1820,
  [1821] = 1821,
  [1822] = 1822,
  [1823] = 1823,
  [1824] = 91,
  [1825] = 1825,
  [1826] = 1826,
  [1827] = 1827,
  [1828] = 288,
  [1829] = 1829,
  [1830] = 470,
  [1831] = 1831,
  [1832] = 1832,
  [1833] = 473,
  [1834] = 475,
  [1835] = 1835,
  [1836] = 477,
  [1837] = 1837,
  [1838] = 91,
  [1839] = 412,
  [1840] = 1840,
  [1841] = 1841,
  [1842] = 342,
  [1843] = 1843,
  [1844] = 493,
  [1845] = 1845,
  [1846] = 1846,
  [1847] = 1847,
  [1848] = 531,
  [1849] = 1849,
  [1850] = 1850,
  [1851] = 450,
  [1852] = 271,
  [1853] = 494,
  [1854] = 1854,
  [1855] = 1855,
  [1856] = 461,
  [1857] = 1857,
  [1858] = 512,
  [1859] = 517,
  [1860] = 1860,
  [1861] = 529,
  [1862] = 502,
  [1863] = 1863,
  [1864] = 1864,
  [1865] = 1865,
  [1866] = 1866,
  [1867] = 1867,
  [1868] = 1868,
  [1869] = 1869,
  [1870] = 528,
  [1871] = 1871,
  [1872] = 1872,
  [1873] = 1873,
  [1874] = 1874,
  [1875] = 429,
  [1876] = 1876,
  [1877] = 1877,
  [1878] = 519,
  [1879] = 1879,
  [1880] = 1880,
  [1881] = 442,
  [1882] = 1882,
  [1883] = 510,
  [1884] = 1884,
  [1885] = 1885,
  [1886] = 1886,
  [1887] = 1887,
  [1888] = 1888,
  [1889] = 1889,
  [1890] = 1890,
  [1891] = 514,
  [1892] = 1892,
  [1893] = 1893,
  [1894] = 1894,
  [1895] = 1895,
  [1896] = 1896,
  [1897] = 1897,
  [1898] = 1898,
  [1899] = 94,
  [1900] = 1900,
  [1901] = 1901,
  [1902] = 1902,
  [1903] = 515,
  [1904] = 1904,
  [1905] = 1905,
  [1906] = 90,
  [1907] = 93,
  [1908] = 92,
  [1909] = 94,
  [1910] = 92,
  [1911] = 93,
  [1912] = 91,
  [1913] = 90,
  [1914] = 94,
  [1915] = 1915,
  [1916] = 1916,
  [1917] = 1917,
  [1918] = 94,
  [1919] = 94,
  [1920] = 1920,
  [1921] = 1921,
  [1922] = 1922,
  [1923] = 1923,
  [1924] = 1740,
  [1925] = 1717,
  [1926] = 1715,
  [1927] = 1737,
  [1928] = 1773,
  [1929] = 1777,
  [1930] = 1766,
  [1931] = 1790,
  [1932] = 1932,
  [1933] = 1796,
  [1934] = 1813,
  [1935] = 1782,
  [1936] = 288,
  [1937] = 1800,
  [1938] = 1900,
  [1939] = 1892,
  [1940] = 1876,
  [1941] = 494,
  [1942] = 1901,
  [1943] = 271,
  [1944] = 1820,
  [1945] = 1793,
  [1946] = 1810,
  [1947] = 1815,
  [1948] = 1792,
  [1949] = 1874,
  [1950] = 1804,
  [1951] = 1814,
  [1952] = 395,
  [1953] = 475,
  [1954] = 529,
  [1955] = 455,
  [1956] = 475,
  [1957] = 455,
  [1958] = 477,
  [1959] = 529,
  [1960] = 395,
  [1961] = 477,
  [1962] = 1962,
  [1963] = 1963,
  [1964] = 1963,
  [1965] = 246,
  [1966] = 254,
  [1967] = 249,
  [1968] = 253,
  [1969] = 256,
  [1970] = 248,
  [1971] = 250,
  [1972] = 254,
  [1973] = 251,
  [1974] = 245,
  [1975] = 253,
  [1976] = 1976,
  [1977] = 247,
  [1978] = 242,
  [1979] = 242,
  [1980] = 251,
  [1981] = 246,
  [1982] = 249,
  [1983] = 250,
  [1984] = 245,
  [1985] = 248,
  [1986] = 247,
  [1987] = 256,
  [1988] = 395,
  [1989] = 251,
  [1990] = 455,
  [1991] = 529,
  [1992] = 245,
  [1993] = 252,
  [1994] = 288,
  [1995] = 256,
  [1996] = 258,
  [1997] = 253,
  [1998] = 246,
  [1999] = 257,
  [2000] = 254,
  [2001] = 258,
  [2002] = 475,
  [2003] = 288,
  [2004] = 271,
  [2005] = 247,
  [2006] = 271,
  [2007] = 257,
  [2008] = 2008,
  [2009] = 477,
  [2010] = 252,
  [2011] = 1132,
  [2012] = 261,
  [2013] = 2013,
  [2014] = 261,
  [2015] = 259,
  [2016] = 259,
  [2017] = 291,
  [2018] = 2018,
  [2019] = 291,
  [2020] = 252,
  [2021] = 252,
  [2022] = 2022,
  [2023] = 252,
  [2024] = 457,
  [2025] = 447,
  [2026] = 414,
  [2027] = 474,
  [2028] = 483,
  [2029] = 522,
  [2030] = 412,
  [2031] = 421,
  [2032] = 511,
  [2033] = 510,
  [2034] = 520,
  [2035] = 357,
  [2036] = 502,
  [2037] = 501,
  [2038] = 336,
  [2039] = 426,
  [2040] = 473,
  [2041] = 493,
  [2042] = 494,
  [2043] = 446,
  [2044] = 499,
  [2045] = 450,
  [2046] = 471,
  [2047] = 490,
  [2048] = 523,
  [2049] = 436,
  [2050] = 357,
  [2051] = 442,
  [2052] = 429,
  [2053] = 313,
  [2054] = 474,
  [2055] = 463,
  [2056] = 454,
  [2057] = 453,
  [2058] = 481,
  [2059] = 520,
  [2060] = 512,
  [2061] = 513,
  [2062] = 485,
  [2063] = 514,
  [2064] = 421,
  [2065] = 408,
  [2066] = 407,
  [2067] = 405,
  [2068] = 404,
  [2069] = 446,
  [2070] = 524,
  [2071] = 515,
  [2072] = 390,
  [2073] = 389,
  [2074] = 517,
  [2075] = 519,
  [2076] = 409,
  [2077] = 526,
  [2078] = 528,
  [2079] = 497,
  [2080] = 341,
  [2081] = 531,
  [2082] = 471,
  [2083] = 348,
  [2084] = 470,
  [2085] = 490,
  [2086] = 359,
  [2087] = 333,
  [2088] = 468,
  [2089] = 443,
  [2090] = 469,
  [2091] = 358,
  [2092] = 467,
  [2093] = 461,
  [2094] = 401,
  [2095] = 466,
  [2096] = 463,
  [2097] = 2097,
  [2098] = 409,
  [2099] = 454,
  [2100] = 342,
  [2101] = 2101,
  [2102] = 431,
  [2103] = 434,
  [2104] = 435,
  [2105] = 453,
  [2106] = 456,
  [2107] = 505,
  [2108] = 460,
  [2109] = 494,
  [2110] = 429,
  [2111] = 442,
  [2112] = 334,
  [2113] = 427,
  [2114] = 479,
  [2115] = 480,
  [2116] = 408,
  [2117] = 482,
  [2118] = 407,
  [2119] = 405,
  [2120] = 404,
  [2121] = 450,
  [2122] = 508,
  [2123] = 493,
  [2124] = 428,
  [2125] = 425,
  [2126] = 501,
  [2127] = 502,
  [2128] = 510,
  [2129] = 441,
  [2130] = 511,
  [2131] = 484,
  [2132] = 412,
  [2133] = 531,
  [2134] = 390,
  [2135] = 389,
  [2136] = 528,
  [2137] = 519,
  [2138] = 517,
  [2139] = 515,
  [2140] = 452,
  [2141] = 503,
  [2142] = 370,
  [2143] = 438,
  [2144] = 357,
  [2145] = 424,
  [2146] = 351,
  [2147] = 514,
  [2148] = 341,
  [2149] = 348,
  [2150] = 367,
  [2151] = 513,
  [2152] = 512,
  [2153] = 403,
  [2154] = 401,
  [2155] = 333,
  [2156] = 359,
  [2157] = 443,
  [2158] = 424,
  [2159] = 505,
  [2160] = 485,
  [2161] = 481,
  [2162] = 427,
  [2163] = 403,
  [2164] = 508,
  [2165] = 431,
  [2166] = 484,
  [2167] = 473,
  [2168] = 523,
  [2169] = 403,
  [2170] = 360,
  [2171] = 403,
  [2172] = 470,
  [2173] = 403,
  [2174] = 360,
  [2175] = 469,
  [2176] = 367,
  [2177] = 313,
  [2178] = 435,
  [2179] = 456,
  [2180] = 334,
  [2181] = 351,
  [2182] = 457,
  [2183] = 460,
  [2184] = 479,
  [2185] = 480,
  [2186] = 370,
  [2187] = 441,
  [2188] = 409,
  [2189] = 313,
  [2190] = 358,
  [2191] = 357,
  [2192] = 461,
  [2193] = 452,
  [2194] = 526,
  [2195] = 524,
  [2196] = 383,
  [2197] = 522,
  [2198] = 503,
  [2199] = 2199,
  [2200] = 483,
  [2201] = 497,
  [2202] = 380,
  [2203] = 379,
  [2204] = 482,
  [2205] = 434,
  [2206] = 499,
  [2207] = 386,
  [2208] = 387,
  [2209] = 413,
  [2210] = 386,
  [2211] = 342,
  [2212] = 447,
  [2213] = 428,
  [2214] = 466,
  [2215] = 467,
  [2216] = 468,
  [2217] = 387,
  [2218] = 425,
  [2219] = 438,
  [2220] = 414,
  [2221] = 379,
  [2222] = 380,
  [2223] = 383,
  [2224] = 413,
  [2225] = 336,
  [2226] = 426,
  [2227] = 436,
  [2228] = 395,
  [2229] = 455,
  [2230] = 529,
  [2231] = 475,
  [2232] = 477,
  [2233] = 249,
  [2234] = 250,
  [2235] = 2235,
  [2236] = 248,
  [2237] = 2237,
  [2238] = 258,
  [2239] = 257,
  [2240] = 2240,
  [2241] = 261,
  [2242] = 288,
  [2243] = 2243,
  [2244] = 291,
  [2245] = 2245,
  [2246] = 2246,
  [2247] = 271,
  [2248] = 2248,
  [2249] = 2249,
  [2250] = 271,
  [2251] = 2251,
  [2252] = 271,
  [2253] = 288,
  [2254] = 2254,
  [2255] = 288,
  [2256] = 403,
  [2257] = 259,
  [2258] = 405,
  [2259] = 528,
  [2260] = 333,
  [2261] = 359,
  [2262] = 499,
  [2263] = 485,
  [2264] = 2264,
  [2265] = 523,
  [2266] = 428,
  [2267] = 425,
  [2268] = 414,
  [2269] = 413,
  [2270] = 473,
  [2271] = 441,
  [2272] = 470,
  [2273] = 484,
  [2274] = 526,
  [2275] = 524,
  [2276] = 421,
  [2277] = 522,
  [2278] = 503,
  [2279] = 497,
  [2280] = 480,
  [2281] = 469,
  [2282] = 452,
  [2283] = 447,
  [2284] = 358,
  [2285] = 438,
  [2286] = 479,
  [2287] = 387,
  [2288] = 386,
  [2289] = 461,
  [2290] = 477,
  [2291] = 460,
  [2292] = 367,
  [2293] = 379,
  [2294] = 380,
  [2295] = 383,
  [2296] = 336,
  [2297] = 426,
  [2298] = 436,
  [2299] = 443,
  [2300] = 342,
  [2301] = 505,
  [2302] = 334,
  [2303] = 508,
  [2304] = 475,
  [2305] = 457,
  [2306] = 395,
  [2307] = 456,
  [2308] = 455,
  [2309] = 529,
  [2310] = 435,
  [2311] = 434,
  [2312] = 431,
  [2313] = 427,
  [2314] = 245,
  [2315] = 424,
  [2316] = 401,
  [2317] = 512,
  [2318] = 513,
  [2319] = 254,
  [2320] = 2320,
  [2321] = 514,
  [2322] = 515,
  [2323] = 517,
  [2324] = 246,
  [2325] = 253,
  [2326] = 519,
  [2327] = 482,
  [2328] = 494,
  [2329] = 348,
  [2330] = 531,
  [2331] = 2331,
  [2332] = 341,
  [2333] = 360,
  [2334] = 256,
  [2335] = 351,
  [2336] = 370,
  [2337] = 412,
  [2338] = 389,
  [2339] = 247,
  [2340] = 390,
  [2341] = 404,
  [2342] = 407,
  [2343] = 2343,
  [2344] = 408,
  [2345] = 2345,
  [2346] = 511,
  [2347] = 510,
  [2348] = 502,
  [2349] = 251,
  [2350] = 501,
  [2351] = 453,
  [2352] = 454,
  [2353] = 463,
  [2354] = 466,
  [2355] = 467,
  [2356] = 468,
  [2357] = 490,
  [2358] = 446,
  [2359] = 471,
  [2360] = 357,
  [2361] = 493,
  [2362] = 450,
  [2363] = 520,
  [2364] = 403,
  [2365] = 442,
  [2366] = 429,
  [2367] = 483,
  [2368] = 481,
  [2369] = 474,
  [2370] = 253,
  [2371] = 1422,
  [2372] = 288,
  [2373] = 271,
  [2374] = 2374,
  [2375] = 249,
  [2376] = 1420,
  [2377] = 313,
  [2378] = 248,
  [2379] = 409,
  [2380] = 256,
  [2381] = 246,
  [2382] = 251,
  [2383] = 250,
  [2384] = 254,
  [2385] = 247,
  [2386] = 2386,
  [2387] = 245,
  [2388] = 2388,
  [2389] = 257,
  [2390] = 258,
  [2391] = 409,
  [2392] = 259,
  [2393] = 261,
  [2394] = 313,
  [2395] = 291,
  [2396] = 2396,
  [2397] = 387,
  [2398] = 359,
  [2399] = 434,
  [2400] = 431,
  [2401] = 427,
  [2402] = 348,
  [2403] = 424,
  [2404] = 341,
  [2405] = 531,
  [2406] = 360,
  [2407] = 401,
  [2408] = 2396,
  [2409] = 351,
  [2410] = 333,
  [2411] = 2396,
  [2412] = 460,
  [2413] = 480,
  [2414] = 457,
  [2415] = 2396,
  [2416] = 429,
  [2417] = 442,
  [2418] = 461,
  [2419] = 370,
  [2420] = 456,
  [2421] = 479,
  [2422] = 469,
  [2423] = 412,
  [2424] = 389,
  [2425] = 519,
  [2426] = 390,
  [2427] = 499,
  [2428] = 404,
  [2429] = 405,
  [2430] = 470,
  [2431] = 407,
  [2432] = 408,
  [2433] = 428,
  [2434] = 2396,
  [2435] = 450,
  [2436] = 425,
  [2437] = 414,
  [2438] = 413,
  [2439] = 2396,
  [2440] = 482,
  [2441] = 528,
  [2442] = 441,
  [2443] = 2396,
  [2444] = 508,
  [2445] = 493,
  [2446] = 484,
  [2447] = 403,
  [2448] = 421,
  [2449] = 526,
  [2450] = 524,
  [2451] = 446,
  [2452] = 2396,
  [2453] = 342,
  [2454] = 2396,
  [2455] = 515,
  [2456] = 336,
  [2457] = 522,
  [2458] = 512,
  [2459] = 473,
  [2460] = 2396,
  [2461] = 503,
  [2462] = 471,
  [2463] = 497,
  [2464] = 494,
  [2465] = 523,
  [2466] = 474,
  [2467] = 453,
  [2468] = 454,
  [2469] = 334,
  [2470] = 481,
  [2471] = 463,
  [2472] = 466,
  [2473] = 483,
  [2474] = 467,
  [2475] = 468,
  [2476] = 452,
  [2477] = 520,
  [2478] = 505,
  [2479] = 2396,
  [2480] = 443,
  [2481] = 447,
  [2482] = 436,
  [2483] = 513,
  [2484] = 501,
  [2485] = 502,
  [2486] = 2396,
  [2487] = 438,
  [2488] = 358,
  [2489] = 514,
  [2490] = 357,
  [2491] = 426,
  [2492] = 367,
  [2493] = 510,
  [2494] = 386,
  [2495] = 511,
  [2496] = 383,
  [2497] = 380,
  [2498] = 485,
  [2499] = 435,
  [2500] = 490,
  [2501] = 379,
  [2502] = 2396,
  [2503] = 517,
  [2504] = 246,
  [2505] = 251,
  [2506] = 254,
  [2507] = 245,
  [2508] = 247,
  [2509] = 256,
  [2510] = 253,
  [2511] = 245,
  [2512] = 246,
  [2513] = 249,
  [2514] = 251,
  [2515] = 1141,
  [2516] = 409,
  [2517] = 254,
  [2518] = 249,
  [2519] = 403,
  [2520] = 248,
  [2521] = 313,
  [2522] = 247,
  [2523] = 256,
  [2524] = 403,
  [2525] = 1112,
  [2526] = 250,
  [2527] = 1140,
  [2528] = 248,
  [2529] = 90,
  [2530] = 253,
  [2531] = 251,
  [2532] = 93,
  [2533] = 92,
  [2534] = 246,
  [2535] = 250,
  [2536] = 253,
  [2537] = 256,
  [2538] = 247,
  [2539] = 254,
  [2540] = 245,
  [2541] = 245,
  [2542] = 251,
  [2543] = 245,
  [2544] = 247,
  [2545] = 271,
  [2546] = 256,
  [2547] = 253,
  [2548] = 357,
  [2549] = 257,
  [2550] = 258,
  [2551] = 2551,
  [2552] = 246,
  [2553] = 257,
  [2554] = 254,
  [2555] = 256,
  [2556] = 258,
  [2557] = 254,
  [2558] = 1119,
  [2559] = 1132,
  [2560] = 253,
  [2561] = 409,
  [2562] = 251,
  [2563] = 246,
  [2564] = 313,
  [2565] = 1119,
  [2566] = 246,
  [2567] = 253,
  [2568] = 256,
  [2569] = 288,
  [2570] = 247,
  [2571] = 288,
  [2572] = 271,
  [2573] = 247,
  [2574] = 251,
  [2575] = 254,
  [2576] = 245,
  [2577] = 2577,
  [2578] = 2578,
  [2579] = 2579,
  [2580] = 252,
  [2581] = 2577,
  [2582] = 2582,
  [2583] = 2577,
  [2584] = 2582,
  [2585] = 259,
  [2586] = 2577,
  [2587] = 252,
  [2588] = 2582,
  [2589] = 291,
  [2590] = 2577,
  [2591] = 261,
  [2592] = 2582,
  [2593] = 2582,
  [2594] = 2577,
  [2595] = 2595,
  [2596] = 2596,
  [2597] = 2577,
  [2598] = 252,
  [2599] = 409,
  [2600] = 2577,
  [2601] = 259,
  [2602] = 2577,
  [2603] = 2582,
  [2604] = 2582,
  [2605] = 2582,
  [2606] = 313,
  [2607] = 2582,
  [2608] = 2577,
  [2609] = 291,
  [2610] = 2577,
  [2611] = 261,
  [2612] = 2577,
  [2613] = 2582,
  [2614] = 2577,
  [2615] = 2615,
  [2616] = 2582,
  [2617] = 403,
  [2618] = 403,
  [2619] = 2582,
  [2620] = 1132,
  [2621] = 389,
  [2622] = 408,
  [2623] = 447,
  [2624] = 438,
  [2625] = 387,
  [2626] = 386,
  [2627] = 367,
  [2628] = 379,
  [2629] = 380,
  [2630] = 383,
  [2631] = 336,
  [2632] = 426,
  [2633] = 436,
  [2634] = 443,
  [2635] = 505,
  [2636] = 334,
  [2637] = 508,
  [2638] = 313,
  [2639] = 2639,
  [2640] = 2640,
  [2641] = 471,
  [2642] = 481,
  [2643] = 2643,
  [2644] = 2644,
  [2645] = 2639,
  [2646] = 2640,
  [2647] = 2640,
  [2648] = 468,
  [2649] = 467,
  [2650] = 466,
  [2651] = 370,
  [2652] = 2640,
  [2653] = 351,
  [2654] = 360,
  [2655] = 2655,
  [2656] = 2643,
  [2657] = 409,
  [2658] = 424,
  [2659] = 427,
  [2660] = 2660,
  [2661] = 499,
  [2662] = 414,
  [2663] = 413,
  [2664] = 526,
  [2665] = 524,
  [2666] = 522,
  [2667] = 503,
  [2668] = 497,
  [2669] = 497,
  [2670] = 2639,
  [2671] = 503,
  [2672] = 387,
  [2673] = 386,
  [2674] = 522,
  [2675] = 524,
  [2676] = 526,
  [2677] = 379,
  [2678] = 380,
  [2679] = 383,
  [2680] = 336,
  [2681] = 426,
  [2682] = 436,
  [2683] = 484,
  [2684] = 334,
  [2685] = 508,
  [2686] = 441,
  [2687] = 2687,
  [2688] = 2640,
  [2689] = 2644,
  [2690] = 413,
  [2691] = 414,
  [2692] = 425,
  [2693] = 523,
  [2694] = 313,
  [2695] = 428,
  [2696] = 499,
  [2697] = 482,
  [2698] = 2643,
  [2699] = 480,
  [2700] = 2640,
  [2701] = 2644,
  [2702] = 479,
  [2703] = 2644,
  [2704] = 2640,
  [2705] = 460,
  [2706] = 457,
  [2707] = 456,
  [2708] = 409,
  [2709] = 435,
  [2710] = 2640,
  [2711] = 288,
  [2712] = 434,
  [2713] = 431,
  [2714] = 427,
  [2715] = 424,
  [2716] = 409,
  [2717] = 401,
  [2718] = 2639,
  [2719] = 2639,
  [2720] = 2640,
  [2721] = 348,
  [2722] = 341,
  [2723] = 523,
  [2724] = 360,
  [2725] = 271,
  [2726] = 2640,
  [2727] = 351,
  [2728] = 2643,
  [2729] = 370,
  [2730] = 389,
  [2731] = 390,
  [2732] = 404,
  [2733] = 405,
  [2734] = 494,
  [2735] = 407,
  [2736] = 408,
  [2737] = 453,
  [2738] = 454,
  [2739] = 463,
  [2740] = 466,
  [2741] = 467,
  [2742] = 468,
  [2743] = 2644,
  [2744] = 2640,
  [2745] = 2745,
  [2746] = 258,
  [2747] = 429,
  [2748] = 442,
  [2749] = 313,
  [2750] = 2639,
  [2751] = 490,
  [2752] = 450,
  [2753] = 2643,
  [2754] = 257,
  [2755] = 2755,
  [2756] = 252,
  [2757] = 493,
  [2758] = 2640,
  [2759] = 2643,
  [2760] = 501,
  [2761] = 502,
  [2762] = 510,
  [2763] = 511,
  [2764] = 412,
  [2765] = 2643,
  [2766] = 2640,
  [2767] = 531,
  [2768] = 2639,
  [2769] = 528,
  [2770] = 519,
  [2771] = 517,
  [2772] = 515,
  [2773] = 514,
  [2774] = 2644,
  [2775] = 513,
  [2776] = 512,
  [2777] = 2644,
  [2778] = 520,
  [2779] = 1133,
  [2780] = 2639,
  [2781] = 333,
  [2782] = 359,
  [2783] = 485,
  [2784] = 483,
  [2785] = 481,
  [2786] = 473,
  [2787] = 470,
  [2788] = 494,
  [2789] = 469,
  [2790] = 358,
  [2791] = 474,
  [2792] = 461,
  [2793] = 471,
  [2794] = 2644,
  [2795] = 342,
  [2796] = 2639,
  [2797] = 367,
  [2798] = 446,
  [2799] = 452,
  [2800] = 2800,
  [2801] = 245,
  [2802] = 421,
  [2803] = 505,
  [2804] = 342,
  [2805] = 443,
  [2806] = 247,
  [2807] = 256,
  [2808] = 461,
  [2809] = 438,
  [2810] = 358,
  [2811] = 447,
  [2812] = 452,
  [2813] = 469,
  [2814] = 2639,
  [2815] = 484,
  [2816] = 470,
  [2817] = 441,
  [2818] = 473,
  [2819] = 425,
  [2820] = 428,
  [2821] = 485,
  [2822] = 359,
  [2823] = 333,
  [2824] = 482,
  [2825] = 480,
  [2826] = 479,
  [2827] = 460,
  [2828] = 457,
  [2829] = 357,
  [2830] = 456,
  [2831] = 403,
  [2832] = 2832,
  [2833] = 409,
  [2834] = 435,
  [2835] = 2835,
  [2836] = 434,
  [2837] = 431,
  [2838] = 401,
  [2839] = 2643,
  [2840] = 512,
  [2841] = 313,
  [2842] = 513,
  [2843] = 2843,
  [2844] = 514,
  [2845] = 515,
  [2846] = 517,
  [2847] = 519,
  [2848] = 528,
  [2849] = 348,
  [2850] = 531,
  [2851] = 403,
  [2852] = 403,
  [2853] = 403,
  [2854] = 421,
  [2855] = 341,
  [2856] = 246,
  [2857] = 412,
  [2858] = 390,
  [2859] = 404,
  [2860] = 405,
  [2861] = 253,
  [2862] = 407,
  [2863] = 256,
  [2864] = 511,
  [2865] = 2615,
  [2866] = 247,
  [2867] = 2643,
  [2868] = 2868,
  [2869] = 2643,
  [2870] = 245,
  [2871] = 2644,
  [2872] = 2643,
  [2873] = 510,
  [2874] = 2639,
  [2875] = 2644,
  [2876] = 502,
  [2877] = 446,
  [2878] = 501,
  [2879] = 2639,
  [2880] = 474,
  [2881] = 453,
  [2882] = 454,
  [2883] = 463,
  [2884] = 483,
  [2885] = 2644,
  [2886] = 2639,
  [2887] = 253,
  [2888] = 429,
  [2889] = 442,
  [2890] = 246,
  [2891] = 520,
  [2892] = 251,
  [2893] = 2644,
  [2894] = 2639,
  [2895] = 490,
  [2896] = 251,
  [2897] = 493,
  [2898] = 254,
  [2899] = 2639,
  [2900] = 254,
  [2901] = 2643,
  [2902] = 450,
  [2903] = 2903,
  [2904] = 2904,
  [2905] = 2905,
  [2906] = 2904,
  [2907] = 2904,
  [2908] = 1688,
  [2909] = 2909,
  [2910] = 2910,
  [2911] = 2904,
  [2912] = 259,
  [2913] = 2904,
  [2914] = 2904,
  [2915] = 2904,
  [2916] = 2916,
  [2917] = 2910,
  [2918] = 261,
  [2919] = 357,
  [2920] = 2904,
  [2921] = 2910,
  [2922] = 2904,
  [2923] = 2904,
  [2924] = 2904,
  [2925] = 2910,
  [2926] = 2013,
  [2927] = 2904,
  [2928] = 2904,
  [2929] = 2929,
  [2930] = 2930,
  [2931] = 2931,
  [2932] = 468,
  [2933] = 2930,
  [2934] = 2930,
  [2935] = 481,
  [2936] = 2235,
  [2937] = 467,
  [2938] = 92,
  [2939] = 466,
  [2940] = 93,
  [2941] = 93,
  [2942] = 360,
  [2943] = 2930,
  [2944] = 2930,
  [2945] = 2930,
  [2946] = 2930,
  [2947] = 370,
  [2948] = 2948,
  [2949] = 494,
  [2950] = 2930,
  [2951] = 2930,
  [2952] = 424,
  [2953] = 90,
  [2954] = 471,
  [2955] = 427,
  [2956] = 508,
  [2957] = 413,
  [2958] = 2930,
  [2959] = 90,
  [2960] = 2930,
  [2961] = 526,
  [2962] = 351,
  [2963] = 92,
  [2964] = 524,
  [2965] = 414,
  [2966] = 334,
  [2967] = 2930,
  [2968] = 436,
  [2969] = 426,
  [2970] = 336,
  [2971] = 383,
  [2972] = 499,
  [2973] = 380,
  [2974] = 2930,
  [2975] = 379,
  [2976] = 386,
  [2977] = 387,
  [2978] = 497,
  [2979] = 503,
  [2980] = 522,
  [2981] = 1693,
  [2982] = 1693,
  [2983] = 2983,
  [2984] = 1692,
  [2985] = 1692,
  [2986] = 1686,
  [2987] = 1686,
  [2988] = 2988,
  [2989] = 1692,
  [2990] = 1693,
  [2991] = 2991,
  [2992] = 2983,
  [2993] = 1693,
  [2994] = 1692,
  [2995] = 2983,
  [2996] = 2991,
  [2997] = 1686,
  [2998] = 2991,
  [2999] = 2999,
  [3000] = 2983,
  [3001] = 1686,
  [3002] = 1686,
  [3003] = 1692,
  [3004] = 1686,
  [3005] = 1692,
  [3006] = 1686,
  [3007] = 1692,
  [3008] = 1693,
  [3009] = 2983,
  [3010] = 1693,
  [3011] = 2991,
  [3012] = 1693,
  [3013] = 1692,
  [3014] = 1686,
  [3015] = 1686,
  [3016] = 1692,
  [3017] = 1686,
  [3018] = 1692,
  [3019] = 3019,
  [3020] = 1692,
  [3021] = 1693,
  [3022] = 1686,
  [3023] = 1686,
  [3024] = 1692,
  [3025] = 1693,
  [3026] = 2983,
  [3027] = 1693,
  [3028] = 2991,
  [3029] = 2991,
  [3030] = 1692,
  [3031] = 1693,
  [3032] = 2983,
  [3033] = 3033,
  [3034] = 2991,
  [3035] = 1693,
  [3036] = 1686,
  [3037] = 1692,
  [3038] = 1686,
  [3039] = 1693,
  [3040] = 1686,
  [3041] = 1692,
  [3042] = 1693,
  [3043] = 1693,
  [3044] = 2983,
  [3045] = 2983,
  [3046] = 1686,
  [3047] = 2983,
  [3048] = 2991,
  [3049] = 2991,
  [3050] = 2983,
  [3051] = 2983,
  [3052] = 2991,
  [3053] = 1693,
  [3054] = 2991,
  [3055] = 1686,
  [3056] = 1692,
  [3057] = 2991,
  [3058] = 1692,
  [3059] = 1693,
  [3060] = 3060,
  [3061] = 3060,
  [3062] = 3062,
  [3063] = 3062,
  [3064] = 3064,
  [3065] = 3062,
  [3066] = 3066,
  [3067] = 3066,
  [3068] = 3068,
  [3069] = 3066,
  [3070] = 3062,
  [3071] = 1916,
  [3072] = 3066,
  [3073] = 3073,
  [3074] = 3074,
  [3075] = 3066,
  [3076] = 3066,
  [3077] = 3066,
  [3078] = 3066,
  [3079] = 3066,
  [3080] = 3062,
  [3081] = 3062,
  [3082] = 3066,
  [3083] = 3062,
  [3084] = 3084,
  [3085] = 3062,
  [3086] = 3062,
  [3087] = 3066,
  [3088] = 3066,
  [3089] = 3066,
  [3090] = 3090,
  [3091] = 3062,
  [3092] = 3092,
  [3093] = 3066,
  [3094] = 3062,
  [3095] = 3062,
  [3096] = 3096,
  [3097] = 3066,
  [3098] = 3062,
  [3099] = 3099,
  [3100] = 3062,
  [3101] = 3062,
  [3102] = 3102,
  [3103] = 3103,
  [3104] = 3104,
  [3105] = 3105,
  [3106] = 3106,
  [3107] = 3107,
  [3108] = 3108,
  [3109] = 3106,
  [3110] = 3110,
  [3111] = 3107,
  [3112] = 3112,
  [3113] = 3112,
  [3114] = 3114,
  [3115] = 3107,
  [3116] = 3116,
  [3117] = 3112,
  [3118] = 3105,
  [3119] = 3107,
  [3120] = 3102,
  [3121] = 3106,
  [3122] = 3105,
  [3123] = 3105,
  [3124] = 3110,
  [3125] = 3104,
  [3126] = 3108,
  [3127] = 3127,
  [3128] = 3102,
  [3129] = 3129,
  [3130] = 3116,
  [3131] = 3102,
  [3132] = 3129,
  [3133] = 3108,
  [3134] = 3103,
  [3135] = 3135,
  [3136] = 3127,
  [3137] = 3137,
  [3138] = 3127,
  [3139] = 3110,
  [3140] = 3129,
  [3141] = 3112,
  [3142] = 3129,
  [3143] = 3104,
  [3144] = 3116,
  [3145] = 3127,
  [3146] = 3137,
  [3147] = 3137,
  [3148] = 3116,
  [3149] = 3149,
  [3150] = 3137,
  [3151] = 3108,
  [3152] = 3105,
  [3153] = 3107,
  [3154] = 3135,
  [3155] = 3110,
  [3156] = 3104,
  [3157] = 3116,
  [3158] = 3103,
  [3159] = 3110,
  [3160] = 3106,
  [3161] = 3102,
  [3162] = 3102,
  [3163] = 3135,
  [3164] = 3103,
  [3165] = 3103,
  [3166] = 3104,
  [3167] = 3103,
  [3168] = 3103,
  [3169] = 3104,
  [3170] = 3107,
  [3171] = 3116,
  [3172] = 3103,
  [3173] = 3129,
  [3174] = 3174,
  [3175] = 3135,
  [3176] = 3104,
  [3177] = 3137,
  [3178] = 3110,
  [3179] = 3102,
  [3180] = 3180,
  [3181] = 3106,
  [3182] = 3135,
  [3183] = 3127,
  [3184] = 3102,
  [3185] = 3107,
  [3186] = 3135,
  [3187] = 3116,
  [3188] = 3103,
  [3189] = 3137,
  [3190] = 3116,
  [3191] = 3106,
  [3192] = 3105,
  [3193] = 3102,
  [3194] = 3108,
  [3195] = 3135,
  [3196] = 3112,
  [3197] = 3106,
  [3198] = 3112,
  [3199] = 3104,
  [3200] = 3112,
  [3201] = 3129,
  [3202] = 3202,
  [3203] = 3106,
  [3204] = 3108,
  [3205] = 3105,
  [3206] = 3127,
  [3207] = 3129,
  [3208] = 3129,
  [3209] = 3110,
  [3210] = 3202,
  [3211] = 3137,
  [3212] = 3127,
  [3213] = 3129,
  [3214] = 3116,
  [3215] = 3215,
  [3216] = 3102,
  [3217] = 3107,
  [3218] = 3102,
  [3219] = 3129,
  [3220] = 3116,
  [3221] = 3127,
  [3222] = 3105,
  [3223] = 3129,
  [3224] = 3129,
  [3225] = 3108,
  [3226] = 3135,
  [3227] = 3106,
  [3228] = 3228,
  [3229] = 3129,
  [3230] = 3137,
  [3231] = 3112,
  [3232] = 3127,
  [3233] = 3129,
  [3234] = 3129,
  [3235] = 3137,
  [3236] = 3127,
  [3237] = 3129,
  [3238] = 3116,
  [3239] = 3103,
  [3240] = 3116,
  [3241] = 3137,
  [3242] = 3105,
  [3243] = 3104,
  [3244] = 3110,
  [3245] = 3129,
  [3246] = 3116,
  [3247] = 3107,
  [3248] = 3105,
  [3249] = 3108,
  [3250] = 3116,
  [3251] = 3102,
  [3252] = 3135,
  [3253] = 3135,
  [3254] = 3129,
  [3255] = 3137,
  [3256] = 3110,
  [3257] = 3107,
  [3258] = 3105,
  [3259] = 3108,
  [3260] = 3137,
  [3261] = 3127,
  [3262] = 3116,
  [3263] = 3129,
  [3264] = 3108,
  [3265] = 3105,
  [3266] = 3135,
  [3267] = 3103,
  [3268] = 3129,
  [3269] = 3104,
  [3270] = 3103,
  [3271] = 3104,
  [3272] = 3108,
  [3273] = 3129,
  [3274] = 3105,
  [3275] = 3202,
  [3276] = 3107,
  [3277] = 3110,
  [3278] = 3107,
  [3279] = 3104,
  [3280] = 3110,
  [3281] = 3110,
  [3282] = 3127,
  [3283] = 3102,
  [3284] = 3104,
  [3285] = 3104,
  [3286] = 3286,
  [3287] = 3127,
  [3288] = 3106,
  [3289] = 3137,
  [3290] = 3110,
  [3291] = 3135,
  [3292] = 3104,
  [3293] = 3103,
  [3294] = 3116,
  [3295] = 3137,
  [3296] = 3135,
  [3297] = 3110,
  [3298] = 3107,
  [3299] = 3108,
  [3300] = 3105,
  [3301] = 3108,
  [3302] = 3137,
  [3303] = 3127,
  [3304] = 3112,
  [3305] = 3135,
  [3306] = 3108,
  [3307] = 3106,
  [3308] = 3104,
  [3309] = 3103,
  [3310] = 3103,
  [3311] = 3107,
  [3312] = 3135,
  [3313] = 3110,
  [3314] = 3127,
  [3315] = 3110,
  [3316] = 3129,
  [3317] = 3106,
  [3318] = 3107,
  [3319] = 3116,
  [3320] = 3102,
  [3321] = 3112,
  [3322] = 3112,
  [3323] = 3127,
  [3324] = 3137,
  [3325] = 3137,
  [3326] = 3102,
  [3327] = 3127,
  [3328] = 3135,
  [3329] = 3135,
  [3330] = 3108,
  [3331] = 3108,
  [3332] = 3108,
  [3333] = 3105,
  [3334] = 3105,
  [3335] = 3129,
  [3336] = 3107,
  [3337] = 3110,
  [3338] = 3104,
  [3339] = 3103,
  [3340] = 3107,
  [3341] = 3103,
  [3342] = 3202,
  [3343] = 3343,
  [3344] = 3112,
  [3345] = 3105,
  [3346] = 3346,
  [3347] = 3347,
  [3348] = 3348,
  [3349] = 3348,
  [3350] = 3348,
  [3351] = 3348,
  [3352] = 3352,
  [3353] = 3348,
  [3354] = 3348,
  [3355] = 3355,
  [3356] = 3348,
  [3357] = 3348,
  [3358] = 3348,
  [3359] = 3348,
  [3360] = 3348,
  [3361] = 3348,
  [3362] = 3362,
  [3363] = 477,
  [3364] = 475,
  [3365] = 529,
  [3366] = 395,
  [3367] = 455,
  [3368] = 475,
  [3369] = 455,
  [3370] = 395,
  [3371] = 3371,
  [3372] = 3372,
  [3373] = 3373,
  [3374] = 529,
  [3375] = 477,
  [3376] = 3376,
  [3377] = 1766,
  [3378] = 3378,
  [3379] = 1408,
  [3380] = 1408,
  [3381] = 3381,
  [3382] = 2248,
  [3383] = 3383,
  [3384] = 2331,
  [3385] = 1717,
  [3386] = 3383,
  [3387] = 3383,
  [3388] = 3388,
  [3389] = 1737,
  [3390] = 3383,
  [3391] = 3391,
  [3392] = 3392,
  [3393] = 2386,
  [3394] = 2374,
  [3395] = 3395,
  [3396] = 3396,
  [3397] = 3397,
  [3398] = 3398,
  [3399] = 333,
  [3400] = 3398,
  [3401] = 3398,
  [3402] = 3402,
  [3403] = 3398,
  [3404] = 3404,
  [3405] = 3398,
  [3406] = 403,
  [3407] = 3407,
  [3408] = 3408,
  [3409] = 3398,
  [3410] = 3398,
  [3411] = 3408,
  [3412] = 3408,
  [3413] = 3398,
  [3414] = 3408,
  [3415] = 3398,
  [3416] = 3416,
  [3417] = 3398,
  [3418] = 3408,
  [3419] = 3408,
  [3420] = 3408,
  [3421] = 3408,
  [3422] = 3398,
  [3423] = 291,
  [3424] = 359,
  [3425] = 3408,
  [3426] = 3398,
  [3427] = 3408,
  [3428] = 3408,
  [3429] = 3408,
  [3430] = 3430,
  [3431] = 3404,
  [3432] = 3432,
  [3433] = 3433,
  [3434] = 3398,
  [3435] = 3408,
  [3436] = 3404,
  [3437] = 3398,
  [3438] = 3408,
  [3439] = 3398,
  [3440] = 3440,
  [3441] = 3441,
  [3442] = 3442,
  [3443] = 3443,
  [3444] = 3408,
  [3445] = 3404,
  [3446] = 3446,
  [3447] = 342,
  [3448] = 412,
  [3449] = 3449,
  [3450] = 358,
  [3451] = 3451,
  [3452] = 3452,
  [3453] = 3453,
  [3454] = 3454,
  [3455] = 519,
  [3456] = 514,
  [3457] = 3457,
  [3458] = 429,
  [3459] = 442,
  [3460] = 450,
  [3461] = 493,
  [3462] = 473,
  [3463] = 513,
  [3464] = 470,
  [3465] = 501,
  [3466] = 469,
  [3467] = 515,
  [3468] = 461,
  [3469] = 512,
  [3470] = 3470,
  [3471] = 502,
  [3472] = 485,
  [3473] = 510,
  [3474] = 511,
  [3475] = 531,
  [3476] = 517,
  [3477] = 3477,
  [3478] = 528,
  [3479] = 3479,
  [3480] = 3480,
  [3481] = 3481,
  [3482] = 3482,
  [3483] = 3483,
  [3484] = 3482,
  [3485] = 3482,
  [3486] = 3482,
  [3487] = 3487,
  [3488] = 3482,
  [3489] = 3489,
  [3490] = 3482,
  [3491] = 3482,
  [3492] = 3482,
  [3493] = 3482,
  [3494] = 523,
  [3495] = 3495,
  [3496] = 3482,
  [3497] = 3497,
  [3498] = 3482,
  [3499] = 3482,
  [3500] = 3500,
  [3501] = 3501,
  [3502] = 3502,
  [3503] = 3503,
  [3504] = 3504,
  [3505] = 3505,
  [3506] = 3506,
  [3507] = 3507,
  [3508] = 3508,
  [3509] = 3509,
  [3510] = 3510,
  [3511] = 3511,
  [3512] = 3512,
  [3513] = 3513,
  [3514] = 3514,
  [3515] = 3515,
  [3516] = 3516,
  [3517] = 3517,
  [3518] = 3518,
  [3519] = 3519,
  [3520] = 3519,
  [3521] = 3521,
  [3522] = 3519,
  [3523] = 3523,
  [3524] = 3524,
  [3525] = 3521,
  [3526] = 3526,
  [3527] = 3527,
  [3528] = 3528,
  [3529] = 3529,
  [3530] = 3530,
  [3531] = 3531,
  [3532] = 3532,
  [3533] = 3519,
  [3534] = 3523,
  [3535] = 3535,
  [3536] = 3535,
  [3537] = 3523,
  [3538] = 3523,
  [3539] = 3519,
  [3540] = 3540,
  [3541] = 3521,
  [3542] = 3524,
  [3543] = 3535,
  [3544] = 3519,
  [3545] = 3521,
  [3546] = 3527,
  [3547] = 3547,
  [3548] = 3527,
  [3549] = 3528,
  [3550] = 3529,
  [3551] = 3530,
  [3552] = 3528,
  [3553] = 3529,
  [3554] = 3530,
  [3555] = 3527,
  [3556] = 3556,
  [3557] = 3528,
  [3558] = 3529,
  [3559] = 3530,
  [3560] = 3524,
  [3561] = 3561,
  [3562] = 3535,
  [3563] = 3563,
  [3564] = 3535,
  [3565] = 3523,
  [3566] = 3528,
  [3567] = 3521,
  [3568] = 3530,
  [3569] = 3524,
  [3570] = 3530,
  [3571] = 3529,
  [3572] = 3528,
  [3573] = 3527,
  [3574] = 3529,
  [3575] = 3527,
  [3576] = 3528,
  [3577] = 3529,
  [3578] = 3524,
  [3579] = 3579,
  [3580] = 3527,
  [3581] = 3528,
  [3582] = 3529,
  [3583] = 3530,
  [3584] = 3535,
  [3585] = 3530,
  [3586] = 3523,
  [3587] = 3535,
  [3588] = 3519,
  [3589] = 3528,
  [3590] = 3521,
  [3591] = 3519,
  [3592] = 3524,
  [3593] = 3523,
  [3594] = 3527,
  [3595] = 3595,
  [3596] = 3524,
  [3597] = 3523,
  [3598] = 3524,
  [3599] = 3521,
  [3600] = 3519,
  [3601] = 3523,
  [3602] = 3535,
  [3603] = 3527,
  [3604] = 3521,
  [3605] = 3605,
  [3606] = 3530,
  [3607] = 3529,
  [3608] = 3529,
  [3609] = 3530,
  [3610] = 3610,
  [3611] = 3611,
  [3612] = 3528,
  [3613] = 3527,
  [3614] = 3535,
  [3615] = 3615,
  [3616] = 3616,
  [3617] = 3523,
  [3618] = 3519,
  [3619] = 3521,
  [3620] = 3524,
  [3621] = 3535,
  [3622] = 3622,
  [3623] = 3623,
  [3624] = 3527,
  [3625] = 3528,
  [3626] = 3529,
  [3627] = 3530,
  [3628] = 3524,
  [3629] = 3629,
  [3630] = 3630,
  [3631] = 3535,
  [3632] = 3530,
  [3633] = 3521,
  [3634] = 3529,
  [3635] = 3528,
  [3636] = 3527,
  [3637] = 3521,
  [3638] = 3535,
  [3639] = 3519,
  [3640] = 3524,
  [3641] = 3523,
  [3642] = 3523,
  [3643] = 3519,
  [3644] = 3521,
  [3645] = 3524,
  [3646] = 3646,
  [3647] = 3647,
  [3648] = 3648,
  [3649] = 291,
  [3650] = 3650,
  [3651] = 403,
  [3652] = 3652,
  [3653] = 3653,
  [3654] = 3654,
  [3655] = 3655,
  [3656] = 3656,
  [3657] = 3657,
  [3658] = 3658,
  [3659] = 3659,
  [3660] = 3660,
  [3661] = 3661,
  [3662] = 3662,
  [3663] = 3663,
  [3664] = 3664,
  [3665] = 3665,
  [3666] = 3666,
  [3667] = 3667,
  [3668] = 3668,
  [3669] = 523,
  [3670] = 3670,
  [3671] = 3671,
  [3672] = 3672,
  [3673] = 3673,
  [3674] = 3674,
  [3675] = 3675,
  [3676] = 3676,
  [3677] = 3677,
  [3678] = 3678,
  [3679] = 3679,
  [3680] = 3680,
  [3681] = 3681,
  [3682] = 3682,
  [3683] = 3683,
  [3684] = 3657,
  [3685] = 3663,
  [3686] = 3686,
  [3687] = 3673,
  [3688] = 3688,
  [3689] = 3689,
  [3690] = 3670,
  [3691] = 3660,
  [3692] = 3692,
  [3693] = 3693,
  [3694] = 3694,
  [3695] = 3695,
  [3696] = 3696,
  [3697] = 3697,
  [3698] = 3698,
  [3699] = 3699,
  [3700] = 3693,
  [3701] = 3701,
  [3702] = 3702,
  [3703] = 3703,
  [3704] = 3694,
  [3705] = 3693,
  [3706] = 3706,
  [3707] = 3707,
  [3708] = 3708,
  [3709] = 3693,
  [3710] = 3710,
  [3711] = 3693,
  [3712] = 3694,
  [3713] = 3713,
  [3714] = 3698,
  [3715] = 3693,
  [3716] = 3716,
  [3717] = 3699,
  [3718] = 3718,
  [3719] = 3719,
  [3720] = 3701,
  [3721] = 3693,
  [3722] = 3698,
  [3723] = 3723,
  [3724] = 3699,
  [3725] = 3725,
  [3726] = 3701,
  [3727] = 3693,
  [3728] = 3728,
  [3729] = 3729,
  [3730] = 3699,
  [3731] = 3701,
  [3732] = 3732,
  [3733] = 3733,
  [3734] = 3734,
  [3735] = 3693,
  [3736] = 3736,
  [3737] = 3737,
  [3738] = 3738,
  [3739] = 3739,
  [3740] = 3694,
  [3741] = 3736,
  [3742] = 3698,
  [3743] = 3701,
  [3744] = 3699,
  [3745] = 3693,
  [3746] = 3746,
  [3747] = 3701,
  [3748] = 3699,
  [3749] = 3699,
  [3750] = 3693,
  [3751] = 3698,
  [3752] = 3701,
  [3753] = 3694,
  [3754] = 3754,
  [3755] = 3755,
  [3756] = 3701,
  [3757] = 3757,
  [3758] = 3699,
  [3759] = 3759,
  [3760] = 3760,
  [3761] = 3698,
  [3762] = 3762,
  [3763] = 3698,
  [3764] = 3764,
  [3765] = 3694,
  [3766] = 3766,
  [3767] = 3698,
  [3768] = 3768,
  [3769] = 3769,
  [3770] = 3770,
  [3771] = 3771,
  [3772] = 3772,
  [3773] = 3694,
  [3774] = 3774,
  [3775] = 3699,
  [3776] = 3701,
  [3777] = 3694,
  [3778] = 1835,
  [3779] = 3779,
  [3780] = 3780,
  [3781] = 3698,
  [3782] = 3693,
  [3783] = 3693,
  [3784] = 3784,
  [3785] = 3785,
  [3786] = 1840,
  [3787] = 3787,
  [3788] = 3694,
  [3789] = 3754,
  [3790] = 3736,
  [3791] = 3693,
  [3792] = 3754,
  [3793] = 3736,
  [3794] = 3693,
  [3795] = 3754,
  [3796] = 3736,
  [3797] = 3797,
  [3798] = 3699,
  [3799] = 3698,
  [3800] = 3754,
  [3801] = 3801,
  [3802] = 3701,
  [3803] = 3803,
  [3804] = 3694,
  [3805] = 3736,
  [3806] = 3806,
  [3807] = 3754,
  [3808] = 3699,
  [3809] = 3701,
  [3810] = 3736,
  [3811] = 3811,
  [3812] = 3693,
  [3813] = 3754,
  [3814] = 3814,
  [3815] = 3815,
  [3816] = 3736,
  [3817] = 3736,
  [3818] = 3818,
  [3819] = 3754,
  [3820] = 3701,
  [3821] = 3699,
  [3822] = 3698,
  [3823] = 3736,
  [3824] = 3824,
  [3825] = 3825,
  [3826] = 3826,
  [3827] = 3754,
  [3828] = 3828,
  [3829] = 3754,
  [3830] = 3698,
  [3831] = 3754,
  [3832] = 3736,
  [3833] = 3694,
  [3834] = 3693,
  [3835] = 3835,
  [3836] = 3694,
  [3837] = 3736,
  [3838] = 3698,
  [3839] = 3701,
  [3840] = 3699,
  [3841] = 3754,
  [3842] = 3842,
  [3843] = 3843,
  [3844] = 3844,
  [3845] = 3845,
  [3846] = 3846,
  [3847] = 3847,
  [3848] = 3848,
  [3849] = 3849,
  [3850] = 3850,
  [3851] = 3851,
  [3852] = 3852,
  [3853] = 3853,
  [3854] = 3844,
  [3855] = 3849,
  [3856] = 3856,
  [3857] = 3857,
  [3858] = 3853,
  [3859] = 3847,
  [3860] = 3860,
  [3861] = 3861,
  [3862] = 3860,
  [3863] = 3863,
  [3864] = 3845,
  [3865] = 3857,
  [3866] = 3860,
  [3867] = 3853,
  [3868] = 3849,
  [3869] = 3846,
  [3870] = 3848,
  [3871] = 3850,
  [3872] = 3851,
  [3873] = 3844,
  [3874] = 3874,
  [3875] = 3849,
  [3876] = 3863,
  [3877] = 3686,
  [3878] = 3662,
  [3879] = 3861,
  [3880] = 3853,
  [3881] = 3860,
  [3882] = 3857,
  [3883] = 3683,
  [3884] = 3857,
  [3885] = 3692,
  [3886] = 3850,
  [3887] = 3844,
  [3888] = 3851,
  [3889] = 3889,
  [3890] = 3850,
  [3891] = 3863,
  [3892] = 3892,
  [3893] = 3847,
  [3894] = 3861,
  [3895] = 3849,
  [3896] = 3844,
  [3897] = 3861,
  [3898] = 3863,
  [3899] = 3853,
  [3900] = 3900,
  [3901] = 3845,
  [3902] = 3846,
  [3903] = 3860,
  [3904] = 3863,
  [3905] = 3848,
  [3906] = 3906,
  [3907] = 1737,
  [3908] = 3861,
  [3909] = 3860,
  [3910] = 3853,
  [3911] = 3849,
  [3912] = 3851,
  [3913] = 3913,
  [3914] = 3914,
  [3915] = 3861,
  [3916] = 3844,
  [3917] = 3844,
  [3918] = 3918,
  [3919] = 3919,
  [3920] = 3920,
  [3921] = 3863,
  [3922] = 3847,
  [3923] = 3848,
  [3924] = 3924,
  [3925] = 3925,
  [3926] = 3846,
  [3927] = 3845,
  [3928] = 3857,
  [3929] = 3857,
  [3930] = 3930,
  [3931] = 3848,
  [3932] = 3846,
  [3933] = 3845,
  [3934] = 3851,
  [3935] = 3850,
  [3936] = 3860,
  [3937] = 3844,
  [3938] = 3844,
  [3939] = 3853,
  [3940] = 3849,
  [3941] = 1740,
  [3942] = 3848,
  [3943] = 3846,
  [3944] = 3944,
  [3945] = 3847,
  [3946] = 3946,
  [3947] = 3947,
  [3948] = 3844,
  [3949] = 3949,
  [3950] = 3848,
  [3951] = 3844,
  [3952] = 3845,
  [3953] = 3953,
  [3954] = 3863,
  [3955] = 3861,
  [3956] = 3857,
  [3957] = 3957,
  [3958] = 3391,
  [3959] = 3959,
  [3960] = 3960,
  [3961] = 3845,
  [3962] = 3847,
  [3963] = 3963,
  [3964] = 3851,
  [3965] = 3850,
  [3966] = 3846,
  [3967] = 3848,
  [3968] = 3847,
  [3969] = 3969,
  [3970] = 1717,
  [3971] = 3971,
  [3972] = 1715,
  [3973] = 3845,
  [3974] = 3846,
  [3975] = 3975,
  [3976] = 3976,
  [3977] = 3388,
  [3978] = 3847,
  [3979] = 3850,
  [3980] = 1737,
  [3981] = 3981,
  [3982] = 1715,
  [3983] = 3983,
  [3984] = 3847,
  [3985] = 3851,
  [3986] = 3850,
  [3987] = 3851,
  [3988] = 3850,
  [3989] = 3844,
  [3990] = 3851,
  [3991] = 3851,
  [3992] = 3844,
  [3993] = 3857,
  [3994] = 3861,
  [3995] = 3863,
  [3996] = 3850,
  [3997] = 3845,
  [3998] = 3846,
  [3999] = 3848,
  [4000] = 2248,
  [4001] = 3857,
  [4002] = 4002,
  [4003] = 4003,
  [4004] = 3857,
  [4005] = 4005,
  [4006] = 3860,
  [4007] = 3853,
  [4008] = 3849,
  [4009] = 4009,
  [4010] = 1717,
  [4011] = 4011,
  [4012] = 4012,
  [4013] = 1740,
  [4014] = 3861,
  [4015] = 3863,
  [4016] = 4016,
  [4017] = 3860,
  [4018] = 4018,
  [4019] = 3853,
  [4020] = 3849,
  [4021] = 1717,
  [4022] = 4022,
  [4023] = 4023,
  [4024] = 4024,
  [4025] = 4025,
  [4026] = 3857,
  [4027] = 3849,
  [4028] = 4028,
  [4029] = 3849,
  [4030] = 3853,
  [4031] = 3851,
  [4032] = 3850,
  [4033] = 4033,
  [4034] = 3853,
  [4035] = 3860,
  [4036] = 3847,
  [4037] = 3850,
  [4038] = 3851,
  [4039] = 3857,
  [4040] = 3860,
  [4041] = 3857,
  [4042] = 3847,
  [4043] = 3849,
  [4044] = 3849,
  [4045] = 3853,
  [4046] = 3860,
  [4047] = 3851,
  [4048] = 3853,
  [4049] = 3850,
  [4050] = 4050,
  [4051] = 3860,
  [4052] = 3863,
  [4053] = 3861,
  [4054] = 4054,
  [4055] = 3863,
  [4056] = 3845,
  [4057] = 4057,
  [4058] = 3847,
  [4059] = 3847,
  [4060] = 3861,
  [4061] = 3850,
  [4062] = 3851,
  [4063] = 4063,
  [4064] = 3847,
  [4065] = 3857,
  [4066] = 1737,
  [4067] = 3849,
  [4068] = 3853,
  [4069] = 3863,
  [4070] = 3860,
  [4071] = 3861,
  [4072] = 3844,
  [4073] = 3848,
  [4074] = 3846,
  [4075] = 3844,
  [4076] = 3845,
  [4077] = 4077,
  [4078] = 3860,
  [4079] = 3853,
  [4080] = 3849,
  [4081] = 3848,
  [4082] = 3846,
  [4083] = 1715,
  [4084] = 3857,
  [4085] = 3848,
  [4086] = 3846,
  [4087] = 3851,
  [4088] = 3850,
  [4089] = 3845,
  [4090] = 4090,
  [4091] = 3845,
  [4092] = 3847,
  [4093] = 4093,
  [4094] = 4094,
  [4095] = 4095,
  [4096] = 4096,
  [4097] = 4097,
  [4098] = 3686,
  [4099] = 4099,
  [4100] = 3662,
  [4101] = 4101,
  [4102] = 4095,
  [4103] = 3662,
  [4104] = 3686,
  [4105] = 4105,
  [4106] = 3683,
  [4107] = 4107,
  [4108] = 3692,
  [4109] = 4109,
  [4110] = 4110,
  [4111] = 4111,
  [4112] = 4095,
  [4113] = 4105,
  [4114] = 4107,
  [4115] = 4115,
  [4116] = 1814,
  [4117] = 4101,
  [4118] = 4118,
  [4119] = 4105,
  [4120] = 4107,
  [4121] = 4099,
  [4122] = 4122,
  [4123] = 4101,
  [4124] = 4122,
  [4125] = 4095,
  [4126] = 4126,
  [4127] = 4127,
  [4128] = 4128,
  [4129] = 4107,
  [4130] = 4128,
  [4131] = 4115,
  [4132] = 4132,
  [4133] = 3692,
  [4134] = 4115,
  [4135] = 4107,
  [4136] = 4105,
  [4137] = 3683,
  [4138] = 4128,
  [4139] = 2331,
  [4140] = 4140,
  [4141] = 4107,
  [4142] = 4126,
  [4143] = 4097,
  [4144] = 4095,
  [4145] = 4145,
  [4146] = 4097,
  [4147] = 4107,
  [4148] = 4148,
  [4149] = 4126,
  [4150] = 4150,
  [4151] = 4105,
  [4152] = 3686,
  [4153] = 4153,
  [4154] = 4107,
  [4155] = 3662,
  [4156] = 4122,
  [4157] = 4107,
  [4158] = 4105,
  [4159] = 4159,
  [4160] = 4160,
  [4161] = 4132,
  [4162] = 4122,
  [4163] = 4107,
  [4164] = 1796,
  [4165] = 4140,
  [4166] = 3683,
  [4167] = 4107,
  [4168] = 3692,
  [4169] = 4115,
  [4170] = 4128,
  [4171] = 4153,
  [4172] = 4126,
  [4173] = 4159,
  [4174] = 4122,
  [4175] = 4175,
  [4176] = 4097,
  [4177] = 4177,
  [4178] = 4178,
  [4179] = 4145,
  [4180] = 4180,
  [4181] = 4181,
  [4182] = 4153,
  [4183] = 4183,
  [4184] = 4183,
  [4185] = 4159,
  [4186] = 4186,
  [4187] = 4122,
  [4188] = 4188,
  [4189] = 4181,
  [4190] = 4181,
  [4191] = 4107,
  [4192] = 4175,
  [4193] = 4193,
  [4194] = 4181,
  [4195] = 4195,
  [4196] = 4183,
  [4197] = 4183,
  [4198] = 4198,
  [4199] = 4199,
  [4200] = 4095,
  [4201] = 4122,
  [4202] = 4175,
  [4203] = 4159,
  [4204] = 4153,
  [4205] = 1815,
  [4206] = 4206,
  [4207] = 4207,
  [4208] = 4208,
  [4209] = 4175,
  [4210] = 4126,
  [4211] = 4175,
  [4212] = 4128,
  [4213] = 4213,
  [4214] = 4115,
  [4215] = 3692,
  [4216] = 3683,
  [4217] = 4217,
  [4218] = 4105,
  [4219] = 4145,
  [4220] = 3686,
  [4221] = 3662,
  [4222] = 3662,
  [4223] = 4223,
  [4224] = 4183,
  [4225] = 4181,
  [4226] = 3686,
  [4227] = 4097,
  [4228] = 4145,
  [4229] = 4105,
  [4230] = 4122,
  [4231] = 4159,
  [4232] = 4232,
  [4233] = 4153,
  [4234] = 4234,
  [4235] = 4145,
  [4236] = 3683,
  [4237] = 4237,
  [4238] = 3683,
  [4239] = 4101,
  [4240] = 4099,
  [4241] = 4099,
  [4242] = 4242,
  [4243] = 4126,
  [4244] = 4244,
  [4245] = 4128,
  [4246] = 4095,
  [4247] = 4247,
  [4248] = 3692,
  [4249] = 4249,
  [4250] = 4115,
  [4251] = 4115,
  [4252] = 4128,
  [4253] = 4126,
  [4254] = 4254,
  [4255] = 4097,
  [4256] = 4256,
  [4257] = 4257,
  [4258] = 4101,
  [4259] = 3692,
  [4260] = 3683,
  [4261] = 4261,
  [4262] = 4105,
  [4263] = 4145,
  [4264] = 4099,
  [4265] = 4145,
  [4266] = 3662,
  [4267] = 3686,
  [4268] = 4268,
  [4269] = 4269,
  [4270] = 4097,
  [4271] = 4271,
  [4272] = 4095,
  [4273] = 4273,
  [4274] = 4274,
  [4275] = 4275,
  [4276] = 4276,
  [4277] = 4095,
  [4278] = 4177,
  [4279] = 4101,
  [4280] = 4178,
  [4281] = 4180,
  [4282] = 4282,
  [4283] = 4107,
  [4284] = 4097,
  [4285] = 4285,
  [4286] = 4286,
  [4287] = 4181,
  [4288] = 4099,
  [4289] = 4099,
  [4290] = 4175,
  [4291] = 4099,
  [4292] = 4101,
  [4293] = 4159,
  [4294] = 4099,
  [4295] = 4101,
  [4296] = 3686,
  [4297] = 3662,
  [4298] = 4183,
  [4299] = 4181,
  [4300] = 4122,
  [4301] = 4105,
  [4302] = 4097,
  [4303] = 3683,
  [4304] = 4105,
  [4305] = 4145,
  [4306] = 3692,
  [4307] = 4307,
  [4308] = 4095,
  [4309] = 4122,
  [4310] = 4115,
  [4311] = 4159,
  [4312] = 4312,
  [4313] = 4115,
  [4314] = 4314,
  [4315] = 4153,
  [4316] = 4128,
  [4317] = 4126,
  [4318] = 4128,
  [4319] = 4097,
  [4320] = 4320,
  [4321] = 4175,
  [4322] = 4126,
  [4323] = 4128,
  [4324] = 4115,
  [4325] = 4325,
  [4326] = 3692,
  [4327] = 4126,
  [4328] = 4153,
  [4329] = 4183,
  [4330] = 4105,
  [4331] = 4159,
  [4332] = 4122,
  [4333] = 4181,
  [4334] = 4183,
  [4335] = 3662,
  [4336] = 3686,
  [4337] = 3686,
  [4338] = 4097,
  [4339] = 3662,
  [4340] = 4122,
  [4341] = 4159,
  [4342] = 4153,
  [4343] = 4153,
  [4344] = 4145,
  [4345] = 4345,
  [4346] = 4159,
  [4347] = 4175,
  [4348] = 4348,
  [4349] = 4349,
  [4350] = 4095,
  [4351] = 4101,
  [4352] = 4099,
  [4353] = 4105,
  [4354] = 4354,
  [4355] = 3683,
  [4356] = 4356,
  [4357] = 4122,
  [4358] = 3692,
  [4359] = 4359,
  [4360] = 4181,
  [4361] = 4183,
  [4362] = 4115,
  [4363] = 4128,
  [4364] = 4175,
  [4365] = 4145,
  [4366] = 4126,
  [4367] = 4175,
  [4368] = 4101,
  [4369] = 4175,
  [4370] = 4128,
  [4371] = 4145,
  [4372] = 4126,
  [4373] = 4373,
  [4374] = 4115,
  [4375] = 4101,
  [4376] = 4153,
  [4377] = 4099,
  [4378] = 4145,
  [4379] = 4379,
  [4380] = 4095,
  [4381] = 4183,
  [4382] = 4099,
  [4383] = 4097,
  [4384] = 3686,
  [4385] = 4385,
  [4386] = 4386,
  [4387] = 4387,
  [4388] = 3662,
  [4389] = 4105,
  [4390] = 4390,
  [4391] = 4181,
  [4392] = 4392,
  [4393] = 4175,
  [4394] = 4101,
  [4395] = 4105,
  [4396] = 4183,
  [4397] = 4181,
  [4398] = 4181,
  [4399] = 4097,
  [4400] = 4183,
  [4401] = 3683,
  [4402] = 4153,
  [4403] = 4122,
  [4404] = 3692,
  [4405] = 4115,
  [4406] = 4128,
  [4407] = 4126,
  [4408] = 4408,
  [4409] = 4159,
  [4410] = 4153,
  [4411] = 4159,
  [4412] = 4095,
  [4413] = 4122,
  [4414] = 4414,
  [4415] = 4415,
  [4416] = 4416,
  [4417] = 4417,
  [4418] = 4418,
  [4419] = 4419,
  [4420] = 4420,
  [4421] = 4421,
  [4422] = 4422,
  [4423] = 4423,
  [4424] = 4424,
  [4425] = 4423,
  [4426] = 4424,
  [4427] = 4421,
  [4428] = 4419,
  [4429] = 4429,
  [4430] = 4430,
  [4431] = 4431,
  [4432] = 4416,
  [4433] = 4433,
  [4434] = 4434,
  [4435] = 4435,
  [4436] = 4436,
  [4437] = 4414,
  [4438] = 4438,
  [4439] = 4419,
  [4440] = 4421,
  [4441] = 4424,
  [4442] = 4414,
  [4443] = 4443,
  [4444] = 4423,
  [4445] = 4445,
  [4446] = 4431,
  [4447] = 4424,
  [4448] = 4421,
  [4449] = 4419,
  [4450] = 4416,
  [4451] = 4451,
  [4452] = 4452,
  [4453] = 4453,
  [4454] = 4423,
  [4455] = 4431,
  [4456] = 4456,
  [4457] = 4457,
  [4458] = 4458,
  [4459] = 4434,
  [4460] = 4458,
  [4461] = 4414,
  [4462] = 4434,
  [4463] = 4435,
  [4464] = 4464,
  [4465] = 4423,
  [4466] = 4445,
  [4467] = 4451,
  [4468] = 4424,
  [4469] = 4421,
  [4470] = 4419,
  [4471] = 4471,
  [4472] = 4453,
  [4473] = 4456,
  [4474] = 4436,
  [4475] = 4436,
  [4476] = 4435,
  [4477] = 4477,
  [4478] = 4478,
  [4479] = 4445,
  [4480] = 4456,
  [4481] = 4453,
  [4482] = 4451,
  [4483] = 4416,
  [4484] = 4431,
  [4485] = 4419,
  [4486] = 4423,
  [4487] = 4458,
  [4488] = 4457,
  [4489] = 4424,
  [4490] = 4421,
  [4491] = 4414,
  [4492] = 4421,
  [4493] = 4445,
  [4494] = 4436,
  [4495] = 4458,
  [4496] = 4435,
  [4497] = 4424,
  [4498] = 4414,
  [4499] = 4434,
  [4500] = 4423,
  [4501] = 4429,
  [4502] = 4502,
  [4503] = 4416,
  [4504] = 4434,
  [4505] = 4505,
  [4506] = 4435,
  [4507] = 4423,
  [4508] = 4457,
  [4509] = 4419,
  [4510] = 4424,
  [4511] = 4421,
  [4512] = 4419,
  [4513] = 4434,
  [4514] = 4429,
  [4515] = 4456,
  [4516] = 4453,
  [4517] = 4451,
  [4518] = 4421,
  [4519] = 4519,
  [4520] = 4520,
  [4521] = 4521,
  [4522] = 4424,
  [4523] = 4423,
  [4524] = 4429,
  [4525] = 4431,
  [4526] = 4416,
  [4527] = 4434,
  [4528] = 4423,
  [4529] = 4435,
  [4530] = 4429,
  [4531] = 4424,
  [4532] = 4421,
  [4533] = 4419,
  [4534] = 4436,
  [4535] = 4535,
  [4536] = 4445,
  [4537] = 4436,
  [4538] = 4538,
  [4539] = 4539,
  [4540] = 4540,
  [4541] = 4445,
  [4542] = 4542,
  [4543] = 4457,
  [4544] = 4458,
  [4545] = 4423,
  [4546] = 4546,
  [4547] = 4424,
  [4548] = 4421,
  [4549] = 4419,
  [4550] = 4456,
  [4551] = 4453,
  [4552] = 4451,
  [4553] = 4423,
  [4554] = 4419,
  [4555] = 2386,
  [4556] = 4457,
  [4557] = 4423,
  [4558] = 4419,
  [4559] = 4458,
  [4560] = 4416,
  [4561] = 4561,
  [4562] = 4431,
  [4563] = 4416,
  [4564] = 4456,
  [4565] = 4431,
  [4566] = 4419,
  [4567] = 4414,
  [4568] = 4568,
  [4569] = 4569,
  [4570] = 4570,
  [4571] = 4571,
  [4572] = 4434,
  [4573] = 4435,
  [4574] = 4436,
  [4575] = 4575,
  [4576] = 4445,
  [4577] = 4577,
  [4578] = 4578,
  [4579] = 4457,
  [4580] = 4580,
  [4581] = 4429,
  [4582] = 4458,
  [4583] = 4451,
  [4584] = 4453,
  [4585] = 4456,
  [4586] = 4418,
  [4587] = 4429,
  [4588] = 4419,
  [4589] = 4421,
  [4590] = 4590,
  [4591] = 4451,
  [4592] = 4424,
  [4593] = 4419,
  [4594] = 4453,
  [4595] = 4421,
  [4596] = 4424,
  [4597] = 4453,
  [4598] = 4451,
  [4599] = 4599,
  [4600] = 4414,
  [4601] = 4423,
  [4602] = 4414,
  [4603] = 4603,
  [4604] = 4458,
  [4605] = 4605,
  [4606] = 4414,
  [4607] = 4456,
  [4608] = 4457,
  [4609] = 4423,
  [4610] = 4457,
  [4611] = 4429,
  [4612] = 4445,
  [4613] = 4436,
  [4614] = 4451,
  [4615] = 4453,
  [4616] = 4456,
  [4617] = 4458,
  [4618] = 4435,
  [4619] = 4457,
  [4620] = 4431,
  [4621] = 4621,
  [4622] = 4458,
  [4623] = 4457,
  [4624] = 4445,
  [4625] = 4416,
  [4626] = 4626,
  [4627] = 4627,
  [4628] = 4445,
  [4629] = 4629,
  [4630] = 4436,
  [4631] = 4436,
  [4632] = 4435,
  [4633] = 4434,
  [4634] = 4429,
  [4635] = 4435,
  [4636] = 4636,
  [4637] = 4434,
  [4638] = 4434,
  [4639] = 4431,
  [4640] = 4416,
  [4641] = 4431,
  [4642] = 4434,
  [4643] = 4429,
  [4644] = 4644,
  [4645] = 4435,
  [4646] = 4603,
  [4647] = 4416,
  [4648] = 4436,
  [4649] = 4431,
  [4650] = 4456,
  [4651] = 4445,
  [4652] = 4429,
  [4653] = 4457,
  [4654] = 4458,
  [4655] = 4655,
  [4656] = 4656,
  [4657] = 4657,
  [4658] = 4658,
  [4659] = 4431,
  [4660] = 4456,
  [4661] = 4416,
  [4662] = 4429,
  [4663] = 4663,
  [4664] = 4434,
  [4665] = 4453,
  [4666] = 4451,
  [4667] = 4667,
  [4668] = 4435,
  [4669] = 4453,
  [4670] = 4451,
  [4671] = 4605,
  [4672] = 4672,
  [4673] = 4673,
  [4674] = 4436,
  [4675] = 4445,
  [4676] = 4435,
  [4677] = 4414,
  [4678] = 4457,
  [4679] = 4458,
  [4680] = 4429,
  [4681] = 4429,
  [4682] = 4590,
  [4683] = 4683,
  [4684] = 4429,
  [4685] = 4685,
  [4686] = 4686,
  [4687] = 4687,
  [4688] = 4456,
  [4689] = 4673,
  [4690] = 4453,
  [4691] = 4451,
  [4692] = 4435,
  [4693] = 4414,
  [4694] = 4694,
  [4695] = 4429,
  [4696] = 4429,
  [4697] = 4697,
  [4698] = 4698,
  [4699] = 4699,
  [4700] = 2374,
  [4701] = 4701,
  [4702] = 4416,
  [4703] = 4458,
  [4704] = 4704,
  [4705] = 4705,
  [4706] = 4414,
  [4707] = 4457,
  [4708] = 4451,
  [4709] = 4709,
  [4710] = 4453,
  [4711] = 4456,
  [4712] = 4435,
  [4713] = 4431,
  [4714] = 4714,
  [4715] = 4715,
  [4716] = 4716,
};

static TSCharacterRange sym_rune_literal_character_set_1[] = {
  {'"', '"'}, {'\'', '\''}, {'0', '7'}, {'U', 'U'}, {'\\', '\\'}, {'`', 'b'}, {'e', 'f'}, {'n', 'n'},
  {'r', 'r'}, {'t', 'v'}, {'x', 'x'},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '!', 266,
        '"', 341,
        '#', 394,
        '$', 339,
        '%', 239,
        '&', 276,
        '\'', 335,
        '(', 221,
        ')', 222,
        '*', 234,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 210,
        '/', 237,
        '0', 357,
        ':', 260,
        ';', 208,
        '<', 256,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 254,
        '\\', 21,
        ']', 258,
        '^', 274,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 387,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(329);
      if (('A' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(292);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '"', 341,
        '#', 113,
        '$', 110,
        '%', 238,
        '&', 277,
        '\'', 335,
        '(', 221,
        ')', 222,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 212,
        '/', 236,
        '0', 324,
        ':', 259,
        ';', 208,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 79,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 273,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 270,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(3);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '"', 341,
        '#', 113,
        '$', 110,
        '%', 238,
        '&', 277,
        '\'', 335,
        '(', 221,
        ')', 222,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 212,
        '/', 236,
        '0', 324,
        ':', 259,
        ';', 208,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 79,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 270,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(3);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '"', 341,
        '#', 113,
        '$', 107,
        '%', 238,
        '&', 277,
        '\'', 335,
        '(', 221,
        ')', 222,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 212,
        '/', 236,
        '0', 324,
        ';', 208,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 79,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 273,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 270,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(5);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '"', 341,
        '#', 113,
        '$', 107,
        '%', 238,
        '&', 277,
        '\'', 335,
        '(', 221,
        ')', 222,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 212,
        '/', 236,
        '0', 324,
        ';', 208,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 79,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 270,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(5);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 211,
        '/', 236,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 76,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 273,
        'a', 380,
        'i', 373,
        'm', 369,
        'o', 378,
        '{', 218,
        '|', 270,
        '}', 220,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(8);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 211,
        '/', 236,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 76,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 273,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 270,
        '}', 220,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(9);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 211,
        '/', 236,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 76,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        'a', 380,
        'i', 373,
        'm', 369,
        'o', 378,
        '{', 218,
        '|', 270,
        '}', 220,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(8);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 211,
        '/', 236,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 76,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 270,
        '}', 220,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(9);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '#', 113,
        '$', 108,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 211,
        '/', 236,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 76,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 273,
        'a', 380,
        'i', 373,
        'o', 378,
        '|', 270,
        '}', 220,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(11);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '#', 113,
        '$', 108,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 211,
        '/', 236,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 76,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        'a', 380,
        'i', 373,
        'o', 378,
        '|', 270,
        '}', 220,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(11);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '#', 113,
        '$', 126,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 209,
        '/', 236,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '[', 254,
        '^', 273,
        'a', 135,
        'i', 132,
        'o', 134,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(13);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '#', 113,
        '$', 126,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 209,
        '/', 236,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '[', 271,
        '^', 273,
        'a', 135,
        'i', 132,
        'o', 134,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(13);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 265,
        '"', 341,
        '$', 110,
        '&', 275,
        '\'', 335,
        '(', 221,
        ')', 222,
        '*', 233,
        '+', 225,
        ',', 219,
        '-', 229,
        '.', 212,
        '/', 83,
        '0', 324,
        ';', 208,
        '<', 86,
        '?', 263,
        '@', 79,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        '`', 114,
        'c', 360,
        'j', 381,
        'm', 369,
        'r', 361,
        '{', 218,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(14);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 15:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 265,
        '$', 111,
        '&', 275,
        '(', 221,
        '*', 233,
        '.', 209,
        '/', 83,
        '<', 255,
        '?', 263,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        'm', 369,
        '}', 220,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(16);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 16:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 265,
        '$', 111,
        '&', 275,
        '(', 221,
        '*', 233,
        '.', 209,
        '/', 83,
        '?', 263,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        'm', 369,
        '}', 220,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(16);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 17:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 265,
        '$', 111,
        '&', 275,
        '(', 221,
        '*', 233,
        '/', 83,
        ';', 208,
        '=', 223,
        '?', 263,
        '@', 76,
        'C', 363,
        'J', 367,
        '[', 271,
        'm', 369,
        '}', 220,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(17);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 18:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '$', 111,
        ',', 219,
        '.', 89,
        '/', 83,
        ':', 259,
        ';', 208,
        '=', 223,
        '@', 76,
        'C', 363,
        'J', 367,
        '[', 271,
        '{', 218,
        '}', 220,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(18);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 19:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '$', 111,
        '.', 209,
        '/', 83,
        ';', 208,
        '=', 223,
        '@', 76,
        'C', 363,
        'J', 367,
        '[', 254,
        '{', 218,
        '}', 220,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(20);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 20:
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '$', 111,
        '.', 209,
        '/', 83,
        ';', 208,
        '=', 223,
        '@', 76,
        'C', 363,
        'J', 367,
        '[', 271,
        '{', 218,
        '}', 220,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(20);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 21:
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == 'U') ADVANCE(294);
      if (lookahead == 'u') ADVANCE(296);
      if (lookahead == 'x') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(293);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          (lookahead < 0x0b || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(292);
      END_STATE();
    case 22:
      ADVANCE_MAP(
        '!', 266,
        '"', 341,
        '#', 113,
        '$', 110,
        '%', 238,
        '&', 277,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 215,
        '/', 236,
        '0', 324,
        ':', 259,
        ';', 208,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 79,
        'C', 363,
        'J', 367,
        '[', 254,
        ']', 258,
        '^', 273,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 270,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(23);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 23:
      ADVANCE_MAP(
        '!', 266,
        '"', 341,
        '#', 113,
        '$', 110,
        '%', 238,
        '&', 277,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 215,
        '/', 236,
        '0', 324,
        ':', 259,
        ';', 208,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 79,
        'C', 363,
        'J', 367,
        '[', 271,
        ']', 258,
        '^', 273,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 270,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(23);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 24:
      ADVANCE_MAP(
        '!', 266,
        '"', 341,
        '#', 113,
        '$', 107,
        '%', 238,
        '&', 277,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 215,
        '/', 236,
        '0', 324,
        ':', 259,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 79,
        'C', 363,
        'J', 367,
        '[', 254,
        ']', 258,
        '^', 273,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 270,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(25);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 25:
      ADVANCE_MAP(
        '!', 266,
        '"', 341,
        '#', 113,
        '$', 107,
        '%', 238,
        '&', 277,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 215,
        '/', 236,
        '0', 324,
        ':', 259,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 79,
        'C', 363,
        'J', 367,
        '[', 271,
        ']', 258,
        '^', 273,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 270,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(25);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 26:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 239,
        '&', 276,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 209,
        '/', 237,
        '0', 327,
        ':', 98,
        ';', 208,
        '<', 242,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 274,
        'a', 380,
        'i', 373,
        'm', 369,
        'o', 378,
        '{', 218,
        '|', 269,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(27);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(329);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 27:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 239,
        '&', 276,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 209,
        '/', 237,
        '0', 327,
        ':', 98,
        ';', 208,
        '<', 242,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 274,
        'a', 380,
        'i', 373,
        'm', 369,
        'o', 378,
        '{', 218,
        '|', 269,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(27);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(329);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 28:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 239,
        '&', 276,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 209,
        '/', 237,
        ':', 259,
        '<', 240,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 274,
        'a', 380,
        'i', 373,
        'm', 369,
        'o', 378,
        '{', 218,
        '|', 269,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(30);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 29:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 239,
        '&', 276,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 209,
        '/', 237,
        ':', 259,
        '<', 240,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 274,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 269,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(31);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 30:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 239,
        '&', 276,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 209,
        '/', 237,
        ':', 259,
        '<', 240,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 274,
        'a', 380,
        'i', 373,
        'm', 369,
        'o', 378,
        '{', 218,
        '|', 269,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(30);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 31:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 239,
        '&', 276,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 209,
        '/', 237,
        ':', 259,
        '<', 240,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 274,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 269,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(31);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 32:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 239,
        '&', 276,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 209,
        '/', 237,
        ':', 98,
        ';', 208,
        '<', 242,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 274,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 269,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(33);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 33:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 239,
        '&', 276,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 209,
        '/', 237,
        ':', 98,
        ';', 208,
        '<', 242,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 274,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 269,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(33);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 34:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 238,
        '&', 277,
        '(', 221,
        ')', 222,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 213,
        '/', 236,
        ':', 260,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        ']', 258,
        '^', 273,
        'a', 380,
        'i', 373,
        'm', 369,
        'o', 378,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(36);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 35:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 238,
        '&', 277,
        '(', 221,
        ')', 222,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 213,
        '/', 236,
        ':', 260,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        ']', 258,
        '^', 273,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(37);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 36:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 238,
        '&', 277,
        '(', 221,
        ')', 222,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 213,
        '/', 236,
        ':', 260,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        ']', 258,
        '^', 273,
        'a', 380,
        'i', 373,
        'm', 369,
        'o', 378,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(36);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 37:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 238,
        '&', 277,
        '(', 221,
        ')', 222,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 213,
        '/', 236,
        ':', 260,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        ']', 258,
        '^', 273,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(37);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 38:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 210,
        '/', 236,
        ':', 98,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 273,
        'a', 380,
        'i', 373,
        'm', 369,
        'o', 378,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(39);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 39:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 210,
        '/', 236,
        ':', 98,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        'a', 380,
        'i', 373,
        'm', 369,
        'o', 378,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(39);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 40:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 210,
        '/', 236,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 273,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(41);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 41:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 210,
        '/', 236,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(41);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 42:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        '-', 230,
        '.', 209,
        '/', 236,
        ':', 259,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 273,
        'a', 380,
        'i', 373,
        'o', 378,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(43);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 43:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 111,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        '-', 230,
        '.', 209,
        '/', 236,
        ':', 259,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        'a', 380,
        'i', 373,
        'o', 378,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(43);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 44:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 127,
        '%', 239,
        '&', 276,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 209,
        '/', 237,
        ':', 98,
        ';', 208,
        '<', 242,
        '=', 224,
        '>', 247,
        '?', 264,
        '[', 254,
        '^', 274,
        'a', 135,
        'i', 132,
        'o', 134,
        '{', 218,
        '|', 269,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(45);
      END_STATE();
    case 45:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 127,
        '%', 239,
        '&', 276,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 209,
        '/', 237,
        ':', 98,
        ';', 208,
        '<', 242,
        '=', 224,
        '>', 247,
        '?', 264,
        '[', 271,
        '^', 274,
        'a', 135,
        'i', 132,
        'o', 134,
        '{', 218,
        '|', 269,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(45);
      END_STATE();
    case 46:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 108,
        '%', 239,
        '&', 276,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 209,
        '/', 237,
        ':', 259,
        '<', 240,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 274,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 269,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(47);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 47:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 108,
        '%', 239,
        '&', 276,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 209,
        '/', 237,
        ':', 259,
        '<', 240,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 274,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 269,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(47);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 48:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 108,
        '%', 239,
        '&', 276,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 209,
        '/', 237,
        ':', 98,
        ';', 208,
        '<', 242,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 274,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 269,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(49);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 49:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 108,
        '%', 239,
        '&', 276,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 209,
        '/', 237,
        ':', 98,
        ';', 208,
        '<', 242,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 274,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 269,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(49);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 50:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 108,
        '%', 238,
        '&', 277,
        '(', 221,
        ')', 222,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 213,
        '/', 236,
        ':', 260,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        ']', 258,
        '^', 273,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 270,
        '}', 220,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(51);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 51:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 108,
        '%', 238,
        '&', 277,
        '(', 221,
        ')', 222,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 213,
        '/', 236,
        ':', 260,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        ']', 258,
        '^', 273,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 270,
        '}', 220,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(51);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 52:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 108,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 210,
        '/', 236,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 273,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(53);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 53:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 108,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 210,
        '/', 236,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        'a', 380,
        'i', 373,
        'o', 378,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(53);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 54:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 108,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        '-', 230,
        '.', 209,
        '/', 236,
        ':', 259,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 273,
        'a', 380,
        'i', 373,
        'o', 378,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(55);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 55:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 108,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        '-', 230,
        '.', 209,
        '/', 236,
        ':', 259,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        'a', 380,
        'i', 373,
        'o', 378,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(55);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 56:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 126,
        '%', 239,
        '&', 276,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 209,
        '/', 237,
        ':', 260,
        '<', 240,
        '=', 224,
        '>', 247,
        '?', 264,
        '[', 254,
        '^', 274,
        'a', 135,
        'i', 132,
        'o', 134,
        '{', 218,
        '|', 269,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(57);
      END_STATE();
    case 57:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 126,
        '%', 239,
        '&', 276,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 209,
        '/', 237,
        ':', 260,
        '<', 240,
        '=', 224,
        '>', 247,
        '?', 264,
        '[', 271,
        '^', 274,
        'a', 135,
        'i', 132,
        'o', 134,
        '{', 218,
        '|', 269,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(57);
      END_STATE();
    case 58:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 126,
        '%', 238,
        '&', 277,
        '(', 221,
        ')', 222,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 213,
        '/', 236,
        ':', 260,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '[', 254,
        ']', 258,
        '^', 273,
        'a', 135,
        'i', 132,
        'o', 134,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(59);
      END_STATE();
    case 59:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 126,
        '%', 238,
        '&', 277,
        '(', 221,
        ')', 222,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 213,
        '/', 236,
        ':', 260,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '[', 271,
        ']', 258,
        '^', 273,
        'a', 135,
        'i', 132,
        'o', 134,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(59);
      END_STATE();
    case 60:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 126,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 210,
        '/', 236,
        ':', 98,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '[', 254,
        ']', 258,
        '^', 273,
        'a', 135,
        'i', 132,
        'o', 134,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(61);
      END_STATE();
    case 61:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 126,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 210,
        '/', 236,
        ':', 98,
        ';', 208,
        '<', 243,
        '=', 99,
        '>', 248,
        '?', 264,
        '[', 271,
        ']', 258,
        '^', 273,
        'a', 135,
        'i', 132,
        'o', 134,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(61);
      END_STATE();
    case 62:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 126,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 209,
        '/', 236,
        ':', 259,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '[', 254,
        '^', 273,
        'a', 135,
        'i', 132,
        'o', 134,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(63);
      END_STATE();
    case 63:
      ADVANCE_MAP(
        '!', 266,
        '#', 113,
        '$', 126,
        '%', 238,
        '&', 277,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 209,
        '/', 236,
        ':', 259,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '[', 271,
        '^', 273,
        'a', 135,
        'i', 132,
        'o', 134,
        '{', 218,
        '|', 270,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(63);
      END_STATE();
    case 64:
      ADVANCE_MAP(
        '!', 265,
        '"', 341,
        '$', 110,
        '&', 275,
        '\'', 335,
        '(', 221,
        ')', 222,
        '*', 233,
        '+', 225,
        ',', 219,
        '-', 229,
        '.', 212,
        '/', 83,
        '0', 324,
        ':', 259,
        ';', 208,
        '<', 86,
        '?', 263,
        '@', 79,
        'C', 363,
        'J', 367,
        '[', 271,
        ']', 258,
        '^', 273,
        '`', 114,
        'c', 360,
        'j', 381,
        'm', 369,
        'r', 361,
        '{', 218,
        '|', 268,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(64);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 65:
      ADVANCE_MAP(
        '!', 265,
        '"', 341,
        '$', 110,
        '&', 275,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 225,
        '-', 229,
        '.', 214,
        '/', 83,
        '0', 324,
        '<', 86,
        '?', 263,
        '@', 79,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        '`', 114,
        'c', 360,
        'j', 381,
        'm', 369,
        'r', 361,
        '{', 218,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(65);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 66:
      ADVANCE_MAP(
        '!', 265,
        '$', 111,
        '&', 275,
        '(', 221,
        ')', 222,
        '*', 233,
        ',', 219,
        '.', 211,
        '/', 83,
        '<', 255,
        '=', 223,
        '?', 263,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        'm', 369,
        '{', 218,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(67);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 67:
      ADVANCE_MAP(
        '!', 265,
        '$', 111,
        '&', 275,
        '(', 221,
        ')', 222,
        '*', 233,
        ',', 219,
        '.', 211,
        '/', 83,
        '=', 223,
        '?', 263,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        'm', 369,
        '{', 218,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(67);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 68:
      ADVANCE_MAP(
        '!', 265,
        '$', 111,
        '&', 275,
        '(', 221,
        ')', 222,
        '*', 233,
        ',', 219,
        '.', 89,
        '/', 83,
        '=', 223,
        '?', 263,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        ']', 258,
        'm', 369,
        '{', 218,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(68);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 69:
      ADVANCE_MAP(
        '!', 96,
        '$', 111,
        '%', 238,
        '(', 221,
        ')', 222,
        '*', 233,
        '+', 225,
        '-', 229,
        '.', 211,
        '/', 236,
        '0', 327,
        ':', 259,
        '<', 244,
        '=', 99,
        '>', 246,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 271,
        ']', 258,
        '{', 218,
        '|', 268,
        '}', 220,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(69);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(329);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 70:
      ADVANCE_MAP(
        '!', 96,
        '$', 111,
        '%', 238,
        '(', 221,
        '*', 233,
        '+', 225,
        '-', 229,
        '/', 236,
        '<', 244,
        '=', 99,
        '>', 246,
        '@', 76,
        'C', 363,
        'J', 367,
        '[', 271,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(70);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 71:
      ADVANCE_MAP(
        '!', 96,
        '$', 82,
        '%', 238,
        '(', 221,
        ')', 222,
        '*', 233,
        '+', 225,
        '-', 229,
        '.', 211,
        '/', 236,
        '0', 327,
        ':', 259,
        '<', 257,
        '=', 99,
        '>', 246,
        '@', 77,
        'C', 363,
        'J', 367,
        '[', 254,
        ']', 258,
        '{', 218,
        '|', 268,
        '}', 220,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(69);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(329);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 72:
      ADVANCE_MAP(
        '"', 341,
        '$', 111,
        '\'', 335,
        '.', 147,
        '/', 83,
        '0', 324,
        '@', 77,
        'C', 363,
        'J', 367,
        '`', 114,
        'c', 360,
        'r', 361,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(72);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 73:
      if (lookahead == '"') ADVANCE(341);
      if (lookahead == '$') ADVANCE(340);
      if (lookahead == '/') ADVANCE(342);
      if (lookahead == '\\') ADVANCE(21);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(343);
      if (lookahead != 0) ADVANCE(344);
      END_STATE();
    case 74:
      if (lookahead == '"') ADVANCE(341);
      if (lookahead == '/') ADVANCE(352);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(353);
      if (lookahead != 0) ADVANCE(354);
      END_STATE();
    case 75:
      ADVANCE_MAP(
        '$', 111,
        '.', 209,
        '/', 83,
        '0', 357,
        '>', 245,
        '@', 77,
        'C', 363,
        'J', 367,
        ']', 258,
        '}', 220,
        '+', 356,
        '-', 356,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(75);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(329);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 76:
      if (lookahead == '$') ADVANCE(111);
      if (lookahead == 'C') ADVANCE(363);
      if (lookahead == 'J') ADVANCE(367);
      if (lookahead == '[') ADVANCE(402);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 77:
      if (lookahead == '$') ADVANCE(111);
      if (lookahead == 'C') ADVANCE(363);
      if (lookahead == 'J') ADVANCE(367);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 78:
      if (lookahead == '$') ADVANCE(111);
      if (lookahead == 'C') ADVANCE(362);
      if (lookahead == 'J') ADVANCE(366);
      if (lookahead == '[') ADVANCE(402);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(383);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 79:
      if (lookahead == '$') ADVANCE(111);
      if (lookahead == 'C') ADVANCE(362);
      if (lookahead == 'J') ADVANCE(366);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(383);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 80:
      if (lookahead == '$') ADVANCE(340);
      if (lookahead == '\'') ADVANCE(335);
      if (lookahead == '/') ADVANCE(336);
      if (lookahead == '\\') ADVANCE(21);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(337);
      if (lookahead != 0) ADVANCE(338);
      END_STATE();
    case 81:
      if (lookahead == '\'') ADVANCE(335);
      if (lookahead == '/') ADVANCE(348);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(349);
      if (lookahead != 0) ADVANCE(350);
      END_STATE();
    case 82:
      if (lookahead == '(') ADVANCE(298);
      if (lookahead == 'C') ADVANCE(363);
      if (lookahead == 'J') ADVANCE(367);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 83:
      if (lookahead == '*') ADVANCE(199);
      if (lookahead == '/') ADVANCE(196);
      END_STATE();
    case 84:
      if (lookahead == '*') ADVANCE(199);
      if (lookahead == '/') ADVANCE(196);
      if (lookahead == '=') ADVANCE(311);
      END_STATE();
    case 85:
      if (lookahead == '*') ADVANCE(202);
      if (lookahead == '/') ADVANCE(204);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(205);
      if (lookahead != 0) ADVANCE(206);
      END_STATE();
    case 86:
      if (lookahead == '-') ADVANCE(279);
      END_STATE();
    case 87:
      if (lookahead == '-') ADVANCE(279);
      if (lookahead == '<') ADVANCE(102);
      END_STATE();
    case 88:
      if (lookahead == '.') ADVANCE(253);
      END_STATE();
    case 89:
      if (lookahead == '.') ADVANCE(88);
      END_STATE();
    case 90:
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '_') ADVANCE(148);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(90);
      END_STATE();
    case 91:
      if (lookahead == '.') ADVANCE(154);
      if (lookahead == '_') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(323);
      END_STATE();
    case 92:
      if (lookahead == '/') ADVANCE(83);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(92);
      END_STATE();
    case 93:
      if (lookahead == '/') ADVANCE(399);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(400);
      if (lookahead != 0 &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(401);
      END_STATE();
    case 94:
      if (lookahead == '/') ADVANCE(396);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(92);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(397);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(398);
      END_STATE();
    case 95:
      if (lookahead == '0') ADVANCE(120);
      if (lookahead == 'U') ADVANCE(167);
      if (lookahead == 'u') ADVANCE(160);
      if (lookahead == 'x') ADVANCE(156);
      if (('1' <= lookahead && lookahead <= '7')) ADVANCE(143);
      if (set_contains(sym_rune_literal_character_set_1, 11, lookahead)) ADVANCE(119);
      END_STATE();
    case 96:
      if (lookahead == '=') ADVANCE(250);
      END_STATE();
    case 97:
      if (lookahead == '=') ADVANCE(312);
      END_STATE();
    case 98:
      if (lookahead == '=') ADVANCE(322);
      END_STATE();
    case 99:
      if (lookahead == '=') ADVANCE(249);
      END_STATE();
    case 100:
      if (lookahead == '=') ADVANCE(320);
      END_STATE();
    case 101:
      if (lookahead == '=') ADVANCE(317);
      END_STATE();
    case 102:
      if (lookahead == '=') ADVANCE(313);
      END_STATE();
    case 103:
      if (lookahead == '=') ADVANCE(314);
      if (lookahead == '>') ADVANCE(104);
      END_STATE();
    case 104:
      if (lookahead == '=') ADVANCE(315);
      END_STATE();
    case 105:
      if (lookahead == '>') ADVANCE(103);
      END_STATE();
    case 106:
      if (lookahead == 'C') ADVANCE(363);
      if (lookahead == 'J') ADVANCE(367);
      if (lookahead == 'e') ADVANCE(372);
      if (lookahead == 'f') ADVANCE(376);
      if (lookahead == 'i') ADVANCE(371);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 107:
      if (lookahead == 'C') ADVANCE(363);
      if (lookahead == 'J') ADVANCE(367);
      if (lookahead == 'e') ADVANCE(372);
      if (lookahead == 'i') ADVANCE(371);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 108:
      if (lookahead == 'C') ADVANCE(363);
      if (lookahead == 'J') ADVANCE(367);
      if (lookahead == 'e') ADVANCE(372);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 109:
      if (lookahead == 'C') ADVANCE(363);
      if (lookahead == 'J') ADVANCE(367);
      if (lookahead == 'f') ADVANCE(376);
      if (lookahead == 'i') ADVANCE(371);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 110:
      if (lookahead == 'C') ADVANCE(363);
      if (lookahead == 'J') ADVANCE(367);
      if (lookahead == 'i') ADVANCE(371);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 111:
      if (lookahead == 'C') ADVANCE(363);
      if (lookahead == 'J') ADVANCE(367);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 112:
      if (lookahead == 'J') ADVANCE(367);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 113:
      if (lookahead == '[') ADVANCE(299);
      END_STATE();
    case 114:
      if (lookahead == '\\') ADVANCE(95);
      if (lookahead != 0) ADVANCE(119);
      END_STATE();
    case 115:
      if (lookahead == '_') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(328);
      END_STATE();
    case 116:
      if (lookahead == '_') ADVANCE(139);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(330);
      END_STATE();
    case 117:
      if (lookahead == '_') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(331);
      END_STATE();
    case 118:
      if (lookahead == '_') ADVANCE(154);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(118);
      END_STATE();
    case 119:
      if (lookahead == '`') ADVANCE(334);
      END_STATE();
    case 120:
      if (lookahead == '`') ADVANCE(334);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(142);
      END_STATE();
    case 121:
      if (lookahead == 'c') ADVANCE(133);
      END_STATE();
    case 122:
      if (lookahead == 'd') ADVANCE(124);
      END_STATE();
    case 123:
      if (lookahead == 'd') ADVANCE(125);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(267);
      END_STATE();
    case 126:
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(130);
      if (lookahead == 'i') ADVANCE(129);
      END_STATE();
    case 128:
      if (lookahead == 'e') ADVANCE(302);
      END_STATE();
    case 129:
      if (lookahead == 'f') ADVANCE(300);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(136);
      END_STATE();
    case 131:
      if (lookahead == 'n') ADVANCE(309);
      if (lookahead == 's') ADVANCE(306);
      END_STATE();
    case 132:
      if (lookahead == 'n') ADVANCE(307);
      if (lookahead == 's') ADVANCE(304);
      END_STATE();
    case 133:
      if (lookahead == 'o') ADVANCE(123);
      END_STATE();
    case 134:
      if (lookahead == 'r') ADVANCE(290);
      END_STATE();
    case 135:
      if (lookahead == 's') ADVANCE(216);
      END_STATE();
    case 136:
      if (lookahead == 's') ADVANCE(128);
      END_STATE();
    case 137:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(149);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(333);
      END_STATE();
    case 138:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(118);
      END_STATE();
    case 139:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(330);
      END_STATE();
    case 140:
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(325);
      END_STATE();
    case 141:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(328);
      END_STATE();
    case 142:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(119);
      END_STATE();
    case 143:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(142);
      END_STATE();
    case 144:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(329);
      END_STATE();
    case 145:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(292);
      END_STATE();
    case 146:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(326);
      END_STATE();
    case 147:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(332);
      END_STATE();
    case 148:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(90);
      END_STATE();
    case 149:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(333);
      END_STATE();
    case 150:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(292);
      END_STATE();
    case 151:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(119);
      END_STATE();
    case 152:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(331);
      END_STATE();
    case 153:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(323);
      END_STATE();
    case 154:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(118);
      END_STATE();
    case 155:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(150);
      END_STATE();
    case 156:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(151);
      END_STATE();
    case 157:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(156);
      END_STATE();
    case 158:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(155);
      END_STATE();
    case 159:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(158);
      END_STATE();
    case 160:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(157);
      END_STATE();
    case 161:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(160);
      END_STATE();
    case 162:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(159);
      END_STATE();
    case 163:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(162);
      END_STATE();
    case 164:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(161);
      END_STATE();
    case 165:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(163);
      END_STATE();
    case 166:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(164);
      END_STATE();
    case 167:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(166);
      END_STATE();
    case 168:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 169:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '"', 341,
        '#', 395,
        '$', 109,
        '%', 239,
        '&', 276,
        '\'', 335,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 215,
        '/', 237,
        '0', 324,
        ':', 260,
        ';', 208,
        '<', 240,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 274,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 269,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(170);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 170:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '"', 341,
        '#', 395,
        '$', 109,
        '%', 239,
        '&', 276,
        '\'', 335,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 215,
        '/', 237,
        '0', 324,
        ':', 260,
        ';', 208,
        '<', 240,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 274,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 269,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(170);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 171:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '"', 341,
        '#', 395,
        '$', 109,
        '%', 238,
        '&', 277,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 215,
        '/', 236,
        '0', 324,
        ';', 208,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 273,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 270,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(172);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 172:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '"', 341,
        '#', 395,
        '$', 109,
        '%', 238,
        '&', 277,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 215,
        '/', 236,
        '0', 324,
        ';', 208,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 270,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(172);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 173:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '"', 341,
        '#', 395,
        '$', 106,
        '%', 239,
        '&', 276,
        '\'', 335,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 215,
        '/', 237,
        '0', 324,
        ':', 260,
        ';', 208,
        '<', 240,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 274,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 269,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(174);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 174:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '"', 341,
        '#', 395,
        '$', 106,
        '%', 239,
        '&', 276,
        '\'', 335,
        '(', 221,
        '*', 235,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 215,
        '/', 237,
        '0', 324,
        ':', 260,
        ';', 208,
        '<', 240,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 274,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 269,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(174);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 175:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '"', 341,
        '#', 395,
        '$', 106,
        '%', 238,
        '&', 277,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 215,
        '/', 236,
        '0', 324,
        ';', 208,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 273,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 270,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(176);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 176:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 266,
        '"', 341,
        '#', 395,
        '$', 106,
        '%', 238,
        '&', 277,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 226,
        ',', 219,
        '-', 230,
        '.', 215,
        '/', 236,
        '0', 324,
        ';', 208,
        '<', 241,
        '=', 99,
        '>', 248,
        '?', 264,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 270,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(176);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 177:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 265,
        '"', 341,
        '#', 392,
        '$', 109,
        '%', 97,
        '&', 278,
        '\'', 335,
        '(', 221,
        '*', 235,
        '+', 228,
        ',', 219,
        '-', 232,
        '.', 215,
        '/', 84,
        '0', 324,
        ':', 98,
        ';', 208,
        '<', 87,
        '=', 223,
        '>', 105,
        '?', 263,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 274,
        '`', 114,
        'c', 360,
        'j', 381,
        'm', 369,
        'r', 361,
        '{', 218,
        '|', 100,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(177);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 178:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 265,
        '"', 341,
        '#', 392,
        '$', 109,
        '&', 275,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 225,
        ',', 219,
        '-', 229,
        '.', 215,
        '/', 83,
        '0', 324,
        ';', 208,
        '<', 86,
        '?', 263,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        '`', 114,
        'c', 360,
        'j', 381,
        'm', 369,
        'r', 361,
        '{', 218,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(178);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 179:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 265,
        '"', 341,
        '#', 392,
        '$', 109,
        '&', 275,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 225,
        '-', 229,
        '.', 215,
        '/', 83,
        '0', 324,
        '<', 86,
        '?', 263,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 273,
        '`', 114,
        'c', 360,
        'j', 381,
        'm', 369,
        'r', 361,
        '{', 218,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(180);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 180:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '\n', 188,
        '\r', 190,
        '!', 265,
        '"', 341,
        '#', 392,
        '$', 109,
        '&', 275,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 225,
        '-', 229,
        '.', 215,
        '/', 83,
        '0', 324,
        '<', 86,
        '?', 263,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        '`', 114,
        'c', 360,
        'j', 381,
        'm', 369,
        'r', 361,
        '{', 218,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(180);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 181:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '\n', 189,
        '\r', 191,
        '!', 265,
        '"', 341,
        '#', 392,
        '$', 109,
        '&', 275,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 225,
        '-', 229,
        '.', 215,
        '/', 83,
        '0', 324,
        '<', 86,
        '?', 263,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 254,
        '^', 273,
        '`', 114,
        'c', 360,
        'j', 381,
        'm', 369,
        'r', 361,
        '{', 218,
        '|', 386,
        '~', 272,
        '\t', 385,
        0x0b, 385,
        '\f', 385,
        ' ', 385,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 182:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '\n', 189,
        '\r', 191,
        '!', 265,
        '"', 341,
        '#', 392,
        '$', 109,
        '&', 275,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 225,
        '-', 229,
        '.', 215,
        '/', 83,
        '0', 324,
        '<', 86,
        '?', 263,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        '`', 114,
        'c', 360,
        'j', 381,
        'm', 369,
        'r', 361,
        '{', 218,
        '|', 386,
        '~', 272,
        '\t', 385,
        0x0b, 385,
        '\f', 385,
        ' ', 385,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 183:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '!', 266,
        '"', 341,
        '#', 394,
        '$', 339,
        '%', 239,
        '&', 276,
        '\'', 335,
        '(', 221,
        ')', 222,
        '*', 234,
        '+', 227,
        ',', 219,
        '-', 231,
        '.', 210,
        '/', 237,
        '0', 357,
        ':', 260,
        ';', 208,
        '<', 240,
        '=', 224,
        '>', 247,
        '?', 264,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 271,
        '\\', 21,
        ']', 258,
        '^', 274,
        '`', 114,
        'a', 380,
        'c', 360,
        'i', 373,
        'j', 381,
        'm', 369,
        'o', 378,
        'r', 361,
        '{', 218,
        '|', 269,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(329);
      if (('A' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 184:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '!', 265,
        '"', 341,
        '#', 393,
        '$', 109,
        '&', 275,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 225,
        ',', 219,
        '-', 229,
        '.', 215,
        '/', 83,
        '0', 324,
        ';', 208,
        '<', 86,
        '>', 245,
        '?', 263,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 271,
        ']', 258,
        '^', 273,
        '`', 114,
        'c', 360,
        'j', 381,
        'm', 369,
        'r', 361,
        '{', 218,
        '|', 268,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 185:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '!', 265,
        '"', 341,
        '#', 392,
        '$', 109,
        '&', 275,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 225,
        '-', 229,
        '.', 215,
        '/', 83,
        '0', 324,
        '<', 86,
        '?', 263,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        '`', 114,
        'c', 360,
        'j', 381,
        'm', 369,
        'r', 361,
        '{', 218,
        '|', 386,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(186);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 186:
      if (eof) ADVANCE(187);
      ADVANCE_MAP(
        '!', 265,
        '"', 341,
        '#', 392,
        '$', 109,
        '&', 275,
        '\'', 335,
        '(', 221,
        '*', 233,
        '+', 225,
        '-', 229,
        '.', 215,
        '/', 83,
        '0', 324,
        '<', 86,
        '?', 263,
        '@', 78,
        'C', 363,
        'J', 367,
        '[', 271,
        '^', 273,
        '`', 114,
        'c', 360,
        'j', 381,
        'm', 369,
        'r', 361,
        '{', 218,
        '}', 220,
        '~', 272,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(186);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(326);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(188);
      if (lookahead == '\r') ADVANCE(190);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(189);
      if (lookahead == '\r') ADVANCE(191);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(385);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\n') ADVANCE(188);
      if (lookahead == '\r') ADVANCE(190);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\n') ADVANCE(189);
      if (lookahead == '\r') ADVANCE(191);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(385);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_POUND_BANG);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym_shebang_token1);
      if (lookahead == '*') ADVANCE(201);
      if (lookahead == '/') ADVANCE(198);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(195);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(aux_sym_shebang_token1);
      if (lookahead == '/') ADVANCE(193);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(194);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(195);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(aux_sym_shebang_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(195);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\\') ADVANCE(398);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(195);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\\') ADVANCE(398);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(195);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(aux_sym_block_comment_token1);
      if (lookahead == '/') ADVANCE(207);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(aux_sym_block_comment_token2);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(aux_sym_block_comment_token2);
      if (lookahead == '*') ADVANCE(199);
      if (lookahead == '/') ADVANCE(196);
      if (lookahead != 0) ADVANCE(203);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(aux_sym_block_comment_token2);
      if (lookahead == '/') ADVANCE(204);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(205);
      if (lookahead != 0 &&
          lookahead != '*') ADVANCE(206);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(aux_sym_block_comment_token2);
      if (lookahead == '/') ADVANCE(203);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_STAR_SLASH);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(391);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(88);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(332);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(390);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(390);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(332);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(332);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_as);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(249);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(261);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(261);
      if (lookahead == '=') ADVANCE(318);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(318);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(262);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(262);
      if (lookahead == '=') ADVANCE(319);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(319);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '/') ADVANCE(207);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(310);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(199);
      if (lookahead == '/') ADVANCE(196);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(199);
      if (lookahead == '/') ADVANCE(196);
      if (lookahead == '=') ADVANCE(311);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(312);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(279);
      if (lookahead == '<') ADVANCE(281);
      if (lookahead == '=') ADVANCE(251);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(279);
      if (lookahead == '<') ADVANCE(280);
      if (lookahead == '=') ADVANCE(251);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(281);
      if (lookahead == '=') ADVANCE(251);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(280);
      if (lookahead == '=') ADVANCE(251);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(251);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(252);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(252);
      if (lookahead == '>') ADVANCE(282);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(252);
      if (lookahead == '>') ADVANCE(283);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_LT2);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_LT2);
      if (lookahead == '-') ADVANCE(279);
      if (lookahead == '<') ADVANCE(281);
      if (lookahead == '=') ADVANCE(251);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_LT2);
      if (lookahead == '=') ADVANCE(251);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(322);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(297);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(250);
      if (lookahead == 'i') ADVANCE(131);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_json_DOTdecode);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(320);
      if (lookahead == '|') ADVANCE(289);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(289);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_LBRACK2);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(321);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(288);
      if (lookahead == '=') ADVANCE(316);
      if (lookahead == '^') ADVANCE(287);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(288);
      if (lookahead == '^') ADVANCE(286);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(316);
      if (lookahead == '^') ADVANCE(101);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(313);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(314);
      if (lookahead == '>') ADVANCE(285);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(284);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(315);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_AMP_CARET);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_AMP_CARET);
      if (lookahead == '=') ADVANCE(317);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_or);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(145);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(165);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(150);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(158);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_POUND_LBRACK);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_DOLLARif);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_DOLLARif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_DOLLARelse);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_DOLLARelse);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_is);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_BANGis);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_in);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_BANGin);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_AMP_CARET_EQ);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(138);
      if (lookahead == '_') ADVANCE(153);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(323);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_int_literal);
      ADVANCE_MAP(
        '.', 147,
        '_', 140,
        'B', 116,
        'b', 116,
        'E', 137,
        'e', 137,
        'O', 115,
        'o', 115,
        'X', 91,
        'x', 91,
        '8', 90,
        '9', 90,
      );
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(325);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '_') ADVANCE(140);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(137);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(325);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '_') ADVANCE(146);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(326);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(141);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(116);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(115);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(328);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(328);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(329);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(139);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(330);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(331);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == '_') ADVANCE(147);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(332);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == '_') ADVANCE(149);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(333);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_rune_literal);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead == '*') ADVANCE(338);
      if (lookahead == '/') ADVANCE(338);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(338);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead == '/') ADVANCE(336);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(337);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(338);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(338);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == 'C') ADVANCE(363);
      if (lookahead == 'J') ADVANCE(367);
      if (lookahead == '{') ADVANCE(355);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{') ADVANCE(355);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token2);
      if (lookahead == '*') ADVANCE(344);
      if (lookahead == '/') ADVANCE(344);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(344);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token2);
      if (lookahead == '/') ADVANCE(342);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(343);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(344);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token2);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(344);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_c_SQUOTE);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_c_DQUOTE);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_r_SQUOTE);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(aux_sym_raw_string_literal_token1);
      if (lookahead == '*') ADVANCE(350);
      if (lookahead == '/') ADVANCE(350);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(350);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(aux_sym_raw_string_literal_token1);
      if (lookahead == '/') ADVANCE(348);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(349);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(350);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(aux_sym_raw_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(350);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_r_DQUOTE);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(aux_sym_raw_string_literal_token2);
      if (lookahead == '*') ADVANCE(354);
      if (lookahead == '/') ADVANCE(354);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(354);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(aux_sym_raw_string_literal_token2);
      if (lookahead == '/') ADVANCE(352);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(353);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(354);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(aux_sym_raw_string_literal_token2);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(354);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(aux_sym_format_specifier_token2);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == '_') ADVANCE(141);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(116);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(115);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(328);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_pseudo_compile_time_identifier);
      if (lookahead == '.') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(359);
      if (('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_pseudo_compile_time_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(359);
      if (('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(346);
      if (lookahead == '\'') ADVANCE(345);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(351);
      if (lookahead == '\'') ADVANCE(347);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(359);
      if (('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(358);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(359);
      if (('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(364);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '[') ADVANCE(388);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(377);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(303);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(301);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(382);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(308);
      if (lookahead == 's') ADVANCE(305);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(379);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(368);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(291);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(217);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(375);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(359);
      if (('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(aux_sym_sum_type_token1);
      if (lookahead == '\n') ADVANCE(189);
      if (lookahead == '\r') ADVANCE(191);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(385);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(anon_sym_PIPE2);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_PIPE2);
      if (lookahead == '=') ADVANCE(320);
      if (lookahead == '|') ADVANCE(289);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(anon_sym_map_LBRACK);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(anon_sym_DOLLARfor);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 0xb5 ||
          (0x391 <= lookahead && lookahead <= 0x3a9) ||
          (0x3b1 <= lookahead && lookahead <= 0x3c9)) ADVANCE(384);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(253);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(192);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(192);
      if (lookahead == '[') ADVANCE(299);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '[') ADVANCE(299);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(aux_sym_hash_statement_token1);
      if (lookahead == '*') ADVANCE(200);
      if (lookahead == '/') ADVANCE(197);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\\') ADVANCE(398);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(aux_sym_hash_statement_token1);
      if (lookahead == '/') ADVANCE(396);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') ADVANCE(397);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '\\') ADVANCE(398);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(aux_sym_hash_statement_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\\') ADVANCE(398);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(aux_sym__content_block_token1);
      if (lookahead == '*') ADVANCE(401);
      if (lookahead == '/') ADVANCE(401);
      if (lookahead != 0 &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(401);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(aux_sym__content_block_token1);
      if (lookahead == '/') ADVANCE(399);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(400);
      if (lookahead != 0 &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(401);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(aux_sym__content_block_token1);
      if (lookahead != 0 &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(401);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_AT_LBRACK);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        '_', 1,
        'a', 2,
        'b', 3,
        'c', 4,
        'd', 5,
        'e', 6,
        'f', 7,
        'g', 8,
        'i', 9,
        'l', 10,
        'm', 11,
        'n', 12,
        'p', 13,
        'r', 14,
        's', 15,
        't', 16,
        'u', 17,
        'v', 18,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      if (('E' <= lookahead && lookahead <= 'G') ||
          lookahead == 'S' ||
          lookahead == 'X' ||
          lookahead == 'o' ||
          lookahead == 'x') ADVANCE(19);
      END_STATE();
    case 1:
      if (lookahead == '_') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 's') ADVANCE(21);
      if (lookahead == 't') ADVANCE(22);
      END_STATE();
    case 3:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == 'r') ADVANCE(23);
      END_STATE();
    case 4:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == 'h') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 5:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == 'e') ADVANCE(26);
      END_STATE();
    case 6:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'n') ADVANCE(28);
      END_STATE();
    case 7:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 9:
      if (lookahead == 'f') ADVANCE(33);
      if (lookahead == 'm') ADVANCE(34);
      if (lookahead == 'n') ADVANCE(35);
      END_STATE();
    case 10:
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(38);
      if (lookahead == 'u') ADVANCE(39);
      END_STATE();
    case 12:
      if (lookahead == 'i') ADVANCE(40);
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == 'u') ADVANCE(42);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == 'e') ADVANCE(45);
      if (lookahead == 'h') ADVANCE(46);
      if (lookahead == 'p') ADVANCE(47);
      if (lookahead == 'q') ADVANCE(48);
      if (lookahead == 't') ADVANCE(49);
      END_STATE();
    case 16:
      if (lookahead == 'h') ADVANCE(50);
      if (lookahead == 'r') ADVANCE(51);
      if (lookahead == 'y') ADVANCE(52);
      END_STATE();
    case 17:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 18:
      if (lookahead == 'o') ADVANCE(54);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      END_STATE();
    case 20:
      if (lookahead == 'g') ADVANCE(55);
      END_STATE();
    case 21:
      if (lookahead == 'm') ADVANCE(56);
      if (lookahead == 's') ADVANCE(57);
      END_STATE();
    case 22:
      if (lookahead == 'o') ADVANCE(58);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(60);
      END_STATE();
    case 25:
      if (lookahead == 'n') ADVANCE(61);
      END_STATE();
    case 26:
      if (lookahead == 'f') ADVANCE(62);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(63);
      END_STATE();
    case 28:
      if (lookahead == 'u') ADVANCE(64);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(65);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(66);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_go);
      if (lookahead == 't') ADVANCE(67);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 34:
      if (lookahead == 'p') ADVANCE(68);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 36:
      if (lookahead == 'c') ADVANCE(70);
      END_STATE();
    case 37:
      if (lookahead == 't') ADVANCE(71);
      END_STATE();
    case 38:
      if (lookahead == 'd') ADVANCE(72);
      END_STATE();
    case 39:
      if (lookahead == 't') ADVANCE(73);
      END_STATE();
    case 40:
      if (lookahead == 'l') ADVANCE(74);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(75);
      END_STATE();
    case 42:
      if (lookahead == 'b') ADVANCE(76);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 44:
      if (lookahead == 'o') ADVANCE(78);
      END_STATE();
    case 45:
      if (lookahead == 'l') ADVANCE(79);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(80);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(81);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(82);
      END_STATE();
    case 49:
      if (lookahead == 'a') ADVANCE(83);
      if (lookahead == 'r') ADVANCE(84);
      END_STATE();
    case 50:
      if (lookahead == 'r') ADVANCE(85);
      END_STATE();
    case 51:
      if (lookahead == 'u') ADVANCE(86);
      END_STATE();
    case 52:
      if (lookahead == 'p') ADVANCE(87);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(88);
      if (lookahead == 's') ADVANCE(89);
      END_STATE();
    case 54:
      if (lookahead == 'l') ADVANCE(90);
      END_STATE();
    case 55:
      if (lookahead == 'l') ADVANCE(91);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_asm);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 58:
      if (lookahead == 'm') ADVANCE(93);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(94);
      END_STATE();
    case 60:
      if (lookahead == 'n') ADVANCE(95);
      END_STATE();
    case 61:
      if (lookahead == 's') ADVANCE(96);
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 64:
      if (lookahead == 'm') ADVANCE(100);
      END_STATE();
    case 65:
      if (lookahead == 's') ADVANCE(101);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 67:
      if (lookahead == 'o') ADVANCE(102);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(103);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(104);
      END_STATE();
    case 70:
      if (lookahead == 'k') ADVANCE(105);
      END_STATE();
    case 71:
      if (lookahead == 'c') ADVANCE(106);
      END_STATE();
    case 72:
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_mut);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_nil);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_pub);
      END_STATE();
    case 77:
      if (lookahead == 'u') ADVANCE(109);
      END_STATE();
    case 78:
      if (lookahead == 'c') ADVANCE(110);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 80:
      if (lookahead == 'r') ADVANCE(112);
      END_STATE();
    case 81:
      if (lookahead == 'w') ADVANCE(113);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_sql);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(114);
      END_STATE();
    case 84:
      if (lookahead == 'u') ADVANCE(115);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(117);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(119);
      END_STATE();
    case 89:
      if (lookahead == 'a') ADVANCE(120);
      END_STATE();
    case 90:
      if (lookahead == 'a') ADVANCE(121);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(122);
      END_STATE();
    case 92:
      if (lookahead == 'r') ADVANCE(123);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(124);
      END_STATE();
    case 94:
      if (lookahead == 'k') ADVANCE(125);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_chan);
      END_STATE();
    case 96:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 97:
      if (lookahead == 'i') ADVANCE(127);
      END_STATE();
    case 98:
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(129);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 103:
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 104:
      if (lookahead == 'r') ADVANCE(131);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_lock);
      END_STATE();
    case 106:
      if (lookahead == 'h') ADVANCE(132);
      END_STATE();
    case 107:
      if (lookahead == 'l') ADVANCE(133);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_none);
      END_STATE();
    case 109:
      if (lookahead == 'r') ADVANCE(134);
      END_STATE();
    case 110:
      if (lookahead == 'k') ADVANCE(135);
      END_STATE();
    case 111:
      if (lookahead == 'c') ADVANCE(136);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(137);
      END_STATE();
    case 113:
      if (lookahead == 'n') ADVANCE(138);
      END_STATE();
    case 114:
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 115:
      if (lookahead == 'c') ADVANCE(140);
      END_STATE();
    case 116:
      if (lookahead == 'a') ADVANCE(141);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 119:
      if (lookahead == 'n') ADVANCE(142);
      END_STATE();
    case 120:
      if (lookahead == 'f') ADVANCE(143);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(144);
      END_STATE();
    case 122:
      if (lookahead == 'b') ADVANCE(145);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(146);
      END_STATE();
    case 124:
      if (lookahead == 'c') ADVANCE(147);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 127:
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_defer);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 130:
      if (lookahead == 't') ADVANCE(149);
      END_STATE();
    case 131:
      if (lookahead == 'f') ADVANCE(150);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 133:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 134:
      if (lookahead == 'n') ADVANCE(152);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_rlock);
      END_STATE();
    case 136:
      if (lookahead == 't') ADVANCE(153);
      END_STATE();
    case 137:
      if (lookahead == 'd') ADVANCE(154);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_spawn);
      END_STATE();
    case 139:
      if (lookahead == 'c') ADVANCE(155);
      END_STATE();
    case 140:
      if (lookahead == 't') ADVANCE(156);
      END_STATE();
    case 141:
      if (lookahead == 'd') ADVANCE(157);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 143:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 144:
      if (lookahead == 'i') ADVANCE(159);
      END_STATE();
    case 145:
      if (lookahead == 'a') ADVANCE(160);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_atomic);
      END_STATE();
    case 148:
      if (lookahead == 'u') ADVANCE(161);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 150:
      if (lookahead == 'a') ADVANCE(162);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_select);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_shared);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_thread);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_unsafe);
      END_STATE();
    case 159:
      if (lookahead == 'l') ADVANCE(163);
      END_STATE();
    case 160:
      if (lookahead == 'l') ADVANCE(164);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 162:
      if (lookahead == 'c') ADVANCE(166);
      END_STATE();
    case 163:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym___global);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 166:
      if (lookahead == 'e') ADVANCE(168);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 184},
  [2] = {.lex_state = 185},
  [3] = {.lex_state = 185},
  [4] = {.lex_state = 185},
  [5] = {.lex_state = 185},
  [6] = {.lex_state = 185},
  [7] = {.lex_state = 185},
  [8] = {.lex_state = 185},
  [9] = {.lex_state = 185},
  [10] = {.lex_state = 185},
  [11] = {.lex_state = 185},
  [12] = {.lex_state = 185},
  [13] = {.lex_state = 178},
  [14] = {.lex_state = 178},
  [15] = {.lex_state = 185},
  [16] = {.lex_state = 185},
  [17] = {.lex_state = 185},
  [18] = {.lex_state = 185},
  [19] = {.lex_state = 185},
  [20] = {.lex_state = 185},
  [21] = {.lex_state = 185},
  [22] = {.lex_state = 185},
  [23] = {.lex_state = 185},
  [24] = {.lex_state = 185},
  [25] = {.lex_state = 185},
  [26] = {.lex_state = 185},
  [27] = {.lex_state = 185},
  [28] = {.lex_state = 185},
  [29] = {.lex_state = 185},
  [30] = {.lex_state = 185},
  [31] = {.lex_state = 185},
  [32] = {.lex_state = 185},
  [33] = {.lex_state = 185},
  [34] = {.lex_state = 185},
  [35] = {.lex_state = 185},
  [36] = {.lex_state = 185},
  [37] = {.lex_state = 185},
  [38] = {.lex_state = 185},
  [39] = {.lex_state = 185},
  [40] = {.lex_state = 185},
  [41] = {.lex_state = 185},
  [42] = {.lex_state = 185},
  [43] = {.lex_state = 185},
  [44] = {.lex_state = 185},
  [45] = {.lex_state = 185},
  [46] = {.lex_state = 185},
  [47] = {.lex_state = 185},
  [48] = {.lex_state = 185},
  [49] = {.lex_state = 185},
  [50] = {.lex_state = 185},
  [51] = {.lex_state = 185},
  [52] = {.lex_state = 185},
  [53] = {.lex_state = 185},
  [54] = {.lex_state = 185},
  [55] = {.lex_state = 185},
  [56] = {.lex_state = 185},
  [57] = {.lex_state = 185},
  [58] = {.lex_state = 185},
  [59] = {.lex_state = 185},
  [60] = {.lex_state = 185},
  [61] = {.lex_state = 185},
  [62] = {.lex_state = 185},
  [63] = {.lex_state = 185},
  [64] = {.lex_state = 185},
  [65] = {.lex_state = 185},
  [66] = {.lex_state = 185},
  [67] = {.lex_state = 185},
  [68] = {.lex_state = 185},
  [69] = {.lex_state = 185},
  [70] = {.lex_state = 185},
  [71] = {.lex_state = 185},
  [72] = {.lex_state = 185},
  [73] = {.lex_state = 185},
  [74] = {.lex_state = 185},
  [75] = {.lex_state = 185},
  [76] = {.lex_state = 185},
  [77] = {.lex_state = 185},
  [78] = {.lex_state = 185},
  [79] = {.lex_state = 185},
  [80] = {.lex_state = 185},
  [81] = {.lex_state = 185},
  [82] = {.lex_state = 185},
  [83] = {.lex_state = 185},
  [84] = {.lex_state = 185},
  [85] = {.lex_state = 185},
  [86] = {.lex_state = 185},
  [87] = {.lex_state = 185},
  [88] = {.lex_state = 185},
  [89] = {.lex_state = 178},
  [90] = {.lex_state = 169},
  [91] = {.lex_state = 169},
  [92] = {.lex_state = 169},
  [93] = {.lex_state = 169},
  [94] = {.lex_state = 169},
  [95] = {.lex_state = 178},
  [96] = {.lex_state = 64},
  [97] = {.lex_state = 64},
  [98] = {.lex_state = 64},
  [99] = {.lex_state = 169},
  [100] = {.lex_state = 64},
  [101] = {.lex_state = 169},
  [102] = {.lex_state = 64},
  [103] = {.lex_state = 64},
  [104] = {.lex_state = 169},
  [105] = {.lex_state = 64},
  [106] = {.lex_state = 64},
  [107] = {.lex_state = 169},
  [108] = {.lex_state = 64},
  [109] = {.lex_state = 64},
  [110] = {.lex_state = 64},
  [111] = {.lex_state = 169},
  [112] = {.lex_state = 64},
  [113] = {.lex_state = 64},
  [114] = {.lex_state = 64},
  [115] = {.lex_state = 64},
  [116] = {.lex_state = 64},
  [117] = {.lex_state = 64},
  [118] = {.lex_state = 64},
  [119] = {.lex_state = 64},
  [120] = {.lex_state = 64},
  [121] = {.lex_state = 64},
  [122] = {.lex_state = 64},
  [123] = {.lex_state = 64},
  [124] = {.lex_state = 64},
  [125] = {.lex_state = 64},
  [126] = {.lex_state = 64},
  [127] = {.lex_state = 64},
  [128] = {.lex_state = 64},
  [129] = {.lex_state = 64},
  [130] = {.lex_state = 64},
  [131] = {.lex_state = 64},
  [132] = {.lex_state = 64},
  [133] = {.lex_state = 64},
  [134] = {.lex_state = 64},
  [135] = {.lex_state = 64},
  [136] = {.lex_state = 64},
  [137] = {.lex_state = 64},
  [138] = {.lex_state = 64},
  [139] = {.lex_state = 64},
  [140] = {.lex_state = 64},
  [141] = {.lex_state = 64},
  [142] = {.lex_state = 64},
  [143] = {.lex_state = 64},
  [144] = {.lex_state = 64},
  [145] = {.lex_state = 64},
  [146] = {.lex_state = 64},
  [147] = {.lex_state = 64},
  [148] = {.lex_state = 64},
  [149] = {.lex_state = 64},
  [150] = {.lex_state = 64},
  [151] = {.lex_state = 64},
  [152] = {.lex_state = 64},
  [153] = {.lex_state = 64},
  [154] = {.lex_state = 64},
  [155] = {.lex_state = 64},
  [156] = {.lex_state = 64},
  [157] = {.lex_state = 64},
  [158] = {.lex_state = 64},
  [159] = {.lex_state = 64},
  [160] = {.lex_state = 64},
  [161] = {.lex_state = 64},
  [162] = {.lex_state = 64},
  [163] = {.lex_state = 64},
  [164] = {.lex_state = 64},
  [165] = {.lex_state = 64},
  [166] = {.lex_state = 64},
  [167] = {.lex_state = 64},
  [168] = {.lex_state = 64},
  [169] = {.lex_state = 64},
  [170] = {.lex_state = 64},
  [171] = {.lex_state = 64},
  [172] = {.lex_state = 64},
  [173] = {.lex_state = 64},
  [174] = {.lex_state = 64},
  [175] = {.lex_state = 64},
  [176] = {.lex_state = 64},
  [177] = {.lex_state = 64},
  [178] = {.lex_state = 64},
  [179] = {.lex_state = 64},
  [180] = {.lex_state = 64},
  [181] = {.lex_state = 64},
  [182] = {.lex_state = 64},
  [183] = {.lex_state = 64},
  [184] = {.lex_state = 64},
  [185] = {.lex_state = 64},
  [186] = {.lex_state = 64},
  [187] = {.lex_state = 64},
  [188] = {.lex_state = 64},
  [189] = {.lex_state = 64},
  [190] = {.lex_state = 64},
  [191] = {.lex_state = 64},
  [192] = {.lex_state = 64},
  [193] = {.lex_state = 64},
  [194] = {.lex_state = 64},
  [195] = {.lex_state = 64},
  [196] = {.lex_state = 64},
  [197] = {.lex_state = 64},
  [198] = {.lex_state = 64},
  [199] = {.lex_state = 64},
  [200] = {.lex_state = 64},
  [201] = {.lex_state = 64},
  [202] = {.lex_state = 64},
  [203] = {.lex_state = 64},
  [204] = {.lex_state = 64},
  [205] = {.lex_state = 64},
  [206] = {.lex_state = 64},
  [207] = {.lex_state = 64},
  [208] = {.lex_state = 64},
  [209] = {.lex_state = 64},
  [210] = {.lex_state = 64},
  [211] = {.lex_state = 64},
  [212] = {.lex_state = 64},
  [213] = {.lex_state = 64},
  [214] = {.lex_state = 64},
  [215] = {.lex_state = 64},
  [216] = {.lex_state = 64},
  [217] = {.lex_state = 171},
  [218] = {.lex_state = 64},
  [219] = {.lex_state = 64},
  [220] = {.lex_state = 64},
  [221] = {.lex_state = 64},
  [222] = {.lex_state = 64},
  [223] = {.lex_state = 171},
  [224] = {.lex_state = 64},
  [225] = {.lex_state = 64},
  [226] = {.lex_state = 64},
  [227] = {.lex_state = 171},
  [228] = {.lex_state = 64},
  [229] = {.lex_state = 64},
  [230] = {.lex_state = 171},
  [231] = {.lex_state = 64},
  [232] = {.lex_state = 64},
  [233] = {.lex_state = 64},
  [234] = {.lex_state = 64},
  [235] = {.lex_state = 65},
  [236] = {.lex_state = 171},
  [237] = {.lex_state = 64},
  [238] = {.lex_state = 64},
  [239] = {.lex_state = 64},
  [240] = {.lex_state = 64},
  [241] = {.lex_state = 64},
  [242] = {.lex_state = 169},
  [243] = {.lex_state = 64},
  [244] = {.lex_state = 169},
  [245] = {.lex_state = 169},
  [246] = {.lex_state = 169},
  [247] = {.lex_state = 169},
  [248] = {.lex_state = 169},
  [249] = {.lex_state = 169},
  [250] = {.lex_state = 169},
  [251] = {.lex_state = 169},
  [252] = {.lex_state = 169},
  [253] = {.lex_state = 169},
  [254] = {.lex_state = 169},
  [255] = {.lex_state = 169},
  [256] = {.lex_state = 169},
  [257] = {.lex_state = 169},
  [258] = {.lex_state = 169},
  [259] = {.lex_state = 173},
  [260] = {.lex_state = 64},
  [261] = {.lex_state = 173},
  [262] = {.lex_state = 64},
  [263] = {.lex_state = 64},
  [264] = {.lex_state = 64},
  [265] = {.lex_state = 64},
  [266] = {.lex_state = 64},
  [267] = {.lex_state = 64},
  [268] = {.lex_state = 64},
  [269] = {.lex_state = 64},
  [270] = {.lex_state = 64},
  [271] = {.lex_state = 173},
  [272] = {.lex_state = 64},
  [273] = {.lex_state = 64},
  [274] = {.lex_state = 64},
  [275] = {.lex_state = 64},
  [276] = {.lex_state = 64},
  [277] = {.lex_state = 64},
  [278] = {.lex_state = 64},
  [279] = {.lex_state = 64},
  [280] = {.lex_state = 64},
  [281] = {.lex_state = 169},
  [282] = {.lex_state = 64},
  [283] = {.lex_state = 64},
  [284] = {.lex_state = 64},
  [285] = {.lex_state = 64},
  [286] = {.lex_state = 64},
  [287] = {.lex_state = 64},
  [288] = {.lex_state = 169},
  [289] = {.lex_state = 64},
  [290] = {.lex_state = 169},
  [291] = {.lex_state = 169},
  [292] = {.lex_state = 64},
  [293] = {.lex_state = 64},
  [294] = {.lex_state = 64},
  [295] = {.lex_state = 64},
  [296] = {.lex_state = 64},
  [297] = {.lex_state = 64},
  [298] = {.lex_state = 64},
  [299] = {.lex_state = 64},
  [300] = {.lex_state = 64},
  [301] = {.lex_state = 64},
  [302] = {.lex_state = 64},
  [303] = {.lex_state = 64},
  [304] = {.lex_state = 64},
  [305] = {.lex_state = 64},
  [306] = {.lex_state = 64},
  [307] = {.lex_state = 64},
  [308] = {.lex_state = 64},
  [309] = {.lex_state = 64},
  [310] = {.lex_state = 64},
  [311] = {.lex_state = 64},
  [312] = {.lex_state = 173},
  [313] = {.lex_state = 169},
  [314] = {.lex_state = 64},
  [315] = {.lex_state = 64},
  [316] = {.lex_state = 64},
  [317] = {.lex_state = 64},
  [318] = {.lex_state = 64},
  [319] = {.lex_state = 64},
  [320] = {.lex_state = 64},
  [321] = {.lex_state = 64},
  [322] = {.lex_state = 64},
  [323] = {.lex_state = 64},
  [324] = {.lex_state = 64},
  [325] = {.lex_state = 64},
  [326] = {.lex_state = 64},
  [327] = {.lex_state = 64},
  [328] = {.lex_state = 64},
  [329] = {.lex_state = 64},
  [330] = {.lex_state = 64},
  [331] = {.lex_state = 64},
  [332] = {.lex_state = 64},
  [333] = {.lex_state = 169},
  [334] = {.lex_state = 169},
  [335] = {.lex_state = 64},
  [336] = {.lex_state = 169},
  [337] = {.lex_state = 65},
  [338] = {.lex_state = 65},
  [339] = {.lex_state = 65},
  [340] = {.lex_state = 64},
  [341] = {.lex_state = 169},
  [342] = {.lex_state = 169},
  [343] = {.lex_state = 64},
  [344] = {.lex_state = 64},
  [345] = {.lex_state = 64},
  [346] = {.lex_state = 64},
  [347] = {.lex_state = 65},
  [348] = {.lex_state = 169},
  [349] = {.lex_state = 64},
  [350] = {.lex_state = 65},
  [351] = {.lex_state = 169},
  [352] = {.lex_state = 64},
  [353] = {.lex_state = 64},
  [354] = {.lex_state = 65},
  [355] = {.lex_state = 65},
  [356] = {.lex_state = 64},
  [357] = {.lex_state = 169},
  [358] = {.lex_state = 169},
  [359] = {.lex_state = 169},
  [360] = {.lex_state = 169},
  [361] = {.lex_state = 64},
  [362] = {.lex_state = 65},
  [363] = {.lex_state = 65},
  [364] = {.lex_state = 65},
  [365] = {.lex_state = 65},
  [366] = {.lex_state = 64},
  [367] = {.lex_state = 169},
  [368] = {.lex_state = 64},
  [369] = {.lex_state = 65},
  [370] = {.lex_state = 169},
  [371] = {.lex_state = 64},
  [372] = {.lex_state = 64},
  [373] = {.lex_state = 64},
  [374] = {.lex_state = 64},
  [375] = {.lex_state = 64},
  [376] = {.lex_state = 65},
  [377] = {.lex_state = 65},
  [378] = {.lex_state = 65},
  [379] = {.lex_state = 169},
  [380] = {.lex_state = 169},
  [381] = {.lex_state = 64},
  [382] = {.lex_state = 64},
  [383] = {.lex_state = 169},
  [384] = {.lex_state = 64},
  [385] = {.lex_state = 64},
  [386] = {.lex_state = 169},
  [387] = {.lex_state = 169},
  [388] = {.lex_state = 169},
  [389] = {.lex_state = 169},
  [390] = {.lex_state = 169},
  [391] = {.lex_state = 64},
  [392] = {.lex_state = 64},
  [393] = {.lex_state = 64},
  [394] = {.lex_state = 64},
  [395] = {.lex_state = 169},
  [396] = {.lex_state = 64},
  [397] = {.lex_state = 64},
  [398] = {.lex_state = 65},
  [399] = {.lex_state = 65},
  [400] = {.lex_state = 65},
  [401] = {.lex_state = 169},
  [402] = {.lex_state = 64},
  [403] = {.lex_state = 169},
  [404] = {.lex_state = 169},
  [405] = {.lex_state = 169},
  [406] = {.lex_state = 64},
  [407] = {.lex_state = 169},
  [408] = {.lex_state = 169},
  [409] = {.lex_state = 169},
  [410] = {.lex_state = 65},
  [411] = {.lex_state = 64},
  [412] = {.lex_state = 169},
  [413] = {.lex_state = 169},
  [414] = {.lex_state = 169},
  [415] = {.lex_state = 64},
  [416] = {.lex_state = 64},
  [417] = {.lex_state = 64},
  [418] = {.lex_state = 64},
  [419] = {.lex_state = 64},
  [420] = {.lex_state = 64},
  [421] = {.lex_state = 169},
  [422] = {.lex_state = 64},
  [423] = {.lex_state = 64},
  [424] = {.lex_state = 169},
  [425] = {.lex_state = 169},
  [426] = {.lex_state = 169},
  [427] = {.lex_state = 169},
  [428] = {.lex_state = 169},
  [429] = {.lex_state = 169},
  [430] = {.lex_state = 64},
  [431] = {.lex_state = 169},
  [432] = {.lex_state = 65},
  [433] = {.lex_state = 65},
  [434] = {.lex_state = 169},
  [435] = {.lex_state = 169},
  [436] = {.lex_state = 169},
  [437] = {.lex_state = 64},
  [438] = {.lex_state = 169},
  [439] = {.lex_state = 64},
  [440] = {.lex_state = 64},
  [441] = {.lex_state = 169},
  [442] = {.lex_state = 169},
  [443] = {.lex_state = 169},
  [444] = {.lex_state = 64},
  [445] = {.lex_state = 169},
  [446] = {.lex_state = 169},
  [447] = {.lex_state = 169},
  [448] = {.lex_state = 169},
  [449] = {.lex_state = 64},
  [450] = {.lex_state = 169},
  [451] = {.lex_state = 64},
  [452] = {.lex_state = 169},
  [453] = {.lex_state = 169},
  [454] = {.lex_state = 169},
  [455] = {.lex_state = 169},
  [456] = {.lex_state = 169},
  [457] = {.lex_state = 169},
  [458] = {.lex_state = 65},
  [459] = {.lex_state = 64},
  [460] = {.lex_state = 169},
  [461] = {.lex_state = 169},
  [462] = {.lex_state = 64},
  [463] = {.lex_state = 169},
  [464] = {.lex_state = 64},
  [465] = {.lex_state = 64},
  [466] = {.lex_state = 169},
  [467] = {.lex_state = 169},
  [468] = {.lex_state = 169},
  [469] = {.lex_state = 169},
  [470] = {.lex_state = 169},
  [471] = {.lex_state = 169},
  [472] = {.lex_state = 64},
  [473] = {.lex_state = 169},
  [474] = {.lex_state = 169},
  [475] = {.lex_state = 169},
  [476] = {.lex_state = 64},
  [477] = {.lex_state = 169},
  [478] = {.lex_state = 64},
  [479] = {.lex_state = 169},
  [480] = {.lex_state = 169},
  [481] = {.lex_state = 169},
  [482] = {.lex_state = 169},
  [483] = {.lex_state = 169},
  [484] = {.lex_state = 169},
  [485] = {.lex_state = 169},
  [486] = {.lex_state = 64},
  [487] = {.lex_state = 64},
  [488] = {.lex_state = 64},
  [489] = {.lex_state = 64},
  [490] = {.lex_state = 169},
  [491] = {.lex_state = 64},
  [492] = {.lex_state = 64},
  [493] = {.lex_state = 169},
  [494] = {.lex_state = 169},
  [495] = {.lex_state = 64},
  [496] = {.lex_state = 65},
  [497] = {.lex_state = 169},
  [498] = {.lex_state = 64},
  [499] = {.lex_state = 169},
  [500] = {.lex_state = 65},
  [501] = {.lex_state = 169},
  [502] = {.lex_state = 169},
  [503] = {.lex_state = 169},
  [504] = {.lex_state = 64},
  [505] = {.lex_state = 169},
  [506] = {.lex_state = 169},
  [507] = {.lex_state = 64},
  [508] = {.lex_state = 169},
  [509] = {.lex_state = 64},
  [510] = {.lex_state = 169},
  [511] = {.lex_state = 169},
  [512] = {.lex_state = 169},
  [513] = {.lex_state = 169},
  [514] = {.lex_state = 169},
  [515] = {.lex_state = 169},
  [516] = {.lex_state = 64},
  [517] = {.lex_state = 169},
  [518] = {.lex_state = 64},
  [519] = {.lex_state = 169},
  [520] = {.lex_state = 169},
  [521] = {.lex_state = 64},
  [522] = {.lex_state = 169},
  [523] = {.lex_state = 169},
  [524] = {.lex_state = 169},
  [525] = {.lex_state = 64},
  [526] = {.lex_state = 169},
  [527] = {.lex_state = 64},
  [528] = {.lex_state = 169},
  [529] = {.lex_state = 169},
  [530] = {.lex_state = 64},
  [531] = {.lex_state = 169},
  [532] = {.lex_state = 64},
  [533] = {.lex_state = 64},
  [534] = {.lex_state = 64},
  [535] = {.lex_state = 64},
  [536] = {.lex_state = 64},
  [537] = {.lex_state = 64},
  [538] = {.lex_state = 64},
  [539] = {.lex_state = 64},
  [540] = {.lex_state = 64},
  [541] = {.lex_state = 64},
  [542] = {.lex_state = 171},
  [543] = {.lex_state = 64},
  [544] = {.lex_state = 171},
  [545] = {.lex_state = 64},
  [546] = {.lex_state = 64},
  [547] = {.lex_state = 171},
  [548] = {.lex_state = 171},
  [549] = {.lex_state = 64},
  [550] = {.lex_state = 64},
  [551] = {.lex_state = 64},
  [552] = {.lex_state = 64},
  [553] = {.lex_state = 64},
  [554] = {.lex_state = 64},
  [555] = {.lex_state = 64},
  [556] = {.lex_state = 64},
  [557] = {.lex_state = 64},
  [558] = {.lex_state = 64},
  [559] = {.lex_state = 64},
  [560] = {.lex_state = 64},
  [561] = {.lex_state = 64},
  [562] = {.lex_state = 64},
  [563] = {.lex_state = 64},
  [564] = {.lex_state = 64},
  [565] = {.lex_state = 64},
  [566] = {.lex_state = 171},
  [567] = {.lex_state = 64},
  [568] = {.lex_state = 64},
  [569] = {.lex_state = 64},
  [570] = {.lex_state = 64},
  [571] = {.lex_state = 64},
  [572] = {.lex_state = 64},
  [573] = {.lex_state = 64},
  [574] = {.lex_state = 64},
  [575] = {.lex_state = 64},
  [576] = {.lex_state = 64},
  [577] = {.lex_state = 64},
  [578] = {.lex_state = 64},
  [579] = {.lex_state = 64},
  [580] = {.lex_state = 64},
  [581] = {.lex_state = 64},
  [582] = {.lex_state = 64},
  [583] = {.lex_state = 64},
  [584] = {.lex_state = 64},
  [585] = {.lex_state = 64},
  [586] = {.lex_state = 64},
  [587] = {.lex_state = 64},
  [588] = {.lex_state = 64},
  [589] = {.lex_state = 64},
  [590] = {.lex_state = 64},
  [591] = {.lex_state = 64},
  [592] = {.lex_state = 64},
  [593] = {.lex_state = 64},
  [594] = {.lex_state = 64},
  [595] = {.lex_state = 64},
  [596] = {.lex_state = 64},
  [597] = {.lex_state = 64},
  [598] = {.lex_state = 64},
  [599] = {.lex_state = 64},
  [600] = {.lex_state = 64},
  [601] = {.lex_state = 64},
  [602] = {.lex_state = 64},
  [603] = {.lex_state = 64},
  [604] = {.lex_state = 64},
  [605] = {.lex_state = 64},
  [606] = {.lex_state = 64},
  [607] = {.lex_state = 64},
  [608] = {.lex_state = 64},
  [609] = {.lex_state = 64},
  [610] = {.lex_state = 64},
  [611] = {.lex_state = 64},
  [612] = {.lex_state = 64},
  [613] = {.lex_state = 64},
  [614] = {.lex_state = 64},
  [615] = {.lex_state = 64},
  [616] = {.lex_state = 64},
  [617] = {.lex_state = 64},
  [618] = {.lex_state = 64},
  [619] = {.lex_state = 64},
  [620] = {.lex_state = 64},
  [621] = {.lex_state = 64},
  [622] = {.lex_state = 64},
  [623] = {.lex_state = 64},
  [624] = {.lex_state = 64},
  [625] = {.lex_state = 64},
  [626] = {.lex_state = 64},
  [627] = {.lex_state = 64},
  [628] = {.lex_state = 64},
  [629] = {.lex_state = 64},
  [630] = {.lex_state = 64},
  [631] = {.lex_state = 64},
  [632] = {.lex_state = 64},
  [633] = {.lex_state = 64},
  [634] = {.lex_state = 64},
  [635] = {.lex_state = 64},
  [636] = {.lex_state = 64},
  [637] = {.lex_state = 64},
  [638] = {.lex_state = 64},
  [639] = {.lex_state = 64},
  [640] = {.lex_state = 64},
  [641] = {.lex_state = 64},
  [642] = {.lex_state = 64},
  [643] = {.lex_state = 64},
  [644] = {.lex_state = 64},
  [645] = {.lex_state = 64},
  [646] = {.lex_state = 64},
  [647] = {.lex_state = 64},
  [648] = {.lex_state = 64},
  [649] = {.lex_state = 64},
  [650] = {.lex_state = 64},
  [651] = {.lex_state = 64},
  [652] = {.lex_state = 64},
  [653] = {.lex_state = 64},
  [654] = {.lex_state = 64},
  [655] = {.lex_state = 64},
  [656] = {.lex_state = 64},
  [657] = {.lex_state = 64},
  [658] = {.lex_state = 64},
  [659] = {.lex_state = 64},
  [660] = {.lex_state = 64},
  [661] = {.lex_state = 64},
  [662] = {.lex_state = 64},
  [663] = {.lex_state = 64},
  [664] = {.lex_state = 64},
  [665] = {.lex_state = 64},
  [666] = {.lex_state = 64},
  [667] = {.lex_state = 64},
  [668] = {.lex_state = 64},
  [669] = {.lex_state = 64},
  [670] = {.lex_state = 64},
  [671] = {.lex_state = 64},
  [672] = {.lex_state = 64},
  [673] = {.lex_state = 64},
  [674] = {.lex_state = 64},
  [675] = {.lex_state = 64},
  [676] = {.lex_state = 64},
  [677] = {.lex_state = 64},
  [678] = {.lex_state = 64},
  [679] = {.lex_state = 64},
  [680] = {.lex_state = 64},
  [681] = {.lex_state = 64},
  [682] = {.lex_state = 64},
  [683] = {.lex_state = 64},
  [684] = {.lex_state = 64},
  [685] = {.lex_state = 64},
  [686] = {.lex_state = 64},
  [687] = {.lex_state = 64},
  [688] = {.lex_state = 64},
  [689] = {.lex_state = 64},
  [690] = {.lex_state = 64},
  [691] = {.lex_state = 64},
  [692] = {.lex_state = 64},
  [693] = {.lex_state = 64},
  [694] = {.lex_state = 64},
  [695] = {.lex_state = 64},
  [696] = {.lex_state = 64},
  [697] = {.lex_state = 64},
  [698] = {.lex_state = 64},
  [699] = {.lex_state = 64},
  [700] = {.lex_state = 64},
  [701] = {.lex_state = 64},
  [702] = {.lex_state = 64},
  [703] = {.lex_state = 64},
  [704] = {.lex_state = 64},
  [705] = {.lex_state = 64},
  [706] = {.lex_state = 64},
  [707] = {.lex_state = 64},
  [708] = {.lex_state = 64},
  [709] = {.lex_state = 64},
  [710] = {.lex_state = 64},
  [711] = {.lex_state = 64},
  [712] = {.lex_state = 64},
  [713] = {.lex_state = 64},
  [714] = {.lex_state = 64},
  [715] = {.lex_state = 64},
  [716] = {.lex_state = 64},
  [717] = {.lex_state = 64},
  [718] = {.lex_state = 64},
  [719] = {.lex_state = 64},
  [720] = {.lex_state = 64},
  [721] = {.lex_state = 64},
  [722] = {.lex_state = 64},
  [723] = {.lex_state = 64},
  [724] = {.lex_state = 64},
  [725] = {.lex_state = 64},
  [726] = {.lex_state = 64},
  [727] = {.lex_state = 64},
  [728] = {.lex_state = 64},
  [729] = {.lex_state = 64},
  [730] = {.lex_state = 64},
  [731] = {.lex_state = 64},
  [732] = {.lex_state = 64},
  [733] = {.lex_state = 64},
  [734] = {.lex_state = 64},
  [735] = {.lex_state = 64},
  [736] = {.lex_state = 64},
  [737] = {.lex_state = 64},
  [738] = {.lex_state = 64},
  [739] = {.lex_state = 64},
  [740] = {.lex_state = 64},
  [741] = {.lex_state = 64},
  [742] = {.lex_state = 64},
  [743] = {.lex_state = 64},
  [744] = {.lex_state = 64},
  [745] = {.lex_state = 64},
  [746] = {.lex_state = 64},
  [747] = {.lex_state = 64},
  [748] = {.lex_state = 64},
  [749] = {.lex_state = 64},
  [750] = {.lex_state = 64},
  [751] = {.lex_state = 64},
  [752] = {.lex_state = 64},
  [753] = {.lex_state = 64},
  [754] = {.lex_state = 64},
  [755] = {.lex_state = 64},
  [756] = {.lex_state = 64},
  [757] = {.lex_state = 64},
  [758] = {.lex_state = 64},
  [759] = {.lex_state = 64},
  [760] = {.lex_state = 64},
  [761] = {.lex_state = 64},
  [762] = {.lex_state = 64},
  [763] = {.lex_state = 64},
  [764] = {.lex_state = 64},
  [765] = {.lex_state = 64},
  [766] = {.lex_state = 64},
  [767] = {.lex_state = 64},
  [768] = {.lex_state = 64},
  [769] = {.lex_state = 64},
  [770] = {.lex_state = 64},
  [771] = {.lex_state = 64},
  [772] = {.lex_state = 64},
  [773] = {.lex_state = 64},
  [774] = {.lex_state = 64},
  [775] = {.lex_state = 64},
  [776] = {.lex_state = 64},
  [777] = {.lex_state = 64},
  [778] = {.lex_state = 64},
  [779] = {.lex_state = 64},
  [780] = {.lex_state = 64},
  [781] = {.lex_state = 64},
  [782] = {.lex_state = 64},
  [783] = {.lex_state = 64},
  [784] = {.lex_state = 64},
  [785] = {.lex_state = 64},
  [786] = {.lex_state = 64},
  [787] = {.lex_state = 64},
  [788] = {.lex_state = 64},
  [789] = {.lex_state = 64},
  [790] = {.lex_state = 64},
  [791] = {.lex_state = 64},
  [792] = {.lex_state = 64},
  [793] = {.lex_state = 64},
  [794] = {.lex_state = 64},
  [795] = {.lex_state = 64},
  [796] = {.lex_state = 64},
  [797] = {.lex_state = 64},
  [798] = {.lex_state = 64},
  [799] = {.lex_state = 64},
  [800] = {.lex_state = 64},
  [801] = {.lex_state = 64},
  [802] = {.lex_state = 64},
  [803] = {.lex_state = 64},
  [804] = {.lex_state = 64},
  [805] = {.lex_state = 64},
  [806] = {.lex_state = 64},
  [807] = {.lex_state = 64},
  [808] = {.lex_state = 64},
  [809] = {.lex_state = 64},
  [810] = {.lex_state = 64},
  [811] = {.lex_state = 64},
  [812] = {.lex_state = 64},
  [813] = {.lex_state = 64},
  [814] = {.lex_state = 64},
  [815] = {.lex_state = 64},
  [816] = {.lex_state = 64},
  [817] = {.lex_state = 64},
  [818] = {.lex_state = 64},
  [819] = {.lex_state = 64},
  [820] = {.lex_state = 64},
  [821] = {.lex_state = 64},
  [822] = {.lex_state = 64},
  [823] = {.lex_state = 64},
  [824] = {.lex_state = 64},
  [825] = {.lex_state = 64},
  [826] = {.lex_state = 64},
  [827] = {.lex_state = 64},
  [828] = {.lex_state = 64},
  [829] = {.lex_state = 64},
  [830] = {.lex_state = 64},
  [831] = {.lex_state = 64},
  [832] = {.lex_state = 64},
  [833] = {.lex_state = 64},
  [834] = {.lex_state = 64},
  [835] = {.lex_state = 64},
  [836] = {.lex_state = 64},
  [837] = {.lex_state = 64},
  [838] = {.lex_state = 64},
  [839] = {.lex_state = 64},
  [840] = {.lex_state = 64},
  [841] = {.lex_state = 64},
  [842] = {.lex_state = 64},
  [843] = {.lex_state = 64},
  [844] = {.lex_state = 64},
  [845] = {.lex_state = 64},
  [846] = {.lex_state = 64},
  [847] = {.lex_state = 64},
  [848] = {.lex_state = 64},
  [849] = {.lex_state = 64},
  [850] = {.lex_state = 64},
  [851] = {.lex_state = 64},
  [852] = {.lex_state = 64},
  [853] = {.lex_state = 64},
  [854] = {.lex_state = 64},
  [855] = {.lex_state = 64},
  [856] = {.lex_state = 64},
  [857] = {.lex_state = 64},
  [858] = {.lex_state = 64},
  [859] = {.lex_state = 64},
  [860] = {.lex_state = 64},
  [861] = {.lex_state = 64},
  [862] = {.lex_state = 64},
  [863] = {.lex_state = 64},
  [864] = {.lex_state = 64},
  [865] = {.lex_state = 64},
  [866] = {.lex_state = 64},
  [867] = {.lex_state = 64},
  [868] = {.lex_state = 64},
  [869] = {.lex_state = 64},
  [870] = {.lex_state = 64},
  [871] = {.lex_state = 64},
  [872] = {.lex_state = 64},
  [873] = {.lex_state = 64},
  [874] = {.lex_state = 64},
  [875] = {.lex_state = 64},
  [876] = {.lex_state = 64},
  [877] = {.lex_state = 64},
  [878] = {.lex_state = 64},
  [879] = {.lex_state = 64},
  [880] = {.lex_state = 64},
  [881] = {.lex_state = 64},
  [882] = {.lex_state = 64},
  [883] = {.lex_state = 64},
  [884] = {.lex_state = 64},
  [885] = {.lex_state = 64},
  [886] = {.lex_state = 64},
  [887] = {.lex_state = 64},
  [888] = {.lex_state = 64},
  [889] = {.lex_state = 64},
  [890] = {.lex_state = 64},
  [891] = {.lex_state = 64},
  [892] = {.lex_state = 64},
  [893] = {.lex_state = 64},
  [894] = {.lex_state = 169},
  [895] = {.lex_state = 64},
  [896] = {.lex_state = 64},
  [897] = {.lex_state = 64},
  [898] = {.lex_state = 64},
  [899] = {.lex_state = 64},
  [900] = {.lex_state = 64},
  [901] = {.lex_state = 64},
  [902] = {.lex_state = 64},
  [903] = {.lex_state = 64},
  [904] = {.lex_state = 64},
  [905] = {.lex_state = 64},
  [906] = {.lex_state = 64},
  [907] = {.lex_state = 64},
  [908] = {.lex_state = 64},
  [909] = {.lex_state = 64},
  [910] = {.lex_state = 64},
  [911] = {.lex_state = 64},
  [912] = {.lex_state = 64},
  [913] = {.lex_state = 64},
  [914] = {.lex_state = 64},
  [915] = {.lex_state = 64},
  [916] = {.lex_state = 64},
  [917] = {.lex_state = 64},
  [918] = {.lex_state = 64},
  [919] = {.lex_state = 64},
  [920] = {.lex_state = 64},
  [921] = {.lex_state = 64},
  [922] = {.lex_state = 64},
  [923] = {.lex_state = 64},
  [924] = {.lex_state = 64},
  [925] = {.lex_state = 64},
  [926] = {.lex_state = 64},
  [927] = {.lex_state = 64},
  [928] = {.lex_state = 64},
  [929] = {.lex_state = 64},
  [930] = {.lex_state = 64},
  [931] = {.lex_state = 64},
  [932] = {.lex_state = 64},
  [933] = {.lex_state = 64},
  [934] = {.lex_state = 64},
  [935] = {.lex_state = 64},
  [936] = {.lex_state = 64},
  [937] = {.lex_state = 64},
  [938] = {.lex_state = 64},
  [939] = {.lex_state = 64},
  [940] = {.lex_state = 64},
  [941] = {.lex_state = 64},
  [942] = {.lex_state = 64},
  [943] = {.lex_state = 64},
  [944] = {.lex_state = 64},
  [945] = {.lex_state = 64},
  [946] = {.lex_state = 64},
  [947] = {.lex_state = 64},
  [948] = {.lex_state = 64},
  [949] = {.lex_state = 64},
  [950] = {.lex_state = 64},
  [951] = {.lex_state = 64},
  [952] = {.lex_state = 64},
  [953] = {.lex_state = 64},
  [954] = {.lex_state = 64},
  [955] = {.lex_state = 64},
  [956] = {.lex_state = 64},
  [957] = {.lex_state = 64},
  [958] = {.lex_state = 64},
  [959] = {.lex_state = 64},
  [960] = {.lex_state = 64},
  [961] = {.lex_state = 64},
  [962] = {.lex_state = 64},
  [963] = {.lex_state = 64},
  [964] = {.lex_state = 64},
  [965] = {.lex_state = 64},
  [966] = {.lex_state = 64},
  [967] = {.lex_state = 64},
  [968] = {.lex_state = 64},
  [969] = {.lex_state = 64},
  [970] = {.lex_state = 64},
  [971] = {.lex_state = 64},
  [972] = {.lex_state = 64},
  [973] = {.lex_state = 64},
  [974] = {.lex_state = 64},
  [975] = {.lex_state = 64},
  [976] = {.lex_state = 64},
  [977] = {.lex_state = 64},
  [978] = {.lex_state = 64},
  [979] = {.lex_state = 64},
  [980] = {.lex_state = 64},
  [981] = {.lex_state = 64},
  [982] = {.lex_state = 169},
  [983] = {.lex_state = 169},
  [984] = {.lex_state = 169},
  [985] = {.lex_state = 169},
  [986] = {.lex_state = 169},
  [987] = {.lex_state = 169},
  [988] = {.lex_state = 169},
  [989] = {.lex_state = 169},
  [990] = {.lex_state = 169},
  [991] = {.lex_state = 169},
  [992] = {.lex_state = 169},
  [993] = {.lex_state = 169},
  [994] = {.lex_state = 169},
  [995] = {.lex_state = 169},
  [996] = {.lex_state = 169},
  [997] = {.lex_state = 169},
  [998] = {.lex_state = 173},
  [999] = {.lex_state = 173},
  [1000] = {.lex_state = 169},
  [1001] = {.lex_state = 173},
  [1002] = {.lex_state = 173},
  [1003] = {.lex_state = 169},
  [1004] = {.lex_state = 169},
  [1005] = {.lex_state = 169},
  [1006] = {.lex_state = 169},
  [1007] = {.lex_state = 169},
  [1008] = {.lex_state = 169},
  [1009] = {.lex_state = 169},
  [1010] = {.lex_state = 169},
  [1011] = {.lex_state = 169},
  [1012] = {.lex_state = 169},
  [1013] = {.lex_state = 169},
  [1014] = {.lex_state = 169},
  [1015] = {.lex_state = 169},
  [1016] = {.lex_state = 169},
  [1017] = {.lex_state = 169},
  [1018] = {.lex_state = 169},
  [1019] = {.lex_state = 169},
  [1020] = {.lex_state = 169},
  [1021] = {.lex_state = 169},
  [1022] = {.lex_state = 169},
  [1023] = {.lex_state = 169},
  [1024] = {.lex_state = 169},
  [1025] = {.lex_state = 169},
  [1026] = {.lex_state = 169},
  [1027] = {.lex_state = 169},
  [1028] = {.lex_state = 169},
  [1029] = {.lex_state = 169},
  [1030] = {.lex_state = 169},
  [1031] = {.lex_state = 169},
  [1032] = {.lex_state = 169},
  [1033] = {.lex_state = 169},
  [1034] = {.lex_state = 169},
  [1035] = {.lex_state = 169},
  [1036] = {.lex_state = 169},
  [1037] = {.lex_state = 169},
  [1038] = {.lex_state = 169},
  [1039] = {.lex_state = 169},
  [1040] = {.lex_state = 169},
  [1041] = {.lex_state = 169},
  [1042] = {.lex_state = 169},
  [1043] = {.lex_state = 169},
  [1044] = {.lex_state = 169},
  [1045] = {.lex_state = 169},
  [1046] = {.lex_state = 169},
  [1047] = {.lex_state = 169},
  [1048] = {.lex_state = 169},
  [1049] = {.lex_state = 169},
  [1050] = {.lex_state = 169},
  [1051] = {.lex_state = 169},
  [1052] = {.lex_state = 169},
  [1053] = {.lex_state = 169},
  [1054] = {.lex_state = 169},
  [1055] = {.lex_state = 169},
  [1056] = {.lex_state = 169},
  [1057] = {.lex_state = 169},
  [1058] = {.lex_state = 169},
  [1059] = {.lex_state = 169},
  [1060] = {.lex_state = 169},
  [1061] = {.lex_state = 169},
  [1062] = {.lex_state = 169},
  [1063] = {.lex_state = 169},
  [1064] = {.lex_state = 169},
  [1065] = {.lex_state = 169},
  [1066] = {.lex_state = 169},
  [1067] = {.lex_state = 169},
  [1068] = {.lex_state = 169},
  [1069] = {.lex_state = 169},
  [1070] = {.lex_state = 169},
  [1071] = {.lex_state = 169},
  [1072] = {.lex_state = 169},
  [1073] = {.lex_state = 169},
  [1074] = {.lex_state = 169},
  [1075] = {.lex_state = 169},
  [1076] = {.lex_state = 169},
  [1077] = {.lex_state = 169},
  [1078] = {.lex_state = 169},
  [1079] = {.lex_state = 169},
  [1080] = {.lex_state = 169},
  [1081] = {.lex_state = 169},
  [1082] = {.lex_state = 169},
  [1083] = {.lex_state = 169},
  [1084] = {.lex_state = 169},
  [1085] = {.lex_state = 169},
  [1086] = {.lex_state = 169},
  [1087] = {.lex_state = 169},
  [1088] = {.lex_state = 169},
  [1089] = {.lex_state = 169},
  [1090] = {.lex_state = 169},
  [1091] = {.lex_state = 169},
  [1092] = {.lex_state = 169},
  [1093] = {.lex_state = 169},
  [1094] = {.lex_state = 169},
  [1095] = {.lex_state = 169},
  [1096] = {.lex_state = 169},
  [1097] = {.lex_state = 169},
  [1098] = {.lex_state = 169},
  [1099] = {.lex_state = 169},
  [1100] = {.lex_state = 169},
  [1101] = {.lex_state = 169},
  [1102] = {.lex_state = 169},
  [1103] = {.lex_state = 169},
  [1104] = {.lex_state = 169},
  [1105] = {.lex_state = 169},
  [1106] = {.lex_state = 169},
  [1107] = {.lex_state = 169},
  [1108] = {.lex_state = 169},
  [1109] = {.lex_state = 169},
  [1110] = {.lex_state = 169},
  [1111] = {.lex_state = 169},
  [1112] = {.lex_state = 2},
  [1113] = {.lex_state = 169},
  [1114] = {.lex_state = 2},
  [1115] = {.lex_state = 2},
  [1116] = {.lex_state = 2},
  [1117] = {.lex_state = 2},
  [1118] = {.lex_state = 2},
  [1119] = {.lex_state = 171},
  [1120] = {.lex_state = 171},
  [1121] = {.lex_state = 171},
  [1122] = {.lex_state = 171},
  [1123] = {.lex_state = 171},
  [1124] = {.lex_state = 171},
  [1125] = {.lex_state = 171},
  [1126] = {.lex_state = 171},
  [1127] = {.lex_state = 171},
  [1128] = {.lex_state = 171},
  [1129] = {.lex_state = 171},
  [1130] = {.lex_state = 171},
  [1131] = {.lex_state = 171},
  [1132] = {.lex_state = 171},
  [1133] = {.lex_state = 171},
  [1134] = {.lex_state = 171},
  [1135] = {.lex_state = 171},
  [1136] = {.lex_state = 171},
  [1137] = {.lex_state = 171},
  [1138] = {.lex_state = 171},
  [1139] = {.lex_state = 171},
  [1140] = {.lex_state = 171},
  [1141] = {.lex_state = 171},
  [1142] = {.lex_state = 171},
  [1143] = {.lex_state = 171},
  [1144] = {.lex_state = 171},
  [1145] = {.lex_state = 171},
  [1146] = {.lex_state = 22},
  [1147] = {.lex_state = 22},
  [1148] = {.lex_state = 171},
  [1149] = {.lex_state = 22},
  [1150] = {.lex_state = 171},
  [1151] = {.lex_state = 175},
  [1152] = {.lex_state = 22},
  [1153] = {.lex_state = 175},
  [1154] = {.lex_state = 171},
  [1155] = {.lex_state = 175},
  [1156] = {.lex_state = 22},
  [1157] = {.lex_state = 175},
  [1158] = {.lex_state = 171},
  [1159] = {.lex_state = 171},
  [1160] = {.lex_state = 171},
  [1161] = {.lex_state = 171},
  [1162] = {.lex_state = 171},
  [1163] = {.lex_state = 171},
  [1164] = {.lex_state = 171},
  [1165] = {.lex_state = 171},
  [1166] = {.lex_state = 171},
  [1167] = {.lex_state = 171},
  [1168] = {.lex_state = 171},
  [1169] = {.lex_state = 171},
  [1170] = {.lex_state = 171},
  [1171] = {.lex_state = 171},
  [1172] = {.lex_state = 171},
  [1173] = {.lex_state = 171},
  [1174] = {.lex_state = 171},
  [1175] = {.lex_state = 171},
  [1176] = {.lex_state = 171},
  [1177] = {.lex_state = 171},
  [1178] = {.lex_state = 171},
  [1179] = {.lex_state = 171},
  [1180] = {.lex_state = 171},
  [1181] = {.lex_state = 171},
  [1182] = {.lex_state = 171},
  [1183] = {.lex_state = 171},
  [1184] = {.lex_state = 171},
  [1185] = {.lex_state = 171},
  [1186] = {.lex_state = 171},
  [1187] = {.lex_state = 171},
  [1188] = {.lex_state = 171},
  [1189] = {.lex_state = 171},
  [1190] = {.lex_state = 171},
  [1191] = {.lex_state = 171},
  [1192] = {.lex_state = 171},
  [1193] = {.lex_state = 171},
  [1194] = {.lex_state = 171},
  [1195] = {.lex_state = 171},
  [1196] = {.lex_state = 171},
  [1197] = {.lex_state = 171},
  [1198] = {.lex_state = 171},
  [1199] = {.lex_state = 171},
  [1200] = {.lex_state = 171},
  [1201] = {.lex_state = 171},
  [1202] = {.lex_state = 171},
  [1203] = {.lex_state = 171},
  [1204] = {.lex_state = 171},
  [1205] = {.lex_state = 171},
  [1206] = {.lex_state = 171},
  [1207] = {.lex_state = 171},
  [1208] = {.lex_state = 171},
  [1209] = {.lex_state = 171},
  [1210] = {.lex_state = 171},
  [1211] = {.lex_state = 171},
  [1212] = {.lex_state = 171},
  [1213] = {.lex_state = 171},
  [1214] = {.lex_state = 171},
  [1215] = {.lex_state = 171},
  [1216] = {.lex_state = 171},
  [1217] = {.lex_state = 171},
  [1218] = {.lex_state = 171},
  [1219] = {.lex_state = 171},
  [1220] = {.lex_state = 171},
  [1221] = {.lex_state = 171},
  [1222] = {.lex_state = 171},
  [1223] = {.lex_state = 171},
  [1224] = {.lex_state = 171},
  [1225] = {.lex_state = 171},
  [1226] = {.lex_state = 171},
  [1227] = {.lex_state = 171},
  [1228] = {.lex_state = 171},
  [1229] = {.lex_state = 171},
  [1230] = {.lex_state = 171},
  [1231] = {.lex_state = 171},
  [1232] = {.lex_state = 171},
  [1233] = {.lex_state = 171},
  [1234] = {.lex_state = 171},
  [1235] = {.lex_state = 171},
  [1236] = {.lex_state = 171},
  [1237] = {.lex_state = 171},
  [1238] = {.lex_state = 171},
  [1239] = {.lex_state = 171},
  [1240] = {.lex_state = 171},
  [1241] = {.lex_state = 171},
  [1242] = {.lex_state = 171},
  [1243] = {.lex_state = 171},
  [1244] = {.lex_state = 171},
  [1245] = {.lex_state = 171},
  [1246] = {.lex_state = 171},
  [1247] = {.lex_state = 171},
  [1248] = {.lex_state = 171},
  [1249] = {.lex_state = 171},
  [1250] = {.lex_state = 171},
  [1251] = {.lex_state = 171},
  [1252] = {.lex_state = 171},
  [1253] = {.lex_state = 171},
  [1254] = {.lex_state = 171},
  [1255] = {.lex_state = 171},
  [1256] = {.lex_state = 171},
  [1257] = {.lex_state = 171},
  [1258] = {.lex_state = 171},
  [1259] = {.lex_state = 171},
  [1260] = {.lex_state = 171},
  [1261] = {.lex_state = 171},
  [1262] = {.lex_state = 171},
  [1263] = {.lex_state = 171},
  [1264] = {.lex_state = 171},
  [1265] = {.lex_state = 171},
  [1266] = {.lex_state = 171},
  [1267] = {.lex_state = 171},
  [1268] = {.lex_state = 171},
  [1269] = {.lex_state = 171},
  [1270] = {.lex_state = 171},
  [1271] = {.lex_state = 171},
  [1272] = {.lex_state = 171},
  [1273] = {.lex_state = 171},
  [1274] = {.lex_state = 171},
  [1275] = {.lex_state = 171},
  [1276] = {.lex_state = 171},
  [1277] = {.lex_state = 171},
  [1278] = {.lex_state = 171},
  [1279] = {.lex_state = 171},
  [1280] = {.lex_state = 182},
  [1281] = {.lex_state = 182},
  [1282] = {.lex_state = 171},
  [1283] = {.lex_state = 171},
  [1284] = {.lex_state = 171},
  [1285] = {.lex_state = 182},
  [1286] = {.lex_state = 171},
  [1287] = {.lex_state = 171},
  [1288] = {.lex_state = 171},
  [1289] = {.lex_state = 171},
  [1290] = {.lex_state = 171},
  [1291] = {.lex_state = 171},
  [1292] = {.lex_state = 175},
  [1293] = {.lex_state = 171},
  [1294] = {.lex_state = 175},
  [1295] = {.lex_state = 175},
  [1296] = {.lex_state = 175},
  [1297] = {.lex_state = 171},
  [1298] = {.lex_state = 171},
  [1299] = {.lex_state = 171},
  [1300] = {.lex_state = 171},
  [1301] = {.lex_state = 171},
  [1302] = {.lex_state = 171},
  [1303] = {.lex_state = 171},
  [1304] = {.lex_state = 171},
  [1305] = {.lex_state = 171},
  [1306] = {.lex_state = 171},
  [1307] = {.lex_state = 171},
  [1308] = {.lex_state = 171},
  [1309] = {.lex_state = 171},
  [1310] = {.lex_state = 171},
  [1311] = {.lex_state = 171},
  [1312] = {.lex_state = 171},
  [1313] = {.lex_state = 171},
  [1314] = {.lex_state = 171},
  [1315] = {.lex_state = 171},
  [1316] = {.lex_state = 171},
  [1317] = {.lex_state = 171},
  [1318] = {.lex_state = 171},
  [1319] = {.lex_state = 171},
  [1320] = {.lex_state = 171},
  [1321] = {.lex_state = 171},
  [1322] = {.lex_state = 171},
  [1323] = {.lex_state = 171},
  [1324] = {.lex_state = 171},
  [1325] = {.lex_state = 171},
  [1326] = {.lex_state = 171},
  [1327] = {.lex_state = 171},
  [1328] = {.lex_state = 171},
  [1329] = {.lex_state = 171},
  [1330] = {.lex_state = 171},
  [1331] = {.lex_state = 171},
  [1332] = {.lex_state = 171},
  [1333] = {.lex_state = 171},
  [1334] = {.lex_state = 171},
  [1335] = {.lex_state = 171},
  [1336] = {.lex_state = 171},
  [1337] = {.lex_state = 171},
  [1338] = {.lex_state = 171},
  [1339] = {.lex_state = 171},
  [1340] = {.lex_state = 178},
  [1341] = {.lex_state = 171},
  [1342] = {.lex_state = 171},
  [1343] = {.lex_state = 171},
  [1344] = {.lex_state = 171},
  [1345] = {.lex_state = 171},
  [1346] = {.lex_state = 171},
  [1347] = {.lex_state = 171},
  [1348] = {.lex_state = 171},
  [1349] = {.lex_state = 171},
  [1350] = {.lex_state = 171},
  [1351] = {.lex_state = 171},
  [1352] = {.lex_state = 171},
  [1353] = {.lex_state = 171},
  [1354] = {.lex_state = 171},
  [1355] = {.lex_state = 171},
  [1356] = {.lex_state = 171},
  [1357] = {.lex_state = 171},
  [1358] = {.lex_state = 171},
  [1359] = {.lex_state = 171},
  [1360] = {.lex_state = 171},
  [1361] = {.lex_state = 171},
  [1362] = {.lex_state = 171},
  [1363] = {.lex_state = 171},
  [1364] = {.lex_state = 171},
  [1365] = {.lex_state = 171},
  [1366] = {.lex_state = 178},
  [1367] = {.lex_state = 171},
  [1368] = {.lex_state = 171},
  [1369] = {.lex_state = 171},
  [1370] = {.lex_state = 171},
  [1371] = {.lex_state = 171},
  [1372] = {.lex_state = 171},
  [1373] = {.lex_state = 178},
  [1374] = {.lex_state = 171},
  [1375] = {.lex_state = 171},
  [1376] = {.lex_state = 171},
  [1377] = {.lex_state = 171},
  [1378] = {.lex_state = 171},
  [1379] = {.lex_state = 171},
  [1380] = {.lex_state = 171},
  [1381] = {.lex_state = 171},
  [1382] = {.lex_state = 171},
  [1383] = {.lex_state = 171},
  [1384] = {.lex_state = 171},
  [1385] = {.lex_state = 171},
  [1386] = {.lex_state = 171},
  [1387] = {.lex_state = 171},
  [1388] = {.lex_state = 171},
  [1389] = {.lex_state = 171},
  [1390] = {.lex_state = 171},
  [1391] = {.lex_state = 171},
  [1392] = {.lex_state = 171},
  [1393] = {.lex_state = 171},
  [1394] = {.lex_state = 171},
  [1395] = {.lex_state = 171},
  [1396] = {.lex_state = 171},
  [1397] = {.lex_state = 171},
  [1398] = {.lex_state = 171},
  [1399] = {.lex_state = 171},
  [1400] = {.lex_state = 171},
  [1401] = {.lex_state = 171},
  [1402] = {.lex_state = 171},
  [1403] = {.lex_state = 171},
  [1404] = {.lex_state = 171},
  [1405] = {.lex_state = 171},
  [1406] = {.lex_state = 171},
  [1407] = {.lex_state = 171},
  [1408] = {.lex_state = 177},
  [1409] = {.lex_state = 2},
  [1410] = {.lex_state = 2},
  [1411] = {.lex_state = 2},
  [1412] = {.lex_state = 2},
  [1413] = {.lex_state = 2},
  [1414] = {.lex_state = 2},
  [1415] = {.lex_state = 2},
  [1416] = {.lex_state = 2},
  [1417] = {.lex_state = 2},
  [1418] = {.lex_state = 2},
  [1419] = {.lex_state = 2},
  [1420] = {.lex_state = 2},
  [1421] = {.lex_state = 2},
  [1422] = {.lex_state = 2},
  [1423] = {.lex_state = 2},
  [1424] = {.lex_state = 2},
  [1425] = {.lex_state = 4},
  [1426] = {.lex_state = 2},
  [1427] = {.lex_state = 2},
  [1428] = {.lex_state = 2},
  [1429] = {.lex_state = 2},
  [1430] = {.lex_state = 4},
  [1431] = {.lex_state = 2},
  [1432] = {.lex_state = 4},
  [1433] = {.lex_state = 4},
  [1434] = {.lex_state = 2},
  [1435] = {.lex_state = 2},
  [1436] = {.lex_state = 2},
  [1437] = {.lex_state = 26},
  [1438] = {.lex_state = 2},
  [1439] = {.lex_state = 2},
  [1440] = {.lex_state = 26},
  [1441] = {.lex_state = 2},
  [1442] = {.lex_state = 2},
  [1443] = {.lex_state = 26},
  [1444] = {.lex_state = 2},
  [1445] = {.lex_state = 26},
  [1446] = {.lex_state = 2},
  [1447] = {.lex_state = 2},
  [1448] = {.lex_state = 2},
  [1449] = {.lex_state = 26},
  [1450] = {.lex_state = 2},
  [1451] = {.lex_state = 2},
  [1452] = {.lex_state = 2},
  [1453] = {.lex_state = 2},
  [1454] = {.lex_state = 2},
  [1455] = {.lex_state = 2},
  [1456] = {.lex_state = 2},
  [1457] = {.lex_state = 2},
  [1458] = {.lex_state = 2},
  [1459] = {.lex_state = 2},
  [1460] = {.lex_state = 2},
  [1461] = {.lex_state = 2},
  [1462] = {.lex_state = 26},
  [1463] = {.lex_state = 2},
  [1464] = {.lex_state = 2},
  [1465] = {.lex_state = 2},
  [1466] = {.lex_state = 2},
  [1467] = {.lex_state = 2},
  [1468] = {.lex_state = 2},
  [1469] = {.lex_state = 2},
  [1470] = {.lex_state = 2},
  [1471] = {.lex_state = 2},
  [1472] = {.lex_state = 2},
  [1473] = {.lex_state = 2},
  [1474] = {.lex_state = 2},
  [1475] = {.lex_state = 2},
  [1476] = {.lex_state = 2},
  [1477] = {.lex_state = 2},
  [1478] = {.lex_state = 28},
  [1479] = {.lex_state = 2},
  [1480] = {.lex_state = 2},
  [1481] = {.lex_state = 2},
  [1482] = {.lex_state = 2},
  [1483] = {.lex_state = 2},
  [1484] = {.lex_state = 2},
  [1485] = {.lex_state = 2},
  [1486] = {.lex_state = 2},
  [1487] = {.lex_state = 2},
  [1488] = {.lex_state = 28},
  [1489] = {.lex_state = 2},
  [1490] = {.lex_state = 2},
  [1491] = {.lex_state = 2},
  [1492] = {.lex_state = 2},
  [1493] = {.lex_state = 2},
  [1494] = {.lex_state = 2},
  [1495] = {.lex_state = 2},
  [1496] = {.lex_state = 2},
  [1497] = {.lex_state = 2},
  [1498] = {.lex_state = 2},
  [1499] = {.lex_state = 2},
  [1500] = {.lex_state = 2},
  [1501] = {.lex_state = 2},
  [1502] = {.lex_state = 2},
  [1503] = {.lex_state = 2},
  [1504] = {.lex_state = 2},
  [1505] = {.lex_state = 2},
  [1506] = {.lex_state = 2},
  [1507] = {.lex_state = 2},
  [1508] = {.lex_state = 2},
  [1509] = {.lex_state = 2},
  [1510] = {.lex_state = 2},
  [1511] = {.lex_state = 2},
  [1512] = {.lex_state = 2},
  [1513] = {.lex_state = 2},
  [1514] = {.lex_state = 2},
  [1515] = {.lex_state = 2},
  [1516] = {.lex_state = 2},
  [1517] = {.lex_state = 28},
  [1518] = {.lex_state = 2},
  [1519] = {.lex_state = 2},
  [1520] = {.lex_state = 2},
  [1521] = {.lex_state = 2},
  [1522] = {.lex_state = 2},
  [1523] = {.lex_state = 28},
  [1524] = {.lex_state = 2},
  [1525] = {.lex_state = 2},
  [1526] = {.lex_state = 2},
  [1527] = {.lex_state = 2},
  [1528] = {.lex_state = 2},
  [1529] = {.lex_state = 2},
  [1530] = {.lex_state = 2},
  [1531] = {.lex_state = 2},
  [1532] = {.lex_state = 2},
  [1533] = {.lex_state = 28},
  [1534] = {.lex_state = 2},
  [1535] = {.lex_state = 2},
  [1536] = {.lex_state = 2},
  [1537] = {.lex_state = 2},
  [1538] = {.lex_state = 2},
  [1539] = {.lex_state = 2},
  [1540] = {.lex_state = 2},
  [1541] = {.lex_state = 2},
  [1542] = {.lex_state = 2},
  [1543] = {.lex_state = 2},
  [1544] = {.lex_state = 2},
  [1545] = {.lex_state = 2},
  [1546] = {.lex_state = 2},
  [1547] = {.lex_state = 2},
  [1548] = {.lex_state = 2},
  [1549] = {.lex_state = 2},
  [1550] = {.lex_state = 2},
  [1551] = {.lex_state = 2},
  [1552] = {.lex_state = 22},
  [1553] = {.lex_state = 22},
  [1554] = {.lex_state = 26},
  [1555] = {.lex_state = 22},
  [1556] = {.lex_state = 22},
  [1557] = {.lex_state = 22},
  [1558] = {.lex_state = 22},
  [1559] = {.lex_state = 22},
  [1560] = {.lex_state = 22},
  [1561] = {.lex_state = 24},
  [1562] = {.lex_state = 22},
  [1563] = {.lex_state = 22},
  [1564] = {.lex_state = 22},
  [1565] = {.lex_state = 22},
  [1566] = {.lex_state = 22},
  [1567] = {.lex_state = 22},
  [1568] = {.lex_state = 22},
  [1569] = {.lex_state = 22},
  [1570] = {.lex_state = 22},
  [1571] = {.lex_state = 22},
  [1572] = {.lex_state = 24},
  [1573] = {.lex_state = 24},
  [1574] = {.lex_state = 22},
  [1575] = {.lex_state = 22},
  [1576] = {.lex_state = 22},
  [1577] = {.lex_state = 22},
  [1578] = {.lex_state = 22},
  [1579] = {.lex_state = 22},
  [1580] = {.lex_state = 22},
  [1581] = {.lex_state = 22},
  [1582] = {.lex_state = 177},
  [1583] = {.lex_state = 22},
  [1584] = {.lex_state = 22},
  [1585] = {.lex_state = 24},
  [1586] = {.lex_state = 22},
  [1587] = {.lex_state = 22},
  [1588] = {.lex_state = 22},
  [1589] = {.lex_state = 22},
  [1590] = {.lex_state = 22},
  [1591] = {.lex_state = 22},
  [1592] = {.lex_state = 22},
  [1593] = {.lex_state = 22},
  [1594] = {.lex_state = 22},
  [1595] = {.lex_state = 22},
  [1596] = {.lex_state = 22},
  [1597] = {.lex_state = 22},
  [1598] = {.lex_state = 22},
  [1599] = {.lex_state = 22},
  [1600] = {.lex_state = 22},
  [1601] = {.lex_state = 22},
  [1602] = {.lex_state = 22},
  [1603] = {.lex_state = 22},
  [1604] = {.lex_state = 22},
  [1605] = {.lex_state = 22},
  [1606] = {.lex_state = 22},
  [1607] = {.lex_state = 22},
  [1608] = {.lex_state = 22},
  [1609] = {.lex_state = 22},
  [1610] = {.lex_state = 22},
  [1611] = {.lex_state = 22},
  [1612] = {.lex_state = 22},
  [1613] = {.lex_state = 22},
  [1614] = {.lex_state = 22},
  [1615] = {.lex_state = 22},
  [1616] = {.lex_state = 22},
  [1617] = {.lex_state = 22},
  [1618] = {.lex_state = 22},
  [1619] = {.lex_state = 22},
  [1620] = {.lex_state = 22},
  [1621] = {.lex_state = 22},
  [1622] = {.lex_state = 22},
  [1623] = {.lex_state = 22},
  [1624] = {.lex_state = 22},
  [1625] = {.lex_state = 22},
  [1626] = {.lex_state = 22},
  [1627] = {.lex_state = 22},
  [1628] = {.lex_state = 22},
  [1629] = {.lex_state = 22},
  [1630] = {.lex_state = 22},
  [1631] = {.lex_state = 22},
  [1632] = {.lex_state = 22},
  [1633] = {.lex_state = 22},
  [1634] = {.lex_state = 22},
  [1635] = {.lex_state = 22},
  [1636] = {.lex_state = 22},
  [1637] = {.lex_state = 22},
  [1638] = {.lex_state = 22},
  [1639] = {.lex_state = 22},
  [1640] = {.lex_state = 22},
  [1641] = {.lex_state = 22},
  [1642] = {.lex_state = 22},
  [1643] = {.lex_state = 22},
  [1644] = {.lex_state = 22},
  [1645] = {.lex_state = 22},
  [1646] = {.lex_state = 22},
  [1647] = {.lex_state = 22},
  [1648] = {.lex_state = 22},
  [1649] = {.lex_state = 22},
  [1650] = {.lex_state = 22},
  [1651] = {.lex_state = 22},
  [1652] = {.lex_state = 22},
  [1653] = {.lex_state = 22},
  [1654] = {.lex_state = 22},
  [1655] = {.lex_state = 22},
  [1656] = {.lex_state = 22},
  [1657] = {.lex_state = 22},
  [1658] = {.lex_state = 22},
  [1659] = {.lex_state = 22},
  [1660] = {.lex_state = 22},
  [1661] = {.lex_state = 22},
  [1662] = {.lex_state = 22},
  [1663] = {.lex_state = 22},
  [1664] = {.lex_state = 22},
  [1665] = {.lex_state = 22},
  [1666] = {.lex_state = 22},
  [1667] = {.lex_state = 22},
  [1668] = {.lex_state = 22},
  [1669] = {.lex_state = 22},
  [1670] = {.lex_state = 22},
  [1671] = {.lex_state = 22},
  [1672] = {.lex_state = 22},
  [1673] = {.lex_state = 22},
  [1674] = {.lex_state = 22},
  [1675] = {.lex_state = 22},
  [1676] = {.lex_state = 22},
  [1677] = {.lex_state = 22},
  [1678] = {.lex_state = 22},
  [1679] = {.lex_state = 22},
  [1680] = {.lex_state = 22},
  [1681] = {.lex_state = 22},
  [1682] = {.lex_state = 22},
  [1683] = {.lex_state = 22},
  [1684] = {.lex_state = 22},
  [1685] = {.lex_state = 22},
  [1686] = {.lex_state = 22},
  [1687] = {.lex_state = 22},
  [1688] = {.lex_state = 22},
  [1689] = {.lex_state = 22},
  [1690] = {.lex_state = 6},
  [1691] = {.lex_state = 22},
  [1692] = {.lex_state = 22},
  [1693] = {.lex_state = 22},
  [1694] = {.lex_state = 6},
  [1695] = {.lex_state = 6},
  [1696] = {.lex_state = 6},
  [1697] = {.lex_state = 6},
  [1698] = {.lex_state = 22},
  [1699] = {.lex_state = 181},
  [1700] = {.lex_state = 34},
  [1701] = {.lex_state = 181},
  [1702] = {.lex_state = 182},
  [1703] = {.lex_state = 182},
  [1704] = {.lex_state = 182},
  [1705] = {.lex_state = 182},
  [1706] = {.lex_state = 34},
  [1707] = {.lex_state = 182},
  [1708] = {.lex_state = 182},
  [1709] = {.lex_state = 181},
  [1710] = {.lex_state = 34},
  [1711] = {.lex_state = 181},
  [1712] = {.lex_state = 182},
  [1713] = {.lex_state = 34},
  [1714] = {.lex_state = 182},
  [1715] = {.lex_state = 178},
  [1716] = {.lex_state = 182},
  [1717] = {.lex_state = 178},
  [1718] = {.lex_state = 182},
  [1719] = {.lex_state = 182},
  [1720] = {.lex_state = 182},
  [1721] = {.lex_state = 182},
  [1722] = {.lex_state = 182},
  [1723] = {.lex_state = 182},
  [1724] = {.lex_state = 182},
  [1725] = {.lex_state = 182},
  [1726] = {.lex_state = 182},
  [1727] = {.lex_state = 182},
  [1728] = {.lex_state = 182},
  [1729] = {.lex_state = 182},
  [1730] = {.lex_state = 179},
  [1731] = {.lex_state = 182},
  [1732] = {.lex_state = 182},
  [1733] = {.lex_state = 182},
  [1734] = {.lex_state = 182},
  [1735] = {.lex_state = 182},
  [1736] = {.lex_state = 182},
  [1737] = {.lex_state = 178},
  [1738] = {.lex_state = 182},
  [1739] = {.lex_state = 182},
  [1740] = {.lex_state = 178},
  [1741] = {.lex_state = 182},
  [1742] = {.lex_state = 182},
  [1743] = {.lex_state = 182},
  [1744] = {.lex_state = 182},
  [1745] = {.lex_state = 182},
  [1746] = {.lex_state = 182},
  [1747] = {.lex_state = 182},
  [1748] = {.lex_state = 182},
  [1749] = {.lex_state = 178},
  [1750] = {.lex_state = 178},
  [1751] = {.lex_state = 178},
  [1752] = {.lex_state = 179},
  [1753] = {.lex_state = 178},
  [1754] = {.lex_state = 178},
  [1755] = {.lex_state = 178},
  [1756] = {.lex_state = 178},
  [1757] = {.lex_state = 178},
  [1758] = {.lex_state = 178},
  [1759] = {.lex_state = 178},
  [1760] = {.lex_state = 178},
  [1761] = {.lex_state = 178},
  [1762] = {.lex_state = 178},
  [1763] = {.lex_state = 178},
  [1764] = {.lex_state = 178},
  [1765] = {.lex_state = 178},
  [1766] = {.lex_state = 178},
  [1767] = {.lex_state = 178},
  [1768] = {.lex_state = 178},
  [1769] = {.lex_state = 178},
  [1770] = {.lex_state = 178},
  [1771] = {.lex_state = 178},
  [1772] = {.lex_state = 178},
  [1773] = {.lex_state = 178},
  [1774] = {.lex_state = 179},
  [1775] = {.lex_state = 179},
  [1776] = {.lex_state = 178},
  [1777] = {.lex_state = 178},
  [1778] = {.lex_state = 178},
  [1779] = {.lex_state = 178},
  [1780] = {.lex_state = 178},
  [1781] = {.lex_state = 178},
  [1782] = {.lex_state = 178},
  [1783] = {.lex_state = 185},
  [1784] = {.lex_state = 178},
  [1785] = {.lex_state = 178},
  [1786] = {.lex_state = 178},
  [1787] = {.lex_state = 178},
  [1788] = {.lex_state = 178},
  [1789] = {.lex_state = 178},
  [1790] = {.lex_state = 178},
  [1791] = {.lex_state = 178},
  [1792] = {.lex_state = 178},
  [1793] = {.lex_state = 178},
  [1794] = {.lex_state = 178},
  [1795] = {.lex_state = 178},
  [1796] = {.lex_state = 178},
  [1797] = {.lex_state = 178},
  [1798] = {.lex_state = 178},
  [1799] = {.lex_state = 178},
  [1800] = {.lex_state = 178},
  [1801] = {.lex_state = 178},
  [1802] = {.lex_state = 178},
  [1803] = {.lex_state = 178},
  [1804] = {.lex_state = 178},
  [1805] = {.lex_state = 185},
  [1806] = {.lex_state = 178},
  [1807] = {.lex_state = 178},
  [1808] = {.lex_state = 178},
  [1809] = {.lex_state = 178},
  [1810] = {.lex_state = 178},
  [1811] = {.lex_state = 178},
  [1812] = {.lex_state = 178},
  [1813] = {.lex_state = 178},
  [1814] = {.lex_state = 178},
  [1815] = {.lex_state = 178},
  [1816] = {.lex_state = 178},
  [1817] = {.lex_state = 178},
  [1818] = {.lex_state = 178},
  [1819] = {.lex_state = 178},
  [1820] = {.lex_state = 178},
  [1821] = {.lex_state = 178},
  [1822] = {.lex_state = 178},
  [1823] = {.lex_state = 178},
  [1824] = {.lex_state = 38},
  [1825] = {.lex_state = 178},
  [1826] = {.lex_state = 178},
  [1827] = {.lex_state = 178},
  [1828] = {.lex_state = 178},
  [1829] = {.lex_state = 178},
  [1830] = {.lex_state = 178},
  [1831] = {.lex_state = 178},
  [1832] = {.lex_state = 178},
  [1833] = {.lex_state = 178},
  [1834] = {.lex_state = 178},
  [1835] = {.lex_state = 178},
  [1836] = {.lex_state = 178},
  [1837] = {.lex_state = 178},
  [1838] = {.lex_state = 6},
  [1839] = {.lex_state = 178},
  [1840] = {.lex_state = 178},
  [1841] = {.lex_state = 178},
  [1842] = {.lex_state = 178},
  [1843] = {.lex_state = 178},
  [1844] = {.lex_state = 178},
  [1845] = {.lex_state = 178},
  [1846] = {.lex_state = 178},
  [1847] = {.lex_state = 178},
  [1848] = {.lex_state = 178},
  [1849] = {.lex_state = 178},
  [1850] = {.lex_state = 178},
  [1851] = {.lex_state = 178},
  [1852] = {.lex_state = 178},
  [1853] = {.lex_state = 178},
  [1854] = {.lex_state = 178},
  [1855] = {.lex_state = 178},
  [1856] = {.lex_state = 178},
  [1857] = {.lex_state = 178},
  [1858] = {.lex_state = 178},
  [1859] = {.lex_state = 178},
  [1860] = {.lex_state = 178},
  [1861] = {.lex_state = 178},
  [1862] = {.lex_state = 178},
  [1863] = {.lex_state = 178},
  [1864] = {.lex_state = 178},
  [1865] = {.lex_state = 178},
  [1866] = {.lex_state = 178},
  [1867] = {.lex_state = 178},
  [1868] = {.lex_state = 178},
  [1869] = {.lex_state = 178},
  [1870] = {.lex_state = 178},
  [1871] = {.lex_state = 178},
  [1872] = {.lex_state = 178},
  [1873] = {.lex_state = 178},
  [1874] = {.lex_state = 178},
  [1875] = {.lex_state = 178},
  [1876] = {.lex_state = 178},
  [1877] = {.lex_state = 178},
  [1878] = {.lex_state = 178},
  [1879] = {.lex_state = 178},
  [1880] = {.lex_state = 178},
  [1881] = {.lex_state = 178},
  [1882] = {.lex_state = 178},
  [1883] = {.lex_state = 178},
  [1884] = {.lex_state = 178},
  [1885] = {.lex_state = 178},
  [1886] = {.lex_state = 178},
  [1887] = {.lex_state = 178},
  [1888] = {.lex_state = 178},
  [1889] = {.lex_state = 178},
  [1890] = {.lex_state = 178},
  [1891] = {.lex_state = 178},
  [1892] = {.lex_state = 178},
  [1893] = {.lex_state = 178},
  [1894] = {.lex_state = 178},
  [1895] = {.lex_state = 178},
  [1896] = {.lex_state = 178},
  [1897] = {.lex_state = 178},
  [1898] = {.lex_state = 178},
  [1899] = {.lex_state = 34},
  [1900] = {.lex_state = 178},
  [1901] = {.lex_state = 178},
  [1902] = {.lex_state = 178},
  [1903] = {.lex_state = 178},
  [1904] = {.lex_state = 178},
  [1905] = {.lex_state = 178},
  [1906] = {.lex_state = 38},
  [1907] = {.lex_state = 38},
  [1908] = {.lex_state = 38},
  [1909] = {.lex_state = 6},
  [1910] = {.lex_state = 6},
  [1911] = {.lex_state = 6},
  [1912] = {.lex_state = 34},
  [1913] = {.lex_state = 6},
  [1914] = {.lex_state = 38},
  [1915] = {.lex_state = 185},
  [1916] = {.lex_state = 64},
  [1917] = {.lex_state = 185},
  [1918] = {.lex_state = 34},
  [1919] = {.lex_state = 34},
  [1920] = {.lex_state = 185},
  [1921] = {.lex_state = 185},
  [1922] = {.lex_state = 185},
  [1923] = {.lex_state = 185},
  [1924] = {.lex_state = 178},
  [1925] = {.lex_state = 178},
  [1926] = {.lex_state = 178},
  [1927] = {.lex_state = 178},
  [1928] = {.lex_state = 178},
  [1929] = {.lex_state = 178},
  [1930] = {.lex_state = 178},
  [1931] = {.lex_state = 178},
  [1932] = {.lex_state = 178},
  [1933] = {.lex_state = 178},
  [1934] = {.lex_state = 178},
  [1935] = {.lex_state = 178},
  [1936] = {.lex_state = 178},
  [1937] = {.lex_state = 178},
  [1938] = {.lex_state = 178},
  [1939] = {.lex_state = 178},
  [1940] = {.lex_state = 178},
  [1941] = {.lex_state = 178},
  [1942] = {.lex_state = 178},
  [1943] = {.lex_state = 178},
  [1944] = {.lex_state = 178},
  [1945] = {.lex_state = 178},
  [1946] = {.lex_state = 178},
  [1947] = {.lex_state = 178},
  [1948] = {.lex_state = 178},
  [1949] = {.lex_state = 178},
  [1950] = {.lex_state = 178},
  [1951] = {.lex_state = 178},
  [1952] = {.lex_state = 26},
  [1953] = {.lex_state = 28},
  [1954] = {.lex_state = 26},
  [1955] = {.lex_state = 28},
  [1956] = {.lex_state = 26},
  [1957] = {.lex_state = 26},
  [1958] = {.lex_state = 26},
  [1959] = {.lex_state = 28},
  [1960] = {.lex_state = 28},
  [1961] = {.lex_state = 28},
  [1962] = {.lex_state = 185},
  [1963] = {.lex_state = 44},
  [1964] = {.lex_state = 44},
  [1965] = {.lex_state = 56},
  [1966] = {.lex_state = 56},
  [1967] = {.lex_state = 44},
  [1968] = {.lex_state = 44},
  [1969] = {.lex_state = 44},
  [1970] = {.lex_state = 56},
  [1971] = {.lex_state = 56},
  [1972] = {.lex_state = 44},
  [1973] = {.lex_state = 44},
  [1974] = {.lex_state = 44},
  [1975] = {.lex_state = 56},
  [1976] = {.lex_state = 44},
  [1977] = {.lex_state = 44},
  [1978] = {.lex_state = 44},
  [1979] = {.lex_state = 44},
  [1980] = {.lex_state = 56},
  [1981] = {.lex_state = 44},
  [1982] = {.lex_state = 56},
  [1983] = {.lex_state = 44},
  [1984] = {.lex_state = 56},
  [1985] = {.lex_state = 44},
  [1986] = {.lex_state = 56},
  [1987] = {.lex_state = 56},
  [1988] = {.lex_state = 6},
  [1989] = {.lex_state = 44},
  [1990] = {.lex_state = 6},
  [1991] = {.lex_state = 6},
  [1992] = {.lex_state = 44},
  [1993] = {.lex_state = 44},
  [1994] = {.lex_state = 48},
  [1995] = {.lex_state = 44},
  [1996] = {.lex_state = 32},
  [1997] = {.lex_state = 44},
  [1998] = {.lex_state = 44},
  [1999] = {.lex_state = 32},
  [2000] = {.lex_state = 44},
  [2001] = {.lex_state = 29},
  [2002] = {.lex_state = 6},
  [2003] = {.lex_state = 46},
  [2004] = {.lex_state = 48},
  [2005] = {.lex_state = 44},
  [2006] = {.lex_state = 46},
  [2007] = {.lex_state = 29},
  [2008] = {.lex_state = 56},
  [2009] = {.lex_state = 6},
  [2010] = {.lex_state = 44},
  [2011] = {.lex_state = 44},
  [2012] = {.lex_state = 44},
  [2013] = {.lex_state = 56},
  [2014] = {.lex_state = 56},
  [2015] = {.lex_state = 44},
  [2016] = {.lex_state = 56},
  [2017] = {.lex_state = 56},
  [2018] = {.lex_state = 14},
  [2019] = {.lex_state = 44},
  [2020] = {.lex_state = 44},
  [2021] = {.lex_state = 44},
  [2022] = {.lex_state = 14},
  [2023] = {.lex_state = 44},
  [2024] = {.lex_state = 56},
  [2025] = {.lex_state = 56},
  [2026] = {.lex_state = 56},
  [2027] = {.lex_state = 56},
  [2028] = {.lex_state = 56},
  [2029] = {.lex_state = 44},
  [2030] = {.lex_state = 44},
  [2031] = {.lex_state = 44},
  [2032] = {.lex_state = 44},
  [2033] = {.lex_state = 44},
  [2034] = {.lex_state = 56},
  [2035] = {.lex_state = 44},
  [2036] = {.lex_state = 44},
  [2037] = {.lex_state = 44},
  [2038] = {.lex_state = 44},
  [2039] = {.lex_state = 44},
  [2040] = {.lex_state = 44},
  [2041] = {.lex_state = 44},
  [2042] = {.lex_state = 56},
  [2043] = {.lex_state = 44},
  [2044] = {.lex_state = 56},
  [2045] = {.lex_state = 44},
  [2046] = {.lex_state = 44},
  [2047] = {.lex_state = 56},
  [2048] = {.lex_state = 56},
  [2049] = {.lex_state = 44},
  [2050] = {.lex_state = 44},
  [2051] = {.lex_state = 44},
  [2052] = {.lex_state = 44},
  [2053] = {.lex_state = 56},
  [2054] = {.lex_state = 44},
  [2055] = {.lex_state = 56},
  [2056] = {.lex_state = 56},
  [2057] = {.lex_state = 56},
  [2058] = {.lex_state = 44},
  [2059] = {.lex_state = 44},
  [2060] = {.lex_state = 44},
  [2061] = {.lex_state = 44},
  [2062] = {.lex_state = 44},
  [2063] = {.lex_state = 44},
  [2064] = {.lex_state = 56},
  [2065] = {.lex_state = 56},
  [2066] = {.lex_state = 56},
  [2067] = {.lex_state = 56},
  [2068] = {.lex_state = 56},
  [2069] = {.lex_state = 56},
  [2070] = {.lex_state = 44},
  [2071] = {.lex_state = 44},
  [2072] = {.lex_state = 56},
  [2073] = {.lex_state = 56},
  [2074] = {.lex_state = 44},
  [2075] = {.lex_state = 44},
  [2076] = {.lex_state = 44},
  [2077] = {.lex_state = 44},
  [2078] = {.lex_state = 44},
  [2079] = {.lex_state = 44},
  [2080] = {.lex_state = 56},
  [2081] = {.lex_state = 44},
  [2082] = {.lex_state = 56},
  [2083] = {.lex_state = 56},
  [2084] = {.lex_state = 44},
  [2085] = {.lex_state = 44},
  [2086] = {.lex_state = 44},
  [2087] = {.lex_state = 44},
  [2088] = {.lex_state = 44},
  [2089] = {.lex_state = 44},
  [2090] = {.lex_state = 44},
  [2091] = {.lex_state = 44},
  [2092] = {.lex_state = 44},
  [2093] = {.lex_state = 44},
  [2094] = {.lex_state = 56},
  [2095] = {.lex_state = 44},
  [2096] = {.lex_state = 44},
  [2097] = {.lex_state = 44},
  [2098] = {.lex_state = 44},
  [2099] = {.lex_state = 44},
  [2100] = {.lex_state = 44},
  [2101] = {.lex_state = 44},
  [2102] = {.lex_state = 56},
  [2103] = {.lex_state = 56},
  [2104] = {.lex_state = 56},
  [2105] = {.lex_state = 44},
  [2106] = {.lex_state = 56},
  [2107] = {.lex_state = 44},
  [2108] = {.lex_state = 56},
  [2109] = {.lex_state = 44},
  [2110] = {.lex_state = 56},
  [2111] = {.lex_state = 56},
  [2112] = {.lex_state = 44},
  [2113] = {.lex_state = 56},
  [2114] = {.lex_state = 56},
  [2115] = {.lex_state = 56},
  [2116] = {.lex_state = 44},
  [2117] = {.lex_state = 56},
  [2118] = {.lex_state = 44},
  [2119] = {.lex_state = 44},
  [2120] = {.lex_state = 44},
  [2121] = {.lex_state = 56},
  [2122] = {.lex_state = 44},
  [2123] = {.lex_state = 56},
  [2124] = {.lex_state = 56},
  [2125] = {.lex_state = 56},
  [2126] = {.lex_state = 56},
  [2127] = {.lex_state = 56},
  [2128] = {.lex_state = 56},
  [2129] = {.lex_state = 56},
  [2130] = {.lex_state = 56},
  [2131] = {.lex_state = 56},
  [2132] = {.lex_state = 56},
  [2133] = {.lex_state = 56},
  [2134] = {.lex_state = 44},
  [2135] = {.lex_state = 44},
  [2136] = {.lex_state = 56},
  [2137] = {.lex_state = 56},
  [2138] = {.lex_state = 56},
  [2139] = {.lex_state = 56},
  [2140] = {.lex_state = 56},
  [2141] = {.lex_state = 44},
  [2142] = {.lex_state = 44},
  [2143] = {.lex_state = 56},
  [2144] = {.lex_state = 44},
  [2145] = {.lex_state = 56},
  [2146] = {.lex_state = 44},
  [2147] = {.lex_state = 56},
  [2148] = {.lex_state = 44},
  [2149] = {.lex_state = 44},
  [2150] = {.lex_state = 56},
  [2151] = {.lex_state = 56},
  [2152] = {.lex_state = 56},
  [2153] = {.lex_state = 44},
  [2154] = {.lex_state = 44},
  [2155] = {.lex_state = 56},
  [2156] = {.lex_state = 56},
  [2157] = {.lex_state = 56},
  [2158] = {.lex_state = 44},
  [2159] = {.lex_state = 56},
  [2160] = {.lex_state = 56},
  [2161] = {.lex_state = 56},
  [2162] = {.lex_state = 44},
  [2163] = {.lex_state = 56},
  [2164] = {.lex_state = 56},
  [2165] = {.lex_state = 44},
  [2166] = {.lex_state = 44},
  [2167] = {.lex_state = 56},
  [2168] = {.lex_state = 44},
  [2169] = {.lex_state = 44},
  [2170] = {.lex_state = 44},
  [2171] = {.lex_state = 44},
  [2172] = {.lex_state = 56},
  [2173] = {.lex_state = 56},
  [2174] = {.lex_state = 56},
  [2175] = {.lex_state = 56},
  [2176] = {.lex_state = 44},
  [2177] = {.lex_state = 44},
  [2178] = {.lex_state = 44},
  [2179] = {.lex_state = 44},
  [2180] = {.lex_state = 56},
  [2181] = {.lex_state = 56},
  [2182] = {.lex_state = 44},
  [2183] = {.lex_state = 44},
  [2184] = {.lex_state = 44},
  [2185] = {.lex_state = 44},
  [2186] = {.lex_state = 56},
  [2187] = {.lex_state = 44},
  [2188] = {.lex_state = 56},
  [2189] = {.lex_state = 44},
  [2190] = {.lex_state = 56},
  [2191] = {.lex_state = 56},
  [2192] = {.lex_state = 56},
  [2193] = {.lex_state = 44},
  [2194] = {.lex_state = 56},
  [2195] = {.lex_state = 56},
  [2196] = {.lex_state = 44},
  [2197] = {.lex_state = 56},
  [2198] = {.lex_state = 56},
  [2199] = {.lex_state = 14},
  [2200] = {.lex_state = 44},
  [2201] = {.lex_state = 56},
  [2202] = {.lex_state = 44},
  [2203] = {.lex_state = 44},
  [2204] = {.lex_state = 44},
  [2205] = {.lex_state = 44},
  [2206] = {.lex_state = 44},
  [2207] = {.lex_state = 44},
  [2208] = {.lex_state = 56},
  [2209] = {.lex_state = 56},
  [2210] = {.lex_state = 56},
  [2211] = {.lex_state = 56},
  [2212] = {.lex_state = 44},
  [2213] = {.lex_state = 44},
  [2214] = {.lex_state = 56},
  [2215] = {.lex_state = 56},
  [2216] = {.lex_state = 56},
  [2217] = {.lex_state = 44},
  [2218] = {.lex_state = 44},
  [2219] = {.lex_state = 44},
  [2220] = {.lex_state = 44},
  [2221] = {.lex_state = 56},
  [2222] = {.lex_state = 56},
  [2223] = {.lex_state = 56},
  [2224] = {.lex_state = 44},
  [2225] = {.lex_state = 56},
  [2226] = {.lex_state = 56},
  [2227] = {.lex_state = 56},
  [2228] = {.lex_state = 34},
  [2229] = {.lex_state = 34},
  [2230] = {.lex_state = 34},
  [2231] = {.lex_state = 34},
  [2232] = {.lex_state = 34},
  [2233] = {.lex_state = 7},
  [2234] = {.lex_state = 7},
  [2235] = {.lex_state = 44},
  [2236] = {.lex_state = 7},
  [2237] = {.lex_state = 64},
  [2238] = {.lex_state = 7},
  [2239] = {.lex_state = 7},
  [2240] = {.lex_state = 64},
  [2241] = {.lex_state = 10},
  [2242] = {.lex_state = 10},
  [2243] = {.lex_state = 64},
  [2244] = {.lex_state = 7},
  [2245] = {.lex_state = 64},
  [2246] = {.lex_state = 64},
  [2247] = {.lex_state = 10},
  [2248] = {.lex_state = 64},
  [2249] = {.lex_state = 64},
  [2250] = {.lex_state = 64},
  [2251] = {.lex_state = 7},
  [2252] = {.lex_state = 7},
  [2253] = {.lex_state = 7},
  [2254] = {.lex_state = 64},
  [2255] = {.lex_state = 64},
  [2256] = {.lex_state = 7},
  [2257] = {.lex_state = 10},
  [2258] = {.lex_state = 7},
  [2259] = {.lex_state = 7},
  [2260] = {.lex_state = 7},
  [2261] = {.lex_state = 7},
  [2262] = {.lex_state = 7},
  [2263] = {.lex_state = 7},
  [2264] = {.lex_state = 64},
  [2265] = {.lex_state = 7},
  [2266] = {.lex_state = 7},
  [2267] = {.lex_state = 7},
  [2268] = {.lex_state = 7},
  [2269] = {.lex_state = 7},
  [2270] = {.lex_state = 7},
  [2271] = {.lex_state = 7},
  [2272] = {.lex_state = 7},
  [2273] = {.lex_state = 7},
  [2274] = {.lex_state = 7},
  [2275] = {.lex_state = 7},
  [2276] = {.lex_state = 7},
  [2277] = {.lex_state = 7},
  [2278] = {.lex_state = 7},
  [2279] = {.lex_state = 7},
  [2280] = {.lex_state = 7},
  [2281] = {.lex_state = 7},
  [2282] = {.lex_state = 7},
  [2283] = {.lex_state = 7},
  [2284] = {.lex_state = 7},
  [2285] = {.lex_state = 7},
  [2286] = {.lex_state = 7},
  [2287] = {.lex_state = 7},
  [2288] = {.lex_state = 7},
  [2289] = {.lex_state = 7},
  [2290] = {.lex_state = 38},
  [2291] = {.lex_state = 7},
  [2292] = {.lex_state = 7},
  [2293] = {.lex_state = 7},
  [2294] = {.lex_state = 7},
  [2295] = {.lex_state = 7},
  [2296] = {.lex_state = 7},
  [2297] = {.lex_state = 7},
  [2298] = {.lex_state = 7},
  [2299] = {.lex_state = 7},
  [2300] = {.lex_state = 7},
  [2301] = {.lex_state = 7},
  [2302] = {.lex_state = 7},
  [2303] = {.lex_state = 7},
  [2304] = {.lex_state = 38},
  [2305] = {.lex_state = 7},
  [2306] = {.lex_state = 38},
  [2307] = {.lex_state = 7},
  [2308] = {.lex_state = 38},
  [2309] = {.lex_state = 38},
  [2310] = {.lex_state = 7},
  [2311] = {.lex_state = 7},
  [2312] = {.lex_state = 7},
  [2313] = {.lex_state = 7},
  [2314] = {.lex_state = 7},
  [2315] = {.lex_state = 7},
  [2316] = {.lex_state = 7},
  [2317] = {.lex_state = 7},
  [2318] = {.lex_state = 7},
  [2319] = {.lex_state = 7},
  [2320] = {.lex_state = 64},
  [2321] = {.lex_state = 7},
  [2322] = {.lex_state = 7},
  [2323] = {.lex_state = 7},
  [2324] = {.lex_state = 7},
  [2325] = {.lex_state = 7},
  [2326] = {.lex_state = 7},
  [2327] = {.lex_state = 7},
  [2328] = {.lex_state = 7},
  [2329] = {.lex_state = 7},
  [2330] = {.lex_state = 7},
  [2331] = {.lex_state = 64},
  [2332] = {.lex_state = 7},
  [2333] = {.lex_state = 7},
  [2334] = {.lex_state = 7},
  [2335] = {.lex_state = 7},
  [2336] = {.lex_state = 7},
  [2337] = {.lex_state = 7},
  [2338] = {.lex_state = 7},
  [2339] = {.lex_state = 7},
  [2340] = {.lex_state = 7},
  [2341] = {.lex_state = 7},
  [2342] = {.lex_state = 7},
  [2343] = {.lex_state = 15},
  [2344] = {.lex_state = 7},
  [2345] = {.lex_state = 64},
  [2346] = {.lex_state = 7},
  [2347] = {.lex_state = 7},
  [2348] = {.lex_state = 7},
  [2349] = {.lex_state = 7},
  [2350] = {.lex_state = 7},
  [2351] = {.lex_state = 7},
  [2352] = {.lex_state = 7},
  [2353] = {.lex_state = 7},
  [2354] = {.lex_state = 7},
  [2355] = {.lex_state = 7},
  [2356] = {.lex_state = 7},
  [2357] = {.lex_state = 7},
  [2358] = {.lex_state = 7},
  [2359] = {.lex_state = 7},
  [2360] = {.lex_state = 7},
  [2361] = {.lex_state = 7},
  [2362] = {.lex_state = 7},
  [2363] = {.lex_state = 7},
  [2364] = {.lex_state = 7},
  [2365] = {.lex_state = 7},
  [2366] = {.lex_state = 7},
  [2367] = {.lex_state = 7},
  [2368] = {.lex_state = 7},
  [2369] = {.lex_state = 7},
  [2370] = {.lex_state = 7},
  [2371] = {.lex_state = 7},
  [2372] = {.lex_state = 50},
  [2373] = {.lex_state = 50},
  [2374] = {.lex_state = 64},
  [2375] = {.lex_state = 58},
  [2376] = {.lex_state = 7},
  [2377] = {.lex_state = 7},
  [2378] = {.lex_state = 58},
  [2379] = {.lex_state = 7},
  [2380] = {.lex_state = 7},
  [2381] = {.lex_state = 7},
  [2382] = {.lex_state = 7},
  [2383] = {.lex_state = 58},
  [2384] = {.lex_state = 7},
  [2385] = {.lex_state = 7},
  [2386] = {.lex_state = 64},
  [2387] = {.lex_state = 7},
  [2388] = {.lex_state = 7},
  [2389] = {.lex_state = 35},
  [2390] = {.lex_state = 35},
  [2391] = {.lex_state = 7},
  [2392] = {.lex_state = 58},
  [2393] = {.lex_state = 58},
  [2394] = {.lex_state = 7},
  [2395] = {.lex_state = 58},
  [2396] = {.lex_state = 58},
  [2397] = {.lex_state = 58},
  [2398] = {.lex_state = 58},
  [2399] = {.lex_state = 58},
  [2400] = {.lex_state = 58},
  [2401] = {.lex_state = 58},
  [2402] = {.lex_state = 58},
  [2403] = {.lex_state = 58},
  [2404] = {.lex_state = 58},
  [2405] = {.lex_state = 58},
  [2406] = {.lex_state = 58},
  [2407] = {.lex_state = 58},
  [2408] = {.lex_state = 58},
  [2409] = {.lex_state = 58},
  [2410] = {.lex_state = 58},
  [2411] = {.lex_state = 58},
  [2412] = {.lex_state = 58},
  [2413] = {.lex_state = 58},
  [2414] = {.lex_state = 58},
  [2415] = {.lex_state = 58},
  [2416] = {.lex_state = 58},
  [2417] = {.lex_state = 58},
  [2418] = {.lex_state = 58},
  [2419] = {.lex_state = 58},
  [2420] = {.lex_state = 58},
  [2421] = {.lex_state = 58},
  [2422] = {.lex_state = 58},
  [2423] = {.lex_state = 58},
  [2424] = {.lex_state = 58},
  [2425] = {.lex_state = 58},
  [2426] = {.lex_state = 58},
  [2427] = {.lex_state = 58},
  [2428] = {.lex_state = 58},
  [2429] = {.lex_state = 58},
  [2430] = {.lex_state = 58},
  [2431] = {.lex_state = 58},
  [2432] = {.lex_state = 58},
  [2433] = {.lex_state = 58},
  [2434] = {.lex_state = 58},
  [2435] = {.lex_state = 58},
  [2436] = {.lex_state = 58},
  [2437] = {.lex_state = 58},
  [2438] = {.lex_state = 58},
  [2439] = {.lex_state = 58},
  [2440] = {.lex_state = 58},
  [2441] = {.lex_state = 58},
  [2442] = {.lex_state = 58},
  [2443] = {.lex_state = 58},
  [2444] = {.lex_state = 58},
  [2445] = {.lex_state = 58},
  [2446] = {.lex_state = 58},
  [2447] = {.lex_state = 58},
  [2448] = {.lex_state = 58},
  [2449] = {.lex_state = 58},
  [2450] = {.lex_state = 58},
  [2451] = {.lex_state = 58},
  [2452] = {.lex_state = 58},
  [2453] = {.lex_state = 58},
  [2454] = {.lex_state = 58},
  [2455] = {.lex_state = 58},
  [2456] = {.lex_state = 58},
  [2457] = {.lex_state = 58},
  [2458] = {.lex_state = 58},
  [2459] = {.lex_state = 58},
  [2460] = {.lex_state = 58},
  [2461] = {.lex_state = 58},
  [2462] = {.lex_state = 58},
  [2463] = {.lex_state = 58},
  [2464] = {.lex_state = 58},
  [2465] = {.lex_state = 58},
  [2466] = {.lex_state = 58},
  [2467] = {.lex_state = 58},
  [2468] = {.lex_state = 58},
  [2469] = {.lex_state = 58},
  [2470] = {.lex_state = 58},
  [2471] = {.lex_state = 58},
  [2472] = {.lex_state = 58},
  [2473] = {.lex_state = 58},
  [2474] = {.lex_state = 58},
  [2475] = {.lex_state = 58},
  [2476] = {.lex_state = 58},
  [2477] = {.lex_state = 58},
  [2478] = {.lex_state = 58},
  [2479] = {.lex_state = 58},
  [2480] = {.lex_state = 58},
  [2481] = {.lex_state = 58},
  [2482] = {.lex_state = 58},
  [2483] = {.lex_state = 58},
  [2484] = {.lex_state = 58},
  [2485] = {.lex_state = 58},
  [2486] = {.lex_state = 58},
  [2487] = {.lex_state = 58},
  [2488] = {.lex_state = 58},
  [2489] = {.lex_state = 58},
  [2490] = {.lex_state = 58},
  [2491] = {.lex_state = 58},
  [2492] = {.lex_state = 58},
  [2493] = {.lex_state = 58},
  [2494] = {.lex_state = 58},
  [2495] = {.lex_state = 58},
  [2496] = {.lex_state = 58},
  [2497] = {.lex_state = 58},
  [2498] = {.lex_state = 58},
  [2499] = {.lex_state = 58},
  [2500] = {.lex_state = 58},
  [2501] = {.lex_state = 58},
  [2502] = {.lex_state = 58},
  [2503] = {.lex_state = 58},
  [2504] = {.lex_state = 12},
  [2505] = {.lex_state = 60},
  [2506] = {.lex_state = 58},
  [2507] = {.lex_state = 58},
  [2508] = {.lex_state = 58},
  [2509] = {.lex_state = 58},
  [2510] = {.lex_state = 58},
  [2511] = {.lex_state = 12},
  [2512] = {.lex_state = 58},
  [2513] = {.lex_state = 60},
  [2514] = {.lex_state = 58},
  [2515] = {.lex_state = 12},
  [2516] = {.lex_state = 58},
  [2517] = {.lex_state = 60},
  [2518] = {.lex_state = 12},
  [2519] = {.lex_state = 58},
  [2520] = {.lex_state = 60},
  [2521] = {.lex_state = 58},
  [2522] = {.lex_state = 12},
  [2523] = {.lex_state = 12},
  [2524] = {.lex_state = 60},
  [2525] = {.lex_state = 15},
  [2526] = {.lex_state = 60},
  [2527] = {.lex_state = 12},
  [2528] = {.lex_state = 12},
  [2529] = {.lex_state = 17},
  [2530] = {.lex_state = 12},
  [2531] = {.lex_state = 12},
  [2532] = {.lex_state = 17},
  [2533] = {.lex_state = 17},
  [2534] = {.lex_state = 60},
  [2535] = {.lex_state = 12},
  [2536] = {.lex_state = 60},
  [2537] = {.lex_state = 60},
  [2538] = {.lex_state = 60},
  [2539] = {.lex_state = 12},
  [2540] = {.lex_state = 60},
  [2541] = {.lex_state = 58},
  [2542] = {.lex_state = 58},
  [2543] = {.lex_state = 58},
  [2544] = {.lex_state = 58},
  [2545] = {.lex_state = 52},
  [2546] = {.lex_state = 58},
  [2547] = {.lex_state = 58},
  [2548] = {.lex_state = 60},
  [2549] = {.lex_state = 40},
  [2550] = {.lex_state = 40},
  [2551] = {.lex_state = 60},
  [2552] = {.lex_state = 58},
  [2553] = {.lex_state = 7},
  [2554] = {.lex_state = 58},
  [2555] = {.lex_state = 58},
  [2556] = {.lex_state = 7},
  [2557] = {.lex_state = 60},
  [2558] = {.lex_state = 58},
  [2559] = {.lex_state = 58},
  [2560] = {.lex_state = 58},
  [2561] = {.lex_state = 12},
  [2562] = {.lex_state = 58},
  [2563] = {.lex_state = 58},
  [2564] = {.lex_state = 12},
  [2565] = {.lex_state = 58},
  [2566] = {.lex_state = 60},
  [2567] = {.lex_state = 60},
  [2568] = {.lex_state = 60},
  [2569] = {.lex_state = 52},
  [2570] = {.lex_state = 58},
  [2571] = {.lex_state = 10},
  [2572] = {.lex_state = 10},
  [2573] = {.lex_state = 60},
  [2574] = {.lex_state = 60},
  [2575] = {.lex_state = 58},
  [2576] = {.lex_state = 60},
  [2577] = {.lex_state = 58},
  [2578] = {.lex_state = 60},
  [2579] = {.lex_state = 60},
  [2580] = {.lex_state = 58},
  [2581] = {.lex_state = 58},
  [2582] = {.lex_state = 58},
  [2583] = {.lex_state = 58},
  [2584] = {.lex_state = 58},
  [2585] = {.lex_state = 12},
  [2586] = {.lex_state = 58},
  [2587] = {.lex_state = 58},
  [2588] = {.lex_state = 58},
  [2589] = {.lex_state = 60},
  [2590] = {.lex_state = 58},
  [2591] = {.lex_state = 60},
  [2592] = {.lex_state = 58},
  [2593] = {.lex_state = 58},
  [2594] = {.lex_state = 58},
  [2595] = {.lex_state = 62},
  [2596] = {.lex_state = 58},
  [2597] = {.lex_state = 58},
  [2598] = {.lex_state = 58},
  [2599] = {.lex_state = 60},
  [2600] = {.lex_state = 58},
  [2601] = {.lex_state = 60},
  [2602] = {.lex_state = 58},
  [2603] = {.lex_state = 58},
  [2604] = {.lex_state = 58},
  [2605] = {.lex_state = 58},
  [2606] = {.lex_state = 60},
  [2607] = {.lex_state = 58},
  [2608] = {.lex_state = 58},
  [2609] = {.lex_state = 12},
  [2610] = {.lex_state = 58},
  [2611] = {.lex_state = 12},
  [2612] = {.lex_state = 58},
  [2613] = {.lex_state = 58},
  [2614] = {.lex_state = 58},
  [2615] = {.lex_state = 58},
  [2616] = {.lex_state = 58},
  [2617] = {.lex_state = 58},
  [2618] = {.lex_state = 12},
  [2619] = {.lex_state = 58},
  [2620] = {.lex_state = 58},
  [2621] = {.lex_state = 12},
  [2622] = {.lex_state = 12},
  [2623] = {.lex_state = 60},
  [2624] = {.lex_state = 60},
  [2625] = {.lex_state = 12},
  [2626] = {.lex_state = 12},
  [2627] = {.lex_state = 60},
  [2628] = {.lex_state = 12},
  [2629] = {.lex_state = 12},
  [2630] = {.lex_state = 12},
  [2631] = {.lex_state = 12},
  [2632] = {.lex_state = 12},
  [2633] = {.lex_state = 12},
  [2634] = {.lex_state = 60},
  [2635] = {.lex_state = 60},
  [2636] = {.lex_state = 12},
  [2637] = {.lex_state = 12},
  [2638] = {.lex_state = 60},
  [2639] = {.lex_state = 68},
  [2640] = {.lex_state = 58},
  [2641] = {.lex_state = 60},
  [2642] = {.lex_state = 60},
  [2643] = {.lex_state = 58},
  [2644] = {.lex_state = 58},
  [2645] = {.lex_state = 68},
  [2646] = {.lex_state = 58},
  [2647] = {.lex_state = 58},
  [2648] = {.lex_state = 60},
  [2649] = {.lex_state = 60},
  [2650] = {.lex_state = 60},
  [2651] = {.lex_state = 60},
  [2652] = {.lex_state = 58},
  [2653] = {.lex_state = 60},
  [2654] = {.lex_state = 60},
  [2655] = {.lex_state = 58},
  [2656] = {.lex_state = 58},
  [2657] = {.lex_state = 62},
  [2658] = {.lex_state = 60},
  [2659] = {.lex_state = 60},
  [2660] = {.lex_state = 60},
  [2661] = {.lex_state = 60},
  [2662] = {.lex_state = 60},
  [2663] = {.lex_state = 60},
  [2664] = {.lex_state = 60},
  [2665] = {.lex_state = 60},
  [2666] = {.lex_state = 60},
  [2667] = {.lex_state = 60},
  [2668] = {.lex_state = 60},
  [2669] = {.lex_state = 12},
  [2670] = {.lex_state = 68},
  [2671] = {.lex_state = 12},
  [2672] = {.lex_state = 60},
  [2673] = {.lex_state = 60},
  [2674] = {.lex_state = 12},
  [2675] = {.lex_state = 12},
  [2676] = {.lex_state = 12},
  [2677] = {.lex_state = 60},
  [2678] = {.lex_state = 60},
  [2679] = {.lex_state = 60},
  [2680] = {.lex_state = 60},
  [2681] = {.lex_state = 60},
  [2682] = {.lex_state = 60},
  [2683] = {.lex_state = 60},
  [2684] = {.lex_state = 60},
  [2685] = {.lex_state = 60},
  [2686] = {.lex_state = 60},
  [2687] = {.lex_state = 58},
  [2688] = {.lex_state = 58},
  [2689] = {.lex_state = 58},
  [2690] = {.lex_state = 12},
  [2691] = {.lex_state = 12},
  [2692] = {.lex_state = 60},
  [2693] = {.lex_state = 60},
  [2694] = {.lex_state = 58},
  [2695] = {.lex_state = 60},
  [2696] = {.lex_state = 12},
  [2697] = {.lex_state = 60},
  [2698] = {.lex_state = 58},
  [2699] = {.lex_state = 60},
  [2700] = {.lex_state = 58},
  [2701] = {.lex_state = 58},
  [2702] = {.lex_state = 60},
  [2703] = {.lex_state = 58},
  [2704] = {.lex_state = 58},
  [2705] = {.lex_state = 60},
  [2706] = {.lex_state = 60},
  [2707] = {.lex_state = 60},
  [2708] = {.lex_state = 60},
  [2709] = {.lex_state = 60},
  [2710] = {.lex_state = 58},
  [2711] = {.lex_state = 54},
  [2712] = {.lex_state = 60},
  [2713] = {.lex_state = 60},
  [2714] = {.lex_state = 12},
  [2715] = {.lex_state = 12},
  [2716] = {.lex_state = 58},
  [2717] = {.lex_state = 60},
  [2718] = {.lex_state = 68},
  [2719] = {.lex_state = 68},
  [2720] = {.lex_state = 58},
  [2721] = {.lex_state = 60},
  [2722] = {.lex_state = 60},
  [2723] = {.lex_state = 12},
  [2724] = {.lex_state = 12},
  [2725] = {.lex_state = 54},
  [2726] = {.lex_state = 58},
  [2727] = {.lex_state = 12},
  [2728] = {.lex_state = 58},
  [2729] = {.lex_state = 12},
  [2730] = {.lex_state = 60},
  [2731] = {.lex_state = 60},
  [2732] = {.lex_state = 60},
  [2733] = {.lex_state = 60},
  [2734] = {.lex_state = 12},
  [2735] = {.lex_state = 60},
  [2736] = {.lex_state = 60},
  [2737] = {.lex_state = 60},
  [2738] = {.lex_state = 60},
  [2739] = {.lex_state = 60},
  [2740] = {.lex_state = 12},
  [2741] = {.lex_state = 12},
  [2742] = {.lex_state = 12},
  [2743] = {.lex_state = 58},
  [2744] = {.lex_state = 58},
  [2745] = {.lex_state = 58},
  [2746] = {.lex_state = 42},
  [2747] = {.lex_state = 60},
  [2748] = {.lex_state = 60},
  [2749] = {.lex_state = 62},
  [2750] = {.lex_state = 68},
  [2751] = {.lex_state = 60},
  [2752] = {.lex_state = 60},
  [2753] = {.lex_state = 58},
  [2754] = {.lex_state = 42},
  [2755] = {.lex_state = 58},
  [2756] = {.lex_state = 58},
  [2757] = {.lex_state = 60},
  [2758] = {.lex_state = 58},
  [2759] = {.lex_state = 58},
  [2760] = {.lex_state = 60},
  [2761] = {.lex_state = 60},
  [2762] = {.lex_state = 60},
  [2763] = {.lex_state = 60},
  [2764] = {.lex_state = 60},
  [2765] = {.lex_state = 58},
  [2766] = {.lex_state = 58},
  [2767] = {.lex_state = 60},
  [2768] = {.lex_state = 68},
  [2769] = {.lex_state = 60},
  [2770] = {.lex_state = 60},
  [2771] = {.lex_state = 60},
  [2772] = {.lex_state = 60},
  [2773] = {.lex_state = 60},
  [2774] = {.lex_state = 58},
  [2775] = {.lex_state = 60},
  [2776] = {.lex_state = 60},
  [2777] = {.lex_state = 58},
  [2778] = {.lex_state = 60},
  [2779] = {.lex_state = 58},
  [2780] = {.lex_state = 68},
  [2781] = {.lex_state = 60},
  [2782] = {.lex_state = 60},
  [2783] = {.lex_state = 60},
  [2784] = {.lex_state = 60},
  [2785] = {.lex_state = 12},
  [2786] = {.lex_state = 60},
  [2787] = {.lex_state = 60},
  [2788] = {.lex_state = 60},
  [2789] = {.lex_state = 60},
  [2790] = {.lex_state = 60},
  [2791] = {.lex_state = 60},
  [2792] = {.lex_state = 60},
  [2793] = {.lex_state = 12},
  [2794] = {.lex_state = 58},
  [2795] = {.lex_state = 60},
  [2796] = {.lex_state = 68},
  [2797] = {.lex_state = 12},
  [2798] = {.lex_state = 60},
  [2799] = {.lex_state = 60},
  [2800] = {.lex_state = 62},
  [2801] = {.lex_state = 58},
  [2802] = {.lex_state = 60},
  [2803] = {.lex_state = 12},
  [2804] = {.lex_state = 12},
  [2805] = {.lex_state = 12},
  [2806] = {.lex_state = 58},
  [2807] = {.lex_state = 58},
  [2808] = {.lex_state = 12},
  [2809] = {.lex_state = 12},
  [2810] = {.lex_state = 12},
  [2811] = {.lex_state = 12},
  [2812] = {.lex_state = 12},
  [2813] = {.lex_state = 12},
  [2814] = {.lex_state = 68},
  [2815] = {.lex_state = 12},
  [2816] = {.lex_state = 12},
  [2817] = {.lex_state = 12},
  [2818] = {.lex_state = 12},
  [2819] = {.lex_state = 12},
  [2820] = {.lex_state = 12},
  [2821] = {.lex_state = 12},
  [2822] = {.lex_state = 12},
  [2823] = {.lex_state = 12},
  [2824] = {.lex_state = 12},
  [2825] = {.lex_state = 12},
  [2826] = {.lex_state = 12},
  [2827] = {.lex_state = 12},
  [2828] = {.lex_state = 12},
  [2829] = {.lex_state = 12},
  [2830] = {.lex_state = 12},
  [2831] = {.lex_state = 60},
  [2832] = {.lex_state = 68},
  [2833] = {.lex_state = 60},
  [2834] = {.lex_state = 12},
  [2835] = {.lex_state = 58},
  [2836] = {.lex_state = 12},
  [2837] = {.lex_state = 12},
  [2838] = {.lex_state = 12},
  [2839] = {.lex_state = 58},
  [2840] = {.lex_state = 12},
  [2841] = {.lex_state = 60},
  [2842] = {.lex_state = 12},
  [2843] = {.lex_state = 58},
  [2844] = {.lex_state = 12},
  [2845] = {.lex_state = 12},
  [2846] = {.lex_state = 12},
  [2847] = {.lex_state = 12},
  [2848] = {.lex_state = 12},
  [2849] = {.lex_state = 12},
  [2850] = {.lex_state = 12},
  [2851] = {.lex_state = 12},
  [2852] = {.lex_state = 58},
  [2853] = {.lex_state = 60},
  [2854] = {.lex_state = 12},
  [2855] = {.lex_state = 12},
  [2856] = {.lex_state = 58},
  [2857] = {.lex_state = 12},
  [2858] = {.lex_state = 12},
  [2859] = {.lex_state = 12},
  [2860] = {.lex_state = 12},
  [2861] = {.lex_state = 58},
  [2862] = {.lex_state = 12},
  [2863] = {.lex_state = 58},
  [2864] = {.lex_state = 12},
  [2865] = {.lex_state = 58},
  [2866] = {.lex_state = 58},
  [2867] = {.lex_state = 58},
  [2868] = {.lex_state = 68},
  [2869] = {.lex_state = 58},
  [2870] = {.lex_state = 58},
  [2871] = {.lex_state = 58},
  [2872] = {.lex_state = 58},
  [2873] = {.lex_state = 12},
  [2874] = {.lex_state = 68},
  [2875] = {.lex_state = 58},
  [2876] = {.lex_state = 12},
  [2877] = {.lex_state = 12},
  [2878] = {.lex_state = 12},
  [2879] = {.lex_state = 68},
  [2880] = {.lex_state = 12},
  [2881] = {.lex_state = 12},
  [2882] = {.lex_state = 12},
  [2883] = {.lex_state = 12},
  [2884] = {.lex_state = 12},
  [2885] = {.lex_state = 58},
  [2886] = {.lex_state = 68},
  [2887] = {.lex_state = 58},
  [2888] = {.lex_state = 12},
  [2889] = {.lex_state = 12},
  [2890] = {.lex_state = 58},
  [2891] = {.lex_state = 12},
  [2892] = {.lex_state = 58},
  [2893] = {.lex_state = 58},
  [2894] = {.lex_state = 68},
  [2895] = {.lex_state = 12},
  [2896] = {.lex_state = 58},
  [2897] = {.lex_state = 12},
  [2898] = {.lex_state = 58},
  [2899] = {.lex_state = 68},
  [2900] = {.lex_state = 58},
  [2901] = {.lex_state = 58},
  [2902] = {.lex_state = 12},
  [2903] = {.lex_state = 58},
  [2904] = {.lex_state = 58},
  [2905] = {.lex_state = 66},
  [2906] = {.lex_state = 58},
  [2907] = {.lex_state = 58},
  [2908] = {.lex_state = 58},
  [2909] = {.lex_state = 66},
  [2910] = {.lex_state = 58},
  [2911] = {.lex_state = 58},
  [2912] = {.lex_state = 62},
  [2913] = {.lex_state = 58},
  [2914] = {.lex_state = 58},
  [2915] = {.lex_state = 58},
  [2916] = {.lex_state = 66},
  [2917] = {.lex_state = 58},
  [2918] = {.lex_state = 62},
  [2919] = {.lex_state = 58},
  [2920] = {.lex_state = 58},
  [2921] = {.lex_state = 58},
  [2922] = {.lex_state = 58},
  [2923] = {.lex_state = 58},
  [2924] = {.lex_state = 58},
  [2925] = {.lex_state = 58},
  [2926] = {.lex_state = 58},
  [2927] = {.lex_state = 58},
  [2928] = {.lex_state = 58},
  [2929] = {.lex_state = 66},
  [2930] = {.lex_state = 58},
  [2931] = {.lex_state = 68},
  [2932] = {.lex_state = 62},
  [2933] = {.lex_state = 58},
  [2934] = {.lex_state = 58},
  [2935] = {.lex_state = 62},
  [2936] = {.lex_state = 58},
  [2937] = {.lex_state = 62},
  [2938] = {.lex_state = 17},
  [2939] = {.lex_state = 62},
  [2940] = {.lex_state = 17},
  [2941] = {.lex_state = 68},
  [2942] = {.lex_state = 62},
  [2943] = {.lex_state = 58},
  [2944] = {.lex_state = 58},
  [2945] = {.lex_state = 58},
  [2946] = {.lex_state = 58},
  [2947] = {.lex_state = 62},
  [2948] = {.lex_state = 58},
  [2949] = {.lex_state = 62},
  [2950] = {.lex_state = 58},
  [2951] = {.lex_state = 58},
  [2952] = {.lex_state = 62},
  [2953] = {.lex_state = 68},
  [2954] = {.lex_state = 62},
  [2955] = {.lex_state = 62},
  [2956] = {.lex_state = 62},
  [2957] = {.lex_state = 62},
  [2958] = {.lex_state = 58},
  [2959] = {.lex_state = 17},
  [2960] = {.lex_state = 58},
  [2961] = {.lex_state = 62},
  [2962] = {.lex_state = 62},
  [2963] = {.lex_state = 68},
  [2964] = {.lex_state = 62},
  [2965] = {.lex_state = 62},
  [2966] = {.lex_state = 62},
  [2967] = {.lex_state = 58},
  [2968] = {.lex_state = 62},
  [2969] = {.lex_state = 62},
  [2970] = {.lex_state = 62},
  [2971] = {.lex_state = 62},
  [2972] = {.lex_state = 62},
  [2973] = {.lex_state = 62},
  [2974] = {.lex_state = 58},
  [2975] = {.lex_state = 62},
  [2976] = {.lex_state = 62},
  [2977] = {.lex_state = 62},
  [2978] = {.lex_state = 62},
  [2979] = {.lex_state = 62},
  [2980] = {.lex_state = 62},
  [2981] = {.lex_state = 58},
  [2982] = {.lex_state = 58},
  [2983] = {.lex_state = 58},
  [2984] = {.lex_state = 58},
  [2985] = {.lex_state = 58},
  [2986] = {.lex_state = 58},
  [2987] = {.lex_state = 58},
  [2988] = {.lex_state = 58},
  [2989] = {.lex_state = 58},
  [2990] = {.lex_state = 58},
  [2991] = {.lex_state = 58},
  [2992] = {.lex_state = 58},
  [2993] = {.lex_state = 58},
  [2994] = {.lex_state = 58},
  [2995] = {.lex_state = 58},
  [2996] = {.lex_state = 58},
  [2997] = {.lex_state = 58},
  [2998] = {.lex_state = 58},
  [2999] = {.lex_state = 58},
  [3000] = {.lex_state = 58},
  [3001] = {.lex_state = 58},
  [3002] = {.lex_state = 58},
  [3003] = {.lex_state = 58},
  [3004] = {.lex_state = 58},
  [3005] = {.lex_state = 58},
  [3006] = {.lex_state = 58},
  [3007] = {.lex_state = 58},
  [3008] = {.lex_state = 58},
  [3009] = {.lex_state = 58},
  [3010] = {.lex_state = 58},
  [3011] = {.lex_state = 58},
  [3012] = {.lex_state = 58},
  [3013] = {.lex_state = 58},
  [3014] = {.lex_state = 58},
  [3015] = {.lex_state = 58},
  [3016] = {.lex_state = 58},
  [3017] = {.lex_state = 58},
  [3018] = {.lex_state = 58},
  [3019] = {.lex_state = 58},
  [3020] = {.lex_state = 58},
  [3021] = {.lex_state = 58},
  [3022] = {.lex_state = 58},
  [3023] = {.lex_state = 58},
  [3024] = {.lex_state = 58},
  [3025] = {.lex_state = 58},
  [3026] = {.lex_state = 58},
  [3027] = {.lex_state = 58},
  [3028] = {.lex_state = 58},
  [3029] = {.lex_state = 58},
  [3030] = {.lex_state = 58},
  [3031] = {.lex_state = 58},
  [3032] = {.lex_state = 58},
  [3033] = {.lex_state = 58},
  [3034] = {.lex_state = 58},
  [3035] = {.lex_state = 58},
  [3036] = {.lex_state = 58},
  [3037] = {.lex_state = 58},
  [3038] = {.lex_state = 58},
  [3039] = {.lex_state = 58},
  [3040] = {.lex_state = 58},
  [3041] = {.lex_state = 58},
  [3042] = {.lex_state = 58},
  [3043] = {.lex_state = 58},
  [3044] = {.lex_state = 58},
  [3045] = {.lex_state = 58},
  [3046] = {.lex_state = 58},
  [3047] = {.lex_state = 58},
  [3048] = {.lex_state = 58},
  [3049] = {.lex_state = 58},
  [3050] = {.lex_state = 58},
  [3051] = {.lex_state = 58},
  [3052] = {.lex_state = 58},
  [3053] = {.lex_state = 58},
  [3054] = {.lex_state = 58},
  [3055] = {.lex_state = 58},
  [3056] = {.lex_state = 58},
  [3057] = {.lex_state = 58},
  [3058] = {.lex_state = 58},
  [3059] = {.lex_state = 58},
  [3060] = {.lex_state = 68},
  [3061] = {.lex_state = 68},
  [3062] = {.lex_state = 68},
  [3063] = {.lex_state = 68},
  [3064] = {.lex_state = 68},
  [3065] = {.lex_state = 68},
  [3066] = {.lex_state = 68},
  [3067] = {.lex_state = 68},
  [3068] = {.lex_state = 68},
  [3069] = {.lex_state = 68},
  [3070] = {.lex_state = 68},
  [3071] = {.lex_state = 68},
  [3072] = {.lex_state = 68},
  [3073] = {.lex_state = 68},
  [3074] = {.lex_state = 68},
  [3075] = {.lex_state = 68},
  [3076] = {.lex_state = 68},
  [3077] = {.lex_state = 68},
  [3078] = {.lex_state = 68},
  [3079] = {.lex_state = 68},
  [3080] = {.lex_state = 68},
  [3081] = {.lex_state = 68},
  [3082] = {.lex_state = 68},
  [3083] = {.lex_state = 68},
  [3084] = {.lex_state = 68},
  [3085] = {.lex_state = 68},
  [3086] = {.lex_state = 68},
  [3087] = {.lex_state = 68},
  [3088] = {.lex_state = 68},
  [3089] = {.lex_state = 68},
  [3090] = {.lex_state = 68},
  [3091] = {.lex_state = 68},
  [3092] = {.lex_state = 68},
  [3093] = {.lex_state = 68},
  [3094] = {.lex_state = 68},
  [3095] = {.lex_state = 68},
  [3096] = {.lex_state = 68},
  [3097] = {.lex_state = 68},
  [3098] = {.lex_state = 68},
  [3099] = {.lex_state = 68},
  [3100] = {.lex_state = 68},
  [3101] = {.lex_state = 68},
  [3102] = {.lex_state = 68},
  [3103] = {.lex_state = 68},
  [3104] = {.lex_state = 68},
  [3105] = {.lex_state = 68},
  [3106] = {.lex_state = 68},
  [3107] = {.lex_state = 68},
  [3108] = {.lex_state = 68},
  [3109] = {.lex_state = 68},
  [3110] = {.lex_state = 68},
  [3111] = {.lex_state = 68},
  [3112] = {.lex_state = 68},
  [3113] = {.lex_state = 68},
  [3114] = {.lex_state = 68},
  [3115] = {.lex_state = 68},
  [3116] = {.lex_state = 68},
  [3117] = {.lex_state = 68},
  [3118] = {.lex_state = 68},
  [3119] = {.lex_state = 68},
  [3120] = {.lex_state = 68},
  [3121] = {.lex_state = 68},
  [3122] = {.lex_state = 68},
  [3123] = {.lex_state = 68},
  [3124] = {.lex_state = 68},
  [3125] = {.lex_state = 68},
  [3126] = {.lex_state = 68},
  [3127] = {.lex_state = 68},
  [3128] = {.lex_state = 68},
  [3129] = {.lex_state = 68},
  [3130] = {.lex_state = 68},
  [3131] = {.lex_state = 68},
  [3132] = {.lex_state = 68},
  [3133] = {.lex_state = 68},
  [3134] = {.lex_state = 68},
  [3135] = {.lex_state = 68},
  [3136] = {.lex_state = 68},
  [3137] = {.lex_state = 68},
  [3138] = {.lex_state = 68},
  [3139] = {.lex_state = 68},
  [3140] = {.lex_state = 68},
  [3141] = {.lex_state = 68},
  [3142] = {.lex_state = 68},
  [3143] = {.lex_state = 68},
  [3144] = {.lex_state = 68},
  [3145] = {.lex_state = 68},
  [3146] = {.lex_state = 68},
  [3147] = {.lex_state = 68},
  [3148] = {.lex_state = 68},
  [3149] = {.lex_state = 68},
  [3150] = {.lex_state = 68},
  [3151] = {.lex_state = 68},
  [3152] = {.lex_state = 68},
  [3153] = {.lex_state = 68},
  [3154] = {.lex_state = 68},
  [3155] = {.lex_state = 68},
  [3156] = {.lex_state = 68},
  [3157] = {.lex_state = 68},
  [3158] = {.lex_state = 68},
  [3159] = {.lex_state = 68},
  [3160] = {.lex_state = 68},
  [3161] = {.lex_state = 68},
  [3162] = {.lex_state = 68},
  [3163] = {.lex_state = 68},
  [3164] = {.lex_state = 68},
  [3165] = {.lex_state = 68},
  [3166] = {.lex_state = 68},
  [3167] = {.lex_state = 68},
  [3168] = {.lex_state = 68},
  [3169] = {.lex_state = 68},
  [3170] = {.lex_state = 68},
  [3171] = {.lex_state = 68},
  [3172] = {.lex_state = 68},
  [3173] = {.lex_state = 68},
  [3174] = {.lex_state = 68},
  [3175] = {.lex_state = 68},
  [3176] = {.lex_state = 68},
  [3177] = {.lex_state = 68},
  [3178] = {.lex_state = 68},
  [3179] = {.lex_state = 68},
  [3180] = {.lex_state = 68},
  [3181] = {.lex_state = 68},
  [3182] = {.lex_state = 68},
  [3183] = {.lex_state = 68},
  [3184] = {.lex_state = 68},
  [3185] = {.lex_state = 68},
  [3186] = {.lex_state = 68},
  [3187] = {.lex_state = 68},
  [3188] = {.lex_state = 68},
  [3189] = {.lex_state = 68},
  [3190] = {.lex_state = 68},
  [3191] = {.lex_state = 68},
  [3192] = {.lex_state = 68},
  [3193] = {.lex_state = 68},
  [3194] = {.lex_state = 68},
  [3195] = {.lex_state = 68},
  [3196] = {.lex_state = 68},
  [3197] = {.lex_state = 68},
  [3198] = {.lex_state = 68},
  [3199] = {.lex_state = 68},
  [3200] = {.lex_state = 68},
  [3201] = {.lex_state = 68},
  [3202] = {.lex_state = 68},
  [3203] = {.lex_state = 68},
  [3204] = {.lex_state = 68},
  [3205] = {.lex_state = 68},
  [3206] = {.lex_state = 68},
  [3207] = {.lex_state = 68},
  [3208] = {.lex_state = 68},
  [3209] = {.lex_state = 68},
  [3210] = {.lex_state = 68},
  [3211] = {.lex_state = 68},
  [3212] = {.lex_state = 68},
  [3213] = {.lex_state = 68},
  [3214] = {.lex_state = 68},
  [3215] = {.lex_state = 68},
  [3216] = {.lex_state = 68},
  [3217] = {.lex_state = 68},
  [3218] = {.lex_state = 68},
  [3219] = {.lex_state = 68},
  [3220] = {.lex_state = 68},
  [3221] = {.lex_state = 68},
  [3222] = {.lex_state = 68},
  [3223] = {.lex_state = 68},
  [3224] = {.lex_state = 68},
  [3225] = {.lex_state = 68},
  [3226] = {.lex_state = 68},
  [3227] = {.lex_state = 68},
  [3228] = {.lex_state = 68},
  [3229] = {.lex_state = 68},
  [3230] = {.lex_state = 68},
  [3231] = {.lex_state = 68},
  [3232] = {.lex_state = 68},
  [3233] = {.lex_state = 68},
  [3234] = {.lex_state = 68},
  [3235] = {.lex_state = 68},
  [3236] = {.lex_state = 68},
  [3237] = {.lex_state = 68},
  [3238] = {.lex_state = 68},
  [3239] = {.lex_state = 68},
  [3240] = {.lex_state = 68},
  [3241] = {.lex_state = 68},
  [3242] = {.lex_state = 68},
  [3243] = {.lex_state = 68},
  [3244] = {.lex_state = 68},
  [3245] = {.lex_state = 68},
  [3246] = {.lex_state = 68},
  [3247] = {.lex_state = 68},
  [3248] = {.lex_state = 68},
  [3249] = {.lex_state = 68},
  [3250] = {.lex_state = 68},
  [3251] = {.lex_state = 68},
  [3252] = {.lex_state = 68},
  [3253] = {.lex_state = 68},
  [3254] = {.lex_state = 68},
  [3255] = {.lex_state = 68},
  [3256] = {.lex_state = 68},
  [3257] = {.lex_state = 68},
  [3258] = {.lex_state = 68},
  [3259] = {.lex_state = 68},
  [3260] = {.lex_state = 68},
  [3261] = {.lex_state = 68},
  [3262] = {.lex_state = 68},
  [3263] = {.lex_state = 68},
  [3264] = {.lex_state = 68},
  [3265] = {.lex_state = 68},
  [3266] = {.lex_state = 68},
  [3267] = {.lex_state = 68},
  [3268] = {.lex_state = 68},
  [3269] = {.lex_state = 68},
  [3270] = {.lex_state = 68},
  [3271] = {.lex_state = 68},
  [3272] = {.lex_state = 68},
  [3273] = {.lex_state = 68},
  [3274] = {.lex_state = 68},
  [3275] = {.lex_state = 68},
  [3276] = {.lex_state = 68},
  [3277] = {.lex_state = 68},
  [3278] = {.lex_state = 68},
  [3279] = {.lex_state = 68},
  [3280] = {.lex_state = 68},
  [3281] = {.lex_state = 68},
  [3282] = {.lex_state = 68},
  [3283] = {.lex_state = 68},
  [3284] = {.lex_state = 68},
  [3285] = {.lex_state = 68},
  [3286] = {.lex_state = 68},
  [3287] = {.lex_state = 68},
  [3288] = {.lex_state = 68},
  [3289] = {.lex_state = 68},
  [3290] = {.lex_state = 68},
  [3291] = {.lex_state = 68},
  [3292] = {.lex_state = 68},
  [3293] = {.lex_state = 68},
  [3294] = {.lex_state = 68},
  [3295] = {.lex_state = 68},
  [3296] = {.lex_state = 68},
  [3297] = {.lex_state = 68},
  [3298] = {.lex_state = 68},
  [3299] = {.lex_state = 68},
  [3300] = {.lex_state = 68},
  [3301] = {.lex_state = 68},
  [3302] = {.lex_state = 68},
  [3303] = {.lex_state = 68},
  [3304] = {.lex_state = 68},
  [3305] = {.lex_state = 68},
  [3306] = {.lex_state = 68},
  [3307] = {.lex_state = 68},
  [3308] = {.lex_state = 68},
  [3309] = {.lex_state = 68},
  [3310] = {.lex_state = 68},
  [3311] = {.lex_state = 68},
  [3312] = {.lex_state = 68},
  [3313] = {.lex_state = 68},
  [3314] = {.lex_state = 68},
  [3315] = {.lex_state = 68},
  [3316] = {.lex_state = 68},
  [3317] = {.lex_state = 68},
  [3318] = {.lex_state = 68},
  [3319] = {.lex_state = 68},
  [3320] = {.lex_state = 68},
  [3321] = {.lex_state = 68},
  [3322] = {.lex_state = 68},
  [3323] = {.lex_state = 68},
  [3324] = {.lex_state = 68},
  [3325] = {.lex_state = 68},
  [3326] = {.lex_state = 68},
  [3327] = {.lex_state = 68},
  [3328] = {.lex_state = 68},
  [3329] = {.lex_state = 68},
  [3330] = {.lex_state = 68},
  [3331] = {.lex_state = 68},
  [3332] = {.lex_state = 68},
  [3333] = {.lex_state = 68},
  [3334] = {.lex_state = 68},
  [3335] = {.lex_state = 68},
  [3336] = {.lex_state = 68},
  [3337] = {.lex_state = 68},
  [3338] = {.lex_state = 68},
  [3339] = {.lex_state = 68},
  [3340] = {.lex_state = 68},
  [3341] = {.lex_state = 68},
  [3342] = {.lex_state = 68},
  [3343] = {.lex_state = 68},
  [3344] = {.lex_state = 68},
  [3345] = {.lex_state = 68},
  [3346] = {.lex_state = 68},
  [3347] = {.lex_state = 72},
  [3348] = {.lex_state = 68},
  [3349] = {.lex_state = 68},
  [3350] = {.lex_state = 68},
  [3351] = {.lex_state = 68},
  [3352] = {.lex_state = 68},
  [3353] = {.lex_state = 68},
  [3354] = {.lex_state = 68},
  [3355] = {.lex_state = 72},
  [3356] = {.lex_state = 68},
  [3357] = {.lex_state = 68},
  [3358] = {.lex_state = 68},
  [3359] = {.lex_state = 68},
  [3360] = {.lex_state = 68},
  [3361] = {.lex_state = 68},
  [3362] = {.lex_state = 71},
  [3363] = {.lex_state = 17},
  [3364] = {.lex_state = 17},
  [3365] = {.lex_state = 17},
  [3366] = {.lex_state = 17},
  [3367] = {.lex_state = 17},
  [3368] = {.lex_state = 68},
  [3369] = {.lex_state = 68},
  [3370] = {.lex_state = 68},
  [3371] = {.lex_state = 70},
  [3372] = {.lex_state = 70},
  [3373] = {.lex_state = 72},
  [3374] = {.lex_state = 68},
  [3375] = {.lex_state = 68},
  [3376] = {.lex_state = 70},
  [3377] = {.lex_state = 26},
  [3378] = {.lex_state = 18},
  [3379] = {.lex_state = 26},
  [3380] = {.lex_state = 26},
  [3381] = {.lex_state = 18},
  [3382] = {.lex_state = 68},
  [3383] = {.lex_state = 26},
  [3384] = {.lex_state = 68},
  [3385] = {.lex_state = 26},
  [3386] = {.lex_state = 26},
  [3387] = {.lex_state = 26},
  [3388] = {.lex_state = 26},
  [3389] = {.lex_state = 26},
  [3390] = {.lex_state = 26},
  [3391] = {.lex_state = 26},
  [3392] = {.lex_state = 26},
  [3393] = {.lex_state = 68},
  [3394] = {.lex_state = 68},
  [3395] = {.lex_state = 71},
  [3396] = {.lex_state = 71},
  [3397] = {.lex_state = 71},
  [3398] = {.lex_state = 71},
  [3399] = {.lex_state = 19},
  [3400] = {.lex_state = 71},
  [3401] = {.lex_state = 71},
  [3402] = {.lex_state = 71},
  [3403] = {.lex_state = 71},
  [3404] = {.lex_state = 26},
  [3405] = {.lex_state = 71},
  [3406] = {.lex_state = 19},
  [3407] = {.lex_state = 18},
  [3408] = {.lex_state = 71},
  [3409] = {.lex_state = 71},
  [3410] = {.lex_state = 71},
  [3411] = {.lex_state = 71},
  [3412] = {.lex_state = 71},
  [3413] = {.lex_state = 71},
  [3414] = {.lex_state = 71},
  [3415] = {.lex_state = 71},
  [3416] = {.lex_state = 70},
  [3417] = {.lex_state = 71},
  [3418] = {.lex_state = 71},
  [3419] = {.lex_state = 71},
  [3420] = {.lex_state = 71},
  [3421] = {.lex_state = 71},
  [3422] = {.lex_state = 71},
  [3423] = {.lex_state = 19},
  [3424] = {.lex_state = 19},
  [3425] = {.lex_state = 71},
  [3426] = {.lex_state = 71},
  [3427] = {.lex_state = 71},
  [3428] = {.lex_state = 71},
  [3429] = {.lex_state = 71},
  [3430] = {.lex_state = 70},
  [3431] = {.lex_state = 26},
  [3432] = {.lex_state = 70},
  [3433] = {.lex_state = 70},
  [3434] = {.lex_state = 71},
  [3435] = {.lex_state = 71},
  [3436] = {.lex_state = 26},
  [3437] = {.lex_state = 71},
  [3438] = {.lex_state = 71},
  [3439] = {.lex_state = 71},
  [3440] = {.lex_state = 70},
  [3441] = {.lex_state = 70},
  [3442] = {.lex_state = 70},
  [3443] = {.lex_state = 70},
  [3444] = {.lex_state = 71},
  [3445] = {.lex_state = 26},
  [3446] = {.lex_state = 70},
  [3447] = {.lex_state = 18},
  [3448] = {.lex_state = 18},
  [3449] = {.lex_state = 70},
  [3450] = {.lex_state = 18},
  [3451] = {.lex_state = 70},
  [3452] = {.lex_state = 18},
  [3453] = {.lex_state = 70},
  [3454] = {.lex_state = 18},
  [3455] = {.lex_state = 18},
  [3456] = {.lex_state = 18},
  [3457] = {.lex_state = 19},
  [3458] = {.lex_state = 18},
  [3459] = {.lex_state = 18},
  [3460] = {.lex_state = 18},
  [3461] = {.lex_state = 18},
  [3462] = {.lex_state = 18},
  [3463] = {.lex_state = 18},
  [3464] = {.lex_state = 18},
  [3465] = {.lex_state = 18},
  [3466] = {.lex_state = 18},
  [3467] = {.lex_state = 18},
  [3468] = {.lex_state = 18},
  [3469] = {.lex_state = 18},
  [3470] = {.lex_state = 70},
  [3471] = {.lex_state = 18},
  [3472] = {.lex_state = 18},
  [3473] = {.lex_state = 18},
  [3474] = {.lex_state = 18},
  [3475] = {.lex_state = 18},
  [3476] = {.lex_state = 18},
  [3477] = {.lex_state = 18},
  [3478] = {.lex_state = 18},
  [3479] = {.lex_state = 71},
  [3480] = {.lex_state = 71},
  [3481] = {.lex_state = 19},
  [3482] = {.lex_state = 66},
  [3483] = {.lex_state = 18},
  [3484] = {.lex_state = 66},
  [3485] = {.lex_state = 66},
  [3486] = {.lex_state = 66},
  [3487] = {.lex_state = 71},
  [3488] = {.lex_state = 66},
  [3489] = {.lex_state = 18},
  [3490] = {.lex_state = 66},
  [3491] = {.lex_state = 66},
  [3492] = {.lex_state = 66},
  [3493] = {.lex_state = 66},
  [3494] = {.lex_state = 18},
  [3495] = {.lex_state = 18},
  [3496] = {.lex_state = 66},
  [3497] = {.lex_state = 71},
  [3498] = {.lex_state = 66},
  [3499] = {.lex_state = 66},
  [3500] = {.lex_state = 18},
  [3501] = {.lex_state = 18},
  [3502] = {.lex_state = 12},
  [3503] = {.lex_state = 18},
  [3504] = {.lex_state = 18},
  [3505] = {.lex_state = 18},
  [3506] = {.lex_state = 18},
  [3507] = {.lex_state = 18},
  [3508] = {.lex_state = 18},
  [3509] = {.lex_state = 18},
  [3510] = {.lex_state = 71},
  [3511] = {.lex_state = 12},
  [3512] = {.lex_state = 12},
  [3513] = {.lex_state = 12},
  [3514] = {.lex_state = 18},
  [3515] = {.lex_state = 71},
  [3516] = {.lex_state = 18},
  [3517] = {.lex_state = 18},
  [3518] = {.lex_state = 12},
  [3519] = {.lex_state = 80},
  [3520] = {.lex_state = 80},
  [3521] = {.lex_state = 73},
  [3522] = {.lex_state = 80},
  [3523] = {.lex_state = 73},
  [3524] = {.lex_state = 80},
  [3525] = {.lex_state = 73},
  [3526] = {.lex_state = 66},
  [3527] = {.lex_state = 73},
  [3528] = {.lex_state = 80},
  [3529] = {.lex_state = 73},
  [3530] = {.lex_state = 80},
  [3531] = {.lex_state = 12},
  [3532] = {.lex_state = 66},
  [3533] = {.lex_state = 80},
  [3534] = {.lex_state = 73},
  [3535] = {.lex_state = 66},
  [3536] = {.lex_state = 66},
  [3537] = {.lex_state = 73},
  [3538] = {.lex_state = 73},
  [3539] = {.lex_state = 80},
  [3540] = {.lex_state = 66},
  [3541] = {.lex_state = 73},
  [3542] = {.lex_state = 80},
  [3543] = {.lex_state = 66},
  [3544] = {.lex_state = 80},
  [3545] = {.lex_state = 73},
  [3546] = {.lex_state = 73},
  [3547] = {.lex_state = 71},
  [3548] = {.lex_state = 73},
  [3549] = {.lex_state = 80},
  [3550] = {.lex_state = 73},
  [3551] = {.lex_state = 80},
  [3552] = {.lex_state = 80},
  [3553] = {.lex_state = 73},
  [3554] = {.lex_state = 80},
  [3555] = {.lex_state = 73},
  [3556] = {.lex_state = 66},
  [3557] = {.lex_state = 80},
  [3558] = {.lex_state = 73},
  [3559] = {.lex_state = 80},
  [3560] = {.lex_state = 80},
  [3561] = {.lex_state = 66},
  [3562] = {.lex_state = 66},
  [3563] = {.lex_state = 71},
  [3564] = {.lex_state = 66},
  [3565] = {.lex_state = 73},
  [3566] = {.lex_state = 80},
  [3567] = {.lex_state = 73},
  [3568] = {.lex_state = 80},
  [3569] = {.lex_state = 80},
  [3570] = {.lex_state = 80},
  [3571] = {.lex_state = 73},
  [3572] = {.lex_state = 80},
  [3573] = {.lex_state = 73},
  [3574] = {.lex_state = 73},
  [3575] = {.lex_state = 73},
  [3576] = {.lex_state = 80},
  [3577] = {.lex_state = 73},
  [3578] = {.lex_state = 80},
  [3579] = {.lex_state = 71},
  [3580] = {.lex_state = 73},
  [3581] = {.lex_state = 80},
  [3582] = {.lex_state = 73},
  [3583] = {.lex_state = 80},
  [3584] = {.lex_state = 66},
  [3585] = {.lex_state = 80},
  [3586] = {.lex_state = 73},
  [3587] = {.lex_state = 66},
  [3588] = {.lex_state = 80},
  [3589] = {.lex_state = 80},
  [3590] = {.lex_state = 73},
  [3591] = {.lex_state = 80},
  [3592] = {.lex_state = 80},
  [3593] = {.lex_state = 73},
  [3594] = {.lex_state = 73},
  [3595] = {.lex_state = 18},
  [3596] = {.lex_state = 80},
  [3597] = {.lex_state = 73},
  [3598] = {.lex_state = 80},
  [3599] = {.lex_state = 73},
  [3600] = {.lex_state = 80},
  [3601] = {.lex_state = 73},
  [3602] = {.lex_state = 66},
  [3603] = {.lex_state = 73},
  [3604] = {.lex_state = 73},
  [3605] = {.lex_state = 66},
  [3606] = {.lex_state = 80},
  [3607] = {.lex_state = 73},
  [3608] = {.lex_state = 73},
  [3609] = {.lex_state = 80},
  [3610] = {.lex_state = 66},
  [3611] = {.lex_state = 66},
  [3612] = {.lex_state = 80},
  [3613] = {.lex_state = 73},
  [3614] = {.lex_state = 66},
  [3615] = {.lex_state = 66},
  [3616] = {.lex_state = 71},
  [3617] = {.lex_state = 73},
  [3618] = {.lex_state = 80},
  [3619] = {.lex_state = 73},
  [3620] = {.lex_state = 80},
  [3621] = {.lex_state = 66},
  [3622] = {.lex_state = 73},
  [3623] = {.lex_state = 80},
  [3624] = {.lex_state = 73},
  [3625] = {.lex_state = 80},
  [3626] = {.lex_state = 73},
  [3627] = {.lex_state = 80},
  [3628] = {.lex_state = 80},
  [3629] = {.lex_state = 66},
  [3630] = {.lex_state = 66},
  [3631] = {.lex_state = 66},
  [3632] = {.lex_state = 80},
  [3633] = {.lex_state = 73},
  [3634] = {.lex_state = 73},
  [3635] = {.lex_state = 80},
  [3636] = {.lex_state = 73},
  [3637] = {.lex_state = 73},
  [3638] = {.lex_state = 66},
  [3639] = {.lex_state = 80},
  [3640] = {.lex_state = 80},
  [3641] = {.lex_state = 73},
  [3642] = {.lex_state = 73},
  [3643] = {.lex_state = 80},
  [3644] = {.lex_state = 73},
  [3645] = {.lex_state = 80},
  [3646] = {.lex_state = 66},
  [3647] = {.lex_state = 71},
  [3648] = {.lex_state = 178},
  [3649] = {.lex_state = 0},
  [3650] = {.lex_state = 75},
  [3651] = {.lex_state = 0},
  [3652] = {.lex_state = 71},
  [3653] = {.lex_state = 178},
  [3654] = {.lex_state = 71},
  [3655] = {.lex_state = 178},
  [3656] = {.lex_state = 178},
  [3657] = {.lex_state = 80},
  [3658] = {.lex_state = 71},
  [3659] = {.lex_state = 66},
  [3660] = {.lex_state = 71},
  [3661] = {.lex_state = 66},
  [3662] = {.lex_state = 0},
  [3663] = {.lex_state = 73},
  [3664] = {.lex_state = 73},
  [3665] = {.lex_state = 66},
  [3666] = {.lex_state = 18},
  [3667] = {.lex_state = 71},
  [3668] = {.lex_state = 178},
  [3669] = {.lex_state = 184},
  [3670] = {.lex_state = 73},
  [3671] = {.lex_state = 178},
  [3672] = {.lex_state = 71},
  [3673] = {.lex_state = 0},
  [3674] = {.lex_state = 66},
  [3675] = {.lex_state = 18},
  [3676] = {.lex_state = 66},
  [3677] = {.lex_state = 80},
  [3678] = {.lex_state = 71},
  [3679] = {.lex_state = 66},
  [3680] = {.lex_state = 18},
  [3681] = {.lex_state = 66},
  [3682] = {.lex_state = 66},
  [3683] = {.lex_state = 0},
  [3684] = {.lex_state = 73},
  [3685] = {.lex_state = 80},
  [3686] = {.lex_state = 0},
  [3687] = {.lex_state = 0},
  [3688] = {.lex_state = 0},
  [3689] = {.lex_state = 0},
  [3690] = {.lex_state = 80},
  [3691] = {.lex_state = 71},
  [3692] = {.lex_state = 0},
  [3693] = {.lex_state = 0},
  [3694] = {.lex_state = 71},
  [3695] = {.lex_state = 85},
  [3696] = {.lex_state = 71},
  [3697] = {.lex_state = 0},
  [3698] = {.lex_state = 44},
  [3699] = {.lex_state = 44},
  [3700] = {.lex_state = 0},
  [3701] = {.lex_state = 71},
  [3702] = {.lex_state = 0},
  [3703] = {.lex_state = 0},
  [3704] = {.lex_state = 71},
  [3705] = {.lex_state = 0},
  [3706] = {.lex_state = 71},
  [3707] = {.lex_state = 0},
  [3708] = {.lex_state = 71},
  [3709] = {.lex_state = 0},
  [3710] = {.lex_state = 71},
  [3711] = {.lex_state = 0},
  [3712] = {.lex_state = 71},
  [3713] = {.lex_state = 71},
  [3714] = {.lex_state = 44},
  [3715] = {.lex_state = 0},
  [3716] = {.lex_state = 44},
  [3717] = {.lex_state = 44},
  [3718] = {.lex_state = 178},
  [3719] = {.lex_state = 85},
  [3720] = {.lex_state = 71},
  [3721] = {.lex_state = 0},
  [3722] = {.lex_state = 44},
  [3723] = {.lex_state = 178},
  [3724] = {.lex_state = 44},
  [3725] = {.lex_state = 71},
  [3726] = {.lex_state = 71},
  [3727] = {.lex_state = 0},
  [3728] = {.lex_state = 71},
  [3729] = {.lex_state = 66},
  [3730] = {.lex_state = 44},
  [3731] = {.lex_state = 71},
  [3732] = {.lex_state = 66},
  [3733] = {.lex_state = 71},
  [3734] = {.lex_state = 0},
  [3735] = {.lex_state = 0},
  [3736] = {.lex_state = 0},
  [3737] = {.lex_state = 184},
  [3738] = {.lex_state = 75},
  [3739] = {.lex_state = 44},
  [3740] = {.lex_state = 71},
  [3741] = {.lex_state = 0},
  [3742] = {.lex_state = 44},
  [3743] = {.lex_state = 71},
  [3744] = {.lex_state = 44},
  [3745] = {.lex_state = 0},
  [3746] = {.lex_state = 75},
  [3747] = {.lex_state = 71},
  [3748] = {.lex_state = 44},
  [3749] = {.lex_state = 44},
  [3750] = {.lex_state = 0},
  [3751] = {.lex_state = 44},
  [3752] = {.lex_state = 71},
  [3753] = {.lex_state = 71},
  [3754] = {.lex_state = 0},
  [3755] = {.lex_state = 71},
  [3756] = {.lex_state = 71},
  [3757] = {.lex_state = 184},
  [3758] = {.lex_state = 44},
  [3759] = {.lex_state = 0},
  [3760] = {.lex_state = 71},
  [3761] = {.lex_state = 44},
  [3762] = {.lex_state = 0},
  [3763] = {.lex_state = 44},
  [3764] = {.lex_state = 178},
  [3765] = {.lex_state = 71},
  [3766] = {.lex_state = 71},
  [3767] = {.lex_state = 44},
  [3768] = {.lex_state = 44},
  [3769] = {.lex_state = 0},
  [3770] = {.lex_state = 71},
  [3771] = {.lex_state = 71},
  [3772] = {.lex_state = 0},
  [3773] = {.lex_state = 71},
  [3774] = {.lex_state = 44},
  [3775] = {.lex_state = 44},
  [3776] = {.lex_state = 71},
  [3777] = {.lex_state = 71},
  [3778] = {.lex_state = 178},
  [3779] = {.lex_state = 71},
  [3780] = {.lex_state = 66},
  [3781] = {.lex_state = 44},
  [3782] = {.lex_state = 0},
  [3783] = {.lex_state = 0},
  [3784] = {.lex_state = 178},
  [3785] = {.lex_state = 71},
  [3786] = {.lex_state = 178},
  [3787] = {.lex_state = 0},
  [3788] = {.lex_state = 71},
  [3789] = {.lex_state = 0},
  [3790] = {.lex_state = 0},
  [3791] = {.lex_state = 0},
  [3792] = {.lex_state = 0},
  [3793] = {.lex_state = 0},
  [3794] = {.lex_state = 0},
  [3795] = {.lex_state = 0},
  [3796] = {.lex_state = 0},
  [3797] = {.lex_state = 71},
  [3798] = {.lex_state = 44},
  [3799] = {.lex_state = 44},
  [3800] = {.lex_state = 0},
  [3801] = {.lex_state = 85},
  [3802] = {.lex_state = 71},
  [3803] = {.lex_state = 0},
  [3804] = {.lex_state = 71},
  [3805] = {.lex_state = 0},
  [3806] = {.lex_state = 178},
  [3807] = {.lex_state = 0},
  [3808] = {.lex_state = 44},
  [3809] = {.lex_state = 71},
  [3810] = {.lex_state = 0},
  [3811] = {.lex_state = 71},
  [3812] = {.lex_state = 0},
  [3813] = {.lex_state = 0},
  [3814] = {.lex_state = 178},
  [3815] = {.lex_state = 71},
  [3816] = {.lex_state = 0},
  [3817] = {.lex_state = 0},
  [3818] = {.lex_state = 71},
  [3819] = {.lex_state = 0},
  [3820] = {.lex_state = 71},
  [3821] = {.lex_state = 44},
  [3822] = {.lex_state = 44},
  [3823] = {.lex_state = 0},
  [3824] = {.lex_state = 0},
  [3825] = {.lex_state = 178},
  [3826] = {.lex_state = 71},
  [3827] = {.lex_state = 0},
  [3828] = {.lex_state = 0},
  [3829] = {.lex_state = 0},
  [3830] = {.lex_state = 44},
  [3831] = {.lex_state = 0},
  [3832] = {.lex_state = 0},
  [3833] = {.lex_state = 71},
  [3834] = {.lex_state = 0},
  [3835] = {.lex_state = 0},
  [3836] = {.lex_state = 71},
  [3837] = {.lex_state = 0},
  [3838] = {.lex_state = 44},
  [3839] = {.lex_state = 71},
  [3840] = {.lex_state = 44},
  [3841] = {.lex_state = 0},
  [3842] = {.lex_state = 184},
  [3843] = {.lex_state = 184},
  [3844] = {.lex_state = 0},
  [3845] = {.lex_state = 71},
  [3846] = {.lex_state = 81},
  [3847] = {.lex_state = 0},
  [3848] = {.lex_state = 74},
  [3849] = {.lex_state = 0},
  [3850] = {.lex_state = 0},
  [3851] = {.lex_state = 0},
  [3852] = {.lex_state = 0},
  [3853] = {.lex_state = 0},
  [3854] = {.lex_state = 0},
  [3855] = {.lex_state = 0},
  [3856] = {.lex_state = 184},
  [3857] = {.lex_state = 0},
  [3858] = {.lex_state = 0},
  [3859] = {.lex_state = 0},
  [3860] = {.lex_state = 0},
  [3861] = {.lex_state = 81},
  [3862] = {.lex_state = 0},
  [3863] = {.lex_state = 74},
  [3864] = {.lex_state = 71},
  [3865] = {.lex_state = 0},
  [3866] = {.lex_state = 0},
  [3867] = {.lex_state = 0},
  [3868] = {.lex_state = 0},
  [3869] = {.lex_state = 81},
  [3870] = {.lex_state = 74},
  [3871] = {.lex_state = 0},
  [3872] = {.lex_state = 0},
  [3873] = {.lex_state = 0},
  [3874] = {.lex_state = 71},
  [3875] = {.lex_state = 0},
  [3876] = {.lex_state = 74},
  [3877] = {.lex_state = 0},
  [3878] = {.lex_state = 0},
  [3879] = {.lex_state = 81},
  [3880] = {.lex_state = 0},
  [3881] = {.lex_state = 0},
  [3882] = {.lex_state = 0},
  [3883] = {.lex_state = 0},
  [3884] = {.lex_state = 0},
  [3885] = {.lex_state = 0},
  [3886] = {.lex_state = 0},
  [3887] = {.lex_state = 0},
  [3888] = {.lex_state = 0},
  [3889] = {.lex_state = 0},
  [3890] = {.lex_state = 0},
  [3891] = {.lex_state = 74},
  [3892] = {.lex_state = 0},
  [3893] = {.lex_state = 0},
  [3894] = {.lex_state = 81},
  [3895] = {.lex_state = 0},
  [3896] = {.lex_state = 0},
  [3897] = {.lex_state = 81},
  [3898] = {.lex_state = 74},
  [3899] = {.lex_state = 0},
  [3900] = {.lex_state = 0},
  [3901] = {.lex_state = 71},
  [3902] = {.lex_state = 81},
  [3903] = {.lex_state = 0},
  [3904] = {.lex_state = 74},
  [3905] = {.lex_state = 74},
  [3906] = {.lex_state = 0},
  [3907] = {.lex_state = 0},
  [3908] = {.lex_state = 81},
  [3909] = {.lex_state = 0},
  [3910] = {.lex_state = 0},
  [3911] = {.lex_state = 0},
  [3912] = {.lex_state = 0},
  [3913] = {.lex_state = 74},
  [3914] = {.lex_state = 71},
  [3915] = {.lex_state = 81},
  [3916] = {.lex_state = 0},
  [3917] = {.lex_state = 0},
  [3918] = {.lex_state = 71},
  [3919] = {.lex_state = 44},
  [3920] = {.lex_state = 0},
  [3921] = {.lex_state = 74},
  [3922] = {.lex_state = 0},
  [3923] = {.lex_state = 74},
  [3924] = {.lex_state = 184},
  [3925] = {.lex_state = 71},
  [3926] = {.lex_state = 81},
  [3927] = {.lex_state = 71},
  [3928] = {.lex_state = 0},
  [3929] = {.lex_state = 0},
  [3930] = {.lex_state = 71},
  [3931] = {.lex_state = 74},
  [3932] = {.lex_state = 81},
  [3933] = {.lex_state = 71},
  [3934] = {.lex_state = 0},
  [3935] = {.lex_state = 0},
  [3936] = {.lex_state = 0},
  [3937] = {.lex_state = 0},
  [3938] = {.lex_state = 0},
  [3939] = {.lex_state = 0},
  [3940] = {.lex_state = 0},
  [3941] = {.lex_state = 0},
  [3942] = {.lex_state = 74},
  [3943] = {.lex_state = 81},
  [3944] = {.lex_state = 0},
  [3945] = {.lex_state = 0},
  [3946] = {.lex_state = 0},
  [3947] = {.lex_state = 44},
  [3948] = {.lex_state = 0},
  [3949] = {.lex_state = 71},
  [3950] = {.lex_state = 74},
  [3951] = {.lex_state = 0},
  [3952] = {.lex_state = 71},
  [3953] = {.lex_state = 81},
  [3954] = {.lex_state = 74},
  [3955] = {.lex_state = 81},
  [3956] = {.lex_state = 0},
  [3957] = {.lex_state = 0},
  [3958] = {.lex_state = 0},
  [3959] = {.lex_state = 0},
  [3960] = {.lex_state = 66},
  [3961] = {.lex_state = 71},
  [3962] = {.lex_state = 0},
  [3963] = {.lex_state = 0},
  [3964] = {.lex_state = 0},
  [3965] = {.lex_state = 0},
  [3966] = {.lex_state = 81},
  [3967] = {.lex_state = 74},
  [3968] = {.lex_state = 0},
  [3969] = {.lex_state = 0},
  [3970] = {.lex_state = 0},
  [3971] = {.lex_state = 66},
  [3972] = {.lex_state = 0},
  [3973] = {.lex_state = 71},
  [3974] = {.lex_state = 81},
  [3975] = {.lex_state = 0},
  [3976] = {.lex_state = 0},
  [3977] = {.lex_state = 0},
  [3978] = {.lex_state = 0},
  [3979] = {.lex_state = 0},
  [3980] = {.lex_state = 0},
  [3981] = {.lex_state = 184},
  [3982] = {.lex_state = 0},
  [3983] = {.lex_state = 0},
  [3984] = {.lex_state = 0},
  [3985] = {.lex_state = 0},
  [3986] = {.lex_state = 0},
  [3987] = {.lex_state = 0},
  [3988] = {.lex_state = 0},
  [3989] = {.lex_state = 0},
  [3990] = {.lex_state = 0},
  [3991] = {.lex_state = 0},
  [3992] = {.lex_state = 0},
  [3993] = {.lex_state = 0},
  [3994] = {.lex_state = 81},
  [3995] = {.lex_state = 74},
  [3996] = {.lex_state = 0},
  [3997] = {.lex_state = 71},
  [3998] = {.lex_state = 81},
  [3999] = {.lex_state = 74},
  [4000] = {.lex_state = 71},
  [4001] = {.lex_state = 0},
  [4002] = {.lex_state = 0},
  [4003] = {.lex_state = 0},
  [4004] = {.lex_state = 0},
  [4005] = {.lex_state = 66},
  [4006] = {.lex_state = 0},
  [4007] = {.lex_state = 0},
  [4008] = {.lex_state = 0},
  [4009] = {.lex_state = 0},
  [4010] = {.lex_state = 0},
  [4011] = {.lex_state = 0},
  [4012] = {.lex_state = 71},
  [4013] = {.lex_state = 0},
  [4014] = {.lex_state = 81},
  [4015] = {.lex_state = 74},
  [4016] = {.lex_state = 66},
  [4017] = {.lex_state = 0},
  [4018] = {.lex_state = 0},
  [4019] = {.lex_state = 0},
  [4020] = {.lex_state = 0},
  [4021] = {.lex_state = 0},
  [4022] = {.lex_state = 66},
  [4023] = {.lex_state = 0},
  [4024] = {.lex_state = 0},
  [4025] = {.lex_state = 0},
  [4026] = {.lex_state = 0},
  [4027] = {.lex_state = 0},
  [4028] = {.lex_state = 0},
  [4029] = {.lex_state = 0},
  [4030] = {.lex_state = 0},
  [4031] = {.lex_state = 0},
  [4032] = {.lex_state = 0},
  [4033] = {.lex_state = 0},
  [4034] = {.lex_state = 0},
  [4035] = {.lex_state = 0},
  [4036] = {.lex_state = 0},
  [4037] = {.lex_state = 0},
  [4038] = {.lex_state = 0},
  [4039] = {.lex_state = 0},
  [4040] = {.lex_state = 0},
  [4041] = {.lex_state = 0},
  [4042] = {.lex_state = 0},
  [4043] = {.lex_state = 0},
  [4044] = {.lex_state = 0},
  [4045] = {.lex_state = 0},
  [4046] = {.lex_state = 0},
  [4047] = {.lex_state = 0},
  [4048] = {.lex_state = 0},
  [4049] = {.lex_state = 0},
  [4050] = {.lex_state = 44},
  [4051] = {.lex_state = 0},
  [4052] = {.lex_state = 74},
  [4053] = {.lex_state = 81},
  [4054] = {.lex_state = 85},
  [4055] = {.lex_state = 74},
  [4056] = {.lex_state = 71},
  [4057] = {.lex_state = 184},
  [4058] = {.lex_state = 0},
  [4059] = {.lex_state = 0},
  [4060] = {.lex_state = 81},
  [4061] = {.lex_state = 0},
  [4062] = {.lex_state = 0},
  [4063] = {.lex_state = 71},
  [4064] = {.lex_state = 0},
  [4065] = {.lex_state = 0},
  [4066] = {.lex_state = 0},
  [4067] = {.lex_state = 0},
  [4068] = {.lex_state = 0},
  [4069] = {.lex_state = 74},
  [4070] = {.lex_state = 0},
  [4071] = {.lex_state = 81},
  [4072] = {.lex_state = 0},
  [4073] = {.lex_state = 74},
  [4074] = {.lex_state = 81},
  [4075] = {.lex_state = 0},
  [4076] = {.lex_state = 71},
  [4077] = {.lex_state = 184},
  [4078] = {.lex_state = 0},
  [4079] = {.lex_state = 0},
  [4080] = {.lex_state = 0},
  [4081] = {.lex_state = 74},
  [4082] = {.lex_state = 81},
  [4083] = {.lex_state = 0},
  [4084] = {.lex_state = 0},
  [4085] = {.lex_state = 74},
  [4086] = {.lex_state = 81},
  [4087] = {.lex_state = 0},
  [4088] = {.lex_state = 0},
  [4089] = {.lex_state = 71},
  [4090] = {.lex_state = 71},
  [4091] = {.lex_state = 71},
  [4092] = {.lex_state = 0},
  [4093] = {.lex_state = 71},
  [4094] = {.lex_state = 0},
  [4095] = {.lex_state = 0},
  [4096] = {.lex_state = 184},
  [4097] = {.lex_state = 0},
  [4098] = {.lex_state = 0},
  [4099] = {.lex_state = 71},
  [4100] = {.lex_state = 0},
  [4101] = {.lex_state = 0},
  [4102] = {.lex_state = 0},
  [4103] = {.lex_state = 0},
  [4104] = {.lex_state = 0},
  [4105] = {.lex_state = 0},
  [4106] = {.lex_state = 0},
  [4107] = {.lex_state = 0},
  [4108] = {.lex_state = 0},
  [4109] = {.lex_state = 0},
  [4110] = {.lex_state = 0},
  [4111] = {.lex_state = 0},
  [4112] = {.lex_state = 0},
  [4113] = {.lex_state = 0},
  [4114] = {.lex_state = 0},
  [4115] = {.lex_state = 0},
  [4116] = {.lex_state = 0},
  [4117] = {.lex_state = 0},
  [4118] = {.lex_state = 0},
  [4119] = {.lex_state = 0},
  [4120] = {.lex_state = 0},
  [4121] = {.lex_state = 71},
  [4122] = {.lex_state = 71},
  [4123] = {.lex_state = 0},
  [4124] = {.lex_state = 71},
  [4125] = {.lex_state = 0},
  [4126] = {.lex_state = 0},
  [4127] = {.lex_state = 0},
  [4128] = {.lex_state = 0},
  [4129] = {.lex_state = 0},
  [4130] = {.lex_state = 0},
  [4131] = {.lex_state = 0},
  [4132] = {.lex_state = 0},
  [4133] = {.lex_state = 0},
  [4134] = {.lex_state = 0},
  [4135] = {.lex_state = 0},
  [4136] = {.lex_state = 0},
  [4137] = {.lex_state = 0},
  [4138] = {.lex_state = 0},
  [4139] = {.lex_state = 71},
  [4140] = {.lex_state = 71},
  [4141] = {.lex_state = 0},
  [4142] = {.lex_state = 0},
  [4143] = {.lex_state = 0},
  [4144] = {.lex_state = 0},
  [4145] = {.lex_state = 0},
  [4146] = {.lex_state = 0},
  [4147] = {.lex_state = 0},
  [4148] = {.lex_state = 44},
  [4149] = {.lex_state = 0},
  [4150] = {.lex_state = 0},
  [4151] = {.lex_state = 0},
  [4152] = {.lex_state = 0},
  [4153] = {.lex_state = 0},
  [4154] = {.lex_state = 0},
  [4155] = {.lex_state = 0},
  [4156] = {.lex_state = 71},
  [4157] = {.lex_state = 0},
  [4158] = {.lex_state = 0},
  [4159] = {.lex_state = 0},
  [4160] = {.lex_state = 0},
  [4161] = {.lex_state = 0},
  [4162] = {.lex_state = 71},
  [4163] = {.lex_state = 0},
  [4164] = {.lex_state = 0},
  [4165] = {.lex_state = 71},
  [4166] = {.lex_state = 0},
  [4167] = {.lex_state = 0},
  [4168] = {.lex_state = 0},
  [4169] = {.lex_state = 0},
  [4170] = {.lex_state = 0},
  [4171] = {.lex_state = 0},
  [4172] = {.lex_state = 0},
  [4173] = {.lex_state = 0},
  [4174] = {.lex_state = 71},
  [4175] = {.lex_state = 0},
  [4176] = {.lex_state = 0},
  [4177] = {.lex_state = 0},
  [4178] = {.lex_state = 0},
  [4179] = {.lex_state = 0},
  [4180] = {.lex_state = 0},
  [4181] = {.lex_state = 0},
  [4182] = {.lex_state = 0},
  [4183] = {.lex_state = 0},
  [4184] = {.lex_state = 0},
  [4185] = {.lex_state = 0},
  [4186] = {.lex_state = 0},
  [4187] = {.lex_state = 71},
  [4188] = {.lex_state = 0},
  [4189] = {.lex_state = 0},
  [4190] = {.lex_state = 0},
  [4191] = {.lex_state = 0},
  [4192] = {.lex_state = 0},
  [4193] = {.lex_state = 0},
  [4194] = {.lex_state = 0},
  [4195] = {.lex_state = 0},
  [4196] = {.lex_state = 0},
  [4197] = {.lex_state = 0},
  [4198] = {.lex_state = 0},
  [4199] = {.lex_state = 0},
  [4200] = {.lex_state = 0},
  [4201] = {.lex_state = 71},
  [4202] = {.lex_state = 0},
  [4203] = {.lex_state = 0},
  [4204] = {.lex_state = 0},
  [4205] = {.lex_state = 0},
  [4206] = {.lex_state = 71},
  [4207] = {.lex_state = 0},
  [4208] = {.lex_state = 71},
  [4209] = {.lex_state = 0},
  [4210] = {.lex_state = 0},
  [4211] = {.lex_state = 0},
  [4212] = {.lex_state = 0},
  [4213] = {.lex_state = 71},
  [4214] = {.lex_state = 0},
  [4215] = {.lex_state = 0},
  [4216] = {.lex_state = 0},
  [4217] = {.lex_state = 0},
  [4218] = {.lex_state = 0},
  [4219] = {.lex_state = 0},
  [4220] = {.lex_state = 0},
  [4221] = {.lex_state = 0},
  [4222] = {.lex_state = 0},
  [4223] = {.lex_state = 0},
  [4224] = {.lex_state = 0},
  [4225] = {.lex_state = 0},
  [4226] = {.lex_state = 0},
  [4227] = {.lex_state = 0},
  [4228] = {.lex_state = 0},
  [4229] = {.lex_state = 0},
  [4230] = {.lex_state = 71},
  [4231] = {.lex_state = 0},
  [4232] = {.lex_state = 0},
  [4233] = {.lex_state = 0},
  [4234] = {.lex_state = 0},
  [4235] = {.lex_state = 0},
  [4236] = {.lex_state = 0},
  [4237] = {.lex_state = 0},
  [4238] = {.lex_state = 0},
  [4239] = {.lex_state = 0},
  [4240] = {.lex_state = 71},
  [4241] = {.lex_state = 71},
  [4242] = {.lex_state = 0},
  [4243] = {.lex_state = 0},
  [4244] = {.lex_state = 0},
  [4245] = {.lex_state = 0},
  [4246] = {.lex_state = 0},
  [4247] = {.lex_state = 0},
  [4248] = {.lex_state = 0},
  [4249] = {.lex_state = 0},
  [4250] = {.lex_state = 0},
  [4251] = {.lex_state = 0},
  [4252] = {.lex_state = 0},
  [4253] = {.lex_state = 0},
  [4254] = {.lex_state = 0},
  [4255] = {.lex_state = 0},
  [4256] = {.lex_state = 71},
  [4257] = {.lex_state = 0},
  [4258] = {.lex_state = 0},
  [4259] = {.lex_state = 0},
  [4260] = {.lex_state = 0},
  [4261] = {.lex_state = 0},
  [4262] = {.lex_state = 0},
  [4263] = {.lex_state = 0},
  [4264] = {.lex_state = 71},
  [4265] = {.lex_state = 0},
  [4266] = {.lex_state = 0},
  [4267] = {.lex_state = 0},
  [4268] = {.lex_state = 71},
  [4269] = {.lex_state = 0},
  [4270] = {.lex_state = 0},
  [4271] = {.lex_state = 81},
  [4272] = {.lex_state = 0},
  [4273] = {.lex_state = 74},
  [4274] = {.lex_state = 71},
  [4275] = {.lex_state = 71},
  [4276] = {.lex_state = 44},
  [4277] = {.lex_state = 0},
  [4278] = {.lex_state = 0},
  [4279] = {.lex_state = 0},
  [4280] = {.lex_state = 0},
  [4281] = {.lex_state = 0},
  [4282] = {.lex_state = 71},
  [4283] = {.lex_state = 0},
  [4284] = {.lex_state = 0},
  [4285] = {.lex_state = 0},
  [4286] = {.lex_state = 0},
  [4287] = {.lex_state = 0},
  [4288] = {.lex_state = 71},
  [4289] = {.lex_state = 71},
  [4290] = {.lex_state = 0},
  [4291] = {.lex_state = 71},
  [4292] = {.lex_state = 0},
  [4293] = {.lex_state = 0},
  [4294] = {.lex_state = 71},
  [4295] = {.lex_state = 0},
  [4296] = {.lex_state = 0},
  [4297] = {.lex_state = 0},
  [4298] = {.lex_state = 0},
  [4299] = {.lex_state = 0},
  [4300] = {.lex_state = 71},
  [4301] = {.lex_state = 0},
  [4302] = {.lex_state = 0},
  [4303] = {.lex_state = 0},
  [4304] = {.lex_state = 0},
  [4305] = {.lex_state = 0},
  [4306] = {.lex_state = 0},
  [4307] = {.lex_state = 0},
  [4308] = {.lex_state = 0},
  [4309] = {.lex_state = 71},
  [4310] = {.lex_state = 0},
  [4311] = {.lex_state = 0},
  [4312] = {.lex_state = 0},
  [4313] = {.lex_state = 0},
  [4314] = {.lex_state = 0},
  [4315] = {.lex_state = 0},
  [4316] = {.lex_state = 0},
  [4317] = {.lex_state = 0},
  [4318] = {.lex_state = 0},
  [4319] = {.lex_state = 0},
  [4320] = {.lex_state = 44},
  [4321] = {.lex_state = 0},
  [4322] = {.lex_state = 0},
  [4323] = {.lex_state = 0},
  [4324] = {.lex_state = 0},
  [4325] = {.lex_state = 71},
  [4326] = {.lex_state = 0},
  [4327] = {.lex_state = 0},
  [4328] = {.lex_state = 0},
  [4329] = {.lex_state = 0},
  [4330] = {.lex_state = 0},
  [4331] = {.lex_state = 0},
  [4332] = {.lex_state = 71},
  [4333] = {.lex_state = 0},
  [4334] = {.lex_state = 0},
  [4335] = {.lex_state = 0},
  [4336] = {.lex_state = 0},
  [4337] = {.lex_state = 0},
  [4338] = {.lex_state = 0},
  [4339] = {.lex_state = 0},
  [4340] = {.lex_state = 71},
  [4341] = {.lex_state = 0},
  [4342] = {.lex_state = 0},
  [4343] = {.lex_state = 0},
  [4344] = {.lex_state = 0},
  [4345] = {.lex_state = 0},
  [4346] = {.lex_state = 0},
  [4347] = {.lex_state = 0},
  [4348] = {.lex_state = 0},
  [4349] = {.lex_state = 0},
  [4350] = {.lex_state = 0},
  [4351] = {.lex_state = 0},
  [4352] = {.lex_state = 71},
  [4353] = {.lex_state = 0},
  [4354] = {.lex_state = 71},
  [4355] = {.lex_state = 0},
  [4356] = {.lex_state = 71},
  [4357] = {.lex_state = 71},
  [4358] = {.lex_state = 0},
  [4359] = {.lex_state = 71},
  [4360] = {.lex_state = 0},
  [4361] = {.lex_state = 0},
  [4362] = {.lex_state = 0},
  [4363] = {.lex_state = 0},
  [4364] = {.lex_state = 0},
  [4365] = {.lex_state = 0},
  [4366] = {.lex_state = 0},
  [4367] = {.lex_state = 0},
  [4368] = {.lex_state = 0},
  [4369] = {.lex_state = 0},
  [4370] = {.lex_state = 0},
  [4371] = {.lex_state = 0},
  [4372] = {.lex_state = 0},
  [4373] = {.lex_state = 0},
  [4374] = {.lex_state = 0},
  [4375] = {.lex_state = 0},
  [4376] = {.lex_state = 0},
  [4377] = {.lex_state = 71},
  [4378] = {.lex_state = 0},
  [4379] = {.lex_state = 0},
  [4380] = {.lex_state = 0},
  [4381] = {.lex_state = 0},
  [4382] = {.lex_state = 71},
  [4383] = {.lex_state = 0},
  [4384] = {.lex_state = 0},
  [4385] = {.lex_state = 0},
  [4386] = {.lex_state = 0},
  [4387] = {.lex_state = 71},
  [4388] = {.lex_state = 0},
  [4389] = {.lex_state = 0},
  [4390] = {.lex_state = 0},
  [4391] = {.lex_state = 0},
  [4392] = {.lex_state = 71},
  [4393] = {.lex_state = 0},
  [4394] = {.lex_state = 0},
  [4395] = {.lex_state = 0},
  [4396] = {.lex_state = 0},
  [4397] = {.lex_state = 0},
  [4398] = {.lex_state = 0},
  [4399] = {.lex_state = 0},
  [4400] = {.lex_state = 0},
  [4401] = {.lex_state = 0},
  [4402] = {.lex_state = 0},
  [4403] = {.lex_state = 71},
  [4404] = {.lex_state = 0},
  [4405] = {.lex_state = 0},
  [4406] = {.lex_state = 0},
  [4407] = {.lex_state = 0},
  [4408] = {.lex_state = 71},
  [4409] = {.lex_state = 0},
  [4410] = {.lex_state = 0},
  [4411] = {.lex_state = 0},
  [4412] = {.lex_state = 0},
  [4413] = {.lex_state = 71},
  [4414] = {.lex_state = 0},
  [4415] = {.lex_state = 0},
  [4416] = {.lex_state = 0},
  [4417] = {.lex_state = 0},
  [4418] = {.lex_state = 0},
  [4419] = {.lex_state = 93},
  [4420] = {.lex_state = 0},
  [4421] = {.lex_state = 0},
  [4422] = {.lex_state = 0},
  [4423] = {.lex_state = 0},
  [4424] = {.lex_state = 0},
  [4425] = {.lex_state = 0},
  [4426] = {.lex_state = 0},
  [4427] = {.lex_state = 0},
  [4428] = {.lex_state = 93},
  [4429] = {.lex_state = 0},
  [4430] = {.lex_state = 0},
  [4431] = {.lex_state = 0},
  [4432] = {.lex_state = 0},
  [4433] = {.lex_state = 26},
  [4434] = {.lex_state = 0},
  [4435] = {.lex_state = 0},
  [4436] = {.lex_state = 0},
  [4437] = {.lex_state = 0},
  [4438] = {.lex_state = 0},
  [4439] = {.lex_state = 93},
  [4440] = {.lex_state = 0},
  [4441] = {.lex_state = 0},
  [4442] = {.lex_state = 0},
  [4443] = {.lex_state = 71},
  [4444] = {.lex_state = 0},
  [4445] = {.lex_state = 0},
  [4446] = {.lex_state = 0},
  [4447] = {.lex_state = 0},
  [4448] = {.lex_state = 0},
  [4449] = {.lex_state = 93},
  [4450] = {.lex_state = 0},
  [4451] = {.lex_state = 0},
  [4452] = {.lex_state = 0},
  [4453] = {.lex_state = 0},
  [4454] = {.lex_state = 0},
  [4455] = {.lex_state = 0},
  [4456] = {.lex_state = 0},
  [4457] = {.lex_state = 0},
  [4458] = {.lex_state = 0},
  [4459] = {.lex_state = 0},
  [4460] = {.lex_state = 0},
  [4461] = {.lex_state = 0},
  [4462] = {.lex_state = 0},
  [4463] = {.lex_state = 0},
  [4464] = {.lex_state = 0},
  [4465] = {.lex_state = 0},
  [4466] = {.lex_state = 0},
  [4467] = {.lex_state = 0},
  [4468] = {.lex_state = 0},
  [4469] = {.lex_state = 0},
  [4470] = {.lex_state = 93},
  [4471] = {.lex_state = 0},
  [4472] = {.lex_state = 0},
  [4473] = {.lex_state = 0},
  [4474] = {.lex_state = 0},
  [4475] = {.lex_state = 0},
  [4476] = {.lex_state = 0},
  [4477] = {.lex_state = 0},
  [4478] = {.lex_state = 71},
  [4479] = {.lex_state = 0},
  [4480] = {.lex_state = 0},
  [4481] = {.lex_state = 0},
  [4482] = {.lex_state = 0},
  [4483] = {.lex_state = 0},
  [4484] = {.lex_state = 0},
  [4485] = {.lex_state = 93},
  [4486] = {.lex_state = 0},
  [4487] = {.lex_state = 0},
  [4488] = {.lex_state = 0},
  [4489] = {.lex_state = 0},
  [4490] = {.lex_state = 0},
  [4491] = {.lex_state = 0},
  [4492] = {.lex_state = 0},
  [4493] = {.lex_state = 0},
  [4494] = {.lex_state = 0},
  [4495] = {.lex_state = 0},
  [4496] = {.lex_state = 0},
  [4497] = {.lex_state = 0},
  [4498] = {.lex_state = 0},
  [4499] = {.lex_state = 0},
  [4500] = {.lex_state = 0},
  [4501] = {.lex_state = 0},
  [4502] = {.lex_state = 0},
  [4503] = {.lex_state = 0},
  [4504] = {.lex_state = 0},
  [4505] = {.lex_state = 0},
  [4506] = {.lex_state = 0},
  [4507] = {.lex_state = 0},
  [4508] = {.lex_state = 0},
  [4509] = {.lex_state = 93},
  [4510] = {.lex_state = 0},
  [4511] = {.lex_state = 0},
  [4512] = {.lex_state = 93},
  [4513] = {.lex_state = 0},
  [4514] = {.lex_state = 0},
  [4515] = {.lex_state = 0},
  [4516] = {.lex_state = 0},
  [4517] = {.lex_state = 0},
  [4518] = {.lex_state = 0},
  [4519] = {.lex_state = 71},
  [4520] = {.lex_state = 71},
  [4521] = {.lex_state = 71},
  [4522] = {.lex_state = 0},
  [4523] = {.lex_state = 0},
  [4524] = {.lex_state = 0},
  [4525] = {.lex_state = 0},
  [4526] = {.lex_state = 0},
  [4527] = {.lex_state = 0},
  [4528] = {.lex_state = 0},
  [4529] = {.lex_state = 0},
  [4530] = {.lex_state = 0},
  [4531] = {.lex_state = 0},
  [4532] = {.lex_state = 0},
  [4533] = {.lex_state = 93},
  [4534] = {.lex_state = 0},
  [4535] = {.lex_state = 71},
  [4536] = {.lex_state = 0},
  [4537] = {.lex_state = 0},
  [4538] = {.lex_state = 71},
  [4539] = {.lex_state = 71},
  [4540] = {.lex_state = 71},
  [4541] = {.lex_state = 0},
  [4542] = {.lex_state = 71},
  [4543] = {.lex_state = 0},
  [4544] = {.lex_state = 0},
  [4545] = {.lex_state = 0},
  [4546] = {.lex_state = 0},
  [4547] = {.lex_state = 0},
  [4548] = {.lex_state = 0},
  [4549] = {.lex_state = 93},
  [4550] = {.lex_state = 0},
  [4551] = {.lex_state = 0},
  [4552] = {.lex_state = 0},
  [4553] = {.lex_state = 0},
  [4554] = {.lex_state = 93},
  [4555] = {.lex_state = 71},
  [4556] = {.lex_state = 0},
  [4557] = {.lex_state = 0},
  [4558] = {.lex_state = 93},
  [4559] = {.lex_state = 0},
  [4560] = {.lex_state = 0},
  [4561] = {.lex_state = 0},
  [4562] = {.lex_state = 0},
  [4563] = {.lex_state = 0},
  [4564] = {.lex_state = 0},
  [4565] = {.lex_state = 0},
  [4566] = {.lex_state = 93},
  [4567] = {.lex_state = 0},
  [4568] = {.lex_state = 71},
  [4569] = {.lex_state = 71},
  [4570] = {.lex_state = 0},
  [4571] = {.lex_state = 71},
  [4572] = {.lex_state = 0},
  [4573] = {.lex_state = 0},
  [4574] = {.lex_state = 0},
  [4575] = {.lex_state = 0},
  [4576] = {.lex_state = 0},
  [4577] = {.lex_state = 26},
  [4578] = {.lex_state = 44},
  [4579] = {.lex_state = 0},
  [4580] = {.lex_state = 71},
  [4581] = {.lex_state = 0},
  [4582] = {.lex_state = 0},
  [4583] = {.lex_state = 0},
  [4584] = {.lex_state = 0},
  [4585] = {.lex_state = 0},
  [4586] = {.lex_state = 0},
  [4587] = {.lex_state = 0},
  [4588] = {.lex_state = 93},
  [4589] = {.lex_state = 0},
  [4590] = {.lex_state = 0},
  [4591] = {.lex_state = 0},
  [4592] = {.lex_state = 0},
  [4593] = {.lex_state = 93},
  [4594] = {.lex_state = 0},
  [4595] = {.lex_state = 0},
  [4596] = {.lex_state = 0},
  [4597] = {.lex_state = 0},
  [4598] = {.lex_state = 0},
  [4599] = {.lex_state = 0},
  [4600] = {.lex_state = 0},
  [4601] = {.lex_state = 0},
  [4602] = {.lex_state = 0},
  [4603] = {.lex_state = 0},
  [4604] = {.lex_state = 0},
  [4605] = {.lex_state = 71},
  [4606] = {.lex_state = 0},
  [4607] = {.lex_state = 0},
  [4608] = {.lex_state = 0},
  [4609] = {.lex_state = 0},
  [4610] = {.lex_state = 0},
  [4611] = {.lex_state = 0},
  [4612] = {.lex_state = 0},
  [4613] = {.lex_state = 0},
  [4614] = {.lex_state = 0},
  [4615] = {.lex_state = 0},
  [4616] = {.lex_state = 0},
  [4617] = {.lex_state = 0},
  [4618] = {.lex_state = 0},
  [4619] = {.lex_state = 0},
  [4620] = {.lex_state = 0},
  [4621] = {.lex_state = 0},
  [4622] = {.lex_state = 0},
  [4623] = {.lex_state = 0},
  [4624] = {.lex_state = 0},
  [4625] = {.lex_state = 0},
  [4626] = {.lex_state = 194},
  [4627] = {.lex_state = 0},
  [4628] = {.lex_state = 0},
  [4629] = {.lex_state = 0},
  [4630] = {.lex_state = 0},
  [4631] = {.lex_state = 0},
  [4632] = {.lex_state = 0},
  [4633] = {.lex_state = 0},
  [4634] = {.lex_state = 0},
  [4635] = {.lex_state = 0},
  [4636] = {.lex_state = 0},
  [4637] = {.lex_state = 0},
  [4638] = {.lex_state = 0},
  [4639] = {.lex_state = 0},
  [4640] = {.lex_state = 0},
  [4641] = {.lex_state = 0},
  [4642] = {.lex_state = 0},
  [4643] = {.lex_state = 0},
  [4644] = {.lex_state = 26},
  [4645] = {.lex_state = 0},
  [4646] = {.lex_state = 0},
  [4647] = {.lex_state = 0},
  [4648] = {.lex_state = 0},
  [4649] = {.lex_state = 0},
  [4650] = {.lex_state = 0},
  [4651] = {.lex_state = 0},
  [4652] = {.lex_state = 0},
  [4653] = {.lex_state = 0},
  [4654] = {.lex_state = 0},
  [4655] = {.lex_state = 194},
  [4656] = {.lex_state = 0},
  [4657] = {.lex_state = 71},
  [4658] = {.lex_state = 0},
  [4659] = {.lex_state = 0},
  [4660] = {.lex_state = 0},
  [4661] = {.lex_state = 0},
  [4662] = {.lex_state = 0},
  [4663] = {.lex_state = 0},
  [4664] = {.lex_state = 0},
  [4665] = {.lex_state = 0},
  [4666] = {.lex_state = 0},
  [4667] = {.lex_state = 0},
  [4668] = {.lex_state = 0},
  [4669] = {.lex_state = 0},
  [4670] = {.lex_state = 0},
  [4671] = {.lex_state = 71},
  [4672] = {.lex_state = 71},
  [4673] = {.lex_state = 94},
  [4674] = {.lex_state = 0},
  [4675] = {.lex_state = 0},
  [4676] = {.lex_state = 0},
  [4677] = {.lex_state = 0},
  [4678] = {.lex_state = 0},
  [4679] = {.lex_state = 0},
  [4680] = {.lex_state = 0},
  [4681] = {.lex_state = 0},
  [4682] = {.lex_state = 0},
  [4683] = {.lex_state = 0},
  [4684] = {.lex_state = 0},
  [4685] = {.lex_state = 185},
  [4686] = {.lex_state = 0},
  [4687] = {.lex_state = 0},
  [4688] = {.lex_state = 0},
  [4689] = {.lex_state = 94},
  [4690] = {.lex_state = 0},
  [4691] = {.lex_state = 0},
  [4692] = {.lex_state = 0},
  [4693] = {.lex_state = 0},
  [4694] = {.lex_state = 0},
  [4695] = {.lex_state = 0},
  [4696] = {.lex_state = 0},
  [4697] = {.lex_state = 0},
  [4698] = {.lex_state = 71},
  [4699] = {.lex_state = 71},
  [4700] = {.lex_state = 71},
  [4701] = {.lex_state = 71},
  [4702] = {.lex_state = 0},
  [4703] = {.lex_state = 0},
  [4704] = {.lex_state = 71},
  [4705] = {.lex_state = 0},
  [4706] = {.lex_state = 0},
  [4707] = {.lex_state = 0},
  [4708] = {.lex_state = 0},
  [4709] = {.lex_state = 71},
  [4710] = {.lex_state = 0},
  [4711] = {.lex_state = 0},
  [4712] = {.lex_state = 0},
  [4713] = {.lex_state = 0},
  [4714] = {(TSStateId)(-1)},
  [4715] = {(TSStateId)(-1)},
  [4716] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_line_comment] = STATE(0),
    [sym_block_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_POUND_BANG] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_block_comment_token1] = ACTIONS(1),
    [anon_sym_STAR_SLASH] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym___global] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_LT2] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_pub] = ACTIONS(1),
    [anon_sym_mut] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_go] = ACTIONS(1),
    [anon_sym_spawn] = ACTIONS(1),
    [anon_sym_json_DOTdecode] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_LBRACK2] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_AMP_CARET] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_none] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_POUND_LBRACK] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_BANGis] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_BANGin] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_select] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_AMP_CARET_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_lock] = ACTIONS(1),
    [anon_sym_rlock] = ACTIONS(1),
    [anon_sym_unsafe] = ACTIONS(1),
    [anon_sym_sql] = ACTIONS(1),
    [sym_int_literal] = ACTIONS(1),
    [sym_rune_literal] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_c_SQUOTE] = ACTIONS(1),
    [anon_sym_c_DQUOTE] = ACTIONS(1),
    [anon_sym_r_SQUOTE] = ACTIONS(1),
    [anon_sym_r_DQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [aux_sym_format_specifier_token1] = ACTIONS(1),
    [aux_sym_format_specifier_token2] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [sym_pseudo_compile_time_identifier] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_shared] = ACTIONS(1),
    [anon_sym_PIPE2] = ACTIONS(1),
    [anon_sym_map_LBRACK] = ACTIONS(1),
    [anon_sym_chan] = ACTIONS(1),
    [anon_sym_thread] = ACTIONS(1),
    [anon_sym_atomic] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_defer] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_asm] = ACTIONS(1),
    [anon_sym_AT_LBRACK] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(4667),
    [sym_shebang] = STATE(2),
    [sym_line_comment] = STATE(1),
    [sym_block_comment] = STATE(1),
    [sym_module_clause] = STATE(4),
    [sym_import_list] = STATE(5),
    [sym_import_declaration] = STATE(1920),
    [sym_const_declaration] = STATE(1788),
    [sym_global_var_declaration] = STATE(1788),
    [sym_type_declaration] = STATE(1788),
    [sym_function_declaration] = STATE(1788),
    [sym_static_method_declaration] = STATE(1788),
    [sym_struct_declaration] = STATE(1788),
    [sym_enum_declaration] = STATE(1788),
    [sym_interface_declaration] = STATE(1788),
    [sym__expression] = STATE(244),
    [sym__expression_without_blocks] = STATE(471),
    [sym__expression_with_blocks] = STATE(471),
    [sym_strictly_expression_list] = STATE(1796),
    [sym_inc_expression] = STATE(474),
    [sym_dec_expression] = STATE(474),
    [sym_or_block_expression] = STATE(474),
    [sym_option_propagation_expression] = STATE(474),
    [sym_result_propagation_expression] = STATE(474),
    [sym_anon_struct_value_expression] = STATE(481),
    [sym_go_expression] = STATE(474),
    [sym_spawn_expression] = STATE(474),
    [sym_parenthesized_expression] = STATE(474),
    [sym_call_expression] = STATE(474),
    [sym_type_initializer] = STATE(481),
    [sym_function_literal] = STATE(474),
    [sym_reference_expression] = STATE(483),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(474),
    [sym_receive_expression] = STATE(474),
    [sym_binary_expression] = STATE(474),
    [sym_as_type_cast_expression] = STATE(474),
    [sym__max_group] = STATE(474),
    [sym_literal] = STATE(446),
    [sym_map_init_expression] = STATE(481),
    [sym_array_creation] = STATE(474),
    [sym_fixed_array_creation] = STATE(474),
    [sym_selector_expression] = STATE(474),
    [sym_index_expression] = STATE(474),
    [sym_slice_expression] = STATE(474),
    [sym_if_expression] = STATE(481),
    [sym_compile_time_if_expression] = STATE(481),
    [sym_is_expression] = STATE(474),
    [sym_in_expression] = STATE(474),
    [sym_enum_fetch] = STATE(474),
    [sym_match_expression] = STATE(481),
    [sym_select_expression] = STATE(481),
    [sym_lock_expression] = STATE(481),
    [sym_unsafe_expression] = STATE(481),
    [sym_sql_expression] = STATE(481),
    [sym_interpreted_string_literal] = STATE(421),
    [sym_c_string_literal] = STATE(421),
    [sym_raw_string_literal] = STATE(421),
    [sym_visibility_modifiers] = STATE(3616),
    [sym_mutability_modifiers] = STATE(932),
    [sym_mutable_expression] = STATE(3390),
    [sym_expression_list] = STATE(3404),
    [sym_plain_type] = STATE(4176),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1788),
    [sym_simple_statement] = STATE(1804),
    [sym_assert_statement] = STATE(1804),
    [sym_append_statement] = STATE(1804),
    [sym_send_statement] = STATE(1804),
    [sym_var_declaration] = STATE(1796),
    [sym_assignment_statement] = STATE(1796),
    [sym_block] = STATE(1804),
    [sym_defer_statement] = STATE(1804),
    [sym_goto_statement] = STATE(1804),
    [sym_break_statement] = STATE(1804),
    [sym_continue_statement] = STATE(1804),
    [sym_return_statement] = STATE(1804),
    [sym_label_definition] = STATE(13),
    [sym_labeled_statement] = STATE(1804),
    [sym_compile_time_for_statement] = STATE(1804),
    [sym_for_statement] = STATE(1804),
    [sym_hash_statement] = STATE(1804),
    [sym_asm_statement] = STATE(1804),
    [sym_attributes] = STATE(3480),
    [sym_attribute] = STATE(3407),
    [aux_sym_source_file_repeat1] = STATE(11),
    [aux_sym_import_list_repeat1] = STATE(1805),
    [aux_sym_attributes_repeat1] = STATE(3449),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_POUND_BANG] = ACTIONS(11),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym___global] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(31),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_struct] = ACTIONS(35),
    [anon_sym_union] = ACTIONS(37),
    [anon_sym_pub] = ACTIONS(39),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_interface] = ACTIONS(45),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_spawn] = ACTIONS(53),
    [anon_sym_json_DOTdecode] = ACTIONS(55),
    [anon_sym_LBRACK2] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_CARET] = ACTIONS(31),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [sym_none] = ACTIONS(63),
    [sym_true] = ACTIONS(63),
    [sym_false] = ACTIONS(63),
    [sym_nil] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_DOLLARif] = ACTIONS(67),
    [anon_sym_match] = ACTIONS(69),
    [anon_sym_select] = ACTIONS(71),
    [anon_sym_lock] = ACTIONS(73),
    [anon_sym_rlock] = ACTIONS(73),
    [anon_sym_unsafe] = ACTIONS(75),
    [anon_sym_sql] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(79),
    [sym_rune_literal] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_c_SQUOTE] = ACTIONS(85),
    [anon_sym_c_DQUOTE] = ACTIONS(87),
    [anon_sym_r_SQUOTE] = ACTIONS(89),
    [anon_sym_r_DQUOTE] = ACTIONS(91),
    [sym_pseudo_compile_time_identifier] = ACTIONS(93),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(105),
    [anon_sym_defer] = ACTIONS(107),
    [anon_sym_goto] = ACTIONS(109),
    [anon_sym_break] = ACTIONS(111),
    [anon_sym_continue] = ACTIONS(113),
    [anon_sym_return] = ACTIONS(115),
    [anon_sym_DOLLARfor] = ACTIONS(117),
    [anon_sym_for] = ACTIONS(119),
    [anon_sym_POUND] = ACTIONS(121),
    [anon_sym_asm] = ACTIONS(123),
    [anon_sym_AT_LBRACK] = ACTIONS(125),
  },
  [2] = {
    [sym_line_comment] = STATE(2),
    [sym_block_comment] = STATE(2),
    [sym_module_clause] = STATE(3),
    [sym_import_list] = STATE(9),
    [sym_import_declaration] = STATE(1920),
    [sym_const_declaration] = STATE(1788),
    [sym_global_var_declaration] = STATE(1788),
    [sym_type_declaration] = STATE(1788),
    [sym_function_declaration] = STATE(1788),
    [sym_static_method_declaration] = STATE(1788),
    [sym_struct_declaration] = STATE(1788),
    [sym_enum_declaration] = STATE(1788),
    [sym_interface_declaration] = STATE(1788),
    [sym__expression] = STATE(244),
    [sym__expression_without_blocks] = STATE(471),
    [sym__expression_with_blocks] = STATE(471),
    [sym_strictly_expression_list] = STATE(1796),
    [sym_inc_expression] = STATE(474),
    [sym_dec_expression] = STATE(474),
    [sym_or_block_expression] = STATE(474),
    [sym_option_propagation_expression] = STATE(474),
    [sym_result_propagation_expression] = STATE(474),
    [sym_anon_struct_value_expression] = STATE(481),
    [sym_go_expression] = STATE(474),
    [sym_spawn_expression] = STATE(474),
    [sym_parenthesized_expression] = STATE(474),
    [sym_call_expression] = STATE(474),
    [sym_type_initializer] = STATE(481),
    [sym_function_literal] = STATE(474),
    [sym_reference_expression] = STATE(483),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(474),
    [sym_receive_expression] = STATE(474),
    [sym_binary_expression] = STATE(474),
    [sym_as_type_cast_expression] = STATE(474),
    [sym__max_group] = STATE(474),
    [sym_literal] = STATE(446),
    [sym_map_init_expression] = STATE(481),
    [sym_array_creation] = STATE(474),
    [sym_fixed_array_creation] = STATE(474),
    [sym_selector_expression] = STATE(474),
    [sym_index_expression] = STATE(474),
    [sym_slice_expression] = STATE(474),
    [sym_if_expression] = STATE(481),
    [sym_compile_time_if_expression] = STATE(481),
    [sym_is_expression] = STATE(474),
    [sym_in_expression] = STATE(474),
    [sym_enum_fetch] = STATE(474),
    [sym_match_expression] = STATE(481),
    [sym_select_expression] = STATE(481),
    [sym_lock_expression] = STATE(481),
    [sym_unsafe_expression] = STATE(481),
    [sym_sql_expression] = STATE(481),
    [sym_interpreted_string_literal] = STATE(421),
    [sym_c_string_literal] = STATE(421),
    [sym_raw_string_literal] = STATE(421),
    [sym_visibility_modifiers] = STATE(3616),
    [sym_mutability_modifiers] = STATE(932),
    [sym_mutable_expression] = STATE(3390),
    [sym_expression_list] = STATE(3404),
    [sym_plain_type] = STATE(4176),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1788),
    [sym_simple_statement] = STATE(1804),
    [sym_assert_statement] = STATE(1804),
    [sym_append_statement] = STATE(1804),
    [sym_send_statement] = STATE(1804),
    [sym_var_declaration] = STATE(1796),
    [sym_assignment_statement] = STATE(1796),
    [sym_block] = STATE(1804),
    [sym_defer_statement] = STATE(1804),
    [sym_goto_statement] = STATE(1804),
    [sym_break_statement] = STATE(1804),
    [sym_continue_statement] = STATE(1804),
    [sym_return_statement] = STATE(1804),
    [sym_label_definition] = STATE(13),
    [sym_labeled_statement] = STATE(1804),
    [sym_compile_time_for_statement] = STATE(1804),
    [sym_for_statement] = STATE(1804),
    [sym_hash_statement] = STATE(1804),
    [sym_asm_statement] = STATE(1804),
    [sym_attributes] = STATE(3480),
    [sym_attribute] = STATE(3407),
    [aux_sym_source_file_repeat1] = STATE(10),
    [aux_sym_import_list_repeat1] = STATE(1805),
    [aux_sym_attributes_repeat1] = STATE(3449),
    [ts_builtin_sym_end] = ACTIONS(127),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym___global] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(31),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_struct] = ACTIONS(35),
    [anon_sym_union] = ACTIONS(37),
    [anon_sym_pub] = ACTIONS(39),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_interface] = ACTIONS(45),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_spawn] = ACTIONS(53),
    [anon_sym_json_DOTdecode] = ACTIONS(55),
    [anon_sym_LBRACK2] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_CARET] = ACTIONS(31),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [sym_none] = ACTIONS(63),
    [sym_true] = ACTIONS(63),
    [sym_false] = ACTIONS(63),
    [sym_nil] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_DOLLARif] = ACTIONS(67),
    [anon_sym_match] = ACTIONS(69),
    [anon_sym_select] = ACTIONS(71),
    [anon_sym_lock] = ACTIONS(73),
    [anon_sym_rlock] = ACTIONS(73),
    [anon_sym_unsafe] = ACTIONS(75),
    [anon_sym_sql] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(79),
    [sym_rune_literal] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_c_SQUOTE] = ACTIONS(85),
    [anon_sym_c_DQUOTE] = ACTIONS(87),
    [anon_sym_r_SQUOTE] = ACTIONS(89),
    [anon_sym_r_DQUOTE] = ACTIONS(91),
    [sym_pseudo_compile_time_identifier] = ACTIONS(93),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(105),
    [anon_sym_defer] = ACTIONS(107),
    [anon_sym_goto] = ACTIONS(109),
    [anon_sym_break] = ACTIONS(111),
    [anon_sym_continue] = ACTIONS(113),
    [anon_sym_return] = ACTIONS(115),
    [anon_sym_DOLLARfor] = ACTIONS(117),
    [anon_sym_for] = ACTIONS(119),
    [anon_sym_POUND] = ACTIONS(129),
    [anon_sym_asm] = ACTIONS(123),
    [anon_sym_AT_LBRACK] = ACTIONS(125),
  },
  [3] = {
    [sym_line_comment] = STATE(3),
    [sym_block_comment] = STATE(3),
    [sym_import_list] = STATE(8),
    [sym_import_declaration] = STATE(1920),
    [sym_const_declaration] = STATE(1788),
    [sym_global_var_declaration] = STATE(1788),
    [sym_type_declaration] = STATE(1788),
    [sym_function_declaration] = STATE(1788),
    [sym_static_method_declaration] = STATE(1788),
    [sym_struct_declaration] = STATE(1788),
    [sym_enum_declaration] = STATE(1788),
    [sym_interface_declaration] = STATE(1788),
    [sym__expression] = STATE(244),
    [sym__expression_without_blocks] = STATE(471),
    [sym__expression_with_blocks] = STATE(471),
    [sym_strictly_expression_list] = STATE(1796),
    [sym_inc_expression] = STATE(474),
    [sym_dec_expression] = STATE(474),
    [sym_or_block_expression] = STATE(474),
    [sym_option_propagation_expression] = STATE(474),
    [sym_result_propagation_expression] = STATE(474),
    [sym_anon_struct_value_expression] = STATE(481),
    [sym_go_expression] = STATE(474),
    [sym_spawn_expression] = STATE(474),
    [sym_parenthesized_expression] = STATE(474),
    [sym_call_expression] = STATE(474),
    [sym_type_initializer] = STATE(481),
    [sym_function_literal] = STATE(474),
    [sym_reference_expression] = STATE(483),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(474),
    [sym_receive_expression] = STATE(474),
    [sym_binary_expression] = STATE(474),
    [sym_as_type_cast_expression] = STATE(474),
    [sym__max_group] = STATE(474),
    [sym_literal] = STATE(446),
    [sym_map_init_expression] = STATE(481),
    [sym_array_creation] = STATE(474),
    [sym_fixed_array_creation] = STATE(474),
    [sym_selector_expression] = STATE(474),
    [sym_index_expression] = STATE(474),
    [sym_slice_expression] = STATE(474),
    [sym_if_expression] = STATE(481),
    [sym_compile_time_if_expression] = STATE(481),
    [sym_is_expression] = STATE(474),
    [sym_in_expression] = STATE(474),
    [sym_enum_fetch] = STATE(474),
    [sym_match_expression] = STATE(481),
    [sym_select_expression] = STATE(481),
    [sym_lock_expression] = STATE(481),
    [sym_unsafe_expression] = STATE(481),
    [sym_sql_expression] = STATE(481),
    [sym_interpreted_string_literal] = STATE(421),
    [sym_c_string_literal] = STATE(421),
    [sym_raw_string_literal] = STATE(421),
    [sym_visibility_modifiers] = STATE(3616),
    [sym_mutability_modifiers] = STATE(932),
    [sym_mutable_expression] = STATE(3390),
    [sym_expression_list] = STATE(3404),
    [sym_plain_type] = STATE(4176),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1788),
    [sym_simple_statement] = STATE(1804),
    [sym_assert_statement] = STATE(1804),
    [sym_append_statement] = STATE(1804),
    [sym_send_statement] = STATE(1804),
    [sym_var_declaration] = STATE(1796),
    [sym_assignment_statement] = STATE(1796),
    [sym_block] = STATE(1804),
    [sym_defer_statement] = STATE(1804),
    [sym_goto_statement] = STATE(1804),
    [sym_break_statement] = STATE(1804),
    [sym_continue_statement] = STATE(1804),
    [sym_return_statement] = STATE(1804),
    [sym_label_definition] = STATE(13),
    [sym_labeled_statement] = STATE(1804),
    [sym_compile_time_for_statement] = STATE(1804),
    [sym_for_statement] = STATE(1804),
    [sym_hash_statement] = STATE(1804),
    [sym_asm_statement] = STATE(1804),
    [sym_attributes] = STATE(3487),
    [sym_attribute] = STATE(3407),
    [aux_sym_source_file_repeat1] = STATE(7),
    [aux_sym_import_list_repeat1] = STATE(1805),
    [aux_sym_attributes_repeat1] = STATE(3449),
    [ts_builtin_sym_end] = ACTIONS(131),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym___global] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(31),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_struct] = ACTIONS(35),
    [anon_sym_union] = ACTIONS(37),
    [anon_sym_pub] = ACTIONS(39),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_interface] = ACTIONS(45),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_spawn] = ACTIONS(53),
    [anon_sym_json_DOTdecode] = ACTIONS(55),
    [anon_sym_LBRACK2] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_CARET] = ACTIONS(31),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [sym_none] = ACTIONS(63),
    [sym_true] = ACTIONS(63),
    [sym_false] = ACTIONS(63),
    [sym_nil] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_DOLLARif] = ACTIONS(67),
    [anon_sym_match] = ACTIONS(69),
    [anon_sym_select] = ACTIONS(71),
    [anon_sym_lock] = ACTIONS(73),
    [anon_sym_rlock] = ACTIONS(73),
    [anon_sym_unsafe] = ACTIONS(75),
    [anon_sym_sql] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(79),
    [sym_rune_literal] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_c_SQUOTE] = ACTIONS(85),
    [anon_sym_c_DQUOTE] = ACTIONS(87),
    [anon_sym_r_SQUOTE] = ACTIONS(89),
    [anon_sym_r_DQUOTE] = ACTIONS(91),
    [sym_pseudo_compile_time_identifier] = ACTIONS(93),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(105),
    [anon_sym_defer] = ACTIONS(107),
    [anon_sym_goto] = ACTIONS(109),
    [anon_sym_break] = ACTIONS(111),
    [anon_sym_continue] = ACTIONS(113),
    [anon_sym_return] = ACTIONS(115),
    [anon_sym_DOLLARfor] = ACTIONS(117),
    [anon_sym_for] = ACTIONS(119),
    [anon_sym_POUND] = ACTIONS(129),
    [anon_sym_asm] = ACTIONS(123),
    [anon_sym_AT_LBRACK] = ACTIONS(125),
  },
  [4] = {
    [sym_line_comment] = STATE(4),
    [sym_block_comment] = STATE(4),
    [sym_import_list] = STATE(9),
    [sym_import_declaration] = STATE(1920),
    [sym_const_declaration] = STATE(1788),
    [sym_global_var_declaration] = STATE(1788),
    [sym_type_declaration] = STATE(1788),
    [sym_function_declaration] = STATE(1788),
    [sym_static_method_declaration] = STATE(1788),
    [sym_struct_declaration] = STATE(1788),
    [sym_enum_declaration] = STATE(1788),
    [sym_interface_declaration] = STATE(1788),
    [sym__expression] = STATE(244),
    [sym__expression_without_blocks] = STATE(471),
    [sym__expression_with_blocks] = STATE(471),
    [sym_strictly_expression_list] = STATE(1796),
    [sym_inc_expression] = STATE(474),
    [sym_dec_expression] = STATE(474),
    [sym_or_block_expression] = STATE(474),
    [sym_option_propagation_expression] = STATE(474),
    [sym_result_propagation_expression] = STATE(474),
    [sym_anon_struct_value_expression] = STATE(481),
    [sym_go_expression] = STATE(474),
    [sym_spawn_expression] = STATE(474),
    [sym_parenthesized_expression] = STATE(474),
    [sym_call_expression] = STATE(474),
    [sym_type_initializer] = STATE(481),
    [sym_function_literal] = STATE(474),
    [sym_reference_expression] = STATE(483),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(474),
    [sym_receive_expression] = STATE(474),
    [sym_binary_expression] = STATE(474),
    [sym_as_type_cast_expression] = STATE(474),
    [sym__max_group] = STATE(474),
    [sym_literal] = STATE(446),
    [sym_map_init_expression] = STATE(481),
    [sym_array_creation] = STATE(474),
    [sym_fixed_array_creation] = STATE(474),
    [sym_selector_expression] = STATE(474),
    [sym_index_expression] = STATE(474),
    [sym_slice_expression] = STATE(474),
    [sym_if_expression] = STATE(481),
    [sym_compile_time_if_expression] = STATE(481),
    [sym_is_expression] = STATE(474),
    [sym_in_expression] = STATE(474),
    [sym_enum_fetch] = STATE(474),
    [sym_match_expression] = STATE(481),
    [sym_select_expression] = STATE(481),
    [sym_lock_expression] = STATE(481),
    [sym_unsafe_expression] = STATE(481),
    [sym_sql_expression] = STATE(481),
    [sym_interpreted_string_literal] = STATE(421),
    [sym_c_string_literal] = STATE(421),
    [sym_raw_string_literal] = STATE(421),
    [sym_visibility_modifiers] = STATE(3616),
    [sym_mutability_modifiers] = STATE(932),
    [sym_mutable_expression] = STATE(3390),
    [sym_expression_list] = STATE(3404),
    [sym_plain_type] = STATE(4176),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1788),
    [sym_simple_statement] = STATE(1804),
    [sym_assert_statement] = STATE(1804),
    [sym_append_statement] = STATE(1804),
    [sym_send_statement] = STATE(1804),
    [sym_var_declaration] = STATE(1796),
    [sym_assignment_statement] = STATE(1796),
    [sym_block] = STATE(1804),
    [sym_defer_statement] = STATE(1804),
    [sym_goto_statement] = STATE(1804),
    [sym_break_statement] = STATE(1804),
    [sym_continue_statement] = STATE(1804),
    [sym_return_statement] = STATE(1804),
    [sym_label_definition] = STATE(13),
    [sym_labeled_statement] = STATE(1804),
    [sym_compile_time_for_statement] = STATE(1804),
    [sym_for_statement] = STATE(1804),
    [sym_hash_statement] = STATE(1804),
    [sym_asm_statement] = STATE(1804),
    [sym_attributes] = STATE(3487),
    [sym_attribute] = STATE(3407),
    [aux_sym_source_file_repeat1] = STATE(10),
    [aux_sym_import_list_repeat1] = STATE(1805),
    [aux_sym_attributes_repeat1] = STATE(3449),
    [ts_builtin_sym_end] = ACTIONS(127),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym___global] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(31),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_struct] = ACTIONS(35),
    [anon_sym_union] = ACTIONS(37),
    [anon_sym_pub] = ACTIONS(39),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_interface] = ACTIONS(45),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_spawn] = ACTIONS(53),
    [anon_sym_json_DOTdecode] = ACTIONS(55),
    [anon_sym_LBRACK2] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_CARET] = ACTIONS(31),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [sym_none] = ACTIONS(63),
    [sym_true] = ACTIONS(63),
    [sym_false] = ACTIONS(63),
    [sym_nil] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_DOLLARif] = ACTIONS(67),
    [anon_sym_match] = ACTIONS(69),
    [anon_sym_select] = ACTIONS(71),
    [anon_sym_lock] = ACTIONS(73),
    [anon_sym_rlock] = ACTIONS(73),
    [anon_sym_unsafe] = ACTIONS(75),
    [anon_sym_sql] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(79),
    [sym_rune_literal] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_c_SQUOTE] = ACTIONS(85),
    [anon_sym_c_DQUOTE] = ACTIONS(87),
    [anon_sym_r_SQUOTE] = ACTIONS(89),
    [anon_sym_r_DQUOTE] = ACTIONS(91),
    [sym_pseudo_compile_time_identifier] = ACTIONS(93),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(105),
    [anon_sym_defer] = ACTIONS(107),
    [anon_sym_goto] = ACTIONS(109),
    [anon_sym_break] = ACTIONS(111),
    [anon_sym_continue] = ACTIONS(113),
    [anon_sym_return] = ACTIONS(115),
    [anon_sym_DOLLARfor] = ACTIONS(117),
    [anon_sym_for] = ACTIONS(119),
    [anon_sym_POUND] = ACTIONS(129),
    [anon_sym_asm] = ACTIONS(123),
    [anon_sym_AT_LBRACK] = ACTIONS(125),
  },
  [5] = {
    [sym_line_comment] = STATE(5),
    [sym_block_comment] = STATE(5),
    [sym_const_declaration] = STATE(1788),
    [sym_global_var_declaration] = STATE(1788),
    [sym_type_declaration] = STATE(1788),
    [sym_function_declaration] = STATE(1788),
    [sym_static_method_declaration] = STATE(1788),
    [sym_struct_declaration] = STATE(1788),
    [sym_enum_declaration] = STATE(1788),
    [sym_interface_declaration] = STATE(1788),
    [sym__expression] = STATE(244),
    [sym__expression_without_blocks] = STATE(471),
    [sym__expression_with_blocks] = STATE(471),
    [sym_strictly_expression_list] = STATE(1796),
    [sym_inc_expression] = STATE(474),
    [sym_dec_expression] = STATE(474),
    [sym_or_block_expression] = STATE(474),
    [sym_option_propagation_expression] = STATE(474),
    [sym_result_propagation_expression] = STATE(474),
    [sym_anon_struct_value_expression] = STATE(481),
    [sym_go_expression] = STATE(474),
    [sym_spawn_expression] = STATE(474),
    [sym_parenthesized_expression] = STATE(474),
    [sym_call_expression] = STATE(474),
    [sym_type_initializer] = STATE(481),
    [sym_function_literal] = STATE(474),
    [sym_reference_expression] = STATE(483),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(474),
    [sym_receive_expression] = STATE(474),
    [sym_binary_expression] = STATE(474),
    [sym_as_type_cast_expression] = STATE(474),
    [sym__max_group] = STATE(474),
    [sym_literal] = STATE(446),
    [sym_map_init_expression] = STATE(481),
    [sym_array_creation] = STATE(474),
    [sym_fixed_array_creation] = STATE(474),
    [sym_selector_expression] = STATE(474),
    [sym_index_expression] = STATE(474),
    [sym_slice_expression] = STATE(474),
    [sym_if_expression] = STATE(481),
    [sym_compile_time_if_expression] = STATE(481),
    [sym_is_expression] = STATE(474),
    [sym_in_expression] = STATE(474),
    [sym_enum_fetch] = STATE(474),
    [sym_match_expression] = STATE(481),
    [sym_select_expression] = STATE(481),
    [sym_lock_expression] = STATE(481),
    [sym_unsafe_expression] = STATE(481),
    [sym_sql_expression] = STATE(481),
    [sym_interpreted_string_literal] = STATE(421),
    [sym_c_string_literal] = STATE(421),
    [sym_raw_string_literal] = STATE(421),
    [sym_visibility_modifiers] = STATE(3616),
    [sym_mutability_modifiers] = STATE(932),
    [sym_mutable_expression] = STATE(3390),
    [sym_expression_list] = STATE(3404),
    [sym_plain_type] = STATE(4176),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1788),
    [sym_simple_statement] = STATE(1804),
    [sym_assert_statement] = STATE(1804),
    [sym_append_statement] = STATE(1804),
    [sym_send_statement] = STATE(1804),
    [sym_var_declaration] = STATE(1796),
    [sym_assignment_statement] = STATE(1796),
    [sym_block] = STATE(1804),
    [sym_defer_statement] = STATE(1804),
    [sym_goto_statement] = STATE(1804),
    [sym_break_statement] = STATE(1804),
    [sym_continue_statement] = STATE(1804),
    [sym_return_statement] = STATE(1804),
    [sym_label_definition] = STATE(13),
    [sym_labeled_statement] = STATE(1804),
    [sym_compile_time_for_statement] = STATE(1804),
    [sym_for_statement] = STATE(1804),
    [sym_hash_statement] = STATE(1804),
    [sym_asm_statement] = STATE(1804),
    [sym_attributes] = STATE(3487),
    [sym_attribute] = STATE(3407),
    [aux_sym_source_file_repeat1] = STATE(10),
    [aux_sym_attributes_repeat1] = STATE(3449),
    [ts_builtin_sym_end] = ACTIONS(127),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym___global] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(31),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_struct] = ACTIONS(35),
    [anon_sym_union] = ACTIONS(37),
    [anon_sym_pub] = ACTIONS(39),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_interface] = ACTIONS(45),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_spawn] = ACTIONS(53),
    [anon_sym_json_DOTdecode] = ACTIONS(55),
    [anon_sym_LBRACK2] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_CARET] = ACTIONS(31),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [sym_none] = ACTIONS(63),
    [sym_true] = ACTIONS(63),
    [sym_false] = ACTIONS(63),
    [sym_nil] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_DOLLARif] = ACTIONS(67),
    [anon_sym_match] = ACTIONS(69),
    [anon_sym_select] = ACTIONS(71),
    [anon_sym_lock] = ACTIONS(73),
    [anon_sym_rlock] = ACTIONS(73),
    [anon_sym_unsafe] = ACTIONS(75),
    [anon_sym_sql] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(79),
    [sym_rune_literal] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_c_SQUOTE] = ACTIONS(85),
    [anon_sym_c_DQUOTE] = ACTIONS(87),
    [anon_sym_r_SQUOTE] = ACTIONS(89),
    [anon_sym_r_DQUOTE] = ACTIONS(91),
    [sym_pseudo_compile_time_identifier] = ACTIONS(93),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(105),
    [anon_sym_defer] = ACTIONS(107),
    [anon_sym_goto] = ACTIONS(109),
    [anon_sym_break] = ACTIONS(111),
    [anon_sym_continue] = ACTIONS(113),
    [anon_sym_return] = ACTIONS(115),
    [anon_sym_DOLLARfor] = ACTIONS(117),
    [anon_sym_for] = ACTIONS(119),
    [anon_sym_POUND] = ACTIONS(129),
    [anon_sym_asm] = ACTIONS(123),
    [anon_sym_AT_LBRACK] = ACTIONS(125),
  },
  [6] = {
    [sym_line_comment] = STATE(6),
    [sym_block_comment] = STATE(6),
    [sym_const_declaration] = STATE(1788),
    [sym_global_var_declaration] = STATE(1788),
    [sym_type_declaration] = STATE(1788),
    [sym_function_declaration] = STATE(1788),
    [sym_static_method_declaration] = STATE(1788),
    [sym_struct_declaration] = STATE(1788),
    [sym_enum_declaration] = STATE(1788),
    [sym_interface_declaration] = STATE(1788),
    [sym__expression] = STATE(244),
    [sym__expression_without_blocks] = STATE(471),
    [sym__expression_with_blocks] = STATE(471),
    [sym_strictly_expression_list] = STATE(1796),
    [sym_inc_expression] = STATE(474),
    [sym_dec_expression] = STATE(474),
    [sym_or_block_expression] = STATE(474),
    [sym_option_propagation_expression] = STATE(474),
    [sym_result_propagation_expression] = STATE(474),
    [sym_anon_struct_value_expression] = STATE(481),
    [sym_go_expression] = STATE(474),
    [sym_spawn_expression] = STATE(474),
    [sym_parenthesized_expression] = STATE(474),
    [sym_call_expression] = STATE(474),
    [sym_type_initializer] = STATE(481),
    [sym_function_literal] = STATE(474),
    [sym_reference_expression] = STATE(483),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(474),
    [sym_receive_expression] = STATE(474),
    [sym_binary_expression] = STATE(474),
    [sym_as_type_cast_expression] = STATE(474),
    [sym__max_group] = STATE(474),
    [sym_literal] = STATE(446),
    [sym_map_init_expression] = STATE(481),
    [sym_array_creation] = STATE(474),
    [sym_fixed_array_creation] = STATE(474),
    [sym_selector_expression] = STATE(474),
    [sym_index_expression] = STATE(474),
    [sym_slice_expression] = STATE(474),
    [sym_if_expression] = STATE(481),
    [sym_compile_time_if_expression] = STATE(481),
    [sym_is_expression] = STATE(474),
    [sym_in_expression] = STATE(474),
    [sym_enum_fetch] = STATE(474),
    [sym_match_expression] = STATE(481),
    [sym_select_expression] = STATE(481),
    [sym_lock_expression] = STATE(481),
    [sym_unsafe_expression] = STATE(481),
    [sym_sql_expression] = STATE(481),
    [sym_interpreted_string_literal] = STATE(421),
    [sym_c_string_literal] = STATE(421),
    [sym_raw_string_literal] = STATE(421),
    [sym_visibility_modifiers] = STATE(3616),
    [sym_mutability_modifiers] = STATE(932),
    [sym_mutable_expression] = STATE(3390),
    [sym_expression_list] = STATE(3404),
    [sym_plain_type] = STATE(4176),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1788),
    [sym_simple_statement] = STATE(1804),
    [sym_assert_statement] = STATE(1804),
    [sym_append_statement] = STATE(1804),
    [sym_send_statement] = STATE(1804),
    [sym_var_declaration] = STATE(1796),
    [sym_assignment_statement] = STATE(1796),
    [sym_block] = STATE(1804),
    [sym_defer_statement] = STATE(1804),
    [sym_goto_statement] = STATE(1804),
    [sym_break_statement] = STATE(1804),
    [sym_continue_statement] = STATE(1804),
    [sym_return_statement] = STATE(1804),
    [sym_label_definition] = STATE(13),
    [sym_labeled_statement] = STATE(1804),
    [sym_compile_time_for_statement] = STATE(1804),
    [sym_for_statement] = STATE(1804),
    [sym_hash_statement] = STATE(1804),
    [sym_asm_statement] = STATE(1804),
    [sym_attributes] = STATE(3487),
    [sym_attribute] = STATE(3407),
    [aux_sym_source_file_repeat1] = STATE(12),
    [aux_sym_attributes_repeat1] = STATE(3449),
    [ts_builtin_sym_end] = ACTIONS(133),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym___global] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(31),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_struct] = ACTIONS(35),
    [anon_sym_union] = ACTIONS(37),
    [anon_sym_pub] = ACTIONS(39),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_interface] = ACTIONS(45),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_spawn] = ACTIONS(53),
    [anon_sym_json_DOTdecode] = ACTIONS(55),
    [anon_sym_LBRACK2] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_CARET] = ACTIONS(31),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [sym_none] = ACTIONS(63),
    [sym_true] = ACTIONS(63),
    [sym_false] = ACTIONS(63),
    [sym_nil] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_DOLLARif] = ACTIONS(67),
    [anon_sym_match] = ACTIONS(69),
    [anon_sym_select] = ACTIONS(71),
    [anon_sym_lock] = ACTIONS(73),
    [anon_sym_rlock] = ACTIONS(73),
    [anon_sym_unsafe] = ACTIONS(75),
    [anon_sym_sql] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(79),
    [sym_rune_literal] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_c_SQUOTE] = ACTIONS(85),
    [anon_sym_c_DQUOTE] = ACTIONS(87),
    [anon_sym_r_SQUOTE] = ACTIONS(89),
    [anon_sym_r_DQUOTE] = ACTIONS(91),
    [sym_pseudo_compile_time_identifier] = ACTIONS(93),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(105),
    [anon_sym_defer] = ACTIONS(107),
    [anon_sym_goto] = ACTIONS(109),
    [anon_sym_break] = ACTIONS(111),
    [anon_sym_continue] = ACTIONS(113),
    [anon_sym_return] = ACTIONS(115),
    [anon_sym_DOLLARfor] = ACTIONS(117),
    [anon_sym_for] = ACTIONS(119),
    [anon_sym_POUND] = ACTIONS(129),
    [anon_sym_asm] = ACTIONS(123),
    [anon_sym_AT_LBRACK] = ACTIONS(125),
  },
  [7] = {
    [sym_line_comment] = STATE(7),
    [sym_block_comment] = STATE(7),
    [sym_const_declaration] = STATE(1788),
    [sym_global_var_declaration] = STATE(1788),
    [sym_type_declaration] = STATE(1788),
    [sym_function_declaration] = STATE(1788),
    [sym_static_method_declaration] = STATE(1788),
    [sym_struct_declaration] = STATE(1788),
    [sym_enum_declaration] = STATE(1788),
    [sym_interface_declaration] = STATE(1788),
    [sym__expression] = STATE(244),
    [sym__expression_without_blocks] = STATE(471),
    [sym__expression_with_blocks] = STATE(471),
    [sym_strictly_expression_list] = STATE(1796),
    [sym_inc_expression] = STATE(474),
    [sym_dec_expression] = STATE(474),
    [sym_or_block_expression] = STATE(474),
    [sym_option_propagation_expression] = STATE(474),
    [sym_result_propagation_expression] = STATE(474),
    [sym_anon_struct_value_expression] = STATE(481),
    [sym_go_expression] = STATE(474),
    [sym_spawn_expression] = STATE(474),
    [sym_parenthesized_expression] = STATE(474),
    [sym_call_expression] = STATE(474),
    [sym_type_initializer] = STATE(481),
    [sym_function_literal] = STATE(474),
    [sym_reference_expression] = STATE(483),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(474),
    [sym_receive_expression] = STATE(474),
    [sym_binary_expression] = STATE(474),
    [sym_as_type_cast_expression] = STATE(474),
    [sym__max_group] = STATE(474),
    [sym_literal] = STATE(446),
    [sym_map_init_expression] = STATE(481),
    [sym_array_creation] = STATE(474),
    [sym_fixed_array_creation] = STATE(474),
    [sym_selector_expression] = STATE(474),
    [sym_index_expression] = STATE(474),
    [sym_slice_expression] = STATE(474),
    [sym_if_expression] = STATE(481),
    [sym_compile_time_if_expression] = STATE(481),
    [sym_is_expression] = STATE(474),
    [sym_in_expression] = STATE(474),
    [sym_enum_fetch] = STATE(474),
    [sym_match_expression] = STATE(481),
    [sym_select_expression] = STATE(481),
    [sym_lock_expression] = STATE(481),
    [sym_unsafe_expression] = STATE(481),
    [sym_sql_expression] = STATE(481),
    [sym_interpreted_string_literal] = STATE(421),
    [sym_c_string_literal] = STATE(421),
    [sym_raw_string_literal] = STATE(421),
    [sym_visibility_modifiers] = STATE(3616),
    [sym_mutability_modifiers] = STATE(932),
    [sym_mutable_expression] = STATE(3390),
    [sym_expression_list] = STATE(3404),
    [sym_plain_type] = STATE(4176),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1788),
    [sym_simple_statement] = STATE(1804),
    [sym_assert_statement] = STATE(1804),
    [sym_append_statement] = STATE(1804),
    [sym_send_statement] = STATE(1804),
    [sym_var_declaration] = STATE(1796),
    [sym_assignment_statement] = STATE(1796),
    [sym_block] = STATE(1804),
    [sym_defer_statement] = STATE(1804),
    [sym_goto_statement] = STATE(1804),
    [sym_break_statement] = STATE(1804),
    [sym_continue_statement] = STATE(1804),
    [sym_return_statement] = STATE(1804),
    [sym_label_definition] = STATE(13),
    [sym_labeled_statement] = STATE(1804),
    [sym_compile_time_for_statement] = STATE(1804),
    [sym_for_statement] = STATE(1804),
    [sym_hash_statement] = STATE(1804),
    [sym_asm_statement] = STATE(1804),
    [sym_attributes] = STATE(3487),
    [sym_attribute] = STATE(3407),
    [aux_sym_source_file_repeat1] = STATE(12),
    [aux_sym_attributes_repeat1] = STATE(3449),
    [ts_builtin_sym_end] = ACTIONS(135),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym___global] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(31),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_struct] = ACTIONS(35),
    [anon_sym_union] = ACTIONS(37),
    [anon_sym_pub] = ACTIONS(39),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_interface] = ACTIONS(45),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_spawn] = ACTIONS(53),
    [anon_sym_json_DOTdecode] = ACTIONS(55),
    [anon_sym_LBRACK2] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_CARET] = ACTIONS(31),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [sym_none] = ACTIONS(63),
    [sym_true] = ACTIONS(63),
    [sym_false] = ACTIONS(63),
    [sym_nil] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_DOLLARif] = ACTIONS(67),
    [anon_sym_match] = ACTIONS(69),
    [anon_sym_select] = ACTIONS(71),
    [anon_sym_lock] = ACTIONS(73),
    [anon_sym_rlock] = ACTIONS(73),
    [anon_sym_unsafe] = ACTIONS(75),
    [anon_sym_sql] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(79),
    [sym_rune_literal] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_c_SQUOTE] = ACTIONS(85),
    [anon_sym_c_DQUOTE] = ACTIONS(87),
    [anon_sym_r_SQUOTE] = ACTIONS(89),
    [anon_sym_r_DQUOTE] = ACTIONS(91),
    [sym_pseudo_compile_time_identifier] = ACTIONS(93),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(105),
    [anon_sym_defer] = ACTIONS(107),
    [anon_sym_goto] = ACTIONS(109),
    [anon_sym_break] = ACTIONS(111),
    [anon_sym_continue] = ACTIONS(113),
    [anon_sym_return] = ACTIONS(115),
    [anon_sym_DOLLARfor] = ACTIONS(117),
    [anon_sym_for] = ACTIONS(119),
    [anon_sym_POUND] = ACTIONS(129),
    [anon_sym_asm] = ACTIONS(123),
    [anon_sym_AT_LBRACK] = ACTIONS(125),
  },
  [8] = {
    [sym_line_comment] = STATE(8),
    [sym_block_comment] = STATE(8),
    [sym_const_declaration] = STATE(1788),
    [sym_global_var_declaration] = STATE(1788),
    [sym_type_declaration] = STATE(1788),
    [sym_function_declaration] = STATE(1788),
    [sym_static_method_declaration] = STATE(1788),
    [sym_struct_declaration] = STATE(1788),
    [sym_enum_declaration] = STATE(1788),
    [sym_interface_declaration] = STATE(1788),
    [sym__expression] = STATE(244),
    [sym__expression_without_blocks] = STATE(471),
    [sym__expression_with_blocks] = STATE(471),
    [sym_strictly_expression_list] = STATE(1796),
    [sym_inc_expression] = STATE(474),
    [sym_dec_expression] = STATE(474),
    [sym_or_block_expression] = STATE(474),
    [sym_option_propagation_expression] = STATE(474),
    [sym_result_propagation_expression] = STATE(474),
    [sym_anon_struct_value_expression] = STATE(481),
    [sym_go_expression] = STATE(474),
    [sym_spawn_expression] = STATE(474),
    [sym_parenthesized_expression] = STATE(474),
    [sym_call_expression] = STATE(474),
    [sym_type_initializer] = STATE(481),
    [sym_function_literal] = STATE(474),
    [sym_reference_expression] = STATE(483),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(474),
    [sym_receive_expression] = STATE(474),
    [sym_binary_expression] = STATE(474),
    [sym_as_type_cast_expression] = STATE(474),
    [sym__max_group] = STATE(474),
    [sym_literal] = STATE(446),
    [sym_map_init_expression] = STATE(481),
    [sym_array_creation] = STATE(474),
    [sym_fixed_array_creation] = STATE(474),
    [sym_selector_expression] = STATE(474),
    [sym_index_expression] = STATE(474),
    [sym_slice_expression] = STATE(474),
    [sym_if_expression] = STATE(481),
    [sym_compile_time_if_expression] = STATE(481),
    [sym_is_expression] = STATE(474),
    [sym_in_expression] = STATE(474),
    [sym_enum_fetch] = STATE(474),
    [sym_match_expression] = STATE(481),
    [sym_select_expression] = STATE(481),
    [sym_lock_expression] = STATE(481),
    [sym_unsafe_expression] = STATE(481),
    [sym_sql_expression] = STATE(481),
    [sym_interpreted_string_literal] = STATE(421),
    [sym_c_string_literal] = STATE(421),
    [sym_raw_string_literal] = STATE(421),
    [sym_visibility_modifiers] = STATE(3616),
    [sym_mutability_modifiers] = STATE(932),
    [sym_mutable_expression] = STATE(3390),
    [sym_expression_list] = STATE(3404),
    [sym_plain_type] = STATE(4176),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1788),
    [sym_simple_statement] = STATE(1804),
    [sym_assert_statement] = STATE(1804),
    [sym_append_statement] = STATE(1804),
    [sym_send_statement] = STATE(1804),
    [sym_var_declaration] = STATE(1796),
    [sym_assignment_statement] = STATE(1796),
    [sym_block] = STATE(1804),
    [sym_defer_statement] = STATE(1804),
    [sym_goto_statement] = STATE(1804),
    [sym_break_statement] = STATE(1804),
    [sym_continue_statement] = STATE(1804),
    [sym_return_statement] = STATE(1804),
    [sym_label_definition] = STATE(13),
    [sym_labeled_statement] = STATE(1804),
    [sym_compile_time_for_statement] = STATE(1804),
    [sym_for_statement] = STATE(1804),
    [sym_hash_statement] = STATE(1804),
    [sym_asm_statement] = STATE(1804),
    [sym_attributes] = STATE(3487),
    [sym_attribute] = STATE(3407),
    [aux_sym_source_file_repeat1] = STATE(6),
    [aux_sym_attributes_repeat1] = STATE(3449),
    [ts_builtin_sym_end] = ACTIONS(135),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym___global] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(31),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_struct] = ACTIONS(35),
    [anon_sym_union] = ACTIONS(37),
    [anon_sym_pub] = ACTIONS(39),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_interface] = ACTIONS(45),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_spawn] = ACTIONS(53),
    [anon_sym_json_DOTdecode] = ACTIONS(55),
    [anon_sym_LBRACK2] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_CARET] = ACTIONS(31),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [sym_none] = ACTIONS(63),
    [sym_true] = ACTIONS(63),
    [sym_false] = ACTIONS(63),
    [sym_nil] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_DOLLARif] = ACTIONS(67),
    [anon_sym_match] = ACTIONS(69),
    [anon_sym_select] = ACTIONS(71),
    [anon_sym_lock] = ACTIONS(73),
    [anon_sym_rlock] = ACTIONS(73),
    [anon_sym_unsafe] = ACTIONS(75),
    [anon_sym_sql] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(79),
    [sym_rune_literal] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_c_SQUOTE] = ACTIONS(85),
    [anon_sym_c_DQUOTE] = ACTIONS(87),
    [anon_sym_r_SQUOTE] = ACTIONS(89),
    [anon_sym_r_DQUOTE] = ACTIONS(91),
    [sym_pseudo_compile_time_identifier] = ACTIONS(93),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(105),
    [anon_sym_defer] = ACTIONS(107),
    [anon_sym_goto] = ACTIONS(109),
    [anon_sym_break] = ACTIONS(111),
    [anon_sym_continue] = ACTIONS(113),
    [anon_sym_return] = ACTIONS(115),
    [anon_sym_DOLLARfor] = ACTIONS(117),
    [anon_sym_for] = ACTIONS(119),
    [anon_sym_POUND] = ACTIONS(129),
    [anon_sym_asm] = ACTIONS(123),
    [anon_sym_AT_LBRACK] = ACTIONS(125),
  },
  [9] = {
    [sym_line_comment] = STATE(9),
    [sym_block_comment] = STATE(9),
    [sym_const_declaration] = STATE(1788),
    [sym_global_var_declaration] = STATE(1788),
    [sym_type_declaration] = STATE(1788),
    [sym_function_declaration] = STATE(1788),
    [sym_static_method_declaration] = STATE(1788),
    [sym_struct_declaration] = STATE(1788),
    [sym_enum_declaration] = STATE(1788),
    [sym_interface_declaration] = STATE(1788),
    [sym__expression] = STATE(244),
    [sym__expression_without_blocks] = STATE(471),
    [sym__expression_with_blocks] = STATE(471),
    [sym_strictly_expression_list] = STATE(1796),
    [sym_inc_expression] = STATE(474),
    [sym_dec_expression] = STATE(474),
    [sym_or_block_expression] = STATE(474),
    [sym_option_propagation_expression] = STATE(474),
    [sym_result_propagation_expression] = STATE(474),
    [sym_anon_struct_value_expression] = STATE(481),
    [sym_go_expression] = STATE(474),
    [sym_spawn_expression] = STATE(474),
    [sym_parenthesized_expression] = STATE(474),
    [sym_call_expression] = STATE(474),
    [sym_type_initializer] = STATE(481),
    [sym_function_literal] = STATE(474),
    [sym_reference_expression] = STATE(483),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(474),
    [sym_receive_expression] = STATE(474),
    [sym_binary_expression] = STATE(474),
    [sym_as_type_cast_expression] = STATE(474),
    [sym__max_group] = STATE(474),
    [sym_literal] = STATE(446),
    [sym_map_init_expression] = STATE(481),
    [sym_array_creation] = STATE(474),
    [sym_fixed_array_creation] = STATE(474),
    [sym_selector_expression] = STATE(474),
    [sym_index_expression] = STATE(474),
    [sym_slice_expression] = STATE(474),
    [sym_if_expression] = STATE(481),
    [sym_compile_time_if_expression] = STATE(481),
    [sym_is_expression] = STATE(474),
    [sym_in_expression] = STATE(474),
    [sym_enum_fetch] = STATE(474),
    [sym_match_expression] = STATE(481),
    [sym_select_expression] = STATE(481),
    [sym_lock_expression] = STATE(481),
    [sym_unsafe_expression] = STATE(481),
    [sym_sql_expression] = STATE(481),
    [sym_interpreted_string_literal] = STATE(421),
    [sym_c_string_literal] = STATE(421),
    [sym_raw_string_literal] = STATE(421),
    [sym_visibility_modifiers] = STATE(3616),
    [sym_mutability_modifiers] = STATE(932),
    [sym_mutable_expression] = STATE(3390),
    [sym_expression_list] = STATE(3404),
    [sym_plain_type] = STATE(4176),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1788),
    [sym_simple_statement] = STATE(1804),
    [sym_assert_statement] = STATE(1804),
    [sym_append_statement] = STATE(1804),
    [sym_send_statement] = STATE(1804),
    [sym_var_declaration] = STATE(1796),
    [sym_assignment_statement] = STATE(1796),
    [sym_block] = STATE(1804),
    [sym_defer_statement] = STATE(1804),
    [sym_goto_statement] = STATE(1804),
    [sym_break_statement] = STATE(1804),
    [sym_continue_statement] = STATE(1804),
    [sym_return_statement] = STATE(1804),
    [sym_label_definition] = STATE(13),
    [sym_labeled_statement] = STATE(1804),
    [sym_compile_time_for_statement] = STATE(1804),
    [sym_for_statement] = STATE(1804),
    [sym_hash_statement] = STATE(1804),
    [sym_asm_statement] = STATE(1804),
    [sym_attributes] = STATE(3487),
    [sym_attribute] = STATE(3407),
    [aux_sym_source_file_repeat1] = STATE(7),
    [aux_sym_attributes_repeat1] = STATE(3449),
    [ts_builtin_sym_end] = ACTIONS(131),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym___global] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(31),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_struct] = ACTIONS(35),
    [anon_sym_union] = ACTIONS(37),
    [anon_sym_pub] = ACTIONS(39),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_interface] = ACTIONS(45),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_spawn] = ACTIONS(53),
    [anon_sym_json_DOTdecode] = ACTIONS(55),
    [anon_sym_LBRACK2] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_CARET] = ACTIONS(31),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [sym_none] = ACTIONS(63),
    [sym_true] = ACTIONS(63),
    [sym_false] = ACTIONS(63),
    [sym_nil] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_DOLLARif] = ACTIONS(67),
    [anon_sym_match] = ACTIONS(69),
    [anon_sym_select] = ACTIONS(71),
    [anon_sym_lock] = ACTIONS(73),
    [anon_sym_rlock] = ACTIONS(73),
    [anon_sym_unsafe] = ACTIONS(75),
    [anon_sym_sql] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(79),
    [sym_rune_literal] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_c_SQUOTE] = ACTIONS(85),
    [anon_sym_c_DQUOTE] = ACTIONS(87),
    [anon_sym_r_SQUOTE] = ACTIONS(89),
    [anon_sym_r_DQUOTE] = ACTIONS(91),
    [sym_pseudo_compile_time_identifier] = ACTIONS(93),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(105),
    [anon_sym_defer] = ACTIONS(107),
    [anon_sym_goto] = ACTIONS(109),
    [anon_sym_break] = ACTIONS(111),
    [anon_sym_continue] = ACTIONS(113),
    [anon_sym_return] = ACTIONS(115),
    [anon_sym_DOLLARfor] = ACTIONS(117),
    [anon_sym_for] = ACTIONS(119),
    [anon_sym_POUND] = ACTIONS(129),
    [anon_sym_asm] = ACTIONS(123),
    [anon_sym_AT_LBRACK] = ACTIONS(125),
  },
  [10] = {
    [sym_line_comment] = STATE(10),
    [sym_block_comment] = STATE(10),
    [sym_const_declaration] = STATE(1788),
    [sym_global_var_declaration] = STATE(1788),
    [sym_type_declaration] = STATE(1788),
    [sym_function_declaration] = STATE(1788),
    [sym_static_method_declaration] = STATE(1788),
    [sym_struct_declaration] = STATE(1788),
    [sym_enum_declaration] = STATE(1788),
    [sym_interface_declaration] = STATE(1788),
    [sym__expression] = STATE(244),
    [sym__expression_without_blocks] = STATE(471),
    [sym__expression_with_blocks] = STATE(471),
    [sym_strictly_expression_list] = STATE(1796),
    [sym_inc_expression] = STATE(474),
    [sym_dec_expression] = STATE(474),
    [sym_or_block_expression] = STATE(474),
    [sym_option_propagation_expression] = STATE(474),
    [sym_result_propagation_expression] = STATE(474),
    [sym_anon_struct_value_expression] = STATE(481),
    [sym_go_expression] = STATE(474),
    [sym_spawn_expression] = STATE(474),
    [sym_parenthesized_expression] = STATE(474),
    [sym_call_expression] = STATE(474),
    [sym_type_initializer] = STATE(481),
    [sym_function_literal] = STATE(474),
    [sym_reference_expression] = STATE(483),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(474),
    [sym_receive_expression] = STATE(474),
    [sym_binary_expression] = STATE(474),
    [sym_as_type_cast_expression] = STATE(474),
    [sym__max_group] = STATE(474),
    [sym_literal] = STATE(446),
    [sym_map_init_expression] = STATE(481),
    [sym_array_creation] = STATE(474),
    [sym_fixed_array_creation] = STATE(474),
    [sym_selector_expression] = STATE(474),
    [sym_index_expression] = STATE(474),
    [sym_slice_expression] = STATE(474),
    [sym_if_expression] = STATE(481),
    [sym_compile_time_if_expression] = STATE(481),
    [sym_is_expression] = STATE(474),
    [sym_in_expression] = STATE(474),
    [sym_enum_fetch] = STATE(474),
    [sym_match_expression] = STATE(481),
    [sym_select_expression] = STATE(481),
    [sym_lock_expression] = STATE(481),
    [sym_unsafe_expression] = STATE(481),
    [sym_sql_expression] = STATE(481),
    [sym_interpreted_string_literal] = STATE(421),
    [sym_c_string_literal] = STATE(421),
    [sym_raw_string_literal] = STATE(421),
    [sym_visibility_modifiers] = STATE(3616),
    [sym_mutability_modifiers] = STATE(932),
    [sym_mutable_expression] = STATE(3390),
    [sym_expression_list] = STATE(3404),
    [sym_plain_type] = STATE(4176),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1788),
    [sym_simple_statement] = STATE(1804),
    [sym_assert_statement] = STATE(1804),
    [sym_append_statement] = STATE(1804),
    [sym_send_statement] = STATE(1804),
    [sym_var_declaration] = STATE(1796),
    [sym_assignment_statement] = STATE(1796),
    [sym_block] = STATE(1804),
    [sym_defer_statement] = STATE(1804),
    [sym_goto_statement] = STATE(1804),
    [sym_break_statement] = STATE(1804),
    [sym_continue_statement] = STATE(1804),
    [sym_return_statement] = STATE(1804),
    [sym_label_definition] = STATE(13),
    [sym_labeled_statement] = STATE(1804),
    [sym_compile_time_for_statement] = STATE(1804),
    [sym_for_statement] = STATE(1804),
    [sym_hash_statement] = STATE(1804),
    [sym_asm_statement] = STATE(1804),
    [sym_attributes] = STATE(3487),
    [sym_attribute] = STATE(3407),
    [aux_sym_source_file_repeat1] = STATE(12),
    [aux_sym_attributes_repeat1] = STATE(3449),
    [ts_builtin_sym_end] = ACTIONS(131),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym___global] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(31),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_struct] = ACTIONS(35),
    [anon_sym_union] = ACTIONS(37),
    [anon_sym_pub] = ACTIONS(39),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_interface] = ACTIONS(45),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_spawn] = ACTIONS(53),
    [anon_sym_json_DOTdecode] = ACTIONS(55),
    [anon_sym_LBRACK2] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_CARET] = ACTIONS(31),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [sym_none] = ACTIONS(63),
    [sym_true] = ACTIONS(63),
    [sym_false] = ACTIONS(63),
    [sym_nil] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_DOLLARif] = ACTIONS(67),
    [anon_sym_match] = ACTIONS(69),
    [anon_sym_select] = ACTIONS(71),
    [anon_sym_lock] = ACTIONS(73),
    [anon_sym_rlock] = ACTIONS(73),
    [anon_sym_unsafe] = ACTIONS(75),
    [anon_sym_sql] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(79),
    [sym_rune_literal] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_c_SQUOTE] = ACTIONS(85),
    [anon_sym_c_DQUOTE] = ACTIONS(87),
    [anon_sym_r_SQUOTE] = ACTIONS(89),
    [anon_sym_r_DQUOTE] = ACTIONS(91),
    [sym_pseudo_compile_time_identifier] = ACTIONS(93),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(105),
    [anon_sym_defer] = ACTIONS(107),
    [anon_sym_goto] = ACTIONS(109),
    [anon_sym_break] = ACTIONS(111),
    [anon_sym_continue] = ACTIONS(113),
    [anon_sym_return] = ACTIONS(115),
    [anon_sym_DOLLARfor] = ACTIONS(117),
    [anon_sym_for] = ACTIONS(119),
    [anon_sym_POUND] = ACTIONS(129),
    [anon_sym_asm] = ACTIONS(123),
    [anon_sym_AT_LBRACK] = ACTIONS(125),
  },
  [11] = {
    [sym_line_comment] = STATE(11),
    [sym_block_comment] = STATE(11),
    [sym_const_declaration] = STATE(1788),
    [sym_global_var_declaration] = STATE(1788),
    [sym_type_declaration] = STATE(1788),
    [sym_function_declaration] = STATE(1788),
    [sym_static_method_declaration] = STATE(1788),
    [sym_struct_declaration] = STATE(1788),
    [sym_enum_declaration] = STATE(1788),
    [sym_interface_declaration] = STATE(1788),
    [sym__expression] = STATE(244),
    [sym__expression_without_blocks] = STATE(471),
    [sym__expression_with_blocks] = STATE(471),
    [sym_strictly_expression_list] = STATE(1796),
    [sym_inc_expression] = STATE(474),
    [sym_dec_expression] = STATE(474),
    [sym_or_block_expression] = STATE(474),
    [sym_option_propagation_expression] = STATE(474),
    [sym_result_propagation_expression] = STATE(474),
    [sym_anon_struct_value_expression] = STATE(481),
    [sym_go_expression] = STATE(474),
    [sym_spawn_expression] = STATE(474),
    [sym_parenthesized_expression] = STATE(474),
    [sym_call_expression] = STATE(474),
    [sym_type_initializer] = STATE(481),
    [sym_function_literal] = STATE(474),
    [sym_reference_expression] = STATE(483),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(474),
    [sym_receive_expression] = STATE(474),
    [sym_binary_expression] = STATE(474),
    [sym_as_type_cast_expression] = STATE(474),
    [sym__max_group] = STATE(474),
    [sym_literal] = STATE(446),
    [sym_map_init_expression] = STATE(481),
    [sym_array_creation] = STATE(474),
    [sym_fixed_array_creation] = STATE(474),
    [sym_selector_expression] = STATE(474),
    [sym_index_expression] = STATE(474),
    [sym_slice_expression] = STATE(474),
    [sym_if_expression] = STATE(481),
    [sym_compile_time_if_expression] = STATE(481),
    [sym_is_expression] = STATE(474),
    [sym_in_expression] = STATE(474),
    [sym_enum_fetch] = STATE(474),
    [sym_match_expression] = STATE(481),
    [sym_select_expression] = STATE(481),
    [sym_lock_expression] = STATE(481),
    [sym_unsafe_expression] = STATE(481),
    [sym_sql_expression] = STATE(481),
    [sym_interpreted_string_literal] = STATE(421),
    [sym_c_string_literal] = STATE(421),
    [sym_raw_string_literal] = STATE(421),
    [sym_visibility_modifiers] = STATE(3616),
    [sym_mutability_modifiers] = STATE(932),
    [sym_mutable_expression] = STATE(3390),
    [sym_expression_list] = STATE(3404),
    [sym_plain_type] = STATE(4176),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1788),
    [sym_simple_statement] = STATE(1804),
    [sym_assert_statement] = STATE(1804),
    [sym_append_statement] = STATE(1804),
    [sym_send_statement] = STATE(1804),
    [sym_var_declaration] = STATE(1796),
    [sym_assignment_statement] = STATE(1796),
    [sym_block] = STATE(1804),
    [sym_defer_statement] = STATE(1804),
    [sym_goto_statement] = STATE(1804),
    [sym_break_statement] = STATE(1804),
    [sym_continue_statement] = STATE(1804),
    [sym_return_statement] = STATE(1804),
    [sym_label_definition] = STATE(13),
    [sym_labeled_statement] = STATE(1804),
    [sym_compile_time_for_statement] = STATE(1804),
    [sym_for_statement] = STATE(1804),
    [sym_hash_statement] = STATE(1804),
    [sym_asm_statement] = STATE(1804),
    [sym_attributes] = STATE(3487),
    [sym_attribute] = STATE(3407),
    [aux_sym_source_file_repeat1] = STATE(12),
    [aux_sym_attributes_repeat1] = STATE(3449),
    [ts_builtin_sym_end] = ACTIONS(127),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym___global] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(31),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_struct] = ACTIONS(35),
    [anon_sym_union] = ACTIONS(37),
    [anon_sym_pub] = ACTIONS(39),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_interface] = ACTIONS(45),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_spawn] = ACTIONS(53),
    [anon_sym_json_DOTdecode] = ACTIONS(55),
    [anon_sym_LBRACK2] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_CARET] = ACTIONS(31),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [sym_none] = ACTIONS(63),
    [sym_true] = ACTIONS(63),
    [sym_false] = ACTIONS(63),
    [sym_nil] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_DOLLARif] = ACTIONS(67),
    [anon_sym_match] = ACTIONS(69),
    [anon_sym_select] = ACTIONS(71),
    [anon_sym_lock] = ACTIONS(73),
    [anon_sym_rlock] = ACTIONS(73),
    [anon_sym_unsafe] = ACTIONS(75),
    [anon_sym_sql] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(79),
    [sym_rune_literal] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_c_SQUOTE] = ACTIONS(85),
    [anon_sym_c_DQUOTE] = ACTIONS(87),
    [anon_sym_r_SQUOTE] = ACTIONS(89),
    [anon_sym_r_DQUOTE] = ACTIONS(91),
    [sym_pseudo_compile_time_identifier] = ACTIONS(93),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(105),
    [anon_sym_defer] = ACTIONS(107),
    [anon_sym_goto] = ACTIONS(109),
    [anon_sym_break] = ACTIONS(111),
    [anon_sym_continue] = ACTIONS(113),
    [anon_sym_return] = ACTIONS(115),
    [anon_sym_DOLLARfor] = ACTIONS(117),
    [anon_sym_for] = ACTIONS(119),
    [anon_sym_POUND] = ACTIONS(129),
    [anon_sym_asm] = ACTIONS(123),
    [anon_sym_AT_LBRACK] = ACTIONS(125),
  },
  [12] = {
    [sym_line_comment] = STATE(12),
    [sym_block_comment] = STATE(12),
    [sym_const_declaration] = STATE(1788),
    [sym_global_var_declaration] = STATE(1788),
    [sym_type_declaration] = STATE(1788),
    [sym_function_declaration] = STATE(1788),
    [sym_static_method_declaration] = STATE(1788),
    [sym_struct_declaration] = STATE(1788),
    [sym_enum_declaration] = STATE(1788),
    [sym_interface_declaration] = STATE(1788),
    [sym__expression] = STATE(244),
    [sym__expression_without_blocks] = STATE(471),
    [sym__expression_with_blocks] = STATE(471),
    [sym_strictly_expression_list] = STATE(1796),
    [sym_inc_expression] = STATE(474),
    [sym_dec_expression] = STATE(474),
    [sym_or_block_expression] = STATE(474),
    [sym_option_propagation_expression] = STATE(474),
    [sym_result_propagation_expression] = STATE(474),
    [sym_anon_struct_value_expression] = STATE(481),
    [sym_go_expression] = STATE(474),
    [sym_spawn_expression] = STATE(474),
    [sym_parenthesized_expression] = STATE(474),
    [sym_call_expression] = STATE(474),
    [sym_type_initializer] = STATE(481),
    [sym_function_literal] = STATE(474),
    [sym_reference_expression] = STATE(483),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(474),
    [sym_receive_expression] = STATE(474),
    [sym_binary_expression] = STATE(474),
    [sym_as_type_cast_expression] = STATE(474),
    [sym__max_group] = STATE(474),
    [sym_literal] = STATE(446),
    [sym_map_init_expression] = STATE(481),
    [sym_array_creation] = STATE(474),
    [sym_fixed_array_creation] = STATE(474),
    [sym_selector_expression] = STATE(474),
    [sym_index_expression] = STATE(474),
    [sym_slice_expression] = STATE(474),
    [sym_if_expression] = STATE(481),
    [sym_compile_time_if_expression] = STATE(481),
    [sym_is_expression] = STATE(474),
    [sym_in_expression] = STATE(474),
    [sym_enum_fetch] = STATE(474),
    [sym_match_expression] = STATE(481),
    [sym_select_expression] = STATE(481),
    [sym_lock_expression] = STATE(481),
    [sym_unsafe_expression] = STATE(481),
    [sym_sql_expression] = STATE(481),
    [sym_interpreted_string_literal] = STATE(421),
    [sym_c_string_literal] = STATE(421),
    [sym_raw_string_literal] = STATE(421),
    [sym_visibility_modifiers] = STATE(3616),
    [sym_mutability_modifiers] = STATE(932),
    [sym_mutable_expression] = STATE(3390),
    [sym_expression_list] = STATE(3404),
    [sym_plain_type] = STATE(4176),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1788),
    [sym_simple_statement] = STATE(1804),
    [sym_assert_statement] = STATE(1804),
    [sym_append_statement] = STATE(1804),
    [sym_send_statement] = STATE(1804),
    [sym_var_declaration] = STATE(1796),
    [sym_assignment_statement] = STATE(1796),
    [sym_block] = STATE(1804),
    [sym_defer_statement] = STATE(1804),
    [sym_goto_statement] = STATE(1804),
    [sym_break_statement] = STATE(1804),
    [sym_continue_statement] = STATE(1804),
    [sym_return_statement] = STATE(1804),
    [sym_label_definition] = STATE(13),
    [sym_labeled_statement] = STATE(1804),
    [sym_compile_time_for_statement] = STATE(1804),
    [sym_for_statement] = STATE(1804),
    [sym_hash_statement] = STATE(1804),
    [sym_asm_statement] = STATE(1804),
    [sym_attributes] = STATE(3487),
    [sym_attribute] = STATE(3407),
    [aux_sym_source_file_repeat1] = STATE(12),
    [aux_sym_attributes_repeat1] = STATE(3449),
    [ts_builtin_sym_end] = ACTIONS(137),
    [sym_identifier] = ACTIONS(139),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(142),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_const] = ACTIONS(148),
    [anon_sym_LPAREN] = ACTIONS(151),
    [anon_sym___global] = ACTIONS(154),
    [anon_sym_type] = ACTIONS(157),
    [anon_sym_fn] = ACTIONS(160),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(166),
    [anon_sym_struct] = ACTIONS(169),
    [anon_sym_union] = ACTIONS(172),
    [anon_sym_pub] = ACTIONS(175),
    [anon_sym_mut] = ACTIONS(178),
    [anon_sym_enum] = ACTIONS(181),
    [anon_sym_interface] = ACTIONS(184),
    [anon_sym_QMARK] = ACTIONS(187),
    [anon_sym_BANG] = ACTIONS(190),
    [anon_sym_go] = ACTIONS(193),
    [anon_sym_spawn] = ACTIONS(196),
    [anon_sym_json_DOTdecode] = ACTIONS(199),
    [anon_sym_LBRACK2] = ACTIONS(202),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_CARET] = ACTIONS(163),
    [anon_sym_AMP] = ACTIONS(205),
    [anon_sym_LT_DASH] = ACTIONS(208),
    [sym_none] = ACTIONS(211),
    [sym_true] = ACTIONS(211),
    [sym_false] = ACTIONS(211),
    [sym_nil] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(214),
    [anon_sym_DOLLARif] = ACTIONS(217),
    [anon_sym_match] = ACTIONS(220),
    [anon_sym_select] = ACTIONS(223),
    [anon_sym_lock] = ACTIONS(226),
    [anon_sym_rlock] = ACTIONS(226),
    [anon_sym_unsafe] = ACTIONS(229),
    [anon_sym_sql] = ACTIONS(232),
    [sym_int_literal] = ACTIONS(211),
    [sym_float_literal] = ACTIONS(235),
    [sym_rune_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(238),
    [anon_sym_DQUOTE] = ACTIONS(241),
    [anon_sym_c_SQUOTE] = ACTIONS(244),
    [anon_sym_c_DQUOTE] = ACTIONS(247),
    [anon_sym_r_SQUOTE] = ACTIONS(250),
    [anon_sym_r_DQUOTE] = ACTIONS(253),
    [sym_pseudo_compile_time_identifier] = ACTIONS(256),
    [anon_sym_shared] = ACTIONS(259),
    [anon_sym_map_LBRACK] = ACTIONS(262),
    [anon_sym_chan] = ACTIONS(265),
    [anon_sym_thread] = ACTIONS(268),
    [anon_sym_atomic] = ACTIONS(271),
    [anon_sym_assert] = ACTIONS(274),
    [anon_sym_defer] = ACTIONS(277),
    [anon_sym_goto] = ACTIONS(280),
    [anon_sym_break] = ACTIONS(283),
    [anon_sym_continue] = ACTIONS(286),
    [anon_sym_return] = ACTIONS(289),
    [anon_sym_DOLLARfor] = ACTIONS(292),
    [anon_sym_for] = ACTIONS(295),
    [anon_sym_POUND] = ACTIONS(298),
    [anon_sym_asm] = ACTIONS(301),
    [anon_sym_AT_LBRACK] = ACTIONS(304),
  },
  [13] = {
    [sym_line_comment] = STATE(13),
    [sym_block_comment] = STATE(13),
    [sym__expression] = STATE(244),
    [sym__expression_without_blocks] = STATE(471),
    [sym__expression_with_blocks] = STATE(471),
    [sym_strictly_expression_list] = STATE(1796),
    [sym_inc_expression] = STATE(474),
    [sym_dec_expression] = STATE(474),
    [sym_or_block_expression] = STATE(474),
    [sym_option_propagation_expression] = STATE(474),
    [sym_result_propagation_expression] = STATE(474),
    [sym_anon_struct_value_expression] = STATE(481),
    [sym_go_expression] = STATE(474),
    [sym_spawn_expression] = STATE(474),
    [sym_parenthesized_expression] = STATE(474),
    [sym_call_expression] = STATE(474),
    [sym_type_initializer] = STATE(481),
    [sym_function_literal] = STATE(474),
    [sym_reference_expression] = STATE(483),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(474),
    [sym_receive_expression] = STATE(474),
    [sym_binary_expression] = STATE(474),
    [sym_as_type_cast_expression] = STATE(474),
    [sym__max_group] = STATE(474),
    [sym_literal] = STATE(446),
    [sym_map_init_expression] = STATE(481),
    [sym_array_creation] = STATE(474),
    [sym_fixed_array_creation] = STATE(474),
    [sym_selector_expression] = STATE(474),
    [sym_index_expression] = STATE(474),
    [sym_slice_expression] = STATE(474),
    [sym_if_expression] = STATE(481),
    [sym_compile_time_if_expression] = STATE(481),
    [sym_is_expression] = STATE(474),
    [sym_in_expression] = STATE(474),
    [sym_enum_fetch] = STATE(474),
    [sym_match_expression] = STATE(481),
    [sym_select_expression] = STATE(481),
    [sym_lock_expression] = STATE(481),
    [sym_unsafe_expression] = STATE(481),
    [sym_sql_expression] = STATE(481),
    [sym_interpreted_string_literal] = STATE(421),
    [sym_c_string_literal] = STATE(421),
    [sym_raw_string_literal] = STATE(421),
    [sym_mutability_modifiers] = STATE(932),
    [sym_mutable_expression] = STATE(3390),
    [sym_expression_list] = STATE(3404),
    [sym_plain_type] = STATE(4176),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1782),
    [sym_simple_statement] = STATE(1804),
    [sym_assert_statement] = STATE(1804),
    [sym_append_statement] = STATE(1804),
    [sym_send_statement] = STATE(1804),
    [sym_var_declaration] = STATE(1796),
    [sym_assignment_statement] = STATE(1796),
    [sym_block] = STATE(1804),
    [sym_defer_statement] = STATE(1804),
    [sym_goto_statement] = STATE(1804),
    [sym_break_statement] = STATE(1804),
    [sym_continue_statement] = STATE(1804),
    [sym_return_statement] = STATE(1804),
    [sym_label_definition] = STATE(13),
    [sym_labeled_statement] = STATE(1804),
    [sym_compile_time_for_statement] = STATE(1804),
    [sym_for_statement] = STATE(1804),
    [sym_hash_statement] = STATE(1804),
    [sym_asm_statement] = STATE(1804),
    [ts_builtin_sym_end] = ACTIONS(307),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_LF] = ACTIONS(309),
    [anon_sym_CR] = ACTIONS(309),
    [anon_sym_CR_LF] = ACTIONS(309),
    [anon_sym_SLASH_SLASH] = ACTIONS(311),
    [anon_sym_SLASH_STAR] = ACTIONS(313),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(315),
    [anon_sym_const] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym___global] = ACTIONS(309),
    [anon_sym_type] = ACTIONS(309),
    [anon_sym_fn] = ACTIONS(319),
    [anon_sym_PLUS] = ACTIONS(321),
    [anon_sym_DASH] = ACTIONS(321),
    [anon_sym_STAR] = ACTIONS(323),
    [anon_sym_struct] = ACTIONS(325),
    [anon_sym_union] = ACTIONS(309),
    [anon_sym_pub] = ACTIONS(309),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(309),
    [anon_sym_interface] = ACTIONS(309),
    [anon_sym_QMARK] = ACTIONS(327),
    [anon_sym_BANG] = ACTIONS(329),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_spawn] = ACTIONS(53),
    [anon_sym_json_DOTdecode] = ACTIONS(331),
    [anon_sym_LBRACK2] = ACTIONS(333),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_CARET] = ACTIONS(321),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_LT_DASH] = ACTIONS(337),
    [sym_none] = ACTIONS(63),
    [sym_true] = ACTIONS(63),
    [sym_false] = ACTIONS(63),
    [sym_nil] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_DOLLARif] = ACTIONS(67),
    [anon_sym_match] = ACTIONS(69),
    [anon_sym_select] = ACTIONS(71),
    [anon_sym_lock] = ACTIONS(73),
    [anon_sym_rlock] = ACTIONS(73),
    [anon_sym_unsafe] = ACTIONS(75),
    [anon_sym_sql] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(63),
    [sym_rune_literal] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(339),
    [anon_sym_DQUOTE] = ACTIONS(341),
    [anon_sym_c_SQUOTE] = ACTIONS(343),
    [anon_sym_c_DQUOTE] = ACTIONS(345),
    [anon_sym_r_SQUOTE] = ACTIONS(347),
    [anon_sym_r_DQUOTE] = ACTIONS(349),
    [sym_pseudo_compile_time_identifier] = ACTIONS(93),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(351),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(105),
    [anon_sym_defer] = ACTIONS(107),
    [anon_sym_goto] = ACTIONS(109),
    [anon_sym_break] = ACTIONS(111),
    [anon_sym_continue] = ACTIONS(113),
    [anon_sym_return] = ACTIONS(115),
    [anon_sym_DOLLARfor] = ACTIONS(117),
    [anon_sym_for] = ACTIONS(119),
    [anon_sym_POUND] = ACTIONS(121),
    [anon_sym_asm] = ACTIONS(123),
    [anon_sym_AT_LBRACK] = ACTIONS(309),
  },
  [14] = {
    [sym_line_comment] = STATE(14),
    [sym_block_comment] = STATE(14),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1935),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_LF] = ACTIONS(309),
    [anon_sym_CR] = ACTIONS(309),
    [anon_sym_CR_LF] = ACTIONS(309),
    [anon_sym_SLASH_SLASH] = ACTIONS(311),
    [anon_sym_SLASH_STAR] = ACTIONS(313),
    [anon_sym_SEMI] = ACTIONS(309),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(357),
    [anon_sym_RBRACE] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(363),
    [anon_sym_STAR] = ACTIONS(365),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(327),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(375),
    [anon_sym_LBRACK2] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(363),
    [anon_sym_CARET] = ACTIONS(363),
    [anon_sym_AMP] = ACTIONS(379),
    [anon_sym_LT_DASH] = ACTIONS(381),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(383),
    [sym_rune_literal] = ACTIONS(383),
    [anon_sym_SQUOTE] = ACTIONS(399),
    [anon_sym_DQUOTE] = ACTIONS(401),
    [anon_sym_c_SQUOTE] = ACTIONS(403),
    [anon_sym_c_DQUOTE] = ACTIONS(405),
    [anon_sym_r_SQUOTE] = ACTIONS(407),
    [anon_sym_r_DQUOTE] = ACTIONS(409),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(351),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(429),
    [anon_sym_asm] = ACTIONS(431),
  },
  [15] = {
    [sym_line_comment] = STATE(15),
    [sym_block_comment] = STATE(15),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(46),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(437),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [16] = {
    [sym_line_comment] = STATE(16),
    [sym_block_comment] = STATE(16),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(56),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [17] = {
    [sym_line_comment] = STATE(17),
    [sym_block_comment] = STATE(17),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(55),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [18] = {
    [sym_line_comment] = STATE(18),
    [sym_block_comment] = STATE(18),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(54),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(475),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [19] = {
    [sym_line_comment] = STATE(19),
    [sym_block_comment] = STATE(19),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(78),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(477),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [20] = {
    [sym_line_comment] = STATE(20),
    [sym_block_comment] = STATE(20),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(82),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(479),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [21] = {
    [sym_line_comment] = STATE(21),
    [sym_block_comment] = STATE(21),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(55),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [22] = {
    [sym_line_comment] = STATE(22),
    [sym_block_comment] = STATE(22),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(304),
    [aux_sym_block_repeat1] = STATE(45),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(481),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [23] = {
    [sym_line_comment] = STATE(23),
    [sym_block_comment] = STATE(23),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(46),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(483),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [24] = {
    [sym_line_comment] = STATE(24),
    [sym_block_comment] = STATE(24),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(55),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(485),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [25] = {
    [sym_line_comment] = STATE(25),
    [sym_block_comment] = STATE(25),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(56),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(487),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [26] = {
    [sym_line_comment] = STATE(26),
    [sym_block_comment] = STATE(26),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(43),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(489),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [27] = {
    [sym_line_comment] = STATE(27),
    [sym_block_comment] = STATE(27),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(84),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(491),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [28] = {
    [sym_line_comment] = STATE(28),
    [sym_block_comment] = STATE(28),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(78),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(493),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [29] = {
    [sym_line_comment] = STATE(29),
    [sym_block_comment] = STATE(29),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(54),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [30] = {
    [sym_line_comment] = STATE(30),
    [sym_block_comment] = STATE(30),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(43),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(497),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [31] = {
    [sym_line_comment] = STATE(31),
    [sym_block_comment] = STATE(31),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(323),
    [aux_sym_block_repeat1] = STATE(75),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [32] = {
    [sym_line_comment] = STATE(32),
    [sym_block_comment] = STATE(32),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(49),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(501),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [33] = {
    [sym_line_comment] = STATE(33),
    [sym_block_comment] = STATE(33),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(85),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(503),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [34] = {
    [sym_line_comment] = STATE(34),
    [sym_block_comment] = STATE(34),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(69),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(505),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [35] = {
    [sym_line_comment] = STATE(35),
    [sym_block_comment] = STATE(35),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(277),
    [aux_sym_block_repeat1] = STATE(45),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(481),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [36] = {
    [sym_line_comment] = STATE(36),
    [sym_block_comment] = STATE(36),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(304),
    [aux_sym_block_repeat1] = STATE(75),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [37] = {
    [sym_line_comment] = STATE(37),
    [sym_block_comment] = STATE(37),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(56),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [38] = {
    [sym_line_comment] = STATE(38),
    [sym_block_comment] = STATE(38),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(53),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [39] = {
    [sym_line_comment] = STATE(39),
    [sym_block_comment] = STATE(39),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(48),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(509),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [40] = {
    [sym_line_comment] = STATE(40),
    [sym_block_comment] = STATE(40),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(55),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(511),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [41] = {
    [sym_line_comment] = STATE(41),
    [sym_block_comment] = STATE(41),
    [sym__expression] = STATE(894),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_map_keyed_element] = STATE(2199),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_map_init_expression_repeat1] = STATE(260),
    [aux_sym_block_repeat1] = STATE(69),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(513),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [42] = {
    [sym_line_comment] = STATE(42),
    [sym_block_comment] = STATE(42),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(48),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [43] = {
    [sym_line_comment] = STATE(43),
    [sym_block_comment] = STATE(43),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(517),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [44] = {
    [sym_line_comment] = STATE(44),
    [sym_block_comment] = STATE(44),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(82),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(519),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [45] = {
    [sym_line_comment] = STATE(45),
    [sym_block_comment] = STATE(45),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(521),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [46] = {
    [sym_line_comment] = STATE(46),
    [sym_block_comment] = STATE(46),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(523),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [47] = {
    [sym_line_comment] = STATE(47),
    [sym_block_comment] = STATE(47),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(56),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(525),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [48] = {
    [sym_line_comment] = STATE(48),
    [sym_block_comment] = STATE(48),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(527),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [49] = {
    [sym_line_comment] = STATE(49),
    [sym_block_comment] = STATE(49),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(529),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [50] = {
    [sym_line_comment] = STATE(50),
    [sym_block_comment] = STATE(50),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(531),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [51] = {
    [sym_line_comment] = STATE(51),
    [sym_block_comment] = STATE(51),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(88),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(533),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [52] = {
    [sym_line_comment] = STATE(52),
    [sym_block_comment] = STATE(52),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(72),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(535),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [53] = {
    [sym_line_comment] = STATE(53),
    [sym_block_comment] = STATE(53),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [54] = {
    [sym_line_comment] = STATE(54),
    [sym_block_comment] = STATE(54),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(539),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [55] = {
    [sym_line_comment] = STATE(55),
    [sym_block_comment] = STATE(55),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(541),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [56] = {
    [sym_line_comment] = STATE(56),
    [sym_block_comment] = STATE(56),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(543),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [57] = {
    [sym_line_comment] = STATE(57),
    [sym_block_comment] = STATE(57),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(53),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [58] = {
    [sym_line_comment] = STATE(58),
    [sym_block_comment] = STATE(58),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(79),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [59] = {
    [sym_line_comment] = STATE(59),
    [sym_block_comment] = STATE(59),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(45),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(549),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [60] = {
    [sym_line_comment] = STATE(60),
    [sym_block_comment] = STATE(60),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(54),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(551),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [61] = {
    [sym_line_comment] = STATE(61),
    [sym_block_comment] = STATE(61),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(553),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [62] = {
    [sym_line_comment] = STATE(62),
    [sym_block_comment] = STATE(62),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [63] = {
    [sym_line_comment] = STATE(63),
    [sym_block_comment] = STATE(63),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(62),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(557),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [64] = {
    [sym_line_comment] = STATE(64),
    [sym_block_comment] = STATE(64),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(84),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(559),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [65] = {
    [sym_line_comment] = STATE(65),
    [sym_block_comment] = STATE(65),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(70),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(561),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [66] = {
    [sym_line_comment] = STATE(66),
    [sym_block_comment] = STATE(66),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(49),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(563),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [67] = {
    [sym_line_comment] = STATE(67),
    [sym_block_comment] = STATE(67),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(61),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(565),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [68] = {
    [sym_line_comment] = STATE(68),
    [sym_block_comment] = STATE(68),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(78),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(567),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [69] = {
    [sym_line_comment] = STATE(69),
    [sym_block_comment] = STATE(69),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(569),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [70] = {
    [sym_line_comment] = STATE(70),
    [sym_block_comment] = STATE(70),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(571),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [71] = {
    [sym_line_comment] = STATE(71),
    [sym_block_comment] = STATE(71),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(75),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(573),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [72] = {
    [sym_line_comment] = STATE(72),
    [sym_block_comment] = STATE(72),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(575),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [73] = {
    [sym_line_comment] = STATE(73),
    [sym_block_comment] = STATE(73),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(46),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(577),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [74] = {
    [sym_line_comment] = STATE(74),
    [sym_block_comment] = STATE(74),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(50),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(579),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [75] = {
    [sym_line_comment] = STATE(75),
    [sym_block_comment] = STATE(75),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(581),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [76] = {
    [sym_line_comment] = STATE(76),
    [sym_block_comment] = STATE(76),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(87),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(583),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [77] = {
    [sym_line_comment] = STATE(77),
    [sym_block_comment] = STATE(77),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(43),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(585),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [78] = {
    [sym_line_comment] = STATE(78),
    [sym_block_comment] = STATE(78),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(587),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [79] = {
    [sym_line_comment] = STATE(79),
    [sym_block_comment] = STATE(79),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(589),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [80] = {
    [sym_line_comment] = STATE(80),
    [sym_block_comment] = STATE(80),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(69),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(591),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [81] = {
    [sym_line_comment] = STATE(81),
    [sym_block_comment] = STATE(81),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(593),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(596),
    [anon_sym_LBRACE] = ACTIONS(599),
    [anon_sym_RBRACE] = ACTIONS(602),
    [anon_sym_LPAREN] = ACTIONS(604),
    [anon_sym_fn] = ACTIONS(607),
    [anon_sym_PLUS] = ACTIONS(610),
    [anon_sym_DASH] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(613),
    [anon_sym_struct] = ACTIONS(616),
    [anon_sym_mut] = ACTIONS(619),
    [anon_sym_QMARK] = ACTIONS(622),
    [anon_sym_BANG] = ACTIONS(625),
    [anon_sym_go] = ACTIONS(628),
    [anon_sym_spawn] = ACTIONS(631),
    [anon_sym_json_DOTdecode] = ACTIONS(634),
    [anon_sym_LBRACK2] = ACTIONS(637),
    [anon_sym_TILDE] = ACTIONS(610),
    [anon_sym_CARET] = ACTIONS(610),
    [anon_sym_AMP] = ACTIONS(640),
    [anon_sym_LT_DASH] = ACTIONS(643),
    [sym_none] = ACTIONS(646),
    [sym_true] = ACTIONS(646),
    [sym_false] = ACTIONS(646),
    [sym_nil] = ACTIONS(646),
    [anon_sym_if] = ACTIONS(649),
    [anon_sym_DOLLARif] = ACTIONS(652),
    [anon_sym_match] = ACTIONS(655),
    [anon_sym_select] = ACTIONS(658),
    [anon_sym_lock] = ACTIONS(661),
    [anon_sym_rlock] = ACTIONS(661),
    [anon_sym_unsafe] = ACTIONS(664),
    [anon_sym_sql] = ACTIONS(667),
    [sym_int_literal] = ACTIONS(646),
    [sym_float_literal] = ACTIONS(670),
    [sym_rune_literal] = ACTIONS(670),
    [anon_sym_SQUOTE] = ACTIONS(673),
    [anon_sym_DQUOTE] = ACTIONS(676),
    [anon_sym_c_SQUOTE] = ACTIONS(679),
    [anon_sym_c_DQUOTE] = ACTIONS(682),
    [anon_sym_r_SQUOTE] = ACTIONS(685),
    [anon_sym_r_DQUOTE] = ACTIONS(688),
    [sym_pseudo_compile_time_identifier] = ACTIONS(691),
    [anon_sym_shared] = ACTIONS(694),
    [anon_sym_map_LBRACK] = ACTIONS(697),
    [anon_sym_chan] = ACTIONS(700),
    [anon_sym_thread] = ACTIONS(703),
    [anon_sym_atomic] = ACTIONS(706),
    [anon_sym_assert] = ACTIONS(709),
    [anon_sym_defer] = ACTIONS(712),
    [anon_sym_goto] = ACTIONS(715),
    [anon_sym_break] = ACTIONS(718),
    [anon_sym_continue] = ACTIONS(721),
    [anon_sym_return] = ACTIONS(724),
    [anon_sym_DOLLARfor] = ACTIONS(727),
    [anon_sym_for] = ACTIONS(730),
    [anon_sym_POUND] = ACTIONS(733),
    [anon_sym_asm] = ACTIONS(736),
  },
  [82] = {
    [sym_line_comment] = STATE(82),
    [sym_block_comment] = STATE(82),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(739),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [83] = {
    [sym_line_comment] = STATE(83),
    [sym_block_comment] = STATE(83),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(55),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(741),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [84] = {
    [sym_line_comment] = STATE(84),
    [sym_block_comment] = STATE(84),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(743),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [85] = {
    [sym_line_comment] = STATE(85),
    [sym_block_comment] = STATE(85),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(745),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [86] = {
    [sym_line_comment] = STATE(86),
    [sym_block_comment] = STATE(86),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(85),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(747),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [87] = {
    [sym_line_comment] = STATE(87),
    [sym_block_comment] = STATE(87),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_type] = STATE(2416),
    [sym_option_type] = STATE(2416),
    [sym_qualified_type] = STATE(3649),
    [sym_fixed_array_type] = STATE(2417),
    [sym_array_type] = STATE(2417),
    [sym_pointer_type] = STATE(2417),
    [sym_wrong_pointer_type] = STATE(2417),
    [sym_map_type] = STATE(2417),
    [sym_channel_type] = STATE(2417),
    [sym_shared_type] = STATE(2417),
    [sym_thread_type] = STATE(2417),
    [sym_atomic_type] = STATE(2417),
    [sym_generic_type] = STATE(2417),
    [sym_function_type] = STATE(2417),
    [sym__statement] = STATE(1932),
    [sym_simple_statement] = STATE(1950),
    [sym_assert_statement] = STATE(1950),
    [sym_append_statement] = STATE(1950),
    [sym_send_statement] = STATE(1950),
    [sym_var_declaration] = STATE(1933),
    [sym_assignment_statement] = STATE(1933),
    [sym_block] = STATE(1950),
    [sym_defer_statement] = STATE(1950),
    [sym_goto_statement] = STATE(1950),
    [sym_break_statement] = STATE(1950),
    [sym_continue_statement] = STATE(1950),
    [sym_return_statement] = STATE(1950),
    [sym_label_definition] = STATE(14),
    [sym_labeled_statement] = STATE(1950),
    [sym_compile_time_for_statement] = STATE(1950),
    [sym_for_statement] = STATE(1950),
    [sym_hash_statement] = STATE(1950),
    [sym_asm_statement] = STATE(1950),
    [aux_sym_block_repeat1] = STATE(81),
    [sym_identifier] = ACTIONS(353),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(749),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_struct] = ACTIONS(367),
    [anon_sym_mut] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(47),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_go] = ACTIONS(371),
    [anon_sym_spawn] = ACTIONS(373),
    [anon_sym_json_DOTdecode] = ACTIONS(447),
    [anon_sym_LBRACK2] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_LT_DASH] = ACTIONS(453),
    [sym_none] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_nil] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_DOLLARif] = ACTIONS(387),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_select] = ACTIONS(391),
    [anon_sym_lock] = ACTIONS(393),
    [anon_sym_rlock] = ACTIONS(393),
    [anon_sym_unsafe] = ACTIONS(395),
    [anon_sym_sql] = ACTIONS(397),
    [sym_int_literal] = ACTIONS(383),
    [sym_float_literal] = ACTIONS(455),
    [sym_rune_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_c_SQUOTE] = ACTIONS(461),
    [anon_sym_c_DQUOTE] = ACTIONS(463),
    [anon_sym_r_SQUOTE] = ACTIONS(465),
    [anon_sym_r_DQUOTE] = ACTIONS(467),
    [sym_pseudo_compile_time_identifier] = ACTIONS(411),
    [anon_sym_shared] = ACTIONS(95),
    [anon_sym_map_LBRACK] = ACTIONS(97),
    [anon_sym_chan] = ACTIONS(99),
    [anon_sym_thread] = ACTIONS(101),
    [anon_sym_atomic] = ACTIONS(103),
    [anon_sym_assert] = ACTIONS(413),
    [anon_sym_defer] = ACTIONS(415),
    [anon_sym_goto] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_DOLLARfor] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(427),
    [anon_sym_POUND] = ACTIONS(469),
    [anon_sym_asm] = ACTIONS(431),
  },
  [88] = {
    [sym_line_comment] = STATE(88),
    [sym_block_comment] = STATE(88),
    [sym__expression] = STATE(984),
    [sym__expression_without_blocks] = STATE(1018),
    [sym__expression_with_blocks] = STATE(1018),
    [sym_strictly_expression_list] = STATE(1933),
    [sym_inc_expression] = STATE(1020),
    [sym_dec_expression] = STATE(1020),
    [sym_or_block_expression] = STATE(1020),
    [sym_option_propagation_expression] = STATE(1020),
    [sym_result_propagation_expression] = STATE(1020),
    [sym_anon_struct_value_expression] = STATE(1022),
    [sym_go_expression] = STATE(1020),
    [sym_spawn_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_call_expression] = STATE(1020),
    [sym_type_initializer] = STATE(1022),
    [sym_function_literal] = STATE(1020),
    [sym_reference_expression] = STATE(1027),
    [sym_type_reference_expression] = STATE(3649),
    [sym_unary_expression] = STATE(1020),
    [sym_receive_expression] = STATE(1020),
    [sym_binary_expression] = STATE(1020),
    [sym_as_type_cast_expression] = STATE(1020),
    [sym__max_group] = STATE(1020),
    [sym_literal] = STATE(1009),
    [sym_map_init_expression] = STATE(1022),
    [sym_array_creation] = STATE(1020),
    [sym_fixed_array_creation] = STATE(1020),
    [sym_selector_expression] = STATE(1020),
    [sym_index_expression] = STATE(1020),
    [sym_slice_expression] = STATE(1020),
    [sym_if_expression] = STATE(1022),
    [sym_compile_time_if_expression] = STATE(1022),
    [sym_is_expression] = STATE(1020),
    [sym_in_expression] = STATE(1020),
    [sym_enum_fetch] = STATE(1020),
    [sym_match_expression] = STATE(1022),
    [sym_select_expression] = STATE(1022),
    [sym_lock_expression] = STATE(1022),
    [sym_unsafe_expression] = STATE(1022),
    [sym_sql_expression] = STATE(1022),
    [sym_interpreted_string_literal] = STATE(1007),
    [sym_c_string_literal] = STATE(1007),
    [sym_raw_string_literal] = STATE(1007),
    [sym_mutability_modifiers] = STATE(788),
    [sym_mutable_expression] = STATE(3383),
    [sym_expression_list] = STATE(3445),
    [sym_plain_type] = STATE(4146),
    [sym__plain_type_without_special] = STATE(2416),
    [sym_anon_struct_type] = STATE(2417),
    [sym_multi_return_type] = STATE(2416),
    [sym_result_ty