(*++

Copyright (C) 2019 Calculation developers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated Pascal application that demonstrates the
 usage of the Pascal bindings of Calculation library

Interface version: 1.0.0

*)

program CalculationPascalTest;

uses
  {$IFDEF UNIX}{$IFDEF UseCThreads}
  cthreads,
  {$ENDIF}{$ENDIF}
  Classes, SysUtils, CustApp,
  Unit_Numbers,
  Unit_Calculation
  { you can add units after this };

type

TCalculation_Example = class(TCustomApplication)
protected
  procedure DoRun; override;
  procedure TestCalculation ();
public
  constructor Create(TheOwner: TComponent); override;
  destructor Destroy; override;
end;


procedure TCalculation_Example.TestCalculation ();
var
  ACalculationWrapper: TCalculationWrapper;
  ANumbersWrapper: TNumbersWrapper;
  AMajor, AMinor, AMicro: Cardinal;
  AVersionString: string;
  ALibPath: string;
  ACalculator : TCalculationCalculator;
  AVar1, AVar2, AVar2Again, AResult1, AResult2: TNumbersVariable;
begin
  writeln ('loading DLL');
  ALibPath := ''; // TODO add the location of the shared library binary here
  ACalculationWrapper := TCalculationWrapper.Create (ALibPath + '/' + 'calculation.dll'); // TODO add the extension of the shared library file here
  try
    writeln ('loading DLL Done');
    ACalculationWrapper.GetVersion(AMajor, AMinor, AMicro);
    AVersionString := Format('Calculation.version = %d.%d.%d', [AMajor, AMinor, AMicro]);
    writeln(AVersionString);

    ALibPath := '';
    ANumbersWrapper := TNumbersWrapper.Create (ALibPath + '/' + 'numbers.'); // TODO add the extension of the shared library file here
    ANumbersWrapper.GetVersion(AMajor, AMinor, AMicro);
    AVersionString := Format('Numbers.version = %d.%d.%d', [AMajor, AMinor, AMicro]);
    writeln(AVersionString);

    ACalculationWrapper.InjectComponent('Numbers', ANumbersWrapper.GetSymbolLookupMethod());

    ACalculator := ACalculationWrapper.CreateCalculator();

    AVar1 := ANumbersWrapper.CreateVariable(10.0);
    AVar2 := ANumbersWrapper.CreateVariable(5.0);
    ACalculator.EnlistVariable(AVar1);
    ACalculator.EnlistVariable(AVar2);
    FreeAndNil(AVar2);

    AResult1 := ACalculator.Add();
    WriteLn(Format('   sum = %f', [AResult1.GetValue()]));
    FreeAndNil(AResult1);

    AVar2Again := ACalculator.GetEnlistedVariable(1);
    AVar2Again.SetValue(15.0);
    FreeAndNil(AVar2Again);

    AResult2 := ACalculator.Add();
    WriteLn(Format('newSum = %f', [AResult2.GetValue()]));
    FreeAndNil(AResult2);
  finally
    FreeAndNil(ACalculator);
    FreeAndNil(AVar1);
    FreeAndNil(AVar2);
    FreeAndNil(AVar2Again);
    FreeAndNil(AResult1);
    FreeAndNil(AResult2);

    FreeAndNil(ANumbersWrapper);
    FreeAndNil(ACalculationWrapper);
  end;
end;

procedure TCalculation_Example.DoRun;
begin
  try
    TestCalculation();
  except
    On E: Exception do
      writeln ('Fatal error: ', E.Message);
  end;
  Terminate
end;

constructor TCalculation_Example.Create(TheOwner: TComponent);
begin
  inherited Create(TheOwner);
  StopOnException:=True;
end;

destructor TCalculation_Example.Destroy;
begin
  inherited Destroy;
end;


var
  Application: TCalculation_Example;
begin
  Application:=TCalculation_Example.Create(nil);
  Application.Run;
  Application.Free;
end.
