/*++

Copyright (C) 2019 ACT Developers


This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated C++ implementation file in order to allow easy
development of Optional Class Library. It provides an automatic Journaling mechanism for the library implementation.

Interface version: 1.0.0

*/


#include <string>
#include <sstream>
#include <iomanip>

#include "optclass_interfacejournal.hpp"
#include "optclass_interfaceexception.hpp"


std::string OptClassHandleToHex (OptClassHandle pHandle)
{
	std::stringstream stream;
	stream << std::setfill('0') << std::setw(sizeof(OptClass_uint64) * 2)
		<< std::hex << (OptClass_uint64) pHandle;
	return stream.str();
}

COptClassInterfaceJournalEntry::COptClassInterfaceJournalEntry(COptClassInterfaceJournal * pJournal, std::string sClassName, std::string sMethodName, OptClassHandle pInstanceHandle)
	: m_pJournal(pJournal), m_ErrorCode(OPTCLASS_SUCCESS), m_sClassName(sClassName), m_sMethodName(sMethodName), m_nInitTimeStamp(0), m_nFinishTimeStamp(0)
{
	if (pJournal == nullptr)
		throw EOptClassInterfaceException(OPTCLASS_ERROR_INVALIDPARAM);
	m_nInitTimeStamp = m_pJournal->getTimeStamp ();
	m_sInstanceHandle = OptClassHandleToHex (pInstanceHandle);
}

COptClassInterfaceJournalEntry::~COptClassInterfaceJournalEntry()
{
}

void COptClassInterfaceJournalEntry::addParameter(const std::string & sName, const std::string & sParameterType, const std::string & sParameterValue)
{
	m_sParameters.push_back(std::make_pair(std::make_pair(sName, sParameterType), sParameterValue));
}

void COptClassInterfaceJournalEntry::addResult(const std::string & sName, const std::string & sResultType, const std::string & sResultValue)
{
	m_sResultValues.push_back(std::make_pair(std::make_pair(sName, sResultType), sResultValue));
}

std::string COptClassInterfaceJournalEntry::getXMLString()
{
	std::stringstream sStream;
	OptClass_uint64 nDuration = 0;

	if (m_nFinishTimeStamp > m_nInitTimeStamp)
		nDuration = m_nFinishTimeStamp - m_nInitTimeStamp;

	sStream << "    <entry";
	if (m_sClassName != "")
		sStream << " class=\"" << m_sClassName << "\"";
	sStream << " method=\"" << m_sMethodName << "\"";
	if (m_ErrorCode != OPTCLASS_SUCCESS)
		sStream << " errorcode=\"" << m_ErrorCode << "\"";
	sStream << " timestamp=\"" << m_nInitTimeStamp << "\" duration=\"" << nDuration << "\">\n";

	if (m_sClassName != "")
		sStream << "        <instance handle=\"" << m_sInstanceHandle << "\" />\n";

	auto iParamIter = m_sParameters.begin();
	while (iParamIter != m_sParameters.end()) {
		sStream << "        <parameter name=\"" << iParamIter->first.first << "\" type=\"" << iParamIter->first.second << "\" value=\"" << iParamIter->second <<"\" />\n";
		iParamIter++;
	}

	auto iResultIter = m_sResultValues.begin();
	while (iResultIter != m_sResultValues.end()) {
		sStream << "        <result name=\"" << iResultIter->first.first << "\" type=\"" << iResultIter->first.second << "\" value=\"" << iResultIter->second << "\" />\n";
		iResultIter++;
	}

	sStream << "    </entry>\n";
	return sStream.str ();
}

void COptClassInterfaceJournalEntry::writeSuccess()
{
	writeError(OPTCLASS_SUCCESS);
}

void COptClassInterfaceJournalEntry::writeError(OptClassResult nErrorCode)
{
	m_ErrorCode = nErrorCode;
	m_nFinishTimeStamp = m_pJournal->getTimeStamp();
	m_pJournal->writeEntry(this);
}

void COptClassInterfaceJournalEntry::addBooleanParameter(const std::string & sName, const bool bValue)
{
	addParameter (sName, "bool", std::to_string((int)bValue));
}

void COptClassInterfaceJournalEntry::addUInt8Parameter(const std::string & sName, const OptClass_uint8 nValue)
{
	addParameter(sName, "uint8", std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addUInt16Parameter(const std::string & sName, const OptClass_uint16 nValue)
{
	addParameter(sName, "uint16", std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addUInt32Parameter(const std::string & sName, const OptClass_uint32 nValue)
{
	addParameter(sName, "uint32", std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addUInt64Parameter(const std::string & sName, const OptClass_uint64 nValue)
{
	addParameter(sName, "uint64", std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addInt8Parameter(const std::string & sName, const OptClass_int8 nValue)
{
	addParameter(sName, "int8", std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addInt16Parameter(const std::string & sName, const OptClass_int16 nValue)
{
	addParameter(sName, "int16", std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addInt32Parameter(const std::string & sName, const OptClass_int32 nValue)
{
	addParameter(sName, "uint32", std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addInt64Parameter(const std::string & sName, const OptClass_int64 nValue)
{
	addParameter(sName, "int64", std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addSingleParameter(const std::string & sName,  const OptClass_single fValue)
{
	addParameter(sName, "single", std::to_string(fValue));
}

void COptClassInterfaceJournalEntry::addDoubleParameter(const std::string & sName, const OptClass_double dValue)
{
	addParameter(sName, "double", std::to_string(dValue));
}
void COptClassInterfaceJournalEntry::addPointerParameter(const std::string & sName, const OptClass_pvoid pValue)
{
	addParameter(sName, "pointer", std::to_string(reinterpret_cast<const OptClass_uint64>(pValue)));
}

void COptClassInterfaceJournalEntry::addStringParameter(const std::string & sName, const char * pValue)
{
	if (pValue != nullptr) {
		addParameter(sName, "string", pValue);
	}
	else {
		addParameter(sName, "nullstring", "");
	}
}

void COptClassInterfaceJournalEntry::addHandleParameter(const std::string & sName, const OptClassHandle pHandle)
{
	addParameter(sName, "handle", OptClassHandleToHex(pHandle));
}

void COptClassInterfaceJournalEntry::addEnumParameter(const std::string & sName, const std::string & sEnumType, const OptClass_int32 nValue)
{
	addParameter(sName, "enum" + sEnumType, std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addBooleanResult(const std::string & sName, const bool bValue)
{
	addResult(sName, "bool", std::to_string((int)bValue));
}

void COptClassInterfaceJournalEntry::addUInt8Result(const std::string & sName, const OptClass_uint8 nValue)
{
	addResult(sName, "uint8", std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addUInt16Result(const std::string & sName, const OptClass_uint16 nValue)
{
	addResult(sName, "uint16", std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addUInt32Result(const std::string & sName, const OptClass_uint32 nValue)
{
	addResult(sName, "uint32", std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addUInt64Result(const std::string & sName, const OptClass_uint64 nValue)
{
	addResult(sName, "uint64", std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addInt8Result(const std::string & sName, const OptClass_int8 nValue)
{
	addResult(sName, "int8", std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addInt16Result(const std::string & sName, const OptClass_int16 nValue)
{
	addResult(sName, "int16", std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addInt32Result(const std::string & sName, const OptClass_int32 nValue)
{
	addResult(sName, "uint32", std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addInt64Result(const std::string & sName, const OptClass_int64 nValue)
{
	addResult(sName, "int64", std::to_string(nValue));
}

void COptClassInterfaceJournalEntry::addSingleResult(const std::string & sName,  const OptClass_single fValue)
{
	addResult(sName, "single", std::to_string(fValue));
}

void COptClassInterfaceJournalEntry::addDoubleResult(const std::string & sName, const OptClass_double dValue)
{
	addResult(sName, "double", std::to_string(dValue));
}

void COptClassInterfaceJournalEntry::addPointerResult(const std::string & sName, const OptClass_pvoid pValue)
{
	addResult(sName, "pointer", std::to_string(reinterpret_cast<const OptClass_uint64>(pValue)));
}

void COptClassInterfaceJournalEntry::addStringResult(const std::string & sName, const char * pValue)
{
	if (pValue != nullptr) {
		addResult(sName, "string", pValue);
	}
	else {
		addResult(sName, "nullstring", "");
	}
}

void COptClassInterfaceJournalEntry::addHandleResult(const std::string & sName, const OptClassHandle pHandle)
{
	addResult(sName, "handle", OptClassHandleToHex(pHandle));
}

void COptClassInterfaceJournalEntry::addEnumResult(const std::string & sName, const std::string & sEnumType, const OptClass_int32 nValue)
{
	addResult(sName, "enum" + sEnumType, std::to_string(nValue));
}


COptClassInterfaceJournal::COptClassInterfaceJournal (const std::string & sFileName)
	: m_sFileName (sFileName)
{
	m_StartTime = std::chrono::high_resolution_clock::now();
	m_Stream.open (sFileName, std::ios::out);
	m_Stream << "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
	m_Stream << "<journal library=\"OptClass\" version=\"1.0.0\" xmlns=\"http://schemas.autodesk.com/components/OptClass/1.0.0\">\n";
	m_Stream << "\n";

}

COptClassInterfaceJournal::~COptClassInterfaceJournal ()
{
	m_Stream << "</journal>\n";
}

POptClassInterfaceJournalEntry COptClassInterfaceJournal::beginClassMethod(const OptClassHandle pHandle, const std::string & sClassName, const std::string & sMethodName)
{
	return std::make_shared<COptClassInterfaceJournalEntry>(this, sClassName, sMethodName, pHandle);
}

POptClassInterfaceJournalEntry COptClassInterfaceJournal::beginStaticFunction(const std::string & sMethodName)
{
	return std::make_shared<COptClassInterfaceJournalEntry>(this, "", sMethodName, nullptr);
}

void COptClassInterfaceJournal::writeEntry (COptClassInterfaceJournalEntry * pEntry)
{
	if (pEntry == nullptr)
		throw EOptClassInterfaceException (OPTCLASS_ERROR_INVALIDPARAM);

	std::string sXMLString = pEntry->getXMLString();
	m_Mutex.lock();
	try {
		m_Stream << sXMLString;
		m_Stream << "\n";

		m_Mutex.unlock();
	}
	catch (...) {
		m_Mutex.unlock();
	}
}

OptClass_uint64 COptClassInterfaceJournal::getTimeStamp ()
{
	auto currentTime = std::chrono::high_resolution_clock::now();
	if (m_StartTime < currentTime) {
		auto duration = currentTime - m_StartTime;
		auto milliSeconds = std::chrono::duration_cast<std::chrono::milliseconds> (duration);

		return (OptClass_uint64) milliSeconds.count();
	}
	else {
		return 0;
	}

}

