/*++

Copyright (C) 2019 PrimeDevelopers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated C++ implementation file in order to allow easy
development of Prime Numbers Library. It provides an automatic Journaling mechanism for the library implementation.

Interface version: 1.2.0

*/


#include <string>
#include <sstream>
#include <iomanip>

#include "libprimes_interfacejournal.hpp"
#include "libprimes_interfaceexception.hpp"


std::string LibPrimesHandleToHex (LibPrimesHandle pHandle)
{
	std::stringstream stream;
	stream << std::setfill('0') << std::setw(sizeof(LibPrimes_uint64) * 2)
		<< std::hex << (LibPrimes_uint64) pHandle;
	return stream.str();
}

CLibPrimesInterfaceJournalEntry::CLibPrimesInterfaceJournalEntry(CLibPrimesInterfaceJournal * pJournal, std::string sClassName, std::string sMethodName, LibPrimesHandle pInstanceHandle)
	: m_pJournal(pJournal), m_ErrorCode(LIBPRIMES_SUCCESS), m_sClassName(sClassName), m_sMethodName(sMethodName), m_nInitTimeStamp(0), m_nFinishTimeStamp(0)
{
	if (pJournal == nullptr)
		throw ELibPrimesInterfaceException(LIBPRIMES_ERROR_INVALIDPARAM);
	m_nInitTimeStamp = m_pJournal->getTimeStamp ();
	m_sInstanceHandle = LibPrimesHandleToHex (pInstanceHandle);
}

CLibPrimesInterfaceJournalEntry::~CLibPrimesInterfaceJournalEntry()
{
}

void CLibPrimesInterfaceJournalEntry::addParameter(const std::string & sName, const std::string & sParameterType, const std::string & sParameterValue)
{
	m_sParameters.push_back(std::make_pair(std::make_pair(sName, sParameterType), sParameterValue));
}

void CLibPrimesInterfaceJournalEntry::addResult(const std::string & sName, const std::string & sResultType, const std::string & sResultValue)
{
	m_sResultValues.push_back(std::make_pair(std::make_pair(sName, sResultType), sResultValue));
}

std::string CLibPrimesInterfaceJournalEntry::getXMLString()
{
	std::stringstream sStream;
	LibPrimes_uint64 nDuration = 0;

	if (m_nFinishTimeStamp > m_nInitTimeStamp)
		nDuration = m_nFinishTimeStamp - m_nInitTimeStamp;

	sStream << "    <entry";
	if (m_sClassName != "")
		sStream << " class=\"" << m_sClassName << "\"";
	sStream << " method=\"" << m_sMethodName << "\"";
	if (m_ErrorCode != LIBPRIMES_SUCCESS)
		sStream << " errorcode=\"" << m_ErrorCode << "\"";
	sStream << " timestamp=\"" << m_nInitTimeStamp << "\" duration=\"" << nDuration << "\">\n";

	if (m_sClassName != "")
		sStream << "        <instance handle=\"" << m_sInstanceHandle << "\" />\n";

	auto iParamIter = m_sParameters.begin();
	while (iParamIter != m_sParameters.end()) {
		sStream << "        <parameter name=\"" << iParamIter->first.first << "\" type=\"" << iParamIter->first.second << "\" value=\"" << iParamIter->second <<"\" />\n";
		iParamIter++;
	}

	auto iResultIter = m_sResultValues.begin();
	while (iResultIter != m_sResultValues.end()) {
		sStream << "        <result name=\"" << iResultIter->first.first << "\" type=\"" << iResultIter->first.second << "\" value=\"" << iResultIter->second << "\" />\n";
		iResultIter++;
	}

	sStream << "    </entry>\n";
	return sStream.str ();
}

void CLibPrimesInterfaceJournalEntry::writeSuccess()
{
	writeError(LIBPRIMES_SUCCESS);
}

void CLibPrimesInterfaceJournalEntry::writeError(LibPrimesResult nErrorCode)
{
	m_ErrorCode = nErrorCode;
	m_nFinishTimeStamp = m_pJournal->getTimeStamp();
	m_pJournal->writeEntry(this);
}

void CLibPrimesInterfaceJournalEntry::addBooleanParameter(const std::string & sName, const bool bValue)
{
	addParameter (sName, "bool", std::to_string((int)bValue));
}

void CLibPrimesInterfaceJournalEntry::addUInt8Parameter(const std::string & sName, const LibPrimes_uint8 nValue)
{
	addParameter(sName, "uint8", std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addUInt16Parameter(const std::string & sName, const LibPrimes_uint16 nValue)
{
	addParameter(sName, "uint16", std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addUInt32Parameter(const std::string & sName, const LibPrimes_uint32 nValue)
{
	addParameter(sName, "uint32", std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addUInt64Parameter(const std::string & sName, const LibPrimes_uint64 nValue)
{
	addParameter(sName, "uint64", std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addInt8Parameter(const std::string & sName, const LibPrimes_int8 nValue)
{
	addParameter(sName, "int8", std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addInt16Parameter(const std::string & sName, const LibPrimes_int16 nValue)
{
	addParameter(sName, "int16", std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addInt32Parameter(const std::string & sName, const LibPrimes_int32 nValue)
{
	addParameter(sName, "uint32", std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addInt64Parameter(const std::string & sName, const LibPrimes_int64 nValue)
{
	addParameter(sName, "int64", std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addSingleParameter(const std::string & sName,  const LibPrimes_single fValue)
{
	addParameter(sName, "single", std::to_string(fValue));
}

void CLibPrimesInterfaceJournalEntry::addDoubleParameter(const std::string & sName, const LibPrimes_double dValue)
{
	addParameter(sName, "double", std::to_string(dValue));
}
void CLibPrimesInterfaceJournalEntry::addPointerParameter(const std::string & sName, const LibPrimes_pvoid pValue)
{
	addParameter(sName, "pointer", std::to_string(reinterpret_cast<const LibPrimes_uint64>(pValue)));
}

void CLibPrimesInterfaceJournalEntry::addStringParameter(const std::string & sName, const char * pValue)
{
	if (pValue != nullptr) {
		addParameter(sName, "string", pValue);
	}
	else {
		addParameter(sName, "nullstring", "");
	}
}

void CLibPrimesInterfaceJournalEntry::addHandleParameter(const std::string & sName, const LibPrimesHandle pHandle)
{
	addParameter(sName, "handle", LibPrimesHandleToHex(pHandle));
}

void CLibPrimesInterfaceJournalEntry::addEnumParameter(const std::string & sName, const std::string & sEnumType, const LibPrimes_int32 nValue)
{
	addParameter(sName, "enum" + sEnumType, std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addBooleanResult(const std::string & sName, const bool bValue)
{
	addResult(sName, "bool", std::to_string((int)bValue));
}

void CLibPrimesInterfaceJournalEntry::addUInt8Result(const std::string & sName, const LibPrimes_uint8 nValue)
{
	addResult(sName, "uint8", std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addUInt16Result(const std::string & sName, const LibPrimes_uint16 nValue)
{
	addResult(sName, "uint16", std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addUInt32Result(const std::string & sName, const LibPrimes_uint32 nValue)
{
	addResult(sName, "uint32", std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addUInt64Result(const std::string & sName, const LibPrimes_uint64 nValue)
{
	addResult(sName, "uint64", std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addInt8Result(const std::string & sName, const LibPrimes_int8 nValue)
{
	addResult(sName, "int8", std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addInt16Result(const std::string & sName, const LibPrimes_int16 nValue)
{
	addResult(sName, "int16", std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addInt32Result(const std::string & sName, const LibPrimes_int32 nValue)
{
	addResult(sName, "uint32", std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addInt64Result(const std::string & sName, const LibPrimes_int64 nValue)
{
	addResult(sName, "int64", std::to_string(nValue));
}

void CLibPrimesInterfaceJournalEntry::addSingleResult(const std::string & sName,  const LibPrimes_single fValue)
{
	addResult(sName, "single", std::to_string(fValue));
}

void CLibPrimesInterfaceJournalEntry::addDoubleResult(const std::string & sName, const LibPrimes_double dValue)
{
	addResult(sName, "double", std::to_string(dValue));
}

void CLibPrimesInterfaceJournalEntry::addPointerResult(const std::string & sName, const LibPrimes_pvoid pValue)
{
	addResult(sName, "pointer", std::to_string(reinterpret_cast<const LibPrimes_uint64>(pValue)));
}

void CLibPrimesInterfaceJournalEntry::addStringResult(const std::string & sName, const char * pValue)
{
	if (pValue != nullptr) {
		addResult(sName, "string", pValue);
	}
	else {
		addResult(sName, "nullstring", "");
	}
}

void CLibPrimesInterfaceJournalEntry::addHandleResult(const std::string & sName, const LibPrimesHandle pHandle)
{
	addResult(sName, "handle", LibPrimesHandleToHex(pHandle));
}

void CLibPrimesInterfaceJournalEntry::addEnumResult(const std::string & sName, const std::string & sEnumType, const LibPrimes_int32 nValue)
{
	addResult(sName, "enum" + sEnumType, std::to_string(nValue));
}


CLibPrimesInterfaceJournal::CLibPrimesInterfaceJournal (const std::string & sFileName)
	: m_sFileName (sFileName)
{
	m_StartTime = std::chrono::high_resolution_clock::now();
	m_Stream.open (sFileName, std::ios::out);
	m_Stream << "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
	m_Stream << "<journal library=\"LibPrimes\" version=\"1.2.0\" xmlns=\"http://schemas.autodesk.com/components/LibPrimes/1.2.0\">\n";
	m_Stream << "\n";

}

CLibPrimesInterfaceJournal::~CLibPrimesInterfaceJournal ()
{
	m_Stream << "</journal>\n";
}

PLibPrimesInterfaceJournalEntry CLibPrimesInterfaceJournal::beginClassMethod(const LibPrimesHandle pHandle, const std::string & sClassName, const std::string & sMethodName)
{
	return std::make_shared<CLibPrimesInterfaceJournalEntry>(this, sClassName, sMethodName, pHandle);
}

PLibPrimesInterfaceJournalEntry CLibPrimesInterfaceJournal::beginStaticFunction(const std::string & sMethodName)
{
	return std::make_shared<CLibPrimesInterfaceJournalEntry>(this, "", sMethodName, nullptr);
}

void CLibPrimesInterfaceJournal::writeEntry (CLibPrimesInterfaceJournalEntry * pEntry)
{
	if (pEntry == nullptr)
		throw ELibPrimesInterfaceException (LIBPRIMES_ERROR_INVALIDPARAM);

	std::string sXMLString = pEntry->getXMLString();
	m_Mutex.lock();
	try {
		m_Stream << sXMLString;
		m_Stream << "\n";

		m_Mutex.unlock();
	}
	catch (...) {
		m_Mutex.unlock();
	}
}

LibPrimes_uint64 CLibPrimesInterfaceJournal::getTimeStamp ()
{
	auto currentTime = std::chrono::high_resolution_clock::now();
	if (m_StartTime < currentTime) {
		auto duration = currentTime - m_StartTime;
		auto milliSeconds = std::chrono::duration_cast<std::chrono::milliseconds> (duration);

		return (LibPrimes_uint64) milliSeconds.count();
	}
	else {
		return 0;
	}

}

