pub const ext = @import("ext.zig");
const gstglx11 = @This();

const std = @import("std");
const compat = @import("compat");
const gstvideo = @import("gstvideo1");
const gstbase = @import("gstbase1");
const gst = @import("gst1");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gmodule = @import("gmodule2");
const gstgl = @import("gstgl1");
/// the contents of a `gstglx11.GLDisplayX11` are private and should only be accessed
/// through the provided API
pub const GLDisplayX11 = extern struct {
    pub const Parent = gstgl.GLDisplay;
    pub const Implements = [_]type{};
    pub const Class = gstglx11.GLDisplayX11Class;
    f_parent: gstgl.GLDisplay,
    f_name: ?[*:0]u8,
    f_display: ?*anyopaque,
    f_xcb_connection: ?*anyopaque,
    f_foreign_display: c_int,
    f__padding: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Create a new `gstglx11.GLDisplayX11` from the x11 display name.  See `XOpenDisplay`()
    /// for details on what is a valid name.
    extern fn gst_gl_display_x11_new(p_name: ?[*:0]const u8) ?*gstglx11.GLDisplayX11;
    pub const new = gst_gl_display_x11_new;

    /// Creates a new display connection from a X11 Display.
    extern fn gst_gl_display_x11_new_with_display(p_display: *anyopaque) *gstglx11.GLDisplayX11;
    pub const newWithDisplay = gst_gl_display_x11_new_with_display;

    extern fn gst_gl_display_x11_get_type() usize;
    pub const getGObjectType = gst_gl_display_x11_get_type;

    extern fn g_object_ref(p_self: *gstglx11.GLDisplayX11) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstglx11.GLDisplayX11) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GLDisplayX11, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const GLDisplayX11Class = extern struct {
    pub const Instance = gstglx11.GLDisplayX11;

    f_object_class: gstgl.GLDisplayClass,
    f__padding: [4]*anyopaque,

    pub fn as(p_instance: *GLDisplayX11Class, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};
