pub const ext = @import("ext.zig");
const gstvulkanxcb = @This();

const std = @import("std");
const compat = @import("compat");
const vulkan = @import("vulkan1");
const gstvulkan = @import("gstvulkan1");
const gstvideo = @import("gstvideo1");
const gstbase = @import("gstbase1");
const gst = @import("gst1");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gmodule = @import("gmodule2");
/// the contents of a `gstvulkanxcb.VulkanDisplayXCB` are private and should only be accessed
/// through the provided API
pub const VulkanDisplayXCB = opaque {
    pub const Parent = gstvulkan.VulkanDisplay;
    pub const Implements = [_]type{};
    pub const Class = gstvulkanxcb.VulkanDisplayXCBClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Create a new `gstvulkanxcb.VulkanDisplayXCB` from the xcb display name.  See XOpenDisplay\()
    /// for details on what is a valid name.
    extern fn gst_vulkan_display_xcb_new(p_name: ?[*:0]const u8) ?*gstvulkanxcb.VulkanDisplayXCB;
    pub const new = gst_vulkan_display_xcb_new;

    extern fn gst_vulkan_display_xcb_get_type() usize;
    pub const getGObjectType = gst_vulkan_display_xcb_get_type;

    extern fn g_object_ref(p_self: *gstvulkanxcb.VulkanDisplayXCB) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkanxcb.VulkanDisplayXCB) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanDisplayXCB, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanDisplayXCBClass = extern struct {
    pub const Instance = gstvulkanxcb.VulkanDisplayXCB;

    f_object_class: gstvulkan.VulkanDisplayClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanDisplayXCBClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};
