/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstNamedElementContainer;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.psi.PyComprehensionComponent;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyComprehensionIfComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstComprehensionElement
extends PyAstExpression,
PyAstNamedElementContainer {
    @Nullable
    default public PyAstExpression getResultExpression() {
        ASTNode[] exprs = this.getNode().getChildren(PythonDialectsTokenSetProvider.getInstance().getExpressionTokens());
        return exprs.length == 0 ? null : (PyAstExpression)exprs[0].getPsi();
    }

    default public List<PyComprehensionComponent> getComponents() {
        final ArrayList<PyComprehensionComponent> list = new ArrayList<PyComprehensionComponent>(5);
        this.visitComponents(new ComprehensionElementVisitor(){

            @Override
            void visitForComponent(PyComprehensionForComponent component) {
                list.add(component);
            }

            @Override
            void visitIfComponent(PyComprehensionIfComponent component) {
                list.add(component);
            }
        });
        return list;
    }

    default public List<PyComprehensionForComponent> getForComponents() {
        final ArrayList<PyComprehensionForComponent> list = new ArrayList<PyComprehensionForComponent>(5);
        this.visitComponents(new ComprehensionElementVisitor(){

            @Override
            void visitForComponent(PyComprehensionForComponent component) {
                list.add(component);
            }
        });
        return list;
    }

    default public List<PyComprehensionIfComponent> getIfComponents() {
        final ArrayList<PyComprehensionIfComponent> list = new ArrayList<PyComprehensionIfComponent>(5);
        this.visitComponents(new ComprehensionElementVisitor(){

            @Override
            void visitIfComponent(PyComprehensionIfComponent component) {
                list.add(component);
            }
        });
        return list;
    }

    @Override
    @NotNull
    default public List<PsiNamedElement> getNamedElements() {
        List<PyComprehensionForComponent> fors = this.getForComponents();
        PyAstExpression[] for_targets = new PyAstExpression[fors.size()];
        int i = 0;
        for (PyComprehensionForComponent for_comp : fors) {
            for_targets[i] = for_comp.getIteratorVariable();
            ++i;
        }
        List<PyAstExpression> expressions = PyUtilCore.flattenedParensAndLists(for_targets);
        ArrayList<PsiNamedElement> results = new ArrayList<PsiNamedElement>();
        for (PyAstExpression expression : expressions) {
            if (!(expression instanceof PsiNamedElement)) continue;
            results.add((PsiNamedElement)expression);
        }
        ArrayList<PsiNamedElement> arrayList = results;
        if (arrayList == null) {
            PyAstComprehensionElement.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Nullable
    private static ASTNode getNextExpression(ASTNode after) {
        ASTNode node = after;
        while ((node = node.getTreeNext()) != null && !PythonDialectsTokenSetProvider.getInstance().getExpressionTokens().contains(node.getElementType())) {
        }
        return node;
    }

    private void visitComponents(ComprehensionElementVisitor visitor) {
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType type = node.getElementType();
            ASTNode next = PyAstComprehensionElement.getNextExpression(node);
            if (next == null) break;
            if (type == PyTokenTypes.FOR_KEYWORD) {
                ASTNode next2 = PyAstComprehensionElement.getNextExpression(next);
                if (next2 == null) break;
                final PyAstExpression variable = (PyAstExpression)next.getPsi();
                final PyAstExpression iterated = (PyAstExpression)next2.getPsi();
                final boolean isAsync = Optional.ofNullable(node.getTreePrev()).map(ASTNode::getTreePrev).map(asyncNode -> asyncNode.getElementType() == PyTokenTypes.ASYNC_KEYWORD).orElse(false);
                visitor.visitForComponent(new PyComprehensionForComponent(){

                    public PyAstExpression getIteratorVariable() {
                        return variable;
                    }

                    public PyAstExpression getIteratedList() {
                        return iterated;
                    }

                    @Override
                    public boolean isAsync() {
                        return isAsync;
                    }
                });
                continue;
            }
            if (type != PyTokenTypes.IF_KEYWORD) continue;
            final PyAstExpression test = (PyAstExpression)next.getPsi();
            visitor.visitIfComponent(new PyComprehensionIfComponent(){

                public PyAstExpression getTest() {
                    return test;
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/ast/PyAstComprehensionElement", "getNamedElements"));
    }

    public static abstract class ComprehensionElementVisitor {
        void visitIfComponent(PyComprehensionIfComponent component) {
        }

        void visitForComponent(PyComprehensionForComponent component) {
        }
    }
}

