/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessageType;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputBase;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputSchema;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputs;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputsBaseKt;
import com.intellij.jupyter.core.jupyter.nbformat.NewLineProcessor;
import com.intellij.jupyter.core.jupyter.nbformat.NotebookEvent;
import com.intellij.jupyter.core.jupyter.nbformat.schema.v4.V4JupyterOutputSchema;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\tH\u0016J\u001f\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterStreamOutput;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterOutputBase;", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "outputSchema", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterOutputSchema;", "<init>", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterOutputSchema;)V", "name", "", "getName", "()Ljava/lang/String;", "text", "", "getText", "()Ljava/util/List;", "getTextForCopy", "copyTo", "Lcom/intellij/jupyter/core/jupyter/nbformat/NotebookEvent$OutputCreated;", "outputs", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterOutputs;", "indexOfDisplay", "", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterOutputs;Ljava/lang/Integer;)Lcom/intellij/jupyter/core/jupyter/nbformat/NotebookEvent$OutputCreated;", "appendString", "", "message", "Companion", "intellij.jupyter.core"})
public final class JupyterStreamOutput
extends JupyterOutputBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<String> text;

    public JupyterStreamOutput(@NotNull ObjectNode json, @NotNull JupyterOutputSchema outputSchema) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)outputSchema, (String)"outputSchema");
        super(json, outputSchema);
        this.name = outputSchema.getStreamOutputName(json);
        this.text = outputSchema.getStreamOutputText(json);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<String> getText() {
        return this.text;
    }

    @Override
    @NotNull
    public String getTextForCopy() {
        return CollectionsKt.joinToString$default((Iterable)this.text, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    public NotebookEvent.OutputCreated copyTo(@NotNull JupyterOutputs outputs, @Nullable Integer indexOfDisplay) {
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        return outputs.createStreamOutput(this.name, this.text);
    }

    public final void appendString(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        JsonNode jsonNode = this.getRoot().get("text");
        Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ArrayNode");
        new NewLineProcessor((ArrayNode)jsonNode, message);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterStreamOutput$Companion;", "", "<init>", "()V", "fromMessage", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterStreamOutput;", "message", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "fromText", "text", "", "name", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterStreamOutput fromMessage(@NotNull JupyterMessage message) {
            ObjectNode objectNode;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            ObjectNode $this$fromMessage_u24lambda_u240 = objectNode = JupyterJsonKt.getJackson().createObjectNode();
            boolean bl = false;
            $this$fromMessage_u24lambda_u240.put("name", message.getMessageContent().get("name").asText());
            Intrinsics.checkNotNull((Object)$this$fromMessage_u24lambda_u240);
            JupyterOutputsBaseKt.access$setOutputType($this$fromMessage_u24lambda_u240, message);
            ArrayNode array = $this$fromMessage_u24lambda_u240.putArray("text");
            Intrinsics.checkNotNull((Object)array);
            JupyterOutputsBaseKt.access$addMessageContentToArray(message, array);
            ObjectNode output = objectNode;
            Intrinsics.checkNotNull((Object)output);
            return new JupyterStreamOutput(output, V4JupyterOutputSchema.INSTANCE);
        }

        @NotNull
        public final JupyterStreamOutput fromText(@NotNull String text, @Nullable String name) {
            ObjectNode objectNode;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            ObjectNode $this$fromText_u24lambda_u241 = objectNode = JupyterJsonKt.getJackson().createObjectNode();
            boolean bl = false;
            String string = name;
            if (string == null) {
                string = "placeholder";
            }
            $this$fromText_u24lambda_u241.put("name", string);
            $this$fromText_u24lambda_u241.put("output_type", JupyterMessageType.STREAM.getValue());
            ArrayNode array = $this$fromText_u24lambda_u241.putArray("text");
            Intrinsics.checkNotNull((Object)array);
            new NewLineProcessor(array, text);
            ObjectNode output = objectNode;
            Intrinsics.checkNotNull((Object)output);
            return new JupyterStreamOutput(output, V4JupyterOutputSchema.INSTANCE);
        }

        public static /* synthetic */ JupyterStreamOutput fromText$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.fromText(string, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

