/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.setupPy;

import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateAction;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplateDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateSetupPyAction
extends CreateFromTemplateAction {
    private static final String AUTHOR_PROPERTY = "python.packaging.author";
    private static final String EMAIL_PROPERTY = "python.packaging.author.email";
    static final String SETUP_SCRIPT_TEMPLATE_NAME = "Setup Script";

    public CreateSetupPyAction() {
        super(SETUP_SCRIPT_TEMPLATE_NAME, PythonFileType.INSTANCE.getIcon(), () -> FileTemplateManager.getDefaultInstance().getInternalTemplate(SETUP_SCRIPT_TEMPLATE_NAME));
        this.getTemplatePresentation().setText(PyBundle.message("python.packaging.create.setup.py", new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateSetupPyAction.$$$reportNull$$$0(0);
        }
        Module module2 = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        e.getPresentation().setEnabled(module2 != null && !PyPackageUtil.hasSetupPy(module2));
    }

    public AttributesDefaults getAttributesDefaults(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        AttributesDefaults defaults = new AttributesDefaults("setup.py").withFixedName(true);
        if (project != null) {
            defaults.addPredefined("Import", CreateSetupPyAction.getSetupImport(dataContext));
            defaults.add("Package_name", project.getName());
            PropertiesComponent properties = PropertiesComponent.getInstance();
            defaults.add("Author", properties.getValue(AUTHOR_PROPERTY, SystemProperties.getUserName()));
            defaults.add("Author_email", properties.getValue(EMAIL_PROPERTY, ""));
            defaults.addPredefined("PackageList", CreateSetupPyAction.getPackageList(dataContext));
            defaults.addPredefined("PackageDirs", CreateSetupPyAction.getPackageDirs(dataContext));
        }
        defaults.setAttributeVisibleNames(CreateSetupPyAction.getVisibleNames());
        return defaults;
    }

    private static Map<String, String> getVisibleNames() {
        HashMap<String, String> attributeToName = new HashMap<String, String>();
        attributeToName.put("Package_name", PyBundle.message("python.packaging.create.setup.package.name", new Object[0]));
        attributeToName.put("Version", PyBundle.message("python.packaging.create.setup.version", new Object[0]));
        attributeToName.put("URL", PyBundle.message("python.packaging.create.setup.url", new Object[0]));
        attributeToName.put("License", PyBundle.message("python.packaging.create.setup.license", new Object[0]));
        attributeToName.put("Author", PyBundle.message("python.packaging.create.setup.author", new Object[0]));
        attributeToName.put("Author_Email", PyBundle.message("python.packaging.create.setup.author.email", new Object[0]));
        attributeToName.put("Description", PyBundle.message("python.packaging.create.setup.description", new Object[0]));
        return attributeToName;
    }

    @NotNull
    private static String getSetupImport(@NotNull DataContext dataContext) {
        Module module2;
        if (dataContext == null) {
            CreateSetupPyAction.$$$reportNull$$$0(1);
        }
        return CreateSetupPyAction.hasSetuptoolsPackage(module2 = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext)) ? "from setuptools import setup" : "from distutils.core import setup";
    }

    private static boolean hasSetuptoolsPackage(@Nullable Module module2) {
        Sdk sdk2 = PythonSdkUtil.findPythonSdk(module2);
        if (sdk2 == null) {
            return false;
        }
        List<PyPackage> packages2 = PyPackageManager.getInstance(sdk2).getPackages();
        return packages2 != null && PyPsiPackageUtil.findPackage(packages2, "setuptools") != null;
    }

    private static String getPackageList(DataContext dataContext) {
        Module module2 = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
        if (module2 != null) {
            return "['" + StringUtil.join(PyPackageUtil.getPackageNames(module2), (String)"', '") + "']";
        }
        return "[]";
    }

    private static String getPackageDirs(DataContext dataContext) {
        Module module2 = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
        if (module2 != null) {
            VirtualFile[] sourceRoots;
            for (VirtualFile sourceRoot : sourceRoots = ModuleRootManager.getInstance((Module)module2).getSourceRoots()) {
                VirtualFile contentRoot = ProjectFileIndex.getInstance((Project)module2.getProject()).getContentRootForFile(sourceRoot);
                if (contentRoot == null || Comparing.equal((Object)contentRoot, (Object)sourceRoot)) continue;
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)sourceRoot, (VirtualFile)contentRoot, (char)'/');
                return "\n    package_dir={'': '" + relativePath + "'},";
            }
        }
        return "";
    }

    protected PsiDirectory getTargetDirectory(DataContext dataContext, IdeView view) {
        Collection<VirtualFile> sourceRoots;
        Module module2 = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
        if (module2 != null && !(sourceRoots = PyUtil.getSourceRoots(module2)).isEmpty()) {
            return PsiManager.getInstance((Project)module2.getProject()).findDirectory(sourceRoots.iterator().next());
        }
        return super.getTargetDirectory(dataContext, view);
    }

    protected void elementCreated(CreateFromTemplateDialog dialog2, PsiElement createdElement) {
        String authorEmail;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Properties properties = dialog2.getEnteredProperties();
        String author = properties.getProperty("Author");
        if (author != null) {
            propertiesComponent.setValue(AUTHOR_PROPERTY, author);
        }
        if ((authorEmail = properties.getProperty("Author_email")) != null) {
            propertiesComponent.setValue(EMAIL_PROPERTY, authorEmail);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/packaging/setupPy/CreateSetupPyAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSetupImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

