/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "kubevirt.io/api/export/v1alpha1"
)

// FakeVirtualMachineExports implements VirtualMachineExportInterface
type FakeVirtualMachineExports struct {
	Fake *FakeExportV1alpha1
	ns   string
}

var virtualmachineexportsResource = v1alpha1.SchemeGroupVersion.WithResource("virtualmachineexports")

var virtualmachineexportsKind = v1alpha1.SchemeGroupVersion.WithKind("VirtualMachineExport")

// Get takes name of the virtualMachineExport, and returns the corresponding virtualMachineExport object, and an error if there is any.
func (c *FakeVirtualMachineExports) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.VirtualMachineExport, err error) {
	emptyResult := &v1alpha1.VirtualMachineExport{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(virtualmachineexportsResource, c.ns, name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.VirtualMachineExport), err
}

// List takes label and field selectors, and returns the list of VirtualMachineExports that match those selectors.
func (c *FakeVirtualMachineExports) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.VirtualMachineExportList, err error) {
	emptyResult := &v1alpha1.VirtualMachineExportList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(virtualmachineexportsResource, virtualmachineexportsKind, c.ns, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.VirtualMachineExportList{ListMeta: obj.(*v1alpha1.VirtualMachineExportList).ListMeta}
	for _, item := range obj.(*v1alpha1.VirtualMachineExportList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested virtualMachineExports.
func (c *FakeVirtualMachineExports) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchActionWithOptions(virtualmachineexportsResource, c.ns, opts))

}

// Create takes the representation of a virtualMachineExport and creates it.  Returns the server's representation of the virtualMachineExport, and an error, if there is any.
func (c *FakeVirtualMachineExports) Create(ctx context.Context, virtualMachineExport *v1alpha1.VirtualMachineExport, opts v1.CreateOptions) (result *v1alpha1.VirtualMachineExport, err error) {
	emptyResult := &v1alpha1.VirtualMachineExport{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(virtualmachineexportsResource, c.ns, virtualMachineExport, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.VirtualMachineExport), err
}

// Update takes the representation of a virtualMachineExport and updates it. Returns the server's representation of the virtualMachineExport, and an error, if there is any.
func (c *FakeVirtualMachineExports) Update(ctx context.Context, virtualMachineExport *v1alpha1.VirtualMachineExport, opts v1.UpdateOptions) (result *v1alpha1.VirtualMachineExport, err error) {
	emptyResult := &v1alpha1.VirtualMachineExport{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(virtualmachineexportsResource, c.ns, virtualMachineExport, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.VirtualMachineExport), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeVirtualMachineExports) UpdateStatus(ctx context.Context, virtualMachineExport *v1alpha1.VirtualMachineExport, opts v1.UpdateOptions) (result *v1alpha1.VirtualMachineExport, err error) {
	emptyResult := &v1alpha1.VirtualMachineExport{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceActionWithOptions(virtualmachineexportsResource, "status", c.ns, virtualMachineExport, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.VirtualMachineExport), err
}

// Delete takes name of the virtualMachineExport and deletes it. Returns an error if one occurs.
func (c *FakeVirtualMachineExports) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(virtualmachineexportsResource, c.ns, name, opts), &v1alpha1.VirtualMachineExport{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeVirtualMachineExports) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionActionWithOptions(virtualmachineexportsResource, c.ns, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.VirtualMachineExportList{})
	return err
}

// Patch applies the patch and returns the patched virtualMachineExport.
func (c *FakeVirtualMachineExports) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.VirtualMachineExport, err error) {
	emptyResult := &v1alpha1.VirtualMachineExport{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(virtualmachineexportsResource, c.ns, name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.VirtualMachineExport), err
}
