/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.vfs2.util.CombinedResources;

public final class Messages {
    private static final ConcurrentMap<String, MessageFormat> MESSAGE_MAP = new ConcurrentHashMap<String, MessageFormat>();
    private static final ResourceBundle RESOURCES = new CombinedResources("org.apache.commons.vfs2.Resources");

    private Messages() {
    }

    public static String getString(String code) {
        return Messages.getString(code, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    @Deprecated
    public static String getString(String code, Object param) {
        return Messages.getString(code, new Object[]{param});
    }

    public static String getString(String code, Object ... params) {
        try {
            if (code == null) {
                return null;
            }
            return Messages.findMessage(code).format(params);
        }
        catch (MissingResourceException mre) {
            return "Unknown message with code \"" + code + "\".";
        }
    }

    private static MessageFormat findMessage(String code) throws MissingResourceException {
        return MESSAGE_MAP.computeIfAbsent(code, k -> new MessageFormat(RESOURCES.getString((String)k)));
    }
}

