/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPathRefTrie;
import com.intellij.database.util.ObjectPathSynchronizedTrie;
import com.intellij.database.util.ObjectPathTrieImpl;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ObjectPathTrie<V> {
    public void clear();

    @NotNull
    public List<? extends V> clearAndCollectValues();

    public V put(@NotNull ObjectPath var1, V var2);

    public V putIfAbsent(@NotNull ObjectPath var1, V var2);

    public V get(@NotNull ObjectPath var1);

    public V remove(@NotNull ObjectPath var1);

    public boolean remove(@NotNull ObjectPath var1, V var2);

    public boolean removeCascade(@NotNull ObjectPath var1);

    @NotNull
    public List<? extends V> removeCascadeAndCollectValues(@NotNull ObjectPath var1);

    public boolean contains(@NotNull ObjectPath var1);

    @NotNull
    public Iterable<ObjectPath> getChildren(@Nullable ObjectPath var1);

    public static <V> ObjectPathTrie<V> create() {
        return new ObjectPathTrieImpl(HashMap::new);
    }

    public static <V> ObjectPathTrie<V> createConcurrent() {
        return new ObjectPathSynchronizedTrie(ObjectPathTrieImpl::new);
    }

    public static <V> ObjectPathTrie<V> createSoftValueTrie() {
        return ObjectPathRefTrie.createSoftValueTrie(HashMap::new);
    }

    public static <V> ObjectPathTrie<V> createConcurrentSoftValueTrie() {
        return new ObjectPathSynchronizedTrie(ObjectPathRefTrie::createSoftValueTrie);
    }
}

