/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.lexer;

import com.intellij.database.Dbms;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStringTokenLexer
extends LexerBase {
    private final Dbms myDbms;
    private final boolean myTokenizeQuotes;
    private boolean myWithSlashEscapes;
    protected CharSequence myBuffer;
    protected int myStart;
    protected int myEnd;
    protected int myBufferStart;
    protected int myBufferEnd;
    protected IElementType myTokenType;
    private int myFirstQuoteOffset;

    public SqlStringTokenLexer(Dbms dbms) {
        this(dbms, false);
    }

    public SqlStringTokenLexer(Dbms dbms, boolean tokenizeQuotes) {
        this.myDbms = dbms;
        this.myTokenizeQuotes = tokenizeQuotes;
    }

    public int getState() {
        return 0;
    }

    public int getTokenStart() {
        return this.myStart;
    }

    public int getTokenEnd() {
        return this.myEnd;
    }

    public void advance() {
        this.myStart = this.myEnd;
        this.locateToken();
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            SqlStringTokenLexer.$$$reportNull$$$0(0);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myTokenType;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            SqlStringTokenLexer.$$$reportNull$$$0(1);
        }
        this.myBuffer = buffer;
        this.myStart = this.myEnd = startOffset;
        this.myBufferStart = this.myEnd;
        this.myBufferEnd = endOffset;
        this.myWithSlashEscapes = DbSqlUtilCore.stringsAreEscapedWithSlash(this.myDbms) || DbSqlUtilCore.supportsEscapeStringLiterals(this.myDbms) && startOffset < endOffset && (buffer.charAt(this.myBufferStart) == 'e' || buffer.charAt(this.myBufferStart) == 'E');
        this.myFirstQuoteOffset = StringUtil.indexOf((CharSequence)buffer, (char)'\'', (int)this.myBufferStart, (int)this.myBufferEnd);
        this.locateToken();
    }

    private void locateToken() {
        if (this.myStart >= this.myBufferEnd) {
            this.myTokenType = null;
            return;
        }
        if (this.myTokenizeQuotes) {
            if (this.myStart <= this.myFirstQuoteOffset) {
                this.myEnd = this.myFirstQuoteOffset + 1;
                this.myTokenType = SqlTokens.SQL_CUSTOM_LQUOTE;
                return;
            }
            if (this.myStart == this.myBufferEnd - 1) {
                this.myEnd = this.myBufferEnd;
                this.myTokenType = SqlTokens.SQL_CUSTOM_RQUOTE;
                return;
            }
        }
        char curChar = this.myBuffer.charAt(this.myStart);
        if (this.myStart + 1 >= this.myBufferEnd - 1 && curChar == '\\' && this.myWithSlashEscapes) {
            ++this.myEnd;
            this.myTokenType = StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
        } else if (!(curChar == '\\' && this.myWithSlashEscapes || curChar == '\'' && this.myStart > this.myFirstQuoteOffset && this.myStart < this.myBufferEnd - 1)) {
            char c2;
            this.myTokenType = SqlTokens.SQL_STRING_TOKEN;
            while (!(++this.myEnd >= this.myBufferEnd || (c2 = this.myBuffer.charAt(this.myEnd)) == '\'' && (this.myEnd != this.myBufferEnd - 1 || this.myTokenizeQuotes) || c2 == '\\' && this.myWithSlashEscapes)) {
            }
        } else if (curChar == '\'' && curChar == this.myBuffer.charAt(this.myStart + 1)) {
            this.myEnd += 2;
            this.myTokenType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        } else {
            this.myEnd += 2;
            this.myTokenType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/lexer/SqlStringTokenLexer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/lexer/SqlStringTokenLexer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

