/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.editor.DiffEditorTabFilesManager;
import com.intellij.diff.editor.DiffVirtualFileBase;
import com.intellij.diff.editor.SimpleDiffEditorEscapeAction;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.DiffRequestProcessorWithProducers;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreviewProvider;
import com.intellij.openapi.vcs.changes.PreviewDiffVirtualFile;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.platform.vcs.impl.shared.changes.DiffPreviewUpdateProcessor;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Processor;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Use EditorTabDiffPreview")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000e\b'\u0018\u0000 =2\u00020\u0001:\u0002<=B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u000e\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020\"H\u0014J\b\u0010(\u001a\u00020\"H\u0014J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001e\u0010+\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001e0-H\u0002J\u000f\u0010.\u001a\t\u0018\u00010/\u00a2\u0006\u0002\b0H$J\b\u00101\u001a\u00020\"H$J\b\u00102\u001a\u00020\"H\u0014J\u0010\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\"H\u0016J\b\u00105\u001a\u00020\"H\u0004J\b\u00106\u001a\u00020\u001eH\u0016J\u0010\u00107\u001a\u00020\"2\u0006\u00108\u001a\u00020\"H\u0016J\b\u00109\u001a\u00020\"H\u0002J\u0010\u0010:\u001a\u00020\"2\u0006\u00108\u001a\u00020\"H\u0002J\b\u0010;\u001a\u00020\"H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\n\u0018\u00010\u0017j\u0004\u0018\u0001`\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006>"}, d2={"Lcom/intellij/openapi/vcs/changes/EditorTabPreviewBase;", "Lcom/intellij/openapi/vcs/changes/DiffPreview;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getParentDisposable", "()Lcom/intellij/openapi/Disposable;", "updatePreviewQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "updatePreviewProcessor", "Lcom/intellij/platform/vcs/impl/shared/changes/DiffPreviewUpdateProcessor;", "getUpdatePreviewProcessor", "()Lcom/intellij/platform/vcs/impl/shared/changes/DiffPreviewUpdateProcessor;", "previewFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPreviewFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "escapeHandler", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "getEscapeHandler", "()Ljava/lang/Runnable;", "setEscapeHandler", "(Ljava/lang/Runnable;)V", "installListeners", "", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "isOpenEditorDiffPreviewWithSingleClick", "", "installSelectionHandler", "installNextDiffActionOn", "component", "Ljavax/swing/JComponent;", "isPreviewOnDoubleClickAllowed", "isPreviewOnEnterAllowed", "installDoubleClickHandler", "installEnterKeyHandler", "installSelectionChangedHandler", "handler", "Lkotlin/Function0;", "getCurrentName", "", "Lorg/jetbrains/annotations/Nls;", "hasContent", "skipPreviewUpdate", "updatePreview", "fromModelRefresh", "isPreviewOpen", "closePreview", "openPreview", "requestFocus", "ensureHasContent", "openPreviewEditor", "performDiffAction", "EditorTabDiffPreviewVirtualFile", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@ApiStatus.ScheduledForRemoval
@SourceDebugExtension(value={"SMAP\nEditorTabPreview.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorTabPreview.kt\ncom/intellij/openapi/vcs/changes/EditorTabPreviewBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1#2:255\n*E\n"})
public abstract class EditorTabPreviewBase
implements DiffPreview {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final MergingUpdateQueue updatePreviewQueue;
    @Nullable
    private Runnable escapeHandler;

    /*
     * WARNING - void declaration
     */
    public EditorTabPreviewBase(@NotNull Project project, @NotNull Disposable parentDisposable) {
        void $this$updatePreviewQueue_u24lambda_u240;
        MergingUpdateQueue mergingUpdateQueue;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.parentDisposable = parentDisposable;
        MergingUpdateQueue mergingUpdateQueue2 = mergingUpdateQueue = new MergingUpdateQueue("updatePreviewQueue", 100, true, null, this.parentDisposable, null, false, 96, null);
        EditorTabPreviewBase editorTabPreviewBase = this;
        boolean bl = false;
        $this$updatePreviewQueue_u24lambda_u240.setRestartTimerOnAdd(true);
        editorTabPreviewBase.updatePreviewQueue = mergingUpdateQueue;
        Disposer.register((Disposable)this.parentDisposable, () -> EditorTabPreviewBase._init_$lambda$1(this));
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final Disposable getParentDisposable() {
        return this.parentDisposable;
    }

    @NotNull
    protected abstract DiffPreviewUpdateProcessor getUpdatePreviewProcessor();

    @NotNull
    protected abstract VirtualFile getPreviewFile();

    @Nullable
    public final Runnable getEscapeHandler() {
        return this.escapeHandler;
    }

    public final void setEscapeHandler(@Nullable Runnable runnable) {
        this.escapeHandler = runnable;
    }

    public final void installListeners(@NotNull ChangesTree tree, boolean isOpenEditorDiffPreviewWithSingleClick) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        this.installDoubleClickHandler(tree);
        this.installEnterKeyHandler(tree);
        if (isOpenEditorDiffPreviewWithSingleClick) {
            DumbService.Companion.getInstance(this.project).smartInvokeLater(() -> EditorTabPreviewBase.installListeners$lambda$2(this, tree));
        } else {
            this.installSelectionHandler(tree, false);
        }
    }

    public final void installSelectionHandler(@NotNull ChangesTree tree, boolean isOpenEditorDiffPreviewWithSingleClick) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        this.installSelectionChangedHandler(tree, (Function0<Unit>)((Function0)() -> EditorTabPreviewBase.installSelectionHandler$lambda$3(isOpenEditorDiffPreviewWithSingleClick, this)));
    }

    public final void installNextDiffActionOn(@NotNull JComponent component) {
        DumbAwareAction dumbAwareAction;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        DumbAwareAction $this$installNextDiffActionOn_u24lambda_u246 = dumbAwareAction = DumbAwareAction.create(arg_0 -> EditorTabPreviewBase.installNextDiffActionOn$lambda$5(arg_0 -> EditorTabPreviewBase.installNextDiffActionOn$lambda$4(this, arg_0), arg_0));
        boolean bl = false;
        $this$installNextDiffActionOn_u24lambda_u246.copyShortcutFrom(ActionManager.getInstance().getAction("NextDiff"));
        $this$installNextDiffActionOn_u24lambda_u246.registerCustomShortcutSet(component, this.parentDisposable);
    }

    protected boolean isPreviewOnDoubleClickAllowed() {
        return true;
    }

    protected boolean isPreviewOnEnterAllowed() {
        return true;
    }

    private final void installDoubleClickHandler(ChangesTree tree) {
        Processor<? super MouseEvent> oldDoubleClickHandler = tree.getDoubleClickHandler();
        Processor newDoubleClickHandler = arg_0 -> EditorTabPreviewBase.installDoubleClickHandler$lambda$7(tree, this, oldDoubleClickHandler, arg_0);
        tree.setDoubleClickHandler((Processor<? super MouseEvent>)newDoubleClickHandler);
        Disposer.register((Disposable)this.parentDisposable, () -> EditorTabPreviewBase.installDoubleClickHandler$lambda$8(tree, oldDoubleClickHandler));
    }

    private final void installEnterKeyHandler(ChangesTree tree) {
        Processor<? super KeyEvent> oldEnterKeyHandler = tree.getEnterKeyHandler();
        Processor newEnterKeyHandler = arg_0 -> EditorTabPreviewBase.installEnterKeyHandler$lambda$9(this, oldEnterKeyHandler, arg_0);
        tree.setEnterKeyHandler((Processor<? super KeyEvent>)newEnterKeyHandler);
        Disposer.register((Disposable)this.parentDisposable, () -> EditorTabPreviewBase.installEnterKeyHandler$lambda$10(tree, oldEnterKeyHandler));
    }

    private final void installSelectionChangedHandler(ChangesTree tree, Function0<Unit> handler) {
        tree.addSelectionListener(() -> EditorTabPreviewBase.installSelectionChangedHandler$lambda$12(this, handler), (Disposable)this.updatePreviewQueue);
    }

    @Nullable
    protected abstract String getCurrentName();

    protected abstract boolean hasContent();

    protected boolean skipPreviewUpdate() {
        return ToolWindowManager.Companion.getInstance(this.project).isEditorComponentActive();
    }

    public void updatePreview(boolean fromModelRefresh) {
        if (this.isPreviewOpen()) {
            this.getUpdatePreviewProcessor().refresh(false);
        } else {
            this.getUpdatePreviewProcessor().clear();
        }
    }

    protected final boolean isPreviewOpen() {
        return FileEditorManager.getInstance((Project)this.project).isFileOpenWithRemotes(this.getPreviewFile());
    }

    public void closePreview() {
        DiffPreview.Companion.closePreviewFile(this.project, this.getPreviewFile());
        this.getUpdatePreviewProcessor().clear();
    }

    public boolean openPreview(boolean requestFocus) {
        if (!this.ensureHasContent()) {
            return false;
        }
        return this.openPreviewEditor(requestFocus);
    }

    private final boolean ensureHasContent() {
        this.getUpdatePreviewProcessor().refresh(false);
        return this.hasContent();
    }

    private final boolean openPreviewEditor(boolean requestFocus) {
        Runnable runnable = this.escapeHandler;
        if (runnable != null) {
            Runnable handler = runnable;
            boolean bl = false;
            Companion.registerEscapeHandler(this.getPreviewFile(), handler);
        }
        Companion.openPreview(this.project, this.getPreviewFile(), requestFocus);
        return true;
    }

    public boolean performDiffAction() {
        if (!this.ensureHasContent()) {
            return false;
        }
        if (ExternalDiffTool.isEnabled()) {
            DiffRequestProcessorWithProducers processorWithProducers;
            DiffPreviewUpdateProcessor diffPreviewUpdateProcessor = this.getUpdatePreviewProcessor();
            DiffRequestProcessorWithProducers diffRequestProcessorWithProducers = processorWithProducers = diffPreviewUpdateProcessor instanceof DiffRequestProcessorWithProducers ? (DiffRequestProcessorWithProducers)diffPreviewUpdateProcessor : null;
            if (processorWithProducers != null) {
                ListSelection<? extends DiffRequestProducer> diffProducers = processorWithProducers.collectDiffProducers(true);
                if (diffProducers != null && diffProducers.isEmpty()) {
                    DiffRequestProducer diffRequestProducer;
                    List list;
                    ListSelection<? extends DiffRequestProducer> listSelection = processorWithProducers.collectDiffProducers(false);
                    if (listSelection != null && (list = listSelection.getList()) != null && (diffRequestProducer = (DiffRequestProducer)CollectionsKt.firstOrNull((List)list)) != null) {
                        DiffRequestProducer it = diffRequestProducer;
                        boolean bl = false;
                        v1 = ListSelection.createSingleton((Object)it);
                    } else {
                        v1 = diffProducers = null;
                    }
                }
                if (Companion.showExternalToolIfNeeded(this.project, diffProducers)) {
                    return true;
                }
            }
        }
        return this.openPreviewEditor(true);
    }

    private static final void _init_$lambda$1(EditorTabPreviewBase this$0) {
        this$0.getPreviewFile().putUserData(DiffVirtualFileBase.ESCAPE_HANDLER, null);
    }

    private static final void installListeners$lambda$2(EditorTabPreviewBase this$0, ChangesTree $tree) {
        if (Disposer.isDisposed((Disposable)((Disposable)this$0.updatePreviewQueue))) {
            return;
        }
        this$0.installSelectionHandler($tree, true);
    }

    private static final Unit installSelectionHandler$lambda$3(boolean $isOpenEditorDiffPreviewWithSingleClick, EditorTabPreviewBase this$0) {
        if ($isOpenEditorDiffPreviewWithSingleClick) {
            if (!this$0.openPreview(false)) {
                this$0.closePreview();
            }
        } else {
            this$0.updatePreview(false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit installNextDiffActionOn$lambda$4(EditorTabPreviewBase this$0, AnActionEvent it) {
        this$0.openPreview(true);
        return Unit.INSTANCE;
    }

    private static final void installNextDiffActionOn$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean installDoubleClickHandler$lambda$7(ChangesTree $tree, EditorTabPreviewBase this$0, Processor $oldDoubleClickHandler, MouseEvent e) {
        JTree jTree = (JTree)((Object)$tree);
        Intrinsics.checkNotNull((Object)e);
        if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)jTree, (MouseEvent)e)) {
            return false;
        }
        if (this$0.isPreviewOnDoubleClickAllowed()) {
            if (this$0.performDiffAction()) return true;
        }
        Processor processor2 = $oldDoubleClickHandler;
        if (processor2 == null) return false;
        if (!processor2.process((Object)e)) return false;
        return true;
    }

    private static final void installDoubleClickHandler$lambda$8(ChangesTree $tree, Processor $oldDoubleClickHandler) {
        $tree.setDoubleClickHandler((Processor<? super MouseEvent>)$oldDoubleClickHandler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean installEnterKeyHandler$lambda$9(EditorTabPreviewBase this$0, Processor $oldEnterKeyHandler, KeyEvent e) {
        if (this$0.isPreviewOnEnterAllowed()) {
            if (this$0.performDiffAction()) return true;
        }
        Processor processor2 = $oldEnterKeyHandler;
        if (processor2 == null) return false;
        if (!processor2.process((Object)e)) return false;
        return true;
    }

    private static final void installEnterKeyHandler$lambda$10(ChangesTree $tree, Processor $oldEnterKeyHandler) {
        $tree.setEnterKeyHandler((Processor<? super KeyEvent>)$oldEnterKeyHandler);
    }

    private static final void installSelectionChangedHandler$lambda$12$lambda$11(EditorTabPreviewBase this$0, Function0 $handler) {
        if (!this$0.skipPreviewUpdate()) {
            $handler.invoke();
        }
    }

    private static final void installSelectionChangedHandler$lambda$12(EditorTabPreviewBase this$0, Function0 $handler) {
        MergingUpdateQueue mergingUpdateQueue = this$0.updatePreviewQueue;
        DisposableUpdate disposableUpdate = DisposableUpdate.createDisposable((Disposable)((Disposable)this$0.updatePreviewQueue), (Object)this$0, () -> EditorTabPreviewBase.installSelectionChangedHandler$lambda$12$lambda$11(this$0, $handler));
        Intrinsics.checkNotNullExpressionValue((Object)disposableUpdate, (String)"createDisposable(...)");
        mergingUpdateQueue.queue((Update)disposableUpdate);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012J\"\u0010\u0013\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0010\u0010\u0014\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0016\u0018\u00010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/EditorTabPreviewBase$Companion;", "", "<init>", "()V", "openPreview", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "focusEditor", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Z)[Lcom/intellij/openapi/fileEditor/FileEditor;", "registerEscapeHandler", "", "handler", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "showExternalToolIfNeeded", "diffProducers", "Lcom/intellij/openapi/ListSelection;", "Lcom/intellij/diff/chains/DiffRequestProducer;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileEditor[] openPreview(@NotNull Project project, @NotNull VirtualFile file, boolean focusEditor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return DiffEditorTabFilesManager.Companion.getInstance(project).showDiffFile(file, focusEditor);
        }

        public final void registerEscapeHandler(@NotNull VirtualFile file, @NotNull Runnable handler) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            file.putUserData(DiffVirtualFileBase.ESCAPE_HANDLER, (Object)new SimpleDiffEditorEscapeAction(handler));
        }

        public final boolean showExternalToolIfNeeded(@Nullable Project project, @Nullable ListSelection<? extends DiffRequestProducer> diffProducers) {
            if (diffProducers == null || diffProducers.isEmpty()) {
                return false;
            }
            List list = diffProducers.getExplicitSelection();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExplicitSelection(...)");
            List producers = list;
            DiffDialogHints diffDialogHints = DiffDialogHints.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)diffDialogHints, (String)"DEFAULT");
            return ExternalDiffTool.showIfNeeded((Project)project, (List)producers, (DiffDialogHints)diffDialogHints);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B,\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0013\u0010\u0006\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\b\u00a2\u0006\u0002\b\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/EditorTabPreviewBase$EditorTabDiffPreviewVirtualFile;", "Lcom/intellij/openapi/vcs/changes/PreviewDiffVirtualFile;", "diffProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "updatePreviewProcessor", "Lcom/intellij/platform/vcs/impl/shared/changes/DiffPreviewUpdateProcessor;", "tabNameProvider", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lcom/intellij/diff/impl/DiffRequestProcessor;Lcom/intellij/platform/vcs/impl/shared/changes/DiffPreviewUpdateProcessor;Lkotlin/jvm/functions/Function0;)V", "intellij.platform.vcs.impl"})
    public static final class EditorTabDiffPreviewVirtualFile
    extends PreviewDiffVirtualFile {
        public EditorTabDiffPreviewVirtualFile(@NotNull DiffRequestProcessor diffProcessor, @NotNull DiffPreviewUpdateProcessor updatePreviewProcessor, @NotNull Function0<String> tabNameProvider) {
            Intrinsics.checkNotNullParameter((Object)diffProcessor, (String)"diffProcessor");
            Intrinsics.checkNotNullParameter((Object)updatePreviewProcessor, (String)"updatePreviewProcessor");
            Intrinsics.checkNotNullParameter(tabNameProvider, (String)"tabNameProvider");
            super(new EditorTabDiffPreviewProvider(diffProcessor, tabNameProvider));
            diffProcessor.putContextUserData(DiffUserDataKeysEx.DIFF_IN_EDITOR_WITH_EXPLICIT_DISPOSABLE, () -> EditorTabDiffPreviewVirtualFile._init_$lambda$0(updatePreviewProcessor));
        }

        private static final void _init_$lambda$0(DiffPreviewUpdateProcessor $updatePreviewProcessor) {
            $updatePreviewProcessor.clear();
        }
    }
}

