/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter.deserialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanDescription;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/httpClient/postman/converter/deserialization/PostmanDescriptionSerializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanDescription;", "<init>", "()V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "intellij.restClient"})
public final class PostmanDescriptionSerializer
extends JsonDeserializer<PostmanDescription> {
    @Nullable
    public PostmanDescription deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext context2) {
        PostmanDescription postmanDescription;
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsonNode jsonNode = (JsonNode)parser.getCodec().readTree(parser);
        if (jsonNode == null) {
            return null;
        }
        JsonNode node = jsonNode;
        if (node.isTextual()) {
            String string = node.textValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textValue(...)");
            postmanDescription = new PostmanDescription.DescriptionString(string);
        } else {
            JsonNode jsonNode2 = node.get("content");
            JsonNode jsonNode3 = node.get("type");
            JsonNode jsonNode4 = node.get("version");
            postmanDescription = new PostmanDescription.DescriptionObject(jsonNode2 != null ? jsonNode2.textValue() : null, jsonNode3 != null ? jsonNode3.textValue() : null, jsonNode4 != null ? jsonNode4.textValue() : null);
        }
        return postmanDescription;
    }
}

