/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packages;

import com.intellij.javascript.nodejs.packages.NodePackageInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageInfoException
extends IOException {
    private final String myCommandLine;
    private final int myExitCode;
    private final String myStdOut;
    private final String myStdErr;

    public NodePackageInfoException(@NotNull String commandLine, int exitCode, @NotNull String stdOut, @NotNull String stdErr) {
        if (commandLine == null) {
            NodePackageInfoException.$$$reportNull$$$0(0);
        }
        if (stdOut == null) {
            NodePackageInfoException.$$$reportNull$$$0(1);
        }
        if (stdErr == null) {
            NodePackageInfoException.$$$reportNull$$$0(2);
        }
        super("FAILED COMMAND: " + commandLine + "\nEXIT CODE: " + exitCode + "\nSTDOUT:\n" + stdOut + "\nSTDERR:\n" + stdErr);
        this.myCommandLine = commandLine;
        this.myExitCode = exitCode;
        this.myStdOut = stdOut;
        this.myStdErr = stdErr;
    }

    @NotNull
    @Nls
    public String formatHtmlDescription() {
        StringBuilder buf = new StringBuilder();
        buf.append("<h4 style='color:red'>").append("Failed to load details: command returns non-zero exit code").append("</h4>");
        NodePackageInfoException.addSection(buf, "Command line", this.myCommandLine);
        if (StringUtil.isNotEmpty((String)this.myStdOut)) {
            NodePackageInfoException.addSection(buf, "Standard output", this.myStdOut);
        }
        NodePackageInfoException.addSection(buf, "Standard error", this.myStdErr);
        NodePackageInfoException.addSection(buf, "Process finished with exit code " + this.myExitCode, null);
        String string = NodePackageInfo.createHtml(buf.toString());
        if (string == null) {
            NodePackageInfoException.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void addSection(@NotNull StringBuilder buf, @Nullable String title, @Nullable String data2) {
        if (buf == null) {
            NodePackageInfoException.$$$reportNull$$$0(4);
        }
        if (title != null) {
            buf.append("<h4>").append(StringUtil.escapeXmlEntities((String)title)).append("</h4>");
        }
        if (data2 != null) {
            buf.append("<div style='padding-left:5px'><pre><code>");
            buf.append(StringUtil.escapeXmlEntities((String)data2));
            buf.append("</code></pre></div>");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdOut";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdErr";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packages/NodePackageInfoException";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packages/NodePackageInfoException";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatHtmlDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

