/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageDescriptor {
    private static final Logger LOG = Logger.getInstance(NodePackageDescriptor.class);
    private final List<String> myPackageNames;
    private final Map<String, String> myDependencyByPackageMap;
    private final @NlsContexts.StatusText String myHintText;

    public NodePackageDescriptor(@NotNull String packageName) {
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(0);
        }
        this(Collections.singletonList(packageName), null);
    }

    public NodePackageDescriptor(String ... packageNames) {
        if (packageNames == null) {
            NodePackageDescriptor.$$$reportNull$$$0(1);
        }
        this(List.of(packageNames), null);
    }

    public NodePackageDescriptor(@NotNull List<String> packageNames) {
        if (packageNames == null) {
            NodePackageDescriptor.$$$reportNull$$$0(2);
        }
        this(List.copyOf(packageNames), null);
    }

    public NodePackageDescriptor(@NotNull List<String> packageNames, @NlsContexts.StatusText @Nullable String hintText) {
        if (packageNames == null) {
            NodePackageDescriptor.$$$reportNull$$$0(3);
        }
        this(List.copyOf(packageNames), Collections.emptyMap(), hintText);
    }

    public NodePackageDescriptor(@NotNull List<String> packageNames, @NotNull Map<String, String> dependencyByPackageMap, @NlsContexts.StatusText @Nullable String hintText) {
        if (packageNames == null) {
            NodePackageDescriptor.$$$reportNull$$$0(4);
        }
        if (dependencyByPackageMap == null) {
            NodePackageDescriptor.$$$reportNull$$$0(5);
        }
        this.myPackageNames = List.copyOf(packageNames);
        this.myDependencyByPackageMap = Map.copyOf(dependencyByPackageMap);
        this.myHintText = hintText;
    }

    @NotNull
    public List<String> getPackageNames() {
        List<String> list = this.myPackageNames;
        if (list == null) {
            NodePackageDescriptor.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public String getDependencyByPackageName(@NotNull String packageName) {
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(7);
        }
        return this.myDependencyByPackageMap.get(packageName);
    }

    @NotNull
    public NodePackage createPackage(@NotNull String path2) {
        YarnPnpNodePackage yarnPnpNodePackage;
        if (path2 == null) {
            NodePackageDescriptor.$$$reportNull$$$0(8);
        }
        if ((yarnPnpNodePackage = YarnPnpNodePackage.createFromText(path2)) != null) {
            YarnPnpNodePackage yarnPnpNodePackage2 = yarnPnpNodePackage;
            if (yarnPnpNodePackage2 == null) {
                NodePackageDescriptor.$$$reportNull$$$0(9);
            }
            return yarnPnpNodePackage2;
        }
        return new NodePackage(LocalFilePath.stripRemoteProtocol(path2));
    }

    @NotNull
    public NodePackageRef createPackageRef(@NotNull String text) {
        if (text == null) {
            NodePackageDescriptor.$$$reportNull$$$0(10);
        }
        NodePackageRef nodePackageRef = NodePackageRef.create(this.createPackage(text));
        if (nodePackageRef == null) {
            NodePackageDescriptor.$$$reportNull$$$0(11);
        }
        return nodePackageRef;
    }

    @NotNull
    public NodePackageRef dereferenceIfProjectRef(@NotNull Project project, @NotNull NodePackageRef ref2) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(12);
        }
        if (ref2 == null) {
            NodePackageDescriptor.$$$reportNull$$$0(13);
        }
        NodePackageRef nodePackageRef = ref2;
        if (nodePackageRef == null) {
            NodePackageDescriptor.$$$reportNull$$$0(14);
        }
        return nodePackageRef;
    }

    @NotNull
    public NodePackage findFirstDirectDependencyPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter2, @Nullable VirtualFile contextFileOrDirectory) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(15);
        }
        NodePackage nodePackage = (NodePackage)ReadAction.compute(() -> {
            List<NodePackage> packages = this.listAvailable(project, interpreter2, contextFileOrDirectory, true);
            NodePackage pkg = (NodePackage)ContainerUtil.getFirstItem(packages);
            return pkg != null ? pkg : this.createPackage("");
        });
        if (nodePackage == null) {
            NodePackageDescriptor.$$$reportNull$$$0(16);
        }
        return nodePackage;
    }

    @NotNull
    public List<NodePackageRef> listPackageRefs(@NotNull Project project, @Nullable NodeJsInterpreter interpreter2, @Nullable VirtualFile contextFileOrDirectory) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(17);
        }
        List<NodePackage> packages = this.listAvailable(project, interpreter2, contextFileOrDirectory, false);
        List list = ContainerUtil.map(packages, pkg -> NodePackageRef.create(pkg));
        if (list == null) {
            NodePackageDescriptor.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public final List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter2, @Nullable VirtualFile contextFileOrDirectory) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(19);
        }
        List<NodePackage> list = this.listAvailable(project, interpreter2, contextFileOrDirectory, false);
        if (list == null) {
            NodePackageDescriptor.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    public List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter2, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(21);
        }
        List<NodePackage> list = this.listAvailable(project, interpreter2, contextFileOrDirectory, directDependenciesInsideProject, false);
        if (list == null) {
            NodePackageDescriptor.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter2, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject, boolean dependenciesShouldBeVisibleFromContext) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(23);
        }
        LinkedHashSet packages = new LinkedHashSet();
        LinkedHashSet globalPackages = new LinkedHashSet();
        for (String packageName : this.myPackageNames) {
            ReadAction.run(() -> NodePackageDescriptor.listAvailable(packages, globalPackages, packageName, this.myDependencyByPackageMap.get(packageName), project, interpreter2, contextFileOrDirectory, directDependenciesInsideProject, this::createPackage));
        }
        LinkedHashSet<NodePackage> result2 = new LinkedHashSet<NodePackage>();
        if (contextFileOrDirectory != null) {
            MultiMap map2 = MultiMap.create();
            for (NodePackageAndPackageJson pkg : packages) {
                VirtualFile packageJson = pkg.getPackageJson();
                VirtualFile root = packageJson != null ? packageJson.getParent() : null;
                if (root == null) continue;
                map2.putValue((Object)root, (Object)pkg.getPackage());
            }
            for (VirtualFile dir = contextFileOrDirectory; dir != null; dir = dir.getParent()) {
                result2.addAll(map2.get((Object)dir));
            }
        }
        if (!dependenciesShouldBeVisibleFromContext) {
            for (NodePackageAndPackageJson pkg : packages) {
                result2.add(pkg.getPackage());
            }
        }
        result2.addAll(globalPackages);
        return new ArrayList<NodePackage>(result2);
    }

    @NlsContexts.StatusText
    @Nullable
    public String getHintText() {
        String pkgText;
        if (this.myHintText != null) {
            return this.myHintText;
        }
        if (this.myPackageNames.size() == 1) {
            pkgText = (String)ContainerUtil.getFirstItem(this.myPackageNames);
        } else if (this.myPackageNames.size() > 1) {
            pkgText = JavaScriptBundle.message("node.package.empty.hint.pkg1.or.pkg2", StringUtil.join(this.myPackageNames.subList(0, this.myPackageNames.size() - 1), (String)", "), ContainerUtil.getLastItem(this.myPackageNames));
        } else {
            return null;
        }
        return JavaScriptBundle.message("node.package.empty.hint", pkgText);
    }

    @Nullable
    public NodePackage findUnambiguousDependencyPackage(@NotNull Project project) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(24);
        }
        String packageName = Objects.requireNonNull((String)ContainerUtil.getFirstItem(this.myPackageNames));
        VirtualFile projectRoot = ProjectUtil.guessProjectDir((Project)project);
        if (project.isDefault() || projectRoot == null) {
            return null;
        }
        VirtualFile packageJson = JSLinterConfigFileUtil.findDistinctConfigInContentRoots(project, Collections.singletonList("package.json"));
        if (packageJson == null || !PackageJsonData.getOrCreate(packageJson).isDependencyOfAnyType(packageName)) {
            return null;
        }
        YarnPnpNodePackage yarnPnpNodePackage = YarnPnpNodePackage.create(project, packageJson, packageName, true, false);
        if (yarnPnpNodePackage != null) {
            return yarnPnpNodePackage;
        }
        boolean yarn = NpmUtil.isYarnAlikePackageRef(NpmManager.getInstance(project).getPackageRef());
        if (yarn) {
            return null;
        }
        Path projectRootPath = projectRoot.toNioPath();
        return new NodePackage(projectRootPath.resolve("node_modules").resolve(packageName));
    }

    private static void listAvailable(@NotNull Set<NodePackageAndPackageJson> packages, @NotNull Set<NodePackage> globalPackages, @NotNull String packageName, @Nullable String dependencyName, @NotNull Project project, @Nullable NodeJsInterpreter interpreter2, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject, @NotNull NodePackageProducer packageProducer) {
        if (packages == null) {
            NodePackageDescriptor.$$$reportNull$$$0(25);
        }
        if (globalPackages == null) {
            NodePackageDescriptor.$$$reportNull$$$0(26);
        }
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(27);
        }
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(28);
        }
        if (packageProducer == null) {
            NodePackageDescriptor.$$$reportNull$$$0(29);
        }
        ArrayList modules = new ArrayList();
        if (contextFileOrDirectory != null) {
            NodeModuleSearchUtil.findModulesWithName(modules, packageName, contextFileOrDirectory, null);
        }
        if (!project.isDefault()) {
            NodeModuleSearchUtil.findModulesByNameInContentRoots(modules, packageName, project);
            Set<VirtualFile> packageJsonFiles = PackageJsonFileManager.getInstance(project).getValidPackageJsonFiles();
            HashSet<VirtualFile> packageJsonWithInheritedDependency = new HashSet<VirtualFile>();
            for (VirtualFile packageJson : packageJsonFiles) {
                YarnPnpNodePackage yarnPnpNodePackage;
                PackageJsonData data2 = PackageJsonData.getOrCreate(packageJson);
                if (!NodePackageDescriptor.isPackageAndDependencyDeclared(data2, packageName, dependencyName)) continue;
                VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson);
                int countBefore = modules.size();
                if (nodeModulesDir != null) {
                    NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, nodeModulesDir, ModuleType.NODE_MODULES_DIR, packageName);
                }
                if (modules.size() == countBefore) {
                    VirtualFile parentPackageJson;
                    VirtualFile parent = packageJson.getParent();
                    if (parent != null) {
                        parent = parent.getParent();
                    }
                    if (parent != null && (parentPackageJson = PackageJsonUtil.findUpPackageJson(parent)) != null) {
                        packageJsonWithInheritedDependency.add(parentPackageJson);
                    }
                }
                if ((yarnPnpNodePackage = YarnPnpNodePackage.create(project, packageJson, packageName, true, false)) == null) continue;
                packages.add(new NodePackageAndPackageJson(yarnPnpNodePackage, packageJson));
            }
            for (CompletionModuleInfo module : modules) {
                PackageJsonData data3;
                VirtualFile dir = module.getVirtualFile();
                if (dir == null || !dir.isDirectory()) continue;
                VirtualFile nodeModulesDir = NodePackageDescriptor.findNodeModulesByPackageDir(dir);
                VirtualFile packageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir);
                boolean ok = directDependenciesInsideProject && JSLibraryUtil.getContentRootForFile(project, dir) != null && packageJson != null ? NodePackageDescriptor.isPackageAndDependencyDeclared(data3 = PackageJsonData.getOrCreate(packageJson), packageName, dependencyName) || packageJsonWithInheritedDependency.contains(packageJson) : NodePackageDescriptor.hasSiblingPackageInstalled(dir, dependencyName);
                if (!ok) continue;
                NodePackage pkg = packageProducer.create(dir.getPath());
                packages.add(new NodePackageAndPackageJson(pkg, packageJson));
            }
        }
        List<Path> packageDirs = NodePackageDescriptor.findGloballyInstalledPackages(project, packageName, interpreter2);
        for (Path dir : packageDirs) {
            if (dir == null || !Files.isDirectory(dir, new LinkOption[0]) || !NodePackageDescriptor.hasSiblingPackageInstalled(dir, dependencyName)) continue;
            NodePackage pkg = packageProducer.create(dir.toString());
            globalPackages.add(pkg);
        }
    }

    @NotNull
    public static List<Path> findGloballyInstalledPackages(@Nullable Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter2) {
        Path packageDir;
        Path configDir;
        Path packageDir2;
        NodePackageRef npmRef;
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(30);
        }
        if (interpreter2 == null) {
            List<Path> list = Collections.emptyList();
            if (list == null) {
                NodePackageDescriptor.$$$reportNull$$$0(31);
            }
            return list;
        }
        ArrayList globalModules = new ArrayList();
        NodeModuleSearchUtil.findGloballyInstalledModules(globalModules, packageName, interpreter2);
        ArrayList<Path> dirs = new ArrayList<Path>();
        NodePackageRef nodePackageRef = npmRef = project != null ? NpmManager.getInstance(project).getPackageRef() : null;
        if ((npmRef != null && NpmUtil.isPnpmPackageRef(npmRef) || "pnpm".equals(packageName)) && (packageDir2 = NodePackageDescriptor.getPnpmGlobalInstallation(packageName, interpreter2)) != null) {
            dirs.add(packageDir2);
        }
        dirs.addAll(ContainerUtil.mapNotNull(globalModules, info -> {
            VirtualFile file = info.getVirtualFile();
            return file != null ? file.toNioPath() : null;
        }));
        if (npmRef != null && NpmUtil.isYarnAlikePackageRef(npmRef) && (configDir = NodePackageDescriptor.getYarnGlobalNodeModules()) != null && Files.isDirectory(packageDir = configDir.resolve(packageName), new LinkOption[0])) {
            dirs.add(packageDir);
        }
        ArrayList<Path> arrayList = dirs;
        if (arrayList == null) {
            NodePackageDescriptor.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @Nullable
    private static Path getPnpmGlobalInstallation(@NotNull String packageName, @Nullable NodeJsInterpreter interpreter2) {
        NodeJsLocalInterpreter localInterpreter;
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(33);
        }
        if ((localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter2)) == null) {
            return null;
        }
        String configPrefix = localInterpreter.getConfigPrefix();
        if (configPrefix == null) {
            return null;
        }
        Path pnpmGlobalDir = Paths.get(configPrefix, "pnpm-global");
        if (Files.isDirectory(pnpmGlobalDir, new LinkOption[0])) {
            return NodePackageDescriptor.findPnpmGlobalPackage(localInterpreter, packageName, pnpmGlobalDir);
        }
        return null;
    }

    @Nullable
    private static Path findPnpmGlobalPackage(@NotNull NodeJsLocalInterpreter interpreter2, @NotNull String packageName, @NotNull Path pnpmGlobalDir) {
        Path path2;
        block13: {
            if (interpreter2 == null) {
                NodePackageDescriptor.$$$reportNull$$$0(34);
            }
            if (packageName == null) {
                NodePackageDescriptor.$$$reportNull$$$0(35);
            }
            if (pnpmGlobalDir == null) {
                NodePackageDescriptor.$$$reportNull$$$0(36);
            }
            if ("pnpm".equals(packageName)) {
                Path result2;
                String layoutVersion = NodePackageDescriptor.findLayoutVersion(packageName, interpreter2);
                if (layoutVersion != null && Files.isDirectory(result2 = pnpmGlobalDir.resolve(layoutVersion + File.separator + "node_modules" + File.separator + packageName), new LinkOption[0])) {
                    return result2;
                }
                return null;
            }
            Stream<Path> files = Files.list(pnpmGlobalDir);
            try {
                path2 = files.map(layoutVersionDir -> {
                    Path result2 = layoutVersionDir.resolve("node_modules" + File.separatorChar + packageName);
                    return Files.isDirectory(result2, new LinkOption[0]) ? result2 : null;
                }).filter(Objects::nonNull).findFirst().orElse(null);
                if (files == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    return null;
                }
            }
            files.close();
        }
        return path2;
    }

    @Nullable
    private static String findLayoutVersion(@NotNull String binaryName, @NotNull NodeJsLocalInterpreter interpreter2) {
        Path binDir;
        Path pnpmBinary;
        if (binaryName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(37);
        }
        if (interpreter2 == null) {
            NodePackageDescriptor.$$$reportNull$$$0(38);
        }
        if (Files.isRegularFile(pnpmBinary = (binDir = Paths.get(PathUtil.getParentPath((String)interpreter2.getInterpreterSystemDependentPath()), new String[0])).resolve(binaryName), new LinkOption[0])) {
            try {
                String text = FileUtil.toSystemIndependentName((String)Files.readString(pnpmBinary));
                Pattern pattern = Pattern.compile("/pnpm-global/([^/]+)/node_modules/");
                Matcher matcher = pattern.matcher(text);
                if (matcher.find()) {
                    return matcher.group(1);
                }
            }
            catch (IOException e) {
                LOG.info("Cannot read " + String.valueOf(pnpmBinary), (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    private static Path getYarnGlobalNodeModules() {
        String userHome = SystemProperties.getUserHome();
        if (StringUtil.isNotEmpty((String)userHome)) {
            return Path.of(userHome, ".config/yarn/global/node_modules");
        }
        return null;
    }

    private static boolean isPackageAndDependencyDeclared(@NotNull PackageJsonData data2, @NotNull String packageName, @Nullable String dependencyName) {
        if (data2 == null) {
            NodePackageDescriptor.$$$reportNull$$$0(39);
        }
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(40);
        }
        return data2.isDependencyOfAnyType(packageName) && (dependencyName == null || data2.isDependencyOfAnyType(dependencyName));
    }

    private static boolean hasSiblingPackageInstalled(@NotNull VirtualFile packageDir, @Nullable String siblingPackageName) {
        if (packageDir == null) {
            NodePackageDescriptor.$$$reportNull$$$0(41);
        }
        if (siblingPackageName == null) {
            return true;
        }
        VirtualFile nodeModulesDir = NodePackageDescriptor.findNodeModulesByPackageDir(packageDir);
        return nodeModulesDir != null && nodeModulesDir.findFileByRelativePath(siblingPackageName) != null;
    }

    private static boolean hasSiblingPackageInstalled(@NotNull Path packageDir, @Nullable String siblingPackageName) {
        String nodeModulesStr;
        if (packageDir == null) {
            NodePackageDescriptor.$$$reportNull$$$0(42);
        }
        if (siblingPackageName == null) {
            return true;
        }
        String path2 = FileUtil.toSystemIndependentName((String)packageDir.toAbsolutePath().toString());
        int i = path2.lastIndexOf(nodeModulesStr = "/node_modules/");
        if (i < 0) {
            return false;
        }
        Path absoluteSiblingPath = Path.of(path2.substring(0, i) + nodeModulesStr + siblingPackageName, new String[0]);
        return Files.isDirectory(absoluteSiblingPath, new LinkOption[0]);
    }

    @Nullable
    private static VirtualFile findNodeModulesByPackageDir(@NotNull VirtualFile dir) {
        VirtualFile parent;
        if (dir == null) {
            NodePackageDescriptor.$$$reportNull$$$0(43);
        }
        if ((parent = dir.getParent()) == null) {
            return null;
        }
        CharSequence parentName = parent.getNameSequence();
        if (parent.isDirectory() && StringUtil.equals((CharSequence)"node_modules", (CharSequence)dir.getNameSequence())) {
            return parent;
        }
        if (NodeModuleSearchUtil.isScopeDirName(parentName)) {
            parent = parent.getParent();
        }
        return parent;
    }

    @NotNull
    public FileChooserDescriptor createFileChooserDescriptor() {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withShowHiddenFiles(SystemInfo.isUnix);
        if (this.getPackageNames().size() == 1) {
            descriptor.withTitle(JavaScriptBundle.message("node.package.selector.single.package.title", this.getPackageNames().get(0)));
        } else {
            descriptor.withTitle(JavaScriptBundle.message("node.package.selector.multiple.packages.title", new Object[0]));
            String text = this.getHintText();
            if (text != null) {
                descriptor.withDescription(JavaScriptBundle.message("node.package.selector.multiple.packages.description", text));
            }
        }
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            NodePackageDescriptor.$$$reportNull$$$0(44);
        }
        return fileChooserDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 11, 14, 16, 18, 20, 22, 31, 32, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyByPackageMap";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 31: 
            case 32: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageDescriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalPackages";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageProducer";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pnpmGlobalDir";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryName";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageRef";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "dereferenceIfProjectRef";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findFirstDirectDependencyPackage";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "listPackageRefs";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "listAvailable";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "findGloballyInstalledPackages";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileChooserDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 31: 
            case 32: 
            case 44: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyByPackageName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPackage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPackageRef";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "dereferenceIfProjectRef";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findFirstDirectDependencyPackage";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "listPackageRefs";
                break;
            }
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "listAvailable";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findUnambiguousDependencyPackage";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findGloballyInstalledPackages";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPnpmGlobalInstallation";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findPnpmGlobalPackage";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findLayoutVersion";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isPackageAndDependencyDeclared";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "hasSiblingPackageInstalled";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findNodeModulesByPackageDir";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 11, 14, 16, 18, 20, 22, 31, 32, 44 -> new IllegalStateException(string);
        };
    }

    private static final class NodePackageAndPackageJson {
        private final NodePackage myPackage;
        private final VirtualFile myPackageJson;

        private NodePackageAndPackageJson(@NotNull NodePackage pkg, @Nullable VirtualFile packageJson) {
            if (pkg == null) {
                NodePackageAndPackageJson.$$$reportNull$$$0(0);
            }
            this.myPackage = pkg;
            this.myPackageJson = packageJson;
        }

        @NotNull
        private NodePackage getPackage() {
            NodePackage nodePackage = this.myPackage;
            if (nodePackage == null) {
                NodePackageAndPackageJson.$$$reportNull$$$0(1);
            }
            return nodePackage;
        }

        @Nullable
        private VirtualFile getPackageJson() {
            return this.myPackageJson;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodePackageAndPackageJson json = (NodePackageAndPackageJson)o;
            return this.myPackage.equals(json.myPackage);
        }

        public int hashCode() {
            return this.myPackage.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pkg";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageDescriptor$NodePackageAndPackageJson";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageDescriptor$NodePackageAndPackageJson";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPackage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static interface NodePackageProducer {
        @NotNull
        public NodePackage create(@NotNull String var1);
    }
}

