/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept '____queue_work' function
 *
 * Notes:
 *  - Enforce Exploit Detection CFI
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 20.XI.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../../p_lkrg_main.h"


char p_pcfi___queue_work_kretprobe_state = 0;

static struct kretprobe p_pcfi___queue_work_kretprobe = {
    .kp.symbol_name = "__queue_work",
    .handler = p_pcfi___queue_work_ret,
    .entry_handler = p_pcfi___queue_work_entry,
    .data_size = sizeof(struct p_pcfi___queue_work_data),
};

/*
 * x86-64 syscall ABI:
 *  *rax - syscall_number
 *    rdi - 1st argument
 *    rsi - 2nd argument
 *    rdx - 3rd argument
 *    rcx - 4th argument
 *
 *    r8  - 5th one
 *    r9  - 6th one
 */

int p_pcfi___queue_work_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

   unsigned long p_flags;

   p_ed_pcfi_cpu(0);

   if (p_is_ed_task(current)) {
      /* Do not take ED lock */
      if (p_tasks_read_trylock(&p_flags)) {
         p_ed_validate_current();
         p_tasks_read_unlock(&p_flags);
      }
   }

   return 0;
}


int p_pcfi___queue_work_ret(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

//   p_ed_enforce_validation();

   return 0;
}


GENERATE_INSTALL_FUNC(pcfi___queue_work)
