# @HEADER
# ************************************************************************
#
#            Trilinos: An Object-Oriented Solver Framework
#                 Copyright (2001) Sandia Corporation
#
#
# Copyright (2001) Sandia Corporation. Under the terms of Contract
# DE-AC04-94AL85000, there is a non-exclusive license for use of this
# work by or on behalf of the U.S. Government.  Export of this program
# may require a license from the United States Government.
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the Corporation nor the names of the
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# NOTICE:  The United States Government is granted for itself and others
# acting on its behalf a paid-up, nonexclusive, irrevocable worldwide
# license in this data to reproduce, prepare derivative works, and
# perform publicly and display publicly.  Beginning five (5) years from
# July 25, 2001, the United States Government is granted for itself and
# others acting on its behalf a paid-up, nonexclusive, irrevocable
# worldwide license in this data to reproduce, prepare derivative works,
# distribute copies to the public, perform publicly and display
# publicly, and to permit others to do so.
#
# NEITHER THE UNITED STATES GOVERNMENT, NOR THE UNITED STATES DEPARTMENT
# OF ENERGY, NOR SANDIA CORPORATION, NOR ANY OF THEIR EMPLOYEES, MAKES
# ANY WARRANTY, EXPRESS OR IMPLIED, OR ASSUMES ANY LEGAL LIABILITY OR
# RESPONSIBILITY FOR THE ACCURACY, COMPLETENESS, OR USEFULNESS OF ANY
# INFORMATION, APPARATUS, PRODUCT, OR PROCESS DISCLOSED, OR REPRESENTS
# THAT ITS USE WOULD NOT INFRINGE PRIVATELY OWNED RIGHTS.
#
# ************************************************************************
# @HEADER


set(REQUIRED_LIBS_NAMES "blas blas_win32")

#
# Second, search for BLAS components (if allowed) using the standard
# find_package(BLAS ...).
#
tribits_tpl_allow_pre_find_package(BLAS  BLAS_ALLOW_PREFIND)
if (BLAS_ALLOW_PREFIND)

  message("-- Using find_package(BLAS ...) ...")

  find_package(BLAS)

  if (BLAS_FOUND)
    # Tell TriBITS that we found BLAS and there no need to look any further!
    set(TPL_BLAS_INCLUDE_DIRS "" CACHE PATH
      "BLAS include dirs")
    set(TPL_BLAS_LIBRARIES ${BLAS_LIBRARIES} CACHE FILEPATH
      "BLAS libraries")
    set(TPL_BLAS_LIBRARY_DIRS "" CACHE PATH
      "BLAS library dirs")
  endif()

endif()

if (MSVC AND NOT
    (BLAS_LIBRARY_DIRS  OR
     (NOT "${BLAS_LIBRARY_NAMES}" STREQUAL "blas blas_win32" AND
      NOT "${BLAS_LIBRARY_NAMES}" STREQUAL "") OR
     BLAS_INCLUDE_DIRS  OR
     BLAS_INCLUDE_NAMES OR
     (NOT "${TPL_BLAS_LIBRARIES}" STREQUAL "blas" AND
      NOT "${TPL_BLAS_LIBRARIES}" STREQUAL "") OR
     TPL_BLAS_INCLUDE_DIRS)
   )
  # Find the CLAPACK built by CMake on the machine for MSVC if found it will
  # set the BLAS and LAPACK libraries.  NOTE: This the FindCLAPACK module must
  # be called every configure or this does not work!
  # If the user has specified alternate name or location of their blas that
  # will be used instead.
  find_package(CLAPACK 3.2.1 NO_MODULE)
  if (CLAPACK_FOUND)
    advanced_set(TPL_BLAS_LIBRARIES blas
      CACHE FILEPATH "Set from MSVC CLAPACK specialization")
  endif()
endif()
#
# Third, call tribits_tpl_find_include_dirs_and_libraries()
#
tribits_tpl_find_include_dirs_and_libraries( BLAS
  REQUIRED_LIBS_NAMES ${REQUIRED_LIBS_NAMES}
  )
# NOTE: If find_package(BLAS ...) was called and successfully found BLAS, then
# tribits_tpl_find_include_dirs_and_libraries() will use the already-set
# variables TPL_BLAS_INCLUDE_DIRS and TPL_BLAS_LIBRARIES and then print them
