/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.http.proxy;

import com.intellij.credentialStore.Credentials;
import com.intellij.jupyter.core.jupyter.connections.http.proxy.ProxySettings;
import com.intellij.jupyter.core.jupyter.connections.http.proxy.ProxyType;
import com.intellij.util.net.HttpConfigurable;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a8\u0006\t"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/http/proxy/JupyterSystemProxy;", "", "<init>", "()V", "getIdeaProxySettings", "Lcom/intellij/jupyter/core/jupyter/connections/http/proxy/ProxySettings;", "uri", "Ljava/net/URI;", "Lorg/intellij/markdown/html/URI;", "intellij.jupyter.core"})
public final class JupyterSystemProxy {
    @NotNull
    public static final JupyterSystemProxy INSTANCE = new JupyterSystemProxy();

    private JupyterSystemProxy() {
    }

    @Nullable
    public final ProxySettings getIdeaProxySettings(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
        if (!httpConfigurable.isHttpProxyEnabledForUrl(uri.toString())) {
            return null;
        }
        String ignoreHosts = httpConfigurable.PROXY_EXCEPTIONS;
        ProxyType proxyType = httpConfigurable.PROXY_TYPE_IS_SOCKS ? ProxyType.SOCKS : ProxyType.HTTP;
        Credentials credentials = new Credentials(httpConfigurable.getProxyLogin(), httpConfigurable.getPlainProxyPassword());
        String string = httpConfigurable.PROXY_HOST;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PROXY_HOST");
        return new ProxySettings(proxyType, ((Object)StringsKt.trim((CharSequence)string)).toString(), httpConfigurable.PROXY_PORT, credentials, ignoreHosts);
    }
}

