/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputSettings;", "", "<init>", "()V", "ENABLED_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "globallyEnabled", "getGloballyEnabled", "()Z", "disableInputCellsForEditor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "inputCellsEnabled", "intellij.jupyter.core"})
public final class JupyterDataInputSettings {
    @NotNull
    public static final JupyterDataInputSettings INSTANCE = new JupyterDataInputSettings();
    @NotNull
    private static final Key<Boolean> ENABLED_KEY;

    private JupyterDataInputSettings() {
    }

    private final boolean getGloballyEnabled() {
        return Registry.Companion.is("jupyter.core.data.input.cell.enabled", true);
    }

    public final void disableInputCellsForEditor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        editor.putUserData(ENABLED_KEY, (Object)false);
    }

    public final boolean inputCellsEnabled(@Nullable Editor editor) {
        return PlatformUtils.isDataSpell() && this.getGloballyEnabled() && editor != null && !Intrinsics.areEqual((Object)editor.getUserData(ENABLED_KEY), (Object)false);
    }

    static {
        Key key = Key.create((String)"INPUT_CELLS_ENABLED");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ENABLED_KEY = key;
    }
}

