/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.profilers.async.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.profiler.ProfilerDumpPanel;
import com.intellij.profiler.actions.ImportProfilerResultAction;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.profilers.SnapshotOpener;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InternalProfilerSnapshotOpener
implements SnapshotOpener {
    InternalProfilerSnapshotOpener() {
    }

    public boolean canOpen(@NotNull File snapshot, @Nullable Project project) {
        if (snapshot == null) {
            InternalProfilerSnapshotOpener.$$$reportNull$$$0(0);
        }
        if (project == null) {
            return false;
        }
        String name = snapshot.getName();
        return name.endsWith(".hprof") || name.endsWith(".jfr");
    }

    public String getPresentableName() {
        return PerformanceTestingBundle.message((String)"profiling.capture.snapshot.action.open", (Object[])new Object[0]);
    }

    public void open(@NotNull File file, @Nullable Project project) {
        if (file == null) {
            InternalProfilerSnapshotOpener.$$$reportNull$$$0(1);
        }
        if (project == null) {
            Logger.getInstance(InternalProfilerSnapshotOpener.class).warn("Can not open snapshot with internal profiler because no project instance was supplied");
            return;
        }
        String tabName = file.getName();
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Profiler");
        Content content = (Content)JBIterable.of(toolWindow == null ? null : toolWindow.getContentManager().getContents()).find(o -> o.getComponent() instanceof ProfilerDumpPanel && tabName.equals(((ProfilerDumpPanel)o.getComponent()).getTabName()));
        if (toolWindow != null && content != null) {
            toolWindow.activate(() -> toolWindow.getContentManager().setSelectedContent(content, true));
        } else {
            ImportProfilerResultAction.Companion.importProfilerDump(project, file, null, null, null, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/profilers/async/core/InternalProfilerSnapshotOpener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canOpen";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "open";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

