/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui.providers.selection;

import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.openapi.Disposable;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0006J\u0014\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/intellij/notebooks/visualization/ui/providers/selection/EditorCellSelectionModel;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "_selection", "", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "selection", "", "getSelection", "()Ljava/util/List;", "dispose", "", "removeCell", "selectedCell", "replaceSelection", "cells", "", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorCellSelectionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellSelectionModel.kt\ncom/intellij/notebooks/visualization/ui/providers/selection/EditorCellSelectionModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n1053#2:36\n1863#2,2:37\n1863#2,2:39\n*S KotlinDebug\n*F\n+ 1 EditorCellSelectionModel.kt\ncom/intellij/notebooks/visualization/ui/providers/selection/EditorCellSelectionModel\n*L\n11#1:36\n26#1:37,2\n29#1:39,2\n*E\n"})
public final class EditorCellSelectionModel
implements Disposable {
    @NotNull
    private final Set<EditorCell> _selection = new LinkedHashSet();

    @NotNull
    public final List<EditorCell> getSelection() {
        Iterable $this$sortedBy$iv = this._selection;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                EditorCell it = (EditorCell)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getInterval().getOrdinal());
                it = (EditorCell)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getInterval().getOrdinal()));
            }
        });
    }

    public void dispose() {
        this._selection.clear();
    }

    public final void removeCell(@NotNull EditorCell selectedCell) {
        Intrinsics.checkNotNullParameter((Object)selectedCell, (String)"selectedCell");
        this._selection.remove(selectedCell);
        selectedCell.isSelected().set(false);
    }

    public final void replaceSelection(@NotNull Collection<EditorCell> cells) {
        EditorCell it;
        Intrinsics.checkNotNullParameter(cells, (String)"cells");
        Set selectionSet = CollectionsKt.toSet((Iterable)cells);
        Set toRemove = SetsKt.minus(this._selection, (Iterable)selectionSet);
        Set toAdd = SetsKt.minus((Set)selectionSet, (Iterable)this._selection);
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (EditorCell)element$iv;
            boolean bl = false;
            it.isSelected().set(false);
        }
        $this$forEach$iv = toAdd;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (EditorCell)element$iv;
            boolean bl = false;
            it.isSelected().set(true);
        }
        this._selection.removeAll(toRemove);
        this._selection.addAll(toAdd);
    }
}

