/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.session;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.session.ShellCommandOutputScraperImplKt;
import org.jetbrains.plugins.terminal.block.session.scraper.CommandEndMarkerListeningStringCollector;
import org.jetbrains.plugins.terminal.block.session.scraper.SimpleStringCollector;
import org.jetbrains.plugins.terminal.block.session.scraper.SimpleTerminalLinesCollector;
import org.jetbrains.plugins.terminal.block.session.scraper.StringCollector;
import org.jetbrains.plugins.terminal.util.TerminalUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandEndMarkerListener;", "", "terminalTextBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "commandEndMarker", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "onFound", "Lkotlin/Function0;", "", "<init>", "(Lcom/jediterm/terminal/model/TerminalTextBuffer;Ljava/lang/String;Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function0;)V", "disposable", "found", "Ljava/util/concurrent/atomic/AtomicBoolean;", "findCommandEndMarker", "", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nShellCommandEndMarkerListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandEndMarkerListener.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandEndMarkerListener\n+ 2 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtilsKt\n*L\n1#1,50:1\n515#2,7:51\n*S KotlinDebug\n*F\n+ 1 ShellCommandEndMarkerListener.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandEndMarkerListener\n*L\n35#1:51,7\n*E\n"})
public final class ShellCommandEndMarkerListener {
    @NotNull
    private final TerminalTextBuffer terminalTextBuffer;
    @Nullable
    private final String commandEndMarker;
    @NotNull
    private final Function0<Unit> onFound;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final AtomicBoolean found;

    public ShellCommandEndMarkerListener(@NotNull TerminalTextBuffer terminalTextBuffer, @Nullable String commandEndMarker, @NotNull Disposable parentDisposable, @NotNull Function0<Unit> onFound) {
        Intrinsics.checkNotNullParameter((Object)terminalTextBuffer, (String)"terminalTextBuffer");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(onFound, (String)"onFound");
        this.terminalTextBuffer = terminalTextBuffer;
        this.commandEndMarker = commandEndMarker;
        this.onFound = onFound;
        Disposable disposable = Disposer.newDisposable((Disposable)parentDisposable, (String)ShellCommandEndMarkerListener.class.getSimpleName());
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.found = new AtomicBoolean(false);
        if (!this.findCommandEndMarker()) {
            TerminalUtilKt.addModelListener(this.terminalTextBuffer, this.disposable, () -> ShellCommandEndMarkerListener._init_$lambda$0(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean findCommandEndMarker() {
        Ref.BooleanRef commandEndMarkerFound = new Ref.BooleanRef();
        TerminalTextBuffer $this$withLock$iv = this.terminalTextBuffer;
        boolean $i$f$withLock = false;
        $this$withLock$iv.lock();
        try {
            TerminalTextBuffer it = $this$withLock$iv;
            boolean bl = false;
            StringCollector stringCollector = new CommandEndMarkerListeningStringCollector(new SimpleStringCollector(), this.commandEndMarker, (Function0<Unit>)((Function0)() -> ShellCommandEndMarkerListener.findCommandEndMarker$lambda$2$lambda$1(commandEndMarkerFound)));
            ShellCommandOutputScraperImplKt.collectLines$default(this.terminalTextBuffer, new SimpleTerminalLinesCollector(stringCollector), 0, 2, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withLock$iv.unlock();
        }
        if (commandEndMarkerFound.element && this.found.compareAndSet(false, true)) {
            Disposer.dispose((Disposable)this.disposable);
            this.onFound.invoke();
            return true;
        }
        return false;
    }

    private static final void _init_$lambda$0(ShellCommandEndMarkerListener this$0) {
        this$0.findCommandEndMarker();
    }

    private static final Unit findCommandEndMarker$lambda$2$lambda$1(Ref.BooleanRef $commandEndMarkerFound) {
        $commandEndMarkerFound.element = true;
        return Unit.INSTANCE;
    }
}

