/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgPromptCommandExecutor;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgUpdateCommand {
    private final Project project;
    private final VirtualFile repo;
    @NonNls
    private String revision;
    private boolean clean;

    public HgUpdateCommand(@NotNull Project project, @NotNull VirtualFile repo) {
        if (project == null) {
            HgUpdateCommand.$$$reportNull$$$0(0);
        }
        if (repo == null) {
            HgUpdateCommand.$$$reportNull$$$0(1);
        }
        this.project = project;
        this.repo = repo;
    }

    public void setRevision(@NonNls String revision) {
        this.revision = revision;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    @Nullable
    public HgCommandResult execute() {
        HgCommandResult result;
        LinkedList<String> arguments = new LinkedList<String>();
        if (this.clean) {
            arguments.add("--clean");
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.revision)) {
            arguments.add("--rev");
            arguments.add(this.revision);
        }
        HgPromptCommandExecutor executor = new HgPromptCommandExecutor(this.project);
        executor.setShowOutput(true);
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.project, (String)HgBundle.message("activity.name.update", new Object[0]));){
            String message;
            result = executor.executeInCurrentThread(this.repo, "update", arguments);
            if (!this.clean && HgErrorUtil.hasUncommittedChangesConflict(result) && HgUpdateCommand.showDiscardChangesConfirmation(this.project, message = XmlStringUtil.wrapInHtml((CharSequence)HgBundle.message("hg4idea.update.unable.to.merge", new Object[0]))) == 0) {
                arguments.add("-C");
                result = executor.executeInCurrentThread(this.repo, "update", arguments);
            }
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{this.repo});
        return result;
    }

    public static int showDiscardChangesConfirmation(@NotNull Project project, @NotNull @NlsContexts.DialogTitle String confirmationMessage) {
        if (project == null) {
            HgUpdateCommand.$$$reportNull$$$0(2);
        }
        if (confirmationMessage == null) {
            HgUpdateCommand.$$$reportNull$$$0(3);
        }
        AtomicInteger exitCode = new AtomicInteger();
        UIUtil.invokeAndWaitIfNeeded(() -> exitCode.set(Messages.showOkCancelDialog((Project)project, (String)confirmationMessage, (String)HgBundle.message("hg4idea.update.uncommitted.problem", new Object[0]), (String)HgBundle.message("changes.discard", new Object[0]), (String)CommonBundle.message((String)"button.cancel.c", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())));
        return exitCode.get();
    }

    public static void updateTo(@NotNull @NonNls String targetRevision, @NotNull List<? extends HgRepository> repos, @Nullable Runnable callInAwtLater) {
        if (targetRevision == null) {
            HgUpdateCommand.$$$reportNull$$$0(4);
        }
        if (repos == null) {
            HgUpdateCommand.$$$reportNull$$$0(5);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        for (HgRepository hgRepository : repos) {
            VirtualFile repository = hgRepository.getRoot();
            Project project = hgRepository.getProject();
            HgUpdateCommand.updateRepoTo(project, repository, targetRevision, callInAwtLater);
        }
    }

    public static void updateRepoTo(@NotNull Project project, @NotNull VirtualFile repository, @NotNull @NonNls String targetRevision, @Nullable Runnable callInAwtLater) {
        if (project == null) {
            HgUpdateCommand.$$$reportNull$$$0(6);
        }
        if (repository == null) {
            HgUpdateCommand.$$$reportNull$$$0(7);
        }
        if (targetRevision == null) {
            HgUpdateCommand.$$$reportNull$$$0(8);
        }
        HgUpdateCommand.updateRepoTo(project, repository, targetRevision, false, callInAwtLater);
    }

    public static void updateRepoTo(final @NotNull Project project, final @NotNull VirtualFile repository, final @NotNull @NonNls String targetRevision, final boolean clean, final @Nullable Runnable callInAwtLater) {
        if (project == null) {
            HgUpdateCommand.$$$reportNull$$$0(9);
        }
        if (repository == null) {
            HgUpdateCommand.$$$reportNull$$$0(10);
        }
        if (targetRevision == null) {
            HgUpdateCommand.$$$reportNull$$$0(11);
        }
        new Task.Backgroundable(project, HgBundle.message("action.hg4idea.updateTo.description", new Object[0])){

            public void onSuccess() {
                if (callInAwtLater != null) {
                    callInAwtLater.run();
                }
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                HgUpdateCommand.updateRepoToInCurrentThread(project, repository, targetRevision, clean);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/command/HgUpdateCommand$1", "run"));
            }
        }.queue();
    }

    public static boolean updateRepoToInCurrentThread(@NotNull Project project, @NotNull VirtualFile repository, @NotNull @NonNls String targetRevision, boolean clean) {
        if (project == null) {
            HgUpdateCommand.$$$reportNull$$$0(12);
        }
        if (repository == null) {
            HgUpdateCommand.$$$reportNull$$$0(13);
        }
        if (targetRevision == null) {
            HgUpdateCommand.$$$reportNull$$$0(14);
        }
        HgUpdateCommand hgUpdateCommand = new HgUpdateCommand(project, repository);
        hgUpdateCommand.setRevision(targetRevision);
        hgUpdateCommand.setClean(clean);
        HgCommandResult result = hgUpdateCommand.execute();
        new HgConflictResolver(project).resolve(repository);
        boolean success = !HgErrorUtil.isCommandExecutionFailed(result);
        boolean hasUnresolvedConflicts = HgConflictResolver.hasConflicts(project, repository);
        if (!success) {
            new HgCommandResultNotifier(project).notifyError("hg.update.error", result, "", HgBundle.message("hg4idea.update.failed", new Object[0]));
        } else if (hasUnresolvedConflicts) {
            new VcsNotifier(project).notifyImportantWarning("hg.update.unresolved.conflicts.error", HgBundle.message("hg4idea.update.unresolved.conflicts", new Object[0]), HgBundle.message("hg4idea.update.warning.merge.conflicts", repository.getPath()));
        }
        HgUtil.getRepositoryManager(project).updateRepository(repository);
        HgUtil.markDirectoryDirty(project, repository);
        return success;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmationMessage";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRevision";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repos";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
        }
        objectArray2[1] = "org/zmlx/hg4idea/command/HgUpdateCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showDiscardChangesConfirmation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateTo";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "updateRepoTo";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "updateRepoToInCurrentThread";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

