/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.fixture;

import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.core.MouseClickInfo;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.fixture.JPopupMenuFixture;
import org.assertj.swing.fixture.JTreeFixture;
import org.assertj.swing.fixture.JTreeNodeFixture;

public class JTreePathFixture
implements JTreeNodeFixture<JTreePathFixture> {
    private final JTreeFixture tree;
    private final String path;

    protected JTreePathFixture(@Nonnull JTreeFixture tree, @Nonnull String path) {
        this.tree = tree;
        this.path = path;
    }

    @Override
    @Nonnull
    public JTreePathFixture expand() {
        this.tree.expandPath(this.path());
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture collapse() {
        this.tree.collapsePath(this.path());
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture select() {
        this.tree.selectPath(this.path());
        return this;
    }

    @Nonnull
    public JTreePathFixture unselect() {
        this.tree.unselectPath(this.path());
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture click() {
        this.tree.clickPath(this.path());
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture click(@Nonnull MouseButton button2) {
        this.tree.clickPath(this.path(), button2);
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture click(@Nonnull MouseClickInfo mouseClickInfo) {
        this.tree.clickPath(this.path(), mouseClickInfo);
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture doubleClick() {
        this.tree.doubleClickPath(this.path());
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture rightClick() {
        this.tree.rightClickPath(this.path());
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture drag() {
        this.tree.drag(this.path());
        return this;
    }

    @Override
    @Nonnull
    public JTreePathFixture drop() {
        this.tree.drop(this.path());
        return this;
    }

    @Override
    @Nonnull
    public JPopupMenuFixture showPopupMenu() {
        return this.tree.showPopupMenuAt(this.path());
    }

    @Override
    @Nullable
    public String value() {
        return this.tree.valueAt(this.path());
    }

    @Nonnull
    public String path() {
        return this.path;
    }

    @Nonnull
    @VisibleForTesting
    JTreeFixture treeFixture() {
        return this.tree;
    }
}

