/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.references;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.HintedPsiElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import java.util.List;
import org.intellij.plugins.intelliLang.references.InjectedReferencesContributor;
import org.jetbrains.annotations.NotNull;

public final class InjectedReferencesInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            InjectedReferencesInspection.$$$reportNull$$$0(0);
        }
        return new InjectedReferencesVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/plugins/intelliLang/references/InjectedReferencesInspection", "buildVisitor"));
    }

    private static class InjectedReferencesVisitor
    extends PsiElementVisitor
    implements HintedPsiElementVisitor {
        private final ProblemsHolder myHolder;

        private InjectedReferencesVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @NotNull
        public List<Class<?>> getHintPsiElements() {
            List<Class<?>> list = List.of(PsiLanguageInjectionHost.class, ContributedReferenceHost.class);
            if (list == null) {
                InjectedReferencesVisitor.$$$reportNull$$$0(0);
            }
            return list;
        }

        public void visitElement(@NotNull PsiElement element) {
            PsiReference[] injected;
            if (element == null) {
                InjectedReferencesVisitor.$$$reportNull$$$0(1);
            }
            if ((injected = InjectedReferencesContributor.getInjectedReferences(element)) != null) {
                for (PsiReference reference : injected) {
                    if (!InjectedReferencesVisitor.isUnresolved(reference)) continue;
                    TextRange range = reference.getRangeInElement();
                    if (range.isEmpty() && range.getStartOffset() == 1 && "\"\"".equals(element.getText())) {
                        String message = ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference);
                        this.myHolder.registerProblem(element, message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, TextRange.create((int)0, (int)2), new LocalQuickFix[0]);
                        continue;
                    }
                    this.myHolder.registerProblem(reference);
                }
            }
            super.visitElement(element);
        }

        private static boolean isUnresolved(PsiReference reference) {
            if (reference instanceof PsiPolyVariantReference) {
                PsiPolyVariantReference polyVariantReference = (PsiPolyVariantReference)reference;
                return polyVariantReference.multiResolve(false).length == 0;
            }
            return reference.resolve() == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/intelliLang/references/InjectedReferencesInspection$InjectedReferencesVisitor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHintPsiElements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/intelliLang/references/InjectedReferencesInspection$InjectedReferencesVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitElement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

