/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.py.debugger.JupyterCellSourcePosition;
import com.intellij.jupyter.py.debugger.JupyterDebugProcess;
import com.intellij.jupyter.py.editor.JupyterFileUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.DigestUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0007\u0018\u0000 +2\u00020\u0001:\u0001+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u000bJ\u001e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019H\u0002J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u001b\u001a\u00060\u0007j\u0002`\bJ\u0012\u0010\u001c\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u001d\u001a\u00020\u0006J\u0012\u0010\u001e\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u001f\u001a\u00020\u000bJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0007J\u000e\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0007J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\u0014\u0010%\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0002J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0002J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u0007H\u0002J\b\u0010*\u001a\u00020\u000fH\u0016R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugCellIdManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "cellPositionToCellId", "", "Lcom/intellij/jupyter/py/debugger/JupyterCellSourcePosition;", "", "Lcom/intellij/jupyter/py/debugger/JupyterCellId;", "cellIdToCellPosition", "cellToCellPosition", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "indexedFiles", "", "updatePositions", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "latestExecutedCell", "updateCellToCellPositionMap", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "cells", "", "getCellPositionByCellId", "cellId", "getCellIdByPosition", "cellPosition", "getCellIdByCell", "cell", "isFileIndexed", "", "filepath", "isCellId", "updateCellIds", "generateCellId", "computeCellContentHash", "cellText", "removeCellIdentifierLines", "cleanPositionsForFile", "dispose", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterDebugCellIdManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDebugCellIdManager.kt\ncom/intellij/jupyter/py/debugger/JupyterDebugCellIdManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,154:1\n1863#2,2:155\n1863#2,2:157\n3829#3:159\n4344#3,2:160\n535#4:162\n520#4,6:163\n535#4:169\n520#4,6:170\n535#4:176\n520#4,6:177\n*S KotlinDebug\n*F\n+ 1 JupyterDebugCellIdManager.kt\ncom/intellij/jupyter/py/debugger/JupyterDebugCellIdManager\n*L\n39#1:155,2\n49#1:157,2\n108#1:159\n108#1:160,2\n112#1:162\n112#1:163,6\n113#1:169\n113#1:170,6\n114#1:176\n114#1:177,6\n*E\n"})
public final class JupyterDebugCellIdManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<JupyterCellSourcePosition, String> cellPositionToCellId = new LinkedHashMap();
    @NotNull
    private Map<String, JupyterCellSourcePosition> cellIdToCellPosition = new LinkedHashMap();
    @NotNull
    private Map<JupyterPsiCell, JupyterCellSourcePosition> cellToCellPosition = new LinkedHashMap();
    @NotNull
    private Set<String> indexedFiles = new LinkedHashSet();
    @NotNull
    private static final String DEBUG_PREFIX = "# pydev_debug_cell";
    @NotNull
    private static final Logger LOG;

    public final synchronized void updatePositions(@NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile, @Nullable JupyterPsiCell latestExecutedCell) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        VirtualFile originalFile = virtualFile.getOriginFile();
        String string = originalFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String filePath = string;
        this.cleanPositionsForFile(filePath);
        this.indexedFiles.add(filePath);
        List list = JupyterHelper.INSTANCE.getPsiCells(project, virtualFile);
        if (list == null) {
            return;
        }
        List cells = list;
        this.updateCellToCellPositionMap(originalFile, cells);
        Iterable $this$forEach$iv = cells;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterPsiCell cell = (JupyterPsiCell)element$iv;
            boolean bl = false;
            this.updateCellIds(cell);
        }
        if (latestExecutedCell != null) {
            this.updateCellIds(latestExecutedCell);
        }
    }

    public static /* synthetic */ void updatePositions$default(JupyterDebugCellIdManager jupyterDebugCellIdManager, Project project, BackedNotebookVirtualFile backedNotebookVirtualFile, JupyterPsiCell jupyterPsiCell, int n, Object object) {
        if ((n & 4) != 0) {
            jupyterPsiCell = null;
        }
        jupyterDebugCellIdManager.updatePositions(project, backedNotebookVirtualFile, jupyterPsiCell);
    }

    private final void updateCellToCellPositionMap(VirtualFile originalFile, List<? extends JupyterPsiCell> cells) {
        Iterable $this$forEach$iv = cells;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterCellSourcePosition cellPosition;
            JupyterPsiCell cell = (JupyterPsiCell)element$iv;
            boolean bl = false;
            if (JupyterFileUtilKt.getCellPositionForJupyterCell(originalFile, cell) == null) continue;
            boolean bl2 = false;
            this.cellToCellPosition.put(cell, cellPosition);
        }
    }

    @Nullable
    public final synchronized JupyterCellSourcePosition getCellPositionByCellId(@NotNull Project project, @NotNull String cellId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cellId, (String)"cellId");
        JupyterCellSourcePosition position = this.cellIdToCellPosition.get(cellId);
        if (position == null) {
            JupyterDebugProcess.Companion.showCellEditedDuringSession(project);
        }
        return position;
    }

    @NotNull
    public final synchronized String getCellIdByPosition(@NotNull JupyterCellSourcePosition cellPosition) {
        Intrinsics.checkNotNullParameter((Object)cellPosition, (String)"cellPosition");
        String string = this.cellPositionToCellId.get(cellPosition);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final synchronized String getCellIdByCell(@NotNull JupyterPsiCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        String string = this.cellPositionToCellId.get(this.cellToCellPosition.get(cell));
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final synchronized boolean isFileIndexed(@NotNull String filepath) {
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        return this.indexedFiles.contains(filepath);
    }

    public final boolean isCellId(@NotNull String filepath) {
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        return this.cellIdToCellPosition.containsKey(filepath);
    }

    private final void updateCellIds(JupyterPsiCell cell) {
        String cellId = this.generateCellId(cell);
        JupyterCellSourcePosition cellPosition = this.cellToCellPosition.get(cell);
        if (cellPosition != null) {
            this.cellPositionToCellId.put(cellPosition, cellId);
            this.cellIdToCellPosition.put(cellId, cellPosition);
        }
    }

    private final String generateCellId(JupyterPsiCell cell) {
        String cellText = Companion.extractCellTextAndRemoveFirstEmptyLine$intellij_jupyter_py(cell);
        return this.computeCellContentHash(cellText);
    }

    private final String computeCellContentHash(String cellText) {
        String filteredCellContent = this.removeCellIdentifierLines(cellText);
        byte[] byArray = filteredCellContent.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return DigestUtil.sha256Hex((byte[])byArray);
    }

    /*
     * WARNING - void declaration
     */
    private final String removeCellIdentifierLines(String cellText) {
        void $this$filterTo$iv$iv;
        String[] lines;
        String[] stringArray = StringUtil.splitByLinesKeepSeparators((String)cellText);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"splitByLinesKeepSeparators(...)");
        String[] $this$filter$iv = lines = stringArray;
        boolean $i$f$filter = false;
        String[] stringArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void text = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)text);
            if (!(!StringsKt.contains$default((CharSequence)((CharSequence)text), (CharSequence)"#%%", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    private final void cleanPositionsForFile(String filepath) {
        boolean bl;
        Map.Entry<Object, Object> it;
        Map<String, JupyterCellSourcePosition> $this$filterTo$iv$iv;
        Map<String, JupyterCellSourcePosition> $this$filter$iv;
        Map<JupyterCellSourcePosition, String> map = this.cellPositionToCellId;
        JupyterDebugCellIdManager jupyterDebugCellIdManager = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            bl = false;
            if (!(!Intrinsics.areEqual((Object)((JupyterCellSourcePosition)it.getKey()).getStart().getFile().getPath(), (Object)filepath))) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        jupyterDebugCellIdManager.cellPositionToCellId = MapsKt.toMutableMap((Map)destination$iv$iv);
        $this$filter$iv = this.cellIdToCellPosition;
        jupyterDebugCellIdManager = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        for (Map.Entry<Object, Object> entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            bl = false;
            if (!(!Intrinsics.areEqual((Object)((JupyterCellSourcePosition)it.getValue()).getStart().getFile().getPath(), (Object)filepath))) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        jupyterDebugCellIdManager.cellIdToCellPosition = MapsKt.toMutableMap((Map)destination$iv$iv);
        $this$filter$iv = this.cellToCellPosition;
        jupyterDebugCellIdManager = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        for (Map.Entry<Object, Object> entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            bl = false;
            if (!(!Intrinsics.areEqual((Object)((JupyterCellSourcePosition)it.getValue()).getStart().getFile().getPath(), (Object)filepath))) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        jupyterDebugCellIdManager.cellToCellPosition = MapsKt.toMutableMap((Map)destination$iv$iv);
    }

    public void dispose() {
        this.cellPositionToCellId.clear();
        this.cellIdToCellPosition.clear();
        this.cellToCellPosition.clear();
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fR\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugCellIdManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/py/debugger/JupyterDebugCellIdManager;", "project", "Lcom/intellij/openapi/project/Project;", "extractCellTextAndRemoveFirstEmptyLine", "", "cell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "extractCellTextAndRemoveFirstEmptyLine$intellij_jupyter_py", "DEBUG_PREFIX", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterDebugCellIdManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(JupyterDebugCellIdManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (JupyterDebugCellIdManager)object;
        }

        @NotNull
        public final String extractCellTextAndRemoveFirstEmptyLine$intellij_jupyter_py(@NotNull JupyterPsiCell cell) {
            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
            String cellText = (String)ReadAction.compute(() -> Companion.extractCellTextAndRemoveFirstEmptyLine$lambda$0(cell));
            Object[] objectArray = StringUtil.splitByLinesKeepSeparators((String)cellText);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"splitByLinesKeepSeparators(...)");
            Object[] lines = objectArray;
            if (!(lines.length == 0)) {
                String string = lines[0];
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                if (StringsKt.isBlank((CharSequence)string)) {
                    lines[0] = JupyterDebugCellIdManager.DEBUG_PREFIX + (String)lines[0];
                }
            }
            return ((Object)StringsKt.trimEnd((CharSequence)ArraysKt.joinToString$default((Object[])lines, (CharSequence)"", null, null, (int)0, null, null, (int)62, null))).toString() + "\n";
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private static final String extractCellTextAndRemoveFirstEmptyLine$lambda$0(JupyterPsiCell $cell) {
            return $cell.getSource().getText();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

