/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.viewinterop;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableInferredTarget;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidedValue;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.snapshots.SnapshotStateObserver;
import androidx.compose.ui.viewinterop.InteropContainer;
import androidx.compose.ui.viewinterop.InteropContainer_skikoKt;
import androidx.compose.ui.viewinterop.InteropViewHolder;
import androidx.compose.ui.viewinterop.ScheduledUpdatesSwapchain;
import androidx.compose.ui.viewinterop.SwingInteropContainer;
import androidx.compose.ui.viewinterop.TrackInteropPlacementModifierNode;
import java.awt.Component;
import java.awt.Container;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.ClipRectangle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B'\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0006\u0010\u001e\u001a\u00020\tJ\b\u0010\u001f\u001a\u00020\tH\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u0004\u0018\u00010\r2\n\u0010%\u001a\u00060&j\u0002`'H\u0016J!\u0010(\u001a\u00020\t2\u0011\u0010)\u001a\r\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b*H\u0087\u0002\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0014\u0010-\u001a\u00020\t2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0016\u0010/\u001a\u00020\t2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u00101\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\rH\u0016R\u001e\u0010\u000b\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00062"}, d2={"Landroidx/compose/ui/viewinterop/SwingInteropContainer;", "Landroidx/compose/ui/viewinterop/InteropContainer;", "root", "Ljava/awt/Container;", "Landroidx/compose/ui/viewinterop/InteropViewGroup;", "placeInteropAbove", "", "requestRedraw", "Lkotlin/Function0;", "", "(Ljava/awt/Container;ZLkotlin/jvm/functions/Function0;)V", "interopComponents", "", "Landroidx/compose/ui/viewinterop/InteropViewHolder;", "getRoot", "()Ljava/awt/Container;", "rootModifier", "Landroidx/compose/ui/viewinterop/TrackInteropPlacementModifierNode;", "getRootModifier", "()Landroidx/compose/ui/viewinterop/TrackInteropPlacementModifierNode;", "setRootModifier", "(Landroidx/compose/ui/viewinterop/TrackInteropPlacementModifierNode;)V", "scheduledUpdatesSwapchain", "Landroidx/compose/ui/viewinterop/ScheduledUpdatesSwapchain;", "snapshotObserver", "Landroidx/compose/runtime/snapshots/SnapshotStateObserver;", "getSnapshotObserver", "()Landroidx/compose/runtime/snapshots/SnapshotStateObserver;", "contains", "holder", "dispose", "executeScheduledUpdates", "getClipRectForComponent", "Lorg/jetbrains/skiko/ClipRectangle;", "component", "Ljava/awt/Component;", "holderOfView", "view", "", "Landroidx/compose/ui/viewinterop/InteropView;", "invoke", "content", "Landroidx/compose/runtime/Composable;", "(Lkotlin/jvm/functions/Function2;Landroidx/compose/runtime/Composer;I)V", "place", "postponingExecutingScheduledUpdates", "body", "scheduleUpdate", "action", "unplace", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSwingInteropContainer.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwingInteropContainer.desktop.kt\nandroidx/compose/ui/viewinterop/SwingInteropContainer\n+ 2 SwingInteropContainer.desktop.kt\nandroidx/compose/ui/viewinterop/ScheduledUpdatesSwapchain\n*L\n1#1,252:1\n60#2,16:253\n*S KotlinDebug\n*F\n+ 1 SwingInteropContainer.desktop.kt\nandroidx/compose/ui/viewinterop/SwingInteropContainer\n*L\n220#1:253,16\n*E\n"})
public final class SwingInteropContainer
implements InteropContainer {
    @NotNull
    private final Container root;
    private final boolean placeInteropAbove;
    @NotNull
    private Map<Container, InteropViewHolder> interopComponents;
    @Nullable
    private TrackInteropPlacementModifierNode rootModifier;
    @NotNull
    private final SnapshotStateObserver snapshotObserver;
    @NotNull
    private final ScheduledUpdatesSwapchain scheduledUpdatesSwapchain;
    public static final int $stable = 8;

    public SwingInteropContainer(@NotNull Container root, boolean placeInteropAbove, @NotNull Function0<Unit> requestRedraw) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(requestRedraw, (String)"requestRedraw");
        this.root = root;
        this.placeInteropAbove = placeInteropAbove;
        this.interopComponents = new LinkedHashMap();
        this.snapshotObserver = new SnapshotStateObserver((Function1<? super Function0<Unit>, Unit>)((Function1)snapshotObserver.1.INSTANCE));
        this.scheduledUpdatesSwapchain = new ScheduledUpdatesSwapchain(requestRedraw);
    }

    @Override
    @NotNull
    public Container getRoot() {
        return this.root;
    }

    @Override
    @Nullable
    public TrackInteropPlacementModifierNode getRootModifier() {
        return this.rootModifier;
    }

    @Override
    public void setRootModifier(@Nullable TrackInteropPlacementModifierNode trackInteropPlacementModifierNode) {
        this.rootModifier = trackInteropPlacementModifierNode;
    }

    @Override
    @NotNull
    public SnapshotStateObserver getSnapshotObserver() {
        return this.snapshotObserver;
    }

    @Override
    public boolean contains(@NotNull InteropViewHolder holder2) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return this.interopComponents.containsKey(holder2.getGroup());
    }

    @Override
    @Nullable
    public InteropViewHolder holderOfView(@NotNull Object view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Component component = (Component)view;
        Container container2 = component.getParent();
        if (container2 == null) {
            boolean bl = false;
            String string = "InteropView is assumed to be added to its group for its entire lifetime";
            throw new IllegalStateException(string.toString());
        }
        Container group = container2;
        return this.interopComponents.get(group);
    }

    @Override
    public void place(@NotNull InteropViewHolder holder2) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        Container group = holder2.getGroup();
        if (this.interopComponents.isEmpty()) {
            this.getSnapshotObserver().start();
        }
        int nonInteropComponents = this.getRoot().getComponentCount() - this.interopComponents.size();
        boolean alreadyAdded = this.interopComponents.containsKey(group);
        if (!alreadyAdded) {
            this.interopComponents.put(group, holder2);
        }
        int countBelow = InteropContainer_skikoKt.countInteropComponentsBelow(this, holder2);
        int lastInteropIndex = this.interopComponents.size() - 1;
        if (!this.placeInteropAbove) {
            lastInteropIndex += nonInteropComponents;
        }
        int awtIndex = lastInteropIndex - countBelow;
        this.scheduleUpdate((Function0<Unit>)((Function0)new Function0<Unit>(alreadyAdded, holder2, this, awtIndex){
            final /* synthetic */ boolean $alreadyAdded;
            final /* synthetic */ InteropViewHolder $holder;
            final /* synthetic */ SwingInteropContainer this$0;
            final /* synthetic */ int $awtIndex;
            {
                this.$alreadyAdded = $alreadyAdded;
                this.$holder = $holder;
                this.this$0 = $receiver;
                this.$awtIndex = $awtIndex;
                super(0);
            }

            public final void invoke() {
                if (this.$alreadyAdded) {
                    this.$holder.changeInteropViewIndex(this.this$0.getRoot(), this.$awtIndex);
                } else {
                    this.$holder.insertInteropView(this.this$0.getRoot(), this.$awtIndex);
                }
            }
        }));
    }

    @Override
    public void unplace(@NotNull InteropViewHolder holder2) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        this.scheduleUpdate((Function0<Unit>)((Function0)new Function0<Unit>(holder2, this){
            final /* synthetic */ InteropViewHolder $holder;
            final /* synthetic */ SwingInteropContainer this$0;
            {
                this.$holder = $holder;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$holder.removeInteropView(this.this$0.getRoot());
            }
        }));
        this.interopComponents.remove(holder2.getGroup());
        if (this.interopComponents.isEmpty()) {
            this.getSnapshotObserver().stop();
        }
    }

    private final void executeScheduledUpdates() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Check failed.");
        }
        boolean hasAnyUpdates = this.scheduledUpdatesSwapchain.execute();
        if (hasAnyUpdates) {
            this.getRoot().validate();
            this.getRoot().repaint();
        }
    }

    public final void dispose() {
        this.executeScheduledUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postponingExecutingScheduledUpdates(@NotNull Function0<Unit> body) {
        Object object;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        ScheduledUpdatesSwapchain this_$iv = this.scheduledUpdatesSwapchain;
        boolean $i$f$preventingRedrawRequests = false;
        try {
            object = ScheduledUpdatesSwapchain.access$getLock$p(this_$iv);
            synchronized (object) {
                boolean $i$a$-synchronized-ScheduledUpdatesSwapchain$preventingRedrawRequests$1$iv22 = false;
                if (!ScheduledUpdatesSwapchain.access$getNeedsRequestRedrawOnUpdateScheduled$p(this_$iv)) {
                    boolean $i$a$-check-ScheduledUpdatesSwapchain$preventingRedrawRequests$1$1$iv22 = false;
                    String $i$a$-check-ScheduledUpdatesSwapchain$preventingRedrawRequests$1$1$iv22 = "Reentry into ignoringRedrawRequests is not allowed";
                    throw new IllegalStateException($i$a$-check-ScheduledUpdatesSwapchain$preventingRedrawRequests$1$1$iv22.toString());
                }
                ScheduledUpdatesSwapchain.access$setNeedsRequestRedrawOnUpdateScheduled$p(this_$iv, false);
                Unit $i$a$-synchronized-ScheduledUpdatesSwapchain$preventingRedrawRequests$1$iv22 = Unit.INSTANCE;
            }
            boolean bl = false;
            body.invoke();
        }
        finally {
            object = ScheduledUpdatesSwapchain.access$getLock$p(this_$iv);
            synchronized (object) {
                boolean bl = false;
                ScheduledUpdatesSwapchain.access$setNeedsRequestRedrawOnUpdateScheduled$p(this_$iv, true);
                Unit unit = Unit.INSTANCE;
            }
        }
        this.executeScheduledUpdates();
    }

    @Override
    public void scheduleUpdate(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.scheduledUpdatesSwapchain.scheduleUpdate(action);
    }

    @NotNull
    public final ClipRectangle getClipRectForComponent(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        InteropViewHolder interopViewHolder = this.interopComponents.get(component);
        if (interopViewHolder == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)interopViewHolder, (String)"null cannot be cast to non-null type org.jetbrains.skiko.ClipRectangle");
        return (ClipRectangle)interopViewHolder;
    }

    @Composable
    @ComposableInferredTarget(scheme="[androidx.compose.ui.UiComposable[androidx.compose.ui.UiComposable]]")
    public final void invoke(@NotNull Function2<? super Composer, ? super Integer, Unit> content, @Nullable Composer $composer, int $changed) {
        block6: {
            Intrinsics.checkNotNullParameter(content, (String)"content");
            $composer = $composer.startRestartGroup(-1630984403);
            ComposerKt.sourceInformation($composer, "C(invoke)244@8308L103,242@8223L188:SwingInteropContainer.desktop.kt#z33iqn");
            int $dirty = $changed;
            if (($changed & 6) == 0) {
                $dirty |= $composer.changedInstance(content) ? 4 : 2;
            }
            if (($changed & 0x30) == 0) {
                $dirty |= $composer.changedInstance(this) ? 32 : 16;
            }
            if (($dirty & 0x13) != 18 || !$composer.getSkipping()) {
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart(-1630984403, $dirty, -1, "androidx.compose.ui.viewinterop.SwingInteropContainer.invoke (SwingInteropContainer.desktop.kt:241)");
                }
                CompositionLocalKt.CompositionLocalProvider(InteropContainer_skikoKt.getLocalInteropContainer().provides(this), (Function2<? super Composer, ? super Integer, Unit>)((Function2)ComposableLambdaKt.rememberComposableLambda(891259885, true, new Function2<Composer, Integer, Unit>(this, content){
                    final /* synthetic */ SwingInteropContainer this$0;
                    final /* synthetic */ Function2<Composer, Integer, Unit> $content;
                    {
                        this.this$0 = $receiver;
                        this.$content = $content;
                        super(2);
                    }

                    @Composable
                    @ComposableTarget(applier="androidx.compose.ui.UiComposable")
                    public final void invoke(Composer $composer, int $changed) {
                        ComposerKt.sourceInformation($composer, "C245@8322L79:SwingInteropContainer.desktop.kt#z33iqn");
                        if (($changed & 3) != 2 || !$composer.getSkipping()) {
                            if (ComposerKt.isTraceInProgress()) {
                                ComposerKt.traceEventStart(891259885, $changed, -1, "androidx.compose.ui.viewinterop.SwingInteropContainer.invoke.<anonymous> (SwingInteropContainer.desktop.kt:245)");
                            }
                            InteropContainer_skikoKt.TrackInteropPlacementContainer(this.this$0, this.$content, $composer, 0);
                            if (ComposerKt.isTraceInProgress()) {
                                ComposerKt.traceEventEnd();
                            }
                        } else {
                            $composer.skipToGroupEnd();
                        }
                    }
                }, $composer, 54)), $composer, 0x30 | ProvidedValue.$stable);
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block6;
            scopeUpdateScope.updateScope((Function2<? super Composer, ? super Integer, Unit>)((Function2)new Function2<Composer, Integer, Unit>(this, content, $changed){
                final /* synthetic */ SwingInteropContainer $tmp0_rcvr;
                final /* synthetic */ Function2<Composer, Integer, Unit> $content;
                final /* synthetic */ int $$changed;
                {
                    this.$tmp0_rcvr = $tmp0_rcvr;
                    this.$content = $content;
                    this.$$changed = $$changed;
                    super(2);
                }

                public final void invoke(Composer $composer, int $force) {
                    this.$tmp0_rcvr.invoke(this.$content, $composer, RecomposeScopeImplKt.updateChangedFlags(this.$$changed | 1));
                }
            }));
        }
    }
}

