/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.CodeStyle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.TimeoutCancellationException;
import org.ec4j.core.ResourceProperties;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigNavigationActionsFactory;
import org.editorconfig.configmanagement.extended.EditorConfigCodeStyleSettingsModifierKt;
import org.editorconfig.configmanagement.extended.EditorConfigCodeStyleStatusBarUIContributor;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002 !B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J7\u0010\u0010\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00062\u000b\u0010\u0013\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier;", "Lcom/intellij/psi/codeStyle/modifier/CodeStyleSettingsModifier;", "<init>", "()V", "reportedErrorIds", "", "", "modifySettings", "", "settings", "Lcom/intellij/psi/codeStyle/modifier/TransientCodeStyleSettings;", "psiFile", "Lcom/intellij/psi/PsiFile;", "doModifySettings", "project", "Lcom/intellij/openapi/project/Project;", "error", "", "id", "message", "Lorg/jetbrains/annotations/Nls;", "fixAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "oneTime", "getStatusBarUiContributor", "Lcom/intellij/psi/codeStyle/modifier/CodeStyleStatusBarUIContributor;", "transientSettings", "mayOverrideSettingsOf", "getName", "getDisablingFunction", "Ljava/util/function/Consumer;", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "DisableEditorConfigAction", "Handler", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigCodeStyleSettingsModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigCodeStyleSettingsModifier.kt\norg/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,363:1\n1557#2:364\n1628#2,3:365\n62#3,5:368\n62#3,5:373\n*S KotlinDebug\n*F\n+ 1 EditorConfigCodeStyleSettingsModifier.kt\norg/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier\n*L\n79#1:364\n79#1:365,3\n80#1:368,5\n84#1:373,5\n*E\n"})
public final class EditorConfigCodeStyleSettingsModifier
implements CodeStyleSettingsModifier {
    @NotNull
    private final Set<String> reportedErrorIds = new HashSet();

    public boolean modifySettings(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        VirtualFile file = psiFile.getVirtualFile();
        if (!Utils.INSTANCE.isFullIntellijSettingsSupport() || file == null || !Handler.INSTANCE.isEnabledInTests$intellij_editorconfig() && ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (project2.isDisposed() || !Utils.isEnabled((CodeStyleSettings)settings)) {
            return false;
        }
        return this.doModifySettings(psiFile, settings, project2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean doModifySettings(PsiFile psiFile, TransientCodeStyleSettings settings, Project project) {
        try {
            Pair pair = EditorConfigCodeStyleSettingsModifierKt.access$processEditorConfig(project, psiFile);
            ResourceProperties properties = (ResourceProperties)pair.component1();
            List editorConfigs = (List)pair.component2();
            if (EditorConfigCodeStyleSettingsModifierKt.access$applyCodeStyleSettings(settings, properties, psiFile)) {
                EditorConfigNavigationActionsFactory editorConfigNavigationActionsFactory;
                EditorConfigNavigationActionsFactory navigationFactory;
                settings.addDependencies(editorConfigs);
                EditorConfigNavigationActionsFactory editorConfigNavigationActionsFactory2 = navigationFactory = EditorConfigNavigationActionsFactory.Companion.getInstance(psiFile);
                if (editorConfigNavigationActionsFactory2 != null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = editorConfigs;
                    editorConfigNavigationActionsFactory = editorConfigNavigationActionsFactory2;
                    boolean $i$f$map = false;
                    void var10_19 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        String string = it.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        collection.add(string);
                    }
                    editorConfigNavigationActionsFactory.updateEditorConfigFilePaths((List)destination$iv$iv);
                }
                Logger $this$debug_u24default$iv = EditorConfigCodeStyleSettingsModifierKt.access$getLOG();
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    editorConfigNavigationActionsFactory = $this$debug_u24default$iv;
                    boolean bl = false;
                    editorConfigNavigationActionsFactory.debug("Modified for " + psiFile.getName(), e$iv);
                }
                return true;
            }
            Logger $this$debug_u24default$iv = EditorConfigCodeStyleSettingsModifierKt.access$getLOG();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("No changes for " + psiFile.getName(), e$iv);
            }
            return false;
        }
        catch (TimeoutCancellationException e) {
            EditorConfigCodeStyleSettingsModifierKt.access$getLOG().warn((Throwable)e);
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                this.error(project, "timeout", EditorConfigBundle.message("error.timeout"), new DisableEditorConfigAction(project), true);
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Exception e) {
            EditorConfigCodeStyleSettingsModifierKt.access$getLOG().error((Throwable)e);
        }
        return false;
    }

    public final synchronized void error(@Nullable Project project, @NotNull String id, @NotNull String message, @Nullable AnAction fixAction, boolean oneTime) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (oneTime) {
            if (this.reportedErrorIds.contains(id)) {
                return;
            }
            this.reportedErrorIds.add(id);
        }
        Notification notification = new Notification("editorconfig", EditorConfigBundle.message("editorconfig"), message, NotificationType.ERROR);
        if (fixAction != null) {
            String string = fixAction.getTemplateText();
            notification.addAction(new AnAction(fixAction, this, id, notification, string){
                final /* synthetic */ AnAction $fixAction;
                final /* synthetic */ EditorConfigCodeStyleSettingsModifier this$0;
                final /* synthetic */ String $id;
                final /* synthetic */ Notification $notification;
                {
                    this.$fixAction = $fixAction;
                    this.this$0 = $receiver;
                    this.$id = $id;
                    this.$notification = $notification;
                    super($super_call_param$1);
                }

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$fixAction.actionPerformed(e);
                    EditorConfigCodeStyleSettingsModifier.access$getReportedErrorIds$p(this.this$0).remove(this.$id);
                    this.$notification.expire();
                }
            });
        }
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    @NotNull
    public CodeStyleStatusBarUIContributor getStatusBarUiContributor(@NotNull TransientCodeStyleSettings transientSettings) {
        Intrinsics.checkNotNullParameter((Object)transientSettings, (String)"transientSettings");
        return new EditorConfigCodeStyleStatusBarUIContributor();
    }

    public boolean mayOverrideSettingsOf(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return Utils.isEnabled(CodeStyle.getSettings((Project)project)) && Utils.INSTANCE.editorConfigExists(project);
    }

    @NotNull
    public String getName() {
        return EditorConfigBundle.message("editorconfig");
    }

    @NotNull
    public Consumer<CodeStyleSettings> getDisablingFunction(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return EditorConfigCodeStyleSettingsModifier::getDisablingFunction$lambda$3;
    }

    private static final void getDisablingFunction$lambda$3(CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(EditorConfigSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        EditorConfigSettings editorConfigSettings = (EditorConfigSettings)customCodeStyleSettings;
        editorConfigSettings.ENABLED = false;
    }

    public static final /* synthetic */ Set access$getReportedErrorIds$p(EditorConfigCodeStyleSettingsModifier $this) {
        return $this.reportedErrorIds;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier$DisableEditorConfigAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.editorconfig"})
    private static final class DisableEditorConfigAction
    extends AnAction {
        @NotNull
        private final Project myProject;

        public DisableEditorConfigAction(@NotNull Project myProject) {
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            super(EditorConfigBundle.message("action.disable"));
            this.myProject = myProject;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            CustomCodeStyleSettings customCodeStyleSettings = CodeStyle.getSettings((Project)this.myProject).getCustomSettings(EditorConfigSettings.class);
            EditorConfigSettings $this$actionPerformed_u24lambda_u240 = (EditorConfigSettings)customCodeStyleSettings;
            boolean bl = false;
            $this$actionPerformed_u24lambda_u240.ENABLED = false;
            CodeStyleSettingsManager.getInstance((Project)this.myProject).notifyCodeStyleSettingsChanged();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lorg/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier$Handler;", "", "<init>", "()V", "isEnabledInTests", "", "isEnabledInTests$intellij_editorconfig", "setEnabledInTests", "", "intellij.editorconfig"})
    public static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();

        private Handler() {
        }

        public final boolean isEnabledInTests$intellij_editorconfig() {
            return EditorConfigCodeStyleSettingsModifierKt.access$getOurEnabledInTestOnly$p();
        }

        @TestOnly
        public final void setEnabledInTests(boolean isEnabledInTests) {
            EditorConfigCodeStyleSettingsModifierKt.access$setOurEnabledInTestOnly$p(isEnabledInTests);
        }
    }
}

