/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.ImperativeCommand;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/testFramework/propertyBased/CheckPsiReadAccessors;", "Lcom/intellij/testFramework/propertyBased/ActionOnFile;", "file", "Lcom/intellij/psi/PsiFile;", "skipCondition", "Lcom/intellij/openapi/util/Condition;", "Ljava/lang/reflect/Method;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/Condition;)V", "performCommand", "", "env", "Lorg/jetbrains/jetCheck/ImperativeCommand$Environment;", "invokeAllReadAccessors", "instance", "", "intellij.platform.testFramework"})
public final class CheckPsiReadAccessors
extends ActionOnFile {
    @NotNull
    private final Condition<? super Method> skipCondition;

    public CheckPsiReadAccessors(@NotNull PsiFile file, @NotNull Condition<? super Method> skipCondition) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(skipCondition, (String)"skipCondition");
        super(file);
        this.skipCondition = skipCondition;
    }

    public void performCommand(@NotNull ImperativeCommand.Environment env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Iterator iterator = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)this.getFile())).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            PsiElement element = (PsiElement)iterator2.next();
            Intrinsics.checkNotNull((Object)element);
            this.invokeAllReadAccessors(element);
        }
    }

    private final void invokeAllReadAccessors(Object instance) {
        PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(instance.getClass()).getPropertyDescriptors();
        if (propertyDescriptorArray == null) {
            return;
        }
        for (PropertyDescriptor descriptor : propertyDescriptorArray) {
            Method method;
            if (descriptor.getReadMethod() == null || this.skipCondition.value((Object)method)) continue;
            try {
                Object object = method.invoke(instance, new Object[0]);
            }
            catch (Throwable e) {
                throw new RuntimeException(method.getDeclaringClass() + "#" + method.getName(), e);
            }
        }
    }
}

