/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.black;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.pathValidation.PathValidatorKt;
import com.jetbrains.python.pathValidation.PlatformAndRoot;
import com.jetbrains.python.pathValidation.ValidationRequest;
import com.jetbrains.python.pyi.PyiFileType;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/python/black/BlackFormatterUtil;", "", "<init>", "()V", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nBlackFormatterUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlackFormatterUtil.kt\ncom/jetbrains/python/black/BlackFormatterUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,60:1\n25#2:61\n*S KotlinDebug\n*F\n+ 1 BlackFormatterUtil.kt\ncom/jetbrains/python/black/BlackFormatterUtil\n*L\n25#1:61\n*E\n"})
public final class BlackFormatterUtil {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String PACKAGE_NAME = "black";
    @NotNull
    private static final Version MINIMAL_LINE_RANGES_COMPATIBLE_VERSION;

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        MINIMAL_LINE_RANGES_COMPATIBLE_VERSION = new Version(23, 11, 0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0006\u0010\u0019\u001a\u00020\u000fJ\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\r\u0010\u001c\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/python/black/BlackFormatterUtil$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "PACKAGE_NAME", "", "MINIMAL_LINE_RANGES_COMPATIBLE_VERSION", "Lcom/intellij/openapi/util/Version;", "getMINIMAL_LINE_RANGES_COMPATIBLE_VERSION", "()Lcom/intellij/openapi/util/Version;", "isFileApplicable", "", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isBlackFormatterInstalledOnProjectSdk", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "detectBlackExecutable", "Ljava/io/File;", "isBlackExecutableDetected", "validateBlackExecutable", "Lcom/intellij/openapi/ui/ValidationInfo;", "path", "Lorg/jetbrains/annotations/SystemDependent;", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nBlackFormatterUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlackFormatterUtil.kt\ncom/jetbrains/python/black/BlackFormatterUtil$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1#2:61\n1755#3,3:62\n*S KotlinDebug\n*F\n+ 1 BlackFormatterUtil.kt\ncom/jetbrains/python/black/BlackFormatterUtil$Companion\n*L\n38#1:62,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final Version getMINIMAL_LINE_RANGES_COMPATIBLE_VERSION() {
            return MINIMAL_LINE_RANGES_COMPATIBLE_VERSION;
        }

        public final boolean isFileApplicable(@NotNull VirtualFile vFile) {
            Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
            return Intrinsics.areEqual((Object)vFile.getFileType(), (Object)PythonFileType.INSTANCE) || Intrinsics.areEqual((Object)vFile.getFileType(), (Object)PyiFileType.INSTANCE);
        }

        public final boolean isBlackFormatterInstalledOnProjectSdk(@NotNull Project project, @Nullable Sdk sdk2) {
            boolean bl;
            block7: {
                PythonPackageManager packageManager;
                PythonPackageManager pythonPackageManager;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Sdk sdk3 = sdk2;
                if (sdk3 != null) {
                    Sdk it = sdk3;
                    boolean bl2 = false;
                    pythonPackageManager = PythonPackageManager.Companion.forSdk(project, sdk2);
                } else {
                    pythonPackageManager = null;
                }
                PythonPackageManager pythonPackageManager2 = packageManager = pythonPackageManager;
                if (pythonPackageManager2 != null) {
                    PythonPackageManager it = pythonPackageManager2;
                    boolean bl3 = false;
                    Iterable $this$any$iv = it.getInstalledPackages();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PythonPackage pyPackage = (PythonPackage)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)pyPackage.getName(), (Object)BlackFormatterUtil.PACKAGE_NAME)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
            return bl;
        }

        @Nullable
        public final File detectBlackExecutable() {
            String name2 = SystemInfo.isWindows ? "black.exe" : BlackFormatterUtil.PACKAGE_NAME;
            return PathEnvironmentVariableUtil.findInPath((String)name2);
        }

        public final boolean isBlackExecutableDetected() {
            return this.detectBlackExecutable() != null;
        }

        @Nullable
        public final ValidationInfo validateBlackExecutable(@Nullable String path2) {
            Object[] objectArray = new Object[]{SystemInfo.isWindows ? 0 : 1};
            String string = PyBundle.message("black.executable.not.found", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return PathValidatorKt.validateExecutableFile(new ValidationRequest(path2, string, PlatformAndRoot.Companion.getLocal(), null, 8, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

