/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreview;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0001\u0019B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0014J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0014J\b\u0010\u0012\u001a\u00020\u000bH\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u000bH\u0014J\b\u0010\u0016\u001a\u00020\u0014H\u0014J\b\u0010\u0017\u001a\u00020\u0014H\u0014J\b\u0010\u0018\u001a\u00020\u0014H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesTreeEditorDiffPreview;", "Lcom/intellij/openapi/vcs/changes/EditorTabDiffPreview;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "targetComponent", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Ljavax/swing/JComponent;)V", "getTree", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "isPreviewOnDoubleClick", "", "handleDoubleClick", "e", "Ljava/awt/event/MouseEvent;", "isPreviewOnEnter", "handleEnterKey", "isOpenPreviewWithSingleClickEnabled", "isOpenPreviewWithSingleClick", "handleSingleClick", "", "isOpenPreviewWithNextDiffShortcut", "handleNextDiffShortcut", "handleEscapeKey", "returnFocusToTree", "PreviewOnNextDiffAction", "intellij.platform.vcs.impl"})
public abstract class ChangesTreeEditorDiffPreview
extends EditorTabDiffPreview {
    @NotNull
    private final ChangesTree tree;

    public ChangesTreeEditorDiffPreview(@NotNull ChangesTree tree, @NotNull JComponent targetComponent) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        Intrinsics.checkNotNullParameter((Object)targetComponent, (String)"targetComponent");
        Project project = tree.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        super(project);
        this.tree = tree;
        this.tree.setDoubleClickHandler((Processor<? super MouseEvent>)((Processor)arg_0 -> ChangesTreeEditorDiffPreview._init_$lambda$0(this, arg_0)));
        this.tree.setEnterKeyHandler((Processor<? super KeyEvent>)((Processor)arg_0 -> ChangesTreeEditorDiffPreview._init_$lambda$1(this, arg_0)));
        this.tree.addSelectionListener(() -> ChangesTreeEditorDiffPreview._init_$lambda$2(this));
        new PreviewOnNextDiffAction().registerCustomShortcutSet(targetComponent, (Disposable)this);
        UIUtil.putClientProperty((JComponent)((JComponent)((Object)this.tree)), (Key)ExpandableItemsHandler.IGNORE_ITEM_SELECTION, (Object)true);
    }

    public /* synthetic */ ChangesTreeEditorDiffPreview(ChangesTree changesTree, JComponent jComponent, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            jComponent = (JComponent)((Object)changesTree);
        }
        this(changesTree, jComponent);
    }

    @NotNull
    protected final ChangesTree getTree() {
        return this.tree;
    }

    protected boolean isPreviewOnDoubleClick() {
        return true;
    }

    public boolean handleDoubleClick(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.isPreviewOnDoubleClick()) {
            return false;
        }
        if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)((Object)this.tree)), (MouseEvent)e)) {
            return false;
        }
        return this.performDiffAction();
    }

    protected boolean isPreviewOnEnter() {
        return true;
    }

    public boolean handleEnterKey() {
        if (!this.isPreviewOnEnter()) {
            return false;
        }
        return this.performDiffAction();
    }

    protected boolean isOpenPreviewWithSingleClickEnabled() {
        return false;
    }

    protected boolean isOpenPreviewWithSingleClick() {
        if (!this.isOpenPreviewWithSingleClickEnabled()) {
            return false;
        }
        return VcsConfiguration.getInstance((Project)this.getProject()).LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN;
    }

    protected void handleSingleClick() {
        if (!this.isOpenPreviewWithSingleClick()) {
            return;
        }
        boolean opened = this.openPreview(false);
        if (!opened) {
            this.closePreview();
        }
    }

    protected boolean isOpenPreviewWithNextDiffShortcut() {
        return true;
    }

    protected void handleNextDiffShortcut() {
        if (!this.isOpenPreviewWithNextDiffShortcut()) {
            return;
        }
        this.openPreview(true);
    }

    protected void handleEscapeKey() {
        this.closePreview();
        ApplicationManager.getApplication().invokeLater(() -> ChangesTreeEditorDiffPreview.handleEscapeKey$lambda$3(this));
    }

    protected void returnFocusToTree() {
    }

    private static final boolean _init_$lambda$0(ChangesTreeEditorDiffPreview this$0, MouseEvent e) {
        Intrinsics.checkNotNull((Object)e);
        return this$0.handleDoubleClick(e);
    }

    private static final boolean _init_$lambda$1(ChangesTreeEditorDiffPreview this$0, KeyEvent e) {
        return this$0.handleEnterKey();
    }

    private static final void _init_$lambda$2(ChangesTreeEditorDiffPreview this$0) {
        this$0.handleSingleClick();
    }

    private static final void handleEscapeKey$lambda$3(ChangesTreeEditorDiffPreview this$0) {
        this$0.returnFocusToTree();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesTreeEditorDiffPreview$PreviewOnNextDiffAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ChangesTreeEditorDiffPreview;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.platform.vcs.impl"})
    private final class PreviewOnNextDiffAction
    extends DumbAwareAction {
        public PreviewOnNextDiffAction() {
            this.copyShortcutFrom(ActionManager.getInstance().getAction("NextDiff"));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabledAndVisible(ChangesTreeEditorDiffPreview.this.isOpenPreviewWithNextDiffShortcut());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ChangesTreeEditorDiffPreview.this.handleNextDiffShortcut();
        }
    }
}

