/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/UrlDescriptor;", "Lcom/intellij/util/io/KeyDescriptor;", "Lorg/jetbrains/idea/svn/api/Url;", "isEncoded", "", "<init>", "(Z)V", "save", "", "out", "Ljava/io/DataOutput;", "value", "read", "in", "Ljava/io/DataInput;", "getHashCode", "", "isEqual", "val1", "val2", "Companion", "intellij.vcs.svn"})
public final class UrlDescriptor
implements KeyDescriptor<Url> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isEncoded;
    @JvmField
    @NotNull
    public static final UrlDescriptor ENCODED_URL_DESCRIPTOR = new UrlDescriptor(true);
    @JvmField
    @NotNull
    public static final UrlDescriptor DECODED_URL_DESCRIPTOR = new UrlDescriptor(false);

    public UrlDescriptor(boolean isEncoded) {
        this.isEncoded = isEncoded;
    }

    public void save(@NotNull DataOutput out, @NotNull Url value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        out.writeUTF(this.isEncoded ? value.toString() : value.toDecodedString());
    }

    @NotNull
    public Url read(@NotNull DataInput in) throws IOException {
        Url url;
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        String urlValue = in.readUTF();
        try {
            url = SvnUtil.createUrl(urlValue, this.isEncoded);
            Intrinsics.checkNotNull((Object)url);
        }
        catch (SvnBindException e) {
            throw new IOException("Could not parse url " + urlValue, (Throwable)((Object)e));
        }
        return url;
    }

    public int getHashCode(@NotNull Url value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value.hashCode();
    }

    public boolean isEqual(@NotNull Url val1, @NotNull Url val2) {
        Intrinsics.checkNotNullParameter((Object)val1, (String)"val1");
        Intrinsics.checkNotNullParameter((Object)val2, (String)"val2");
        return Intrinsics.areEqual((Object)val1, (Object)val2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/UrlDescriptor$Companion;", "", "<init>", "()V", "ENCODED_URL_DESCRIPTOR", "Lorg/jetbrains/idea/svn/branchConfig/UrlDescriptor;", "DECODED_URL_DESCRIPTOR", "intellij.vcs.svn"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

