/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JpsMavenSettings {
    private static final String REPOSITORY_PATH = "repository";
    private static final String M2_DIR = ".m2";
    private static final String CONF_DIR = "conf";
    private static final String SETTINGS_XML = "settings.xml";
    private static final List<Namespace> KNOWN_NAMESPACES = List.of(Namespace.getNamespace((String)"http://maven.apache.org/SETTINGS/1.0.0"), Namespace.getNamespace((String)"http://maven.apache.org/SETTINGS/1.1.0"), Namespace.getNamespace((String)"http://maven.apache.org/SETTINGS/1.2.0"));

    @NotNull
    public static File getUserMavenSettingsXml() {
        String defaultMavenFolder = SystemProperties.getUserHome() + File.separator + M2_DIR;
        return new File(defaultMavenFolder, SETTINGS_XML);
    }

    @Nullable
    public static File getGlobalMavenSettingsXml() {
        String mavenHome = JpsMavenSettings.resolveMavenHomeDirectory();
        if (mavenHome == null) {
            return null;
        }
        return new File(mavenHome + File.separator + CONF_DIR, SETTINGS_XML);
    }

    @Nullable
    private static String resolveMavenHomeDirectory() {
        String defaultHome;
        String mavenFromBrew;
        String m2home = System.getenv("M2_HOME");
        if (JpsMavenSettings.isValidMavenHome(m2home)) {
            return m2home;
        }
        String mavenHome = System.getenv("MAVEN_HOME");
        if (JpsMavenSettings.isValidMavenHome(mavenHome)) {
            return mavenHome;
        }
        String m2UserHome = SystemProperties.getUserHome() + File.separator + M2_DIR;
        if (JpsMavenSettings.isValidMavenHome(m2UserHome)) {
            return m2UserHome;
        }
        if (SystemInfoRt.isMac && JpsMavenSettings.isValidMavenHome(mavenFromBrew = JpsMavenSettings.fromBrew())) {
            return mavenFromBrew;
        }
        if ((SystemInfoRt.isLinux || SystemInfoRt.isMac) && JpsMavenSettings.isValidMavenHome(defaultHome = "/usr/share/maven")) {
            return defaultHome;
        }
        return null;
    }

    @Nullable
    public static String getMavenRepositoryPath() {
        String fromGlobalSettings;
        String fromUserSettings;
        String defaultMavenFolder = SystemProperties.getUserHome() + File.separator + M2_DIR;
        File userSettingsFile = JpsMavenSettings.getUserMavenSettingsXml();
        if (userSettingsFile.exists() && StringUtil.isNotEmpty((String)(fromUserSettings = JpsMavenSettings.getRepositoryFromSettings(userSettingsFile))) && new File(fromUserSettings).exists()) {
            return fromUserSettings;
        }
        File globalSettingsFile = JpsMavenSettings.getGlobalMavenSettingsXml();
        if (globalSettingsFile != null && globalSettingsFile.exists() && StringUtil.isNotEmpty((String)(fromGlobalSettings = JpsMavenSettings.getRepositoryFromSettings(globalSettingsFile))) && new File(fromGlobalSettings).exists()) {
            return fromGlobalSettings;
        }
        String defaultMavenRepository = defaultMavenFolder + File.separator + REPOSITORY_PATH;
        return Files.exists(Path.of(defaultMavenFolder, new String[0]), new LinkOption[0]) ? defaultMavenRepository : null;
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<String, RemoteRepositoryAuthentication> loadAuthenticationSettings(@Nullable File globalMavenSettingsXml, @NotNull File userMavenSettingsXml) {
        if (userMavenSettingsXml == null) {
            JpsMavenSettings.$$$reportNull$$$0(0);
        }
        if (!(globalMavenSettingsXml != null && globalMavenSettingsXml.exists() || userMavenSettingsXml.exists())) {
            Map<String, RemoteRepositoryAuthentication> map = Collections.emptyMap();
            if (map == null) {
                JpsMavenSettings.$$$reportNull$$$0(1);
            }
            return map;
        }
        HashMap<String, RemoteRepositoryAuthentication> result = new HashMap<String, RemoteRepositoryAuthentication>();
        if (globalMavenSettingsXml != null && globalMavenSettingsXml.exists()) {
            JpsMavenSettings.loadAuthenticationFromSettings(globalMavenSettingsXml, result);
        }
        if (userMavenSettingsXml.exists()) {
            JpsMavenSettings.loadAuthenticationFromSettings(userMavenSettingsXml, result);
        }
        HashMap<String, RemoteRepositoryAuthentication> hashMap = result;
        if (hashMap == null) {
            JpsMavenSettings.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @Nullable
    private static String fromBrew() {
        File brewDir = new File("/usr/local/Cellar/maven");
        String[] list = brewDir.list();
        if (list == null || list.length == 0) {
            return null;
        }
        Arrays.sort(list, (o1, o2) -> StringUtil.compareVersionNumbers((String)o2, (String)o1));
        return String.valueOf(brewDir) + File.separator + list[0] + "/libexec";
    }

    @Nullable
    private static String getRepositoryFromSettings(File file) {
        Element settingsXmlRoot;
        try {
            settingsXmlRoot = JDOMUtil.load((File)file);
        }
        catch (IOException | JDOMException e) {
            return null;
        }
        Optional<String> maybeRepository = KNOWN_NAMESPACES.stream().map(it -> settingsXmlRoot.getChildText("localRepository", it)).filter(it -> it != null && !StringUtil.isEmpty((String)it)).findFirst();
        return maybeRepository.orElse(null);
    }

    private static boolean isValidMavenHome(@Nullable String path) {
        return Strings.isNotEmpty((String)path) && Files.exists(Path.of(path, new String[0]), new LinkOption[0]);
    }

    private static void loadAuthenticationFromSettings(@NotNull File settingsXml, @NotNull Map<String, RemoteRepositoryAuthentication> output) {
        Element settingsXmlRoot;
        if (settingsXml == null) {
            JpsMavenSettings.$$$reportNull$$$0(3);
        }
        if (output == null) {
            JpsMavenSettings.$$$reportNull$$$0(4);
        }
        try {
            settingsXmlRoot = JDOMUtil.load((File)settingsXml);
        }
        catch (IOException | JDOMException e) {
            return;
        }
        Optional<Namespace> maybeNamespace = KNOWN_NAMESPACES.stream().filter(it -> settingsXmlRoot.getChild("servers", it) != null).findFirst();
        if (maybeNamespace.isEmpty()) {
            return;
        }
        Namespace namespace = maybeNamespace.get();
        Element serversElement = settingsXmlRoot.getChild("servers", namespace);
        for (Element serverElement : serversElement.getChildren("server", namespace)) {
            String id = serverElement.getChildText("id", namespace);
            String username = serverElement.getChildText("username", namespace);
            String password = serverElement.getChildText("password", namespace);
            if (id == null || username == null || password == null) continue;
            output.put(id, new RemoteRepositoryAuthentication(username, password));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userMavenSettingsXml";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/JpsMavenSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsXml";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsMavenSettings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAuthenticationSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadAuthenticationSettings";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadAuthenticationFromSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class RemoteRepositoryAuthentication {
        private final String username;
        private final String password;

        public RemoteRepositoryAuthentication(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

