/*
    Written by Ralph Marchildon: wmDownload is a WindowMaker dock app
	that monitors and reports how much you have downloaded since
	your last reboot.
	
    Copyright (C) 2000 Ralph Marchildon

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Please direct bug-reports or comments to: who2go2@hotmail.com	
*/

/*
 * Copyright (c) 1999 Alfredo K. Kojima
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <dockapp.h>
#include <unistd.h>
#include <string.h>
#include "PIX/master.xpm"
#include "PIX/numbers.xpm"
#include "PIX/device.xpm"

#define DESCRIPTION "\nA utility to monitor how much you've downloaded\n"
#define VERSION "wmDownload 0.1.1"

#define WIN_SZ 56
#define NUM_SX 7
#define NUM_SY 9

char *displayName = "";

char *device = "   ";
unsigned char devnum = 0;

unsigned char numeth = 0;
unsigned char numppp = 0;

unsigned char nhex = 0;
unsigned int base = 1024;

unsigned long long int bytes = 0;
unsigned int kbytes, mbytes, gbytes;

unsigned int *cmdline;

FILE *file;

GC gc;
Pixmap pixmap, mask;
Pixmap pixnum, masknum;
Pixmap pixdev, devmask;

void writeFile(void);

static DAProgramOption options[] = {
	{"-display", NULL, "Display to use", DOString, False, {&displayName}}
};

void drawNum (int num, int column, int row)
{
	if(row == 1)
		row = 2*NUM_SY - 3;
	else if(row == 2)
		row = 3*NUM_SY + 2;
	else if(row == 3)
		row = 4*NUM_SY + 7;		
	else
		return;
		
	XCopyArea (DADisplay, pixnum, pixmap, gc, num*NUM_SX, 0, NUM_SX, NUM_SY, column*NUM_SX + 3, row);
}

void drawDev (char* type, int num)
{
	int type2 = 0;
	
	if(type == "eth")
		type2 = 0;
	else
		type2 = 1;	
	
	XCopyArea (DADisplay, pixdev, pixmap, gc, 0, type2*9, 17, 9, 3, 2);
	XCopyArea (DADisplay, pixnum, pixmap, gc, num*NUM_SX, 0, NUM_SX, NUM_SY, 19 + 3, 2);
}


void drawNumbers (int gigs, int megs, int kbytes)
{
	char gig[8];
	char meg[8];
	char kby[8];	
	
	int i;
	
	drawDev(device,devnum);
	
	for(i=0; i<7; i++)
	{
		drawNum(16, i, 1);
		drawNum(16, i, 2);
		drawNum(16, i, 3);
	}
	
	if (!nhex)
	{
		sprintf(gig, "%7d", gigs);
		sprintf(meg, "%7d", megs);
		sprintf(kby, "%7d", kbytes);
	}
	else
	{
		sprintf(gig, "%7x", gigs);
		sprintf(meg, "%7x", megs);
		sprintf(kby, "%7x", kbytes);
	}
	
	for(i=0; i<7; i++)
	{
		if(gig[i] != ' ' && gig[i] <= '9') drawNum((int)gig[i] - (int)'0', i, 1);
		else if(gig[i] !=' ') drawNum(((int)gig[i] - (int)'a') + 10, i,1);
		
		if(meg[i] != ' ' && meg[i] <= '9') drawNum((int)meg[i] - (int)'0', i, 2);
		else if(meg[i] !=' ') drawNum(((int)meg[i] - (int)'a') + 10, i,2);
		
		if(kby[i] != ' ' && kby[i] <= '9') drawNum((int)kby[i] - (int)'0', i, 3);
		else if(kby[i] !=' ') drawNum(((int)kby[i] - (int)'a') + 10, i,3);
	}
}

static void buttonPressCallback (int button, int state, int x, int y)
{
	if ((button == 1) && ((numeth != 0) || (numppp != 0)))
	{
		// bytes = kbytes = mbytes = gbytes = 0;		
	
		devnum++;
		devnum %= (device == "eth")?numeth:numppp;
		
		if(devnum == 0)
		{
			if(device == "eth" && (numppp != 0))
				device = "ppp";
			else
				device = "eth";	
		}

	}
	if (button == 3)
		nhex = !nhex;	
}

void checknetstats ()
{
	char string[128];
	char dev[5];
	char *tokens = " :\t\n";
	char *p;

	bytes = kbytes = mbytes = gbytes = 0;

	file = fopen ("/proc/net/dev", "r");
	
	sprintf(dev, "%s%d%c", device, devnum, '\0');
	
	if (file)
	{
		while (fgets (string, 128, file))
		{
			p = (char *)strtok (string, tokens);

			while (p != NULL)
			{
				if (strcmp (p, dev) == 0)
				{
					p = (char *)strtok (NULL, tokens);
						
					bytes = strtouq(p, NULL, 0);
						
					kbytes = (bytes == 0)?0:bytes/base;
					bytes = bytes%base;
						
					mbytes = (kbytes == 0)?0:kbytes/base;
					kbytes = kbytes%base;
						
					gbytes = (mbytes == 0)?0:mbytes/base;
					mbytes = mbytes%base;
				}
				p = (char *)strtok (NULL, tokens);
			}
		}
	}

	fclose(file);
	drawNumbers(gbytes, mbytes, kbytes);
}

void getDevices(void)
{
	char string[128];
	char *dev1 = "eth";
	char *dev2 = "ppp";
	
	char *tokens = " :\t\n0123456789|";
	char *p;

	file = fopen ("/proc/net/dev", "r");
	
	if (file)
	{
		while (fgets (string, 128, file))
		{
			p = (char *)strtok (string, tokens);
			
			if(p)
			{
				if (strcmp (p, dev1) == 0)
					numeth++;
				else
					if (strcmp (p, dev2) == 0)
						numppp++;
			}	
		}
	
		if((numeth == 0) && (numppp == 0))
			printf("You have no modem or ethernet devices setup on your machine!\n");
		else
			device = (numppp != 0)?dev2:dev1;
	}
}	


int main (int argc, char **argv)
{
	unsigned int height, width;
	
	DACallbacks callbacks = { NULL, buttonPressCallback, NULL, NULL, NULL, NULL, NULL }; 

	DAParseArguments (argc, argv, options, sizeof (options) / sizeof (DAProgramOption), DESCRIPTION, VERSION);
	DAInitialize (displayName, "wmDownload", WIN_SZ, WIN_SZ, argc, argv);

	DAMakePixmapFromData (master_xpm, &pixmap, &mask, &height, &width);
	DASetPixmap (pixmap);
	DAMakePixmapFromData (numbers_xpm, &pixnum, &masknum, &height, &width);
	DAMakePixmapFromData (device_xpm, &pixdev, &devmask, &height, &width);	
	gc = DefaultGC (DADisplay, DefaultScreen (DADisplay));

	DASetCallbacks (&callbacks);
	DAShow ();

	getDevices();

	while (1)
	{
		XEvent ev;
		DASetPixmap (pixmap);
		
		/* handle all pending X events */
		while (XPending (DADisplay))
		{
			XNextEvent (DADisplay, &ev);
			DAProcessEvent (&ev);
		}
		
		checknetstats();
		usleep (500000L);
	}
	return 0;
}
