/*
  File autogenerated by gengetopt version 2.23
  generated with the following command:
  gengetopt --conf-parser -i /home/runner/work/yubico-piv-tool/yubico-piv-tool/tool/cmdline.ggo --output-dir /home/runner/work/yubico-piv-tool/yubico-piv-tool/tool 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "";

const char *gengetopt_args_info_usage = "Usage: " CMDLINE_PARSER_PACKAGE " [OPTION]...";

const char *gengetopt_args_info_versiontext = "";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_full_help[] = {
  "  -h, --help               Print help and exit",
  "      --full-help          Print help, including hidden options, and exit",
  "  -V, --version            Print version and exit",
  "  -v, --verbose[=INT]      Print more information  (default=`0')",
  "  -r, --reader=STRING      Only use a matching reader  (default=`Yubikey')",
  "  -k, --key[=STRING]       Management key to use, if no value is specified key\n                             will be asked for\n                             (default=`010203040506070801020304050607080102030405060708')",
  "  -a, --action=ENUM        Action to take  (possible values=\"version\",\n                             \"generate\", \"set-mgm-key\", \"reset\",\n                             \"pin-retries\", \"import-key\",\n                             \"import-certificate\", \"set-chuid\",\n                             \"request-certificate\", \"verify-pin\",\n                             \"verify-bio\", \"change-pin\", \"change-puk\",\n                             \"unblock-pin\", \"selfsign-certificate\",\n                             \"delete-certificate\", \"read-certificate\",\n                             \"read-public-key\", \"status\",\n                             \"test-signature\", \"test-decipher\",\n                             \"list-readers\", \"set-ccc\", \"write-object\",\n                             \"read-object\", \"attest\", \"move-key\",\n                             \"delete-key\")",
  "\n       Multiple actions may be given at once and will be executed in order\n       for example --action=verify-pin --action=request-certificate\n",
  "  -s, --slot=ENUM          What key slot to operate on  (possible\n                             values=\"9a\", \"9c\", \"9d\", \"9e\", \"82\",\n                             \"83\", \"84\", \"85\", \"86\", \"87\", \"88\",\n                             \"89\", \"8a\", \"8b\", \"8c\", \"8d\", \"8e\",\n                             \"8f\", \"90\", \"91\", \"92\", \"93\", \"94\",\n                             \"95\", \"f9\")",
  "\n       9a is for PIV Authentication\n       9c is for Digital Signature (PIN always checked)\n       9d is for Key Management\n       9e is for Card Authentication (PIN never checked)\n       82-95 is for Retired Key Management\n       f9 is for Attestation\n",
  "      --to-slot=ENUM       What slot to move an existing key to  (possible\n                             values=\"9a\", \"9c\", \"9d\", \"9e\", \"82\",\n                             \"83\", \"84\", \"85\", \"86\", \"87\", \"88\",\n                             \"89\", \"8a\", \"8b\", \"8c\", \"8d\", \"8e\",\n                             \"8f\", \"90\", \"91\", \"92\", \"93\", \"94\",\n                             \"95\", \"f9\")",
  "\n       9a is for PIV Authentication\n       9c is for Digital Signature (PIN always checked)\n       9d is for Key Management\n       9e is for Card Authentication (PIN never checked)\n       82-95 is for Retired Key Management\n       f9 is for Attestation\n",
  "  -A, --algorithm=ENUM     What algorithm to use  (possible values=\"RSA1024\",\n                             \"RSA2048\", \"RSA3072\", \"RSA4096\",\n                             \"ECCP256\", \"ECCP384\", \"ED25519\", \"X25519\"\n                             default=`RSA2048')",
  "  -H, --hash=ENUM          Hash to use for signatures  (possible\n                             values=\"SHA1\", \"SHA256\", \"SHA384\",\n                             \"SHA512\" default=`SHA256')",
  "  -n, --new-key=STRING     New management key to use for action set-mgm-key, if\n                             omitted key will be asked for",
  "      --pin-retries=INT    Number of retries before the pin code is blocked",
  "      --puk-retries=INT    Number of retries before the puk code is blocked",
  "  -i, --input=STRING       Filename to use as input, - for stdin  (default=`-')",
  "  -o, --output=STRING      Filename to use as output, - for stdout\n                             (default=`-')",
  "  -K, --key-format=ENUM    Format of the key being read/written  (possible\n                             values=\"PEM\", \"PKCS12\", \"GZIP\", \"DER\",\n                             \"SSH\" default=`PEM')",
  "      --compress           Compress a large certificate using GZIP before\n                             import  (default=off)",
  "      --global             Reset the whole device over all applications\n                             (default=off)",
  "  -p, --password=STRING    Password for decryption of private key file, if\n                             omitted password will be asked for",
  "  -S, --subject=STRING     The subject to use for certificate request",
  "\n       The subject must be written as:\n       /CN=host.example.com/OU=test/O=example.com/\n",
  "      --serial=INT         Serial number of the self-signed certificate",
  "      --valid-days=INT     Time (in days) until the self-signed certificate\n                             expires  (default=`365')",
  "  -P, --pin=STRING         Pin/puk code for verification, if omitted pin/puk\n                             will be asked for",
  "  -N, --new-pin=STRING     New pin/puk code for changing, if omitted pin/puk\n                             will be asked for",
  "      --pin-policy=ENUM    Set pin policy for action generate or import-key.\n                             Only available on YubiKey 4 or newer  (possible\n                             values=\"never\", \"once\", \"always\",\n                             \"matchonce\", \"matchalways\")",
  "      --touch-policy=ENUM  Set touch policy for action generate, import-key or\n                             set-mgm-key. Only available on YubiKey 4 or newer\n                             (possible values=\"never\", \"always\",\n                             \"cached\")",
  "      --id=INT             Id of object for write/read object",
  "  -f, --format=ENUM        Format of data for write/read object  (possible\n                             values=\"hex\", \"base64\", \"binary\"\n                             default=`hex')",
  "      --sign               Sign data  (default=off)",
  "      --stdin-input        Read sensitive values from stdin  (default=off)",
  "      --attestation        Add attestation cross-signature  (default=off)",
  "  -m, --new-key-algo=ENUM  New management key algorithm to use for action\n                             set-mgm-key  (possible values=\"TDES\",\n                             \"AES128\", \"AES192\", \"AES256\" default=`TDES')",
  "      --scp11              Communication with the YubiKey is done over an\n                             encrypted channel. DEPRECATED! Please use the\n                             '--enc' flag instead  (default=off)",
  "      --enc                Communication with the YubiKey is done over an\n                             encrypted channel  (default=off)",
    0
};

static void
init_help_array(void)
{
  gengetopt_args_info_help[0] = gengetopt_args_info_full_help[0];
  gengetopt_args_info_help[1] = gengetopt_args_info_full_help[1];
  gengetopt_args_info_help[2] = gengetopt_args_info_full_help[2];
  gengetopt_args_info_help[3] = gengetopt_args_info_full_help[3];
  gengetopt_args_info_help[4] = gengetopt_args_info_full_help[4];
  gengetopt_args_info_help[5] = gengetopt_args_info_full_help[5];
  gengetopt_args_info_help[6] = gengetopt_args_info_full_help[6];
  gengetopt_args_info_help[7] = gengetopt_args_info_full_help[7];
  gengetopt_args_info_help[8] = gengetopt_args_info_full_help[8];
  gengetopt_args_info_help[9] = gengetopt_args_info_full_help[9];
  gengetopt_args_info_help[10] = gengetopt_args_info_full_help[10];
  gengetopt_args_info_help[11] = gengetopt_args_info_full_help[11];
  gengetopt_args_info_help[12] = gengetopt_args_info_full_help[12];
  gengetopt_args_info_help[13] = gengetopt_args_info_full_help[13];
  gengetopt_args_info_help[14] = gengetopt_args_info_full_help[14];
  gengetopt_args_info_help[15] = gengetopt_args_info_full_help[15];
  gengetopt_args_info_help[16] = gengetopt_args_info_full_help[16];
  gengetopt_args_info_help[17] = gengetopt_args_info_full_help[17];
  gengetopt_args_info_help[18] = gengetopt_args_info_full_help[18];
  gengetopt_args_info_help[19] = gengetopt_args_info_full_help[19];
  gengetopt_args_info_help[20] = gengetopt_args_info_full_help[20];
  gengetopt_args_info_help[21] = gengetopt_args_info_full_help[21];
  gengetopt_args_info_help[22] = gengetopt_args_info_full_help[22];
  gengetopt_args_info_help[23] = gengetopt_args_info_full_help[23];
  gengetopt_args_info_help[24] = gengetopt_args_info_full_help[24];
  gengetopt_args_info_help[25] = gengetopt_args_info_full_help[25];
  gengetopt_args_info_help[26] = gengetopt_args_info_full_help[26];
  gengetopt_args_info_help[27] = gengetopt_args_info_full_help[27];
  gengetopt_args_info_help[28] = gengetopt_args_info_full_help[28];
  gengetopt_args_info_help[29] = gengetopt_args_info_full_help[29];
  gengetopt_args_info_help[30] = gengetopt_args_info_full_help[30];
  gengetopt_args_info_help[31] = gengetopt_args_info_full_help[31];
  gengetopt_args_info_help[32] = gengetopt_args_info_full_help[32];
  gengetopt_args_info_help[33] = gengetopt_args_info_full_help[35];
  gengetopt_args_info_help[34] = gengetopt_args_info_full_help[36];
  gengetopt_args_info_help[35] = gengetopt_args_info_full_help[37];
  gengetopt_args_info_help[36] = gengetopt_args_info_full_help[38];
  gengetopt_args_info_help[37] = 0; 
  
}

const char *gengetopt_args_info_help[38];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_ENUM
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);
struct line_list
{
  char * string_arg;
  struct line_list * next;
};

static struct line_list *cmd_line_list = 0;
static struct line_list *cmd_line_list_tmp = 0;

static void
free_cmd_list(void)
{
  /* free the list of a previous call */
  if (cmd_line_list)
    {
      while (cmd_line_list) {
        cmd_line_list_tmp = cmd_line_list;
        cmd_line_list = cmd_line_list->next;
        free (cmd_line_list_tmp->string_arg);
        free (cmd_line_list_tmp);
      }
    }
}


const char *cmdline_parser_action_values[] = {"version", "generate", "set-mgm-key", "reset", "pin-retries", "import-key", "import-certificate", "set-chuid", "request-certificate", "verify-pin", "verify-bio", "change-pin", "change-puk", "unblock-pin", "selfsign-certificate", "delete-certificate", "read-certificate", "read-public-key", "status", "test-signature", "test-decipher", "list-readers", "set-ccc", "write-object", "read-object", "attest", "move-key", "delete-key", 0}; /*< Possible values for action. */
const char *cmdline_parser_slot_values[] = {"9a", "9c", "9d", "9e", "82", "83", "84", "85", "86", "87", "88", "89", "8a", "8b", "8c", "8d", "8e", "8f", "90", "91", "92", "93", "94", "95", "f9", 0}; /*< Possible values for slot. */
const char *cmdline_parser_to_slot_values[] = {"9a", "9c", "9d", "9e", "82", "83", "84", "85", "86", "87", "88", "89", "8a", "8b", "8c", "8d", "8e", "8f", "90", "91", "92", "93", "94", "95", "f9", 0}; /*< Possible values for to-slot. */
const char *cmdline_parser_algorithm_values[] = {"RSA1024", "RSA2048", "RSA3072", "RSA4096", "ECCP256", "ECCP384", "ED25519", "X25519", 0}; /*< Possible values for algorithm. */
const char *cmdline_parser_hash_values[] = {"SHA1", "SHA256", "SHA384", "SHA512", 0}; /*< Possible values for hash. */
const char *cmdline_parser_key_format_values[] = {"PEM", "PKCS12", "GZIP", "DER", "SSH", 0}; /*< Possible values for key-format. */
const char *cmdline_parser_pin_policy_values[] = {"never", "once", "always", "matchonce", "matchalways", 0}; /*< Possible values for pin-policy. */
const char *cmdline_parser_touch_policy_values[] = {"never", "always", "cached", 0}; /*< Possible values for touch-policy. */
const char *cmdline_parser_format_values[] = {"hex", "base64", "binary", 0}; /*< Possible values for format. */
const char *cmdline_parser_new_key_algo_values[] = {"TDES", "AES128", "AES192", "AES256", 0}; /*< Possible values for new-key-algo. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->reader_given = 0 ;
  args_info->key_given = 0 ;
  args_info->action_given = 0 ;
  args_info->slot_given = 0 ;
  args_info->to_slot_given = 0 ;
  args_info->algorithm_given = 0 ;
  args_info->hash_given = 0 ;
  args_info->new_key_given = 0 ;
  args_info->pin_retries_given = 0 ;
  args_info->puk_retries_given = 0 ;
  args_info->input_given = 0 ;
  args_info->output_given = 0 ;
  args_info->key_format_given = 0 ;
  args_info->compress_given = 0 ;
  args_info->global_given = 0 ;
  args_info->password_given = 0 ;
  args_info->subject_given = 0 ;
  args_info->serial_given = 0 ;
  args_info->valid_days_given = 0 ;
  args_info->pin_given = 0 ;
  args_info->new_pin_given = 0 ;
  args_info->pin_policy_given = 0 ;
  args_info->touch_policy_given = 0 ;
  args_info->id_given = 0 ;
  args_info->format_given = 0 ;
  args_info->sign_given = 0 ;
  args_info->stdin_input_given = 0 ;
  args_info->attestation_given = 0 ;
  args_info->new_key_algo_given = 0 ;
  args_info->scp11_given = 0 ;
  args_info->enc_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->verbose_arg = 0;
  args_info->verbose_orig = NULL;
  args_info->reader_arg = gengetopt_strdup ("Yubikey");
  args_info->reader_orig = NULL;
  args_info->key_arg = gengetopt_strdup ("010203040506070801020304050607080102030405060708");
  args_info->key_orig = NULL;
  args_info->action_arg = NULL;
  args_info->action_orig = NULL;
  args_info->slot_arg = slot__NULL;
  args_info->slot_orig = NULL;
  args_info->to_slot_arg = to_slot__NULL;
  args_info->to_slot_orig = NULL;
  args_info->algorithm_arg = algorithm_arg_RSA2048;
  args_info->algorithm_orig = NULL;
  args_info->hash_arg = hash_arg_SHA256;
  args_info->hash_orig = NULL;
  args_info->new_key_arg = NULL;
  args_info->new_key_orig = NULL;
  args_info->pin_retries_orig = NULL;
  args_info->puk_retries_orig = NULL;
  args_info->input_arg = gengetopt_strdup ("-");
  args_info->input_orig = NULL;
  args_info->output_arg = gengetopt_strdup ("-");
  args_info->output_orig = NULL;
  args_info->key_format_arg = key_format_arg_PEM;
  args_info->key_format_orig = NULL;
  args_info->compress_flag = 0;
  args_info->global_flag = 0;
  args_info->password_arg = NULL;
  args_info->password_orig = NULL;
  args_info->subject_arg = NULL;
  args_info->subject_orig = NULL;
  args_info->serial_orig = NULL;
  args_info->valid_days_arg = 365;
  args_info->valid_days_orig = NULL;
  args_info->pin_arg = NULL;
  args_info->pin_orig = NULL;
  args_info->new_pin_arg = NULL;
  args_info->new_pin_orig = NULL;
  args_info->pin_policy_arg = pin_policy__NULL;
  args_info->pin_policy_orig = NULL;
  args_info->touch_policy_arg = touch_policy__NULL;
  args_info->touch_policy_orig = NULL;
  args_info->id_orig = NULL;
  args_info->format_arg = format_arg_hex;
  args_info->format_orig = NULL;
  args_info->sign_flag = 0;
  args_info->stdin_input_flag = 0;
  args_info->attestation_flag = 0;
  args_info->new_key_algo_arg = new_key_algo_arg_TDES;
  args_info->new_key_algo_orig = NULL;
  args_info->scp11_flag = 0;
  args_info->enc_flag = 0;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{

  init_help_array(); 
  args_info->help_help = gengetopt_args_info_full_help[0] ;
  args_info->full_help_help = gengetopt_args_info_full_help[1] ;
  args_info->version_help = gengetopt_args_info_full_help[2] ;
  args_info->verbose_help = gengetopt_args_info_full_help[3] ;
  args_info->reader_help = gengetopt_args_info_full_help[4] ;
  args_info->key_help = gengetopt_args_info_full_help[5] ;
  args_info->action_help = gengetopt_args_info_full_help[6] ;
  args_info->action_min = 0;
  args_info->action_max = 0;
  args_info->slot_help = gengetopt_args_info_full_help[8] ;
  args_info->to_slot_help = gengetopt_args_info_full_help[10] ;
  args_info->algorithm_help = gengetopt_args_info_full_help[12] ;
  args_info->hash_help = gengetopt_args_info_full_help[13] ;
  args_info->new_key_help = gengetopt_args_info_full_help[14] ;
  args_info->pin_retries_help = gengetopt_args_info_full_help[15] ;
  args_info->puk_retries_help = gengetopt_args_info_full_help[16] ;
  args_info->input_help = gengetopt_args_info_full_help[17] ;
  args_info->output_help = gengetopt_args_info_full_help[18] ;
  args_info->key_format_help = gengetopt_args_info_full_help[19] ;
  args_info->compress_help = gengetopt_args_info_full_help[20] ;
  args_info->global_help = gengetopt_args_info_full_help[21] ;
  args_info->password_help = gengetopt_args_info_full_help[22] ;
  args_info->subject_help = gengetopt_args_info_full_help[23] ;
  args_info->serial_help = gengetopt_args_info_full_help[25] ;
  args_info->valid_days_help = gengetopt_args_info_full_help[26] ;
  args_info->pin_help = gengetopt_args_info_full_help[27] ;
  args_info->new_pin_help = gengetopt_args_info_full_help[28] ;
  args_info->pin_policy_help = gengetopt_args_info_full_help[29] ;
  args_info->touch_policy_help = gengetopt_args_info_full_help[30] ;
  args_info->id_help = gengetopt_args_info_full_help[31] ;
  args_info->format_help = gengetopt_args_info_full_help[32] ;
  args_info->sign_help = gengetopt_args_info_full_help[33] ;
  args_info->stdin_input_help = gengetopt_args_info_full_help[34] ;
  args_info->attestation_help = gengetopt_args_info_full_help[35] ;
  args_info->new_key_algo_help = gengetopt_args_info_full_help[36] ;
  args_info->scp11_help = gengetopt_args_info_full_help[37] ;
  args_info->enc_help = gengetopt_args_info_full_help[38] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void)
{
	size_t len_purpose = strlen(gengetopt_args_info_purpose);
	size_t len_usage = strlen(gengetopt_args_info_usage);

	if (len_usage > 0) {
		printf("%s\n", gengetopt_args_info_usage);
	}
	if (len_purpose > 0) {
		printf("%s\n", gengetopt_args_info_purpose);
	}

	if (len_usage || len_purpose) {
		printf("\n");
	}

	if (strlen(gengetopt_args_info_description) > 0) {
		printf("%s\n\n", gengetopt_args_info_description);
	}
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_full_help[i])
    printf("%s\n", gengetopt_args_info_full_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    int int_arg;
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}

/**
 * The passed arg parameter is NOT set to 0 from this function
 */
static void
free_multiple_field(unsigned int len, void *arg, char ***orig)
{
  unsigned int i;
  if (arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*orig)[i]));
      }

    free (arg);
    free (*orig);
    *orig = 0;
  }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->verbose_orig));
  free_string_field (&(args_info->reader_arg));
  free_string_field (&(args_info->reader_orig));
  free_string_field (&(args_info->key_arg));
  free_string_field (&(args_info->key_orig));
  free_multiple_field (args_info->action_given, (void *)(args_info->action_arg), &(args_info->action_orig));
  args_info->action_arg = 0;
  free_string_field (&(args_info->slot_orig));
  free_string_field (&(args_info->to_slot_orig));
  free_string_field (&(args_info->algorithm_orig));
  free_string_field (&(args_info->hash_orig));
  free_string_field (&(args_info->new_key_arg));
  free_string_field (&(args_info->new_key_orig));
  free_string_field (&(args_info->pin_retries_orig));
  free_string_field (&(args_info->puk_retries_orig));
  free_string_field (&(args_info->input_arg));
  free_string_field (&(args_info->input_orig));
  free_string_field (&(args_info->output_arg));
  free_string_field (&(args_info->output_orig));
  free_string_field (&(args_info->key_format_orig));
  free_string_field (&(args_info->password_arg));
  free_string_field (&(args_info->password_orig));
  free_string_field (&(args_info->subject_arg));
  free_string_field (&(args_info->subject_orig));
  free_string_field (&(args_info->serial_orig));
  free_string_field (&(args_info->valid_days_orig));
  free_string_field (&(args_info->pin_arg));
  free_string_field (&(args_info->pin_orig));
  free_string_field (&(args_info->new_pin_arg));
  free_string_field (&(args_info->new_pin_orig));
  free_string_field (&(args_info->pin_policy_orig));
  free_string_field (&(args_info->touch_policy_orig));
  free_string_field (&(args_info->id_orig));
  free_string_field (&(args_info->format_orig));
  free_string_field (&(args_info->new_key_algo_orig));
  
  

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", args_info->verbose_orig, 0);
  if (args_info->reader_given)
    write_into_file(outfile, "reader", args_info->reader_orig, 0);
  if (args_info->key_given)
    write_into_file(outfile, "key", args_info->key_orig, 0);
  write_multiple_into_file(outfile, args_info->action_given, "action", args_info->action_orig, cmdline_parser_action_values);
  if (args_info->slot_given)
    write_into_file(outfile, "slot", args_info->slot_orig, cmdline_parser_slot_values);
  if (args_info->to_slot_given)
    write_into_file(outfile, "to-slot", args_info->to_slot_orig, cmdline_parser_to_slot_values);
  if (args_info->algorithm_given)
    write_into_file(outfile, "algorithm", args_info->algorithm_orig, cmdline_parser_algorithm_values);
  if (args_info->hash_given)
    write_into_file(outfile, "hash", args_info->hash_orig, cmdline_parser_hash_values);
  if (args_info->new_key_given)
    write_into_file(outfile, "new-key", args_info->new_key_orig, 0);
  if (args_info->pin_retries_given)
    write_into_file(outfile, "pin-retries", args_info->pin_retries_orig, 0);
  if (args_info->puk_retries_given)
    write_into_file(outfile, "puk-retries", args_info->puk_retries_orig, 0);
  if (args_info->input_given)
    write_into_file(outfile, "input", args_info->input_orig, 0);
  if (args_info->output_given)
    write_into_file(outfile, "output", args_info->output_orig, 0);
  if (args_info->key_format_given)
    write_into_file(outfile, "key-format", args_info->key_format_orig, cmdline_parser_key_format_values);
  if (args_info->compress_given)
    write_into_file(outfile, "compress", 0, 0 );
  if (args_info->global_given)
    write_into_file(outfile, "global", 0, 0 );
  if (args_info->password_given)
    write_into_file(outfile, "password", args_info->password_orig, 0);
  if (args_info->subject_given)
    write_into_file(outfile, "subject", args_info->subject_orig, 0);
  if (args_info->serial_given)
    write_into_file(outfile, "serial", args_info->serial_orig, 0);
  if (args_info->valid_days_given)
    write_into_file(outfile, "valid-days", args_info->valid_days_orig, 0);
  if (args_info->pin_given)
    write_into_file(outfile, "pin", args_info->pin_orig, 0);
  if (args_info->new_pin_given)
    write_into_file(outfile, "new-pin", args_info->new_pin_orig, 0);
  if (args_info->pin_policy_given)
    write_into_file(outfile, "pin-policy", args_info->pin_policy_orig, cmdline_parser_pin_policy_values);
  if (args_info->touch_policy_given)
    write_into_file(outfile, "touch-policy", args_info->touch_policy_orig, cmdline_parser_touch_policy_values);
  if (args_info->id_given)
    write_into_file(outfile, "id", args_info->id_orig, 0);
  if (args_info->format_given)
    write_into_file(outfile, "format", args_info->format_orig, cmdline_parser_format_values);
  if (args_info->sign_given)
    write_into_file(outfile, "sign", 0, 0 );
  if (args_info->stdin_input_given)
    write_into_file(outfile, "stdin-input", 0, 0 );
  if (args_info->attestation_given)
    write_into_file(outfile, "attestation", 0, 0 );
  if (args_info->new_key_algo_given)
    write_into_file(outfile, "new-key-algo", args_info->new_key_algo_orig, cmdline_parser_new_key_algo_values);
  if (args_info->scp11_given)
    write_into_file(outfile, "scp11", 0, 0 );
  if (args_info->enc_given)
    write_into_file(outfile, "enc", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error_occurred = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error_occurred = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error_occurred = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error_occurred = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error_occurred = 1;
            }
        }
    }
    
  return error_occurred;
}
int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (! args_info->action_given)
    {
      fprintf (stderr, "%s: '--action' ('-a') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  
  if (check_multiple_option_occurrences(prog_name, args_info->action_given, args_info->action_min, args_info->action_max, "'--action' ('-a')"))
     error_occurred = 1;
  
  
  /* checks for dependences among options */
  if (args_info->pin_retries_given && ! args_info->puk_retries_given)
    {
      fprintf (stderr, "%s: '--pin-retries' option depends on option 'puk-retries'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->puk_retries_given && ! args_info->pin_retries_given)
    {
      fprintf (stderr, "%s: '--puk-retries' option depends on option 'pin-retries'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->new_pin_given && ! args_info->pin_given)
    {
      fprintf (stderr, "%s: '--new-pin' ('-N') option depends on option 'pin'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }

  return error_occurred;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_ENUM:
    if (val) *((int *)field) = found;
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               cmdline_parser_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               cmdline_parser_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_INT:
    case ARG_ENUM:
      *((int **)field) = (int *)realloc (*((int **)field), (field_given + prev_given) * sizeof (int)); break;
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_INT:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_ENUM:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_INT:
      case ARG_ENUM:
        if (! *((int **)field)) {
          *((int **)field) = (int *)malloc (sizeof (int));
          (*((int **)field))[0] = default_value->int_arg; 
        }
        break;
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  struct generic_list * action_list = NULL;
  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  /* TODO: Why is this here? It is not used anywhere. */
  override = params->override;
  FIX_UNUSED(override);

  initialize = params->initialize;
  check_required = params->check_required;

  /* TODO: Why is this here? It is not used anywhere. */
  check_ambiguity = params->check_ambiguity;
  FIX_UNUSED(check_ambiguity);

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "verbose",	2, NULL, 'v' },
        { "reader",	1, NULL, 'r' },
        { "key",	2, NULL, 'k' },
        { "action",	1, NULL, 'a' },
        { "slot",	1, NULL, 's' },
        { "to-slot",	1, NULL, 0 },
        { "algorithm",	1, NULL, 'A' },
        { "hash",	1, NULL, 'H' },
        { "new-key",	1, NULL, 'n' },
        { "pin-retries",	1, NULL, 0 },
        { "puk-retries",	1, NULL, 0 },
        { "input",	1, NULL, 'i' },
        { "output",	1, NULL, 'o' },
        { "key-format",	1, NULL, 'K' },
        { "compress",	0, NULL, 0 },
        { "global",	0, NULL, 0 },
        { "password",	1, NULL, 'p' },
        { "subject",	1, NULL, 'S' },
        { "serial",	1, NULL, 0 },
        { "valid-days",	1, NULL, 0 },
        { "pin",	1, NULL, 'P' },
        { "new-pin",	1, NULL, 'N' },
        { "pin-policy",	1, NULL, 0 },
        { "touch-policy",	1, NULL, 0 },
        { "id",	1, NULL, 0 },
        { "format",	1, NULL, 'f' },
        { "sign",	0, NULL, 0 },
        { "stdin-input",	0, NULL, 0 },
        { "attestation",	0, NULL, 0 },
        { "new-key-algo",	1, NULL, 'm' },
        { "scp11",	0, NULL, 0 },
        { "enc",	0, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVv::r:k::a:s:A:H:n:i:o:K:p:S:P:N:f:m:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'v':	/* Print more information.  */
        
        
          if (update_arg( (void *)&(args_info->verbose_arg), 
               &(args_info->verbose_orig), &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, "0", ARG_INT,
              check_ambiguity, override, 0, 0,
              "verbose", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'r':	/* Only use a matching reader.  */
        
        
          if (update_arg( (void *)&(args_info->reader_arg), 
               &(args_info->reader_orig), &(args_info->reader_given),
              &(local_args_info.reader_given), optarg, 0, "Yubikey", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "reader", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'k':	/* Management key to use, if no value is specified key will be asked for.  */
        
        
          if (update_arg( (void *)&(args_info->key_arg), 
               &(args_info->key_orig), &(args_info->key_given),
              &(local_args_info.key_given), optarg, 0, "010203040506070801020304050607080102030405060708", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "key", 'k',
              additional_error))
            goto failure;
        
          break;
        case 'a':	/* Action to take.  */
        
          if (update_multiple_arg_temp(&action_list, 
              &(local_args_info.action_given), optarg, cmdline_parser_action_values, 0, ARG_ENUM,
              "action", 'a',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* What key slot to operate on.  */
        
        
          if (update_arg( (void *)&(args_info->slot_arg), 
               &(args_info->slot_orig), &(args_info->slot_given),
              &(local_args_info.slot_given), optarg, cmdline_parser_slot_values, 0, ARG_ENUM,
              check_ambiguity, override, 0, 0,
              "slot", 's',
              additional_error))
            goto failure;
        
          break;
        case 'A':	/* What algorithm to use.  */
        
        
          if (update_arg( (void *)&(args_info->algorithm_arg), 
               &(args_info->algorithm_orig), &(args_info->algorithm_given),
              &(local_args_info.algorithm_given), optarg, cmdline_parser_algorithm_values, "RSA2048", ARG_ENUM,
              check_ambiguity, override, 0, 0,
              "algorithm", 'A',
              additional_error))
            goto failure;
        
          break;
        case 'H':	/* Hash to use for signatures.  */
        
        
          if (update_arg( (void *)&(args_info->hash_arg), 
               &(args_info->hash_orig), &(args_info->hash_given),
              &(local_args_info.hash_given), optarg, cmdline_parser_hash_values, "SHA256", ARG_ENUM,
              check_ambiguity, override, 0, 0,
              "hash", 'H',
              additional_error))
            goto failure;
        
          break;
        case 'n':	/* New management key to use for action set-mgm-key, if omitted key will be asked for.  */
        
        
          if (update_arg( (void *)&(args_info->new_key_arg), 
               &(args_info->new_key_orig), &(args_info->new_key_given),
              &(local_args_info.new_key_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "new-key", 'n',
              additional_error))
            goto failure;
        
          break;
        case 'i':	/* Filename to use as input, - for stdin.  */
        
        
          if (update_arg( (void *)&(args_info->input_arg), 
               &(args_info->input_orig), &(args_info->input_given),
              &(local_args_info.input_given), optarg, 0, "-", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "input", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* Filename to use as output, - for stdout.  */
        
        
          if (update_arg( (void *)&(args_info->output_arg), 
               &(args_info->output_orig), &(args_info->output_given),
              &(local_args_info.output_given), optarg, 0, "-", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output", 'o',
              additional_error))
            goto failure;
        
          break;
        case 'K':	/* Format of the key being read/written.  */
        
        
          if (update_arg( (void *)&(args_info->key_format_arg), 
               &(args_info->key_format_orig), &(args_info->key_format_given),
              &(local_args_info.key_format_given), optarg, cmdline_parser_key_format_values, "PEM", ARG_ENUM,
              check_ambiguity, override, 0, 0,
              "key-format", 'K',
              additional_error))
            goto failure;
        
          break;
        case 'p':	/* Password for decryption of private key file, if omitted password will be asked for.  */
        
        
          if (update_arg( (void *)&(args_info->password_arg), 
               &(args_info->password_orig), &(args_info->password_given),
              &(local_args_info.password_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "password", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* The subject to use for certificate request.  */
        
        
          if (update_arg( (void *)&(args_info->subject_arg), 
               &(args_info->subject_orig), &(args_info->subject_given),
              &(local_args_info.subject_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "subject", 'S',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* Pin/puk code for verification, if omitted pin/puk will be asked for.  */
        
        
          if (update_arg( (void *)&(args_info->pin_arg), 
               &(args_info->pin_orig), &(args_info->pin_given),
              &(local_args_info.pin_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "pin", 'P',
              additional_error))
            goto failure;
        
          break;
        case 'N':	/* New pin/puk code for changing, if omitted pin/puk will be asked for.  */
        
        
          if (update_arg( (void *)&(args_info->new_pin_arg), 
               &(args_info->new_pin_orig), &(args_info->new_pin_given),
              &(local_args_info.new_pin_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "new-pin", 'N',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* Format of data for write/read object.  */
        
        
          if (update_arg( (void *)&(args_info->format_arg), 
               &(args_info->format_orig), &(args_info->format_given),
              &(local_args_info.format_given), optarg, cmdline_parser_format_values, "hex", ARG_ENUM,
              check_ambiguity, override, 0, 0,
              "format", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'm':	/* New management key algorithm to use for action set-mgm-key.  */
        
        
          if (update_arg( (void *)&(args_info->new_key_algo_arg), 
               &(args_info->new_key_algo_orig), &(args_info->new_key_algo_given),
              &(local_args_info.new_key_algo_given), optarg, cmdline_parser_new_key_algo_values, "TDES", ARG_ENUM,
              check_ambiguity, override, 0, 0,
              "new-key-algo", 'm',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            cmdline_parser_print_full_help ();
            cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          /* What slot to move an existing key to.  */
          if (strcmp (long_options[option_index].name, "to-slot") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->to_slot_arg), 
                 &(args_info->to_slot_orig), &(args_info->to_slot_given),
                &(local_args_info.to_slot_given), optarg, cmdline_parser_to_slot_values, 0, ARG_ENUM,
                check_ambiguity, override, 0, 0,
                "to-slot", '-',
                additional_error))
              goto failure;
          
          }
          /* Number of retries before the pin code is blocked.  */
          else if (strcmp (long_options[option_index].name, "pin-retries") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->pin_retries_arg), 
                 &(args_info->pin_retries_orig), &(args_info->pin_retries_given),
                &(local_args_info.pin_retries_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "pin-retries", '-',
                additional_error))
              goto failure;
          
          }
          /* Number of retries before the puk code is blocked.  */
          else if (strcmp (long_options[option_index].name, "puk-retries") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->puk_retries_arg), 
                 &(args_info->puk_retries_orig), &(args_info->puk_retries_given),
                &(local_args_info.puk_retries_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "puk-retries", '-',
                additional_error))
              goto failure;
          
          }
          /* Compress a large certificate using GZIP before import.  */
          else if (strcmp (long_options[option_index].name, "compress") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->compress_flag), 0, &(args_info->compress_given),
                &(local_args_info.compress_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "compress", '-',
                additional_error))
              goto failure;
          
          }
          /* Reset the whole device over all applications.  */
          else if (strcmp (long_options[option_index].name, "global") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->global_flag), 0, &(args_info->global_given),
                &(local_args_info.global_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "global", '-',
                additional_error))
              goto failure;
          
          }
          /* Serial number of the self-signed certificate.  */
          else if (strcmp (long_options[option_index].name, "serial") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->serial_arg), 
                 &(args_info->serial_orig), &(args_info->serial_given),
                &(local_args_info.serial_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "serial", '-',
                additional_error))
              goto failure;
          
          }
          /* Time (in days) until the self-signed certificate expires.  */
          else if (strcmp (long_options[option_index].name, "valid-days") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->valid_days_arg), 
                 &(args_info->valid_days_orig), &(args_info->valid_days_given),
                &(local_args_info.valid_days_given), optarg, 0, "365", ARG_INT,
                check_ambiguity, override, 0, 0,
                "valid-days", '-',
                additional_error))
              goto failure;
          
          }
          /* Set pin policy for action generate or import-key. Only available on YubiKey 4 or newer.  */
          else if (strcmp (long_options[option_index].name, "pin-policy") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->pin_policy_arg), 
                 &(args_info->pin_policy_orig), &(args_info->pin_policy_given),
                &(local_args_info.pin_policy_given), optarg, cmdline_parser_pin_policy_values, 0, ARG_ENUM,
                check_ambiguity, override, 0, 0,
                "pin-policy", '-',
                additional_error))
              goto failure;
          
          }
          /* Set touch policy for action generate, import-key or set-mgm-key. Only available on YubiKey 4 or newer.  */
          else if (strcmp (long_options[option_index].name, "touch-policy") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->touch_policy_arg), 
                 &(args_info->touch_policy_orig), &(args_info->touch_policy_given),
                &(local_args_info.touch_policy_given), optarg, cmdline_parser_touch_policy_values, 0, ARG_ENUM,
                check_ambiguity, override, 0, 0,
                "touch-policy", '-',
                additional_error))
              goto failure;
          
          }
          /* Id of object for write/read object.  */
          else if (strcmp (long_options[option_index].name, "id") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_arg), 
                 &(args_info->id_orig), &(args_info->id_given),
                &(local_args_info.id_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "id", '-',
                additional_error))
              goto failure;
          
          }
          /* Sign data.  */
          else if (strcmp (long_options[option_index].name, "sign") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->sign_flag), 0, &(args_info->sign_given),
                &(local_args_info.sign_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "sign", '-',
                additional_error))
              goto failure;
          
          }
          /* Read sensitive values from stdin.  */
          else if (strcmp (long_options[option_index].name, "stdin-input") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->stdin_input_flag), 0, &(args_info->stdin_input_given),
                &(local_args_info.stdin_input_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "stdin-input", '-',
                additional_error))
              goto failure;
          
          }
          /* Add attestation cross-signature.  */
          else if (strcmp (long_options[option_index].name, "attestation") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->attestation_flag), 0, &(args_info->attestation_given),
                &(local_args_info.attestation_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "attestation", '-',
                additional_error))
              goto failure;
          
          }
          /* Communication with the YubiKey is done over an encrypted channel. DEPRECATED! Please use the '--enc' flag instead.  */
          else if (strcmp (long_options[option_index].name, "scp11") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->scp11_flag), 0, &(args_info->scp11_given),
                &(local_args_info.scp11_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "scp11", '-',
                additional_error))
              goto failure;
          
          }
          /* Communication with the YubiKey is done over an encrypted channel.  */
          else if (strcmp (long_options[option_index].name, "enc") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->enc_flag), 0, &(args_info->enc_given),
                &(local_args_info.enc_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "enc", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  update_multiple_arg((void *)&(args_info->action_arg),
    &(args_info->action_orig), args_info->action_given,
    local_args_info.action_given, 0,
    ARG_ENUM, action_list);

  args_info->action_given += local_args_info.action_given;
  local_args_info.action_given = 0;
  
  if (check_required)
    {
      error_occurred += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:
  free_list (action_list, 0 );
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}

#ifndef CONFIG_FILE_LINE_SIZE
#define CONFIG_FILE_LINE_SIZE 2048
#endif
#define ADDITIONAL_ERROR " in configuration file "

#define CONFIG_FILE_LINE_BUFFER_SIZE (CONFIG_FILE_LINE_SIZE+3)
/* 3 is for "--" and "=" */

static int
_cmdline_parser_configfile (const char *filename, int *my_argc)
{
  FILE* file;
  char my_argv[CONFIG_FILE_LINE_BUFFER_SIZE+1];
  char linebuf[CONFIG_FILE_LINE_SIZE];
  int line_num = 0;
  int result = 0, equal;
  char *fopt, *farg;
  char *str_index;
  size_t len, next_token;
  char delimiter;

  if ((file = fopen(filename, "r")) == 0)
    {
      fprintf (stderr, "%s: Error opening configuration file '%s'\n",
               CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  while ((fgets(linebuf, CONFIG_FILE_LINE_SIZE, file)) != 0)
    {
      ++line_num;
      my_argv[0] = '\0';
      len = strlen(linebuf);
      if (len > (CONFIG_FILE_LINE_BUFFER_SIZE-1))
        {
          fprintf (stderr, "%s:%s:%d: Line too long in configuration file\n",
                   CMDLINE_PARSER_PACKAGE, filename, line_num);
          result = EXIT_FAILURE;
          break;
        }

      /* find first non-whitespace character in the line */
      next_token = strspn (linebuf, " \t\r\n");
      str_index  = linebuf + next_token;

      if ( str_index[0] == '\0' || str_index[0] == '#')
        continue; /* empty line or comment line is skipped */

      fopt = str_index;

      /* truncate fopt at the end of the first non-valid character */
      next_token = strcspn (fopt, " \t\r\n=");

      if (fopt[next_token] == '\0') /* the line is over */
        {
          farg  = 0;
          equal = 0;
          goto noarg;
        }

      /* remember if equal sign is present */
      equal = (fopt[next_token] == '=');
      fopt[next_token++] = '\0';

      /* advance pointers to the next token after the end of fopt */
      next_token += strspn (fopt + next_token, " \t\r\n");

      /* check for the presence of equal sign, and if so, skip it */
      if ( !equal )
        if ((equal = (fopt[next_token] == '=')))
          {
            next_token++;
            next_token += strspn (fopt + next_token, " \t\r\n");
          }
      str_index  += next_token;

      /* find argument */
      farg = str_index;
      if ( farg[0] == '\"' || farg[0] == '\'' )
        { /* quoted argument */
          str_index = strchr (++farg, str_index[0] ); /* skip opening quote */
          if (! str_index)
            {
              fprintf
                (stderr,
                 "%s:%s:%d: unterminated string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              break;
            }
        }
      else
        { /* read up the remaining part up to a delimiter */
          next_token = strcspn (farg, " \t\r\n#\'\"");
          str_index += next_token;
        }

      /* truncate farg at the delimiter and store it for further check */
      delimiter = *str_index, *str_index++ = '\0';

      /* everything but comment is illegal at the end of line */
      if (delimiter != '\0' && delimiter != '#')
        {
          str_index += strspn(str_index, " \t\r\n");
          if (*str_index != '\0' && *str_index != '#')
            {
              fprintf
                (stderr,
                 "%s:%s:%d: malformed string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              break;
            }
        }

    noarg:
      if (!strcmp(fopt,"include")) {
        if (farg && *farg) {
          result = _cmdline_parser_configfile(farg, my_argc);
        } else {
          fprintf(stderr, "%s:%s:%d: include requires a filename argument.\n",
                  CMDLINE_PARSER_PACKAGE, filename, line_num);
        }
        continue;
      }
      len = strlen(fopt);
      strcat (my_argv, len > 1 ? "--" : "-");
      strcat (my_argv, fopt);
      if (len > 1 && ((farg && *farg) || equal))
        strcat (my_argv, "=");
      if (farg && *farg)
        strcat (my_argv, farg);
      ++(*my_argc);

      cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
      cmd_line_list_tmp->next = cmd_line_list;
      cmd_line_list = cmd_line_list_tmp;
      cmd_line_list->string_arg = gengetopt_strdup(my_argv);
    } /* while */

  if (file)
    fclose(file);
  return result;
}

int
cmdline_parser_configfile (
  const char *filename,
                           struct gengetopt_args_info *args_info,
                           int override, int initialize, int check_required)
{
  struct cmdline_parser_params params;

  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;
  
  return cmdline_parser_config_file (filename, args_info, &params);
}

int
cmdline_parser_config_file (const char *filename,
                           struct gengetopt_args_info *args_info,
                           struct cmdline_parser_params *params)
{
  int i, result;
  int my_argc = 1;
  char **my_argv_arg;
  char *additional_error;

  /* store the program name */
  cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
  cmd_line_list_tmp->next = cmd_line_list;
  cmd_line_list = cmd_line_list_tmp;
  cmd_line_list->string_arg = gengetopt_strdup (CMDLINE_PARSER_PACKAGE);

  result = _cmdline_parser_configfile(filename, &my_argc);

  if (result != EXIT_FAILURE) {
    my_argv_arg = (char **) malloc((my_argc+1) * sizeof(char *));
    cmd_line_list_tmp = cmd_line_list;

    for (i = my_argc - 1; i >= 0; --i) {
      my_argv_arg[i] = cmd_line_list_tmp->string_arg;
      cmd_line_list_tmp = cmd_line_list_tmp->next;
    }

    my_argv_arg[my_argc] = 0;

    additional_error = (char *)malloc(strlen(filename) + strlen(ADDITIONAL_ERROR) + 1);
    strcpy (additional_error, ADDITIONAL_ERROR);
    strcat (additional_error, filename);
    result =
      cmdline_parser_internal (my_argc, my_argv_arg, args_info,
                              params,
                              additional_error);

    free (additional_error);
    free (my_argv_arg);
  }

  free_cmd_list();
  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}
/* vim: set ft=c noet ts=8 sts=8 sw=8 tw=80 nojs spell : */
