package imap

import (
	"fmt"
)

type MailboxDeleted struct {
	updateBase

	*updateWaiter

	MailboxID MailboxID
}

func NewMailboxDeleted(mailboxID MailboxID) *MailboxDeleted {
	return &MailboxDeleted{
		updateWaiter: newUpdateWaiter(),
		MailboxID:    mailboxID,
	}
}

func (u *MailboxDeleted) String() string {
	return fmt.Sprintf("MailboxDeleted: MailboxID = %v", u.MailboxID.ShortID())
}

type MailboxDeletedSilent struct {
	updateBase

	*updateWaiter

	MailboxID MailboxID
}

func NewMailboxDeletedSilent(mailboxID MailboxID) *MailboxDeletedSilent {
	return &MailboxDeletedSilent{
		updateWaiter: newUpdateWaiter(),
		MailboxID:    mailboxID,
	}
}

func (u *MailboxDeletedSilent) String() string {
	return fmt.Sprintf("MailboxDeletedSilent: MailboxID = %v", u.MailboxID.ShortID())
}
