


getdate(8)					       getdate(8)


NNAAMMEE
       getdate - Get remote RFC 868 date - adjust local time.

SSYYNNOOPPSSIISS
       ggeettddaattee _h_o_s_t [ _h_o_s_t_._._.  ]
       ggeettddaattee --aaddjjuusstt _m_a_x_i_n_t_e_r_v_a_l _m_a_x_c_h_a_n_g_e _h_o_s_t [ _h_o_s_t_._._.  ]
       ggeettddaattee --sseett _m_a_x_i_n_t_e_r_v_a_l _m_a_x_c_h_a_n_g_e _h_o_s_t [ _h_o_s_t_._._.  ]


DDEESSCCRRIIPPTTIIOONN
       GGeettddaattee retrieves the current time from a remote host with
       an RFC 868 compliant time  server.   Almost  any	 of  your
       favorite	 Internet hosts (for FTP etc) will provide such a
       service.

       When used to query the time, getdate reports the	 time  on
       each  host  to  the stdout, along with the difference from
       local time in seconds.

       When used to set the time, getdate tries a list	of  hosts
       until  one  query succeeds or until the list is exhausted.
       Getdate can use adjtime() to change the	time  safely,  or
       stime() to change it immediately.


   OOPPTTIIOONNSS
       --aaddjjuusstt _m_a_x_i_n_t_e_r_v_a_l _m_a_x_c_h_a_n_g_e

	      The  adjust  option  instructs  getdate to call the
	      UNIX adjtime() function.	After getdate has  called
	      adjtime(),  the UNIX kernal will do the rest of the
	      work - the kernal will slowly  creep  the	 time  to
	      apply  the adjustment.  This avoids upsetting cron,
	      or any other time sensitive  operations  (including
	      things like X server input waits).


       --sseett _m_a_x_i_n_t_e_r_v_a_l _m_a_x_c_h_a_n_g_e

	      The  adjust  option  instructs  getdate to call the
	      UNIX stime() function to immediately set	the  time
	      to  match the new time.  Time should be a monotoni-
	      cally increasing function.  Setting it backward  or
	      forward in large leaps should be avoided.	 Cron and
	      other sub-systems relying on the	time  may  become
	      quite upset if you do this to them.  Backward move-
	      ment can be particularly dangerous (especially to X
	      servers).


MMOODDIIFFYYIINNGG TTIIMMEE
       In  order to set the date getdate obtains two samples from
       each host.  It then allows for traveling	 time  by  adding
       half  the  interval  between  the  pairs of samples to the



MH			     getdate				1





getdate(8)					       getdate(8)


       second sample, which then becomes the new time.	_M_a_x_i_n_t_e_r_-
       _v_a_l  and _m_a_x_c_h_a_n_g_e define the quality of the time and mag-
       nitude of the change that you are willing to accept.  They
       are both expressed in seconds.

       Getdate	will  reject  a	 remote	 host's value if the time
       between samples exceeds _m_a_x_i_n_t_e_r_v_u_l seconds.  Getdate will
       also  reject  a remote host's value if its difference from
       local time exceeds _m_a_x_c_h_a_n_g_e seconds.  Both  these  limits
       are  designed  to  make	it safer to run getdate as a cron
       job.   The  first  limit	 prevents  excessive  network  or
       response	 delays from causing mayhem with the time on your
       own host.  The second limit  prevents  any  large  changes
       propagating to your host (major adjustments should only be
       done when the machine is in single user mode or some other
       safe state).


EEXXAAMMPPLLEESS
       To query the date at a series of hosts

	      % getdate tsx-11.mit.edu sunsite.unc.edu sputnik3
	      tsx-11.mit.edu: (+50) Mon Oct 23 15:32:19 1995
	      sunsite.unc.edu: (-2) Mon Oct 23 15:31:30 1995
	      getdate: error - sputnik3 - read error Connection refused

       To  adjust  the local date to a remote date with a maximum
       interval between samples	 of  one  second  and  a  maximum
       change of sixty seconds

	      % getdate -adjust 1 60 tsx-11.mit.edu actrix.gen.nz
	      getdate: tsx-11.mit.edu Mon Oct 23 15:31:16 1995, Mon Oct 23 15:31:18 1995
	      getdate: info - tsx-11.mit.edu second sample took more than 1 second(s), time not set.
	      getdate: actrix.gen.nz  Mon Oct 23 15:31:18 1995, Mon Oct 23 15:31:19 1995
	      getdate: replaced existing adjustment of 5 second(s), 0 usec(s).
	      getdate: time will adjust slowly by 2 second(s) to match actrix.gen.nz.

       To  immediately set the local date to a remote date with a
       maximum interval between samples of 1 seconds and a  maxi-
       mum change of 120 seconds

	      % getdate -set 1 120 sputnik3
	      getdate: sputnik3 Mon Oct 23 15:30:29 1995, Mon Oct 23 15:30:32 1995
	      getdate: set time to Mon Oct 23 15:30:32 1995 to match host sputnik3

       You  can	 set up a cron job to adjust your date.	 The fol-
       lowing job script tests to see if ppp is	 up  and  adjusts
       the  date  if  it  is, the system clock is also updated to
       take on the results of any existing adjustments.

	      #!/bin/sh
	      if (ifconfig | grep 'ppp0') ; then
		      /usr/local/bin/getdate -adjust 2 120 comp.vuw.ac.nz actrix.gen.nz
		      /sbin/clock -w



MH			     getdate				2





getdate(8)					       getdate(8)


	      fi


BBUUGGSS AANNDD LLIIMMIITTAATTIIOONNSS
       This code is definitly not safe from buffer overruns -  it
       is not suid safe.

       Please send any bug reports to michael@actrix.gen.nz.


AAUUTTHHOORR
       Michael Hamilton (michael@actrix.gen.nz)


AACCKKNNOOWWLLEEDDGGEEMMEENNTTSS
       Based  on  rdate	 by Andy Tefft (teffta@crypt.erie.ge.com)
       which was based on rdate by Lee	Moore  at  University  of
       Rochester.  Thanks are due to d-seaman@ukans.edu, Mitchell
       B.   Hamm,    (hamm@one.net)    Marty	Leisner	   (leis-
       ner@sdsp.mc.xerox.com), and Manuel Mollar Villanueva (mol-
       lar@moon.inf.uji.es) for suggestions and patches.


CCOOPPYYRRIIGGHHTT
       Copyright (C) 1995 Michael Hamilton.

       Getdate is free software; you can redistribute  it  and/or
       modify  it  under  the  terms  of  the  GNU General Public
       License as published  by	 the  Free  Software  Foundation;
       either version 2, or (at your option) any later version.



























MH			     getdate				3


