/* port.c
   $Id: port.c,v 1.3 2001/02/04 15:58:44 gwiley Exp $
	Glen Wiley, gwiley@ieee.org

	this file defines some functions that may be needed if the target
	platform does not provide them - this is meant to be used in
	conjunction with the GNU configure/build utilities

	Copyright (c)1999,2000,2001 Glen Wiley
	
	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files (the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sub-license, and/or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions:
	
	The above copyright notice and this permission notice shall be included in
	all copies or substantial portions of the Software.
	
	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
	THE SOFTWARE.

*/

#if HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdlib.h>
#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

/*---------------------------------------- strdup
  allocate storage for and copy src into the returned pointer */
#ifndef HAVE_STRDUP
char *strdup(char *src)
{
	char *cpy;

	cpy = (char *) malloc(strlen(src) + 1);
	strcpy(cpy, src);

	return cpy;
} /* strdup */
#endif
	
/*---------------------------------------- strerror
  this is not a real replacement for the "std" strerror, we just build 
  an error string that looks like "errno=%d"
*/
#ifndef HAVE_STRERROR
char *strerror(int e)
{
	static char str[20];

	sprintf(str, "errno=%d", e);

	return str;
} /* strerror */
#endif
	
/* port.c */
